clear *
set mem 600m
set more off
cap log close
log using logs\summarystats.log, replace
use individual_data, clear
keep if sample==1

* Player Statistics
order fouls_rate points_rate
tabstat min fouls points fouls_rate points_rate ftm_rate ftmiss_rate fg2m_rate fg2miss_rate fg3m_rate fg3miss_rate rbo_rate rbd_rate assists_rate steals_rate blocks_rate turnover_rate  [aw=min] if sample, by(blackplayer) statistics(mean sd) nototal longstub columns(statistics) noseparator labelwidth(32) format(%9.2f)

* Game information
tabstat attend televised out_cont coach_black [aw=min] if sample, by(blackplayer) statistics(mean sd) nototal longstub columns(statistics) noseparator labelwidth(32) format(%9.2f)
* Player characteristics
tabstat age exp all_star center forward guard starter height weight foreign [aw=min] if sample, by(blackplayer) statistics(mean sd) nototal longstub columns(statistics) noseparator labelwidth(32) format(%9.2f)
*Distribution of white referees
tabstat ref_* white [aw=min] if sample, by(blackplayer) statistics(mean sd) nototal longstub columns(statistics) noseparator labelwidth(32) format(%9.2f)

* Sample sizes
gen one=1
egen playertag=tag(pid)
tab black if playertag
tab one if playertag
egen blacks=sum(black), by(gameid)
egen whites=sum(1-black), by(gameid)
egen gametag=tag(gameid)
tab one if blacks>0 & gametag
tab one if whites>0 & gametag
tab one if gametag
table black, c(n min sum min)


* Differences column
qui {
for var min fouls points fouls_rate points_rate ftm_rate ftmiss_rate fg2m_rate fg2miss_rate fg3m_rate fg3miss_rate rbo_rate rbd_rate assists_rate steals_rate blocks_rate turnover_rate  :  reg X black if sample==1 [aw=min] \ gen X_diff=_b[black] \ gen X_p=2*(ttail(e(df_r),abs(_b[black]/_se[black])))
for var attend televised: reg X black if sample==1 [aw=min], cluster(gameid) \ gen X_diff=_b[black] \ gen X_p=2*(ttail(e(df_r),abs(_b[black]/_se[black]))) 
for var out_cont coach_black : reg X black if sample==1 [aw=min], cluster(teamgame) \ gen X_diff=_b[black] \ gen X_p=2*(ttail(e(df_r),abs(_b[black]/_se[black])))
for var age exp all_star : reg X black if sample==1 [aw=min], cluster(playeryear) \ gen X_diff=_b[black] \ gen X_p=2*(ttail(e(df_r),abs(_b[black]/_se[black])))
for var center forward guard : reg X black if sample==1 [aw=min], cluster(pid) \ gen X_diff=_b[black] \ gen X_p=2*(ttail(e(df_r),abs(_b[black]/_se[black])))
for var starter : reg X black if sample==1 [aw=min] \ gen X_diff=_b[black] \ gen X_p=2*(ttail(e(df_r),abs(_b[black]/_se[black])))
for var height weight foreign : reg X black if sample==1 [aw=min], cluster(pid) \ gen X_diff=_b[black] \ gen X_p=2*(ttail(e(df_r),abs(_b[black]/_se[black])))
for var ref_* white  : reg X black if sample==1 [aw=min], cluster(gameid) \ gen X_diff=_b[black] \ gen X_p=2*(ttail(e(df_r),abs(_b[black]/_se[black])))
}

tabstat *_diff, columns(statistics) format(%9.2f) longstub labelwidth(32)
for ! in var *_p: gen !stars=(!<.1)+(!<.05)+(!<.01)
tabstat *_p, columns(statistics) format(%9.2f) longstub labelwidth(32) // p-values
tabstat *_pstars, columns(statistics) format(%4.0f) longstub labelwidth(32) //stars on diffs

* Mentions in text
table black [w=min] if sample==1, c(m min m fouls m fouls_rate)
table black if sample==1, c(m min)
reg fouls_rate black [aw=min], robust
reg fouls_rate black $player_controls $playergame_controls [aw=min], robust
