clear *
global depvars "fouls_rate"
global wts     "min"

cap log close
cap log using logs\Table4.log, replace

set more off
set mem 800m
cap set mem 16000m
cap set matsize 7000
set maxvar 10000
 
* Table 4
use individual_data if sample==1 & min>0, clear

gen mean=1
xi i.year, prefix(yrs) noomit
reg mean mean
outreg mean using "Results\Table4", replace ctitle("Ignore")


* Summary stats
for X in varlist $depvars \ Y in varlist $wts:  ///
	display("Analyzing X using weights Y") \ ///
	reg X mean [aw=Y], nocons \ ///
	summ X [aw=Y] \ ///
	outreg mean using "Results\Table4", se coefastr 3aster ctitle("X:Mean") addstat(Mean, r(mean), SD, r(sd), n, r(N)) append

* Add player, playergame, teamgame controls, plus year, player and referee fixed effects
xi i.player, prefix(pl_) noomit
for X in varlist $depvars \ Y in varlist $wts:  ///
	display("Analyzing X using weights Y") \ ///
	reg X bl_fw /* black fracwhite $player_controls */ $playergame_controls $teamgame_controls yrs* rid* pl_* [aw=Y] , beta \ ///
	outreg bl_fw  $playergame_controls $teamgame_controls using "Results\Table4", se  coefastr nocons ctitle("X:Simple")  3aster append \ ///
	testparm $playergame_controls $teamgame_controls \ testparm pl_* \ testparm rid* \ testparm yrs* 

* Add career stats and interaction effects
for X in varlist $depvars \ Y in varlist $wts: ///
	display("Analyzing X using weights Y") \ ///
	reg X bl_fw /* black fracwhite $player_controls $career_stats */ $playergame_controls $teamgame_controls yrs* rid* pl_*  xn_* [aw=Y] , beta \ ///
	testparm xn_* \ ///
	outreg bl_fw  $playergame_controls $teamgame_controls xn_* using "Results\Table4", se  coefastr nocons ctitle("X:xns") addstat(Ftest: Joint xn's, r(F), Prob>f, r(p)) 3aster append \ ///
	testparm $playergame_controls $teamgame_controls  \ testparm $playergame_controls \ testparm $teamgame_controls \ testparm pl_* \ testparm rid* \ testparm yrs* \ testparm xn_*
 
pcorr fouls_rate bl_fw /* black fracwhite $player_controls $career_stats */ $playergame_controls $teamgame_controls yrs* rid* pl_*  xn_* [aw=min]

clear *
set mem 16000m
use individual_data if sample==1 & min>0, clear
xi i.playeryear i.black*i.home_team
drop _Iblack* _Ihome_team*

for X in varlist $depvars \ Y in varlist $wts: ///
	display("Analyzing X using weights Y") \ ///
	areg X bl_fw /* black fracwhite $player_controls $career_stats $teamgame_controls yrs* rid* pl_* */ $playergame_controls xn_* _I* [aw=Y] , absorb(teamgame)  \ ///
	testparm xn_* \ ///
	outreg bl_fw  $playergame_controls xn_* using "Results\Table4", se  coefastr nocons ctitle("X:allfe") addstat(Ftest: Joint xn's, r(F), Prob>f, r(p)) 3aster append \ ///
	testparm $playergame_controls \ testparm xn_* \ testparm _Iplayerye* \ testparm _Ibl*
 







