* Appendix Tables
clear *

set more off
set mem 1200m
cap set matsize 7000
set maxvar 10000

************************************************
* Appendix Table 1-a: Report full set of controls
************************************************
cap log close
log using using logs\TableA-1.log, replace
cap set mem 16000m
use individual_data if sample==1 & min>0, clear
egen t=tag(player_id)
oprobit black $player_controls p_* if t==1 [w=min_career]

xi i.playeryear i.black*i.home_team
drop _Iblack* _Ihome_team*

for X in varlist fouls_rate points_rate min berri_rate : ///
	display("Analyzing X using weights minutes") \ ///
	areg X bl_fw /* black fracwhite $player_controls $career_stats $teamgame_controls yrs* rid* pl_* */ $playergame_controls xn_* _I* [aw=min] , absorb(teamgame) \ ///
	testparm $playergame_controls \ testparm xn_* \ testparm _Iplayerye* \ testparm _Ibl*
	
log close



************************************************
* Appendix Table 1-b: Different functional forms
************************************************
*** Explore the role of minutes played
cap log close
log using logs\TableA-2.log, replace
use individual_data if sample==1 & min>0, clear
xi i.year, prefix(yrs) noomit
xi i.player, prefix(pl_) noomit

* Baseline specification: Table 4, column 1
reg fouls_rate bl_fw /* black fracwhite $player_controls */ $playergame_controls $teamgame_controls yrs* rid* pl_* [aw=min]

* Analyze foul rate, using only starters 
reg fouls_rate bl_fw /* black fracwhite $player_controls */ $playergame_controls $teamgame_controls yrs* rid* pl_* if starter==1 [aw=min]

* Control for a quartic in minutes played
for X in num 1/4: gen minX=min^X
reg fouls_rate bl_fw min1-min4 /* black fracwhite $player_controls */ $playergame_controls $teamgame_controls yrs* rid* pl_* [aw=min]

* Run a count model, controlling for minutes played
gen lnmin=ln(min)
poisson fouls bl_fw lnmin /* black fracwhite $player_controls */ $playergame_controls $teamgame_controls yrs* rid* pl_* [iw=min]

log close


************************************************
* Appendix Table 1-C: Race effects
************************************************
cap log close
log using logs\TableA-3.log, replace
use individual_data if sample==1 & min>0, clear

xi i.year, prefix(yrs) noomit
xi i.player, prefix(pl_) noomit

*** Start with the key baseline specification being that in Table 4, column 1
reg fouls_rate bl_fw /* black fracwhite $player_controls */ $playergame_controls $teamgame_controls yrs* rid* pl_* [aw=min] 

*** Check whether cross-race effects reflect impacts on black or white players
* Redo main specification, dropping referee fixed effects, and note both bl_fw and wh_fw
gen wh_fw=(1-black)*fracwhite
reg fouls_rate bl_fw wh_fw /* black fracwhite $player_controls */ $playergame_controls $teamgame_controls yrs* pl_* [aw=min] 
lincom bl_fw-wh_fw
* Run separately by race, focussing on fracwhite
bys black: reg fouls_rate  fracwhite /* black fracwhite $player_controls */ $playergame_controls $teamgame_controls yrs* pl_* [aw=min] 

log close

************************************************
* Appendix Table 1-D: Crew versus individual effects
************************************************
cap log close
log using logs\TableA-4.log, replace
use individual_data if sample==1 & min>0, clear

xi i.year, prefix(yrs) noomit
xi i.player, prefix(pl_) noomit

*** Baseline: Table 4, column 1
reg fouls_rate bl_fw /* black fracwhite $player_controls */ $playergame_controls $teamgame_controls yrs* rid* pl_* [aw=min] 

*** Eliminate all mix-race refereeing crews
reg fouls_rate bl_fw /* black fracwhite $player_controls */ $playergame_controls $teamgame_controls yrs* rid* pl_* [aw=min] if fracwhite==0 | fracwhite==1
*** Partial out the identification due to mixed-race crews
gen mix=(white==1 | white==2)
gen bl_mix=black*mix
reg fouls_rate bl_fw bl_mix mix /* black fracwhite $player_controls */ $playergame_controls $teamgame_controls yrs* rid* pl_* [aw=min]
*** Estimate a full set of effects
for X in num 0/3: gen whX=(white==X) \ gen bl_fwX=black*whX
reg fouls_rate bl_fw1 bl_fw2 bl_fw3 /* black fracwhite $player_controls */ $playergame_controls $teamgame_controls yrs* rid* pl_* [aw=min]
test bl_fw1==(bl_fw2-bl_fw1) 
test (bl_fw3-bl_fw2)==(bl_fw2-bl_fw1), accumulate
test bl_fw1==(bl_fw3-bl_fw2), accumulate

log close





