clear *
set mem 600m
set more off
cap log close
log using logs\diffindiff.log, replace
use individual_data, clear
keep if sample==1 & min>0

gen mean=1
reg fouls_rate mean
outreg mean using "Results\DiffinDiff", se coefastr 3aster replace

** 2*2 table
gen whiterefs=white>=2

gen plbl_refwh=black*whiterefs
gen plbl_refbl=black*(1-whiterefs)
gen plwh_refwh=(1-black)*whiterefs
gen plwh_refbl=(1-black)*(1-whiterefs)

* Levels
table whiterefs blackplayer [w=min], c(m fouls_rate) format(%9.3f)
reg fouls_rate plbl_refwh plbl_refbl plwh_refwh plwh_refbl [w=min], noconst
outreg plbl_refwh plbl_refbl plwh_refwh plwh_refbl using "Results\DiffinDiff", se coefastr nocons 3aster append

* First diffs: Foul differential between black and white referees
reg fouls_rate whiterefs [w=min] if black==1
outreg whiterefs using "Results\DiffinDiff", se coefastr nocons 3aster append
reg fouls_rate whiterefs [w=min] if black==0
outreg whiterefs using "Results\DiffinDiff", se coefastr nocons 3aster append

* First diffs: Foul differentials between black and white players
reg fouls_rate black [w=min] if whiterefs==1
outreg black using "Results\DiffinDiff", se coefastr nocons 3aster append
reg fouls_rate black [w=min] if whiterefs==0
outreg black using "Results\DiffinDiff", se coefastr nocons 3aster append

* Diffs-in-diffs
xi: reg fouls_rate i.blackplayer*i.whiterefs [w=min]
outreg _I* using "Results\DiffinDiff", se coefastr nocons 3aster append


reg fouls_rate mean
outreg mean using "Results\DiffinDiff2", se coefastr 3aster replace

** 4*2 table
table white blackplayer [w=min], c(m fouls_rate sd fouls_rate) format(%9.3f)
for X in num 0/3: gen plbl_refwX=black*(white==X) \ gen plwh_refwX=(1-black)*(white==X)
reg fouls_rate plbl_refw0-plwh_refw3 [w=min], noconst
outreg plbl_refw0 plbl_refw1 plbl_refw2 plbl_refw3 plwh_refw0 plwh_refw1 plwh_refw2 plwh_refw3 using "Results\DiffinDiff2", se coefastr nocons 3aster append

*First diffs: Between black and white refs
reg fouls_rate fracwhite [w=min] if black==0
outreg fracwhite using "Results\DiffinDiff2", se coefastr nocons 3aster append
reg fouls_rate fracwhite [w=min] if black==1
outreg fracwhite using "Results\DiffinDiff2", se coefastr nocons 3aster append

* First diffs: Between black and white players
for X in num 0/3: reg fouls_rate black [w=min] if white==X \ outreg black using "Results\DiffinDiff2", se coefastr nocons 3aster append


* Second diffs: Between numbers of white refs
xi: reg fouls_rate i.blackplayer*fracwhite [w=min] if white==0 | white==1
outreg _I* using "Results\DiffinDiff2", se coefastr nocons 3aster append
xi: reg fouls_rate i.blackplayer*fracwhite [w=min] if white==1 | white==2
outreg _I* using "Results\DiffinDiff2", se coefastr nocons 3aster append
xi: reg fouls_rate i.blackplayer*fracwhite [w=min] if white==2 | white==3
outreg _I* using "Results\DiffinDiff2", se coefastr nocons 3aster append

* Diffs-in-diffs
xi: reg fouls_rate i.blackplayer*fracwhite [w=min]
outreg fracwhite _I* using "Results\DiffinDiff2", se coefastr nocons 3aster append



