* This file puts together various other surveys

cap program drop labgraph
program define labgraph
	syntax varlist [if]
	marksample touse
	correl `1' `2' `if'
	global rho=string(r(rho),"%4.3f")
	reg `1' `2' `if'
	global b=string(_b[`2'],"%3.2f")
	global a=string(_b[_cons],"%3.2f")
	global se=string(_se[`2'],"%3.2f")
end


**** Gallup 1946
use "History\Gallup1946.dta", clear
reshape long hap, i(cty) j(happy)
rename hap wt
xi: oprobit happy i.cty [aw=wt]
predict hap_hat, xb
summ hap_hat if happy==1
replace hap_hat=hap_hat-r(mean)
gen lgdp=ln(maddison)
gen gdp=maddison

reg hap_hat lgdp if happy==1
predict h
labgraph hap_hat lgdp if happy==1
lowess hap_hat lgdp if happy==1, nograph generate(hap_hat_low)
gen upper=.5
gen lower=-.5
summ gdp
gen x=500 if _n==2*int(_n/2)
replace x=32000 if x==.

#delimit ;
twoway
	(rarea upper lower x , sort fcolor(gs14) lcolor(gs14))
	(scatter hap_hat gdp, mlabel(cty) mlabcolor(navy) mcolor(navy))
	(line h gdp, sort lpattern(dash) lcolor(black))
,
	xscale(log)
	title("Gallup, 1946 (happiness)", ring(0) size(medsmall))
	xlabel( 500 ".5" 1000 "1"   2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32") 
	ylabel(-1.5(.5)1.5, angle(horizontal) format(%4.1f))
	note("y = $a+$b*ln(x) [se=$se]" "Correlation=$rho", ring(0) pos(5))
	legend(off)
	xsize(10) ysize(7.5)
	name(gallup46, replace)
;
#delimit cr


**** Gallup 1949
use "History\Gallup1949.dta", clear
reshape long hap, i(cty) j(happy)
rename hap wt
xi: oprobit happy i.cty [aw=wt]
predict hap_hat, xb
summ hap_hat if happy==1
replace hap_hat=hap_hat-r(mean)
gen lgdp=ln(maddison)
gen gdp=maddison

reg hap_hat lgdp if happy==1
predict h
labgraph hap_hat lgdp if happy==1
lowess hap_hat lgdp if happy==1, nograph generate(hap_hat_low)
gen upper=.5
gen lower=-.5
summ gdp
gen x=500 if _n==2*int(_n/2)
replace x=32000 if x==.

#delimit ;
twoway
	(rarea upper lower x , sort fcolor(gs14) lcolor(gs14))
	(scatter hap_hat gdp, mlabel(cty) mlabcolor(navy) mcolor(navy))
	(line h gdp, sort lpattern(dash) lcolor(black))
,
	xscale(log)
	title("Gallup, 1949 (happiness)", ring(0) size(medsmall))
	xlabel( 500 ".5" 1000 "1"   2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32") 
	ylabel(-1.5(.5)1.5, nolabels)
	note("y = $a+$b*ln(x) [se=$se]" "Correlation=$rho", ring(0) pos(5))
	legend(off)
	xsize(10) ysize(7.5)
	name(gallup49, replace)
;
#delimit cr


*************** Tension 1948
use "History\Tension 1948.dta", clear
reshape long sat, i(cty) j(s)
rename sat wt
rename s sat

gen freq=round(wt*n,1)

xi: oprobit sat i.cty [fw=freq]
predict sat_hat, xb
summ sat_hat if sat==1
replace sat_hat=sat_hat-r(mean)

gen lgdp=ln(maddison)
gen gdp=maddison
reg sat_hat lgdp if sat==1
predict h


labgraph sat_hat lgdp if sat==1
lowess sat_hat lgdp if sat==1, nograph generate(sat_hat_low)
gen upper=.5
gen lower=-.5
summ gdp
gen x=500 if _n==2*int(_n/2)
replace x=32000 if x==.

#delimit ;
twoway
	(rarea upper lower x , sort fcolor(gs14) lcolor(gs14))
	(scatter sat_hat gdp, mlabel(cty) mlabcolor(navy) mcolor(navy))
	(line h gdp, sort lpattern(dash) lcolor(black))
,
	xscale(log)
	title("Tension Study, 1948 (satisfaction)", ring(0) size(medsmall))
	ylabel(-1.5(.5)1.5, nolabels)
	xlabel( 500 ".5" 1000 "1"   2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32") 
	note("y = $a+$b*ln(x) [se=$se]" "Correlation=$rho", ring(0) pos(5))
	legend(off)
	xsize(10) ysize(7.5)
	name(tension, replace)
;
#delimit cr


***************Cantril 1960
use "History\Cantril.dta", clear
reshape long hap, i(cty) j(happy)
rename hap wt
gen freq=round(wt*n/100,1)
xi: oprobit happy i.cty [fw=freq]
predict hap_hat if wt~=., xb
summ hap_hat if happy==1
replace hap_hat =hap_hat -r(mean)
gen lgdp=ln(maddison)
gen gdp=maddison
reg hap_hat lgdp if happy==1
predict h

labgraph hap_hat lgdp if happy==1
lowess hap_hat lgdp if happy==1, nograph generate(hap_hat_low)
gen upper=.5
gen lower=-.5
summ gdp
gen x=500 if _n==2*int(_n/2)
replace x=32000 if x==.


#delimit ;
twoway
	(rarea upper lower x , sort fcolor(gs14) lcolor(gs14))
	(scatter hap_hat gdp, mlabel(cty) mlabcolor(navy) mcolor(navy))
	(line h gdp, sort lpattern(dash) lcolor(black))
,
	xscale(log)
	title("Patterns of Human Concerns, 1960" "(satisfaction, ladder)", ring(0) size(medsmall))
	xlabel( 500 ".5" 1000 "1"   2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32") 
	ylabel(-1.5(.5)1.5, angle(horizontal) format(%4.1f))
	note("y = $a+$b*ln(x) [se=$se]" "Correlation=$rho", ring(0) pos(5))
	legend(off)
	xsize(10) ysize(7.5)
	name(cantril, replace)
;
#delimit cr


***** World Survey III (1965)
use "History\World Survey III.dta", clear

reshape long hap, i(cty) j(happy)
rename hap wt
gen freq=round(wt*n,1)
xi: oprobit happy i.cty [fw=freq] if cty~="JPN"
predict hap_hat if happy~=. & cty~="JPN", xb
drop _I*
* Fill in missing value for Japan
replace hap_hat=-invnorm(wt)+_b[/cut1] if cty=="JPN" & happy==1
tomode hap_hat, by(cty) replace
replace wt=normal(_b[/cut1]-hap_hat) if happy==1 & wt==.
replace wt=normal(_b[/cut2]-hap_hat)-normal(_b[/cut1]-hap_hat) if happy==2 & wt==.
replace wt=1-normal(_b[/cut2]-hap_hat) if happy==3 & wt==.
summ hap_hat if happy==1
replace hap_hat=hap_hat-r(mean) 


gen lgdp=ln(maddison)
gen gdp=maddison
oprobit happy lgdp [aw=wt]
reg hap_hat lgdp if happy==1
predict h
labgraph hap_hat lgdp if happy==1
lowess hap_hat lgdp if happy==1, nograph generate(hap_hat_low)
gen upper=.5
gen lower=-.5
summ gdp
gen x=500 if _n==2*int(_n/2)
replace x=32000 if x==.
#delimit ;
twoway
	(rarea upper lower x , sort fcolor(gs14) lcolor(gs14))
	(scatter hap_hat gdp, mlabel(cty) mlabcolor(navy) mcolor(navy))
	(line h gdp, sort lpattern(dash) lcolor(black))
,
	xscale(log)
	title("World Survey III, 1965" "(happiness)", ring(0) size(medsmall))
	xlabel( 500 ".5" 1000 "1"   2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32") 
	ylabel(-1.5(.5)1.5, nolabels)
	note("y = $a+$b*ln(x) [se=$se]" "Correlation=$rho", ring(0) pos(5))
	legend(off)
	xsize(10) ysize(7.5)
	name(wsiii, replace)
;
#delimit cr


*** Put 'em all together
#delimit ;
graph combine
	gallup46 tension gallup49 cantril wsiii ,
	l1title("Well-being (Ordered probit index)", size(small))
	b1title("Real GDP per capita (thousands of dollars, log scale)", size(small))
	imargin(zero)
	ycommon
	rows(2)
	xsize(10) ysize(7.5)
	scheme(s1color)
	name(history, replace)
;
#delimit cr
graph save "Figures\fig1.gph", replace

