#delimit;
version 5.0;
set more off;
set matsize 400;

/*areg is used throught this program, adding the fixed effect into prediction*/

/* (0) Data set Cpcounty5.dta should be used to run this do file*/

/* (1)This program uses current arrest rates defined as number of arrests in the county in year t divided by number of murders in the county in year t.  */ 

/* (2) This program was used to generate predicted arrest rate to be used in the second stage of the 2SLS.  To store the predicted arrest rates in the data set Cpcounty5, calling them PAMURCP2.  These predictions includes the fixed effects; the procedure for adding the fixed effects to predicted values was given to us by Sribney, senior statisticians at Stata.*/  

/* FOR PAMURC*/

areg  PAMURC POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM IYEAR_78-IYEAR_96 [aweight=POPC], absorb(COUNTY);



predict double yhat;
egen double A=sum(POPC*yhat) if yhat~=., by(COUNTY);
egen double B=sum(POPC), by(COUNTY);
egen double C=sum(POPC*PAMURC) if PAMURC~=., by(COUNTY);
generate double yhatbari=A/B;
generate double ybari=C/B;
generate PAMURCP2 =yhat-yhatbari+ybari;
drop A B C yhat yhatbari ybari;

