#delimit;
version 5.0;
set more off;
set matsize 400;


/*This program uses areg with POPC as weight*/

/* (0) Cpcounty5.dta should be used to run this do file or its revisions.*/

/* (1)This program is the second-stage of the 2SLS regression and uses the arrest rate, sentencing rate, & execution rate  predicted from the first-stage. All equations are in linear form.  */ 

/*The relevant arrest rate is PAMURC = arrests in t/murders in t. The relevant sentencing rate is PSENTA = state sentences in t + t-1 /state arrests in year t-2 + t-3.  The relevant execution variable is PEXECA=exec in t+2 + t+1 + t + t-1 + t-2 + t-3/sentences in  t-4 + t-5 + t-6 + t-7 + t-8 + t-9 */

/* The following will compute the Mac-David correction*/ 


areg RATMUR RATAGA RATROB PAMURCP2 PSENTAP2 PEXECAP2 PP1019 PP2029 PPB PPN PPM NRARATE RPCPI RPCIM RPCUI DENSITYM IYEAR_78-IYEAR_96 [aweight=POPC], absorb(COUNTY);


predict double yhatwrng, xb;
generate resid1=RATMUR-yhatwrng;
egen double swrng=mean((POPC*resid1)^2);
generate temp=PAMURCP2;
replace PAMURCP2=PAMURC;
generate temp2=PSENTAP2;
replace PSENTAP2=PSENTA;
generate temp3=PEXECAP2;
replace PEXECAP2=PEXECA;
predict double yhatrght, xb;
generate resid2=RATMUR-yhatrght;
egen double srght=mean((POPC*resid2)^2);
generate double MacDaMUR=(srght/swrng)^.5;
replace PAMURCP2=temp;
replace PSENTAP2=temp2;
replace PEXECAP2=temp3;
drop temp temp2 temp3  yhatwrng yhatrght swrng srght resid1 resid2;

generate SEAA=_se[RATAGA]*MacDaMUR;
generate SEROB=_se[RATROB]*MacDaMUR;
generate SEAMUR=_se[PAMURCP2]*MacDaMUR;
generate SESENT=_se[PSENTAP2]*MacDaMUR;
generate SEEXEC=_se[PEXECAP2]*MacDaMUR;
generate SEPP1019=_se[PP1019]*MacDaMUR;
generate SEPP2029=_se[PP2029]*MacDaMUR;
generate SEPPB=_se[PPB]*MacDaMUR;
generate SEPPN=_se[PPN]*MacDaMUR;
generate SEPPM=_se[PPM]*MacDaMUR;
generate SENRA=_se[NRARATE]*MacDaMUR;
generate SERP=_se[RPCPI]*MacDaMUR;
generate SEWELF=_se[RPCIM]*MacDaMUR;
generate SEUNEM=_se[RPCUI]*MacDaMUR;
generate SEDENS=_se[DENSITYM]*MacDaMUR;
generate SEYR78=_se[IYEAR_78]*MacDaMUR;
generate SEYR79=_se[IYEAR_79]*MacDaMUR;
generate SEYR80=_se[IYEAR_80]*MacDaMUR;
generate SEYR81=_se[IYEAR_81]*MacDaMUR;
generate SEYR82=_se[IYEAR_82]*MacDaMUR;
generate SEYR83=_se[IYEAR_83]*MacDaMUR;
generate SEYR84=_se[IYEAR_84]*MacDaMUR;
generate SEYR85=_se[IYEAR_85]*MacDaMUR;
generate SEYR86=_se[IYEAR_86]*MacDaMUR;
generate SEYR87=_se[IYEAR_87]*MacDaMUR;
generate SEYR88=_se[IYEAR_88]*MacDaMUR;
generate SEYR89=_se[IYEAR_89]*MacDaMUR;
generate SEYR90=_se[IYEAR_90]*MacDaMUR;
generate SEYR91=_se[IYEAR_91]*MacDaMUR;
generate SEYR92=_se[IYEAR_92]*MacDaMUR;

generate SEYR93=_se[IYEAR_93]*MacDaMUR;
generate SEYR94=_se[IYEAR_94]*MacDaMUR;
generate SEYR95=_se[IYEAR_95]*MacDaMUR;
generate SEYR96=_se[IYEAR_96]*MacDaMUR;

generate SECONS=_se[_cons]*MacDaMUR;

generate TAA=_b[RATAGA]/SEAA;
generate TROB=_b[RATROB]/SEROB;
generate TAMUR=_b[PAMURCP2]/SEAMUR;
generate TSENT=_b[PSENTAP2]/SESENT;
generate TEXEC=_b[PEXECAP2]/SEEXEC;
generate TPP1019=_b[PP1019]/SEPP1019;
generate TPP2029=_b[PP2029]/SEPP2029;
generate TPPB=_b[PPB]/SEPPB;
generate TPPN=_b[PPN]/SEPPN;
generate TPPM=_b[PPM]/SEPPM;
generate TNRA=_b[NRARATE]/SENRA;
generate TRP=_b[RPCPI]/SERP;
generate TWELF=_b[RPCIM]/SEWELF;
generate TUNEM=_b[RPCUI]/SEUNEM;
generate TDENS=_b[DENSITYM]/SEDENS;
generate TYR78=_b[IYEAR_78]/SEYR78;
generate TYR79=_b[IYEAR_79]/SEYR79;
generate TYR80=_b[IYEAR_80]/SEYR80;
generate TYR81=_b[IYEAR_81]/SEYR81;
generate TYR82=_b[IYEAR_82]/SEYR82;
generate TYR83=_b[IYEAR_83]/SEYR83;
generate TYR84=_b[IYEAR_84]/SEYR84;
generate TYR85=_b[IYEAR_85]/SEYR85;
generate TYR86=_b[IYEAR_86]/SEYR86;
generate TYR87=_b[IYEAR_87]/SEYR87;
generate TYR88=_b[IYEAR_88]/SEYR88;
generate TYR89=_b[IYEAR_89]/SEYR89;
generate TYR90=_b[IYEAR_90]/SEYR90;
generate TYR91=_b[IYEAR_91]/SEYR91;
generate TYR92=_b[IYEAR_92]/SEYR92;

generate TYR93=_b[IYEAR_93]/SEYR93;
generate TYR94=_b[IYEAR_94]/SEYR94;
generate TYR95=_b[IYEAR_95]/SEYR95;
generate TYR96=_b[IYEAR_96]/SEYR96;

generate TCONS=_b[_cons]/SECONS;

list SEAA TAA SEROB TROB SEAMUR TAMUR SESENT TSENT SEEXEC TEXEC SEPP1019 TPP1019 SEPP2029 TPP2029 SEPPB TPPB SEPPN TPPN SEPPM TPPM SENRA TNRA SERP TRP SEWELF TWELF SEUNEM TUNEM SEDENS TDENS SEYR78 TYR78 SEYR79 TYR79 SEYR80 TYR80 SEYR81 TYR81 SEYR82 TYR82 SEYR83 TYR83 SEYR84 TYR84 SEYR85 TYR85 SEYR86 TYR86 SEYR87 TYR87 SEYR88 TYR88 SEYR89 TYR89 SEYR90 TYR90 SEYR91 TYR91 SEYR92 TYR92 SEYR93 TYR93 SEYR94 TYR94 SEYR95 TYR95 SEYR96 TYR96 SECONS TCONS if COUNTY==1001 & YEAR==90;

