% ssgovt

% this file sets the government policy parameters during the transition
% period. Before 1975 the economy is in steady state. At the beginning of
% 1975 the government announces that, after TT1-TT2 periods the policy
% parameters will change.
% TT1 is the transition period (does not include the phase out) in which
% the policy param. are potentially different from the steady state ones.
% TT2 is the period in which the policy param. are actually changed
% (2059-1999).
% From the beginning of time TT1 on the policy parameters are set to
% their new steady state value. The new steady state is reached at the
% beginning of time TT1+T0.

% the parameter tmptran is used during TT2 to get the right debt/gdp
% ratio in the new steady state

% the tax rate on labor income is changed, in five steps during TT2
% also the lump sum component of the social security benefits (fixben)
% is analogously changed in five step to go from fixben11 (computed
% in the initial steady state and such that fixben11=fixrrate*w*...
% gammah*wtnbar11) to fixben22, analogously computed for the final
% steady state.
% PENSIONS ARE TAXED AT THE LABOR TAX RATE FROM YEAR 2000 ON.

TAUL(2000-1974:2009-1974)=taul11+.2*(tmptran-taul11)*ones(10,1);
TAUL(2010-1974:2019-1974)=taul11+.4*(tmptran-taul11)*ones(10,1);
TAUL(2020-1974:2029-1974)=taul11+.6*(tmptran-taul11)*ones(10,1);
TAUL(2030-1974:2039-1974)=taul11+.8*(tmptran-taul11)*ones(10,1);
TAUL(2040-1974:2059-1974)=tmptran*ones(20,1);
NET(2000-1974:2059-1974)=TAUL(2000-1974:2059-1974);

FIXBEN(2000-1974:2009-1974)=fixben11+(1/6)*(fixben22-fixben11)*ones(10,1);
FIXBEN(2010-1974:2019-1974)=fixben11+(2/6)*(fixben22-fixben11)*ones(10,1);
FIXBEN(2020-1974:2029-1974)=fixben11+(3/6)*(fixben22-fixben11)*ones(10,1);
FIXBEN(2030-1974:2039-1974)=fixben11+(4/6)*(fixben22-fixben11)*ones(10,1);
FIXBEN(2040-1974:2059-1974)=fixben11+(5/6)*(fixben22-fixben11)*ones(20,1);

