%  essss.m (a script file)  computes steady state system, 
% "joy-of-giving" formulation
%
%  Inputs are: eff, beta, T, G, gbbar, Taul, Taua, Tauc, Utau,
%  tmpval, Tmpstr, tmpstr, x0, V0, Gammaa, Gammah
%
%  Outputs are, meanx, meanc, meana, meani, V, vc, va, vi, Soc, Tax,
%  Beq, P, F, Ao, Phi, CC, AA, and II.

% initialisations
fixbal=zeros(2,1);
balance=zeros(2,1);
rbal=zeros(2,1);

for yy=1:MAXIT, % this loop iterates on the interest and wage rate
                % until they clear the market
  if yy==MAXIT,
    disp('WARNING: max # of iterations reached for yy in essss');
  end;

  Gammaa=gammaa*ones(T0+1,1);
  Gammah=wrrat./Gammaa.^(ksh/(1-ksh));
  RR=Gammaa(1)+dela; % net of depreciation rate of return in ss

  for zz=1:MAXIT,  % this loop iterates on the gov't budget constraint 
    if zz == MAXIT,
       disp('WARNING: Max. # of iter. reached for zz in ssss iter.')
    end;
    eval([Tmpstr,'=ones(T0+1,1)*(',sprintf('%15.14f',tmpval),');']);
    input1=[G; Taul; Taua; Tauc; beta; eff; ud1'; x0'; scel'; ...
            skal'; sconst'; rrate];
    input2=[PT2, sig, T, T2, lambda', dela, phic, deltah, thetah];
    input3=[pih, ub];

    for z4=1:MAXIT,  % this iterates the lump sum part of the
                     % soc. sec. benefits
      if z4 == MAXIT,
         disp('WARNING: Max. #  of iter. reached for z4 in ssss iter.')
      end; % for if
      [output1, output2,output3]=essec(1, PT1, V0, input3, Utau, c2, ...
                                 a22, dimension, input1, input2,...
                                 fixben*ones(T2,1).*(1+rho).^(0:-1:-T2+1)',...
                                 Net,...
                                 Gammaa, Gammah, survival, beta0, rho);

      meanc=output1(1:nc*(T+1));
      temp=reshape(meanc,nc,T+1);
      meancc=temp(1,:)';
      meancn=temp(2,:)';
      wtnbar=frac(1:T1+1)'*(meancn(1:T1+1).*eff);
      fixbal=fixben-fixrrate*...
      Gammah(1)*sum(eff.*meancn(1:T1+1))/(T1+1);
      if abs(fixbal)< tol1,
         break;
        elseif z4==1,
         fixben1=fixben;
         fixbal1=fixbal;
         fixben=fixben1+pert;
        else,
         fixben0=fixben1;
         fixbal0=fixbal1;
         fixben1=fixben;
         fixbal1=fixbal;
         fixben=fixben1-(fixbal1*(fixben0-fixben1))/(fixbal0-fixbal1);
      end; % for if
    end, % for for z4

    meanka=output1(nc*(T+1)+(1:T+1));
    meania=output2(1:T+1);
    via=output2(T+1+(1:T+1));
    meaninc=output2(2*(T+1)+(1:T+1));
    vinc=output2(3*(T+1)+(1:T+1));
    meandinc=output2(4*(T+1)+(1:T+1));
    vdinc=output2(5*(T+1)+(1:T+1));
    vc=zeros(nc*(T+1),nc);
    vc(:,1)=output2(6*(T+1)+1:8*(T+1));
    vc(:,2)=output2(8*(T+1)+1:10*(T+1));
    vka = output2(10*(T+1)+(1:T+1));
    risk=output2(11*(T+1)+(1:T+2));
    meanx=output2(12*(T+1)+2:length(output2));

    P=output3(1:(T+2)*nx,:);
    V=output3((T+2)*nx+1:(2*T+3)*nx,:);

    Stau=[zeros(T+1,nka+nce+nh) Utau];

    % calculate steady state government cash flow.  gbal is the
    % government budget imbalance, to be searched over so that govt
    % budget is balanced.

    income=0;
    Taxl=0;
    Taxa=0;
    Taxc=0;
    Tax0=0;
    Soc=0;


    for t=1:(T+1),
      if t<=T1+1,
         taulbase=Gammah(1)*eff(t)*meancn(t)*frac(t);
         tauabase=((RR-1)/(1+rho))*skal*meanx((t-1)*nx+1:t*nx)*frac(t);
         taucbase=meancc(t)*frac(t);
         income=income+taulbase;
         Taxl=Taxl+Taul(t)*taulbase;
         Taxa=Taxa+Taua(t)*tauabase;
         Taxc=Taxc+Tauc(t)*taucbase;
         Tax0=Tax0+(Stau(t,:)/(1+rho))*meanx((t-1)*nx+1:t*nx)*frac(t);
        else
         tauabase=((RR-1)/(1+rho))*skal*meanx((t-1)*nx+1:t*nx)*frac(t);
         taucbase=meancc(t)*frac(t);
         income=income+tauabase;
         Taxa=Taxa+Taua(t)*tauabase;
         Taxc=Taxc+Tauc(t)*taucbase;
         Tax0=Tax0+(Stau(t,:)/(1+rho))*meanx((t-1)*nx+1:t*nx)*frac(t);
         Soc=Soc+(1-Net(t))*...
             frac(t)*(rrate/(1+rho))*scel*meanx((t-1)*nx+1:t*nx)+...
             (1-Net(t))*frac(t)*fixben*((1+rho)^(T1+2-t));
      end; % for "if"
    end; % for "for t=1:(T+1)"

    Beq=(1-[survival; 0]') * (frac .* meanka) /pop;
    Tax=Taxl+Taxa+Taxc+Tax0+Taub*(RR/(1+rho))*Beq;
    gbal=G(1)+Soc-Tax+(RR/(pop*(1+rho))-1)*gbbar;
    % when gbal=0, this is government's budget constraint in steady 
    % state. gbbar: end of period per capita debt holding
    clear t

    if abs(gbal) < tol1,
       % if govt balance is close to zero enough, exit the loop.  The
       % value of tmpval has been found.
       break;
      elseif zz==1,
       tmpval1=tmpval;
       gbal1=gbal;
       tmpval=tmpval1+pert;
      else
       tmpval0=tmpval1;
       gbal0=gbal1;
       tmpval1=tmpval;
       gbal1=gbal;
       tmpval=tmpval1-relax*gbal1*(tmpval0-tmpval1)/(gbal0-gbal1)
      end; % for "if abs"
  end; % for "for zz"

  % end-of-period asset holding (includes govt debt)
  kabar0=frac'*meanka;
  % beginning of the period per capita aggregate capital, used in
  % the C-D prod. fn.
  kphat0=(kabar0-gbbar)/(pop*(1+rho)); 

  % interest rate implied by the aggregate capital stock and labor supply
  rbal = CD*ksh*(wtnbar/kphat0)^(1-ksh) - gammaa;

  if abs(rbal) < tol1/20,
     break;
    elseif yy==1,
     gammaa1=gammaa;
     rbal1=rbal;
     gammaa=gammaa1+pert;
    else,
     gammaa0=gammaa1;
     rbal0=rbal1;
     gammaa1=gammaa;
     rbal1=rbal;
     gammaa=gammaa1-relax*rbal1*(gammaa0-gammaa1)/(rbal0-rbal1);
  end; % for if

end; % for the yy loop

gammaa=Gammaa(1);
gammah=wrrat/gammaa^(ksh/(1-ksh));


clear zz zzz RR balance gbal output1 output2 output3 input1 input2

