% essset (a script file): steady state setting
% this is the "joy of giving" formulation of the problem.
% essset sets parameters for the policy-induced transition problem
% studied by run.m.  It sets the following parameters: economic and 
% biological parameters for private agents and age cohorts; policy
% parameters for the two steady states.
% The exogenous wage profile is determined using the efficiency index
% and is given by wt.

load ssdata;    % efficiency index and survival rates over all ages.
		% The efficiency index is used to represent learning
		% ability in accumulating his/her human capital,               

newsurv;        % construct the time varying survival probability
		% table and time varying population growth rate.

%----------------- Set Labor Augmenting  Productivity -----------------%
rho=.016;

%--------------------- Set Tax on Bequests ----------------------------%
taub=0.1;

%------------------- Set Demographic Parameters -----------------------%
% T0+1 is the max. number of years to live (born at beginning of age 0; 
% die at the end of age T0 for sure).T1+1 is max. number of years
% working; T2 is years after retiring. (retire at the end of period T1)
	
T1=length(newefg1)-1;
T2=T0-T1;
eff=newefg1;

%-------------------- Set Preference Parameters -----------------------%
% with the "joy-of-giving" formulation, it is not possible
% to allow for risk sensitivity, since the problem would not
% remain linear quadratic.

% V(t) = -.5 * (s(t)-b(t)).(s(t)-b(t)) + beta(t) E_t(V(t+1))
% where         E(V(t+1)|t) = Surv*E_t(V(x_t+1)|alive) +
%                             (1-Surv)*E_t(V(x_t+1)|dead)
%               s(t) = lambda*h(t-1) + pih*c(t)
%               h(t) = deltah*h(t-1) + thetah*c(t)
%               where (V(x_t)|dead)= x(t)'PT1*x(t)
%               x(t)'*PT1*x(t)=-JG*((1-taub)*B_{t-1}-JB)^2
%               is the "joy-of-giving", B_t are assets left as
%               bequests and JB is the relevant bliss point.

beta0=0.994;
		% beta0 is disc. factor without taking mortality rate 
		% into consideration.

betaT=beta0*ones(1,size(Survival,2)-T0); % discount factor at age T0:
		% it disregards the prob. of dying (which is 1)
		% because we set the final value function at the value
		% of leaving a bequest

Beta=beta0*Survival(:,1:size(Survival,2)-T0);
		% Beta: matrix of expected disc. factors for all cohorts

Beta(T0+1,:)=betaT; 

lambda=[0;0];
pih=[1 0; 0 -1.7];
pih=kron(ones(1,T0+1),pih);
deltah=0;           
thetah=[0 0]; 
ub=[11 0 0 0;
    0 0 0 0];      % ub * z(t) gives b(t).
sig=0;             % risk sensitivity parameter
JG=.032;
JB=60;
PT1=zeros(7);      % value function that induces the "joy-of-giving"
PT1(2,2)=-JG*(1-taub)^2;
PT1(4,4)=-JG*JB^2;
PT1(2,4)=JG*JB*(1-taub);
PT1(4,2)=JG*JB*(1-taub);
PT2=0;  % terminal value of the risk adjustment term in the value
	% function in addition to the certainty equivalent term
	% described by PT1.


%---------------------- Set Technology Parameters ---------------------%
% the technology for the representative agent in a cohort is:

% phic*c(t)+ka(t)=(dela+gammaa)/(1+rho)*ka(t-1)+w(t)*eff(t)*n(t)+fixben+
%                 + rrate*ce(t-1)-T(t)+d1(t)

% ce(t)=ce(t-1)/(1+rho)+w(t)*eff(t)*n(t) = cumulated past earnings
% T(t) is government tax policy, to be specified below;
% the soc. sec. payments the agent receives at age t (rrate/(1+rho)*ce(t-1))
% are a function of the individual's past earnings (and thus of the
% taxes paid) plus a lump sum term (fixben);
% ka are total assets held by the agent;
% the labor supply is optimally determined by the agent;
% eff is an age efficiency profile used to match the age-wage profile.
% w(t)= gammah when working is wage per efficient labor unit;
% w(t)=0 after the agent retires.
% the marginal product of capital and labor, (gammaa and gammah) are
% determined by the economy-wide production technology:
% GDP=CD*Khat^ksh*(Nh)^(1-ksh)
% where CD is the Cobb-Douglas coefficient, ksh is the capital share,
% Khat is the beginning of period aggregate capital and Nh is the
% aggregate efficient labor supply.
% d1(t) is the shock to labor income.

phic=1;
gammaa=.12;             % gross of depreciation return of asset
dela=.945;              % 1-dela is depreciation rate of asset.

% Cobb-Douglas Technology
% I choose ksh and CD to match w and r in the previous version with
% exogenous prices
ksh=.33;
CD=2;
wrrat=CD^(1/(1-ksh))*(1-ksh)*ksh^(ksh/(1-ksh));
% wrrat is defined so that
gammah=wrrat/gammaa^(ksh/(1-ksh));

% Khlbar is the aggregate per capita human capital at the beginning of
% each period. In this model it is exogenous
Khlbar=newefg1'*Frac(1:T1+1,:);

RR=gammaa+dela;   % return of an asset net of depreciation
ud1=[0 0 .85 0];  % selection matrix for labor income


%------------- Set Information Structure Parameters -------------------%
% the underlying exogenous process in the economy is:
%
%               z(t+1) = a22 * z(t) + c2 * w(t+1)
%
% where the first component of z is the constant, the second is the
% preference shock, the third is the labor income shock and the fourth
% is not used.

a22=[1  0  0  0;
     0 .8  0  0;
     0  0 .8  0;
     0  0  0 .5];

c2=[zeros(1,3);
    eye(3)];

% set initial values for mean and variance of x(t), the state vector for
% the representative agent of a cohort.
% x(t)=[h(t-1) ka(t-1) ce(t-1) z(t)];
% ka: agent's assets(physical capital plus government debt)
% ce: agent's cumulated past earnings
% z: exogenous process describing the economy's information structure.

x00=[0 20 0 1 0 0 0];
V00=zeros(7,7);    

%--------------------- Set Dimensional Parameters ---------------------%

nx=length(x00);
[ns,nh]=size(lambda);
nb=ns;
nka=1;
nce=1;
nia=1;
nc=2;
[nd, nu]=size(phic);
[nz,nw]=size(c2);


%------------ Set Steady State Fiscal Policy Parameters --------------%

% First set policy parameters for the initial steady state %

rrate=0.0/(T1+1);   % replacement rate for social security benefits for
		    % the part which is proportional to the agent's past
		    % earnings.
% we then want a lump sum part of the social security benefits. we note
% that in this version of the code the gdp is varying over time (the
% demographics are changing, and so in the labor supply). we want the lump
% sum part of the transfers to be fixrrate*w*frac'(meancn.*eff)=
% fixben. Since the labor supply depends on fixben, we need to iterate
% until convergence in the code ssss.
fixrrate=0.6;
fixben11=fixrrate*gammah*sum(newefg1)/(T1+1);

				 % this is the initialisation of the
				 % social security benefits for the just
				 % retired agent. 

G11=2.5;                    % government spending
gbbar11=2.22*G11;           % government debt
taul11=.27;                 % tax rate on labor income
taua11=.30;                 % tax rate on return of asset
tauc11=.055;                % tax rate on consumption
taub11=taub;                % tax rate on bequests
utau11=zeros(1,nz);         % lump sum tax

% Change this line to select the policy parameter to be used in
% secant algorithm to balance government budget in initial steady state

tmpstr11=['taul'];              % taul11 is to be searched over


tmpval11=eval([tmpstr11, num2str(11)]); 
Tmpstr11=tmpstr11;
Tmpstr11(1)=upper(tmpstr11(1));

% Second set policy parameters for the new steady state   %
% (some of these parameters will be changed later on)    %

gbbar22=gbbar11;
G22=G11*(1.25);                     %  gbbar22  will be changed.
taul22=taul11;
taua22=taua11;
tauc22=tauc11;
taub22=taub;
utau22=zeros(1,nz);

% Change the following lines to select the policy par. to be used in
% secant algorithm to balance government budget in the new steady state

tmpstr22=['taul'];          % taul22 is to be searched over

tmpval22=eval([tmpstr22, num2str(22)]); 
Tmpstr22=tmpstr22;
Tmpstr22(1)=upper(tmpstr22(1));

% 1975 is the year of revelation. In 1975 the govt announces that,
% starting from year 2000 it is going to increase taxes every ten
% years: the tax rate on labor is taull11 from year 1975 to 1999, it
% is taull11+.2(tmptran-taul11) from year 2000 to 2009, it is taull+
% .4*(tmptran-taul11), ....it is tmptran starting from year 2040 til
% year 2059, it is taul22 from 2060 on.
TT1=2059-1974; % transition period in which the policies are different
	       % from the steady state ones (does not include the phase
	       % out period)
TT2=2059-1999; % period in which the change in policy takes place
	       % (hence TT1-TT2=1999-1974 is the announcement period)
% TT is then the lenght of the period during which r and w fluctuate
% but all the rest is set to steady state values. After this period,
% r and w are fixed at their steady state level. It follows that after
% further T0 periods we will be in steady state (i.e after the phase out)
TT=2*T0; 


% initialization of the parameter to be iterated to compute
% the transition path 

tmptran0=taul11;  % initialization of tmptran.  See ssgovtt1.m for 
	 % definition of tmptran (temporary parameter for transition)

% control parameters for the loops

MAXIT=200;                           % Maximum number of iterations
tol1=max(max(G11,G22)/200,.005)/10; % tol. level for government budget 
				    % imbalance solving stationary solution
tol2=1.0e-7;
pert=1.0e-5;    % amount of perturbation when using secant 
		% search method to find the set of fiscal policy 
		% that will balance budget in a stationary setting.
epsi=[pert, 0];         

