% "joy-of-giving" formulation

function [output1, output2, output3]=essec(mode, PT1, V0, input3,...
Utau, c2, a22, dimension, input1, input2, fixben, Net, Gammaa, Gammah, ...
survival, beta0, rho);

survival=[survival; 0];

% ssec.m: prepares the economy described in ssss.m, and bench.m
% into standard discounted linear quadratic gaussian format, then the
% recursive problem is solved.

nx=dimension(1);
nc=dimension(2);
nce=dimension(3);
nh=dimension(4);
nka=dimension(5);
nia=dimension(6);
nw=dimension(7);
ns=dimension(8);
nz=dimension(9);
nb=dimension(10);

PT2=input2(1);
sig=input2(2);
T=input2(3);
T2=input2(4);
lambda=input2(5:6)';
dela=input2(7);
phic=input2(8);
deltah=input2(9);
thetah=input2(10:11);

pih=input3(:,1:2*(T+1));
ub=input3(:,2*(T+1)+1:2*(T+1)+nz);

T1=max(-1, T-T2);

G=input1(1:T+1);
Taul=input1(T+1+(1:T+1));
Taua=input1(2*(T+1)+(1:T+1));
Tauc=input1(3*(T+1)+(1:T+1));
beta=input1(4*(T+1)+(1:T+1));
input1=input1(5*(T+1)+1:length(input1));
eff=input1(1:T1+1);
ud1=input1(T1+1+(1:nz))';
x0=input1(T1+1+nz+(1:nx))';
scel=input1(T1+1+nz+nx+(1:nx))';
skal=input1(T1+1+nz+2*nx+(1:nx))';
sconst=input1(T1+1+nz+3*nx+(1:nx))';
rrate=input1(T1+1+nz+4*nx+1);

Stau=[zeros(T+1,nka+nce+nh) Utau];

A=zeros(nx*(1+T),nx);
R=A;
B=zeros(nx*(1+T),nc);
Q=zeros(nc*(1+T),nc);
Qi=Q;
S=zeros(nc*(1+T),nx);

% creation of the composite state vector x(t)
% State variable x(t)=[h(t-1); ka(t-1); ce(t-1); z(t)];
% Control variable u(t)=[c(t);n(t)];
% see discussion in file esset.m for more details
% the following lines transform the economy into the standard linear
% gaussian quadratic form of:
%       max V(t)=u(t)'*q*u(t) + x(t)'*r*x(t) + beta(t)*E_t(V(t+1))
%       subject to: 
%       x(t+1)=a*x(t)+b*u(t)+c*w(t+1);
% matrices q, r, a, b, and c are formed as follows.

g=[lambda zeros(ns,nka+nce) -ub];
r=-.5*g'*g;
c=[zeros(nh+nka+nce,nw); c2];

% construction of a and b matrices for the workers
% A is a matrix containing a computed for j=1 as first block of
% rows, a computed for j=2, as second block  and so on. Analogously
% for B

for j=1:(T1+1),
  q=-.5*pih(:,2*(j-1)+1:2*j)'*pih(:,2*(j-1)+1:2*j);
  s=-.5*pih(:,2*(j-1)+1:2*j)'*g;
  % transform to remove cross products
  qi=inv(q);
  r=-.5*g'*g-s'*qi*s;
  a1=((Gammaa(j)+dela)*(1-Taua(j)) + Taua(j))/(1+rho);
  a=[deltah zeros(nh,nka+nce+nz);
    zeros(nka,nh) a1 zeros(nka,nce+1) (1-Taul(j)) zeros(nka,nz-2);
    zeros(nce,nka+nh) eye(nce) zeros(nce,nz);
    zeros(nz,nh+nka+nce) a22];
  b=[thetah;
     -phic*(1+Tauc(j)) (1-Taul(j))*Gammah(j)*eff(j);
     0 Gammah(j)*eff(j);
     zeros(nz,nc)];
     a=a-b*qi*s;
     A((j-1)*nx+1:j*nx,:)=a;
     R((j-1)*nx+1:j*nx,:)=r;
     B((j-1)*nx+1:j*nx,:)=b;
     Q((j-1)*nc+1:j*nc,:)=q;
     Qi((j-1)*nc+1:j*nc,:)=qi;
     S((j-1)*nc+1:j*nc,:)=s;
end; % for "for j"

% contruction of the a and b matrices for the retired people

for j=T1+2:T+1,
  q=-.5*pih(:,2*(j-1)+1:2*j)'*pih(:,2*(j-1)+1:2*j);
  s=-.5*pih(:,2*(j-1)+1:2*j)'*g;
  % transform to remove cross products
  qi=inv(q);
  r=-.5*g'*g-s'*qi*s;
  a1=((Gammaa(j)+dela)*(1-Taua(j)) + Taua(j))/(1+rho);
  a=[deltah zeros(nh,nka+nce+nz);
     zeros(nka,nh) a1 (1-Net(j))*rrate/(1+rho) (1-Net(j))*fixben(j-T1-1) zeros(nka,(nz-1)); 
     zeros(nce,nka+nh) eye(nce)/(1+rho) zeros(nce,nz);
     zeros(nz,nh+nka+nce) a22];
  b=[thetah;
     -phic*(1+Tauc(j)) 0;
     zeros(nz+nce,nc)];
  a=a-b*qi*s;
  A((j-1)*nx+1:j*nx,:)=a;
  R((j-1)*nx+1:j*nx,:)=r;
  B((j-1)*nx+1:j*nx,:)=b;
  Q((j-1)*nc+1:j*nc,:)=q;
  Qi((j-1)*nc+1:j*nc,:)=qi;
  S((j-1)*nc+1:j*nc,:)=s;
end; % for "for"

C=c;

% Output includes F, P, Ao, phi, meanx, meanka, meanc, meania, V, vka,
% vc, via.
% Inputs includes beta,A,B,Q,R,Qi,C,sig,PT1,T,beta,x0,V0,Utau,
%
% The following code calculates f_t of the feedback laws:
% u_t = -f_t x_t  that maximizes the function V(t)
%
% where x is the state vector, u the control vector, A, B, Q, R, W are 
% set above. For t=1,...,T, successive rows of P, Ao, and F have the
% corresponding time/age t value functions, closed loops (a-bf) and  
% policy functions.  Phi holds the `transition' functions
%     Phi=[I a1 a2*a1  a3*a2*a1 ...  a(T+1)aT*a(T-1)* ... *a1]
% where ai is the closed loop system at time i-1.  Successive blocks of  
% Phi give the transition law from t-j to t.
% Also computed are: CC,IA,KA, which sequences of decisions rules for c,
% ia, ka, and meania, meanc, meanka, time series of means of ia, c, ka.
% Standard deviations of the distributions of c, ia, ka are stored in
% vc, via, vka.  Covariance matrix of x is stored in V.

CC=zeros((T+1)*nc,nx); 
KA=zeros((T+1)*nka,nx); 

if mode==1,
   IA=zeros((T+1)*nia,nx);
   INC=zeros(T+1,nx);
   DINC=INC;
   risk=zeros(T+2,1);
   risk(T+2)=PT2;
end; % for "if mode"

Ao=zeros((T+1)*nx,nx);
P=Ao;
F=zeros((T+1)*nc,nx);

p0=PT1; 
Phi=eye(nx); 
P((T+1)*nx+1:(T+2)*nx,:)=p0;  
% grand matrix P stacks p(t) together, where x(t)'p(t)x(t)+zita(t) is 
% the expected future utility at date t

sb = [zeros(nb,nh+nka+nce),ub];

for j=1:(T+1),
  jj=T+1-j;       % jj goes from T to 0, denoting the cohort's age.
  a=A(nx*jj+1:(1+jj)*nx,:);
  r=R(nx*jj+1:(1+jj)*nx,:);
  b=B(nx*jj+1:(1+jj)*nx,:);
  q=Q(nc*jj+1:(1+jj)*nc,:);
  qi=Qi(nc*jj+1:(1+jj)*nc,:);

  pp1=eye(nw)-sig*C'*p0*C;

  p1=p0+sig*p0*C*(pp1\C'*p0);

  % The rhs of the above is T(p0) of Hansen-Sargent
  % f0=(q+beta(jj+1)*b'*p1*b)\(beta(jj+1)*b'*p1*a);
  % modified for the joy og giving
  f0=(q+beta(jj+1)*b'*p1*b+beta0*(1-survival(jj+1))*b'*PT1*b)\...
     (beta(jj+1)*b'*p1*a+beta0*(1-survival(jj+1))*b'*PT1*a);

  %  See Hansen-Sargent for this formula
  % p2=r+f0'*q*f0+beta(jj+1)*(a-b*f0)'*p1*(a-b*f0);
  % modified for the joy of giving
  p2=r+f0'*q*f0+beta(jj+1)*(a-b*f0)'*p1*(a-b*f0)+beta0*(1-survival(jj+1))*...
     (a-b*f0)'*PT1*(a-b*f0);

  %  p2=r + beta(jj+1)*A'*(p1 -beta(jj+1)*p1*b*...
  %  ((q+beta(jj+1)*b'*p1*b)\b'*p1))*A;
  %  alternative form for p2 (identical in output)
  %  The right side of the above equation is D(p1) of Hansen and Sargent

  if mode == 1,
     risk(jj+1) = beta(jj+1)*(risk(jj+2) + trace(C'*p0*C))+...
     beta0*(1-survival(jj+1))*trace(C'*PT1*C);
  end; % for "if mode"

  ao=a-b*f0;
  p0=p2;

  %  The following equations stack the outputs into grand matrices
  %   F(nc*jj+1:nc*(jj+1),:)=f0;  % grand matrix for feedback rule
  Ao(nx*jj+1:nx*(jj+1),:)=ao; 
  % Calculation of the solution matrices.

  ska=ao(nh+1:nh+nka, :);       % ska*x(t) is ka(t).
  sc = -f0-qi*s;                % policy fn with cross products

  CC(nc*jj+1:nc*(jj+1),:) = sc;    %asset holding, consumption stock
  KA(nka*jj+1:nka*(jj+1),:) = ska; %and intermediate goods for an agent 

  if mode==1,
     P(nx*jj+1:nx*(jj+1),:)=p2;  
     sia = ska - dela * skal;        % gross invest. in phisical capital
     if T-jj > T2-1, % if worker
        sinc=(Gammaa(jj+1)+dela-1)*skal+Gammah(jj+1)*eff(jj+1)*sc(2,:);
        sdinc=sinc-Taua(jj+1)*(Gammaa(jj+1)+dela-1)*skal-...
              Taul(jj+1)*Gammah(jj+1)*eff(jj+1)*sc(2,:); % disp. income
        % household's income if not retired
       else,
        sinc=(Gammaa(jj+1)+dela-1)*skal+rrate*scel+fixben(jj-T1)*sconst;
        sdinc=sinc-Taua(jj+1)*(Gammaa(jj+1)+dela-1)*skal-...
        Net(jj+1)*(rrate*scel+fixben(jj-T1)*sconst);
     end; % for "if T-jj"
 
     % grand matrices stacking consumption
     IA(nia*jj+1:nia*(jj+1),:) = sia; %services, invest., cons.
     INC(jj+1,:) = sinc;
     DINC(jj+1,:) = sdinc;
  end; % for "if mode"
end;  %  end of the for loop


%  The following code creates a row matrix of transition functions    

meanc=zeros(nc*(T+1),1);   % from c(0) to c(T)
meanka=zeros(nka*(T+1),1); % from ka(0) to ka(T), amount left at death
meanx=zeros((T+1)*nx,1);

if mode == 1,
   meania=zeros(nia*(T+1),1);
   meaninc=zeros(T+1,1);
   meandinc=meaninc;
end; % for "if mode"

for j=1:(1+T),
  Phi=[Phi Ao(nx*(j-1)+1:j*nx,:)*Phi(:,nx*(j-1)+1:j*nx)];
  meanx((j-1)*nx+1:j*nx)=Phi(:,(j-1)*nx+1:j*nx)*x0';
  meanc((j-1)*nc+1:j*nc)=CC((j-1)*nc+1:j*nc,:)*meanx((j-1)*nx+1:j*nx);
  meanka((j-1)*nka+1:j*nka)=KA((j-1)*nka+1:j*nka,:)*...
  meanx((j-1)*nx+1:j*nx);
  if mode == 1,
     meania((j-1)*nia+1:j*nia)=IA((j-1)*nia+1:j*nia,:)*...
     meanx((j-1)*nx+1:j*nx);
     meaninc(j)=INC(j,:)*meanx((j-1)*nx+1:j*nx);
     meandinc(j)=DINC(j,:)*meanx((j-1)*nx+1:j*nx);
  end;% for "if mode"
end; % for "for j"

if mode == 1,
   %  Calculate the unconditional state covariance matrices
   %  The variance at time 2 (second period) is v0, which we put
   %  in the first rows of V; the variance at time 3 is in the second 
   %  set of rows of V, and so on.
   %  The variance at time 1 is taken to be zero; modify this if needed.
   %  Note the formula that we use is
   %  Var(1) =V0  where V0 is the variance associated with state
   %              variable x(0) when the cohort is born;
   %  Var(2) = C C' + Ao(1) Var(1) Ao(1)'
   %  Var(3) = C C' + Ao(2) Var(2) Ao(2)'
   %  Var(j) = C C' + Ao(j-1) Var(j-1) Ao(j-1)' 
   %  The variance of consumption at time j is
   %       sc(j)* Var(j) sc(j)'
   %  where sc(j) is the decision rule for consumption applying
   %  at age j.
 
   V=V0;  % V0 is variance matrix of x(0)
   v=V0;

   for j=1:T,                   % calculates var(x(0)), ... , through
     at=Ao(nx*(j-1)+1:j*nx,:);  % var(x(T)).  Var(x(T)) gives the
     v=C*C' +at*v*at';          % variances of kh(T) and ka(T), the
     V(nx*j+1:(1+j)*nx,:)=v;    % amounts of human/physical assets still
   end; % for "for j"           % holding at the end of agents' life

   %  Compute variances of consumption, investment, capital 
   vc=zeros(nc*(T+1),nc);
   vka=zeros(nka*(T+1),nka);
   via=zeros(nia*(T+1),nia);
   vinc=zeros(T+1,1);
   vdinc=zeros(T+1,1);
   % vc: variances of c(0), ..., c(T).
   % vka: variances of ka(0), ..., ka(T).  Also var(ka(-1)) is 
   % given directly in V0.
   for j=1:(T+1),
     vt=V(nx*(j-1)+1:nx*j,:); 
     sc = CC(nc*(j-1)+1:nc*j,:); 
     ska = KA(nka*(j-1)+1:nka*j,:);
     sia =IA(nia*(j-1)+1:nia*j,:);
     sinc=INC(j,:);
     sdinc=DINC(j,:);
     vc(nc*(j-1)+1:nc*j,:)= sc*vt*sc';
     vka(nka*(j-1)+1:nka*j,:)= ska*vt*ska';
     via(nia*(j-1)+1:nia*j,:)= sia*vt*sia';
     vinc(j)=sinc*vt*sinc';
     vdinc(j)=sdinc*vt*sdinc';
   end; % for "for j"

   output2=[meania; via; meaninc; vinc;
            meandinc; vdinc; vc(:,1); vc(:,2); vka; risk; meanx];
           
   output3=[P; V];

end     % end of "if mode"


output1=[meanc; meanka];

