% btaxl.m (a script file)

% government expenditure for medicaid and medicare increases linearly
% over time.
% retirement age is postponed according to the current legislation:
% in year 2008 people 65 and younger will have their retirement age
% postponed by one year, to age 66. in year 2026 people 66 and younger 
% will have their retirement age postponed by an additional year, 
% to age 67.
% starting from year 2000 SOCIAL SECURITY BENEFITS ARE TAXED AT THE 
% LABOR INCOME TAX RATE
% model with exogenous "labor-augmenting" technological process (rho)
% "joy-of-giving" formulation of the economy.
% We simulate an economy with demographic dynamics and an unchanged and
% unfunded social security system in an environment with endogenous
% labor supply.
% The interest rate and the salary are endogenously determined as the
% marginal productivity of capital and labor using an aggregate, Cobb-
% Douglas production function.
% We allow for a lump sum component of the social security benefits
% (fixben=fixrrate*w*wtnbar) and a component proportional
% to the agent's cumulated earnings (and hence contributions).
% The lump sum component of the social security benefits is computed
% for the initial and final steady states and adjusted in five steps
% (the same as taul) during the transition period.

% The starting year is 1975, prior to that the agents behave
% as if their survival probabilities are the ones of people alive
% in 1970. (Therefore before 1975 the economy is in steady state).
% In 1975 the agents realise that the survival prob. tables change
% over time and they start using the correct ones.
% The assumption is that the conditional survival probabilities keep
% changing until 2060 and hence a new demographic steady state is
% reached in 2060+2*T0. Infact, in this formulation with bequests,
% it will take longer to reach the steady state, because people
% that receive a bequest which is not the steady state one will not
% behave as in steady state for the rest of their lives.
% We take as equal in the initial and final steady state the tax
% rate on asset holdings (Taua), the tax rate on consumption (Tauc),
% the lump sum tax (Utau), and the debt/gdp ratio.
% In 1975 the govt announces that starting from year 2000 it will
% increase the tax rate on labor income every ten year, each time
% increasing it  by .2*(tmptran-taul11). From 2040 on the
% tax on labor income will remain constant until 2059. From 2060
% Taul=Taul22 is constant, but the wage rate and the interest rate
% keep oscillating for TT periods.
% This phase is followed by T0 periods during which both w and r are
% pegged at new constant levels.
% The transitional policy is chosen to ensure that the carryover govt
% debt from the transitional era to the new steady state equals gbbar22.

%--------------------------------------------------------------------%
%---------call ssset to define the parameters of the model-----------%
%--------------------------------------------------------------------%

esset;
% ssset sets parameters for the policy-induced transition problem.
% It sets the economic and biological parameters for the private
% agents and age cohorts and the policy parameters for the two
% steady states. 

% define a couple of selection matrices for cumulated past earnings
% and total assets
scel=[zeros(nce,nh+nka) eye(nce, nce) zeros(nce, nz)];  % ce(t-1)
skal = [zeros(nka,nh) eye(nka,nka) zeros(nka,nz+nce)];  % ka(t-1)
sconst = [zeros(1,nh+nka+nce) 1 zeros(1,nz-1)];         % constant
dimension=[nx, nc, nce, nh, nka, nia,nw, ns, nz, nb];


%--------------------------------------------------------------------%
%----------------- compute the initial steady state -----------------%
%--------------------------------------------------------------------%

% First, define parameter values specific to the initial steady state.
relax=1;
tic;
x0=x00;
V0=V00;
beta=Beta(:,1);
frac=Frac(:,1);
khlbar=Khlbar(1);
survival=Survival(:,1);
pop=Pop(1);
T=T0;
G=G11*ones(T0+1,1);
gbbar=gbbar11;
Taul=taul11*ones(T0+1,1);
Taua=taua11*ones(T0+1,1);
Tauc=tauc11*ones(T0+1,1);
Taub=taub11;
Utau=ones(T0+1,1)*utau11;
tmpval=tmpval11;
Tmpstr=Tmpstr11;
tmpstr=tmpstr11;
fixben=fixben11;
Net=zeros(T0+1,1); % this is linked to the taxation of the Soc. Sec. Ben.
                   % since in the initial steady state they are not taxed, 
                   % the vector is formed of zeros

% external loop that iterates on the "joy-of-giving" until convergence
% is reached: the agents receive as a bequest as much assets they leave
diffb=1;
while (diffb) > 1e-06,

  % Call essss to compute the steady state (solves each generation's
  % problem (calling ssec.m file)- and iterates on the govt b.c.
  % -modifying Taul- until convergence on the govt b.c. is reached.

  essss

  x1=x0;
  x0=[0 (1-Taub)*Beq/frac(1) 0 1 0 0 0];
  diffb=max(abs(x1-x0))

end;

% Save the relevant matrices for the initial steady state using names
% ending with 11 to get the initial ss
% save the tax rate that's searched upon.


eval([tmpstr,'11=',sprintf('%14.14f ;',tmpval)]);

% save the endogenous marginal products of capital and labor
gammaa11=gammaa;
gammah11=gammah;

Beq11=(1-Taub)*Beq/frac(1);


meanx11=meanx;
meanka11=meanka;
meanc11=meanc;
meancc11=meancc;
meancn11=meancn;
meania11=meania;
meaninc11=meaninc;
meandinc11=meandinc;

vka11=vka;
vc11=vc;
vcc11=vc11(1:2:2*(T+1)-1,1);
vcn11=vc11(2:2:2*(T+1),2);
via11=via;
V11=V;
vinc11=vinc;
vdinc11=vdinc;

incbar11=frac'*meaninc11;
dincbar11=frac'*meandinc11;
kabar11=frac'*meanka11;
cbar11=frac'*meancc11;
nbar11=frac'*meancn11;
wtnbar11=frac(1:T1+1)'*(meancn11(1:T1+1).*eff);
iabar11=frac'*meania11;

Soc11=Soc;
Tax11=Tax;
Taxl11=Taxl;
Taxa11=Taxa;
Taxc11=Taxc;
Tax011=Tax0;
P11=P;
fixben11=fixben;
Net=taul22*ones(T0+1,1); % initialization to tax soc. sec. ben.
tmpval=tmpval22;

% dispersion of c, ka, and ia in total population

dispcc11=sqrt(frac' * (vcc11 + meancc11.^2) - cbar11^2);
dispcn11=sqrt(frac' * (vcn11 + meancn11.^2) - nbar11^2);
dispka11=sqrt(frac' * (vka11 + meanka11.^2) - kabar11^2);
dispia11=sqrt(frac'* (via11 + meania11.^2) - iabar11^2);
dispinc11=sqrt(frac'* (vinc11 + meaninc11.^2) - incbar11^2);
dispdinc11=sqrt(frac'* (vdinc11 + meandinc11.^2) - dincbar11^2);

value10=zeros(T0+1,1);

for j=0:T0,
  value10(j+1)=meanx((j*nx+1):(j+1)*nx)'*P((j*nx+1):(j+1)*nx,:)...
              *meanx((j*nx+1):(j+1)*nx)+trace(V((j*nx+1):(j+1)*nx,:)*...
              P((j*nx+1):(j+1)*nx,:))+risk(j+1);
end;

% value10(j+1) is the avg expected lifetime future utility of cohort of
% age j
value11=value10(1);      % expected life time value as of age 0.

% end-of-period aggregate capital stock
kpbar11=kabar11-gbbar11;

% per-capita capital at the beginning of the perid
kphat11=kpbar11/(pop*(1+rho));

% amount of gdp that goes to capital
kpshare11=gammaa11*kphat11;

% amount of gdp that goes to labor
lshare11=gammah11*wtnbar11;

gdp11=kpshare11 + lshare11;

% capital/gdp
kp2gdp11=kpbar11/gdp11;

% public expenditure/govt debt
G2debt11=G11/gbbar11;

% debt/gdp
debt2gdp11=gbbar11/gdp11;

% public expenditure/gdp
G2gdp11=G11/gdp11;

income11=[income; Soc]; 

toc
disp('initial steady state with endogenous prices computed')
%--------------------------------------------------------------------%
%------------------- compute the final steady state -----------------%
%--------------------------------------------------------------------%
relax=.7;

tic;
% define the desired new steady state debt/gdp ratio
debt2gdp0=debt2gdp11;

gbbar20=gbbar22;

% initialise some relevant variables
% define the demographic parameters for the final steady state to take into
% account that agents retire two years later
T1=length(newefg3)-1;
T2=T0-T1;
eff=newefg3;

x0=x00;
V0=V00;
beta=Beta(:,n-T0);
frac=Frac(:,size(Frac,2));
khlbar=Khlbar(length(Khlbar));
survival=Survival(:,n);
pop=Pop(n-1);
T=T0;
G=G22*ones(T0+1,1);
Taul=taul22*ones(T0+1,1);
Taua=taua22*ones(T0+1,1);
Tauc=tauc22*ones(T0+1,1);
Taub=taub22;
Utau=ones(T0+1,1)*utau22;
fixben=fixben11;
tmpval=tmpval22;
Tmpstr=Tmpstr22;
tmpstr=tmpstr22;

% external loop that iterates on the "joy-of-giving" until convergence
% is reached: the agents receive as a bequest as much assets they leave
diffb=1;
while (diffb) > 1e-06,


  % the idea is that we adjust gbbar22 so that debt2gdp22=debt2gdp0
  % (we have an external loop so that we get a fixed debt/gdp ratio)

  for xx=1:MAXIT,
    if xx==MAXIT,
       disp('WARNING:max number of iterations reached for xx')
    end; % for "if xx"

    gbbar=gbbar22;

    % call ssss to solve the problem
    essss;
    eval([tmpstr,'22=',sprintf('%14.14f;',tmpval)]);

    Net=taul22*ones(T0+1,1);
    gammaa22=gammaa;
    gammah22=gammah;

    kabar22=frac'*meanka;
    wtnbar22=frac(1:T1+1)'*(meancn(1:T1+1).*eff);

    % end-of-period aggregate capital stock
    kpbar22=kabar22-gbbar22;

    % per-capita capital at the beginning of the perid
    kphat22=kpbar22/(pop*(1+rho));

    % amount of gdp that goes to capital
    kpshare22=gammaa22*kphat22;

    % amount of gdp that goes to labor
    lshare22=gammah22*wtnbar22;

    gdp22=kpshare22 + lshare22;

    % debt/gdp
    debt2gdp22=gbbar22/gdp22;

    diffx=debt2gdp22-debt2gdp0;

    % we now apply the secant algoritm to search over gbbar22
    % until diffx(1)=0
    if abs(diffx) < tol1, 
       % if govt debt to gdp ratio is close enough to the target,
       % exit the loop
       break;
      elseif xx==1,
       gbbar221=gbbar22;
       diffx1=diffx;
       gbbar22=gbbar221+pert;
      else,
       gbbar220=gbbar221;
       diffx0=diffx1;
       gbbar221=gbbar22;
       diffx1=diffx;
       gbbar22=gbbar221-diffx1*(gbbar220-gbbar221)/(diffx0-diffx1)
    end; % for the "if abs" loop

  end; % for the "for xx" loop

  x1=x0;
  x0=[0 (1-Taub)*Beq/frac(1) 0 1 0 0 0];
  diffb=max(abs(x1-x0))

end;

Beq22=(1-Taub)*Beq/frac(1);

meanx22=meanx;
meanka22=meanka;
meanc22=meanc;
meancc22=meancc;
meancn22=meancn;
meania22=meania;
meaninc22=meaninc;
meandinc22=meandinc;

vka22=vka;
vc22=vc;
vcc22=vc22(1:2:2*(T+1)-1,1);
vcn22=vc22(2:2:2*(T+1),2);
via22=via;
V22=V;
vinc22=vinc;
vdinc22=vdinc;
incbar22=frac'*meaninc22;
dincbar22=frac'*meandinc22;
cbar22=frac'*meancc22;
nbar22=frac'*meancn22;
iabar22=frac'*meania22;

% capital/gdp
kp2gdp22=kpbar22/gdp22;

% public expenditure/govt debt
G2debt22=G22/gbbar22;

% public expenditure/gdp
G2gdp22=G22/gdp22;
income22=[income; Soc];


Soc22=Soc;
Tax22=Tax;
Taxl22=Taxl;
Taxa22=Taxa;
Taxc22=Taxc;
Tax022=Tax0;
P22=P;

% dispersion of c, ka, and ia in total population
dispcc22=sqrt(frac' * (vcc22.^2 + meancc22.^2) - cbar22^2);
dispcn22=sqrt(frac' * (vcn22.^2 + meancn22.^2) - nbar22^2);
dispka22=sqrt(frac' * (vka22.^2 + meanka22.^2) - kabar22^2);
dispia22=sqrt(frac'* (via22.^2 + meania22.^2) - iabar22^2);
dispinc22=sqrt(frac'* (vinc22.^2 + meaninc22.^2) - incbar22^2);
dispdinc22=sqrt(frac'* (vdinc22.^2 + meandinc22.^2) - dincbar22^2);

value20=zeros(T0+1,1);
for j=0:T0,
  value20(j+1)=meanx((j*nx+1):(j+1)*nx)'*P((j*nx+1):(j+1)*nx,:)...
               *meanx((j*nx+1):(j+1)*nx)+trace(V((j*nx+1):(j+1)*nx,:)*...
               P((j*nx+1):(j+1)*nx,:))+risk(j+1);
end;

% value20(j+1) is the avg expected lifetime future ut. of cohort of
% age j
value22=value20(1);      % expected life time value as of age 0.

fixben22=fixben;

toc
save btaxl;
disp('second ss with endogenous prices computed');

%--------------------------------------------------------------------%
%------------------- compute the transitional path ------------------%
%--------------------------------------------------------------------%

relax=.2;

% ------- initialisation of  various parameters and matrices --------%
tic;
TT0=TT1+TT+T0; % total # of periods during the transition

% Initialisation of the time path of goverment policy
tmptran=tmptran0;
GG=[linspace(G11,G22,TT1)'; ones(TT0-TT1+1,1)*G22];
TAUL=[ones(TT1,1)*taul11; ones(TT0-TT1+1,1)*taul22];
TAUA=[ones(TT1,1)*taua11; ones(TT0-TT1+1,1)*taua22];
TAUC=[ones(TT1,1)*tauc11; ones(TT0-TT1+1,1)*tauc22];
UTAU=[ones(TT1,1)*utau11; ones(TT0-TT1+1,1)*utau22];
FIXBEN=[ones(TT1,1)*fixben11; ones(TT0-TT1+1,1)*fixben22];
NET=[zeros(TT1,1); ones(TT0-TT1+1,1)*taul22];
% this is for the time path of pension taxation

% Initialise grand matrices MEANX, MEANC, MEANKA, MEANIA, VV, VKA, VIA.
% MEANC(:,i) is a colum vector of the mean of consumption at each age
% for the i-1)th cohort in the transition era, i=2,...,T0+TT1+1 (the
% first cohort only spends their last period in the transition era, and
% so on). MEANC(:,1) gives the mean consumption of the cohorts in the
% initial steady state, and MEANC(:,T0+TT1+2) corresponds to new steady
% state cohorts.

MEANX=[meanx11*ones(1,TT1) meanx22*ones(1,TT0-TT1+2)];
MEANC=[meanc11*ones(1,TT1) meanc22*ones(1,TT0-TT1+2)];
MEANKA=[meanka11*ones(1,TT1) meanka22*ones(1,TT0-TT1+2)];
MEANIA=[meania11*ones(1,TT1) meania22*ones(1,TT0-TT1+2)];
MEANINC=[meaninc11*ones(1,TT0+1) meaninc22];
MEANDINC=[meaninc11*ones(1,TT0+1) meandinc22];
VKA=[vka11*ones(1,TT0+1) vka22];
VIA=[via11*ones(1,TT0+1) via22];
VC=[kron(ones(1,TT0+1),vc11) vc22];
VINC=[vinc11*ones(1,TT0+1) vinc22];
VDINC=[vdinc11*ones(1,TT0+1) vdinc22];
Pstar=[kron(ones(TT1,1),P11(1:nx,:)); kron(ones(TT0-TT1+1,1),P22(1:nx,:))];
value=zeros(1,TT0);

% Initialise the time path of MPK and MPL. MPK and MPL are fixed to their
% final steady state value in the last TT periods.
GAMMAA=gammaa22*ones(TT0+1,1);
GAMMAA(1:TT0-T0)=gammaa11+(gammaa22-gammaa11)*(0:TT0-T0-1)/(TT0-T0-1);
GAMMAH=gammah22*ones(TT0+1,1);
GAMMAH(1:TT0-T0)=wrrat./GAMMAA(1:TT0-T0).^(ksh/(1-ksh));

% Frac and Pgr are also fixed at the final steady state value fot the
% last TT+T0 periods.
Frac=[Frac Frac(:,size(Frac,2))*ones(1,TT+1)];
Pgr=[pgr; Pop(n-1)*ones(TT+1,1)];

% Enlarge Beta for additional periods (TT)
Beta=[Beta Beta(:,length(Beta))*ones(1,TT)];

Survival=[Survival Survival(:, length(Survival))*ones(1,T0)];
Beqtrans=zeros(TT0,1);
% -------------------------------------------------------------------- %
% ------------ the main loop to compute the transition --------------- %
% -------------------------------------------------------------------- %
% initialisation for tmptran
tmptran=tmptran0;

for xx=1:MAXIT, % loop that iterates on MPK, MPL
  if xx==MAXIT,
     disp('WARNING: max # of iteration reached in transit for MPK, MPL');
  end;

  for yy=1:MAXIT,     % adjust tmptran so that the transition path and the
                      % new steady state are connected smoothly.
    if yy == MAXIT,
       disp('WARNING: max. number of iterations reached for yy')
    end;
    ssgovt;
    RR=GAMMAA+dela;

    % ------- loop to compute the behaviour of all cohorts ----------- %
    % ------ during the transition, given the transit. policy -------- %

    for cohort=0:TT0-1, % "cohort+startyear" denotes the calendar time
                        % at the end of which THE cohort totally
                        % disappears
      T=min(cohort,T0); % T+1 is the maximum number of years left from
                        % the beginning of period zero on for
                        % cohort "cohort".
      if cohort < T0,   % for cohorts that were born before time 1975
                        % (the beginning of the transition period)
         % reinitialise demographic parameters at the initial steady state
         % ones, since we start from that point and there is no postponement
         % in the retirement age until 2008

         T1=length(newefg1)-1;
         T2=T0-T1;
         eff=newefg1;

         % use mean and variance of the state variable for cohort
         % "cohort" at announcement time as new initial values
         x0=meanx11((T0-cohort)*nx+1:(T0-cohort+1)*nx)';
         V0=V11((T0-cohort)*nx+1:(T0-cohort+1)*nx,:);


         % for cohorts still working at the announcement time, pick the
         % efficiency indices
         if cohort < 58,
            T1=length(newefg1)-1;
            T2=T0-T1;
            if cohort < T2,
               eff=[];
              else,
               eff=newefg1(T0-cohort+1:T0-T2+1);
            end; % If cohort <T2
           else,
            T1=length(newefg3)-2;
            T2=T0-T1;
            eff=newefg3(T0-cohort+1:T0-T2+1);
         end; % if cohort <58

         
         % pick policy parameters that these cohorts take as exogenous
         G=GG(1:cohort+1);
         Utau=UTAU(1:cohort+1,:);
         Taul=TAUL(1:cohort+1);
         Taua=TAUA(1:cohort+1);
         Tauc=TAUC(1:cohort+1);
         Net=NET(1:cohort+1);
         Fixben=FIXBEN(max(1,cohort-T2+2):cohort+1).*...
               (1+rho).^(min(0,-T2+1+cohort):-1:-T2+1)';

         % pick interest rate
         Gammaa=GAMMAA(1:cohort+1);
         Gammah=GAMMAH(1:cohort+1);

         % pick discount factors for these cohorts
         beta=Beta(T0-cohort+1:T0+1,cohort+1); % currently alive people
                                               % have different betas
         survival=Survival(T0-cohort+1:T0,cohort+1);

        else,   % for cohort born at or after "startyear" (during the
                % transition)
         if cohort <= 75,
            T1=length(newefg3)-2;
            T2=T0-T1;
            eff=newefg3(1:T1+1);
           else,
            T1=length(newefg3)-1;
            T2=T0-T1;
            eff=newefg3(1:T1+1);
         end; % if cohort <=75
            
         x0=x00;
         V0=V00;
         if cohort==T0,
            x0=meanx11(1:nx)';
           else,
            x0(2)=(1-taub)*Frac(T0+1,cohort-T0+1)*...
                   MEANKA(T0*nka+1:(T0+1)*nka, cohort-T0+1)/...
                   (Frac(1, cohort-T0+2)*Pgr(cohort-T0+1));
            for j=1:T0,
              x0(2)=x0(2)+(1-taub)*(1-Survival(T0+1-j, j+cohort-T0))*....
                    Frac(T0+1-j, cohort-T0+1)*...
                    MEANKA((T0-j)*nka+1:(T0-j+1)*nka, j+cohort-T0+1)/...
                    (Frac(1, cohort-T0+2)*Pgr(cohort-T0+1));
            end; % for j
         end; % if cohort;

         Beqtrans(cohort+1)=x0(2);
         beta=Beta(:,cohort+1);
         survival=Survival(:,cohort+1);

         % the moving window of the transition policy parameters during
         % the lifetime of cohort "cohort"
         G=GG(cohort-T0+1:cohort+1);
         Utau=UTAU(cohort-T0+1:cohort+1,:);
         Taul=TAUL(cohort-T0+1:cohort+1);
         Taua=TAUA(cohort-T0+1:cohort+1);
         Tauc=TAUC(cohort-T0+1:cohort+1);
         Net=NET(cohort-T0+1:cohort+1);
         Fixben=FIXBEN(cohort-T2+2:cohort+1).*(1+rho).^(0:-1:-T2+1)';

         % pick interest rate
         Gammaa=GAMMAA(cohort-T0+1:cohort+1);
         Gammah=GAMMAH(cohort-T0+1:cohort+1);

      end; % for "if cohort <T0"

      % after redefining T, x0, V0, beta, eff, and policy G, Utau,
      % Taul, Taua, solve the problem for "cohort"
      input1=[G; Taul; Taua; Tauc; beta; eff; ud1'; x0'; scel'; skal'; ...
              sconst'; rrate];
      input2=[PT2, sig, T, T2, lambda', dela, phic, deltah, thetah];
      input3=[pih(:,(size(pih,2)-nc*(T+1)+1):size(pih,2)), ub];

      [output1,output2,output3]=essec(1, PT1, V0, input3, Utau, c2, ...
                                      a22, dimension, input1, input2, ...
                                      Fixben, Net, Gammaa, Gammah, survival,...
                                      beta0, rho);

      meanc=output1(1:2*(T+1));
      meanka=output1(2*(T+1)+(1:T+1));
      meania=output2(1:T+1);
      via=output2(T+1+(1:T+1));
      meaninc=output2(2*(T+1)+(1:T+1));
      vinc=output2(3*(T+1)+(1:T+1));
      meandinc=output2(4*(T+1)+(1:T+1));
      vdinc=output2(5*(T+1)+(1:T+1));
      vc=zeros(nc*(T+1),nc);
      vc(:,1)=output2(6*(T+1)+1:8*(T+1));
      vc(:,2)=output2(8*(T+1)+1:10*(T+1));
      vka = output2(10*(T+1)+(1:T+1));
      risk=output2(11*(T+1)+(1:T+2));
      meanx=output2(12*(T+1)+2:length(output2));


      P=output3(1:(T+2)*nx,:);
      %V=output3((T+2)*nx+1:(2*T+3)*nx,:);

      % Stack the outputs into grand-grand matrices

      if cohort < T0, % for cohorts born before time 0.
         MEANX((T0-cohort)*nx +1:(T0+1)*nx,2+cohort)=meanx;
         MEANC((T0-cohort)*nc +1:(T0+1)*nc,2+cohort)=meanc;
         MEANKA((T0-cohort)*nka+1:(T0+1)*nka,2+cohort)=meanka;
         MEANIA((T0-cohort)*nia+1:(T0+1)*nia,2+cohort)=meania;
         MEANINC((T0-cohort) +1:(T0+1),2+cohort)=meaninc;
         MEANDINC((T0-cohort) +1:(T0+1),2+cohort)=meandinc;
         VKA((T0-cohort)*nka+1:(T0+1)*nka,...
             (1+cohort)*nka+1:(2+cohort)*nka)=vka;
         VC((T0-cohort)*nc +1:(T0+1)*nc,...
            (1+cohort)*nc +1:(2+cohort)*nc )=vc;
         VIA((T0-cohort)*nia+1:(T0+1)*nia,...
             (1+cohort)*nia+1:(2+cohort)*nia)=via;
         VINC((T0-cohort) +1:(T0+1),2+cohort )=vinc;
         VDINC((T0-cohort) +1:(T0+1),2+cohort )=vdinc;
         Pstar((cohort+1)*nx+1:(cohort+2)*nx,:)=P(1:nx,:);
         value(cohort+1)=meanx11((T0-cohort)*nx+1:(T0-cohort+1)*nx)'*...
                     P(1:nx,:)*meanx11((T0-cohort)*nx+1:(T0-cohort+1)*nx)+...
                     trace(V11((T0-cohort)*nx+1:(T0-cohort+1)*nx,:)*...
                     P(1:nx,:))+risk(1);

        else     % For cohorts born after time 0

         MEANX(1:(T0+1)*nx,2+cohort)=meanx;
         MEANC(1:(T0+1)*nc,2+cohort)=meanc;
         MEANKA(1:(T0+1)*nka, 2+cohort)=meanka;
         MEANIA(1:(T0+1)*nia, 2+cohort)=meania;
         MEANINC(1:(T0+1),  2+cohort)=meaninc;
         MEANDINC(1:(T0+1),  2+cohort)=meandinc;
         VKA(1:(T0+1)*nka, (1+cohort)*nka+1:(2+cohort)*nka)=vka;
         VC(1:(T0+1)*nc,  (1+cohort)*nc +1:(2+cohort)*nc )=vc;
         VIA(1:(T0+1)*nia, (1+cohort)*nia+1:(2+cohort)*nia)=via;
         VINC(1:(T0+1),  2+cohort )=vinc;
         VDINC(1:(T0+1), 2+cohort )=vdinc;
         Pstar((cohort+1)*nx+1:(cohort+2)*nx,:)=P(1:nx,:);
         value(cohort+1)=x0*P(1:nx,:)*x0'+trace(V0*P(1:nx,:))+risk(1);

      end; % for "if cohort <T0"

    end;  % for  "for cohort=0:TT0-1"


    % rearrange MEANC and create MEANCC and MEANCN (these matrices
    % contain for column j consumption (or labor, respectively)
    % for the (j-1)-th generation at different ages
    select1=1:nc:nc*T0+1;
    select2=2:nc:nc*(T0+1);
    MEANCC=MEANC(select1,:);
    MEANCN=MEANC(select2,:);  clear select1 select2


    % ------ compute aggr. variables over transition and bookkeep ---- %
    % ------ net carryover government debt in the new ss to apply ---- %
    % -------------------- the secant search algorithm --------------- %

    kp0bar= kpbar11;
    % kbar(-1), aggregate physical capital at end of time -1 (still in 
    % the initial steady state). 


    cbar=zeros(TT0,1); % Initialization of the Aggregate Vectors
    nbar=cbar;
    incbar=cbar;
    dincbar=cbar;
    wtnbar=cbar;
    kpbar=cbar;
    kabar=cbar;


    % "time" is calendar time. At date TT0 the economy enters new steady 
    % state. bbar(TT0) is carryover government debt into new ss.

    eff=[eff; zeros(T2,1)];

    for time=0:TT0-1,
      if time < 33,  % 0 is 1975. until time < 23, they retire as in 1st ss
         T1=length(newefg1)-1; 
         T2=T0-T1;
         eff=[newefg1; zeros(T2,1)];
        elseif time >=33 & time <51, % 2008: ret. age is postponed of 1 year
         T1=length(newefg3)-2; 
         T2=T0-T1;             
         eff=[newefg3(1:T1+1); zeros(T2,1)];
        else
         T1=length(newefg3)-1; 
         T2=T0-T1;             
         eff=[newefg3(1:T1+1); zeros(T2,1)];
       end;

      frac=Frac(:,time+2);
      pop=Pgr(time+1);
      % Contribution to aggregate vectors from cohorts born at or after
      % date TT0-T0=TT1+TT (these cohorts are new steady state guys)

      if time >= TT0-T0
         cbar(time+1)=frac(1:time+1-TT0+T0)'*...
                      MEANCC(1:time+1-TT0+T0,TT0+2);
         nbar(time+1)=frac(1:time+1-TT0+T0)'*...
                      MEANCN(1:time+1-TT0+T0,TT0+2);
         wtnbar(time+1)=frac(1:time+1-TT0+T0)'*...
                      (MEANCN(1:time+1-TT0+T0,TT0+2).*eff(1:time+1-TT0+T0));
                      % wtnbar takes into account the efficiecy index
         kabar(time+1)=frac(1:time+1-TT0+T0)'*...
                       MEANKA(1:time+1-TT0+T0,TT0+2);
      end; % for "if time"

      % contributions to these aggregates by cohorts born before date
      % TT1+TT.(these cohorts are affected by transitional policies)

      for tt=max(1, time+2-TT0+T0):T0+1,
        cbar(time+1)=frac(tt)*MEANCC(tt,T0+time+3-tt)+cbar(time+1);
        nbar(time+1)=frac(tt)*MEANCN(tt,T0+time+3-tt)+nbar(time+1);
        wtnbar(time+1)=frac(tt)*MEANCN(tt,T0+time+3-tt)*eff(tt)...
                       +wtnbar(time+1);
        kabar(time+1)=frac(tt)*MEANKA(tt,T0+time+3-tt)+kabar(time+1);       
      end; % for "for tt"


      % Use non-stationary economy-wide resource constraint at date
      % "time" to compute end-of-period physical capital stock to be
      % carried over into date "time+1", given end-of-period physical
      % capital stock in date "time-1" (carried into date "time").

      kpbar(time+1)=RR(time+1)/(1+rho)*(kp0bar/pop) - GG(time+1) - ...
                    phic*cbar(time+1) +...
                    GAMMAH(time+1)*wtnbar(time+1);

      kp0bar=kpbar(time+1);

    end;  % for "for time=0:TT0-1" loop (aggr. for all time periods are
          % computed)

    % Government debt = total asset - physical capital (all end-of-period,
    % in per capita terms)
    bbar=kabar-kpbar;

    % government carryover debt into the new steady state
    carryover=bbar(TT0);
    diffy=carryover-gbbar22;

    % now apply the secant search algoritm to find tmptran, the
    % temporary transitional parameter defined in ssgovt
    if abs(diffy) < tol1,
       % if govt carryover is close enough to gbbar22, exit the loop.
       % the value of tmptran has been found
       break;
      elseif yy==1,
       tmptran1=tmptran;
       diffy1=diffy;
       tmptran=tmptran+pert;
      else,
       tmptran0=tmptran1;
       diffy0=diffy1;
       tmptran1=tmptran;
       diffy1=diffy;
       tmptran=tmptran1-diffy1*(tmptran0-tmptran1)/(diffy0-diffy1)
    end; % for "if"

  end; % for "for yy"

  % time path of the beginning of the period per capita aggregate
  % stock, to be used in the aggregate production function
  kphat=kpbar./(Pgr(2:TT0+1)*(1+rho));
  kphat=[kphat11; kphat(1:length(kphat)-1)];

  % hence the time path of MPK is
  Rstar=CD*ksh*(wtnbar./kphat).^(1-ksh);

  % we need to take care of the possibility that labor and capital
  % may become negative for low values of w and r (hence w and r would
  % in turn become immaginary
  tempo=GAMMAA(1:TT0-T0);
  t1=find(wtnbar<0)
  Rstar(t1)=tempo(t1)/1.5;
  t2=find(kphat<0)
  Rstar(t2)=tempo(t2)*1.5;
  clear tempo, t1, t2;
  
  if max(abs(Rstar(1:TT0-T0)-GAMMAA(1:TT0-T0))) < tol1/20,
     break;
    else,
     GAMMAA(1:TT0-T0)=(1-relax)*GAMMAA(1:TT0-T0)+relax*Rstar(1:TT0-T0)
     GAMMAH(1:TT0-T0)=wrrat./GAMMAA(1:TT0-T0).^(ksh/(1-ksh));
  end; % for if

end; % for xx
toc;

% ------------------------------------------------------------------- %
% ------------ compute other useful economic variables -------------- %
% ------------------------------------------------------------------- %
% Initialisation for the vectors containing the mean standard deviations
% of consumption, labor, asset holdings, income and net income
% computed for the transition period, over the agents alive at a given
% moment in time.
DISPCC=zeros(TT0,1);
DISPCN=zeros(TT0,1);
DISPKA=zeros(TT0,1);
DISPINC=zeros(TT0,1);
DISPDINC=zeros(TT0,1);

% create the matrices containing the variance of consumption for a given
% cohort (column) during the transition
VCC=VC(1:2:2*(T+1)-1,1:2:2*(TT0+2)-1);
VCN=VC(2:2:2*(T+1),2:2:2*(TT0+2));

% these dispersions are computed in two steps: the one in the loop
% "for time" is the first one and computes the relevant second moments.
% I then subtract the corresponding vector of means (squared) and take
% the square root to get the desired standard deviation

for time=0:TT0-1,
  frac=Frac(:,time+2);
  % Contribution to aggregate vectors from cohorts born at or after
  % date TT0-T0=TT1 (these cohorts are new steady state guys)
  if time >= TT0-T0
     incbar(time+1)=frac(1:time+1-TT0+T0)'*MEANINC(1:time+1-TT0+T0,TT0+2);
     dincbar(time+1)=frac(1:time+1-TT0+T0)'*MEANDINC(1:time+1-TT0+T0,TT0+2);
     DISPCC(time+1)=frac(1:time+1-TT0+T0)'*(VCC(1:time+1-TT0+T0,TT0+2)+...
                    MEANCC(1:time+1-TT0+T0,TT0+2).^2);
     DISPCN(time+1)=frac(1:time+1-TT0+T0)'*(VCN(1:time+1-TT0+T0,TT0+2)+...
                    MEANCN(1:time+1-TT0+T0,TT0+2).^2);
     DISPKA(time+1)=frac(1:time+1-TT0+T0)'*(VKA(1:time+1-TT0+T0,TT0+2)+...
                    MEANKA(1:time+1-TT0+T0,TT0+2).^2);
     DISPINC(time+1)=frac(1:time+1-TT0+T0)'*(VINC(1:time+1-TT0+T0,TT0+2)+...
                     MEANINC(1:time+1-TT0+T0,TT0+2).^2);
     DISPDINC(time+1)=frac(1:time+1-TT0+T0)'*(VDINC(1:time+1-TT0+T0,TT0+2)+...
                     MEANDINC(1:time+1-TT0+T0,TT0+2).^2);
   end; % for "if time"
   % contributions to these aggregates by cohorts born before date
   % TT1.(these cohorts are affected by transitional policies)
   for tt=max(1, time+2-TT0+T0):T0+1,
     incbar(time+1)=frac(tt)*MEANINC(tt,T0+time+3-tt)+incbar(time+1);
     dincbar(time+1)=frac(tt)*MEANDINC(tt,T0+time+3-tt)+dincbar(time+1);
     DISPCC(time+1)=frac(tt)*(VCC(tt,T0+time+3-tt)+...
                    MEANCC(tt,T0+time+3-tt).^2)+DISPCC(time+1);
     DISPCN(time+1)=frac(tt)*(VCN(tt,T0+time+3-tt)+...
                    MEANCN(tt,T0+time+3-tt).^2)+DISPCN(time+1);
     DISPKA(time+1)=frac(tt)*(VKA(tt,T0+time+3-tt)+...
                    MEANKA(tt,T0+time+3-tt).^2)+DISPKA(time+1);
     DISPINC(time+1)=frac(tt)*(VINC(tt,T0+time+3-tt)+...
                    MEANINC(tt,T0+time+3-tt).^2)+DISPINC(time+1);
     DISPDINC(time+1)=frac(tt)*(VDINC(tt,T0+time+3-tt)+...
                    MEANDINC(tt,T0+time+3-tt).^2)+DISPDINC(time+1);
   end; % for "for tt"
end; % for time
DISPCC=sqrt(DISPCC-cbar.^2);
DISPCN=sqrt(DISPCN-nbar.^2);
DISPKA=sqrt(DISPKA-kabar.^2);
DISPINC=sqrt(DISPINC-incbar.^2);
DISPDINC=sqrt(DISPDINC-dincbar.^2);


%for time=0:TT0-T0,
 % if time >= TT1 
      %kalbar(time+1)=frac(1:time+1-TT0+T0)'*MEANKAL(1:time+1-TT0+T0,TT0+1);
      %iabar(time+1)=frac(1:time+1-TT0+T0)'*MEANIA(1:time+1-TT0+T0,TT0+1);
  % end; % for "if time"
  % for tt=max(1, time+2-TT1):T0+1,
     %kalbar(time+1)=frac(tt)*MEANKAL(tt, T0+time+3-tt)+ kalbar(time+1);
     %iabar(time+1)=frac(tt)*MEANIA(tt, T0+time+3-tt) + iabar(time+1);
  % end; % for "for tt"
%end; 
clear MEANKAL
 
kpbar=[kpbar11; kpbar];
cbar=[cbar11; cbar];
nbar=[nbar11; nbar];
wtnbar=[wtnbar11; wtnbar];
iabar=[iabar11; iabar];  % per capita aggregate consumption, private 
bbar=[gbbar11; bbar];    % investment in assets, holding of govt debt,
kabar=[kabar11; kabar];  % and holding of assets.

% compute gross domestic product and net domestic product
% contribution to gross domestic product from capital stock is computed
% using the private stock of physical capital at end of the previous
% period.

kphat=kpbar(1:TT0+1)/(pop*(1+rho));
gdp=GAMMAA.*kphat+ GAMMAH.*wtnbar;
ndp=(RR-1).*kphat + GAMMAH.*wtnbar; 

kphat=[kphat11; kphat];


% various tax revenues of the government from date 0 till end of
% transition.  Taxes on labor (human capital) and return of asset
% holding are related to beginning of period stocks of each capital.
 
%taxlbar=taul11*gammah*w*wtnbar; % aggr. per capita tax on labor, return
%taxabar=taua11*(RR-1).*kalbar; % from asset holding, and on bequests
%taxbbar=RR*(kabar(1:TT0+1)/pop - kalbar + frac(1)*x00(nh+1:nh+nka));  

%taxlbar=[Taxl11; taxlbar];
%taxabar=[Taxa11; taxabar];
%taxbbar=[Beq11; taxbbar];

%taxbar=taxlbar+taxabar+taxbbar;  % total tax per capita

%TAUL=[taul11; TAUL];
%TAUA=[taua11; TAUA];
%UTAU=[utau11; UTAU];
%GG=[G11; GG]; 

%ssbar=SS * sum(frac(T0+2-T2:T0+1)); % Along transition path: 
%net_tax=taxbar-ssbar;               % per capita aggregate soc. sec.
%prisav=gdp-net_tax-phic*cbar; % payment, net tax, private savings,
%dincome = gdp - net_tax;            % disposable income, total savings
%totsav=gdp-phic*cbar-G11;     % (private plus public savings), as well
%psrate=prisav./dincome;             % as priv. and total savings rates.
%tsrate=totsav./dincome;

%comp2gdp11=frac(T0+1:-1:1)' * comp /gdp11;

save btaxl












