(TeX-add-style-hook
 "Readme"
 (lambda ()
   (TeX-add-to-alist 'LaTeX-provided-class-options
                     '(("article" "a4paper" "12pt")))
   (TeX-add-to-alist 'LaTeX-provided-package-options
                     '(("natbib" "longnamesfirst") ("xy" "dvips") ("inputenc" "utf8") ("fontenc" "T1") ("geometry" "margin=1in")))
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "hyperref")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "hyperimage")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "hyperbaseurl")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "nolinkurl")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "url")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "path")
   (add-to-list 'LaTeX-verbatim-macros-with-delims-local "url")
   (add-to-list 'LaTeX-verbatim-macros-with-delims-local "path")
   (TeX-run-style-hooks
    "latex2e"
    "article"
    "art12"
    "fullpage"
    "varioref"
    "dcolumn"
    "booktabs"
    "amsmath"
    "setspace"
    "epstopdf"
    "natbib"
    "hyperref"
    "xy"
    "graphicx"
    "amsfonts"
    "amssymb"
    "placeins"
    "pdfpages"
    "amsthm"
    "tabularx"
    "inputenc"
    "fontenc"
    "geometry"
    "lmodern"
    "helvet")
   (TeX-add-symbols
    '("linespacing" 1)
    "sgn")
   (LaTeX-add-labels
    "sec:psidtransformation")
   (LaTeX-add-environments
    "romlist"
    "alphlist")
   (LaTeX-add-bibliographies
    "../../GonzaloBiblio")
   (LaTeX-add-counters
    "Corollary"
    "Lemma"
    "Proposition"
    "Remark"
    "romnum"
    "alphnum")
   (LaTeX-add-amsthm-newtheorems
    "theorem"
    "acknowledgement"
    "algorithm"
    "axiom"
    "assumption"
    "case"
    "claim"
    "conclusion"
    "condition"
    "conjecture"
    "corollary"
    "criterion"
    "definition"
    "example"
    "exercise"
    "lemma"
    "notation"
    "problem"
    "proposition"
    "remark"
    "solution"
    "summary")))

