## GRAPH FUNCTIONS

library(RColorBrewer)
library(zoo)
library(scales)

cond.age.moments <- function(df,xaxis,yaxis,groupvar,xlabel,varname,graphname,ylim=NULL,nolegend=0,
                             titulo=NULL,fsize=14,ratio=NULL,lwidth=0.3,legend.pos) {
  # x <- data.frame or data.table where values are stored
  # xaxis <- name of x-axis variable
  # yaxis <- name of y-axis variable
  # groupvar <- name of group variable
  # varname <- variable name for the y axis
  # graphname <- name for graph
  # code assumes there is a variable "folder" where we want to store it
  gg_color_hue <- function(n) {
    hues = seq(15, 375, length = n + 1)
    hcl(h = hues, l = 65, c = 100)[1:n]
  }
  
  # Guide for the type of graphs
  
  # nolegend == 7 : black and white, no legend
  # nolegend == 8 : black and white, choose legend position. Need to specify ratio.
  
  if (nolegend==7) {
    y <- ggplot(df,aes(x=get(xaxis,as.environment(df)),
                       y=get(yaxis,as.environment(df)),
                       group=get(groupvar,as.environment(df)),
                       linetype=get(groupvar,as.environment(df)))) + geom_line(size=lwidth)+
      scale_x_continuous(name=xlabel,expand=c(0,0),
                         breaks=seq(0,100,20),labels=seq(0,100,20),lim=c(0,100)) +
      scale_y_continuous(name=varname,lim=ylim) +
      ggtitle(titulo) +
      # The below can manually adjust colours and shapes of lines
      # but not very readable
      # if activating it, eliminate labs colour
      scale_linetype_manual(values=c("solid","dotted","dashed","solid","solid","solid",
                                     "solid"),name="Age group",
                            labels=levels(get(groupvar,as.environment(df)))) +
      #scale_colour_manual(name="Age group",
      #                    values=gg_color_hue(7),
      #                    labels=levels(get(groupvar,as.environment(df))))+
      #labs(colour="Age group") +
      theme_light() +
      theme(axis.text=element_text(size=fsize),
            axis.title=element_text(size=fsize),legend.position="none",
            legend.text=element_text(size=fsize),legend.title=element_text(size=fsize),
            plot.title=element_text(hjust=0.5,size=24,face="bold")) +
      theme(plot.margin=unit(c(0.25,0.4,0.25,0.25),"cm"))
    ggsave(filename=paste(folder,graphname,sep=""),plot=y,width=8,height=6)
  } else if (nolegend==8) {
    y <- ggplot(df,aes(x=get(xaxis,as.environment(df)),
                       y=get(yaxis,as.environment(df)),
                       group=get(groupvar,as.environment(df)),
                       linetype=get(groupvar,as.environment(df)))) + geom_line(size=lwidth)+
      scale_x_continuous(name=xlabel,expand=c(0,0),
                         breaks=seq(0,100,20),labels=seq(0,100,20),lim=c(0,100)) +
      scale_y_continuous(name=varname,lim=ylim) +
      
      scale_linetype_manual(values=c("solid","dotted","dashed","solid","solid","solid",
                                     "solid"),name="Age group",
                            labels=levels(get(groupvar,as.environment(df))))+
      ggtitle(titulo) +
      labs(linetype="Age group") +
      theme_light() +
      theme(axis.text=element_text(size=fsize),
            axis.title=element_text(size=fsize),legend.position="right",
            legend.text=element_text(size=fsize),legend.title=element_text(size=fsize),
            plot.title=element_text(hjust=0.5,size=24,face="bold"),
            legend.key=element_rect(size=5),legend.key.size=unit(3,'lines')) +
      theme(plot.margin=unit(c(0.25,0.4,0.25,0.25),"cm")) + coord_fixed(ratio=ratio)
    ggsave(filename=paste(folder,graphname,sep=""),plot=y,width=10,height=6)
  }
  
  
  return(y)
}

grafico.varias.lineas <- function(df,xaxis,yaxis,groupvar,xlabel,ylabel,graphname,ylim=NULL,xticks=NULL,
                                  lwidth=0.3,fsize=15){
  
  if (is.null(xticks)){
    xticks <- waiver()
    minticks <- NULL
    maxticks <- NULL
  } else {
    minticks <- min(xticks)
    maxticks <- max(xticks)
  }
  
  y <- ggplot(df,aes(x=get(xaxis,as.environment(df)),
                     y=get(yaxis,as.environment(df)),
                     colour=get(groupvar,as.environment(df)),
                    group=get(groupvar,as.environment(df)))) +
    geom_line() +
    scale_x_continuous(name=xlabel,expand=c(0,0),breaks=xticks,labels=xticks,lim=c(minticks,
                                                                                   maxticks)) +
    scale_y_continuous(name=ylabel,lim=ylim) +
    theme_light() + geom_line(size=lwidth) +
    theme(axis.text=element_text(size=fsize,face="bold"),
          axis.title=element_text(size=fsize,face="bold"),
          legend.position="bottom",legend.title=element_blank(),
          legend.text=element_text(size=fsize))+
    theme(plot.margin=unit(c(0.25,0.4,0.25,0.25),"cm"))

  ggsave(filename=paste(folder,graphname,sep=""),plot=y,width=8,height=6)
  
  return(y)
}

grafico.varias.lineas.bn <- function(df,xaxis,yaxis,groupvar,xlabel,ylabel,graphname,ylim=NULL,xticks=NULL,
                                  lwidth=0.3,fsize=15){
  
  if (is.null(xticks)){
    xticks <- waiver()
    minticks <- NULL
    maxticks <- NULL
  } else {
    minticks <- min(xticks)
    maxticks <- max(xticks)
  }
  
  y <- ggplot(df,aes(x=get(xaxis,as.environment(df)),
                     y=get(yaxis,as.environment(df)),
                     linetype=get(groupvar,as.environment(df)),
                     group=get(groupvar,as.environment(df)))) +
    geom_line(size=lwidth) +
    scale_x_continuous(name=xlabel,expand=c(0,0),breaks=xticks,labels=xticks,lim=c(minticks,
                                                                                   maxticks)) +
    scale_y_continuous(name=ylabel,lim=ylim) +
    scale_linetype_manual(values=c("solid","dashed","dotted","dotdash","longdash","twodash",
                                   "solid"),name="Age group",
                          labels=levels(get(groupvar,as.environment(df))))+
    theme_light() +
    theme(axis.text=element_text(size=fsize,face="bold"),
          axis.title=element_text(size=fsize,face="bold"),
          legend.position="bottom",legend.title=element_blank(),
          legend.text=element_text(size=fsize),legend.key.size=unit(3,'lines'))+
    theme(plot.margin=unit(c(0.25,0.4,0.25,0.25),"cm"))
  
  ggsave(filename=paste(folder,graphname,sep=""),plot=y,width=8,height=6)
  
  return(y)
}