*We originally generated matches in stata version 16, we enforce backwards compatability here:
stata version 16
# delimit ; 
clear; 
set mem 300m;	
set more 1 ;  
drop _all;
program drop _all;
cd "D:\Dropbox\ERIC_couples\NewPC\Exported Sim data\getmatch";
cap log close;
log using "getmatch_rm_match_died_after_3_or_4_or_5_waves_tighter_assets_correct_topcoding_09042021.log", replace;
use dataprep2_4states_NEW20190702;

*First restructure Data around Events;
*To do this, it is essential that we calculate the correct wave of death-wave;
*Because households actually die between waves, use 2nd wave;

gen manwave=wave if mandied==1;
gen womanwave=wave if womandied==1;

*use the fact that max of missings and nonmissing returns the non missing value;
egen mandiedwave=max(manwave), by(HHID);
egen womandiedwave=max(womanwave), by(HHID);

*generate evercouple id;
egen evercouple=max(couple), by(HHID);

*The first and last death (only really relevant for couples);
gen firstdiedwave=min(womandiedwave,mandiedwave) if evercouple==1;
gen lastdiedwave=max(womandiedwave,mandiedwave);

*Households who are "single", but first appear at a spousal death;
replace lastdiedwave=. if lastdiedwave==firstwave & evercouple==0;

* drop manwave womanwave;

*Now make sure that lastdied and firstdied only apply appropriately;
*replace if they are picking up the same event i.e. lastdied hasn't happened yet;
gen indicator=(hhstatus==0);

egen observe_alldead=max(indicator), by(HHID);
replace lastdiedwave=. if evercouple==1 & observe_alldead==0; 

drop observe_alldead indicator;

*restructure around mandied and womandied;
*These variables all contain the calender time dimension re
gen event_mandied=wave-mandiedwave;
gen event_womandied=wave-womandiedwave;
gen event_lastdied=wave-lastdiedwave;
gen event_firstdied=wave-firstdiedwave;

gen years_last=2*event_lastdied;
gen years_first=2*event_firstdied;

* estimate wealth decline\medical expense rise right before death;
*****************************************************************;
* robustness checks                                              ;
* top coding for assets                                          ;
* what to do with households where hhstatus=3 in wave 1             ;
* keep wave 1, versus drop it                                    ;
*****************************************************************;

*sum assets if evercouple==1 & years_first<2, det;
*gen maxasscouples=r(p99); * replace assets=. if  assets>maxass;
gen keepcoup=2; * 0 => drop if ever part of a couple, 1 => drop if 
currently part of a couple, 2=> keep couples;

*sum assets if evercouple==0 | years_first>0, det;
*gen maxasssingles=r(p99); * replace assets=. if  assets>maxass;

*Number of waves around which we define control group:;
local window_control=2;
/*
* topcoding here;
sum estate assets;
tab estate if estate>maxasscouples & evercouple==1 & years_first<2;
tab estate if estate>maxasssingles & (evercouple==0 | years_first>0);
replace estate=. if estate>maxasscouples & evercouple==1 & years_first<2;
replace estate=. if estate>maxasssingles & (evercouple==0 | years_first>0);
sum estate assets;
replace assets=. if  assets>maxasscouples & evercouple==1 & years_first<2;
replace assets=. if  assets>maxasssingles & (evercouple==0 | years_first>0);
*/
gen testcouples = 0;
replace testcouples = 1 if (evercouple==1 & years_first<2);

sum assets if testcouples==1, det;
gen maxasscouples=r(p99); 
sum assets if testcouples==0, det;
gen maxasssingles=r(p99); 
*sum amothers, det;
*gen maxamothers=r(p99);
sum amothers if testcouples==1, det;
gen maxamotherscouples=r(p99); 
sum amothers if testcouples==0, det;
gen maxamotherssingles=r(p99); 

* topcoding here;
sum estate assets amothers;
tab estate if estate>maxasscouples & testcouples==1;
tab estate if estate>maxasssingles & testcouples==0;
drop if estate>maxasscouples & estate ~=. & testcouples==1;
drop if estate>maxasssingles & estate ~=. & testcouples==0;
drop if  assets>maxasscouples & assets ~=. & testcouples==1;
drop if  assets>maxasssingles & assets ~=. &testcouples==0;
*drop if amothers>maxamothers & amothers ~=.;
drop if  amothers>maxamotherscouples & amothers ~=. & testcouples==1;
drop if  amothers>maxamotherssingles & amothers ~=. &testcouples==0;
sum estate assets amothers;


* focus only on singles?; 
tab hhstatus;
gen dumpthis=0;
replace assets = . if hhstatus==3 & keepcoup~=2;
replace dumpthis=1 if hhstatus==3;
egen num=sum(dumpthis), by (HHID);
drop if dumpthis==1 & keepcoup==1;
drop if num>0 & keepcoup==0;
tab hhstatus;

sort hhstatus;
by hhstatus: sum assets estate;
replace assets=estate if (hhstatus==0 | (assets==. & estate~=.));


* note: check how often the couple dies at the same time;
sort HHID wave;
gen chk=0;
replace chk=1 if hhstatus==0 & hhstatus[_n-1]==3 & HHID==HHID[_n-1];
sum chk;


* eliminate irrelevant observations;
gen dropme=0;
replace dropme=1 if hhstatus[_n-1]==0 & HHID==HHID[_n-1];
replace assets=. if dropme==1;

***************************************************************************************************;
* next                                                                                           ;
* hotdeck "donor" individuals who wave the same sex, age in wave 1, initial wealth and PI as those who die;
* note that we will want to "kill" them at the same time as the truely deceeased died              ;
* once we generate the donor sample, we will want to run all the regressions above on the donor sample;
***************************************************************************************************;
*NOTE: by  matching on wave1 age we implicitly match on cohort;
sort HHID wave;

gen w3wealth = assets if wave ==3;
egen w3iwealth = max(w3wealth), by(HHID);
drop w3wealth;

gen w3hhstatus = hhstatus if wave == 3;
egen w3ihhstatus = max(w3hhstatus), by(HHID);
drop w3hhstatus;

drop if w3iwealth==.|w3ihhstatus==.;

local matchnum = 1;

drop dead;
gen dead=0;
replace dead=1 if hhstatus==0; * note, there are a few households that have hhstatus==., given the use of the "dead" variable, I think this is OK;
replace dead=1 if hhstatus~=w3ihhstatus & hhstatus~=.; *this gives the case where there is a member that dies, by conditioning on initial marital status in hotdeck this will be sufficient;
sort HHID wave;
replace dead=1 if dead[_n-1]==1 & HHID==HHID[_n-1];
sum wave, det;
drop if dead==. & wave==r(max); 

*deadwave is used to create the control group;
gen ideadwave=.;
replace ideadwave=wave if dead[_n-1]==0 &dead[_n]==1 & HHID==HHID[_n-1];
egen deadwave=max(ideadwave), by(HHID);

egen dflagger = max(dead), by(HHID);
sum dflagger;

gen matchmarker = 0;
gen matchmarker_alt = 0;
gen nomatcher = 0;
gen HHIDdonor = 0;
gen HHIDdonor_alt = 0;
gen gooddeath = 0;

local nomatch = 0;
local totalobs=_N;

*export excel using "prepped_for_matching_new_12062019.xlsx", firstrow(variables) replace;

set seed 2627885;


*match only for people who die after 2 years in the sample (which effectively runs from wave 3);
*Phil used to match on whether or not they had died by wave 6 and were alive by wave 6. Doing something like this with 12 waves of data would be crazy;
*Instead - define the donor window as households who are alive 2 waves after our dead houseolds;

*I also make sure I only find a match once. For the wave you die at;
while `matchnum' <= _N {;
   if dead[`matchnum'] == 1 & wave[`matchnum'] >= (3+`window_control') & wave[`matchnum']==deadwave[`matchnum'] {;
*  if dead[`matchnum'] == 1 ;
    *if assets[`matchnum']!=. {;
	 *if assets[`matchnum'-3]!=. & HHID[`matchnum']==HHID[`matchnum'-3]{;
      local matchage = age1[`matchnum']; * This will be age at death;
      local matchgen = w3ihhstatus[`matchnum'];
      local matchwave = wave[`matchnum'];
    * local matchmar = married[`matchnum'];
      local matchwealth = w3iwealth[`matchnum'];
      local matchPI = PI[`matchnum'];
      local deadwave_MN = deadwave[`matchnum']; 
      local window_dead = `deadwave_MN'+`window_control';
      local gotmatch = 0;
      local tightmatch = 0;
	
      local loop = 1;
      while `loop' <= _N {;
         if `loop' ~= `matchnum' {;
            if wave[`loop'] ==`window_dead' {; * changed to define a window;
               if dead[`loop'] == 0 {;
			    * if dflagger[`loop'] == 0 ;
                  if deadwave[`loop'] == (`deadwave_MN'+3) | deadwave[`loop'] == (`deadwave_MN'+4) | deadwave[`loop'] == (`deadwave_MN'+5){;
				   *if assets[`loop']!=. {;
	                *if assets[`loop'-3]!=. & HHID[`loop']==HHID[`loop'-3]{;
				     qui replace gooddeath = 1 in `loop'; * Store for below;
					* };
					*};
				  };
                  if gooddeath[`loop'] == 1 {;
                     if w3ihhstatus[`loop'] == `matchgen' {;		  
                        if (age1[`loop'] > (`matchage'-10) & age1[`loop'] < (`matchage'+10)) {;
                           if(PI[`loop']<=(`matchPI'+0.15) & (`matchPI'-0.15)<=PI[`loop']){;
                              if ((((w3iwealth[`loop'] - 5000) <= `matchwealth') & (`matchwealth' <= (w3iwealth[`loop'] + 5000)))   |
                              ((w3iwealth[`loop'] <= (`matchwealth'*1.025) & (`matchwealth'*.975) <= w3iwealth[`loop']))){;
                                 qui replace matchmarker_alt = 1 in `loop';
                                 local tightmatch = 1;
                              };
                            * In the code that follows, tight and loose criteria differ only w/r/t assets;
                              if `tightmatch' == 0 {;                       
                                 if ((((w3iwealth[`loop'] - 10000) <= `matchwealth') & (`matchwealth' <= (w3iwealth[`loop'] + 10000)))   |
                                 ((w3iwealth[`loop'] <= (`matchwealth'*1.05) & (`matchwealth'*.95) <= w3iwealth[`loop']))){;   
                                    qui replace matchmarker = 1 in `loop';
                                 };									
                              };
                           };
                        };
                     };
                  };
               };
            };
         };
      local loop = `loop' + 1;  
	  	};
	   *};
      *};
	
      qui gen picker = uniform() * matchmarker_alt;
      qui sum picker;
      if r(max) ~= . & r(max) ~= 0 {;
         local gotmatch = 1;
         local loop2 = 1;
         while `loop2' <= _N {;
            if (picker[`loop2'] > (r(max)-.0000001)) & (picker[`loop2'] < (r(max)+.0000001)) {; * guy with maximum value of picker;
               qui replace HHIDdonor_alt = HHID[`loop2'] in `matchnum';    
               local loop2 = _N; 
            };
         local loop2 = `loop2' + 1;        
         };
      };
	
      
      if `tightmatch' == 0 {;
       * The code that follows allows us to adjust match criteria along every dimension;
/*     
         local loop = 1;
         while `loop' <= _N {;
            if `loop' ~= `matchnum' {;
               if wave[`loop'] ==`window_dead' {; * changed to define a window;
                  if dead[`loop'] == 0 {;
                     if gooddeath[`loop'] == 1 {;				  
                        if w3ihhstatus[`loop'] == `matchgen' {;		  
                           if (age1[`loop'] > (`matchage'-10) & age1[`loop'] < (`matchage'+10)) {;
                              if(PI[`loop']<=(`matchPI'+0.15) & (`matchPI'-0.15)<=PI[`loop']){;
                                 if ((((w3iwealth[`loop'] - 20000) <= `matchwealth') & (`matchwealth' <= (w3iwealth[`loop'] + 20000)))   |
                                 ((w3iwealth[`loop'] <= (`matchwealth'*1.1) & (`matchwealth'*.9) <= w3iwealth[`loop']))){;   
                                    qui replace matchmarker = 1 in `loop';
                                 };									
                              };
                           };
                        };
                     };
                  };
               };
            };
         local loop = `loop' + 1;      
         };	  
 */      	   	  
         qui drop picker;
         qui gen picker = uniform() * matchmarker;
         qui sum picker; 
         if r(max) ~= . & r(max) ~= 0 {;
            local gotmatch = 1;
            local loop2 = 1;
            while `loop2' <= _N {;
               if (picker[`loop2'] > (r(max)-.0000001)) & (picker[`loop2'] < (r(max)+.0000001)) {; * guy with maximum value of picker;     
                  qui replace HHIDdonor = HHID[`loop2'] in `matchnum';    
                  local loop2 = _N; 
               };
            local loop2 = `loop2' + 1;        
            };
         };
      };   
      
      sum assets;

      if `gotmatch' == 0 {;
         qui replace nomatcher = 1 in `matchnum';
         local nomatch = `nomatch' + 1;
      };

      qui drop picker;
      qui replace gooddeath = 0;
      replace matchmarker_alt = 0;
      replace matchmarker = 0;
      };

   di "Matched obs: `matchnum' From `totalobs'";
   local matchnum = `matchnum' + 1;
};


egen nomatch=sum(nomatcher), by (HHID);
drop nomatcher;

egen HHIDdon=max(HHIDdonor), by (HHID);
egen HHIDdon_alt=max(HHIDdonor_alt), by (HHID);

save "rawdonors_rm_match_died_after_3_or_4_or_5_waves_tighter_assets_correct_topcoding_09042021.dta", replace;
replace HHIDdon_alt=HHIDdon if HHIDdon_alt==0;
drop HHIDdon;
rename HHIDdon_alt HHIDdon;

keep if wave==3;
keep HHID HHIDdon;
save "eventdonors_rm_match_died_after_3_or_4_or_5_waves_tighter_assets_correct_topcoding_09042021.dta", replace;
use "dataprep2_4states_NEW20190702.dta";

merge m:1 HHID using "eventdonors_rm_match_died_after_3_or_4_or_5_waves_tighter_assets_correct_topcoding_09042021.dta";
drop if _merge!=3;
drop _merge;
replace amothers=0 if mandead==1 & womandead==1; *definitional - we think of these as terminal bequests measured in the assets of households;

save tmp1_rm_match_died_after_3_or_4_or_5_waves_tighter_assets_correct_topcoding_09042021.dta, replace;

use "dataprep2_4states_NEW20190702.dta";
keep HHID wave assets homeeq hhmedcost_b hhmedicaid hhmedicaid_pay amothers;
rename (HHID assets homeeq hhmedcost_b hhmedicaid hhmedicaid_pay amothers) (HHIDdon assets_don homeeq_don hhmedcost_b_don hhmedicaid_don hhmedicaid_pay_don amothers_don);
save tmp2_rm_match_died_after_3_or_4_or_5_waves_tighter_assets_correct_topcoding_09042021.dta, replace;
# delimit ;
use tmp1_rm_match_died_after_3_or_4_or_5_waves_tighter_assets_correct_topcoding_09042021.dta, clear;
sort HHIDdon wave;
*merge using HHIDdon wave tmp2.dta;

merge m:1 HHIDdon wave using tmp2_rm_match_died_after_3_or_4_or_5_waves_tighter_assets_correct_topcoding_09042021.dta;
keep if _merge==3;
save tmp3_rm_match_died_after_3_or_4_or_5_waves_tighter_assets_correct_topcoding_09042021.dta, replace;

*amothers is designed to be missing in the data when we do not observe a death;
replace amothers=0 if assets!=. & amothers==.;
replace amothers_don=0 if assets_don!=.  & amothers_don==.;
save tmp3_rm_match_died_after_3_or_4_or_5_waves_tighter_assets_correct_topcoding_09042021.dta, replace;

log close;
