/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
proc(1) = summxd(AHDMCBS,twoyrs,onlymyrs,mmtcols_j);

    local newdead, dbldead, healsimh, healsimw, pisim96, agesim96, HHIDsim, simwgt96, 
          asstsim, conssim, mssim2, oopmedexsim, Medicaidsim, transfersim, alivesim, 
          deadmssim, dbldmssim, mxobssim, mxmssim, xtraMedex, cuplsim, malesim, 
          fmlsim, agesim, too_old, yearsim, malesim2, conssim2, asstsim2, PIsim2, 
          HHIDsim2, wgtsim2, healsimh2, healsimw2,agesim2, yearsim2, rn2, oopmxsim2, 
          cuplsim2, mdcdsim2, transim2, simyrs2, oopmcsim2, i0, i, alivei, rn, mxdist, 
          mxqnts, iVar, quantrec, meanrec, maxrec, minrec, qnts, cndmnum, mns, dataprfs, 
          datacnts, iPI, xx, yy, piq, mstat, getsMcd, allmx, Snglsim, initSngl;

    load path=^shkpath newdead, dbldead, healsimh, healsimw, pisim96, agesim96, 
                       HHIDsim, simwgt96, asstsim, conssim; 

  @ Load variables withOUT timing shifts @

    load path=^iopath mssim2, oopmedexsim, Medicaidsim, transfersim;

    mssim2      = reshape(mssim2,simyrs+1,_nn)';
    alivesim    = mssim2.>0;
    Snglsim     = alivesim.*(mssim2.<3);
    initSngl    = Snglsim[.,1]*ones(1,simyrs+1);
    oopmedexsim = reshape(oopmedexsim,simyrs+1,_nn)'; 
    Medicaidsim = reshape(Medicaidsim,simyrs+1,_nn)';
    transfersim = reshape(transfersim,simyrs+1,_nn)';

    if (swchRisk==1) and (swchContrisk==0); @ Referee 4 request: no medex risk for surviving spouse @
        oopmedexsim = switchR4(oopmedexsim,initSngl,"oopmedexsim");
        Medicaidsim = switchR4(Medicaidsim,initSngl,"Medicaidsim");
        transfersim = switchR4(transfersim,initSngl,"transfersim");
    endif;

    mssim2      = mssim2[.,1:simyrs]; 
    oopmedexsim = oopmedexsim[.,1:simyrs]; 
    Medicaidsim = Medicaidsim[.,1:simyrs];
    transfersim = transfersim[.,1:simyrs];
    alivesim    = alivesim[.,1:simyrs];
    deadmssim   = zeros(_nn,1)~(newdead[.,2:simyrs].*mssim2[.,1:simyrs-1]);
    dbldmssim   = zeros(_nn,2)~(dbldead[.,3:simyrs].*mssim2[.,1:simyrs-2]);  @ Multiply by previous WAVE's status @
    mxobssim    = alivesim;
    mxmssim     = mssim2;
    conssim     = conssim.*alivesim;
    transfersim = transfersim.*alivesim; // Transfersim set  to -1e5 upon death

  @ Recall that model reports medex for previous period and includes death expenses @
  @ AHDMCBS==1 => match structure of AHEAD @

    if (AHDMCBS==0);  
        oopmedexsim = oopmedexsim[.,2:simyrs]/agestep;  // Move medex up a year
        Medicaidsim = Medicaidsim[.,2:simyrs]/agestep;
        transfersim = transfersim[.,2:simyrs]/agestep;
        conssim     = conssim[.,1:simyrs-1]/agestep;     // But consumption is contemporaneous
        asstsim     = asstsim[.,1:simyrs-1];
        mxobssim    = mxobssim[.,1:simyrs-1];            
        mxmssim     = mxmssim[.,1:simyrs-1];
        if rows(mmtcols_j)>1;
            mmtcols_j = mmtcols_j[1:(rows(mmtcols_j)-1)];
        endif;

    elseif (AHDMCBS==1);
        mxobssim  = alivesim + newdead; 
        mxmssim   = mxmssim + deadmssim;
        mmtcols_j = mmtcols_j[2:rows(mmtcols_j)];  // First medex observation a dud

        if (twoyrs==1) and (agestep==1);         @ matching biannual data with annual simulations @ 
            mxobssim    = mxobssim + dbldead;
            mxmssim     = mxmssim + dbldmssim;    @ Previous WAVE's status @
            xtraMedex   = zeros(_nn,1)~(dbldead[.,2:simyrs].*oopmedexsim[.,1:simyrs-1]);   @ When person dies in previous wave in HRS, EBF does not divide by 2 @
            oopmedexsim = oopmedexsim.*(1-dbldead)+ dbldead.*xtraMedex; @ Just need zeros when person died 1 year ago @
            oopmedexsim = (oopmedexsim[.,1:simyrs-1]+oopmedexsim[.,2:simyrs])/2; @ 2-year averages @
            oopmedexsim = zeros(_nn,1)~oopmedexsim;
            xtraMedex   = zeros(_nn,1)~(dbldead[.,2:simyrs].*Medicaidsim[.,1:simyrs-1]);
            Medicaidsim = Medicaidsim.*(1-dbldead)+ dbldead.*xtraMedex;
            Medicaidsim = (Medicaidsim[.,1:simyrs-1]+Medicaidsim[.,2:simyrs])/2; @ 2-year averages @
            Medicaidsim = zeros(_nn,1)~Medicaidsim;
            xtraMedex   = zeros(_nn,1)~(dbldead[.,2:simyrs].*transfersim[.,1:simyrs-1]); // Should just be zeros
            transfersim = transfersim.*(1-dbldead)+ dbldead.*xtraMedex;
            transfersim = (transfersim[.,1:simyrs-1]+transfersim[.,2:simyrs])/2; @ 2-year averages @
            transfersim = zeros(_nn,1)~transfersim;
            conssim     = (conssim[.,1:simyrs-1]+conssim[.,2:simyrs])/2; @ 2-year averages @
            conssim     = zeros(_nn,1)~conssim;		
        endif;
    endif;

    alivesim = mxobssim;
    cuplsim  = mxmssim.==3;
    malesim  = mxmssim.==1;
    fmlsim   = mxmssim.==2;
    agesim   = agesim96+seqa(0,1,simyrs)';
    too_old  = agesim.>dieage;
    agesim   = agesim.*(1-too_old)+too_old*dieage;
    yearsim  = seqa(0,agestep,simyrs)+momyr1;
   
    if onlymyrs==1;                                             @ AHEAD Survey Years @
        alivesim    = alivesim[.,mmtcols_j];
        oopmedexsim = oopmedexsim[.,mmtcols_j];
        Medicaidsim = Medicaidsim[.,mmtcols_j];
        transfersim = transfersim[.,mmtcols_j];
        conssim     = conssim[.,mmtcols_j];
        cuplsim     = cuplsim[.,mmtcols_j];
        malesim     = malesim[.,mmtcols_j];
        healsimh    = healsimh[.,mmtcols_j];
        healsimw    = healsimw[.,mmtcols_j];
        agesim      = agesim[.,mmtcols_j];
        yearsim     = yearsim[mmtcols_j];        
     endif;

    oopmxsim2 = {};
    cuplsim2  = {};
    mdcdsim2  = {};
    transim2  = {};
    conssim2  = {};
    asstsim2  = {};   
    malesim2  = {};
    healsimh2 = {};
    healsimw2 = {}; 
    agesim2   = {};
    yearsim2  = {};
    PIsim2    = {};
    rn2       = {};
    HHIDsim2  = {};
    wgtsim2   = {};

/*  Note that there is no simulated medex for year 1.  Drop these observations  */

    i=1; do until i>cols(alivesim);
        alivei    = alivesim[.,i];
        alivei    = selif(seqa(1,1,_nn),alivei);
        rn        = rows(alivei);
        oopmxsim2 = oopmxsim2|oopmedexsim[alivei,i];
        mdcdsim2  = mdcdsim2|Medicaidsim[alivei,i];
        transim2  = transim2|transfersim[alivei,i];
        conssim2  = conssim2|conssim[alivei,i];	
        asstsim2  = asstsim2|asstsim[alivei,i];
        cuplsim2  = cuplsim2|cuplsim[alivei,i];		        	
        malesim2  = malesim2|malesim[alivei,i];
        agesim2   = agesim2|agesim[alivei,i];
        yearsim2  = yearsim2|(yearsim[i]*ones(rn,1));
        healsimh2 = healsimh2|healsimh[alivei,i];
        healsimw2 = healsimw2|healsimw[alivei,i]; 
        PIsim2    = PIsim2|pisim96[alivei];
        rn2       = rn2|alivei;
        HHIDsim2  = HHIDsim2|HHIDsim[alivei];
        wgtsim2   = wgtsim2|simwgt96[alivei];
    i=i+1; endo;

    oopmcsim2 = oopmxsim2+mdcdsim2;
    mxdist    = oopmxsim2~mdcdsim2~transim2~agesim2~PIsim2~cuplsim2~malesim2~healsimh2~healsimw2~yearsim2~rn2~HHIDsim2~wgtsim2~asstsim2;
    save path=^shkpath mxdist;

    if prnres>1;
        ?;"Two-year Indicator";; (twoyrs*AHDMCBS); 
        "Mean values for simulated medex";; meanc(mxdist); ?;
    endif;

    {xx,yy,piq} = PIquant2(PIsim2,pistate_a,0);

    mstat    = (1-cuplsim2).*(2-malesim2) + 3*cuplsim2;
    getsMcd  = (mdcdsim2+(transim2.>0).*transim2).>0; // Transfersim set  to -1e5 upon death
    mxdist   = oopmxsim2~mdcdsim2~oopmcsim2;    
    mxqnts   = (0.1|0.25|0.50|0.75|0.90|0.95|0.99|0.995|0.999|0.9999);
    quantrec = {};
    meanrec  = {};
    maxrec   = {};
    minrec   = {};

    iVar = 1; do until iVar>cols(mxdist);
        {mns,cndmnum} = getmean(mxdist[.,iVar],wgtsim2);
        if (wgtddata==0);
            {qnts,cndmnum} = getqunt2(mxdist[.,iVar],mxqnts);
        else;
            {qnts,cndmnum} = getquant(mxdist[.,iVar],wgtsim2,mxqnts,chktie);
        endif;
        meanrec  = meanrec~mns[.,2];
        quantrec = quantrec~qnts[.,2];
        maxrec   = maxrec~maxc(mxdist[.,iVar]);
        minrec   = minrec~minc(mxdist[.,iVar]);
    iVar=iVar+1; endo;

    if prnres>1;
        "    quantile         oop      Medicaid         Sum";;
        mxqnts~quantrec;
        "         min ";; minrec;
        "         max ";; maxrec;
        "        mean ";; meanrec; ?;
    endif; 

    if prnres>1;
        allmx    = oopmxsim2~oopmcsim2~mdcdsim2~getsMcd~conssim2;
        "   PI/Gender      OOP MX       OOP+MC      Medicaid      MC Rate   Consumption";;
        cndmns(allmx,piq);
        cndmns(allmx,mstat);
        ?;?;"MEANS for MEDICAID RECIPIENTS ONLY";
        ?;"   PI/Gender      OOP MX       OOP+MC      Medicaid      MC Rate   Consumption";;
        cndmns(allmx,piq.*getsMcd);
        cndmns(allmx,mstat.*getsMcd);?;?;
    endif;

retp(quantrec|minrec|maxrec|meanrec); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
proc(0) = cndmns(data,sortvar);

    local rn, sortvals, summns, i, goodobs, cmeans;
    
    sortvals = unique(sortvar,1);
    rn       = rows(sortvals);
    summns   = {};
    
    i=1; do until i>rn;
        goodobs = (sortvar.==sortvals[i]);
        cmeans  = (data'goodobs)/(goodobs'goodobs);
        summns  = summns|(sortvals[i]~cmeans');
    i=i+1; endo;
 
    summns;;

retp; endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
proc(0) = sumbqd(onlymyrs);

    local newdead, dbldead, newwidow, pisim96, agesim96, HHIDsim, simwgt96, asstsim, 
          beqsim, mssim2, deadmssim, dbldmssim, lasstsim, bobssim, bmssim, xtrabeq, 
          cuplsim, malesim, fmlsim, agesim, too_old, yearsim, diedsim, cn, cuplsim2, 
          malesim2, agesim2, PIsim2, HHIDsim2, wgtsim2, yearsim2, lasstsim2, beqsim2, 
          i, diedi, rn, bqdist, iVar, cndmnum, mns, nuwdwi, sidebqdist, bqqnts, 
          bqlabel, quantrec, meanrec, maxrec, minrec, qnts, Snglsim, initSngl;

    load path=^shkpath newdead, dbldead, newwidow, pisim96, agesim96, HHIDsim, simwgt96;

  @ Load variables withOUT timing shifts @

    load path=^iopath asstsim, beqsim, mssim2;

    mssim2    = reshape(mssim2,simyrs+1,_nn)';
    Snglsim   = (mssim2.>0).*(mssim2.<3);
    initSngl  = Snglsim[.,1]*ones(1,simyrs+1);
    asstsim   = reshape(asstsim,simyrs+1,_nn)';
    beqsim    = reshape(beqsim,simyrs+1,_nn)';

    if (swchRisk==1) and (swchContrisk==0); @ Referee 4 request: no medex risk for surviving spouse @
        asstsim = switchR4(asstsim,initSngl,"asstsim");
        beqsim  = switchR4(beqsim,initSngl,"beqsim");
    endif;

    asstsim   = asstsim[.,1:simyrs]; 
    beqsim    = beqsim[.,1:simyrs]; 
    mssim2    = mssim2[.,1:simyrs]; 
    deadmssim = zeros(_nn,1)~(newdead[.,2:simyrs].*mssim2[.,1:simyrs-1]);
    dbldmssim = zeros(_nn,2)~(dbldead[.,3:simyrs].*mssim2[.,1:simyrs-2]);  @ Multiply by previous WAVE's status @
    lasstsim  = zeros(_nn,1)~asstsim[.,1:simyrs-1];
    bobssim   = newdead;

    if (onlymyrs*agestep) == 1;
        bobssim   = bobssim + dbldead;
        deadmssim = deadmssim + dbldmssim;
        xtrabeq   = zeros(_nn,1)~(dbldead[.,2:simyrs].*beqsim[.,1:simyrs-1]);     @ Need assets only when person died 2 years ago @
        beqsim    = beqsim.*(1-dbldead)+dbldead.*xtrabeq;                         @ because we have assets for the year after death @
        lasstsim  = zeros(_nn,1)~lasstsim[.,1:simyrs-1];                          @ Assets from previous WAVE @  
    endif;

    cuplsim  = deadmssim.==3;
    malesim  = deadmssim.==1;
    fmlsim   = deadmssim.==2;
    agesim   = agesim96+seqa(0,1,simyrs)';
    too_old  = agesim.>dieage;
    agesim   = agesim.*(1-too_old)+too_old*dieage;
    yearsim  = seqa(0,1,simyrs+1)+momyr1;

    if onlymyrs==1;                                            
        cn = mmtcols; 
    else;
        cn = seqa(1,1,simyrs);
    endif;

/*  There are no simulated bequests or lagged assets for year 1.  Drop these observations  */

    cn = cn[2:rows(cn)];

    diedsim  = bobssim[.,cn];
    newwidow = newwidow[.,cn]; 
    beqsim   = beqsim[.,cn];
    lasstsim = lasstsim[.,cn];
    cuplsim  = cuplsim[.,cn];
    malesim  = malesim[.,cn];
    agesim   = agesim[.,cn];
    yearsim  = yearsim[cn];  

    beqsim2   = {};
    lasstsim2 = {};
    cuplsim2  = {};
    malesim2  = {}; 
    agesim2   = {};
    yearsim2  = {};
    PIsim2    = {};
    HHIDsim2  = {};
    wgtsim2   = {};

    i=1; do until i>rows(cn);
        diedi     = diedsim[.,i];
        diedi     = selif(seqa(1,1,_nn),diedi);
        rn        = rows(diedi);
        beqsim2   = beqsim2|beqsim[diedi,i];
        lasstsim2 = lasstsim2|lasstsim[diedi,i];
        cuplsim2  = cuplsim2|cuplsim[diedi,i];
        malesim2  = malesim2|malesim[diedi,i];
        agesim2   = agesim2|agesim[diedi,i];
        yearsim2  = yearsim2|(yearsim[i]*ones(rn,1));
        PIsim2    = PIsim2|pisim96[diedi];
        HHIDsim2  = HHIDsim2|HHIDsim[diedi];
        wgtsim2   = wgtsim2|simwgt96[diedi];
    i=i+1; endo;

    bqdist = beqsim2~lasstsim2~agesim2~PIsim2~cuplsim2~malesim2~yearsim2~HHIDsim2;
    save path=^shkpath bqdist;

    let string bqlabel = {"Bequests     ", "Prior Assets ", "Age         ", "PI           ", 
                          "Married      ", "Single Man   ", "Year        "
                          };
    bqqnts   = (0.1|0.25|0.50|0.75|0.90|0.95|0.99|0.995|0.999|0.9999);
    quantrec = {};
    meanrec  = {};
    maxrec   = {};
    minrec   = {};

    "Mean values for simulated bequests";
    iVar = 1; do until iVar>(cols(bqdist)-1);
        {mns,cndmnum} = getmean(bqdist[.,iVar],wgtsim2);
        bqlabel[iVar];; mns[.,2];
    iVar=iVar+1; endo;?;

    {mns,cndmnum} = getmean(beqsim2,wgtsim2);
    if (wgtddata==0);
        {qnts,cndmnum} = getqunt2(beqsim2,bqqnts);
    else;
        {qnts,cndmnum} = getquant(beqsim2,wgtsim2,bqqnts,chktie);
    endif;
    meanrec  = meanrec~mns[.,2];
    quantrec = quantrec~qnts[.,2];
    minrec   = minrec~minc(beqsim2);
    maxrec   = maxrec~maxc(beqsim2);


 /* Repeat, for side bequests */

   if sumc(sumc(newwidow))>0;

        cuplsim  = mssim2[.,cn].==3;
        malesim  = mssim2[.,cn].==1;
        fmlsim   = mssim2[.,cn].==2;

        beqsim2   = {};
        lasstsim2 = {};
        cuplsim2  = {};
        malesim2  = {}; 
        agesim2   = {};
        yearsim2  = {};
        PIsim2    = {};
        HHIDsim2  = {};
        wgtsim2   = {};

        i=1; do until i>rows(cn);
            nuwdwi    = newwidow[.,i];
            nuwdwi    = selif(seqa(1,1,_nn),nuwdwi);
            rn        = rows(nuwdwi);
            beqsim2   = beqsim2|beqsim[nuwdwi,i];
            lasstsim2 = lasstsim2|lasstsim[nuwdwi,i];
            cuplsim2  = cuplsim2|cuplsim[nuwdwi,i];
            malesim2  = malesim2|malesim[nuwdwi,i];
            agesim2   = agesim2|agesim[nuwdwi,i];
            yearsim2  = yearsim2|(yearsim[i]*ones(rn,1));
            PIsim2    = PIsim2|pisim96[nuwdwi];
            HHIDsim2  = HHIDsim2|HHIDsim[nuwdwi];
            wgtsim2   = wgtsim2|simwgt96[nuwdwi];
        i=i+1; endo;

        sidebqdist = beqsim2~lasstsim2~agesim2~PIsim2~cuplsim2~malesim2~yearsim2~HHIDsim2;
        save path=^shkpath sidebqdist;

        "Mean values for simulated SIDE bequests";
        iVar = 1; do until iVar>(cols(sidebqdist)-1);
            {mns,cndmnum} = getmean(sidebqdist[.,iVar],wgtsim2);
            bqlabel[iVar];; mns[.,2];
        iVar=iVar+1; endo; ?;
        ?;
 
        {mns,cndmnum} = getmean(beqsim2,wgtsim2);
        if (wgtddata==0);
            {qnts,cndmnum} = getqunt2(beqsim2,bqqnts);
        else;
            {qnts,cndmnum} = getquant(beqsim2,wgtsim2,bqqnts,chktie);
        endif;
        meanrec  = meanrec~mns[.,2];
        quantrec = quantrec~qnts[.,2];
        minrec   = minrec~minc(beqsim2);
        maxrec   = maxrec~maxc(beqsim2);

    endif; 
 
    if prnres>1;
        "    quantile    reg beqs     side beqs";;
        bqqnts~quantrec;
        "         min ";; minrec;
        "         max ";; maxrec;
        "        mean ";; meanrec; ?;?;
    endif;

retp; endp;

