/*---------------------------------------------------------------------------*/
/*  Procedures for MSM Estimation:  Uses decision rules to find simulated    */
/*      moments and compares to data moments.                                */
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(0) = savevecs();

    local agevec, simvec, swchvec, medexvec, prefvec, asstvec, hscoefs,
          xcacoefs, mxmcoefs, mxvcoefs,mxm_noriskcoefs, mxv_noriskcoefs, qcoefs,
          asim96, ztacdfsim96, pisim96, agesim96, incsim96, healsimh, 
          healsimw, mstatsim, xicdfsim, epscdfsim, asimx, ztacdfx, pisimx, 
          agesimx, incsim96x, hlsimhx, hlsimwx, mstatx, xicdfx, epscdfx;

    agevec   = bornage|dieage|agestep|agediffw|_tr;
    simvec   = _nn|simyrs|momyr1|momyr2;
    swchvec  = swchMort|swchBeta|swchY|swchHCost|swchTax|swchZeta|swchXi;
    swchvec  = swchvec|swchROR|swchBeq|swchGender|swchCouple|swchHouse|swchRisk|swchContrisk;
    medexvec = rhomx|fracar1|fracar1i|fracwn|minmedex; 
    prefvec  = _delta1|_delta2|_beta|_nu|_omega|phi_s|kappa_s;
    prefvec  = prefvec|phi_c1|kappa_c1|phi_c2|kappa_c2|_eta;
    asstvec  = cfloor_s|cfloor_c|tauBeq|exBeq|mu_r|sigma_r|MCIncAllow|MCIncTest|MCAssAllow|eta_fpl; 

    save path = ^iopath agevec;
    save path = ^iopath simvec;
    save path = ^iopath swchvec;
    save path = ^iopath medexvec;
    save path = ^iopath prefvec;
    save path = ^iopath asstvec;
    save path = ^iopath rorshk;
    save path = ^iopath job; 
    save path = ^iopath xiparms;
    save path = ^iopath zetaParms;

    hscoefs   = vec(hltrans);  save path = ^iopath hscoefs;
    /*xcacoefs  = vec(xcassts);  save path = ^iopath xcacoefs;*/
    mxmcoefs  = mxcoef[.,1];   save path = ^iopath mxmcoefs;
    mxvcoefs  = mxcoef[.,2];   save path = ^iopath mxvcoefs;
    mxm_noriskcoefs  = mxcoef_norisk[.,1];   save path = ^iopath mxm_noriskcoefs;
    mxv_noriskcoefs  = mxcoef_norisk[.,2];   save path = ^iopath mxv_noriskcoefs;

    yprof     = vecr(yprof);   save path = ^iopath yprof;
    y_pi      = vecr(y_pi);    save path = ^iopath y_pi;    
    /*qcoefs    = vecr(copays);  save path = ^iopath qcoefs;*/

    if simtype==1;
        load path=^shkpath asim96, ztacdfsim96, pisim96, agesim96, incsim96, 
                           healsimh, healsimw, mstatsim, xicdfsim, epscdfsim;
    elseif simtype==2;
        load path=^shkpath asimx, ztacdfx, pisimx, agesimx, incsim96x, hlsimhx, 
                           hlsimwx, mstatx, xicdfx, epscdfx;
        asim96    = asimx[.,1];    ztacdfsim96 = ztacdfx;    pisim96   = pisimx;
        agesim96  = agesimx[.,1];  incsim96    = incsim96x;  healsimh  = hlsimhx;  
        healsimw  = hlsimwx;       mstatsim    = mstatx;     xicdfsim  = xicdfx;
        epscdfsim = epscdfx;
    endif;

    if allalive==1;
        mstatsim = mstatsim[.,1]*ones(1,cols(mstatsim));
    endif;

    healsimh  = vec(healsimh);         /*  simulated husband's health status */ 
    healsimw  = vec(healsimw);         /*  simulated wife's health status    */ 
    mstatsim  = vec(mstatsim);         /*  simulated marital status          */
    xicdfsim  = vec(xicdfsim);         /*  simulated innovation on AR(1)     */
    epscdfsim = vec(epscdfsim);        /*  simulated white noise shock       */

    save path=^iopath asim96, ztacdfsim96, pisim96, agesim96, incsim96, 
                      healsimh, healsimw, mstatsim, xicdfsim, epscdfsim;

retp(); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
PUNSCALE_P:  Converts a vector of transformed parameters into the parameters
             used in the life-cycle model
*/
proc(14) = punscale_p(parmvec);

    local phi0_s, K0_s, phi0_c1, K0_c1, phi0_c2, K0_c2, bigR, _fs, _fc1, _fc2,
          beta2, bigR2, beqscale;

    _delta1  = exp(parmvec[1])-1;
    _delta2  = exp(parmvec[2])-1;
    _beta    = parmvec[3];
    _nu      = parmvec[4];
     _omega  = parmvec[5];

    bigR     = 1+mu_r;
    beta2    = _beta^agestep;
    bigR2    = bigR^agestep;
    beqscale = (agestep+mu_r)/bigR;  // Move between one-year and two-year frameworks

    phi0_s   = beqscale*phimax*logit(parmvec[6]);
    K0_s     = beqscale*parmvec[7]*1000;
    _fs      = bigR2*(1-phi0_s)/phi0_s;
    phi_s    = (_fs^_nu)/(bigR2*beta2);
    kappa_s  = K0_s*_fs + (_fs==0)*1e6;

    phi0_c1  = beqscale*phimax*logit(parmvec[8]);
    K0_c1    = beqscale*parmvec[9]*1000;
    _fc1     = bigR2*(1-phi0_c1)/phi0_c1;
    phi_c1   = (_fc1^_nu)/(bigR2*beta2);
    kappa_c1 = K0_c1*_fc1 + (_fc1==0)*1e6;

    phi0_c2  = beqscale*phimax*logit(parmvec[10]);
    K0_c2    = beqscale*parmvec[11]*1000;
    _fc2     = bigR2*(1-phi0_c2)/phi0_c2;
    phi_c2   = (_fc2^_nu)/(bigR2*beta2);
    kappa_c2 = K0_c2*_fc2 + (_fc2==0)*1e6;

    _eta     = parmvec[12];
    cfloor_s = exp(parmvec[13]);
    cfloor_c = exp(parmvec[14]);

retp(_delta1,_delta2,_beta,_nu,_omega,phi_s,kappa_s,phi_c1,kappa_c1,phi_c2,
     kappa_c2,_eta,cfloor_s,cfloor_c); 
endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
PUNSCALE_M:  Converts a vector of transformed parameters into the parameters
             used ARMA model of medex shocks
*/
proc(8) = punscale_m(shkparms);

    local rhomx, fracar1, fracar1i, fracwn, mxmcoef, mxvcoef, mxcoef, mxmcoef_norisk, mxvcoef_norisk, mxcoef_norisk, xipmtx, 
          xivals, intvals, xiParms, zetapmtx, zetavals, zetaParms, ncoefs;

    rhomx    = shkparms[1];
    fracar1  = shkparms[2];
    ncoefs   = rows(mxlabel);

    if pscaled_m == 1;
        rhomx   = logit(rhomx);
        fracar1 = logit(fracar1);
    endif;
  
    fracar1i = fracar1*(1-rhomx^2);
    fracwn   = 1-fracar1;
    mxmcoef  = shkparms[3:ncoefs+2];
    mxvcoef  = shkparms[ncoefs+3:2+2*ncoefs];
    /* Rory: updated to add new profile */
    mxmcoef_norisk= shkparms[2+2*ncoefs+3:2+2*ncoefs+ncoefs+2];
    mxvcoef_norisk= shkparms[2+2*ncoefs+ncoefs+3:2+2*ncoefs+2+2*ncoefs];

    mxmcoef  = mxmcoef + (mxvarscl.==0)*discrtzn; /* Ad Hoc discretization adjustment */
    mxmcoef  = mxmcoef + (1-mxvarscl)*mxvcoef/2;        /* Mean-preserving adjustment */
    mxvcoef  = mxvarscl*mxvcoef;
    mxcoef   = mxmcoef~mxvcoef;
    /* Rory: updated to add new profile */
    mxmcoef_norisk  = mxmcoef_norisk + (mxvarscl.==0)*discrtzn; /* Ad Hoc discretization adjustment */
    mxmcoef_norisk  = mxmcoef_norisk + (1-mxvarscl)*mxvcoef/2;        /* Mean-preserving adjustment */
    mxvcoef_norisk  = mxvarscl*mxvcoef_norisk;
    mxcoef_norisk   = mxmcoef_norisk~mxvcoef_norisk;

/* Discretize the health shocks.  Here we create unscaled, unit-variance, Markov chains */
   if disco_xi>0;                                   /* XIDIM and disco_xi are globals */
       {xipmtx,xivals,intvals} = tauch(1,0,XIDIM,disco_xi,disco_xi); 
   else;
       {xipmtx,xivals} = taukhuss(1,0,XIDIM);
   endif;
   "Discretized Transitory Shock (Unit variance)";; xivals~xipmtx;?;
   xiParms = XIDIM|xivals|vecr(xipmtx);
   if disco_z>0;                                    /* XIDIM and disco_xi are globals */
       {zetapmtx,zetavals,intvals} = tauch(sqrt(1-rhomx^2),rhomx,ZETADIM,disco_z,disco_z); 
   else;
       {zetapmtx,zetavals} = taukhuss(sqrt(1-rhomx^2),rhomx,ZETADIM);
   endif;
   "Discretized Persistent Shock (Unit variance)";; zetavals~zetapmtx;?;
   zetaParms = ZETADIM|zetavals|vecr(zetapmtx);

retp(rhomx,fracar1,fracar1i,fracwn,mxcoef,xiParms,zetaParms,mxcoef_norisk); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
GETPARMS:   Converts scaled parameter vector into set of parameters
            Note that individual parameters are globals
*/
proc(0) = getparms(parmvec);

    local uparams,rn,pvrn;

    if pscaled_p==1; 
        {_delta1,_delta2,_beta,_nu,_omega,phi_s,kappa_s,phi_c1,kappa_c1,phi_c2,
         kappa_c2,_eta,cfloor_s,cfloor_c} = punscale_p(parmvec);
    elseif pscaled_p==0;
        _delta1  = parmvec[1];
        _delta2  = parmvec[2];
        _beta    = parmvec[3];
        _nu      = parmvec[4];
        _omega   = parmvec[5];
        phi_s    = parmvec[6];
        kappa_s  = parmvec[7];
        phi_c1   = parmvec[8];
        kappa_c1 = parmvec[9];
        phi_c2   = parmvec[10];
        kappa_c2 = parmvec[11];
        _eta     = parmvec[12];
        cfloor_s = parmvec[13];
        cfloor_c = parmvec[14];
    endif;

    if swchBeq==0;
        phi_s = 0;   kappa_s = 1000;
        phi_c1 = 0;  kappa_c1 = 1000;
        phi_c2 = 0;  kappa_c2 = 1000;
    elseif swchBeq==1;
        if onebeq==1;
            phi_c1 = phi_s;  kappa_c1 = kappa_s;
            phi_c2 = phi_s;  kappa_c2 = kappa_s;
        else;
            if fixc2beq==1;
                phi_c2 = phi_s;  kappa_c2 = kappa_s;
            endif;
            if nosidebeq==1;
                phi_c1 = 0;      kappa_c1 = 1000;
            endif;
            if notermbeq==1;
                phi_s = 0;   kappa_s = 1000;
                phi_c2 = 0;  kappa_c2 = 1000;
            endif;
        endif;
    endif;

    if twofloors==0;
        cfloor_c = cfloor_s*eta_fpl;
    endif;

    if prnres>0;
        uparams = _delta1|_delta2|_beta|_nu|_omega|phi_s|kappa_s;
        uparams = uparams|phi_c1|kappa_c1|phi_c2|kappa_c2|_eta|cfloor_s|cfloor_c;
        ?;"Transformed parameters, and parameters actually used:";
        rn=1; do until rn>rows(parmvec);
            pvrn = parmvec[rn];
            if (rn==6) or (rn==8) or (rn==10);
                plabel[rn];; pvrn;; phimax*logit(pvrn);; uparams[rn];
            else;
                plabel[rn];; pvrn;; uparams[rn];
            endif;
        rn=rn+1; endo;
        ?; "Other key parameters:";
        "Medex bottom-code            ";; minmedex;
        "Medicaid income allowance    ";; MCIncAllow;
        "Medicaid income test         ";; MCIncTest;
        "Medicaid asset disregard     ";; MCAssAllow;  
        "taubeq (estate tax rate)     ";; taubeq;
        "exbeq (estate tax exemption) ";; exbeq;
        "mu_r (mean ROR in dec rules) ";; mu_r;
        "sigma_r (std dev ...)        ";; sigma_r; ?;
    endif;

retp; endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(0) = saveR4sims();

local asstsim, oopmedexsim, transfersim, conssim, mssim2, healsimh, healsimw, 
      iIndexsim, Medicaidsim, beqsim, cohsim, ztasim, xisim, ztaindexsim, 
      xiindexsim, netIncomesim, asim96, incsim96, mxsim96, oopsim96, MCXsim96, 
      MCsim96, asimx, incsim96x, mxsim96x, oopsim96x, MCXsim96x, MCsim96x;

    load path=^iopath asstsim, oopmedexsim, transfersim, conssim, mssim2, 
               healsimh, healsimw, iIndexsim, Medicaidsim, beqsim, cohsim, 
               ztasim, xisim, ztaindexsim, xiindexsim, netIncomesim;

    if simtype==1;
        load path=^shkpath asim96, incsim96, mxsim96, oopsim96, MCXsim96, MCsim96;
    elseif simtype==2;
        load path=^shkpath asimx, incsim96x, mxsim96x, oopsim96x, MCXsim96x, MCsim96x;
        asim96   = asimx[.,1];  incsim96 = incsim96x;  mxsim96 = mxsim96x;
        oopsim96 = oopsim96x;   MCXsim96 = MCXsim96x;  MCsim96 = MCsim96x;
        clear asimx, incsim96x, mxsim96x, oopsim96x, MCXsim96x, MCsim96x;
    endif;

    save path=^ref4path asstsim, oopmedexsim, transfersim, conssim, mssim2, 
               healsimh, healsimw, iIndexsim, Medicaidsim, beqsim, cohsim, 
               ztasim, xisim, ztaindexsim, xiindexsim, netIncomesim, 
               asim96, incsim96, mxsim96, oopsim96, MCXsim96, MCsim96;

retp(); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
SWITCHR4:   Replaces simulations for initial singles in newmat with the
            simulations in oldmat
*/
proc(1) = switchR4(newmat,initSngl,datname);

local oldmatfile, oldmat, newR4mat;

   oldmatfile  = ref4path $+ datname $+ ".fmt";
   load oldmat = ^oldmatfile;
   if cols(initSngl) > 1;
       oldmat      = reshape(oldmat,simyrs+1,_nn)';
   endif;
   newR4mat    = initSngl.*oldmat + (1-initSngl).*newmat;

retp(newR4mat); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
proc(0) = loadsims();

local asstsim, oopmedexsim, Medicaidsim, transfersim, conssim, mssim2, healsimh,  
      healsimw, iIndexsim, medexsim, getsMcdsim, alivesim, Snglsim, Mrrdsim, 
      aliveavg,  newdead, newdead2, newdead3, dbldead, deadSngl, deadMrrd,
      dbldSngl, dbldMrrd, newwidow, aobssim, aobsavg, aSnglsim, aMrrdsim, xtrabeq, 
      beqsim, bobssim, bobsavg, mxobssim, mxobsavg, mxSnglsim, mxMrrdsim, xtraMedex, 
      mcobssim, mcobsavg, mcSnglsim, mcMrrdsim, xtraMCR, gothsim, gotwsim, NHsim, 
      cohsim, ztasim, ztaindexsim, xisim, xiindexsim, oopmcdsim, totmedexsim, 
      netIncomesim, insurersim, toosmall, asim96, incsim96, mxsim96, oopsim96, 
      MCXsim96, MCsim96, simavg, incsim96x, mxsim96x, oopsim96x, MCXsim96x, MCsim96x, 
      asimx, mxsimx, incsimx, cohsimx, asstsimx, ztasimx, ztaindx, xisimx, xiindx,
      oopmxsimx, totmxsimx, Medicaidx, transferx, conssimx, beqsimx, mssim2x, 
      hlsimhx, hlsimwx, NHsimx, alivex, snglx, mrrdx, insurerx, oopmcdx, getsMcdx, 
      iIdxsimx, aobsx, aSnglx, aMrrdx, bobsx, mxobsx, mxSnglx, mxMrrdx, mcobsx, 
      mcSnglx, mcMrrdx, newwidowx, alivesim2, aliveavg2, aobssim2, aobsavg2, 
      bobssim2, bobsavg2, mxobssim2, mxobsavg2, mcobssim2, mcobsavg2, newwidow2, 
      nuwdwavg2, iD, sa, saobsavg, simavg2, asstqnts, quantrec, asim2, asim3, 
      aobssim3, asim4, aobssim4, asim5, aobssim5, asim6, aobssim6, initSngl, 
    assets_sumtab_all, assets_sumtab_iS, assets_sumtab_iC, assets_sumtab_C, assets_sumtab_S;

    load path=^iopath asstsim, oopmedexsim, transfersim, conssim, mssim2,
               healsimh, healsimw, iIndexsim, Medicaidsim, beqsim;

    mssim2      = reshape(mssim2,simyrs+1,_nn)';
    alivesim    = mssim2.>0;
    Snglsim     = alivesim.*(mssim2.<3);
    initSngl    = Snglsim[.,1]*ones(1,simyrs+1);
    Mrrdsim     = alivesim.*(mssim2.==3);
    aliveavg    = meanc(alivesim);
    newwidow    = Mrrdsim[.,1:simyrs]-Mrrdsim[.,2:simyrs+1]; // When one spouse dies
    newwidow    = zeros(_nn,1)~(newwidow.>0);
    newwidow    = newwidow.*alivesim;

    asstsim     = reshape(asstsim,simyrs+1,_nn)';
    beqsim      = reshape(beqsim,simyrs+1,_nn)';
    oopmedexsim = reshape(oopmedexsim,simyrs+1,_nn)';
    transfersim = reshape(transfersim,simyrs+1,_nn)';
    Medicaidsim = reshape(Medicaidsim,simyrs+1,_nn)'; 
    conssim     = reshape(conssim,simyrs+1,_nn)';
    healsimh    = reshape(healsimh,simyrs+1,_nn)';
    healsimw    = reshape(healsimw,simyrs+1,_nn)';
    
    if (swchRisk==1) and (swchContrisk==0); @ Referee 4 request: no medex risk for surviving spouse @
        asstsim     = switchR4(asstsim,initSngl,"asstsim");
        beqsim      = switchR4(beqsim,initSngl,"beqsim");
        oopmedexsim = switchR4(oopmedexsim,initSngl,"oopmedexsim");
        transfersim = switchR4(transfersim,initSngl,"transfersim");
        Medicaidsim = switchR4(Medicaidsim,initSngl,"Medicaidsim");
        conssim     = switchR4(conssim,initSngl,"conssim");
    endif;

    asstsim     = asstsim - newwidow.*beqsim; @ remove side bequests from assets of new widow/ers @
    iIndexsim   = reshape(iIndexsim,7,_nn)';
    medexsim    = oopmedexsim+Medicaidsim;
    getsMcdsim  = ((Medicaidsim+transfersim.*(transfersim.>0)).>0); @ Transfersim = -1e5 when person dies @
 
 @  Deal with the problem that the posthumous interviews may provide data for  @
 @  someone who died nearly two years ago.  For data-simulation consistency,   @
 @  we might need simulation output 2 years after a person's death.            @

    newdead    = alivesim[.,1]~alivesim[.,1:simyrs]; 
    newdead    = newdead - alivesim;        @ alive in previous PERIOD, now dead @
    bobssim    = newdead;                   @ Ignore side bequests @
    deadSngl   = zeros(_nn,1)~(newdead[.,2:simyrs+1].*Snglsim[.,1:simyrs]);  @ Multiply by previous PERIOD's status @
    deadMrrd   = zeros(_nn,1)~(newdead[.,2:simyrs+1].*Mrrdsim[.,1:simyrs]);
    dbldead    = 0*newdead;
    dbldSngl   = 0*deadSngl;
    dbldMrrd   = 0*deadMrrd;

    if agestep==1;            @ matching biannual data with annual simulations @
        newdead3 = alivesim[.,mmtcols]; 
        newdead3 = newdead3[.,1]~newdead3[.,1:mmtyrs-1];
        newdead3 = newdead3 - alivesim[.,mmtcols];       @ alive in previous WAVE, now dead @
        newdead2 = zeros(_nn,simyrs+1);
        newdead2[.,mmtcols] = newdead3;                 @ include between-wave observations @
        dbldead  = newdead2 - newdead;
        dbldead  = (dbldead.>0);          @ person who died immediately after previous wave @
        dbldSngl = zeros(_nn,2)~(dbldead[.,3:simyrs+1].*Snglsim[.,1:simyrs-1]);  @ Multiply by previous WAVE's status @
        dbldMrrd = zeros(_nn,2)~(dbldead[.,3:simyrs+1].*Mrrdsim[.,1:simyrs-1]);  @ Multiply by previous WAVE's status @
        xtrabeq  = zeros(_nn,1)~(dbldead[.,2:simyrs+1].*beqsim[.,1:simyrs]);     @ Need assets only when person died 2 years ago @
        beqsim   = beqsim.*(1-dbldead)+dbldead.*xtrabeq;                         @ because we have assets for the year after death @
        bobssim  = bobssim + dbldead;
        clear newdead2, newdead3;
    endif;
    
    if deadassts==0;                  @ Find bequests, don't include in moment calculations @
        aobssim  = alivesim;
        aSnglsim = Snglsim;
        aMrrdsim = Mrrdsim;
        aobsavg  = aliveavg;
//      bobssim  = bobssim + newwidow;  // don't include side bequests in assets
    elseif deadassts==1;                @ Include bequests in assets used in moment calculations @
        aobssim  = alivesim + newdead;  @ alive this period or prior @
        aSnglsim = Snglsim + deadSngl;  @ Multiply by previous PERIOD's status @
        aMrrdsim = Mrrdsim + deadMrrd;
        if (job<7) and (agestep==1);         @ matching biannual data with annual simulations @
            aobssim  = aobssim + dbldead;
            aSnglsim = aSnglsim + dbldSngl;  @ Multiply by previous WAVE's status @
            aMrrdsim = aMrrdsim + dbldMrrd; 
        endif;
        asstsim = alivesim.*asstsim + bobssim.*beqsim;
//      bobssim = bobssim + newwidow;  // don't include side bequests in assets
    endif;

    asim2    = selif(vec(asstsim[.,2:simyrs]),vec(aobssim[.,2:simyrs]));
    assets_sumtab_all=asim2;
    "Summary Statistics (initial assets excluded)";
    asstqnts = (0.1|0.25|0.50|0.75|0.90|0.95|0.99|0.995|0.999|0.9999);
    quantrec = quantile(asim2,asstqnts);
    if prnres>1;
        "    quantile    assets";;
        asstqnts~quantrec;
        "        mean ";; meanc(asim2); ?;?;
    endif;
    
    aobssim3=aobssim.*(aSnglsim[.,1]*ones(1,simyrs+1));
    asim3    = selif(vec(asstsim[.,2:simyrs]),vec(aobssim3[.,2:simyrs]));
        assets_sumtab_iS=asim3;

    "Summary Statistics (initial assets excluded), Initial Singles";
    asstqnts = (0.1|0.25|0.50|0.75|0.90|0.95|0.99|0.995|0.999|0.9999);
    quantrec = quantile(asim3,asstqnts);
    if prnres>1;
        "    quantile    assets";;
        asstqnts~quantrec;
        "        mean ";; meanc(asim3); ?;?;
    endif;
    
    aobssim4 = aobssim.*(1-(aSnglsim[.,1]*ones(1,simyrs+1)));
    asim4    = selif(vec(asstsim[.,2:simyrs]),vec(aobssim4[.,2:simyrs]));
            assets_sumtab_iC=asim4;

    "Summary Statistics (initial assets excluded), Initial Couples";
    asstqnts = (0.1|0.25|0.50|0.75|0.90|0.95|0.99|0.995|0.999|0.9999);
    quantrec = quantile(asim4,asstqnts);
    if prnres>1;
        "    quantile    assets";;
        asstqnts~quantrec;
        "        mean ";; meanc(asim4); ?;?;
    endif;

      aobssim4 = aobssim.*(aMrrdsim);
    asim4    = selif(vec(asstsim[.,2:simyrs]),vec(aobssim4[.,2:simyrs]));  
            assets_sumtab_C=asim4;

"Summary Statistics (initial assets excluded), Current (Intact) Couples";
    asstqnts = (0.1|0.25|0.50|0.75|0.90|0.95|0.99|0.995|0.999|0.9999);
    quantrec = quantile(asim4,asstqnts);
    if prnres>1;
        "    quantile    assets";;
        asstqnts~quantrec;
        "        mean ";; meanc(asim4); ?;?;
    endif;




    aobssim4=aobssim.*(aSnglsim);
    asim4    = selif(vec(asstsim[.,2:simyrs]),vec(aobssim4[.,2:simyrs]));
            assets_sumtab_S=asim4;

  "Summary Statistics (initial assets excluded), Current (All) Singles";
    asstqnts = (0.1|0.25|0.50|0.75|0.90|0.95|0.99|0.995|0.999|0.9999);
    quantrec = quantile(asim4,asstqnts);
    if prnres>1;
        "    quantile    assets";;
        asstqnts~quantrec;
        "        mean ";; meanc(asim4); ?;?;
    endif;

@save this output@
    if prnres>1;

        save path=^shkpath assets_sumtab_all, assets_sumtab_iS, assets_sumtab_iC, assets_sumtab_C, assets_sumtab_S;
    endif;


  @ Do summary statistics on the bequest distributions - select both newdead and new widows @

    aobssim5 = newdead +newwidow;
    aobssim5 = (aobssim5.>0);
    asim5    = selif(vec(beqsim[.,2:simyrs]),vec(aobssim5[.,2:simyrs]));
    "Summary Statistics All  Bequests";
    asstqnts = (0.1|0.25|0.50|0.75|0.90|0.95|0.99|0.995|0.999|0.9999);
    quantrec = quantile(asim5,asstqnts);
    if prnres>1;
        "    quantile    assets";;
        asstqnts~quantrec;
        "        mean ";; meanc(asim5); ?;?;
    endif;
    
  @ Do summary statiistics on the terminal bequest distributions - select just new dead @

    aobssim5 = newdead;
    asim5    = selif(vec(beqsim[.,2:simyrs]),vec(aobssim5[.,2:simyrs]));
    "Summary Statistics Terminal  Bequests";
    asstqnts = (0.1|0.25|0.50|0.75|0.90|0.95|0.99|0.995|0.999|0.9999);
    quantrec = quantile(asim5,asstqnts);
    if prnres>1;
        "    quantile    assets";;
        asstqnts~quantrec;
        "        mean ";; meanc(asim5); ?;?;
    endif;

  @ Do summary statiistics on the side bequest distributions - select just new widows @

    aobssim6 = newwidow;
    asim6    = selif(vec(beqsim[.,2:simyrs]),vec(aobssim6[.,2:simyrs]));
    "Summary Statistics Side  Bequests";
    asstqnts = (0.1|0.25|0.50|0.75|0.90|0.95|0.99|0.995|0.999|0.9999);
    quantrec = quantile(asim6,asstqnts);
    if prnres>1;
        "    quantile    assets";;
        asstqnts~quantrec;
        "        mean ";; meanc(asim6); ?;?;
    endif;
    
    if simtype==1;
        load path=^shkpath asim96, incsim96, mxsim96, oopsim96, MCXsim96, MCsim96;
    elseif simtype==2;
        load path=^shkpath asimx, incsim96x, mxsim96x, oopsim96x, MCXsim96x, MCsim96x;
        asim96   = asimx[.,1];  incsim96 = incsim96x;  mxsim96 = mxsim96x;
        oopsim96 = oopsim96x;   MCXsim96 = MCXsim96x;  MCsim96 = MCsim96x;
        clear asimx, incsim96x, mxsim96x, oopsim96x, MCXsim96x, MCsim96x;
    endif;

  @ I believe this is unnecessary @
    if (swchRisk==1) and (swchContrisk==0); @ Referee 4 request: no medex risk for surviving spouse @
        asim96   = switchR4(asim96,initSngl[.,1],"asim96");
        incsim96 = switchR4(incsim96,initSngl[.,1],"incsim96");
        mxsim96  = switchR4(mxsim96,initSngl[.,1],"mxsim96");
        oopsim96 = switchR4(oopsim96,initSngl[.,1],"oopsim96");
        MCXsim96 = switchR4(MCXsim96,initSngl[.,1],"MCXsim96");
        MCsim96  = switchR4(MCsim96,initSngl[.,1],"MCsim96");
    endif;

  @ Data include medical spending of those who died between waves.             @
  @ Medical spending at model date t is for year t-1 ->  t, just like the data @
  @ Simulations thus include medical spending of those who just died           @

    medexsim[.,1]    = mxsim96; //*miss(1,1);
    oopmedexsim[.,1] = oopsim96; //*miss(1,1);
    Medicaidsim[.,1] = MCXsim96; //*miss(1,1);
//  getsMcdsim[.,1]  = MCsim96; // *miss(1,1);

    mxobssim  = alivesim + newdead;    
    mxSnglsim = Snglsim + deadSngl; 
    mxMrrdsim = Mrrdsim + deadMrrd;
    if (job<7) and (agestep==1);       @ matching biannual data with annual simulations @
        mxobssim  = mxobssim + dbldead;
        mxSnglsim = mxSnglsim + dbldSngl; 
        mxMrrdsim = mxMrrdsim + dbldMrrd;
        xtraMedex = zeros(_nn,1)~(dbldead[.,2:simyrs+1].*medexsim[.,1:simyrs]);   @ When person dies in previous wave in HRS, EBF does not divide by 2 @
        medexsim  = medexsim.*(1-dbldead)+ dbldead.*xtraMedex;
    endif;

  @ Medicaid usage in the data is current for living, lagged for the currently dead. @
  @ Medicaid spending at model date t is for year t-1 ->  t, just like OOP           @
  @ Simulations thus include Medicaid usage of those who just died @

    mcobssim  = alivesim + newdead;
    mcSnglsim = Snglsim + deadSngl; 
    mcMrrdsim = Mrrdsim + deadMrrd;
    if (job<7) and (agestep==1);    @ matching biannual data with annual simulations @
        mcobssim  = mcobssim + dbldead;
        mcSnglsim = mcSnglsim + dbldSngl; @ Multiply by previous WAVE's status @
        mcMrrdsim = mcMrrdsim + dbldMrrd;
        xtraMCR   = zeros(_nn,1)~(dbldead[.,2:simyrs+1].*getsMcdsim[.,1:simyrs]);    @ Need MCR from previous year (of death) @
        getsMcdsim = getsMcdsim.*(1-dbldead)+dbldead.*xtraMCR; 
    endif;

    if agestep==1;   
        medexsim = (medexsim[.,1:simyrs]+medexsim[.,2:simyrs+1])/2; @ 2-year averages @
        medexsim = mxsim96~medexsim;
    endif;
    toosmall = medexsim.<minmedex;   @ bottom coding @
    medexsim = medexsim.*(1-toosmall) + toosmall*minmedex;
    gothsim  = (mssim2.==1)+(mssim2.==3);
    gothsim  = (gothsim.>0);
    gotwsim  = (mssim2.==2)+(mssim2.==3);
    gotwsim  = (gotwsim.>0);
    NHsim    = (healsimh.==1).*gothsim +(healsimw.==1).*gotwsim;
    NHsim    = NHsim.>0;
    aobsavg  = meanc(aobssim);
    bobsavg  = meanc(bobssim);
    mxobsavg = meanc(mxobssim);
    mcobsavg = meanc(mcobssim);
    clear toosmall, gothsim, gotwsim;   
    
    if (prnres>1 or job>4);

        load path=^iopath cohsim, ztasim, xisim, ztaindexsim, xiindexsim, netIncomesim;

        cohsim       = reshape(cohsim,simyrs+1,_nn)';
        ztasim       = reshape(ztasim,simyrs+1,_nn)';
        xisim        = reshape(xisim,simyrs+1,_nn)';      
        ztaindexsim  = reshape(ztaindexsim,simyrs+1,_nn)';
        xiindexsim   = reshape(xiindexsim,simyrs+1,_nn)';
        netIncomesim = reshape(netIncomesim,simyrs+1,_nn)';

        if (swchRisk==1) and (swchContrisk==0); @ Referee 4 request: no medex risk for surviving spouse @
            cohsim      = switchR4(cohsim,initSngl,"cohsim");
            ztasim       = switchR4(ztasim,initSngl,"ztasim");
            xisim        = switchR4(xisim,initSngl,"xisim");
            ztaindexsim  = switchR4(ztaindexsim,initSngl,"ztaindexsim");
            xiindexsim   = switchR4(xiindexsim,initSngl,"xiindexsim");
            netIncomesim = switchR4(netIncomesim,initSngl,"netIncomesim");
        endif;

        oopmcdsim    = oopmedexsim+Medicaidsim;
        totmedexsim  = oopmcdsim/0.3; // a hack to keep the code running
        insurersim   = totmedexsim-oopmcdsim;
        
        iD=0; do until iD>2;
            if (ID==0);
                ?;"EVERYONE:";
                alivesim2 = alivesim;
                aobssim2  = aobssim;
                bobssim2  = bobssim;
                mxobssim2 = mxobssim;
                mcobssim2 = mcobssim;
                newwidow2 = newwidow;
            elseif (ID==1);
                ?;"MEDICAID RECIPIENTS ONLY:";
                alivesim2 = alivesim.*getsMcdsim;
                aobssim2  = aobssim.*getsMcdsim;
                bobssim2  = bobssim.*getsMcdsim;
                mxobssim2 = mxobssim.*getsMcdsim;
                mcobssim2 = mcobssim.*getsMcdsim;
                newwidow2 = newwidow.*getsMcdsim;
            else;
                ?;"NON-MEDICAID RECIPIENTS:";
                alivesim2 = alivesim.*(1-getsMcdsim);
                aobssim2  = aobssim.*(1-getsMcdsim);
                bobssim2  = bobssim.*(1-getsMcdsim);
                mxobssim2 = mxobssim.*(1-getsMcdsim);
                mcobssim2 = mcobssim.*(1-getsMcdsim);
                newwidow2 = newwidow.*(1-getsMcdsim);
            endif;

            aliveavg2 = meanc(alivesim2);
            aobsavg2  = meanc(aobssim2);
            bobsavg2  = meanc(bobssim2);
            mxobsavg2 = meanc(mxobssim2);
            mcobsavg2 = meanc(mcobssim2);
            nuwdwavg2 = meanc(newwidow2);
       
            simavg   = aliveavg2~bobsavg2;
            simavg   = simavg~(meanc(asstsim.*aobssim2)./aobsavg2)~(meanc(medexsim.*mxobssim2)./mxobsavg2);
            simavg   = simavg~(meanc(getsMcdsim.*mcobssim2)./mcobsavg2)~(meanc(beqsim.*bobssim2)./bobsavg2);
            simavg   = simavg~(meanc(netIncomesim.*alivesim2)./aliveavg2)~(meanc(cohsim.*alivesim2)./aliveavg2);
            simavg   = simavg~(meanc(conssim.*alivesim2)./aliveavg2)~(meanc(oopmedexsim.*alivesim2)./aliveavg2);
            simavg   = simavg~(meanc(Medicaidsim.*alivesim2)./aliveavg2)~(meanc(totmedexsim.*alivesim2)./aliveavg2);
            simavg   = simavg~(meanc(transfersim.*alivesim2)./aliveavg2)~(meanc((ztasim+xisim).*alivesim2)./aliveavg2);
            simavg   = simavg~(meanc(beqsim.*newwidow2)./nuwdwavg2)~nuwdwavg2;
            saobsavg = ones(simyrs,2)~aobsavg2[1:simyrs]~mxobsavg2[1:simyrs]~mcobsavg2[1:simyrs]~bobsavg2[1:simyrs];
            saobsavg = saobsavg~(aliveavg[1:simyrs]*ones(1,8))~nuwdwavg2[1:simyrs];
            simavg2  = {};           

            sa = 1; do until sa>cols(saobsavg);
               simavg2 = simavg2~( saobsavg[1:simyrs,sa]'simavg[1:simyrs,sa]/sumc(saobsavg[1:simyrs,sa]) );
            sa = sa+1; endo;

            "     Year        Survival      beqfrac       assets    h. costs      gets Mcd    bequests   net income";;
            "     cash-o-h   consumption       OOP mx    Medicaid   Total Medex   Total Trans     zeta+xi   side beqs";;
            "  sidebq frac";;
            seqa(momyr1,agestep,simyrs+1)~simavg;
            "   All years ";; simavg2;
        
            if (job/=5); break; endif;

        iD=iD+1; endo;
    endif;


    newdead  = newdead[.,1:simyrs];   dbldead  = dbldead[.,1:simyrs];
    deadSngl = deadSngl[.,1:simyrs];  deadMrrd = deadMrrd[.,1:simyrs];
    dbldSngl = dbldSngl[.,1:simyrs];  dbldMrrd = dbldMrrd[.,1:simyrs];
    newwidow = newwidow[.,1:simyrs];

    save path=^shkpath newdead, dbldead, deadSngl, deadMrrd, dbldSngl, dbldMrrd, newwidow;

    asstsim    = asstsim[.,1:simyrs];      medexsim   = medexsim[.,1:simyrs];
    conssim    = conssim[.,1:simyrs];      mssim2     = mssim2[.,1:simyrs];       
    alivesim   = alivesim[.,1:simyrs];     Snglsim    = Snglsim[.,1:simyrs];
    Mrrdsim    = Mrrdsim[.,1:simyrs];      NHsim      = NHsim[.,1:simyrs]; 
    getsMcdsim = getsMcdsim[.,1:simyrs];  
    aobssim    = aobssim[.,1:simyrs];      aSnglsim   = aSnglsim[.,1:simyrs];
    aMrrdsim   = aMrrdsim[.,1:simyrs];     mxobssim   = mxobssim[.,1:simyrs];
    mxSnglsim  = mxSnglsim[.,1:simyrs];    mxMrrdsim  = mxMrrdsim[.,1:simyrs];
    mcobssim   = mcobssim[.,1:simyrs];     mcSnglsim  = mcSnglsim[.,1:simyrs];
    mcMrrdsim  = mcMrrdsim[.,1:simyrs];   
    
    if simtype==1;
        save path=^shkpath asstsim, medexsim, conssim, mssim2, alivesim, snglsim, mrrdsim, 
                           NHsim, getsMcdsim, aobssim, aSnglsim, aMrrdsim, mxobssim, 
                           mxSnglsim, mxMrrdsim, mcobssim, mcSnglsim, mcMrrdsim;
    elseif simtype==2;
        asstsimx = asstsim;     clear asstsim;
        mxsimx   = medexsim;    clear medexsim;
        conssimx = conssim;     clear conssim;
        mssim2x  = mssim2;      clear mssim2;
        alivex   = alivesim;    clear alivesim;
        snglx    = snglsim;     clear snglsim;
        mrrdx    = mrrdsim;     clear mrrdsim;
        getsMcdx = getsMcdsim;  clear getsMcdsim;
        NHsimx   = NHsim;       clear NHsim;
        iIdxsimx = iIndexsim;   clear iIndexsim; 
        aobsx    = aobssim;     clear aobssim;
        aSnglx   = aSnglsim;    clear aSnglsim;
        aMrrdx   = aMrrdsim;    clear aMrrdsim;
        mxobsx   = mxobssim;    clear mxobssim;
        mxSnglx  = mxSnglsim;   clear mxSnglsim;
        mxMrrdx  = mxMrrdsim;   clear mxMrrdsim;
        mcobsx   = mcobssim;    clear mcobssim;
        mcSnglx  = mcSnglsim;   clear mcSnglsim;
        mcMrrdx  = mcMrrdsim;   clear mcMrrdsim;
        newwidowx = newwidow;   clear newwidow;
              
        save path =^shkpath asstsimx, mxsimx, conssimx, mssim2x, alivex, snglx, mrrdx, 
                            NHsimx, getsMcdx, aobsx, aSnglx, aMrrdx, mxobsx, mxSnglx,
                            mxMrrdx, mcobsx, mcSnglx, mcMrrdx, iIdxsimx, newwidowx;
    endif;

    if (prnres>1 or job>4);

        ztasim      = ztasim[.,1:simyrs];       ztaindexsim  = ztaindexsim[.,1:simyrs];
        xisim       = xisim[.,1:simyrs];        xiindexsim   = xiindexsim[.,1:simyrs];
        beqsim      = beqsim[.,1:simyrs];       bobssim      = bobssim[.,1:simyrs];
        cohsim      = cohsim[.,1:simyrs];       netIncomesim = netIncomesim[.,1:simyrs];
        oopmedexsim = oopmedexsim[.,1:simyrs];  totmedexsim  = totmedexsim[.,1:simyrs];
        Medicaidsim = Medicaidsim[.,1:simyrs];  transfersim  = transfersim[.,1:simyrs];  
        oopmcdsim   = oopmcdsim[.,1:simyrs];    insurersim   = insurersim[.,1:simyrs];  
       
    
        if simtype==1;
            save path=^shkpath ztasim, ztaindexsim, xisim, xiindexsim, beqsim, bobssim,
                               cohsim, netIncomesim, oopmedexsim, totmedexsim, Medicaidsim, 
                               transfersim, insurersim, oopmcdsim, newwidow;
        elseif simtype==2;
            cohsimx   = cohsim;       clear cohsim;
            ztasimx   = ztasim;       clear ztasim;
            xisimx    = xisim;        clear xisim;
            oopmxsimx = oopmedexsim;  clear oopmedexsim;
            totmxsimx = totmedexsim;  clear totmedexsim;
            ztaindx   = ztaindexsim;  clear ztaindexsim;   
            xiindx    = xiindexsim;   clear xiindexsim;
            Medicaidx = Medicaidsim;  clear Medicaidsim;
            beqsimx   = beqsim;       clear beqsim;
            bobsx     = bobssim;      clear bobssim;
            transferx = transfersim;  clear transfersim;
            incsimx   = netIncomesim; clear netIncomesim;
            insurerx  = insurersim;   clear insurersim;
            oopmcdx   = oopmcdsim;    clear oopmcdsim;
              
            save path =^shkpath cohsimx, ztasimx, ztaindx, xisimx, xiindx, beqsimx, 
                                bobsx, incsimx, oopmxsimx, totmxsimx, Medicaidx,  
                                transferx, insurerx, oopmcdx;
        endif;
    endif;


retp(); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
PIrank:  Sorts PI data into rank ordering
*/
proc(1) = PIrank(data,wgts);

    local srtddata, srtd2, k, rn, cdf;

  /*-----------------------Remove Missing Observations-----------------------*/
    rn       = rows(data);
    data     = missrv(data,mvcode)~wgts~seqa(1,1,rn);
    srtddata = sortc(data,1);

    k        = (srtddata[.,1].==mvcode);
    k        = k'k; 
    if k > 0;
        srtd2 = srtddata[1:k,.];
    elseif k==0;
        srtd2 = {};
    endif;
    
    srtddata = srtddata[k+1:rn,.];
    cdf      = srtddata[.,2];                /* Base distribution on Weights */
    cdf      = cumsumc(cdf)/sumc(cdf);
    srtddata[.,1] = cdf;                 /* replace non-missing observations */

  /*---------------------Add in Markers for Missing Data---------------------*/
    data   = srtd2|srtddata;
    data   = sortc(data,3);
    data   = data[.,1];
    data   = miss(data,mvcode);

retp(data); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
PIQuant:  Finds Permanent Income quantiles and Identifies PI interval
*/
proc(3) = PIquant(data,wgts,quants,chktie);

    local qnum, rn, cndmnum, qnts, srtddata, srtd2, k, rn1, cdf, qn, qno, 
          qntype, i, j, qnt, rn2;

    qnum     = rows(quants);
    rn       = rows(data);
    if quants[qnum]==0;
        qnts    = 1~maxc(data);
        cndmnum = 1~rn;
        qntype  = ones(rn,1);
        goto pidone;
    endif;

    qnts     = zeros(qnum,2);
    qnts[.,1]= quants;
    cndmnum  = zeros(qnum+1,2);
    cndmnum[.,1] = (quants|1);

  /*-----------------------Remove Missing Observations-----------------------*/
    data     = missrv(data,mvcode)~wgts~seqa(1,1,rn);
    srtddata = sortc(data,1);
    k        = (srtddata[.,1].==mvcode);
    k        = k'k; 
    if k > 0;
        srtd2    = srtddata[1:k,.];
    elseif k==0;
        srtd2 = {};
    endif;
    srtddata = srtddata[k+1:rn,.];

    rn1      = rn-k;                  /* Number of non-missing observations */
    cdf      = srtddata[.,2];                /* Base distribution on Weights */
    cdf      = cumsumc(cdf)/sumc(cdf);
    qno      = 0;
    qntype   = ones(rn1,1);
        
    i=1; do until i>qnum;
        qn   = cdf.< quants[i]; 
        qn   = qn'qn+1;
        qnt  = srtddata[qn,1];
        qnts[i,2] = qnt;

      /*--------Adjust for ties:  shouldn't happen w/ continuous dist--------*/
        if chktie == 1;
            j  = (srtddata[qn:rn1,1].==qnt);
            j  = j'j -1; 
            qn = qn+j;
        endif;

        if qn==qno;  
            i=i+1;
            continue;
        endif;

        rn2 = qn-qno;                     /* Counts for interval (q_i-1,q_i] */
        cndmnum[i,2] = rn2;
        qntype[qno+1:qn] = i*ones(rn2,1);     /* observations in (q_i-1,q_i] */

        qno = qn;
    i=i+1; endo;                               /* End loop through quantiles */

  /*----------------Count observations above highest quantile----------------*/
    if qn < rn1;
        qntype[qn+1:rn1] = (qnum+1)*ones(rn1-qn,1);
        cndmnum[qnum+1,2] = rn1 - qn;        
    endif;

  /*---------------------Add in Markers for Missing Data---------------------*/

    if k>0;  qntype = zeros(k,1)|qntype;  endif;
    data   = srtd2|srtddata;
    data   = data~qntype;
    data   = sortc(data,3);
    qntype = data[.,4];

pidone:

retp(qnts,cndmnum,qntype); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
PIQuant2:  Finds Permanent Income quantiles and Identifies PI interval
           Assumes data have been normalized to [0,1] interval
*/
proc(3) = PIquant2(data,quants,chktie);

    local qnum, rn, cndmnum, qnts, srtddata, srtd2, k, rn1, cdf, qn, qno, 
          qntype, i, j, qnt, rn2;

    qnum     = rows(quants);
    rn       = rows(data);
    if quants[qnum]==0;
        qnts    = 1~maxc(data);
        cndmnum = 1~rn;
        qntype  = ones(rn,1);
        goto pidone2; 
    endif;

    qnts     = zeros(qnum,2);
    qnts[.,1]= quants;
    cndmnum  = zeros(qnum+1,2);
    cndmnum[.,1] = (quants|1);

  /*-----------------------Remove Missing Observations-----------------------*/
    data     = missrv(data,mvcode)~seqa(1,1,rn);
    srtddata = sortc(data,1);
    k        = (srtddata[.,1].==mvcode);
    k        = k'k; 
    if k > 0;
        srtd2    = srtddata[1:k,.];
    elseif k==0;
        srtd2 = {};
    endif;
    srtddata = srtddata[k+1:rn,.];

    rn1      = rn-k;                  /* Number of non-missing observations */
    cdf      = srtddata[.,1];
    qno      = 0;
    qntype   = ones(rn1,1);
        
    i=1; do until i>qnum;
        qn   = cdf.<= quants[i]; 
        qn   = qn'qn;
        qnt  = srtddata[qn,1];
        qnts[i,2] = qnt;

      /*--------Adjust for ties:  shouldn't happen w/ continuous dist--------*/
        if chktie == 1;
            j  = (srtddata[qn:rn1,1].==qnt);
            j  = j'j -1; 
            qn = qn+j;
        endif;

        if qn==qno;  
            i=i+1;
            continue;
        endif;

        rn2 = qn-qno;                     /* Counts for interval (q_i-1,q_i] */
        cndmnum[i,2] = rn2;
        qntype[qno+1:qn] = i*ones(rn2,1);     /* observations in (q_i-1,q_i] */

        qno = qn;
    i=i+1; endo;                               /* End loop through quantiles */

  /*----------------Count observations above highest quantile----------------*/
    if qn < rn1;
        qntype[qn+1:rn1] = (qnum+1)*ones(rn1-qn,1);
        cndmnum[qnum+1,2] = rn1 - qn;        
    endif;

  /*---------------------Add in Markers for Missing Data---------------------*/

    if k>0;  qntype = zeros(k,1)|qntype;  endif;
    data   = srtd2|srtddata;
    data   = data~qntype;
    data   = sortc(data,2);
    qntype = data[.,3];

pidone2:

retp(qnts,cndmnum,qntype); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
Getquant:  Finds quantiles, after removing missing values
           Can handle weighted data
*/
proc(2) = getquant(data,wgts,quants,chktie);

    local qnum, rn, cndmnum, qnts, srtddata, srtd2, k, rn1, cdf, qn, qno, 
          i, j, qnt, rn2;

    qnum     = rows(quants);
    rn       = rows(data);
    qnts     = zeros(qnum,2);
    qnts[.,1]= quants;
    cndmnum  = zeros(qnum+1,2);
    cndmnum[.,1] = (quants|1);

    data     = packr(data~wgts);              /* Remove Missing Observations */
    srtddata = sortc(data,1);
    rn1      = rows(srtddata);         /* Number of non-missing observations */
    cdf      = srtddata[.,2];                /* Base distribution on Weights */
    cdf      = cumsumc(cdf)/sumc(cdf);
    qno      = 0;
        
    i=1; do until i>qnum;
        qn   = cdf.< quants[i]; 
        qn   = qn'qn+1;
        qnt  = srtddata[qn,1];
        qnts[i,2] = qnt;

      /*--------Adjust for ties:  shouldn't happen w/ continuous dist--------*/
        if chktie == 1;
            j  = (srtddata[qn:rn1,1].==qnt);
            j  = j'j -1; 
            qn = qn+j;
        endif;

        if qn==qno;  
            i=i+1;
            continue;
        endif;

        rn2 = qn-qno;                     /* Counts for interval (q_i-1,q_i] */
        cndmnum[i,2] = rn2;
        qno = qn;
    i=i+1; endo;                               /* End loop through quantiles */

  /*----------------Count observations above highest quantile----------------*/
    if qn < rn1;  cndmnum[qnum+1,2] = rn1 - qn;  endif;

retp(qnts,cndmnum); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
Getqunt2:  Finds quantiles, after removing missing values
           Uses GAUSS procedures
*/
proc(2) = getqunt2(data,quants);

    local qnum, rn, cndmnum, qnts, k, qn, qno, i, qnt, rn2;

    qnum      = rows(quants);
    qnts      = zeros(qnum,2);
    qnts[.,1] = quants;
    cndmnum   = zeros(qnum+1,2);
    cndmnum[.,1] = (quants|1);

    data      = packr(data);                  /* Remove Missing Observations */
    rn        = rows(data);
    if rn>1;
        qnts[.,2] = quantile(data,quants);
    else;
        qnts[.,2] = -1e6*ones(qnum,1);
    endif;
        
    qno      = 0;
    i=1; do until i>qnum;
        qn   = data.<=qnts[i,2]; 
        qn   = qn'qn;
        if qn==qno;  
            i=i+1;
            continue;
        endif;

        rn2 = qn-qno;                     /* Counts for interval (q_i-1,q_i] */
        cndmnum[i,2] = rn2;
        qno = qn;
    i=i+1; endo;                               /* End loop through quantiles */

  /*----------------Count observations above highest quantile----------------*/
    if qn < rn;  cndmnum[qnum+1,2] = rn - qn;  endif;

retp(qnts,cndmnum); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
Getmean:  Finds means, after removing missing values
*/
proc(2) = getmean(data,wgts);

    local mns, cndmnum;

    mns     = zeros(1,2);
    cndmnum = zeros(1,2);
    data    = packr(data~wgts);              /* Remove Missing Observations */
    if ismiss(data) == 1;
        mns[2] = -1e6;
    elseif wgtddata==0;
        mns[2] = meanc(data[.,1]);
        cndmnum[2] = rows(data);
    else;  
        wgts   = data[.,2];
        wgts   = wgts/sumc(wgts);
        data   = data[.,1].*wgts;                     /* Use weighted data */
        mns[2] = sumc(data);
        cndmnum[2] = rows(data);
    endif;

retp(mns,cndmnum); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(2) = getchrt(data,cohorts_j);

    local rn, chrtnum_j, chrtcnts, srtddata, srtd2, k, rn1, cn, cno, chrttype, 
          h, j, rn2, rn3, agevec;

    rn            = rows(data);
    chrtnum_j     = rows(cohorts_j)-1;
    chrtcnts      = zeros(chrtnum_j,4);
    chrtcnts[.,1] = seqa(1,1,chrtnum_j);
    chrtcnts[.,2] = cohorts_j[1:chrtnum_j]+1;
    chrtcnts[.,3] = cohorts_j[2:chrtnum_j+1];

  /*-----------------------Remove Missing Observations-----------------------*/
    data     = missrv(data,mvcode)~seqa(1,1,rn);
    srtddata = sortc(data,1);
    k        = (srtddata[.,1]==mvcode);
    k        = k'k;
 
    if k > 0;
        srtd2 = srtddata[1:k,.];
    elseif k==0;
        srtd2 = {};
    endif;
    srtddata = srtddata[k+1:rn,.];

    rn1      = rn-k;                  /* Number of non-missing observations */
    chrttype = ones(rn1,1);
    cno      = 0;

    agevec   = srtddata[.,1];            /* Use age in first wave */
         
    h=chrtnum_j; do until h<1; 
        cn  = agevec.>cohorts_j[h]; /* Note that cohorts has chrtnum+1 elements */
        cn  = cn'cn;

        if cn==cno;  
            h=h-1;
            continue;
        endif;

        rn2 = cn-cno;                /* Counts for interval (age_h,age_h+1) */
        rn3 = rn1 - cn;
        chrttype[rn3+1:rn3+rn2] = h*ones(rn2,1); /* observations in (age_h,age_h+1) */
        cno = cn;
    h=h-1; endo;                              /* End loop through cohorts */

  /*---------------------------Zero Out Outliers----------------------------*/ 
    chrttype = chrttype.*(1-(agevec.>cohorts_j[chrtnum_j+1]));
    chrttype = chrttype.*(1-(agevec.<=cohorts_j[1]));

    h=1; do until h>chrtnum_j;
        cn = (chrttype.==h);
        chrtcnts[h,4] = cn'cn;
    h=h+1; endo;

  /*--------------------Add in Markers for Missing Data---------------------*/
    if k>0;  chrttype = zeros(k,1)|chrttype;  endif;
    data     = srtd2|srtddata;
    data     = data~chrttype;
    data     = sortc(data,2);
    chrttype = data[.,3];

retp(chrtcnts,chrttype); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(2) = simqunts(pisim96, agesim96, datasim, alivesim_j, pistate_j, cohorts_j,  
                   quants_j, mmtyrs_j, comptype, wgts);

    local pinum_j, PIqnts, PIcnts, PItype, chrtnum_j, qnum_j, chrtcnts, chrttype, 
          alivesim_jj, indicat0, indicat, iChrt, iPI, iQunt, iYear, dataprfs, 
          datacnts, data, tempprf, tempnum, recsize, recsize2, cn, nummtx;

    pinum_j   = rows(pistate_j) + (pistate_j /= 0);
    chrtnum_j = rows(cohorts_j)-1;
    qnum_j    = rows(quants_j); 

    {PIqnts,PIcnts,PItype} = PIquant2(pisim96,pistate_j,chktie)@ PIquant(pisim96,wgts,pistate_j,chktie)@;

    {chrtcnts,chrttype} = getchrt(agesim96,cohorts_j);
    if prnres>1;
        ?;"PI counts";;PIcnts;"Cohort counts";;chrtcnts;
    endif;

    cn = cols(alivesim_j);
    if comptype==1;
        if prnres>1;
            ?;"Looking at Survivors Only!!";
        endif;
        alivesim_jj = minc(alivesim_j[.,1|(cn@-4@)]')*ones(1,cn);  @ Note:  data are sometimes missing in middle waves @
        alivesim_j  = alivesim_jj.*alivesim_j;
    endif;

    nummtx   = zeros(chrtnum_j,pinum_j); 
    recsize  = chrtnum_j|pinum_j|qnum_j|mmtyrs_j;
    recsize2 = chrtnum_j|pinum_j|1|mmtyrs_j;
    dataprfs = arrayinit(recsize,mvcode);
    datacnts = arrayinit(recsize2,0);

    iChrt=1; do until iChrt>chrtnum_j;
        iPI=1; do until iPI>pinum_j;
            indicat0 = (chrttype.==iChrt).*(PItype.==iPI);
            indicat  = indicat0.*alivesim_j[.,1];
            nummtx[iChrt,iPI] = rows(indicat)*meanc(indicat);

            indicat = (indicat0*ones(1,mmtyrs_j));
            indicat = indicat.*alivesim_j;
         @ "Cohort = ";;iCHrt;; "PI Quintile = ";;iPI;; _nn*meanc(indicat)';  @
            data    = datasim.*miss(indicat,0);
            iYear=1; do until iYear>mmtyrs_j;
                if sumc(indicat[.,iYear])<quantmin; /* quantile() won't work */
                    iYear=iYear+1; continue;
                 @  break; @
                endif;
                if (quants_j==0); /* using means, rather than quantiles */
                    {tempprf,tempnum} = getmean(data[.,iYear],wgts);
                else;
                    if wgtddata==0;
                        {tempprf,tempnum} = getqunt2(data[.,iYear],quants_j);
                    else;
                        {tempprf,tempnum} = getquant(data[.,iYear],wgts,quants_j,chktie); 
                    endif;
                endif;
                iQunt=1; do until iQunt>qnum_j;
                    dataprfs[iChrt,iPI,iQunt,iYear] = tempprf[iQunt,2];
                  @ datacnts[iChrt,iPI,iQunt,iYear] = tempnum[iQunt,2]; @
                iQunt=iQunt+1; endo;
                datacnts[iChrt,iPI,1,iYear] = sumc(tempnum[.,2]);
            iYear=iYear+1; endo;
        iPI=iPI+1; endo;
    iChrt=iChrt+1; endo;

    if prnres>1;
       ?;"Cohort-PI counts (from first wave in moment criterion)";;nummtx;
    endif;

retp(dataprfs,datacnts); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(7) = simcrrl(pisim96, agesim96, datasim, alivesim_j, pistate_j, cohorts_j,
                  mmtyrs_j, comptype, wgts);

    local pinum_j, PIqnts, PIcnts, PItype, chrtnum_j, chrtcnts, chrttype, 
          indicat0, indicat, iChrt, iPI, iYear, icY0, icY1, icY2, meanprfs, 
          meancnts, stdprfs, crrlprf1, crrlcnt1, crrlprf2, crrlcnt2,

          data0, dY0, dY1, dY2, tempprf, tempnum, recsize, cn;

    pinum_j   = rows(pistate_j) + (pistate_j /= 0);
    chrtnum_j = rows(cohorts_j)-1;

    {PIqnts,PIcnts,PItype} = PIquant2(pisim96,pistate_j,chktie);

    {chrtcnts,chrttype} = getchrt(agesim96,cohorts_j);
    if prnres>1;
        ?;"PI counts";;PIcnts;"Cohort counts";;chrtcnts;?;
    endif;

    cn = cols(alivesim_j);
    if comptype==1;
        ?;"Looking at Survivors Only!!";
        alivesim_j = minc(alivesim_j[.,1|cn]')*ones(1,cn);
    endif;

    recsize  = chrtnum_j|pinum_j|mmtyrs_j;     @ means @ 
    meanprfs = arrayinit(recsize,mvcode);
    meancnts = arrayinit(recsize,mvcode);
    stdprfs  = arrayinit(recsize,mvcode);
    recsize  = chrtnum_j|pinum_j|(mmtyrs_j-1); @ First autocorrelations @
    crrlprf1 = arrayinit(recsize,mvcode);
    crrlcnt1 = arrayinit(recsize,0);
    recsize  = chrtnum_j|pinum_j|(mmtyrs_j-2); @ Second autocorrelations @
    crrlprf2 = arrayinit(recsize,mvcode);
    crrlcnt2 = arrayinit(recsize,0);


    iChrt=1; do until iChrt>chrtnum_j;
        iPI=1; do until iPI>pinum_j;
            indicat0 = (chrttype.==iChrt).*(PItype.==iPI);
            indicat  = (indicat0*ones(1,mmtyrs_j));
            indicat = indicat.*alivesim_j;

        /*  "Cohort = ";;iCHrt;; "PI Quintile = ";;iPI;; meanc(indicat)';  */
            data0   = datasim.*miss(indicat,0);
            dY0     = datasim[.,1]*0;
            dY1     = dY0;
            dY2     = dY0;

            iYear=1; do until iYear>mmtyrs_j;

                if sumc(indicat[.,iYear])<quantmin; /* quantile() won't work */
                    break;
                endif;

                dY0 = data0[.,iYear];
                {tempprf,tempnum} = getmean(dY0,wgts);
                meanprfs[iChrt,iPI,iYear] = tempprf[1,2];
                meancnts[iChrt,iPI,iYear] = tempnum[1,2];

                dY0 = dY0 - tempprf[1,2];     /* Convert into residual */
                {tempprf,tempnum} = getmean(dY0^2,wgts);
                stdprfs[iChrt,iPI,iYear] = sqrt(tempprf[1,2]);
                dY0 = dY0/sqrt(tempprf[1,2]);    /* Normalize residual */

                if iYear>1;
                    {tempprf,tempnum} = getmean(dY0.*dY1,wgts);
                    crrlprf1[iChrt,iPI,iYear-1] = tempprf[1,2];
                    crrlcnt1[iChrt,iPI,iYear-1] = tempnum[1,2];
                endif;

                if iYear>2;
                    {tempprf,tempnum} = getmean(dY0.*dY2,wgts);
                    crrlprf2[iChrt,iPI,iYear-2] = tempprf[1,2];
                    crrlcnt2[iChrt,iPI,iYear-2] = tempnum[1,2];
                endif;

                dY2 = dY1;
                dY1 = dY0;                    
 
            iYear=iYear+1; endo;
        iPI=iPI+1; endo;
    iChrt=iChrt+1; endo;

retp(meanprfs, meancnts, stdprfs, crrlprf1, crrlcnt1, crrlprf2, crrlcnt2); 
endp;
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
getpdf:  Finds kernel densities, using non-missing data
         Kernel density estimator written by Ruud Koenig
*/

proc(1) = getpdf(data,indicat,xvals,wgts);

    local rn, k, iWave, datac, wgtsc, pdfs, kdns, dkdns, bw;

    indicat = indicat.>0;
    indicat = miss(indicat,0);
    data    = data.*indicat;
    pdfs    = {};
    rn      = rows(data);

    iWave=1; do until iWave>cols(data);
        kdns  = 0*xvals[iWave];
        datac = data[.,iWave]~wgts;
        datac = packr(datac);                 /* Remove Missing Observations */

        if ismiss(datac) /= 1;            
            {kdns, dkdns, bw} = ukernel(xvals[iWave],datac[.,1],0,datac[.,2],&k_gauss); 
        endif;
        pdfs  = pdfs|kdns;
    iWave=iWave+1; endo;

retp(pdfs); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(6) = makemmts_q(PIdat, agedat, data, obsdat_j, wgts, dataprfs, pistate_j, 
                     cohorts_j, quants_j, mmtyrs_j, keepinit, addpdfs);

    local nobs, PIqnts, PIcnts, PItype, pinum_j, chrtcnts, chrttype, chrtnum_j, 
          alivedat, indicat0, indicat, iChrt, iPI, iQunt, iYear, cnum, qnum_j, 
          tempprf, temppdf, mmtdata, mmtmtx, obsmtx, mmtvec, iM, mmtskip,
          mmtskeep, zn, obsvec, qntvec, pdfvec;

    nobs      = rows(PIdat);
    pinum_j   = rows(pistate_j) + (pistate_j /= 0);
    chrtnum_j = rows(cohorts_j)-1;
    qnum_j    = rows(quants_j);
    if quants_j==0;  addpdfs=0; endif;  /* Looking at means */

    {PIqnts,PIcnts,PItype} = PIquant2(PIdat,pistate_j,chktie);
    {chrtcnts,chrttype}    = getchrt(agedat,cohorts_j);

    mmtmtx   = {};                       /* rows->obs, cols->moment function */
    obsmtx   = {};
    qntvec   = {};
    pdfvec   = {};
    mmtskip  = {};
    mmtskeep = {};
    iM       = 0;

    iQunt=1; do until iQunt>qnum_j; 

        iChrt=1; do until iChrt>chrtnum_j;

            iPI=1; do until iPI>pinum_j;

                indicat0 = (chrttype.==iChrt).*(PItype.==iPI);
                indicat  = indicat0*ones(1,mmtyrs_j);
                indicat  = indicat.*obsdat_j;
                indicat  = indicat.*wgts;

                tempprf  = getmatrix(dataprfs,iChrt|iPI|iQunt); /* a row vector */
                qntvec   = qntvec|(tempprf');
                if quants_j==0;   /* looking at means */
                    mmtdata = (data - tempprf);
                else;
                    mmtdata = (data.<=tempprf) - quants_j[iQunt];
                endif;
                mmtdata  = mmtdata.*indicat;
                mmtmtx   = mmtmtx~mmtdata;
                obsmtx   = obsmtx~indicat;
                temppdf  = -tempprf';
                if addpdfs==1;
                    temppdf = getpdf(data,indicat,tempprf',wgts);
                endif;
                pdfvec  = pdfvec|temppdf;
                cnum    = sumc(indicat.>0);

             /* Identify moments to drop:  These include moments using   */
             /* the initial asset distribution, or moments with too few  */
             /* observations */
                iYear=1; do until iYear>mmtyrs_j; 
                    iM = iM+1;
                    mmtskeep = mmtskeep|iM;
                    if cnum[iYear] < cellmin;
                        mmtskip = mmtskip|iM;
                        cnum[iYear:mmtyrs_j] = zeros(mmtyrs_j-iYear+1,1); /* Skip all future years */
                    elseif (iYear==1) and (keepinit==0);
                        mmtskip = mmtskip|iM;
                    endif;
                iYear = iYear+1; endo;
            iPI=iPI+1; endo;
        iChrt=iChrt+1; endo;
    iQunt=iQunt+1; endo;

    if rows(mmtskip)>0;
        mmtskeep[mmtskip] = zeros(rows(mmtskip),1);
    endif;
    mmtskeep = sortc(mmtskeep,1);
    zn       = sumc(mmtskeep.< 0.99);
    mmtskeep = mmtskeep[zn+1:iM];

    mmtmtx = mmtmtx[.,mmtskeep];     /* Delete moments derived from initial */
    obsmtx = obsmtx[.,mmtskeep];                  /* distribution of assets */
    qntvec = qntvec[mmtskeep];
    pdfvec = pdfvec[mmtskeep];

    mmtvec = meanc(mmtmtx);
    obsvec = meanc(obsmtx);

retp(qntvec,pdfvec,mmtskeep,iM,mmtmtx,obsmtx); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(5) = makemmts_c(PIdat, agedat, data0, obsdat_j, wgts, meanprfs, stdprfs, 
                     crrlprf1, crrlprf2, pistate_j, cohorts_j, mmtyrs_j);

    local nobs, PIqnts, PIcnts, PItype, pinum_j, chrtcnts, chrttype, chrtnum_j, 
          alivedat, indicat0, indicat, iChrt, iPI, iQunt, iYear, cnum, meanvec, 
          data1, stdvec, dY0, dY1, dY2, icY0, icY1, icY2, indicati, tempprf, 
          mmtdata, mmtmtx, obsmtx, mmtvec, iM, mmtskip, mmtskeep, zn, obsvec, 
          crrlvec;

    nobs      = rows(PIdat);
    pinum_j   = rows(pistate_j) + (pistate_j /= 0);
    chrtnum_j = rows(cohorts_j)-1;

    {PIqnts,PIcnts,PItype} = PIquant2(PIdat,pistate_j,chktie);
    {chrtcnts,chrttype}    = getchrt(agedat,cohorts_j);

    mmtmtx   = {};                       /* rows->obs, cols->moment function */
    obsmtx   = {};
    crrlvec  = {};
    mmtskip  = {};
    mmtskeep = {};
    iM       = 0;

    iChrt=1; do until iChrt>chrtnum_j;

        iPI=1; do until iPI>pinum_j;

            indicat0 = (chrttype.==iChrt).*(PItype.==iPI);
            indicat  = indicat0*ones(1,mmtyrs_j);
            indicat  = indicat.*obsdat_j;
            indicat  = indicat.*sqrt(wgts);      @ terms are multiplied below @

         /* meanvec and stdvec should be from data as the model is matching  */
         /* level means, not log means or deviations.                        */

            meanvec = getmatrix(meanprfs,iChrt|iPI);  /* a row vector */
            data1   = data0 - meanvec;             /* Convert into residuals */               
            stdvec  = getmatrix(stdprfs,iChrt|iPI);  
            data1   = data1./stdvec;                   /* Normalize residual */
            dY0     = data1[.,1]*0;
            dY1     = dY0;
            dY2     = dY0;
            icY0    = dY0;
            icY1    = dY0;
            icY2    = dY0;

            iYear=1; do until iYear>mmtyrs_j;

                dY0  = data1[.,iYear];
                icY0 = indicat[.,iYear];

                if iYear>2; @ We lack 2-year averages for year 1 @
                    tempprf  = getscalar3d(crrlprf1,iChrt,iPI,iYear-1);
                    crrlvec  = crrlvec|tempprf;
                    mmtdata  = dY0.*dY1 - tempprf;
                    indicati = icY0.*icY1;
                    mmtdata  = mmtdata.*indicati;
                    mmtmtx   = mmtmtx~mmtdata;
                    obsmtx   = obsmtx~indicati;
                    cnum     = sumc(indicati.>0);
                    iM       = iM+1;
                    mmtskeep = mmtskeep|iM;
                    if cnum < cellmin; /* Drop moments with too few observations */
                        mmtskip = mmtskip|iM;
                    endif;
                endif;

                if iYear>3;
                    tempprf  = getscalar3d(crrlprf2,iChrt,iPI,iYear-2);
                    crrlvec  = crrlvec|tempprf;
                    mmtdata  = dY0.*dY2 - tempprf;
                    indicati = icY0.*icY2;
                    mmtdata  = mmtdata.*indicati;
                    mmtmtx   = mmtmtx~mmtdata;
                    obsmtx   = obsmtx~indicati;
                    cnum     = sumc(indicati.>0);
                    iM       = iM+1;
                    mmtskeep = mmtskeep|iM;
                    if cnum < cellmin;
                        mmtskip = mmtskip|iM;
                    endif;
                endif;

                dY2  = dY1;
                dY1  = dY0; 
                icY2 = icY1;
                icY1 = icY0;                   
 
            iYear=iYear+1; endo;
        iPI=iPI+1; endo;
    iChrt=iChrt+1; endo;

    if rows(mmtskip)>0;
        mmtskeep[mmtskip] = zeros(rows(mmtskip),1);
    endif;
    mmtskeep = sortc(mmtskeep,1);
    zn       = sumc(mmtskeep.< 0.99);
    mmtskeep = mmtskeep[zn+1:iM];

    mmtmtx  = mmtmtx[.,mmtskeep];  
    obsmtx  = obsmtx[.,mmtskeep];  
    crrlvec = crrlvec[mmtskeep];

    mmtvec  = meanc(mmtmtx);
    obsvec  = meanc(obsmtx);

retp(crrlvec,mmtskeep,iM,mmtmtx,obsmtx); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(5) = makemmts(PIdat, agedat, asstdat, Sngldat, aSngldat, Mrrddat, aMrrddat, 
                   wdwdat, awdwdat, aobsdat, bobsdat, daobsdat, dbobsdat, wgts, 
                   asstqnts_s, asstqnts_c, mxdat, mxobsdat, mxquants, mxmeans, 
                   lmxmnsdat, lmxstddat, mxcrrls1, mxcrrls2, Mcdat, Mcobsdat, 
                   Mcdmns, noisewgt, newnoise, addpdfs);

    local mmtvec_a, obsvec_a, qntvec_a, pdfvec_a, mmtskeep_a, iM_a, mmtmtx_a, 
          obsmtx_a, mmtvec_m, obsvec_m, qntvec_m, pdfvec_m, mmtskeep_m, iM_m, 
          mmtmtx_m, obsmtx_m, meanvec_m, crrlvec_m, mmtvec, obsvec, qntvec, 
          pdfvec, mmtskeep, iM, mmtmtx, obsmtx, mmttype, nmom, cn, MSMval, i, 
          subCrit, rn1, rn2, rn11, rn22, j, subQ;

/*  First, evaluate quantiles for assets */

    {qntvec_a,pdfvec_a,mmtskeep_a,iM_a,mmtmtx_a,obsmtx_a}
        = makemmts_q(PIdat,agedat[.,1],asstdat,aobsdat.*aSngldat,datawgts,
                     asstqnts_s,pistate_a,cohorts_a,quants_a,mmtyrs,0,addpdfs);

    mmtmtx     = mmtmtx_a;
    obsmtx     = obsmtx_a;
    qntvec     = qntvec_a;
    pdfvec     = pdfvec_a;
    mmtskeep   = mmtskeep_a;
    iM         = iM_a;
    rn1        = rows(mmtskeep_a);
    mmttype    = ones(iM_a,1);

    {qntvec_a,pdfvec_a,mmtskeep_a,iM_a,mmtmtx_a,obsmtx_a}
        = makemmts_q(PIdat,agedat[.,1],asstdat,aobsdat.*aMrrddat,datawgts,
                     asstqnts_c,pistate_a,cohorts_a,quants_a,mmtyrs,0,addpdfs);

    mmtmtx     = mmtmtx~mmtmtx_a;
    obsmtx     = obsmtx~obsmtx_a;
    qntvec     = qntvec|qntvec_a;
    pdfvec     = pdfvec|pdfvec_a;
    mmtskeep   = mmtskeep|(mmtskeep_a+iM);
    rn2        = rows(mmtskeep_a);
    iM         = iM+iM_a;
    mmttype    = mmttype|ones(iM_a,1);
    
/*  Next, evaluate quantiles for Medex */

    if mxqtmmts==1;
        
        {qntvec_m,pdfvec_m,mmtskeep_m,iM_m,mmtmtx_m,obsmtx_m}
            = makemmts_q(PIdat,agedat[.,1],mxdat,mxobsdat,datawgts,
                         mxquants,pistate_m,cohorts_m,quants_m,mmtyrs,0,addpdfs);

        mmtmtx     = mmtmtx~mmtmtx_m;
        obsmtx     = obsmtx~obsmtx_m;
        qntvec     = qntvec|qntvec_m;
        pdfvec     = pdfvec|pdfvec_m;
        mmtskeep_m = mmtskeep_m + iM;
        mmtskeep   = mmtskeep|mmtskeep_m;
        iM         = iM+iM;
        mmttype    = mmttype|(2*ones(iM_m,1));

    endif;
        
/*  Next, evaluate Medex means */

    if mxmnmmts==1;

        {meanvec_m,pdfvec_m,mmtskeep_m,iM_m,mmtmtx_m,obsmtx_m}
            = makemmts_q(PIdat,agedat[.,1],mxdat,mxobsdat,datawgts,
                         mxmeans,pistate_m,cohorts_m,0,mmtyrs,0,0);

        mmtmtx     = mmtmtx~mmtmtx_m;
        obsmtx     = obsmtx~obsmtx_m;
        qntvec     = qntvec|meanvec_m;
        mmtskeep_m = mmtskeep_m + iM;
        mmtskeep   = mmtskeep|mmtskeep_m;
        iM         = iM+iM_m;
        mmttype    = mmttype|(3*ones(iM_m,1));
           
    endif;

/*  Next, look at log Medex autocorrelations */

    if mxcrrlmmts==1; 

        {crrlvec_m,mmtskeep_m,iM_m,mmtmtx_m,obsmtx_m}
            = makemmts_c(PIdat,agedat[.,1],ln(mxdat+(1-mxobsdat)),
                         mxobsdat,datawgts,lmxmnsdat,lmxstddat,mxcrrls1,mxcrrls2,
                         pistate_m,cohorts_m,mmtyrs);

        mmtmtx     = mmtmtx~mmtmtx_m;
        obsmtx     = obsmtx~obsmtx_m;
        qntvec     = qntvec|crrlvec_m;
        mmtskeep_m = mmtskeep_m + iM;
        mmtskeep   = mmtskeep|mmtskeep_m;
        iM         = iM+iM_m;
        mmttype    = mmttype|(4*ones(iM_m,1));
        
    endif;        
        
/*  Next, look at Medicaid receipt rates */
        
    if mcmnmmts==1;

        {meanvec_m,pdfvec_m,mmtskeep_m,iM_m,mmtmtx_m,obsmtx_m}
            = makemmts_q(PIdat,agedat[.,1],Mcdat,mcobsdat,datawgts,
                         Mcdmns,pistate_mc,cohorts_m,0,mmtyrs,0,0);
            
        mmtmtx     = mmtmtx~mmtmtx_m;
        obsmtx     = obsmtx~obsmtx_m;
        qntvec     = qntvec|meanvec_m;
        mmtskeep_m = mmtskeep_m + iM;
        mmtskeep   = mmtskeep|mmtskeep_m;
        iM         = iM+iM_m;
        mmttype    = mmttype|(5*ones(iM_m,1));

    endif;
         
    mmtvec  = meanc(mmtmtx);
    obsvec  = meanc(obsmtx);
    nmom    = rows(mmtvec);
    mmttype = mmttype[mmtskeep];
    MSMval  = (totobs*(mmtvec^2).*diag(_W));

    if savemmts==1;                                /* N.B. This is a global */
        save path=^datapath mmtmtx, obsmtx;
    endif;
    if prnres>1;
        ?;"Check of Moment Conditions";
        "                               Average   % Observed     Adjusted    MSM Value         Type";;
        seqa(1,1,nmom)~mmtskeep~mmtvec~obsvec~(mmtvec./obsvec)~MSMval~mmttype;?;
        "Summed squared avg. differences = ";; mmtvec'mmtvec;?;
    endif;
    if prnres>0;
        i=1; do until i>maxc(mmttype);
            if i==2;
                if(mxqtmmts==0);  i=i+1;  continue;  endif;
            endif;
            if i==3;
                if(mxmnmmts==0);  i=i+1;  continue;  endif;
            endif;
            if i==4;
                if(mxcrrlmmts==0);  i=i+1;  continue;  endif;
            endif;
            if i==5;
                if(mcmnmmts==0);  i=i+1;  continue;  endif;
            endif;
            "Contribution from moment category";; i;; 
            if i==1;
                "Asset Quantiles       ";;
            elseif i==2;
                "Medex Quantiles       ";;
            elseif i==3;
                "Medex Means           ";;
            elseif i==4;
                "Medex Autocorrelations";;
            elseif i==5;
                "Medicaid Receipt      ";;
            endif;

            subCrit = selif(MSMval,(mmttype.==i));            
            sumc(subcrit);
            if (i==1) and (qnum_a>1);
                rn11 = rn1/qnum_a;
                rn22 = rn2/qnum_a;
                j=1; do until j>qnum_a;
                    "   Contribution from Quantile";; quants_a[j];; 
                    subQ = sumc(subCrit[(j-1)*rn11+1:j*rn11]);   @ singles, then couples @
                    subQ;; sumc(subCrit[rn1+(j-1)*rn22+1:rn1+j*rn22]);;
                    subQ+sumc(subCrit[rn1+(j-1)*rn22+1:rn1+j*rn22]); 
                j=j+1; endo;
            endif;
        i=i+1; endo;
        ?;
    endif;
    
retp(mmtvec,obsvec,qntvec,pdfvec,mmttype); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(1) = getcrit(parmvec);

    local execret, PIsim96, agesim96, simwgt96, asim96, asstsim, conssim, medexsim, 
          mssim2, Snglsim, Mrrdsim, alivesim, aobssim, aSnglsim, aMrrdsim, mcobssim, 
          mcSnglsim, mcMrrdsim,mxobssim, mxSnglsim, mxMrrdsim, getsMcdsim, asstnoiz, 
          NHsim, cn, aqntsim, aqntcnts, asqntsim, asqntcnts, aisqntsim, aisqntcnts, 
          aihqntsim, aihqntcnts, aiwqntsim, aiwqntcnts, acqntsim, acqntcnts, aiMrrdsim, 
          aicqntsim, aicqntcnts, acsqntsim, acsqntcnts, cprfsim, cprfcnts, mxprfsim, 
          mxprfcnts, mxmnssim, mxmnscnts, MCRmnssim, MCRmnscnts, MCRsmnssim, MCRsmnscnts, 
          MCRcmnssim, MCRcmnscnts, NHmxmnssim, NHmxmnscnts, NHmnssim, NHmnscnts, 
          NHMCRmnssim, NHMCRmnscnts, lmedexsim, lmxmnssim, lmxmnscnts, mxstdsim,  
          mxcrlsim1, mxcrlcnt1, mxcrlsim2, mxcrlcnt2, mmtvec, obsvec, qntvec,
          pdfvec, mmttype, criter;

    getparms(parmvec);
    savevecs();                           /* Save input vector for C program */
    if prnout==1; output off; endif;

    if justmmts==0;
        if useMPI < 2;
            execret = exec(rulecall," ");
        elseif useMPI == 2;
            execret = exec("mpirun", rulecall);
        endif;
    endif;

    if prnout==1; output on; endif;
    loadsims();              /* Load simulation results into local directory */

 /* Get model-predicted summary stats */
    load path=^shkpath pisim96, agesim96, simwgt96, asim96, asstsim, conssim, medexsim, 
                       mssim2, Snglsim, Mrrdsim, alivesim, aobssim, aSnglsim, aMrrdsim, 
                       mcobssim, mcSnglsim, mcMrrdsim, mxobssim, mxSnglsim, mxMrrdsim, 
                       getsMcdsim, asstnoiz, NHsim;
    if assterr > 0;
        asstsim  = asstsim.*asstnoiz;
    endif;
    cn        = rows(mmtcols);
    asstsim   = asstsim[.,mmtcols];                   /* AHEAD Survey Years */
    conssim   = conssim[.,mmtcols];
    mssim2    = mssim2[.,mmtcols];
    Snglsim   = Snglsim[.,mmtcols];
    Mrrdsim   = Mrrdsim[.,mmtcols];
    alivesim  = alivesim[.,mmtcols];
    aobssim   = aobssim[.,mmtcols];
    mxobssim  = mxobssim[.,mmtcols];
    aSnglsim  = aSnglsim[.,mmtcols];
    aMrrdsim  = aMrrdsim[.,mmtcols];
    mcobssim  = mcobssim[.,mmtcols];
    mxSnglsim = mxSnglsim[.,mmtcols];
    mxMrrdsim = mxMrrdsim[.,mmtcols];
    mcSnglsim = mcSnglsim[.,mmtcols];
    mcMrrdsim = mcMrrdsim[.,mmtcols];
    medexsim  = medexsim[.,mmtcols];
    getsMcdsim = getsMcdsim[.,mmtcols];
    NHsim     = NHsim[.,mmtcols];
    aiMrrdsim = aMrrdsim[.,1]*ones(1,cn); @ married in initial wave @
    
    {asqntsim,asqntcnts}   = simqunts(pisim96,agesim96,asstsim,aobssim.*aSnglsim, 
                                      pistate_a,cohorts_a,quants_a,mmtyrs,0,simwgt96);

    {acqntsim,acqntcnts}   = simqunts(pisim96,agesim96,asstsim,aobssim.*aMrrdsim, 
                                      pistate_a,cohorts_a,quants_a,mmtyrs,0,simwgt96);

    {mxprfsim,mxprfcnts}   = simqunts(pisim96,agesim96,medexsim,mxobssim, 
                                      pistate_m,cohorts_m,quants_m,mmtyrs,0,simwgt96);

    {mxmnssim,mxmnscnts}   = simqunts(pisim96,agesim96,medexsim,mxobssim, 
                                      pistate_m,cohorts_m,0,mmtyrs,0,simwgt96);

    lmedexsim = ln(medexsim.*mxobssim + (1-mxobssim)); @ missing values are assigned large negative numbers @
    {lmxmnssim, lmxmnscnts, mxstdsim, mxcrlsim1, mxcrlcnt1, mxcrlsim2, mxcrlcnt2}
                         = simcrrl(pisim96,agesim96,lmedexsim,mxobssim,
                                   pistate_m,cohorts_m,mmtyrs,0,simwgt96);
                                   
    {MCRmnssim,MCRmnscnts} = simqunts(pisim96,agesim96,getsMcdsim,mcobssim, 
                                      pistate_mc,cohorts_m,0,mmtyrs,0,simwgt96);

 /* We use lmxmnsdat and lmxstddat because we are not matching logged means or std deviations. */

    {mmtvec,obsvec,qntvec,pdfvec,mmttype} 
        = makemmts(PIdat, agedat[.,1], asstdat, Sngldat, aSngldat, Mrrddat, aMrrddat,
                   wdwdat, awdwdat, aobsdat, bobsdat, daobsdat, dbobsdat, datawgts,
                   asqntsim, acqntsim, mxdat, mxobsdat, mxprfsim, mxmnssim, lmxmnsdat,
                   lmxstddat, mxcrlsim1, mxcrlsim2, Mcdat, Mcobsdat, MCRmnssim, 0,0,0);

    criter = (1+negpen)*totobs*mmtvec'*_W*mmtvec;
    "GMM criterion value   ";; criter;
 

    if (prnres>1 or prngrph==1);

        {aqntsim,aqntcnts}     = simqunts(pisim96,agesim96,asstsim,aobssim, 
                                          pistate_a,cohorts_a,quants_a,mmtyrs,0,simwgt96);

        {aisqntsim,aisqntcnts} = simqunts(pisim96,agesim96,asstsim,aobssim.*(aSnglsim[.,1]*ones(1,cn)), 
                                          pistate_a,cohorts_a,quants_a,mmtyrs,0,simwgt96);

        {aihqntsim,aihqntcnts} = simqunts(pisim96,agesim96,asstsim,aobssim.*((mssim2[.,1].==1)*ones(1,cn)), 
                                          pistate_a,cohorts_a,quants_a,mmtyrs,0,simwgt96);

        {aiwqntsim,aiwqntcnts} = simqunts(pisim96,agesim96,asstsim,aobssim.*((mssim2[.,1].==2)*ones(1,cn)), 
                                          pistate_a,cohorts_a,quants_a,mmtyrs,0,simwgt96);

        {aicqntsim,aicqntcnts} = simqunts(pisim96,agesim96,asstsim,aobssim.*aiMrrdsim, 
                                          pistate_a,cohorts_a,quants_a,mmtyrs,0,simwgt96);

        {acsqntsim,acsqntcnts} = simqunts(pisim96,agesim96,asstsim,aobssim.*aiMrrdsim.*aSnglsim, 
                                          pistate_a,cohorts_a,quants_a,mmtyrs,0,simwgt96);

        {mxprfsim,mxprfcnts}   = simqunts(pisim96,agesim96,medexsim,mxobssim, 
                                          pistate_a,cohorts_a,quants_m,mmtyrs,0,simwgt96);

        {mxmnssim,mxmnscnts}   = simqunts(pisim96,agesim96,medexsim,,mxobssim, 
                                          pistate_a,cohorts_a,0,mmtyrs,0,simwgt96);

        {MCRmnssim,MCRmnscnts} = simqunts(pisim96,agesim96,getsMcdsim,mcobssim, 
                                          pistate_a,cohorts_a,0,mmtyrs,0,simwgt96);
                                          
        {MCRcmnssim,MCRcmnscnts} = simqunts(pisim96,agesim96,getsMcdsim,mcobssim.*aSnglsim, @Singles@ 
                                          pistate_a,cohorts_a,0,mmtyrs,0,simwgt96);
 
        {MCRsmnssim,MCRsmnscnts} = simqunts(pisim96,agesim96,getsMcdsim,mcobssim.*aMrrdsim, @Couples@ 
                                          pistate_a,cohorts_a,0,mmtyrs,0,simwgt96);

        {cprfsim,cprfcnts}     = simqunts(pisim96,agesim96,conssim,alivesim, 
                                          pistate_a,cohorts_a,0,mmtyrs,0,simwgt96);

        {NHmnssim,NHmnscnts}   = simqunts(pisim96,agesim96,NHsim,alivesim, 
                                          pistate_a,cohorts_a,0,mmtyrs,0,simwgt96);
                                    
        {NHmxmnssim,NHmxmnscnts} = simqunts(pisim96,agesim96,NHsim.*medexsim,
                                            NHsim.*mxobssim,pistate_a,cohorts_a,0,
                                            mmtyrs,0,simwgt96);
                                   
        {NHMCRmnssim,NHMCRmnscnts} = simqunts(pisim96,agesim96,NHsim.*getsMCDsim,
                                              NHsim.*mcobssim,pistate_a,
                                              cohorts_a,0,mmtyrs,0,simwgt96);                       
    endif;
                           
    if prnres>1;
    //  ?;"Asset quantiles from the Model, All";; print aqntsim;?; 
        ?;"Asset quantiles from the Model, Singles";; print asqntsim;?; 
    //  ?;"Asset quantiles from the Model, Initial Singles";; print aisqntsim;?; 
        ?;"Asset quantiles from the Model, Couples";; print acqntsim;?; 
    //  ?;"Asset quantiles from the Model, Initial Couples";; print aicqntsim;?;
    //  ?;"Asset quantiles from the Model, New Widow/ers";; print acsqntsim;?;  
        ?;"Medex Profiles from the Model";; print mxprfsim;
        ?;"Medex Means from the Model";; print mxmnssim;
        ?;"Medicaid participation rates from Model";; print MCRmnssim;
                ?;"Medicaid participation rates from Model, Singles";; print MCRsmnssim;?;
        ?;"Medicaid participation rates from Model, couples";; print MCRcmnssim;?;

        ?;"Nursing Home utilization rates from Model";; print NHmnssim;
        ?;"Log Medex Means from the Model";; print lmxmnssim;
        ?;"Log Medex 1st autocorrelations from Model";; print mxcrlsim1;?; 
        ?;"Log Medex 2nd autocorrelations from Model";; print mxcrlsim2;?; 
    endif;

    if prngrph==1;
        grphmtx(aqntsim,1,0,1,qnum_a,pinum_a,chrtnum_a,"");
        grphmtx(asqntsim,1,0,1,qnum_a,pinum_a,chrtnum_a,"_s_");
        grphmtx(aisqntsim,1,0,1,qnum_a,pinum_a,chrtnum_a,"_is_");
        grphmtx(aihqntsim,1,0,1,qnum_a,pinum_a,chrtnum_a,"_ih_");
        grphmtx(aiwqntsim,1,0,1,qnum_a,pinum_a,chrtnum_a,"_iw_");
        grphmtx(acqntsim,1,0,1,qnum_a,pinum_a,chrtnum_a,"_c_");
        grphmtx(aicqntsim,1,0,1,qnum_a,pinum_a,chrtnum_a,"_ic_");
        grphmtx(acsqntsim,1,0,1,qnum_a,pinum_a,chrtnum_a,"_cs_");
        grphmtx(cprfsim,2,0,1,0,pinum_a,chrtnum_a,"");
        grphmtx(mxprfsim,3,0,1,qnum_m,pinum_a,chrtnum_a,"");
        grphmtx(mxmnssim,3,0,1,0,pinum_a,chrtnum_a,"");
        grphmtx(NHmxmnssim,13,0,1,0,pinum_a,chrtnum_a,"");
        grphmtx(MCRmnssim,20,0,1,0,pinum_a,chrtnum_a,"");
        grphmtx(MCRcmnssim,20,0,1,0,pinum_a,chrtnum_a,"_c_");
        grphmtx(MCRsmnssim,20,0,1,0,pinum_a,chrtnum_a,"_s_");
        grphmtx(NHmnssim,23,0,1,0,pinum_a,chrtnum_a,"");        
        grphmtx(NHMCRmnssim,30,0,1,0,pinum_a,chrtnum_a,"");        
    endif;

    if prngrph==1; 
        {aqntsim,aqntcnts}     = simqunts(pisim96,agesim96,asstsim,aobssim,
                                          pistate_a,cohorts_a,quants_a,mmtyrs,1,simwgt96);
        {asqntsim,asqntcnts}   = simqunts(pisim96,agesim96,asstsim,aobssim.*aSnglsim, 
                                          pistate_a,cohorts_a,quants_a,mmtyrs,1,simwgt96);
        {aisqntsim,aisqntcnts} = simqunts(pisim96,agesim96,asstsim,aobssim.*(aSnglsim[.,1]*ones(1,cn)), 
                                          pistate_a,cohorts_a,quants_a,mmtyrs,1,simwgt96);
        {acqntsim,acqntcnts}   = simqunts(pisim96,agesim96,asstsim,aobssim.*aMrrdsim, 
                                          pistate_a,cohorts_a,quants_a,mmtyrs,1,simwgt96);
        {cprfsim,cprfcnts}     = simqunts(pisim96,agesim96,conssim,alivesim,
                                          pistate_a,cohorts_a,0,mmtyrs,1,simwgt96);
        {mxprfsim,mxprfcnts}   = simqunts(pisim96,agesim96,medexsim,mxobssim, 
                                         pistate_a,cohorts_m,quants_m,mmtyrs,1,simwgt96);
        {mxmnssim,mxmnscnts}   = simqunts(pisim96,agesim96,medexsim,mxobssim, 
                                          pistate_a,cohorts_m,0,mmtyrs,1,simwgt96);
        {MCRmnssim,MCRmnscnts} = simqunts(pisim96,agesim96,getsMcdsim,mcobssim, 
                                          pistate_a,cohorts_m,0,mmtyrs,1,simwgt96);
        {MCRsmnssim,MCRsmnscnts} = simqunts(pisim96,agesim96,getsMcdsim,mcobssim.*aSnglsim, @singles@
                                          pistate_a,cohorts_m,0,mmtyrs,1,simwgt96);
        {MCRcmnssim,MCRcmnscnts} = simqunts(pisim96,agesim96,getsMcdsim,mcobssim.*aMrrdsim, @couples@  
                                          pistate_a,cohorts_m,0,mmtyrs,1,simwgt96);        
        {NHmnssim,NHmnscnts}   = simqunts(pisim96,agesim96,NHsim,alivesim, 
                                          pistate_a,cohorts_a,0,mmtyrs,1,simwgt96); 
        {NHMCRmnssim,NHMCRmnscnts} = simqunts(pisim96,agesim96,NHsim.*getsMCDsim,
                                              mcobssim.*NHsim,pistate_a,
                                              cohorts_m,0,mmtyrs,1,simwgt96);                              
        grphmtx(aqntsim,1,1,1,qnum_a,pinum_a,chrtnum_a,"");     @ Survivors Only @
        grphmtx(aisqntsim,1,1,1,qnum_a,pinum_a,chrtnum_a,"_is_");
        grphmtx(acqntsim,1,1,1,qnum_a,pinum_a,chrtnum_a,"_c_"); 
        grphmtx(cprfsim,2,1,1,0,pinum_a,chrtnum_a,"");
        grphmtx(mxprfsim,3,1,1,qnum_m,pinum_a,chrtnum_a,"");
        grphmtx(mxmnssim,3,1,1,0,pinum_a,chrtnum_a,"");
        grphmtx(MCRmnssim,20,1,1,0,pinum_a,chrtnum_a,"");
        grphmtx(MCRsmnssim,20,1,1,0,pinum_a,chrtnum_a,"_s_");
        grphmtx(MCRcmnssim,20,1,1,0,pinum_a,chrtnum_a,"_c_");
        grphmtx(NHmnssim,23,1,1,0,pinum_a,chrtnum_a,"");        
        grphmtx(NHMCRmnssim,30,1,1,0,pinum_a,chrtnum_a,"");        
    endif;

    sttime = timerec(sttime,"Doing one function evaluation");
    "We are at the end of function evaluation";; feval;?;
    feval = feval+1;

retp(criter); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
proc(0) = prnmedex(rhomx,fracar1,mxcoef);

    local j;

    ?;"Medex Coefficients";
    "rho_mx          ";;rhomx;
    "V(AR1)/V(AR+WN) ";;fracar1;?;

    "                       Mean      Variance";
    j=1; do until j>rows(mxcoef);
        mxlabel[j];;mxcoef[j,.];
    j=j+1; endo;
    ?;

retp; endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(1) = oneloop(allparms);

    local iPI, parmvec, criter, mxdetails;

    ?;"We are at the beginning of function evaluation";; feval;

    allparms = allparms.*zerovec + fixvals.*(1-zerovec);
    {rhomx,fracar1,fracar1i,fracwn,mxcoef,xiParms,zetaParms,mxcoef_norisk} 
        = punscale_m(allparms);                       /* Outputs are globals */
    prnmedex(rhomx,fracar1,mxcoef);
    mxdetails = mxcrrlmmts+mxqtmmts+mxmnmmts+mcmnmmts;

    iPI=0; do until iPI>1;
        negpen = getmxtab(mxcoef,iPI,smplyrs,(prnres-1)*(mxdetails+1));   /* Output is a global */
        if (negpen>0);  "Negative Variances";  break;  endif;
    iPI=iPI+0.2; endo;
    
    parmvec  = allparms[2*rn_m+1:2*rn_m+rn_p]; 
    criter   = -100;

    if job /= 4;
        criter  = getcrit(parmvec);
    else;
        "WRONG JOB!!!";?;
    endif;

retp(criter); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(0) = getexpr(allparms);
    
    local iPI, parmvec, mxdetails, execret, simwgtx, pisimx, agesimx, astnoizx, 
          asstsimx, mxsimx, conssimx, mssim2x, alivex, snglx, mrrdx, hlsimhx, 
          hlsimwx, NHsimx, getsMcdx, aobsx, aSnglx, aMrrdx, mxobsx, mxSnglx, 
          mxMrrdx, mcobsx, mcSnglx, mcMrrdx, iIdxsimx, incsimx, oopmxsimx, 
          Medicaidx, transferx, oopmcdx, age96x, ms96x, hl96hx, hl96wx, hl96x, 
          pdvvec, pdvcons, pdvoop, pdvMedicaid, pdvoopmc, CompVarVec, cn, aiMrrdx, 
          aqntsim, aqntcnts, asqntsim, asqntcnts, aisqntsim, aisqntcnts, 
          aihqntsim, aihqntcnts, aiwqntsim, aiwqntcnts, acqntsim, acqntcnts, 
          aicqntsim, aicqntcnts, acSqntsim, acSqntcnts, cprfsim, cprfcnts, 
          mxprfsim, mxprfcnts, mxmnssim, mxmnscnts, oopprfsim, oopprfcnts, 
          mcprfsim, mcprfcnts, omprfsim, omprfcnts, imnssim, imnscnts,
          NHoopprfsim, NHoopprfcnts, NHomcprfsim, NHomcprfcnts, NHmnssim, 
          NHmnscnts, NHMCRmnssim, NHMCRmnscnts, lmedexsim, lmxmnssim, lmxmnscnts, 
          mxstdsim, mxcrlsim1, mxcrlcnt1, mxcrlsim2, mxcrlcnt2, MCRmnssim, 
          MCRmnscnts, txtsplit, oopcprfsim, oopcprfcnts, oopsprfsim, oopsprfcnts, 
          omcprfsim, omcprfcnts, omsprfsim, omsprfcnts;

    ?;"We are at the beginning of function evaluation";; feval;

    allparms = allparms.*zerovec + fixvals.*(1-zerovec);
    {rhomx,fracar1,fracar1i,fracwn,mxcoef,xiParms,zetaParms,mxcoef_norisk} 
        = punscale_m(allparms);                       /* Outputs are globals */
    prnmedex(rhomx,fracar1,mxcoef);
    mxdetails = mxcrrlmmts+mxqtmmts+mxmnmmts+mcmnmmts;

    iPI=0; do until iPI>1;
        negpen = getmxtab(mxcoef,iPI,smplyrs,(prnres-1)*(mxdetails+1));   /* Output is a global */
        if (negpen>0);  "Negative Variances";  break;  endif;
    iPI=iPI+0.2; endo;
    
    parmvec  = allparms[2*rn_m+1:2*rn_m+rn_p]; 

    getparms(parmvec);
    savevecs();                           /* Save input vector for C program */

    if justmmts==0;
        if useMPI < 2;
            execret = exec(rulecall," ");
        elseif useMPI == 2;
            execret = exec("mpirun", rulecall);
        endif;
    endif;

    if basecase==1;                             /* Save basecase simulations */
        saveR4sims;
    endif;

    loadsims();              /* Load simulation results into local directory */

 /* Get model-predicted summary stats */
    load path=^shkpath simwgtx, pisimx, agesimx, astnoizx, asstsimx, conssimx, mxsimx, 
                       mssim2x, alivex, snglx, mrrdx, hlsimhx, hlsimwx, NHsimx, getsMcdx, 
                       aobsx, aSnglx, aMrrdx, mxobsx, mxSnglx, mxMrrdx, mcobsx, mcSnglx, 
                       mcMrrdx, iIdxsimx, incsimx, oopmxsimx, Medicaidx, transferx, 
                       oopmcdx;

    if assterr > 0;                   
        asstsimx = asstsimx.*astnoizx;
    endif;
    age96x   = agesimx[.,1];
    ms96x    = mssim2x[.,1];
    hl96hx   = hlsimhx[.,1]; 
    hl96wx   = hlsimwx[.,1];
    hl96x    = hl96hx.*(ms96x.==1) + hl96wx.*(ms96x.==2) + minc((hl96hx~hl96wx)').*(ms96x.==3);
    cn       = cols(aobsx);
    aiMrrdx  = aMrrdx[.,1]*ones(1,cn); 


    ?;
    pdvvec      = seqa(0,agestep,_trexpr);
    pdvvec      = (1+mu_r)^(-pdvvec);      
    pdvcons     = getpdv("Consumption = ",pdvvec,conssimx,alivex,pisimx,ms96x,hl96x,pistate_a,simwgtx);
    pdvoop      = getpdv("Oop Medex =   ",pdvvec,oopmxsimx,mxobsx,pisimx,ms96x,hl96x,pistate_a,simwgtx);
    pdvMedicaid = getpdv("Medicaid =    ",pdvvec,Medicaidx,mxobsx,pisimx,ms96x,hl96x,pistate_a,simwgtx);
    pdvoopmc    = getpdv("Oop + Mcaid = ",pdvvec,oopmcdx,mxobsx,pisimx,ms96x,hl96x,pistate_a,simwgtx); 
    
    getmxpdv("Oop Medex: ",oopmxsimx,mxobsx,pisimx,ms96x,hl96x,pistate_a,simwgtx);
    getmxpdv("Oop + Mcaid: ",oopmcdx,mxobsx,pisimx,ms96x,hl96x,pistate_a,simwgtx);
    
    oopmxsimx   = oopmxsimx/agestep;
    Medicaidx   = Medicaidx/agestep;
    oopmcdx     = oopmcdx/agestep;

    {aqntsim,aqntcnts}     = simqunts(pisimx,age96x,asstsimx,aobsx, 
                                      pistate_a,cohortsx,quants_a,simyrsx,0,simwgtx);

    {asqntsim,asqntcnts}   = simqunts(pisimx,age96x,asstsimx,aobsx.*aSnglx, 
                                      pistate_a,cohortsx,quants_a,simyrsx,0,simwgtx);

    {aisqntsim,aisqntcnts} = simqunts(pisimx,age96x,asstsimx,aobsx.*(aSnglx[.,1]*ones(1,cn)), 
                                      pistate_a,cohortsx,quants_a,simyrsx,0,simwgtx);

    {aihqntsim,aihqntcnts} = simqunts(pisimx,age96x,asstsimx,aobsx.*((mssim2x[.,1].==1)*ones(1,cn)), 
                                      pistate_a,cohortsx,quants_a,simyrsx,0,simwgtx);

    {aiwqntsim,aiwqntcnts} = simqunts(pisimx,age96x,asstsimx,aobsx.*((mssim2x[.,1].==2)*ones(1,cn)), 
                                      pistate_a,cohortsx,quants_a,simyrsx,0,simwgtx);

    {acqntsim,acqntcnts}   = simqunts(pisimx,age96x,asstsimx,aobsx.*aMrrdx, 
                                      pistate_a,cohortsx,quants_a,simyrsx,0,simwgtx);

    {aicqntsim,aicqntcnts} = simqunts(pisimx,age96x,asstsimx,aobsx.*aiMrrdx[.,1], 
                                      pistate_a,cohortsx,quants_a,simyrsx,0,simwgtx);

    {acsqntsim,acsqntcnts} = simqunts(pisimx,age96x,asstsimx,aobsx.*aiMrrdx[.,1].*aSnglx, 
                                      pistate_a,cohortsx,quants_a,simyrsx,0,simwgtx);

    {cprfsim,cprfcnts}     = simqunts(pisimx,age96x,conssimx,alivex,
                                      pistate_a,cohortsx,0,simyrsx,0,simwgtx);

    {mxprfsim,mxprfcnts}   = simqunts(pisimx,age96x,mxsimx,mxobsx,
                                      pistate_a,cohortsx,quants_m,simyrsx,0,simwgtx);

    {mxmnssim,mxmnscnts}   = simqunts(pisimx,age96x,mxsimx,mxobsx, 
                                      pistate_a,cohortsx,0,simyrsx,0,simwgtx);

    {oopprfsim,oopprfcnts} = simqunts(pisimx,age96x,oopmxsimx,mxobsx,
                                      pistate_a,cohortsx,0,simyrsx,0,simwgtx);

    {oopcprfsim,oopcprfcnts} = simqunts(pisimx,age96x,oopmxsimx,mxobsx.*mxMrrdx,
                                        pistate_a,cohortsx,0,simyrsx,0,simwgtx);

    {oopsprfsim,oopsprfcnts} = simqunts(pisimx,age96x,oopmxsimx,mxobsx.*mxSnglx,
                                        pistate_a,cohortsx,0,simyrsx,0,simwgtx);

    {mcprfsim,mcprfcnts}   = simqunts(pisimx,age96x,Medicaidx,mxobsx,
                                      pistate_a,cohortsx,0,simyrsx,0,simwgtx);

    {omprfsim,omprfcnts}   = simqunts(pisimx,age96x,oopmcdx,mxobsx,
                                      pistate_a,cohortsx,0,simyrsx,0,simwgtx);

    {omcprfsim,omcprfcnts} = simqunts(pisimx,age96x,oopmcdx,mxobsx.*mxMrrdx,
                                      pistate_a,cohortsx,0,simyrsx,0,simwgtx);

    {omsprfsim,omsprfcnts} = simqunts(pisimx,age96x,oopmcdx,mxobsx.*mxSnglx,
                                      pistate_a,cohortsx,0,simyrsx,0,simwgtx);

    {imnssim,imnscnts}     = simqunts(pisimx,age96x,incsimx,alivex, 
                                      pistate_a,cohortsx,0,simyrsx,0,simwgtx);

    {NHmnssim,NHmnscnts}   = simqunts(pisimx,age96x,NHsimx,alivex, 
                                      pistate_a,cohortsx,0,simyrsx,0,simwgtx);
                                                                     
    {NHoopprfsim,NHoopprfcnts} = simqunts(pisimx,age96x,oopmxsimx.*NHsimx,
                                          mxobsx.*NHsimx,pistate_a,
                                          cohortsx,0,simyrsx,0,simwgtx);
                                  
    {NHomcprfsim,NHomcprfcnts} = simqunts(pisimx,age96x,oopmcdx.*NHsimx,
                                          mxobsx.*NHsimx,pistate_a,
                                          cohortsx,0,simyrsx,0,simwgtx); 
                                 
    {MCRmnssim,MCRmnscnts} = simqunts(pisimx,age96x,getsMcdx,mcobsx, 
                                      pistate_a,cohortsx,0,simyrsx,0,simwgtx);

    {NHMCRmnssim,NHMCRmnscnts} = simqunts(pisimx,age96x,getsMcdx.*NHsimx,
                                          mcobsx.*NHsimx,pistate_a,cohortsx,0,
                                          simyrsx,0,simwgtx);                                                                      

    lmedexsim = ln(mxsimx.*mxobsx + (1-mxobsx)); @ missing values are assigned large negative numbers @
    {lmxmnssim, lmxmnscnts, mxstdsim, mxcrlsim1, mxcrlcnt1, mxcrlsim2, mxcrlcnt2}
                         = simcrrl(pisimx,age96x,lmedexsim,mxobsx, 
                                   pistate_a,cohortsx,simyrsx,0,simwgtx);
    if prnres>1;
        ?;"Asset quantiles from the Model, All";; print aqntsim;?; 
        ?;"Asset quantiles from the Model, Singles";; print asqntsim;?; 
        ?;"Asset quantiles from the Model, Initial Singles";; print aisqntsim;?; 
        ?;"Asset quantiles from the Model, Couples";; print acqntsim;?; 
        ?;"Asset quantiles from the Model, Initial Couples";; print aicqntsim;?; 
    //  ?;"Asset quantiles from the Model, New Widow/ers";; print acsqntsim;?; 

        ?;"Medex Profiles from the Model";; print mxprfsim;
        ?;"Medex Means from the Model";; print mxmnssim;
        ?;"Medicaid participation rates from Model";; print MCRmnssim;
        ?;"Log Medex Means from the Model";; print lmxmnssim;
        ?;"Log Medex 1st autocorrelations from Model";; print mxcrlsim1;?; 
        ?;"Log Medex 2nd autocorrelations from Model";; print mxcrlsim2;?; 
    endif;

    if prngrph==1; 
        grphmtx2(aqntsim,1,0,1,qnum_a,pinum_a,"");
        grphmtx2(asqntsim,1,0,1,qnum_a,pinum_a,"_s_");
        grphmtx2(aisqntsim,1,0,1,qnum_a,pinum_a,"_is_");
        grphmtx2(aihqntsim,1,0,1,qnum_a,pinum_a,"_ih_");
        grphmtx2(aiwqntsim,1,0,1,qnum_a,pinum_a,"_iw_");
        grphmtx2(acqntsim,1,0,1,qnum_a,pinum_a,"_c_");
        grphmtx2(aicqntsim,1,0,1,qnum_a,pinum_a,"_ic_");
        grphmtx2(acsqntsim,1,0,1,qnum_a,pinum_a,"_cs_");
        grphmtx2(cprfsim,2,0,1,0,pinum_a,"");
        grphmtx2(mxprfsim,3,0,1,qnum_m,pinum_a,"");
        grphmtx2(mxmnssim,3,0,1,0,pinum_a,"");
        grphmtx2(imnssim,4,0,1,0,pinum_a,"");
        grphmtx2(oopprfsim,5,0,1,0,pinum_a,"");
        grphmtx2(oopcprfsim,5,0,1,0,pinum_a,"_c_");
        grphmtx2(oopsprfsim,5,0,1,0,pinum_a,"_s_");
        grphmtx2(mcprfsim,6,0,1,0,pinum_a,"");
        grphmtx2(omprfsim,9,0,1,0,pinum_a,"");
        grphmtx2(omcprfsim,9,0,1,0,pinum_a,"_c_");
        grphmtx2(omsprfsim,9,0,1,0,pinum_a,"_s_");
        grphmtx2(NHoopprfsim,15,0,1,0,pinum_a,"");
        grphmtx2(NHomcprfsim,17,0,1,0,pinum_a,"");
        grphmtx2(MCRmnssim,20,0,1,0,pinum_a,"");
        grphmtx2(NHmnssim,23,0,1,0,pinum_a,"");           
        grphmtx2(NHMCRmnssim,30,0,1,0,pinum_a,"");
    endif;

    {aqntsim,aqntcnts}     = simqunts(pisimx,age96x,asstsimx,aobsx,
                                      pistate_a,cohortsx,quants_a,simyrsx,1,simwgtx);

    {aisqntsim,aisqntcnts} = simqunts(pisimx,age96x,asstsimx,aobsx.*(aSnglx[.,1]*ones(1,cn)), 
                                      pistate_a,cohortsx,quants_a,simyrsx,1,simwgtx);

    {acqntsim,acqntcnts}   = simqunts(pisimx,age96x,asstsimx,aobsx.*aMrrdx, 
                                      pistate_a,cohortsx,quants_a,simyrsx,1,simwgtx);

    {cprfsim,cprfcnts}     = simqunts(pisimx,age96x,conssimx,alivex,
                                      pistate_a,cohortsx,0,simyrsx,1,simwgtx);

    {mxprfsim,mxprfcnts}   = simqunts(pisimx,age96x,mxsimx,mxobsx,
                                      pistate_a,cohortsx,quants_m,simyrsx,1,simwgtx);

    {mxmnssim,mxmnscnts}   = simqunts(pisimx,age96x,mxsimx,mxobsx,
                                      pistate_a,cohortsx,0,simyrsx,1,simwgtx);

    {oopprfsim,oopprfcnts} = simqunts(pisimx,age96x,oopmxsimx,mxobsx,
                                      pistate_a,cohortsx,0,simyrsx,1,simwgtx);

    {mcprfsim,mcprfcnts}   = simqunts(pisimx,age96x,Medicaidx,mxobsx,
                                      pistate_a,cohortsx,0,simyrsx,1,simwgtx);

    {omprfsim,omprfcnts}   = simqunts(pisimx,age96x,oopmcdx,mxobsx,
                                      pistate_a,cohortsx,0,simyrsx,1,simwgtx);

    {imnssim,imnscnts}     = simqunts(pisimx,age96x,incsimx,alivex, 
                                      pistate_a,cohortsx,0,simyrsx,1,simwgtx);

    {MCRmnssim,MCRmnscnts} = simqunts(pisimx,age96x,getsMcdx,mcobsx,
                                      pistate_a,cohortsx,0,simyrsx,1,simwgtx);

    {NHmnssim,NHmnscnts}   = simqunts(pisimx,age96x,NHsimx,alivex, 
                                      pistate_a,cohortsx,0,simyrsx,1,simwgtx);                                

    if prngrph==1; 
        grphmtx2(aqntsim,1,1,1,qnum_a,pinum_a,"");              @ Survivors Only @
        grphmtx2(aisqntsim,1,1,1,qnum_a,pinum_a,"_is_");
        grphmtx2(acqntsim,1,1,1,qnum_a,pinum_a,"_c_");
        grphmtx2(aicqntsim,1,1,1,qnum_a,pinum_a,"_ic_");
        grphmtx2(cprfsim,2,1,1,0,pinum_a,"");
        grphmtx2(mxprfsim,3,1,1,qnum_m,pinum_a,"");
        grphmtx2(mxmnssim,3,1,1,0,pinum_a,"");
        grphmtx2(imnssim,4,1,1,0,pinum_a,"");
        grphmtx2(oopprfsim,5,1,1,0,pinum_a,"");
        grphmtx2(mcprfsim,6,1,1,0,pinum_a,"")
        grphmtx2(omprfsim,9,1,1,0,pinum_a,"");
        grphmtx2(MCRmnssim,20,1,1,0,pinum_a,"");
        grphmtx2(NHmnssim,23,1,1,0,pinum_a,"");           
    endif;
    
    sttime = timerec(sttime,"Doing one function evaluation");

retp(); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(0) = commaround(nmbr, rndr);

    local sclr, part1;
    
    nmbr  = rndr*round(nmbr/rndr);
    if nmbr<0;
        "-";;
        nmbr = -nmbr;
    endif;
   
    if nmbr < 10;
        format /rd 1,0;     
        nmbr;; 
    elseif nmbr < 100;
        format /rd 2,0;     
        nmbr;; 
    else;
        format /rdc 3,0; 
        sclr=1000000000000; do while sclr>1;
            part1 = int(nmbr/sclr);
            if part1>0;
                part1;; 
            endif;
            nmbr = nmbr - part1*sclr;
        sclr=sclr/1000; endo;
    
        format /rd 3,0;     
        if nmbr < 100;
            format /rdn 1,0; 0;;
            format /rd 2,0;
        endif;
        if nmbr < 10;
            format /rdn 1,0; 0;;
            format /rd 1,0;     
        endif;
        
        nmbr;;
    endif;   
    
    format /ro 12,4;
   
retp; endp;    

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(1) = getpdv(title,pdvvec,datasim,alivesim,pisim96,mssim96,hlsim96,
                 pistate_j,wgts96);

    local pdvsum, alive96, rn, PIqnts, PIcnts, PItype, cn, pdvtab, pinum_j, 
          iPI, PIdum, pdvavg, pdvcnts, iMS, iHS, MSdum, alivei, pdvnum, 
          annfac, tablab, typelab, distlab, iType, OKvals, summtab, summlab,
          mshslab, iRow, pdvsum1, hsnum2;

    distlab = "                                        Mean          1st          5th         10th         20th         30th"
              $+ "         40th         50th         60th         70th         80th         90th         95th         99th  ";

    rn      = rows(alivesim);
    hsnum2  = hsnum+1;   
    cn      = 3*hsnum2+2;
    alive96 = miss(alivesim[.,1],0);
    pinum_j = rows(pistate_j)+(pistate_j /= 0);
    {PIqnts,PIcnts,PItype} = PIquant2(pisim96,pistate_j,chktie);  
    summtab = zeros(6+pinum_j,3);
    let string summlab = {"                 Bottom          ", "                 Second          ", 
                          "                 Top             ", "\\hspace{0.25cm} Single Men      ",
                          "\\hspace{0.25cm} Single Women    ", "\\hspace{0.25cm} Couples         ", 
                          "\\hspace{0.25cm} In Nursing Home ", "\\hspace{0.25cm} In Bad Health   ", 
                          "\\hspace{0.25cm} In Good Health  "};

    mshslab = "       sm_nh         sm_b         sm_g       sm_all        sw_nh         sw_b         sw_g";
    mshslab = mshslab $+ "        sw_all       cpl_nh       cpl_b        cpl_g      cpl_all          All";


    iType=1; do until iType>3; @ iType==1 => discounted sums; 2 => annuity values; 3 => annuity factors @
        if iType==3;
            datasim = ones(rn,rows(pdvvec));
        endif;
        annfac  = ones(rn,1);
        typelab = "Discounted sums of ";
        if iType==2;
            annfac = alivesim*pdvvec + 1e-10;
            typelab = "Annuity values for ";
        endif;

        pdvsum  = (datasim.*alivesim)*pdvvec;
        pdvsum  = pdvsum./annfac;
        if (iType==1);  pdvsum1 = pdvsum;  endif;

        pdvtab  = zeros(2+pinum_j,cn); 
        pdvnum  = pdvtab;

        {pdvavg,pdvcnts} = getmean(pdvsum.*alive96,wgts96);
        pdvtab[pinum_j+1:pinum_j+2,cn] = pdvavg[2]*ones(2,1);
        pdvnum[pinum_j+1:pinum_j+2,cn] = pdvcnts[2]*ones(2,1);
        pdvtab[pinum_j+2,(hsnum2+1)|(2*hsnum2+1)|(3*hsnum2+1)] = pdvavg[2]*ones(1,3);
        pdvnum[pinum_j+2,(hsnum2+1)|(2*hsnum2+1)|(3*hsnum2+1)] = pdvcnts[2]*ones(1,3);        

        iPI=1; do until iPI>pinum_j;
       
            PIdum  = alive96.*miss((PItype.==iPI),0);           
            pdvtab[iPI,1]    = iPI;
            pdvnum[iPI,1]    = iPI;
            {pdvavg,pdvcnts} = getmean(pdvsum.*PIdum,wgts96); @ everyone in a PI quintile @
            pdvtab[iPI,cn]   = pdvavg[2];
            pdvnum[iPI,cn]   = pdvcnts[2];

            iMS=1; do until iMS>3;
                MSdum = PIdum.*miss((mssim96.==iMS),0);
                {pdvavg,pdvcnts} = getmean(pdvsum.*MSdum,wgts96); @ all males (or females or couples) in a PI quintile @
                pdvtab[iPI,iMS*hsnum2+1] = pdvavg[2];
                pdvnum[iPI,iMS*hsnum2+1] = pdvcnts[2];     
                iHS=1; do until iHS>hsnum;
                    alivei = MSdum.*miss((hlsim96.==iHS),0);
                    {pdvavg,pdvcnts} = getmean(pdvsum.*alivei,wgts96); @ PI-marital status-health status cells @
                    pdvtab[iPI,(iMS-1)*hsnum2+iHS+1] = pdvavg[2];
                    pdvnum[iPI,(iMS-1)*hsnum2+iHS+1] = pdvcnts[2];     
                iHS=iHS+1; endo;
            iMS=iMS+1; endo;

        iPI=iPI+1; endo;

        iMS=1; do until iMS>3;
            MSdum = alive96.*miss((mssim96.==iMS),0);         @ all males (or females or couples) @
            {pdvavg,pdvcnts} = getmean(pdvsum.*MSdum,wgts96);
            pdvtab[pinum_j+1,iMS*hsnum2+1] = pdvavg[2];
            pdvnum[pinum_j+1,iMS*hsnum2+1] = pdvcnts[2];

            iHS=1; do until iHS>hsnum;
                alivei = MSdum.*miss((hlsim96.==iHS),0);
                {pdvavg,pdvcnts} = getmean(pdvsum.*alivei,wgts96);
                pdvtab[pinum_j+1,(iMS-1)*hsnum2+iHS+1] = pdvavg[2];
                pdvnum[pinum_j+1,(iMS-1)*hsnum2+iHS+1] = pdvcnts[2];
            iHS=iHS+1; endo;
        iMS=iMS+1; endo;

        iHS=1; do until iHS>hsnum;
            alivei = alive96.*miss((hlsim96.==iHS),0);
            {pdvavg,pdvcnts} = getmean(pdvsum.*alivei,wgts96);
            pdvtab[pinum_j+2,(iHS+1)|(iHS+hsnum2+1)|(iHS+2*hsnum2+1)] = pdvavg[2]*ones(1,3);
            pdvnum[pinum_j+2,(iHS+1)|(iHS+hsnum2+1)|(iHS+2*hsnum2+1)] = pdvcnts[2]*ones(1,3);
        iHS=iHS+1; endo;

        OKvals = (pdvtab.>-1e5);
        pdvtab = pdvtab.*miss(OKvals,0);
        summtab[1:pinum_j,iType] = pdvtab[1:pinum_j,cn];
        summtab[pinum_j+1,iType] = pdvtab[pinum_j+1,hsnum2+1];
        summtab[pinum_j+2,iType] = pdvtab[pinum_j+1,2*hsnum2+1];
        summtab[pinum_j+3,iType] = pdvtab[pinum_j+1,3*hsnum2+1];

        summtab[pinum_j+4,iType] = pdvtab[pinum_j+2,cn-4];
        summtab[pinum_j+5,iType] = pdvtab[pinum_j+2,cn-3];
        summtab[pinum_j+6,iType] = pdvtab[pinum_j+2,cn-2];

               
        if iType<3;
            distlab;
            typelab;; title;; meanc(pdvsum);; quantile(pdvsum,0.01|0.05|0.1|0.2|0.3|0.4|0.5|0.6|0.7|0.8|0.9|0.95|0.99)';

            tablab = "    PI value" $+ mshslab;
            typelab$+title;
            tablab;; pdvtab~pdvnum;?;
        endif;
        
    iType=iType+1; endo;
    
    summtab[.,2] = summtab[.,1]./summtab[.,3]; 
 
    ?;
    "\\hline"; "\\vspace{-0.4cm} & & \\\\";  @ Spacing row @
    iRow=1; do until iRow>pinum_j+6;
        summlab[iRow];; " & ";; commaround(summtab[iRow,1],100);; " & ";; commaround(summtab[iRow,2],10);; " \\\\";  
        if (iRow==pinum_j) or (iRow==(pinum_j+3));
            "\\hline"; "\\vspace{-0.4cm} & & \\\\"; 
        endif;
    iRow=iRow+1; endo;

    "++++++++++++++++++++++";?;

retp(pdvsum1); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(0) = getmxpdv(title,datasim,alivesim,pisim96,mssim96,hlsim96,pistate_j,
                   wgts96);

    local alive96, cn, PIqnts, PIcnts, PItype, pinum_j, pinum2, PIdum, 
          MSdum, pdvsum, iWave, iMS, iPI, meantab, q90tab, iCol, indicat, 
          data_w, pdvavg, pdvcnts, qprf, qcnts, iTab;

    cn      = _trexpr;
    alive96 = miss(alivesim[.,1],0);
    pinum_j = rows(pistate_j)+(pistate_j /= 0);
    pinum2  = pinum_j+(pinum_j > 1);
    {PIqnts,PIcnts,PItype} = PIquant2(pisim96,pistate_j,chktie);  
    PIdum   = PItype*ones(1,cn);
    MSdum   = (mssim96.>2)*ones(1,cn);
    
    pdvsum  = datasim.*alivesim;

    iWave=cn-1; do until iWave<1;
        pdvsum[.,iWave] = pdvsum[.,iWave] + pdvsum[.,iWave+1]*(1+mu_r)^(-agestep);
    iWave=iWave-1; endo; 

    meantab = ones(_trexpr,2*pinum2)*miss(0,0);
    q90tab  = meantab;

    iMS=0; do until iMS>1;
        iPI=0; do until iPI>pinum_j;
            iCol    = iMS*pinum2+iPI+1;
            indicat = (MSdum.==iMS);
            if iPI>0;
                indicat = indicat.*(PItype.==iPI);
            endif;
            indicat = miss(indicat.*alivesim,0);

            iWave=1; do until iWave>cn;
                data_w = pdvsum[.,iWave].*indicat[.,iWave];
                {pdvavg,pdvcnts} = getmean(data_w,wgts96); 
                if wgtddata==0;
                    {qprf,qcnts} = getqunt2(data_w,0.9);
                else;
                    {qprf,qcnts} = getquant(data_w,wgts96,0.9,chktie); 
                endif;
                meantab[iWave,iCol] = pdvavg[1,2];
                q90tab[iWave,iCol]  = qprf[1,2];
            iWave=iWave+1; endo;
        iPI=iPI+1; endo;
    iMS=iMS+1; endo;       

    meantab = ageseqx~meantab;
    q90tab  = ageseqx~q90tab;
    
    iTab=1; do until iTab>2;
        "Discounted sums of ";;title;;
        if iTab==1;
            "Means for survivors";
        elseif iTab==2;
            "90th percentiles for survivors";
        endif;
        "                      <---------------Singles--------------->             <---------------Couples--------------->";
        "         Age          All     tercile1     tercile2     tercile3          All     tercile1     tercile2     tercile3";;
        if iTab==1;  meantab;  elseif iTab==2;  q90tab;  endif;
        ?;?;
    iTab=iTab+1; endo;

retp; endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
