/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

fn logitsr(x) = sqrt(exp(x)./(1+exp(x)));
fn logit(x)   = exp(x)./(1+exp(x));
fn logitrv(p) = ln(p./(1-p));

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(1) = mvlogit(coeffvec,hsnum,xvars);       

    local nobs, transprobs, tempcfs, iH2;
    
    nobs       = rows(xvars);
    transprobs = zeros(nobs,hsnum+1); 
  
    iH2=1; do until iH2>hsnum;                          @ next period's state @     
        tempcfs = coeffvec[.,iH2];
        transprobs[.,iH2+1] = xvars*tempcfs;
    iH2=iH2+1; endo;

    transprobs = exp(transprobs);                    
    transprobs = transprobs./(transprobs*ones(hsnum+1,1));     @ Logit formula @
    
retp(transprobs); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
GETAGES:  gets ages right
*/
proc(3) = getages(bornage,dieage,dat);

    local j,k,bage2,ib;

    k = indexcat(dat[.,1],bornage);
    if scalmiss(k) == 1; k = 1; endif;
    bage2 = dat[k,1];
    ib = 1 +maxc((bage2-bornage)|0);
    j = indexcat(dat[.,1],dieage);
    if scalmiss(j) == 1;
        j = rows(dat);
    endif;
retp(k,j,ib); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
FIXOBS:  Adjusts data to have a common set of years
         Adds filler rows if data doesn't cover [bornage,dieage]
*/
proc(1) = fixobs(dat,bornage,dieage,k,j,lowmiss,himiss);

    local cn, rn, rn2, bage2, dage2;

    cn    = cols(dat);
    bage2 = dat[k,1];
    dage2 = dat[j,1];
    dat   = dat[k:j,.];

    if bage2 > bornage;
        rn  = bage2-bornage;
        dat = (lowmiss*ones(rn,cn))|dat;
        dat[1:rn,1] = seqa(bornage,1,rn);
    endif;
    rn2 = j-k+bage2-bornage+1;                      /* Number of rows in dat */
    if dage2 < dieage;
        rn  = dieage-dage2;
        dat = dat|(himiss*ones(rn,cn));
        dat[rn2+1:(dieage-bornage+1),1] = seqa(dage2+1,1,rn);
    endif;

retp(dat); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
proc(6) = getprofs();

    local pctle, datstr, rn, hltrans, label1, i, cnst, pinc, xvars0, dumstuff, 
          dumstuff2, xvars1, xvars, label2, xcassts, xavars, xcpreds, asstseq,
          data, datam, dataf, datac, k, j, ib,  goodrows, pipoly, 
          yprofsh, yprofsw, yprofsc, yprof, y_pi, pieffcts, copays, rorshk, 
          wlthshk;

    format /ro 12,4;
    pctle    = 0.0;
    pipoly   = pctle|(pctle^2)|(pctle^3)|(pctle^4)|(pctle^5);
    goodrows = ageseq-bornage+1;

   /*----------------------Mortality and Survival Rates----------------------*/
   
    cnst     = ones(_tr,1);
    pinc     = pctle*cnst;
    xvars0   = cnst~ageseq~(ageseq^2/100)~(ageseq^3/10000)~pinc~(pinc^2)~(pinc.*ageseq);
    dumstuff = cnst~ageseq~pinc;
    dumstuff2= cnst~ageseq;

    datstr   = datapath$+ "hstransh_120717_SpecB.out";
    rn       = 14+(hsnum-1)*2;
    loadm hltrans[rn,hsnum] = ^datstr;

    output on;

  @ State order: 0 = dead, 1 = nursing home, 2 = bad health,  3 = good health  @
    let string label1 = {"constant    ", "age         ", "age^2/100   ", "age^3/10000 ", 
                         "PI          ", "PI^2        ", "PI*age      ", "male        ", 
                         "male*age    ", "Male*PI     ", "married     ", "married*age ",
                         "married*male", "married*PI  ", "BadH        ", "BH*age      ", 
                         "GoodH       ", "GH*age      "};
    "            h_t+1=dead       h_t+1=NH    h_t+1=bad   h_t+1=good";
    i=1; do until i>rn;
        label1[i];;"        NA   ";;hltrans[i,.];
    i=i+1; endo;
    ?;

    label2 = "        Age    h_t+1=dead     h_t+1=NH    h_t+1=bad   h_t+1=good";
    
    "Results for the ";; pctle;; "PI percentile";?;
    
    "Transition Probs:  Single Males in a nursing home ";
    xvars1   = xvars0~dumstuff~zeros(_tr,4);
    xvars    = xvars1~zeros(_tr,2*cols(dumstuff2));
    label2;; ageseq~mvlogit(hltrans,hsnum,xvars);?;
    
    "Transition Probs:  Single Males in bad health ";
    xvars    = xvars1~dumstuff2~zeros(_tr,cols(dumstuff2));
    label2;; ageseq~mvlogit(hltrans,hsnum,xvars);?;
    
    "Transition Probs:  Single Males in good health ";
    xvars    = xvars1~zeros(_tr,cols(dumstuff2))~dumstuff2;
    label2;; ageseq~mvlogit(hltrans,hsnum,xvars);?;
    
    "Transition Probs:  Females in a nursing home ";
    xvars1   = xvars0~(0*dumstuff)~zeros(_tr,4);
    xvars    = xvars1~zeros(_tr,2*cols(dumstuff2));
    label2;; ageseq~mvlogit(hltrans,hsnum,xvars);?;
    
    "Transition Probs:  Females in bad health ";
    xvars    = xvars1~dumstuff2~zeros(_tr,cols(dumstuff2));
    label2;; ageseq~mvlogit(hltrans,hsnum,xvars);?;
    
    "Transition Probs:  Females in good health ";
    xvars    = xvars1~zeros(_tr,cols(dumstuff2))~dumstuff2;
    label2;; ageseq~mvlogit(hltrans,hsnum,xvars);?;
    
  /*-----------Redundant Placeholder------------*/
  xcassts=0;
  /*-----------------------------Income Profiles-----------------------------*/
    datstr   = datapath$+"incprof_120717.out";
    loadm data[] = ^datstr;
    data     = reshape(data,rows(data)/10,10);
 
   /* Order: age, b_const, b_snglmale, b_snglfemale, b_PI0, b_PI1,... bPI5   */
   /*        there are separate values of b_* for each age                   */
   /* y = exp(b_const[age] + b_snglmale[age] + ... )                         */

    datam    = data[.,1]~(data[.,2]+data[.,3]+data[.,5])~data[.,6:10];
    {k,j,ib} = getages(bornage,dieage,datam);
    datam    = fixobs(datam,bornage,dieage,k,j,0,-1e10);
    datam    = datam[goodrows,.];
    y_pi     = datam[.,3:7];

    dataf    = data[.,1]~(data[.,2]+data[.,4]+data[.,5])~data[.,6:10];
    dataf    = fixobs(dataf,bornage,dieage,k,j,0,-1e10);
    dataf    = dataf[goodrows,.];    
    y_pi     = y_pi~dataf[.,3:7];
    datac    = data[.,1]~(data[.,2]+data[.,5])~data[.,6:10];
    datac    = fixobs(datac,bornage,dieage,k,j,0,-1e10);
    datac    = datac[goodrows,.];    
    y_pi     = y_pi~datac[.,3:7];

    "Income Profiles at the ";; pctle;; " PI Percentile";
    "         age        males      females      couples";;
    yprof    = datam[.,2]~dataf[.,2]~datac[.,2];
    pieffcts = y_pi[.,1:5]*pipoly;
    pieffcts = pieffcts~(y_pi[.,6:10]*pipoly)~(y_pi[.,11:15]*pipoly);
    ageseq~exp(yprof+pieffcts);?;  

  /*---------------------------Redundant Placeholder---------------------------*/
   copays=0;

  /*------------------Get realized date-specific ROR shocks-------------------*/
    datstr   = datapath$+"wlthshk10.txt";

    loadm wlthshk[] = ^datstr;
    wlthshk  = reshape(wlthshk,rows(wlthshk)/5,5);
    {k,j,ib} = getages(momyr1,momyr2+1,wlthshk);
    wlthshk  = fixobs(wlthshk,momyr1,momyr2+agestep,k,j,0,0);
    goodrows = yearseq-momyr1+1;
    goodrows = goodrows|(maxc(goodrows)+agestep);
    rorshk   = wlthshk[goodrows,1+rshktype];

    if rshktype==0;
        rorshk = 0*rorshk;
    endif;
    if rshktype>2;
        rorshk = rorshk - mu_r;
    endif;

    "Rate of return shocks:";;
    (yearseq|(momyr2+agestep))~rorshk;?; 

retp(hltrans, xcassts, yprof, y_pi, copays, rorshk); 
endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(1) = getmxtab(mxcoef,pctle,smplyrs,prntab);

    local b_const, b_male, b_fmle, b_cupl, b_PI, b_PI2, b_dum, iHS, mnmxsm, mnmxsw, 
          mnmxc, mnmx, mnmx_pi, mnmx_pi2, stdmxsm, stdmxsw, stdmxc, stdmx, varmx_pi, 
          varmx_pi2, mxmean, mxsmtd, mx995, title1;

    if smplyrs /= 0;
        smplyrs = (smplyrs-bornage)/agestep+1;
    endif;

 /* First for the means */

    b_const  = mxcoef[1,1] + mxcoef[2,1]*ageseq + mxcoef[3,1]*(ageseq^2/100)
               + mxcoef[4,1]*(ageseq^3/10000) + mxcoef[5,1]*(ageseq^4/1000000);
    b_male   = b_const + mxcoef[9,1] + mxcoef[19,1]*ageseq + mxcoef[21,1]*ageseq^2/100;
    b_fmle   = b_const + mxcoef[10,1] + mxcoef[20,1]*ageseq + mxcoef[22,1]*ageseq^2/100;

  @ Now we have to consider lagged health as well, so we can only present a  @
  @ subset of the cases.  These are: single man, GH->GH; SM, NH->NH; SM,     @
  @ GH->dead; single woman, GH->GH; SW, NH->NH; SW, GH->dead; couple, GH->GH @
  @ and GH->GH; couple GH->dead and GH->GH; couple GH->GH and GH->Dead       @

    mnmxsm   = b_male;                         @ In good health both periods @
    b_dum    = mxcoef[13,1] + mxcoef[17,1]              @ In NH both periods @
               + mxcoef[27,1] + mxcoef[29,1];          
    mnmxsm   = mnmxsm~(b_male+b_dum);
    b_dum    = mxcoef[23,1];                           @ Good Health -> Dead @
    mnmxsm   = mnmxsm~(b_male+b_dum);

    mnmxsw   = b_fmle;                         @ In good health both periods @
    b_dum    = mxcoef[14,1] + mxcoef[18,1]              @ In NH both periods @
               + mxcoef[28,1] + mxcoef[30,1];    
    mnmxsw   = mnmxsw~(b_fmle+b_dum);
    b_dum    = mxcoef[24,1];                           @ Good Health -> Dead @
    mnmxsw   = mnmxsw~(b_fmle+b_dum);

    mnmxc    = b_const;                   @ Both in good health both periods @
    b_dum    = mxcoef[23,1];        @ Both in GH -> Husband dead, wife in GH @
    mnmxc    = mnmxc~(b_fmle+b_dum);
    b_dum    = mxcoef[24,1];        @ Both in GH -> Husband in GH, wife dead @
    mnmxc    = mnmxc~(b_male+b_dum);

    mnmx     = mnmxsm~mnmxsw~mnmxc;
    b_PI     = mxcoef[6,1] + mxcoef[8,1]*ageseq;
    b_PI2    = mxcoef[7,1]*ones(_TR,1);
    mnmx_pi  = b_PI~b_PI~(b_PI+mxcoef[25,1])~b_PI~b_PI~(b_PI+mxcoef[26,1]);
    mnmx_pi  = mnmx_pi~b_PI~(b_PI+mxcoef[25,1])~(b_PI+mxcoef[26,1]);
    mnmx_PI2 = b_PI2*ones(1,cols(mnmx_pi));

 /* Then for the variances */

    b_const  = mxcoef[1,2] + mxcoef[2,2]*ageseq + mxcoef[3,2]*(ageseq^2/100)
               + mxcoef[4,2]*(ageseq^3/10000) + mxcoef[5,2]*(ageseq^4/1000000);
    b_male   = b_const + mxcoef[9,2] + mxcoef[19,2]*ageseq + mxcoef[21,2]*ageseq^2/100;
    b_fmle   = b_const + mxcoef[10,2] + mxcoef[20,2]*ageseq + mxcoef[22,2]*ageseq^2/100;

  @ Now we have to consider lagged health as well, so we can only present a  @
  @ subset of the cases.  These are: single man, GH->GH; SM, NH->NH; SM,     @
  @ GH->dead; single woman, GH->GH; SW, NH->NH; SW, GH->dead; couple, GH->GH @
  @ and GH->GH; couple GH->dead and GH->GH; couple GH->GH and GH->Dead       @

    stdmxsm  = b_male;                         @ In good health both periods @
    b_dum    = mxcoef[13,2] + mxcoef[17,2]              @ In NH both periods @
               + mxcoef[27,2] + mxcoef[29,2];          
    stdmxsm  = stdmxsm~(b_male+b_dum);
    b_dum    = mxcoef[23,2];                           @ Good Health -> Dead @
    stdmxsm  = stdmxsm~(b_male+b_dum);

    stdmxsw  = b_fmle;                         @ In good health both periods @
    b_dum    = mxcoef[14,2] + mxcoef[18,2]              @ In NH both periods @
               + mxcoef[28,2] + mxcoef[30,2];    
    stdmxsw  = stdmxsw~(b_fmle+b_dum);
    b_dum    = mxcoef[24,2];                           @ Good Health -> Dead @
    stdmxsw  = stdmxsw~(b_fmle+b_dum);

    stdmxc   = b_const;                   @ Both in good health both periods @
    b_dum    = mxcoef[23,2];        @ Both in GH -> Husband dead, wife in GH @
    stdmxc   = stdmxc~(b_fmle+b_dum);
    b_dum    = mxcoef[24,2];        @ Both in GH -> Husband in GH, wife dead @
    stdmxc   = stdmxc~(b_male+b_dum);

    stdmx    = stdmxsm~stdmxsw~stdmxc;      
    b_PI     = mxcoef[6,2] + mxcoef[8,2]*ageseq;
    b_PI2    = mxcoef[7,2]*ones(_TR,1);
    varmx_pi = b_PI~b_PI~(b_PI+mxcoef[25,2])~b_PI~b_PI~(b_PI+mxcoef[26,2]);
    varmx_pi = varmx_pi~b_PI~(b_PI+mxcoef[25,2])~(b_PI+mxcoef[26,2]);
    varmx_PI2 = b_PI2*ones(1,cols(varmx_pi));


    if minc(minc(stdmx))<0; /* penalize negative variances in GMM criterion */
        negpen = 1;
    else;
        negpen = 0;
    endif;

    stdmx  = sqrt(abs(stdmx));

    if pctle /= -1;

        {mxmean,mxsmtd,mx995} = mxprofs(mnmx,stdmx,mnmx_pi,varmx_pi,mnmx_pi2,
                                        varmx_pi2,pctle);
        if prntab>0;
    
            title1   = "         Age"$+hslabel3;

            ?;" Analytical Mean OOP Medex at the ";; pctle;; " PI Percentile";
            title1;;
            ageseq[smplyrs]~mxmean[smplyrs,.];?;

            " Analytical Std. Deviation OOP Medex at the ";; pctle;; " PI Percentile";
            title1;;
            ageseq[smplyrs]~mxsmtd[smplyrs,.];?;

            " 99.5-th Percentile OOP Medex at the ";; pctle;; " PI Percentile";
            title1;;
            ageseq[smplyrs]~mx995[smplyrs,.];?;
        endif;
    endif;

retp(negpen); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(3) = mxprofs(mnlnmx,stdmx,mnmx_pi,varmx_pi,mnmx_pi2,varmx_pi2,pctle);
   
    local pieffcts, mnmx2, stdmx2, pct995, mxmean, mxstd, mx995;

    pieffcts = mnmx_pi*pctle + mnmx_pi2*(pctle^2);
    mnmx2    = mnlnmx + pieffcts;
    pieffcts = varmx_pi*pctle + varmx_pi2*(pctle^2);
    stdmx2   = sqrt(stdmx^2 + pieffcts);
    
    mxmean   = exp(mnmx2 + (stdmx2.^2)/2);
    mxstd    = sqrt( exp(2*mnmx2 + stdmx2.^2).*(exp(stdmx2.^2)-1) );
    pct995   = 2.5758293;
    mx995    = exp(mnmx2 + pct995*stdmx2);

retp(mxmean,mxstd,mx995); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/* 
GETDATA:  load and clean up data
*/

proc(40) = getdata();

    local datstr, obsdat, wlthdat, nw, sp, totobs, agedat, PIdat, asstdat, 
          aobsdat, MStatdat, MSobsdat, Msgapdat, aMstatdat, Sngldat, aSngldat, 
          Mrrddat, aMrrddat, alivedat, alobsdat, beqdat, bMstatdat, bobsdat, 
          dbobsdat, OOPdat, OOPobsdat, MCXdat, MCXobsdat, mxdat, mxobsdat, MCdat, 
          MCobsdat, hshdat, hshobsdat, hswdat, hswobsdat, condat, conobsdat, 
          snglPIdat, mrrdPIdat, wdwdat, awdwdat, dasstdat, daobsdat, dbasstdat, 
          dumcol, agedat96, datawgts, chrtcnts, chrttype, avgage96, i, toobig, 
          goth, gotw, initletest, initle96, cn, jj, hshgap, hswgap;

    datstr = datapath$+"wlthmat_NEW101618.out";
    loadm wlthdat[4227,304] = ^datstr;

    nw       = 9;                                               @ number of waves-1 @
    sp       = 225|5|15|25|35|85|95|145|155|165|175|185|195|205|215|265|275; 
    if contype==1; @alternative, select total consumption expenditure@
        sp       = 225|5|15|25|35|85|95|145|155|165|175|185|195|205|215|245|255;
    endif;
 @  age|mstat|msobs|wealth|wlthobs|mx|mxobs|getsMCaid|GMCobs|Medicaid|MCobs|hsm|hsmobs|hsw|hswobs  @
    obsdat   = 1 - (wlthdat[.,2].>0);         @ clear out incomplete observations @;
    obsdat   = obsdat + (wlthdat[.,sp[1]].>dieage) + (wlthdat[.,sp[1]].<bornage);
    obsdat   = obsdat.>0;  
    obsdat   = 1-obsdat;
    wlthdat  = selif(wlthdat,obsdat);
    
    agedat   = wlthdat[.,sp[1]:sp[1]+nw];
    agedat   = round(agedat/agestep)*agestep;
    obsdat   = agedat.<=dieage;   @ Kill if too old for model @

 @  Remove people with gaps in their marital histories @ 
 @  Note:  Marital status is sometimes listed as missing at the ends of HH lives @
 @         Note clear if the latter are truly missing @

    MSobsdat = (wlthdat[.,sp[3]:sp[3]+nw].==0).*obsdat;
    MSgapdat = (wlthdat[.,sp[2]:sp[2]+nw].>0).*MSobsdat;
    MSgapdat = (MSgapdat[.,2:nw+1]-MSgapdat[.,1:nw]).>0;
    MSgapdat = (MSgapdat*ones(nw,1)).>0;
    MSgapdat = 1-MSgapdat;  @ reverse for filter, so that no gap = 1 @

 // msgapdat = ones(rows(msgapdat),1);
    msgapdat = msgapdat.*(wlthdat[.,sp[2]].<3); // INITIAL SINGLES

    wlthdat  = selif(wlthdat,MSgapdat);
    agedat   = selif(agedat,MSgapdat);
    obsdat   = selif(obsdat,MSgapdat);
    MSobsdat = selif(MSobsdat,MSgapdat);

    totobs   = rows(wlthdat);"Number of observations";;totobs;?;
    HHIDdat  = wlthdat[.,1];

    if wgtddata==0;
        PIdat    = wlthdat[.,3];
        datawgts = ones(totobs,1);
    elseif wgtddata==1;
        PIdat    = wlthdat[.,4];
        datawgts = wlthdat[.,2];
        datawgts = datawgts*totobs/sumc(datawgts);
    endif;   
    
    MStatdat  = wlthdat[.,sp[2]:sp[2]+nw].*MSobsdat;
    Mstatdat  = (Mstatdat.==1)*2 + (Mstatdat.==2)*1 + (Mstatdat.==3)*3; @ Recode so that 1 = male @
    alivedat  = Mstatdat.>0;   

    asstdat   = wlthdat[.,sp[4]:sp[4]+nw];
    toobig    = asstdat.>asstmax;
    asstdat   = asstdat.*(1-toobig) + toobig.*asstmax;
    aobsdat   = (wlthdat[.,sp[5]:sp[5]+nw].==0).*obsdat;
    cn        = cols(aobsdat);
    dumcol    = zeros(totobs,1);
    dasstdat  = dumcol~(asstdat[.,2:cn]-asstdat[.,1:(cn-1)]);
    daobsdat  = ones(totobs,1)~(aobsdat[.,2:cn].*aobsdat[.,1:(cn-1)]);

    bobsdat   = ((aobsdat-alivedat).>0).*obsdat;  @ died just prior to this wave @
    beqdat    = bobsdat.*asstdat;
    dbasstdat = dasstdat.*bobsdat;
    dbobsdat  = bobsdat.*daobsdat;  @ for some bequests, we don't see assets in preceding period @    
    bMStatdat = bobsdat[.,2:cn].>0;
    bMStatdat = bMStatdat.*MStatdat[.,1:cn-1]; @ Multiply by previous wave's status @
    bMstatdat = zeros(totobs,1)~bMStatdat;
    aMStatdat = Mstatdat+bMstatdat;
    aobsdat   = aobsdat.*(aMstatdat.>0);
    
    if deadassts==0; @ Don't include bequests @
        aobsdat   = aobsdat.*alivedat;
        daobsdat  = daobsdat.*alivedat; 
        aMStatdat = MStatdat;
    endif;   

    OOPdat    = wlthdat[.,sp[6]:sp[6]+nw]*agestep;
    OOPobsdat = (wlthdat[.,sp[7]:sp[7]+nw].==0).*obsdat;
    MCdat     = wlthdat[.,sp[8]:sp[8]+nw];                       @ Medicaid Indicator @
    MCobsdat  = (wlthdat[.,sp[9]:sp[9]+nw].==0).*obsdat;
    MCXdat    = wlthdat[.,sp[10]:sp[10]+nw]*agestep;              @ Medicaid spending @
    MCXobsdat = (wlthdat[.,sp[11]:sp[11]+nw].==0).*obsdat;
    mxdat     = OOPdat+MCXdat;
    mxobsdat  = OOPobsdat.*MCXobsdat;
    hshdat    = wlthdat[.,sp[12]:sp[12]+nw];    @ 0 = dead, 1 = NH, 2 = bad, 3 = good @;
    hshobsdat = (wlthdat[.,sp[13]:sp[13]+nw].==0).*(alivedat); 
    hswdat    = wlthdat[.,sp[14]:sp[14]+nw];    @ 0 = dead, 1 = NH, 2 = bad, 3 = good @;
    hswobsdat = (wlthdat[.,sp[15]:sp[15]+nw].==0).*(alivedat);
    condat    = wlthdat[.,sp[16]:sp[16]+nw]*agestep;    @ Consumption Expenditures @;
    conobsdat = (wlthdat[.,sp[17]:sp[17]+nw].==0).*(obsdat);
    
    
    initle96  = wlthdat[.,sp[1]]~PIdat~MStatdat[.,1]~hshdat[.,1]~hswdat[.,1]~hshobsdat[.,1]~hswobsdat[.,1];   /* Use for life exp. calculations */
    goth      = (initle96[.,3].==1)+(initle96[.,3].==3);
    gotw      = (initle96[.,3].==2)+(initle96[.,3].==3);
    initletest = ( 1+goth.*(hshobsdat[.,1]-1) ).*( 1+gotw.*(hswobsdat[.,1]-1) );
    initle96  = selif(initle96[.,1:5],initletest); 
    rows(initletest);;rows(initle96);
    save path =^shkpath initle96;

    cn        = seqa(1,1,mmtyrs);
    alivedat  = alivedat[.,cn];
    agedat    = agedat[.,cn];    
    MStatdat  = MStatdat[.,cn];
    aMStatdat = aMStatdat[.,cn]; 
    bMStatdat = bMStatdat[.,cn];        
    asstdat   = asstdat[.,cn];
    aobsdat   = aobsdat[.,cn];
    beqdat    = beqdat[.,cn];
    bobsdat   = bobsdat[.,cn]; 
    dbasstdat = dbasstdat[.,cn]; 
    dasstdat  = dasstdat[.,cn];
    daobsdat  = daobsdat[.,cn];
    dbobsdat  = dbobsdat[.,cn];    
    OOPdat    = OOPdat[.,cn];
    OOPobsdat = OOPobsdat[.,cn];

    Mcdat     = Mcdat[.,cn];
    Mcobsdat  = Mcobsdat[.,cn];
    mxdat     = mxdat[.,cn];
    mxobsdat  = mxobsdat[.,cn];

    hshdat    = hshdat[.,cn];
    hshobsdat = hshobsdat[.,cn];
    hswdat    = hswdat[.,cn];
    hswobsdat = hswobsdat[.,cn];
    goth      = (MStatdat.==1)+(MStatdat.==3);
    gotw      = (MStatdat.==2)+(MStatdat.==3);
    hshdat    = hshdat.*goth;
    hshobsdat = hshobsdat.*goth;
    hswdat    = hswdat.*gotw;
    hswobsdat = hswobsdat.*gotw;
    Sngldat   = (MStatdat.>0).*(MStatdat.<3);
    aSngldat  = (aMStatdat.>0).*(aMStatdat.<3);
    Mrrddat   = (MStatdat.==3);
    aMrrddat  = (aMStatdat.==3);
    wdwdat    = dumcol~(Mrrddat[.,1:(mmtyrs-1)].*Sngldat[.,2:mmtyrs]);
    awdwdat   = dumcol~(aMrrddat[.,1:(mmtyrs-1)].*aSngldat[.,2:mmtyrs]); 
    snglPIdat = PIrank(PIdat.*miss(Sngldat[.,1],0),datawgts);
//  mrrdPIdat = PIrank(PIdat.*miss(Mrrddat[.,1],0),datawgts);
    mrrdPIdat = snglPIdat;  // placeholder as there are no couples

    condat =    condat[.,cn];
    conobsdat = conobsdat[.,cn];
    
    {chrtcnts,chrttype} = getchrt(agedat[.,1],cohorts);
  
    avgage96 = zeros(chrtnum,1);
    i=1; do until i>chrtnum;
         avgage96[i] = ((chrttype.==i)'*agedat[.,1])/chrtcnts[i,4];
    i=i+1; endo;
    agedat96 = agedat[.,1];
    avgage96 = round(avgage96);
    "Average Cohort Age"; seqa(1,1,chrtnum)~avgage96;

retp(agedat,PIdat,asstdat,dasstdat,beqdat,dbasstdat,MStatdat,aMstatdat,
     bMstatdat,Sngldat,aSngldat,Mrrddat,aMrrddat,wdwdat,awdwdat,aobsdat,
     bobsdat,daobsdat,dbobsdat,OOPdat,OOPobsdat,MCXdat,MCXobsdat,mxdat,
     mxobsdat,MCdat,MCobsdat,hshdat,hshobsdat,hswdat,hswobsdat,totobs,
     datawgts,agedat96,avgage96,HHIDdat,snglPIdat,mrrdPIdat,condat,
     conobsdat); endp;
     
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/* 
INITDIST:  This gives the initial distribution of assets, wages, health,
           permanent income, and persistent health costs
*/
proc(2) = initdist(isimage,_nn0);

    local ageindx, jj, msgap, goth, gotw, hhmissdat, hwmissdat, gotobs, gotobs2, num0, 
          rn, simsperobs, _nn, onesim, num, agesim96, pisim96, mstat96, asim96, mxsim96, 
          oopsim96, MCXsim96,MCsim96, hsimh96, hsimw96, goth96, gotw96, simwgt96, HHIDsim,
          iHS, frach, fracw, hhdat, hwdat, msdat,  ai, asstsign, oldasst, lnabasst, varasst, 
          bta, asstnoiz, projerr, ln_inc, yPI_96, incsim96, asimx, incsim96x, mxsim96x, 
          oopsim96x, MCXsim96x, MCsim96x, agesimx, pisimx, simwgtx, HHIDx, astnoizx, 
          hsimhx, hsimwx, mstatx, mstatdx, hhdx, hwdx, hhmissdx, hwmissdx, toosmall, 
          bumpup, ms2;

    ageindx  = ones(totobs,1);
    if simtype==2;
        ageindx  = (agedat[.,1].>=(isimage[1])).*(agedat[.,1].<=(isimage[2]));
    endif;

    hhmissdat = ( (1-hshobsdat)+(hshdat.==0) );
    hhmissdat = hhmissdat.>0;
    hwmissdat = ( (1-hswobsdat)+(hswdat.==0) );
    hwmissdat = hwmissdat.>0;

    goth      = (mstatdat.==1)+(mstatdat.==3);
    gotw      = (mstatdat.==2)+(mstatdat.==3);

 // Note:  health missing indicator sometimes = 1 when person is dead
    gotobs   = aobsdat[.,1].*mxobsdat[.,1].*(1-hhmissdat[.,1].*goth[.,1]).*(1-hwmissdat[.,1].*gotw[.,1]).*ageindx; 

    num0     = seqa(1,1,totobs);
    num0     = selif(num0,gotobs);  /* restrict ourselves to non-missing obs */
    rn       = rows(num0);
 
    "Fraction alive/men/women in data";;
    ms2 = selif(Mstatdat,gotobs);
    yearseq~meanc(ms2.>0)~meanc(ms2.==1)~meanc(ms2.==2);?; 
   
    if clonesims==0;                                     @ random draws of indices @
        _nn        = _nn0;
        onesim     = ones(_nn,1);
        num        = rndu(_nn,1)*rn;    
        num        = floor(num)+onesim;
        num        = num0[num];
    elseif clonesims==1;          @ equal number of sims for each data observation @
        simsperobs = round(_nn0/rn);
        _nn        = rn*simsperobs;
        onesim     = ones(_nn,1);
        num        = num0.*.ones(simsperobs,1);
    endif;

    "Number of observations in initial distribution =";; rn;?;
    
  /*--------Draw assets, wages and health from empirical distribution--------*/
    agesim96 = agedat[num,1];
    pisim96  = PIdat[num];
    HHIDsim  = HHIDdat[num];
    mstat96  = Mstatdat[num,1];
    gotobs2  = (hshobsdat[num,1]+hswobsdat[num,1]).*(mstat96.>0);
    gotobs2  = gotobs2.>0;
    goth96   = gotobs2.*((mstat96.==1)+(mstat96.==3));
    gotw96   = gotobs2.*((mstat96.==2)+(mstat96.==3));
    asim96   = asstdat[num,1];
    asim96   = asim96 + (asim96.>asstmax).*(asstmax-asim96);
    mxsim96  = mxdat[num,1];
    oopsim96 = oopdat[num,1];
    MCXsim96 = MCXdat[num,1];
    MCsim96  = MCdat[num,1];
    hsimh96  = hshdat[num,1];
    hsimw96  = hswdat[num,1];
    simwgt96 = datawgts[num,1];

    msdat    = mstatdat[num,1:mmtyrs];
    hhdat    = hshdat[num,1:mmtyrs];
    hwdat    = hswdat[num,1:mmtyrs];
    hhmissdat = hhmissdat[num,1:mmtyrs];
    hwmissdat = hwmissdat[num,1:mmtyrs];

    "Fraction of HH with men   ";; meanc(goth96);
    "Fraction of HH with women ";; meanc(gotw96);
    "Fraction in each health group (men and women), 1996 = ";
    iHS=1; do until iHS>hsnum;    
        frach = meanc((hsimh96.==iHS).*goth96)/meanc(goth96);
        fracw = meanc((hsimw96.==iHS).*gotw96)/meanc(gotw96);
        hslabel[iHS];;frach~fracw;
    iHS=iHS+1; endo;

  /*---Now alter asset and coh distribution to allow for measurement error---*/ 
  /*--------Model:  coh = a + v, v = zero mean error, orthogonal to a--------*/
  /*-----------------a^ = a + u, u orthogonal to a, v------------------------*/
    oldasst  = asim96;
    if assterr > 0;
        asstsign = -1+2*(asim96.>=0);
        oldasst  = abs(oldasst).<0.1;                     @ recode zero assets @
        oldasst  = asim96.*(1-oldasst) + 0.1*oldasst.*asstsign;
        lnabasst = ln(abs(oldasst));
        varasst  = vcx(lnabasst) - assterr;
        bta      = varasst/(varasst+assterr);
        asim96   = lnabasst*bta + (1-bta)*meanc(lnabasst);
        projerr  = sqrt(bta*assterr)*rndn(_nn,1); /* Now add in omitted "true" variation */
        asim96   = asim96 + projerr;
        asim96   = asstsign.*exp(asim96);
    else;
        projerr  = rndn(_nn,1);
    endif;
        
    toosmall = asim96.<asstmin;      @ Model bounds assets below:  do the same here @
    bumpup   = toosmall.*(asstmin-asim96);
    asim96   = asim96+bumpup;
    ai       = (agesim96-bornage)/agestep + 1;
    yPI_96   = y_PI[ai,1:5].*(mstat96.==1) + y_PI[ai,6:10].*(mstat96.==2)
               + y_PI[ai,11:15].*(mstat96.==3);
    ln_inc   = yprof[ai,1].*(mstat96.==1) + yprof[ai,2].*(mstat96.==2)
               + yprof[ai,3].*(mstat96.==3)
               + yPI_96[.,1].*pisim96 + yPI_96[.,2].*(pisim96^2)
               + yPI_96[.,3].*(pisim96^3) + yPI_96[.,4].*(pisim96^4)
               + yPI_96[.,5].*(pisim96^5);
    incsim96 = exp(ln_inc); 

    asstnoiz = exp(sqrt(assterr)*rndn(_nn,simyrs));
    if assterr > 0;
        asstnoiz[.,1] = oldasst./(asim96-bumpup);
    endif;
    format /ro 12,4;
    "Mean assets and std dev of measured and 'true' assets, 1996 = ";
    meanc(oldasst)~stdc(oldasst)~meanc(asim96)~stdc(asim96);?;
    "Std. Deviation of Measurement error";; 
    if simtype==1;
        yearseq~stdc(asstnoiz);
    elseif simtype==2;
        ageseqx~stdc(asstnoiz);
    endif;
    ?;

    if simtype==1;
        save path= ^shkpath asim96, incsim96, mxsim96, oopsim96, MCXsim96, 
                            MCsim96, mstat96, pisim96, agesim96, asstnoiz, 
                            hsimh96, hsimw96, msdat, hhdat, hwdat, hhmissdat, 
                            hwmissdat, simwgt96, HHIDsim;
    elseif simtype==2;
        asimx     = asim96;     incsim96x = incsim96;   mxsim96x  = mxsim96;
        oopsim96x = oopsim96;   MCXsim96x = MCXsim96;   MCsim96x  = MCsim96;   
        mstatx    = mstat96;    pisimx    = pisim96;    agesimx   = agesim96;
        astnoizx  = asstnoiz;   hsimhx    = hsimh96;    hsimwx    = hsimw96;
        mstatdx   = mstatdat;   hhdx      = hhdat;      hwdx      = hwdat;
        hhmissdx  = hhmissdat;  hwmissdx  = hwmissdat;  simwgtx   = simwgt96;
        HHIDx     = HHIDsim;
  
        save path= ^shkpath asimx, incsim96x, mxsim96x, oopsim96x, MCXsim96x,
                            MCsim96x, mstatx, pisimx, agesimx, astnoizx, hsimhx, 
                            hsimwx, mstatdx, hhdx, hwdx, hhmissdx, hwmissdx, 
                            simwgtx, HHIDx;
    endif;

retp(_nn, onesim); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
gethms:  simulate 1-step-ahead demographic transitions using a multivariate
         logit model of transition probs
*/
proc(3) = gethms(agesim,mstatsim,healsimh,healsimw,pisim96,hltrans,_nn);
                          
    local cnst, xvars0h, agesimh, agesimw, xvars0w, gotcupl, dumstuff,  
          dumstuff2,xvarsh, xvarsw, iHS, hprobsh, hprobsw, sprobsh, sprobsw, 
          healshk, mstatshk, gotmale, gotfemale, mstpo, too_old, hcdfh, 
          hcdfw, z, hsimpoh, hsimpow;

    cnst      = ones(_nn,1);
    agesimh   = agesim[.,1];
    agesimw   = agesim[.,2];
    xvars0h   = cnst~agesimh~(agesimh^2/100)~(agesimh^3/10000)~pisim96~(pisim96^2)~(pisim96.*agesimh);
    gotcupl   = (mstatsim.==3);     
    xvars0w   = cnst~agesimw~(agesimw^2/100)~(agesimw^3/10000)~pisim96~(pisim96^2)~(pisim96.*agesimw);
    dumstuff  = cnst~agesimh~pisim96;
    dumstuff2 = cnst~agesimh~cnst~pisim96;
    xvarsh    = xvars0h~dumstuff~(gotcupl.*dumstuff2);
    dumstuff2 = cnst~agesimw~(0*cnst)~pisim96;    
    xvarsw    = xvars0w~(0*dumstuff)~(gotcupl.*dumstuff2);
    dumstuff  = cnst~agesimh;
    dumstuff2 = cnst~agesimw;  
 
    iHS=2; do until iHS>hsnum;
        xvarsh = xvarsh~( (healsimh.==iHS).*dumstuff );
        xvarsw = xvarsw~( (healsimw.==iHS).*dumstuff2 );
    iHS=iHS+1; endo;      

    hprobsh   = mvlogit(hltrans,hsnum,xvarsh);  
    sprobsh   = 1-hprobsh[.,1];
    hprobsw   = mvlogit(hltrans,hsnum,xvarsw);
    sprobsw   = 1-hprobsw[.,1];

/*  Note:  health values 0 => dead, 1 => NH, 2 => bad, 3 => good             */
/*         But we want health sequences for "immortals" as well, so we split */
/*         the probability into Pr(alive_t+1) and Pr(h_t+1|alive_t+1)        */

    healshk   = rndu(_nn,2);                            @ for male and female @
    mstatshk  = rndu(_nn,2);
    gotmale   = ( (mstatsim.==1)+(mstatsim.==3) ).>0;
    gotfemale = ( (mstatsim.==2)+(mstatsim.==3) ).>0;
    
    mstpo     = 1*gotmale.*(mstatshk[.,1].<sprobsh) +  @ male alive at time t @
                2*gotfemale.*(mstatshk[.,2].<sprobsw);         @ female alive @
           
    too_old  = (agesimh+1).>dieage;
    mstpo    = mstpo.*(1-too_old);

    hprobsh  = hprobsh[.,2:hsnum+1]./sprobsh;
    hcdfh    = cumsumc(hprobsh')';
    hcdfh[.,hsnum] = hcdfh[.,hsnum]+1e-6;
    z        = hcdfh.<=healshk[.,1]; 
    hsimpoh  = z*ones(hsnum,1)+1;
    
    hprobsw  = hprobsw[.,2:hsnum+1]./sprobsw;
    hcdfw    = cumsumc(hprobsw')';
    hcdfw[.,hsnum] = hcdfw[.,hsnum]+1e-6;
    z        = hcdfw.<=healshk[.,2]; 
    hsimpow  = z*ones(hsnum,1)+1;
   
retp(hsimpoh, hsimpow, mstpo); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
hsimpute:  Impute health status probabilities for years between AHEAD waves
           Here data are sorted by year, with different ages alive each year
           Note:  if health status probabilities vary by marital status, this
                  imputation procedure will NOT work.
*/

proc(3) = hsimpute(agesim,mstatsim,hhdat2,hwdat2,pisim96,hltrans,_nn);

    local cnst, dumstuff, xvars0, dnum, iHS, xvarsh, xvarsw, hprobsh1, 
          hprobsw1, aliveh, alivew, statevec, sumvec, h2dumsh, h2dumsw, 
          tempprh, tempprw, hprobsh2, hprobsw2, iHS1, xvars1, hprobsh, 
          hprobsw, healshk, mstatshk, mstpo, too_old, sprobsh, sprobsw,     
          hcdfh, hcdfw, z, hsimpoh, hsimpow;
 
    cnst     = ones(_nn,1);
    xvars0   = cnst~agesim~(agesim^2/100)~(agesim^3/10000)~pisim96~(pisim96^2)~(pisim96.*agesim);
    dumstuff = cnst~agesim;
    xvarsh   = xvars0~dumstuff;
    xvarsw   = xvars0~(0*dumstuff);
  
  @ 0=>dead, 1=>nursing Home, 2=>bad health, 3=>good health     @
  @ However, even the dead are given a non-zero "health status" @
  @ for the first of the two waves, as hs=0 and hs=1 are        @
  @ treated the same in transtion probabilities.                @
    
    iHS=2; do until iHS>hsnum;
        xvarsh = xvarsh~( (hhdat2[.,1].==iHS).*dumstuff );
        xvarsw = xvarsw~( (hwdat2[.,1].==iHS).*dumstuff );
    iHS=iHS+1; endo;      

    hprobsh1  = mvlogit(hltrans,hsnum,xvarsh);      @ for time_t to time_t+1 @
    hprobsw1  = mvlogit(hltrans,hsnum,xvarsw);
    
  @ Look at t+1 to t+2 transitions.  Don't know t+1 value, so we consider    @
  @ all possibilities.  Pick out probs for transition that ends with state   @
  @ observed at time t+2.                                                    @

    agesim   = agesim+1;
    xvars0   = cnst~agesim~(agesim^2/100)~(agesim^3/10000)~pisim96~(pisim96^2)~(pisim96.*agesim);
    dumstuff = cnst~agesim;
    dnum     = cols(dumstuff);
    xvarsh   = xvars0~dumstuff;
    xvarsw   = xvars0~(0*dumstuff);

    statevec = seqa(0,1,hsnum+1)';
    h2dumsh   = hhdat2[.,2].==(statevec);
    h2dumsw   = hwdat2[.,2].==(statevec);
   
    sumvec   = ones(hsnum+1,1); 
    tempprh  = ones(_nn,1)~zeros(_nn, hsnum);   @ dead at t+1 => dead at t+2 @ 
    tempprw  = tempprh;
    
    hprobsh2 = (tempprh.*h2dumsh)*sumvec;   @ select prob for time-t+2 state @
    hprobsw2 = (tempprw.*h2dumsw)*sumvec;   @ select prob for time-t+2 state @
    
    iHS1=1; do until iHS1>hsnum;                           @ time_t+1 states @
        xvars1   = zeros(_nn,(hsnum-1)*dnum);     @ construct pseudo-dummies @
        if iHS1>1;
            xvars1[.,(iHS1-2)*dnum+1:(iHS1-1)*dnum] = dumstuff;
        endif;
        
      @ Find transtion probabilities, then select prob for time-t+2 state     @
        tempprh  = mvlogit(hltrans,hsnum,xvarsh~xvars1);
        hprobsh2 = hprobsh2~((tempprh.*h2dumsh)*sumvec);
        tempprw  = mvlogit(hltrans,hsnum,xvarsw~xvars1);
        hprobsw2 = hprobsw2~((tempprw.*h2dumsw)*sumvec);
         
    iHS1=iHS1+1; endo; 
       
  @ Apply Bayes' Rule to find probabilities for each time-t+1 state, given   @
  @ the states at times t and t+2.                                           @
       
    hprobsh  = hprobsh1.*hprobsh2;     @ probability of each transition path @
    hprobsh  = hprobsh./(hprobsh*sumvec);                @ conditional probs @
    sprobsh  = 1-hprobsh[.,1];
    hprobsw  = hprobsw1.*hprobsw2;
    hprobsw  = hprobsw./(hprobsw*sumvec);
    sprobsw  = 1-hprobsw[.,1];
    healshk  = rndu(_nn,2);                            @ for male and female @
    mstatshk = rndu(_nn,2);
    mstpo    = 1*(mstatsim.==1).*(mstatshk[.,1].<sprobsh) + @ male at time t @
               2*(mstatsim.==2).*(mstatshk[.,2].<sprobsw);          @ female @
           
    too_old = (agesim+1).>dieage;
    mstpo   = mstpo.*(1-too_old);

    hprobsh  = hprobsh[.,2:hsnum+1]./sprobsh;
    hcdfh    = cumsumc(hprobsh')';
    hcdfh[.,hsnum] = hcdfh[.,hsnum]+1e-6;
    z        = hcdfh.<=healshk[.,1]; 
    hsimpoh  = z*ones(hsnum,1)+1;
    hprobsw  = hprobsw[.,2:hsnum+1]./sprobsw;
    hcdfw    = cumsumc(hprobsw')';
    hcdfw[.,hsnum] = hcdfw[.,hsnum]+1e-6;
    z        = hcdfw.<=healshk[.,2]; 
    hsimpow  = z*ones(hsnum,1)+1;
  
retp(hsimpoh, hsimpow, mstpo); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
INITMX:  Generate medical expenditure shocks.  Here, "medex shocks" are  
         uniformly-distributed variables applied to Markov chain probabilities
*/

proc(0) = initmx(_ns);

    local ztacdfsim96, epscdfsim, xicdfsim, ztacdfx, epscdfx, xicdfx;

    ztacdfsim96 = rndu(_ns,1);          /*  Initial draw of AR(1)          */
    epscdfsim   = rndu(_ns,simyrs+1);   /*  simulated innovation on AR(1)  */
    xicdfsim    = rndu(_ns,simyrs+1);   /*  simulated white noise shock    */

    if simtype==1;
        save path=^shkpath ztacdfsim96, xicdfsim, epscdfsim;
    elseif simtype==2;
        ztacdfx = ztacdfsim96;  xicdfx = xicdfsim;  epscdfx = epscdfsim;
        save path=^shkpath ztacdfx, xicdfx, epscdfx;
    endif;           
	 
retp; endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
INITSIM:  Simulate sequences of health, health cost and demographic shocks
          Here data are sorted by year, with different ages alive each year
*/
proc(0) = initsim(hltrans);

    local hsimh96, hsimw96, mstat96, pisim96, agesim96, ageindx,
          hsimhx, hsimwx, mstatx, pisimx, agesimx, ii, awadj, ageh, ai2,  
          healsimh, healsimw, hsimpoh, hsimpow, mstatsim, mstpo, agesim, 
          hlsimhx, hlsimwx;

    if simtype==1;
        load path=^shkpath hsimh96, hsimw96, mstat96, pisim96, agesim96;  
    elseif simtype==2;
        load path=^shkpath hsimhx, hsimwx, mstatx, pisimx, agesimx;           
        hsimh96 = hsimhx;  hsimw96  = hsimwx;  mstat96  = mstatx[.,1];
        pisim96 = pisimx;  agesim96 = agesimx[.,1]; 
        clear hsimhx, hsimwx, mstatx, pisimx, agesimx;
    endif;    

    mstatsim = mstat96;        /* 0=>defunct, 1=>husband, 2=>wife, 3=>couple */
    agesim   = agesim96;
    awadj    = (mstatsim[.,1].==3)*agediffw;
 
    healsimh = hsimh96;    /* 1=>Nursing Home, 2=>bad health, 3=>good health */
    healsimw = hsimw96;

    ii=1; do until ii > simyrs;      /* Update with transition probabilities */
        ageh     = agesim96+(ii-1)*agestep;           /* for appropriate age */
        {hsimpoh, hsimpow, mstpo} = gethms((ageh~(ageh-awadj)), mstatsim[.,ii], healsimh[.,ii], 
                                           healsimw[.,ii], pisim96, hltrans, _nn);
        healsimh = healsimh~hsimpoh;
        healsimw = healsimw~hsimpow;
        mstatsim = mstatsim~mstpo;
        agesim   = agesim~(agesim[.,ii]+(mstpo.>0)*agestep);
    ii=ii+1; endo;
    agesim = agesim.*(mstatsim.>0);

    ?;"Number of simulated observations";; _nn;?;

    if simtype==1;
        save path=^shkpath agesim, healsimh, healsimw, mstatsim;
    elseif simtype==2;
        agesimx = agesim;    mstatx  = mstatsim;  
        hlsimhx = healsimh;  hlsimwx = healsimw;
        save path=^shkpath agesimx, hlsimhx, hlsimwx, mstatx;
    endif;

    initmx(_nn);                           /* Generate and save medex shocks */

retp; endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
INITSIM2:  Simulate sequences of health, health cost and demographic shocks
           Here data are sorted by year, with different ages alive each year
           This version uses health and mortality shocks observed in the data,
           with missing (no-wave) values imputed using Baye's Rule.
*/
proc(0) = initsim2(hltrans);

    local hsimh96, hsimw96, mstat96, pisim96, agesim96, msdat, msmiss, hhdat, hwdat,
          hhmissdat, hwmissdat, hmissh, hmissw, healsimh, healsimw, hsimhx, hsimwx, 
          mstatx, pisimx, agesimx, mstatdx, hhdx, hwdx, hhmissdx, hwmissdx, hsimpoh, 
          hsimpow, mstatsim, mstpo, agesim, awadj, ageh, jj, ii, ii_L, ii_H, jj2, 
          hhdat2, hwdat2, hmiss, hlsimhx, hlsimwx, goth, gotw;

    if simtype==1;
        load path=^shkpath hsimh96, hsimw96, mstat96, pisim96, agesim96, 
                           msdat, hhdat, hwdat, hhmissdat, hwmissdat;
    elseif simtype==2;
        load path=^shkpath hsimhx, hsimwx, mstatx, pisimx, agesimx, 
                           mstatdx, hhdx, hwdx, hhmissdx, hwmissdx;   
        hsimh96   = hsimhx;  hsimw96 = hsimwx;   mstat96   = mstatx[.,1];  
        pisim96   = pisimx;  msdat   = mstatdx;  agesim96  = agesimx[.,1];  
        hhdat     = hhdx;    hwdat   = hwdx;     hhmissdat = hhmissdx;
        hwmissdat = hwmissdx;

        clear hsimhx, hsimwx, mstatx, pisimx, agesimx, mstatdx, 
              hhdx, hwdx, hhmissdx, hwmissdx;
    endif; 
        
    mstatsim = mstat96;         @ 0=>defunct, 1=>husband, 2=>wife, 3=>couple @
    agesim   = agesim96;
    awadj    = (mstatsim[.,1].==3)*agediffw;
 
    healsimh = hsimh96;     @ 1=>Nursing Home, 2=>bad health, 3=>good health @
    healsimw = hsimw96;

  /*---------Fill in gaps in demographic histories (fine for singles)---------*/
  /*---------------------------Not great for couples--------------------------*/
  
    jj = mmtyrs; do while jj>1;
        msmiss = (msdat[.,jj-1].==0).*(msdat[.,jj].>0);
        msdat[.,jj-1] = msdat[.,jj-1].*(1-msmiss) + msmiss.*msdat[.,jj];
    jj=jj-1; endo;

    jj=1; do until jj > (mmtyrs-1);                     @ loop through waves @

        ii_L = mmtcols[jj];                    @ index of starting wave year @
        ii_H = mmtcols[jj+1]-1;                            @ unobserved year @

      /*-----Start with data for wave years, then fill in missing values------*/      
        hhdat2 = healsimh[.,ii_L]~hhdat[.,jj+1];
        hwdat2 = healsimw[.,ii_L]~hwdat[.,jj+1];


      /*-----------Replace missing values of hhdat with simulations-----------*/ 
      /*-Assume that first value of pair is observed, but second might not be-*/
        ii=ii_L; do until ii > ii_H; 
            ageh     = agesim96+(ii-1)*agestep;           /* for appropriate age */
            {hsimpoh, hsimpow, mstpo} = gethms((ageh~(ageh-awadj)), mstatsim[.,ii], healsimh[.,ii], 
                                               healsimw[.,ii], pisim96, hltrans, _nn);
            healsimh = healsimh~hsimpoh;
            healsimw = healsimw~hsimpow;
            mstatsim = mstatsim~mstpo;
        ii=ii+agestep; endo;
     
        hmissh = hhmissdat[.,(jj+1)];
        hmissw = hwmissdat[.,(jj+1)];

        hhdat2[.,2] = hhdat2[.,2].*(1-hmissh) + hmissh.*healsimh[.,ii_H+1];
        hwdat2[.,2] = hwdat2[.,2].*(1-hmissw) + hmissw.*healsimw[.,ii_H+1];

        healsimh = healsimh[.,1:ii_L];
        healsimw = healsimw[.,1:ii_L];
        mstatsim = mstatsim[.,1:ii_L];
        if agestep==1;
        
         /*---------------Fill in non-wave years with imputations----------------*/      
            ageh     = agesim96+ii_L-1;
            {hsimpoh, hsimpow, mstpo} = hsimpute((ageh~(ageh-awadj)), mstatsim[.,ii_L], hhdat2, 
                                                 hwdat2, pisim96, hltrans, _nn);
            healsimh = healsimh~hsimpoh;
            healsimw = healsimw~hsimpow;
            mstatsim = mstatsim~mstpo;
            mstatsim = mstatsim~msdat[.,jj+1];
            agesim   = agesim~( agesim[.,ii_L]+(mstpo.>0) );
            agesim   = agesim~( agesim[.,ii_H]+(msdat[.,jj+1].>0) );
        
         /*--------impute health status for people who die between waves---------*/               
            ageh     = ageh+1;
            {hsimpoh, hsimpow, mstpo} = gethms((ageh~(ageh-awadj)), mstatsim[.,ii_H], healsimh[.,ii_H], 
                                               healsimw[.,ii_H], pisim96, hltrans, _nn);
            hmissh = (hhdat2[.,2].==0);
            hhdat2[.,2] = hhdat2[.,2].*(1-hmissh) + hmissh.*hsimpoh;
            hmissw = (hwdat2[.,2].==0);
            hwdat2[.,2] = hwdat2[.,2].*(1-hmissw) + hmissw.*hsimpow;
            healsimh = healsimh~hhdat2[.,2];
            healsimw = healsimw~hwdat2[.,2];

        else;

            mstatsim = mstatsim~msdat[.,jj+1];
            agesim   = agesim~( agesim[.,ii_L]+(msdat[.,jj+1].>0)*agestep );
            healsimh = healsimh~hhdat2[.,2];
            healsimw = healsimw~hwdat2[.,2];

        endif;
        
    jj=jj+1; endo;
    
    ii=mmtcols[mmtyrs]; do until ii > simyrs;                   @ Final year @
        ageh     = agesim96+(ii-1)*agestep;                       
        {hsimpoh, hsimpow, mstpo} = gethms((ageh~(ageh-awadj)), mstatsim[.,ii], healsimh[.,ii], 
                                           healsimw[.,ii], pisim96, hltrans, _nn);
        healsimh = healsimh~hsimpoh;
        healsimw = healsimw~hsimpow;
        mstatsim = mstatsim~mstpo;
        agesim   = agesim~(agesim[.,ii]+(mstpo.>0));
    ii=ii+agestep; endo;

    goth     = (mstatsim.==1) + (mstatsim.==3);
    gotw     = (mstatsim.==2) + (mstatsim.==3);
    healsimh = healsimh.*goth;
    healsimw = healsimw.*gotw;

    "HS missing, person alive, for men and women (backward in time)";
    jj = simyrs; do while jj>0;
        if simtype==1; yearseq[jj];; else; ageseqx[jj];; endif;
        hmissh = (hhmissdat[.,jj].==1).*(goth[.,jj].>0);
        hmissw = (hwmissdat[.,jj].==1).*(gotw[.,jj].>0);
        meanc(hmissh)~meanc(hmissw);;
        hmissh = (healsimh[.,jj].>0).*(hhdat[.,jj].==0);
        hmissw = (healsimw[.,jj].>0).*(hwdat[.,jj].==0);
        meanc(hmissh)~meanc(hmissw);
    jj=jj-1; endo;?;

    agesim = agesim.*(mstatsim.>0);

    if simtype==1;
        save path=^shkpath agesim, healsimh, healsimw, mstatsim;
    elseif simtype==2;
        agesimx = agesim;    mstatx  = mstatsim;  
        hlsimhx = healsimh;  hlsimwx = healsimw;
        save path=^shkpath agesimx, hlsimhx, hlsimwx, mstatx;
    endif;

    initmx(_nn);                          /* Generate and save medex shocks */
	 
retp; endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(0) = sumshks();

    local agesim96, healsimh, healsimw, mstatsim, agesim, pisim96, frh, frw, 
          frc, frdead, yearseq2, hsm, hsw, cn, hsh1, hsh2, hdh1, hdh2, cph, 
          hsw1, hsw2, hdw1, hdw2, cpw, iHS1, iHS2; 

    yearseq2 = yearseq|(maxc(yearseq)+agestep);
    load path= ^shkpath healsimh, healsimw, mstatsim, agesim, pisim96;

    frdead = (mstatsim.==0);
    frh    = (mstatsim.==1);
    frw    = (mstatsim.==2);
    frc    = (mstatsim.==3);

    "Fraction of Households that are single men, single women, couples or dead";;
    yearseq2~meanc(frh)~meanc(frw)~meanc(frc)~meanc(frdead);?;

    frh = (mstatsim.==1)+(mstatsim.==3);   @ ones(_nn,1); @
    frw = (mstatsim.==2)+(mstatsim.==3);   @ ones(_nn,1); @


    
    "Distribution of health for men and women that are still alive";
    hdh1 = {};
    hdw1 = {};
    iHS1 = 1; do until iHS1>hsNum;
        hdh1 = hdh1~( meanc((healsimh.==iHS1).*frh)./meanc(frh) );
        hdw1 = hdw1~( meanc((healsimw.==iHS1).*frw)./meanc(frw) );
    iHS1 = iHS1+1; endo;

    "            ";; hslabel2$+"     E(hPI|t)     E(wPI|t)";;
    yearseq2~hdh1~hdw1~(meanc(pisim96.*frh)./meanc(frh))~(meanc(pisim96.*frw)./meanc(frw))~maxc(agesim);?;

    "Time-t transition probs for time-t+1 (living only)";
    
    cn   = cols(healsimh);
    hsh1 = healsimh[.,1:cn-1];
    hsh2 = healsimh[.,2:cn];
    hsw1 = healsimw[.,1:cn-1];
    hsw2 = healsimw[.,2:cn];
    
    iHS1 = 1; do until iHS1>hsNum;
        "Current health state = ";; hslabel[iHS1];
        "            ";; hslabel2;;
        hdh1 = (hsh1.==iHS1).*frh[.,2:cn];                         @ time-t health = iHS1 @
        hdw1 = (hsw1.==iHS1).*frw[.,2:cn];
        cph  = {};
        cpw  = {};
        
        iHS2 = 1; do until iHS2>hsNum;
            hdh2 = (hsh2.==iHS2);                         @ time-t+1 health = iHS2 @
            hdw2 = (hsw2.==iHS2);
            cph  = cph~( meanc(hdh2.*hdh1)./meanc(hdh1) );
            cpw  = cpw~( meanc(hdw2.*hdw1)./meanc(hdw1) );
        iHS2=iHS2+1; endo;            

        yearseq~cph~cpw;?;
    iHS1=iHS1+1; endo;

retp; endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
proc(0) = sumshks2();

    local hlsimhx, hlsimwx, mstatx, frh, frw, frc, frdead, ageseq2, hsh, hsw, iHS;

    load path= ^shkpath hlsimhx, hlsimwx, mstatx;

@Now compute for initial couples - select also those who are initial couples and divide by initial couples@
   
    ageseq2 = ageseqx|(maxc(ageseqx)+agestep);

    frdead = (mstatx.==0).*(mstatx[.,1].==3)./meanc((mstatx[.,1].==3));
    frh    = (mstatx.==1).*(mstatx[.,1].==3)./meanc((mstatx[.,1].==3));
    frw    = (mstatx.==2).*(mstatx[.,1].==3)./meanc((mstatx[.,1].==3));
    frc    = (mstatx.==3).*(mstatx[.,1].==3)./meanc((mstatx[.,1].==3));
    
    "Fraction of Initial Couples Households that are single men, single women, couples or dead";;
    ageseq2~meanc(frh)~meanc(frw)~meanc(frc)~meanc(frdead);?;
    
    @Now compute for initial singles- select also those who are initial singles and divide by initial singles@
  
    frdead = (mstatx.==0).*((mstatx[.,1].==1)+(mstatx[.,1].==2))./meanc((mstatx[.,1].==1)+(mstatx[.,1].==2));
    frh    = (mstatx.==1).*((mstatx[.,1].==1)+(mstatx[.,1].==2))./meanc((mstatx[.,1].==1)+(mstatx[.,1].==2));
    frw    = (mstatx.==2).*((mstatx[.,1].==1)+(mstatx[.,1].==2))./meanc((mstatx[.,1].==1)+(mstatx[.,1].==2));
    frc    = (mstatx.==3).*((mstatx[.,1].==1)+(mstatx[.,1].==2))./meanc((mstatx[.,1].==1)+(mstatx[.,1].==2));
    
    "Fraction of Initial Single Households that are single men, single women, couples or dead";;
    ageseq2~meanc(frh)~meanc(frw)~meanc(frc)~meanc(frdead);?;

    frdead = (mstatx.==0);
    frh    = (mstatx.==1);
    frw    = (mstatx.==2);
    frc    = (mstatx.==3);
    ageseq2 = ageseqx|(maxc(ageseqx)+agestep);

    "Fraction of Households that are husbands, wives, couples or dead";;
    ageseq2~meanc(frh)~meanc(frw)~meanc(frc)~meanc(frdead);?;

    frh = (mstatx.==1)+(mstatx.==3);   @ ones(_nn,1); @
    frw = (mstatx.==2)+(mstatx.==3);   @ ones(_nn,1); @

    "Distribution of health for men and women that are still alive";
    hsh = {};
    hsw = {};
    iHS = 1; do until iHS>hsNum;
        hsh = hsh~( meanc((hlsimhx.==iHS).*frh)./meanc(frh) );
        hsw = hsw~( meanc((hlsimwx.==iHS).*frw)./meanc(frw) );
    iHS = iHS+1; endo;
    
    "            ";; hslabel2;;
    ageseq2~hsh~hsw;?;

retp; endp;
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(3) = compvinv(optwgts,mmttype,de_mean);

    local mmtmtx, mnvals, totobs, vcv, rn, mcrn, vinv, vdiag, VSdiag, avgvar,
          novar, varnoise, nvind, _W, Wdiag;

    load path =^datapath mmtmtx;
    mnvals  = 0;
    mnvals  = meanc(mmtmtx);      /* This data should already be zero-mean */
    if de_mean==1;
        mmtmtx   = mmtmtx - mnvals';
    endif;

    totobs  = rows(mmtmtx);
    vcv     = mmtmtx'*mmtmtx;
    clear mmtmtx;
    vcv     = vcv/totobs;
    rn      = rows(vcv);

    mcrn     = selif(seqa(1,1,rn),mmttype.==5);

    if sumc(mmttype.==5)>0;                            @ fix moments with 0 variance @
        vdiag    = diag(vcv);
        VSdiag   = vdiag[mcrn];
        avgvar   = meanc(VSdiag);
        novar    = VSdiag.<(avgvar*noisetest);
        if (novar'novar)>0;
            varnoise = (ones(novar'novar,1)*noisewgt*minc(selif(VSdiag,1-novar)));
            nvind    = selif(mcrn,novar);	
            Vdiag[nvind] = varnoise;
            vcv      = diagrv(vcv,Vdiag);
        endif;
    endif;

   @-----Take the principal diagonal and form a diagonal weighting matrix-----@

    vinv    = inv(vcv);  
    vdiag   = diag(vcv);
    save path=^datapath vcv;
    vdiag   = diagrv(eye(rn), vdiag);
    vdiag   = inv(vdiag);

    if optwgts==0;
        _W  = eye(rn);
    elseif optwgts==1;
        _W = vdiag;
    elseif optwgts==2;
        _W = vinv;
    endif;

    if ((optwgts<2) and (xtrasst/=1));
        Wdiag = diag(_W);
        Wdiag = Wdiag + (xtrasst-1).*(mmttype.==1).*Wdiag;
        _W    = diagrv(_W,Wdiag);
    endif;    


    format /ro 12,4;
    "Principal diagonals of V, Vinv (V^{-1}), V_diag^{-1}, and _W = ";;
    seqa(1,1,rn)~diag(vcv)~diag(vinv)~diag(vdiag)~diag(_W);?;

retp(VCV,vinv,_W); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(10) = getWmtx(agedat96, PIdat, asstdat, dasstdat, beqdat, dbasstdat, Sngldat, 
                   aSngldat, Mrrddat, aMrrddat, wdwdat, awdwdat, aobsdat, bobsdat, 
                   daobsdat, dbobsdat, mxdat, mxobsdat, Mcdat, Mcobsdat, hshdat, 
                   hshobsdat, hswdat, hswobsdat, datawgts, optwgts, xtrasst, newnoise, 
                   condat, conobsdat, aMstatdat);

    local NHdat, NHobsdat, cn, aqntdat, aqntcnts, asqntdat, asqntcnts, aisqntdat, 
          aisqntcnts, aihqntdat, aihqntcnts, aiwqntdat, aiwqntcnts, acqntdat, acqntcnts, 
          ainitMrrd, aicqntdat, aicqntcnts, acsqntdat, acsqntcnts, mxqntdat, mxqntcnts, 
          mxmnsdat, mxmnscnts, lmxmnsdat, lmxmnscnts, lmxstddat, mxcrldat1, mxcrlcnt1, 
          mxcrldat2, mxcrlcnt2, MCRmnsdat, MCRmnscnts, MCRcmnsdat, MCRcmnscnts, 
          MCRsmnsdat, MCRsmnscnts, NHmnsdat, NHmnscnts, NHMCRmnsdat, NHMCRmnscnts, 
          NHmxmnsdat, NHmxmnscnts, conqntdat, conqntcnts, mmtvec, obsvec, qntvec, pdfvec, 
          mmttype, VCV, vinv, _W;

    nhdat     = ( (hshdat.==1).*hshobsdat + (hswdat.==1).*hswobsdat ).>0;
    nhobsdat  = (hshobsdat+hswobsdat).>0;
    cn        = cols(hshdat);
    ainitMrrd = aMrrddat[.,1]*ones(1,cn);   

    {aqntdat,aqntcnts} = simqunts(PIdat, agedat96, asstdat, aobsdat,
                                  pistate_a, cohorts_a, quants_a, mmtyrs, 0, 
                                  datawgts);

    {asqntdat,asqntcnts} = simqunts(PIdat, agedat96, asstdat, aobsdat.*aSngldat,
                                    pistate_a, cohorts_a, quants_a, mmtyrs, 0, 
                                    datawgts);

    {aisqntdat,aisqntcnts} = simqunts(PIdat, agedat96, asstdat, aobsdat.*(aSngldat[.,1]*ones(1,cn)),
                                      pistate_a, cohorts_a, quants_a, mmtyrs, 0, 
                                      datawgts);

    {aihqntdat,aihqntcnts} = simqunts(PIdat, agedat96, asstdat, aobsdat.*((aMstatdat[.,1].==1)*ones(1,cn)), @ Initially-single men @
                                      pistate_a, cohorts_a, quants_a, mmtyrs, 0, 
                                      datawgts);

    {aiwqntdat,aiwqntcnts} = simqunts(PIdat, agedat96, asstdat, aobsdat.*((aMstatdat[.,1].==2)*ones(1,cn)), @ Initially-single women @
                                      pistate_a, cohorts_a, quants_a, mmtyrs, 0, 
                                      datawgts);

    {acqntdat,acqntcnts} = simqunts(PIdat, agedat96, asstdat, aobsdat.*aMrrddat,
                                    pistate_a, cohorts_a, quants_a, mmtyrs, 0, 
                                    datawgts);

    {aicqntdat,aicqntcnts} = simqunts(PIdat, agedat96, asstdat, aobsdat.*ainitMrrd,
                                      pistate_a, cohorts_a, quants_a, mmtyrs, 0, 
                                      datawgts);

    {acsqntdat,acsqntcnts} = simqunts(PIdat, agedat96, asstdat, aobsdat.*ainitMrrd.*aSngldat, @ Singles who were initially couples @
                                      pistate_a, cohorts_a, quants_a, mmtyrs, 0, 
                                      datawgts);

    {mxqntdat,mxqntcnts} = simqunts(PIdat, agedat96, mxdat, mxobsdat,
                                    pistate_m, cohorts_m, quants_m, mmtyrs, 0, 
                                    datawgts);

    {mxmnsdat,mxmnscnts} = simqunts(PIdat, agedat96, mxdat, mxobsdat,
                                    pistate_m, cohorts_m, 0, mmtyrs, 0, datawgts);

    {lmxmnsdat, lmxmnscnts, lmxstddat, mxcrldat1, mxcrlcnt1, mxcrldat2, mxcrlcnt2}
                         = simcrrl(PIdat, agedat96, ln(mxdat+(1-mxobsdat)),  
                                   mxobsdat, pistate_m, cohorts_m, mmtyrs, 0, datawgts);
                                   
    {MCRmnsdat,MCRmnscnts} = simqunts(PIdat, agedat96, Mcdat, Mcobsdat,
                                      pistate_mc, cohorts_m, 0, mmtyrs, 0, datawgts);
                                      
    {MCRcmnsdat,MCRcmnscnts} = simqunts(PIdat, agedat96, Mcdat, Mcobsdat.*aMrrddat, @for couples@
                                        pistate_mc, cohorts_m, 0, mmtyrs, 0, datawgts);
                                      
    {MCRsmnsdat,MCRsmnscnts} = simqunts(PIdat, agedat96, Mcdat, Mcobsdat.*aSngldat, @current singles@
                                        pistate_mc, cohorts_m, 0, mmtyrs, 0, datawgts);
    
    savemmts = 1;                                           /* Modify Global */
    {mmtvec,obsvec,qntvec,pdfvec,mmttype} 
        = makemmts(PIdat, agedat[.,1], asstdat, Sngldat, aSngldat, Mrrddat, aMrrddat,
                   wdwdat, awdwdat, aobsdat, bobsdat, daobsdat, dbobsdat, datawgts,
                   asqntdat, acqntdat, mxdat, mxobsdat, mxqntdat, mxmnsdat, lmxmnsdat, 
                   lmxstddat, mxcrldat1, mxcrldat2, Mcdat, Mcobsdat, MCRmnsdat, noisewgt, 
                   newnoise, 1);
    savemmts = 0;
    {VCV,vinv,_W} = compvinv(optwgts,mmttype,1);

  @ Now produce profiles for graphics with 5 distinct PI quintiles  @

    {mxqntdat,mxqntcnts} = simqunts(PIdat, agedat96, mxdat, mxobsdat,
                                    pistate_a, cohorts_a, quants_m, mmtyrs, 0, 
                                    datawgts);

    {mxmnsdat,mxmnscnts} = simqunts(PIdat, agedat96, mxdat, mxobsdat,
                                    pistate_a, cohorts_a, 0, mmtyrs, 0, datawgts);

    {NHmxmnsdat,NHmxmnscnts} = simqunts(PIdat, agedat96, nhdat.*mxdat,  
                                        nhdat.*mxobsdat.*NHobsdat, pistate_a, 
                                        cohorts_a, 0, mmtyrs, 0, datawgts);
                                   
    {MCRmnsdat,MCRmnscnts} = simqunts(PIdat, agedat96, Mcdat, Mcobsdat,
                                      pistate_a, cohorts_a, 0, mmtyrs, 0, datawgts);
                                      
    {MCRcmnsdat,MCRcmnscnts} = simqunts(PIdat, agedat96, Mcdat, Mcobsdat.*aMrrddat, @for couples@
                                          pistate_a, cohorts_a, 0, mmtyrs, 0, datawgts);
                                          
    {MCRsmnsdat,MCRsmnscnts} = simqunts(PIdat, agedat96, Mcdat,  Mcobsdat.*aSngldat, @current singles@
                                          pistate_a, cohorts_a, 0, mmtyrs, 0, datawgts);                                      

    {NHmnsdat,NHmnscnts} = simqunts(PIdat, agedat96, nhdat, NHobsdat,
                                    pistate_a, cohorts_a, 0, mmtyrs, 0, datawgts);
    
    {NHMCRmnsdat,NHMCRmnscnts} = simqunts(PIdat, agedat96, nhdat.*MCdat,  
                                          nhdat.*MCobsdat.*NHobsdat, pistate_a, 
                                          cohorts_a, 0, mmtyrs, 0, datawgts);
    
    {conqntdat,conqntcnts} = simqunts(PIdat, agedat96, condat, conobsdat,
                                      pistate_a, cohorts_a, 0, mmtyrs, 0, 
                                      datawgts);

    ?;"Asset quantiles from Data, All";; print aqntdat;?; 
    ?;"Asset quantiles from Data, Singles";; print asqntdat;?; 
    ?;"Asset quantiles from Data, Initial Singles";; print aisqntdat;?; 
//    ?;"Asset quantiles from Data, Couples";; print acqntdat;?; 
//    ?;"Asset quantiles from Data, Initial Couples";; print aicqntdat;?; 
//    ?;"Asset quantiles from Data, Couples->Singles";; print acsqntdat;?; 
    ?;"Medex quantiles from Data";; print mxqntdat;?; 
    ?;"Medex means from Data";; print mxmnsdat;?;
    ?;"Medex means from Data for NH residents";; print NHmxmnsdat;?; 
    ?;"Medicaid participation rates from data";; print MCRmnsdat;?;
//    ?;"Medicaid participation rates from data, Couples";; print MCRcmnsdat;?;
    ?;"Medicaid participation rates from data, Singles";; print MCRmnsdat;?;
    
    ?;"Nursing home utilization rates from data";; print NHmnsdat;?;
    ?;"Medicaid utilization rates for NH residents";; print NHMCRmnsdat;?;
    ?;"Consumption Expenditures from data";; print conqntdat;?;
    
    ?;"Log Medex means from Data ";; print lmxmnsdat;?; 
    ?;"Log Medex standard deviations from Data";; print lmxstddat;?; 
    ?;"Log Medex 1st autocorrelations from Data";; print mxcrldat1;?; 
    ?;"Log Medex 2nd autocorrelations from Data";; print mxcrldat2;?; 

    grphmtx(aqntdat,1,0,0,qnum_a,pinum_a,chrtnum_a,"");
    grphmtx(asqntdat,1,0,0,qnum_a,pinum_a,chrtnum_a,"_s_");
    grphmtx(aisqntdat,1,0,0,qnum_a,pinum_a,chrtnum_a,"_is_");
    grphmtx(aihqntdat,1,0,0,qnum_a,pinum_a,chrtnum_a,"_ih_");
    grphmtx(aiwqntdat,1,0,0,qnum_a,pinum_a,chrtnum_a,"_iw_");
    grphmtx(acqntdat,1,0,0,qnum_a,pinum_a,chrtnum_a,"_c_");
    grphmtx(aicqntdat,1,0,0,qnum_a,pinum_a,chrtnum_a,"_ic_");
    grphmtx(acsqntdat,1,0,0,qnum_a,pinum_a,chrtnum_a,"_cs_");
    grphmtx(mxqntdat,3,0,0,qnum_m,pinum_a,chrtnum_a,"");
    grphmtx(mxmnsdat,3,0,0,0,pinum_a,chrtnum_a,"");
    grphmtx(NHmxmnsdat,13,0,0,0,pinum_a,chrtnum_a,"");
    grphmtx(MCRmnsdat,20,0,0,0,pinum_a,chrtnum_a,"");
    grphmtx(MCRsmnsdat,20,0,0,0,pinum_a,chrtnum_a,"_s_");
    grphmtx(MCRcmnsdat,20,0,0,0,pinum_a,chrtnum_a,"_c_");
    grphmtx(NHmnsdat,23,0,0,0,pinum_a,chrtnum_a,"");
    grphmtx(NHMCRmnsdat,30,0,0,0,pinum_a,chrtnum_a,"");
    grphmtx(conqntdat,2,0,0,0,pinum_a,chrtnum_a,"");
    
    {aqntdat,aqntcnts} = simqunts(PIdat, agedat96, asstdat, aobsdat,
                                  pistate_a, cohorts_a, quants_a, mmtyrs, 1, 
                                  datawgts);

    {aisqntdat,aisqntcnts} = simqunts(PIdat, agedat96, asstdat, aobsdat.*(aSngldat[.,1]*ones(1,cn)),
                                      pistate_a, cohorts_a, quants_a, mmtyrs, 1, 
                                      datawgts);

    {acqntdat,acqntcnts} = simqunts(PIdat, agedat96, asstdat, aobsdat.*aMrrddat,
                                    pistate_a, cohorts_a, quants_a, mmtyrs, 1, 
                                    datawgts);
                                  
    {mxqntdat,mxqntcnts} = simqunts(PIdat, agedat96, mxdat, mxobsdat,
                                    pistate_a, cohorts_a, quants_m, mmtyrs, 1, 
                                    datawgts);
                                    
    {mxmnsdat,mxmnscnts} = simqunts(PIdat, agedat96, mxdat, mxobsdat,
                                    pistate_a, cohorts_a, 0, mmtyrs, 1, datawgts);
                                    
    {MCRmnsdat,MCRmnscnts} = simqunts(PIdat, agedat96, Mcdat, Mcobsdat,
                                      pistate_a, cohorts_m, 0, mmtyrs, 1, datawgts);

    {NHmnsdat,NHmnscnts} = simqunts(PIdat, agedat96, nhdat, NHobsdat,
                                    pistate_a, cohorts_a, 0, mmtyrs, 1, datawgts);

    grphmtx(aqntdat,1,1,0,qnum_a,pinum_a,chrtnum_a,"");     @ Adjusts for composition bias @
    grphmtx(aisqntdat,1,1,0,qnum_a,pinum_a,chrtnum_a,"_is_");
    grphmtx(acqntdat,1,1,0,qnum_a,pinum_a,chrtnum_a,"_c_"); 
    grphmtx(mxqntdat,3,1,0,qnum_m,pinum_a,chrtnum_a,"");
    grphmtx(mxmnsdat,3,1,0,0,pinum_a,chrtnum_a,"");
    grphmtx(MCRmnsdat,20,1,0,0,pinum_a,chrtnum_a,"");
    grphmtx(NHmnsdat,23,1,0,0,pinum_a,chrtnum_a,"");
    grphmtx(conqntdat,2,1,0,0,pinum_a,chrtnum_a,""); // Can't construct balanced panel for cons
    
retp(VCV,vinv,_W,lmxmnsdat,lmxstddat,mmtvec,obsvec,qntvec,pdfvec,mmttype); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(0) = grphmtx(dataprfs,vartype,comptype,datatype,qnum_j,pinum_j,chrtnum_j,
                  MStype);

    local gmat, cn, iChrt, iPI, iQunt, tempprf, skipem, sk2, _tr2, _tr3, 
          rn, rn2, gotsome, ageseq2, ageseq3, name1, name2, name3, name5, 
          iYear, jYear, fnamestr, skipinit;

    if vartype==1;                                 /* consumption vs. assets */
        name1 = "a";
    elseif vartype==2;
        name1 = "c";
    elseif vartype==3;
        name1 = "m";
    elseif vartype==13;
        name1 = "nhm";
    elseif vartype==20;
        name1 = "fmc";
    elseif vartype==23;
        name1 = "nh";
    elseif vartype==24;
        name1 = "cnr";
    elseif vartype==25;
        name1 = "mnr";
    elseif vartype==30;
        name1 = "nhfmc";
    endif;    

    skipinit = sumc(vartype.==(3|13|20|24|25|30));

    if comptype==0;                        /* All observations vs. survivors */
        name2 = "all";
    elseif comptype==1;
        name2 = "srv";
    endif;    

    if datatype==0;                                  /* Data vs. simulations */
        name3 = "dt";
//        skipinit = 0;
    elseif datatype==1;
        name3 = "sm";        
    endif;

    if qnum_j==0;                                        /* looking at means */
        iQunt=0;
    else;
        iQunt=1;
    endif;

    _tr2 = maxc(avgage96)+simyrs*agestep - bornage;  /* graphs are always annual */
    _tr2 = maxc((_tr*agestep)|_tr2);
    _tr3 = ceil(_tr2/agestep);
    ageseq2 = seqa(bornage,1,_tr2);


    do until iQunt>qnum_j;

        name5 = ftos(iQunt,_z,1,0);
        gmat = ones(_tr2,chrtnum_j*pinum_j)*miss(0,0);
        gmat = ageseq2~gmat;
        gotsome = zeros(_tr2,1);        /* Records ages with observations */
        cn   = 1;

        iChrt=1; do until iChrt>chrtnum_j;
            iPI=1; do until iPI>pinum_j;
                if iQunt==0; /* Means */
                    tempprf = getmatrix(dataprfs,iChrt|iPI|1); /* a row vector */
                else;
                    tempprf = getmatrix(dataprfs,iChrt|iPI|iQunt); /* a row vector */
                endif;

                if skipinit==1;
                    tempprf[1] = mvcode;
                endif;

                skipem  = (tempprf.==mvcode)';
                sk2     = skipem'skipem;

                if sk2>0;
                    if sumc(skipem[mmtyrs-sk2+1:mmtyrs]) /= sk2; @ temporary absences @                         
                       sk2=0; do while sk2<_tr3;
                           if sumc(skipem[mmtyrs-sk2:mmtyrs]) /= (sk2+1); 
                               break; 
                           endif;
                       sk2=sk2+1; endo;
                   endif;
                endif;

                skipem  = sk2;
                cn      = cn+1;
                rn      = mmtcols*agestep  + avgage96[iChrt]-bornage + 1-agestep; @ convert frequencies @
                rn2     = mmtyrs - skipem;

                if rn2>0;
                    rn = rn[1:rn2];
                    rn  = selif(rn,rn.<=_tr2);
                    rn2 = rows(rn);
                    gmat[rn,cn] = tempprf[1:rn2]';
                    gotsome[rn] = ones(rn2,1); 
                endif;

            iPI=iPI+1; endo;
        iChrt=iChrt+1; endo;

        iYear= 1; do until iYear>(_tr2-1);
            if gotsome[iYear]==1;
                jYear=_tr2; do until jYear==iYear;
                    if gotsome[jYear]==1; 
                        gotsome[iYear:jYear]=ones(jYear-iYear+1,1); 
                        jYear=iYear+1;
                    endif;
                jYear=jYear-1; endo;
            iYear=(_tr2-1);
            endif;
        iYear=iYear+1; endo;

        gmat    = selif(gmat,gotsome); /* Drop ages with no observations */
        ageseq3 = selif(ageseq2,gotsome);
        cn = 2; do until cn>cols(gmat);  /* Interpolation for "interior" */
            gmat[.,cn] = fillin(gmat[.,cn],ageseq3);   /* missing values */
        cn=cn+1; endo;
  
        fnamestr = makename(grphpath,name1$+MStype$+name2$+name3,iQunt);
        save ^fnamestr = gmat; 
        if (datatype*basecase) == 1; /* Save for comparison graphs */
            fnamestr = makename(grphpath,name1$+MStype$+name2$+"bn"$+name3,iQunt);
            save ^fnamestr = gmat; 
        endif;

    iQunt=iQunt+1; endo;

retp; endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
grphmtx2:  Set up files for making graphs.  Here we are doing experiments
           where we track a single cohort through time
*/
proc(0) = grphmtx2(dataprfs,vartype,comptype,datatype,qnum_j,pinum_j,MStype);

    local iMStat, MSIndex, tempprf, gmat, cn, iChrt, iPI, iQunt, name1, name2, 
          name3, name4, fnamestr, skipinit;

    if vartype==1;                                 /* consumption vs. assets */
        name1 = "a";
    elseif vartype==2;
        name1 = "c";
    elseif vartype==3;
        name1 = "m";
    elseif vartype==4;
        name1 = "i";
    elseif vartype==5;
        name1 = "oop";
    elseif vartype==6;
        name1 = "mc";
    elseif vartype==7;
        name1 = "tot";
    elseif vartype==8;
        name1 = "isr";
    elseif vartype==9;
        name1 = "om";
    elseif vartype==15;
        name1 = "nhoop";
    elseif vartype==17;
        name1 = "nhomc";
    elseif vartype==20;
        name1 = "fmc";
    elseif vartype==21; 
        name1 = "sf";
    elseif vartype==22; 
        name1 = "q";
    elseif vartype==23;
        name1 = "nh";
    elseif vartype==24;
        name1 = "cnr";
    elseif vartype==25;
        name1 = "mnr";
    elseif vartype==30;
        name1 = "nhfmc";
    endif;

    skipinit = sumc(vartype.==(3|5|6|7|8|9|15|17|20|23|24|25|30));    

    if comptype==0;                        /* All observations vs. survivors */
        name2 = "all";
    elseif comptype==1;
        name2 = "srv";
    endif;    

    if datatype==0;                                  /* Data vs. simulations */
        name3 = "dt";
//        skipinit = 0;
    elseif datatype==1;
        name3 = "sm";        
    endif;

    name4 = "x";

    if qnum_j==0;                                        /* looking at means */
        iQunt=0;
    else;
        iQunt=1;
    endif;

    do until iQunt>qnum_j;

        gmat = ones(_trexpr,pinum_j)*miss(0,0);
        gmat = ageseqx~gmat;

        iPI=1; do until iPI>pinum_j;
            if iQunt==0; /* Means */
                tempprf = getmatrix(dataprfs,1|iPI|1); /* a row vector */
            else;
                tempprf = getmatrix(dataprfs,1|iPI|iQunt); /* a row vector */
            endif;
            if skipinit == 1;
                tempprf[1] = miss(1,1);
            endif;
            gmat[.,iPI+1] = tempprf';
        iPI=iPI+1; endo;
 
        fnamestr =  makename(grphpath,name1$+MStype$+name2$+name3,iQunt)$+name4;
        save ^fnamestr = gmat; 
        if (datatype*basecase) == 1; /* Save for comparison graphs */
            fnamestr = makename(grphpath,name1$+MStype$+name2$+"bn",iQunt)$+name4;
            save ^fnamestr = gmat; 
        endif;

    iQunt=iQunt+1; endo;

retp; endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
proc(1)=fillin(x,ageseq2);

    local i, j, frac, mv, rn;
                                             
    mv = miss(0,0);
    rn = rows(x);
    i=2; do until i>rn;
        if (x[i]==mv)and(x[i-1]/=mv);
            j=i+1; do until j>rn;
                if (x[j]/=mv); break; endif;
            j=j+1; endo;
            if j<=rn;
                frac = (ageseq2[i]-ageseq2[i-1])/(ageseq2[j]-ageseq2[i-1]);
                x[i] = x[i-1] + frac*(x[j]-x[i-1]);
            endif;
        endif;
    i=i+1; endo;

retp(x); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
MAKENAME.G:  Returns a filename string with quantile index
             Note:  We are assuming quantile index is between 1 and 9.
*/
proc(1) = makename(path,rootname,qunum);

    local quantstr,fnamestr;

    quantstr = ftos(qunum,_z,1,0);
    fnamestr = path $+ rootname $+ quantstr;

    retp(fnamestr);
endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
    Tauch:    Converts an AR(1) process into a Markov chain             
              Follows Tauchen (Ec. Letters, 1986)                 
    Inputs:
        stdi:       Scalar, std. dev. of innovation
        rho:        Scalar, AR(1) correlation coefficient
        M:          Scalar indicating number of elements in the chain
        Tail:       Scalar indicating percentages left in each tail
    Output:
        pmtx:       MxM transition matrix
                    rows denote time t values, cols time t+1 values
        values:     Mx1 vector of values
        intvals:    (M-1)x1 vectors of halfway points on values
*/
proc(3) = tauch(stdi,rho,M,utail,ltail);

    local stdy, v_min, v_max, pmtx, values, intvals, ccdfvec, i, j;

    stdy    = sqrt(stdi^2/(1-rho^2));
    v_min   = cdfni(ltail)*stdy;
    v_max   = cdfni(1-utail)*stdy;

    pmtx    = zeros(M,M);
    values  = seqa(v_min,(v_max-v_min)/(M-1),M);
    intvals = (values[1:M-1]+values[2:M])/2; 

    i=1; do until i>m;
        ccdfvec = cdfn((intvals - rho*values[i])/stdi);
        pmtx[i,1] = ccdfvec[1];       @ lower tail @

        j=2; do until j>M-1;
            pmtx[i,j] = ccdfvec[j] - ccdfvec[j-1];
        j=j+1;  endo;

        pmtx[i,m] = 1 - ccdfvec[M-1]; @ upper tail @
    i=i+1; endo;

retp(pmtx,values,intvals); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*
    Taukhuss:   Converts an AR(1) process into a Markov chain             
                Follows Tauchen and Hussey (Econometrica, 1991)                 
    Inputs:
        stdi:       Scalar, std. dev. of innovation
        rho:        Scalar, AR(1) correlation coefficient
        M:          Scalar indicating number of elements in the chain
    Output:
        pmtx:       MxM transition matrix
                    rows denote time t values, cols time t+1 values
        values:     Mx1 vector of values
*/

proc(2) = taukhuss(stdi,rho,m);

    local stdi2, stdy, pmtx, values, quadwgts, yold, ynew, i, j, dev, cpdf;

    stdi2 = sqrt(1-rho^2); @ Innovation variance for normalized process @
    pmtx  = zeros(M,M);
    {values,quadwgts} = ghquad(m,stdi2);

    i=1; do until i>m;
        yold = values[i];
        j=1; do until j>m;
            ynew = values[j];
            dev  = (ynew - rho*yold)/stdi2;
            cpdf = exp(-dev*dev/2.0)/sqrt(2.0*PI*stdi2*stdi2);
            pmtx[i,j] = cpdf*quadwgts[j];
            dev  = ynew/stdi2;
            cpdf = exp(-dev*dev/2.0)/sqrt(2.0*PI*stdi2*stdi2); @ T-H's omega(y) = f(y|0) @
            pmtx[i,j] = pmtx[i,j]/cpdf;
        j=j+1;  endo;
        pmtx[i,.] = pmtx[i,.]/sumc(pmtx[i,.]'); @ Normalize so that probs sum to 1 @
    i=i+1; endo;


    stdy = sqrt(stdi^2/(1-rho^2));
    values = values*stdy;

retp(pmtx,values); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*  
GHQUAD:  Generates weights and nodes for Gauss-Hermite quadrature. 
         Numbers are taken from Judd (1998), p. 262 and Stroud and
         Secrest (1966), pp. 218-219.
*/
proc(2)= ghquad(nodenum,stderr);
    local intmat1,intmat2,intmat3,intmat4,intmat5,intmat6,intmat7,
          intmat8,intmat10,intmat14,posi,revr,revnds,revw,i,nodes,wgts;

    if nodenum <1 or nodenum>8;
        if nodenum ne 10 or nodenum ne 14;
            errorlog("program not configured for order of integration");
        endif;
    endif;

    format /ro 12,8;
    intmat1={0.0           1.772453851};
    intmat2={.7071067811   0.8862269254};
    intmat3={1.224744871   0.2954078751,
             0.0           1.1816359};
    intmat4={1.650680123   0.08131283544,
             0.5246476232  0.804914209};
    intmat5={2.02018287    0.01995624205,
             0.9585724646  0.3936193231,
             0.0           0.9453087204};
    intmat6={0.2350604973e1 0.4530009905e-2,
             0.1335849074e1 0.1570673203,
             0.4360774119   0.7246295952};
    intmat7={2.651961356   0.000971781245,
             1.673551628   0.05451558281,
             0.8162878828  0.4256072526,
             0.0           0.8102646175};
    intmat8={0.2930637420e1 0.1996040722e-3,
             0.1981656756e1 0.1707798300e-1,
             0.1157193712e1 0.2078023258,
             0.3811869902   0.6611470125};

    intmat10={3.436159118  0.000007640432855,
              2.532731674  0.001343645746,
              1.756683649  0.03387439445,
              1.036610829  0.240138611,
              0.3429013272 0.6108626337};

    intmat14={0.4304448570e1  0.8628591168e-8,
              0.3462656934e1  0.4716484355e-5,
              0.2748470725e1  0.3550926136e-3,
              0.2095183259e1  0.7850054726e-2,
              0.1476682731e1  0.6850553422e-1,
              0.8787137873    0.2731056091,
              0.2917455107    0.5364059097};

    if nodenum==1;
        nodes=intmat1[.,1]; wgts=intmat1[.,2];
    elseif nodenum==2;
        nodes=intmat2[.,1]; wgts=intmat2[.,2];
    elseif nodenum==3;
        nodes=intmat3[.,1]; wgts=intmat3[.,2];
    elseif nodenum==4;
        nodes=intmat4[.,1]; wgts=intmat4[.,2];
    elseif nodenum==5;
        nodes=intmat5[.,1]; wgts=intmat5[.,2];
    elseif nodenum==6;
        nodes=intmat6[.,1]; wgts=intmat6[.,2];
    elseif nodenum==7;
        nodes=intmat7[.,1]; wgts=intmat7[.,2];
    elseif nodenum==8;
        nodes=intmat8[.,1]; wgts=intmat8[.,2];
    elseif nodenum==10;
        nodes=intmat10[.,1]; wgts=intmat10[.,2];
    elseif nodenum==14;
        nodes=intmat14[.,1]; wgts=intmat14[.,2];
    endif;

   @-------------------------Expand nodes and weights-------------------------@

    posi=(-1)^nodenum;
    if posi>0;                                 @ Order of integration is even @
        nodes=-nodes|rev(nodes);
        wgts=wgts|rev(wgts);
    elseif nodenum > 1;                         @ Order of integration is Odd @
        revr=(nodenum-1)/2;
        revnds=nodes[1:revr,.];
        revw=wgts[1:revr,.];
      @ "rev(revnds)" rev(revnds); @
        nodes=-nodes|rev(revnds);
        wgts=wgts|rev(revw);
    endif;
    wgts = wgts/sqrt(pi);

   @-------------Now generate nodes for a log-normal distribution-------------@
    nodes=sqrt(2)*stderr*nodes; 
    format /ro 12,4;
    "stderr = " stderr;
    "       nodes        weights " nodes~wgts;?;

retp(nodes,wgts); endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
proc(0) = makeplot(quants_j,pinum_j,chrtnum_j,grphtype,MStype,mortbias,ageRange,
                   ageCshn,valRange);

    local figdim, MSname, typestr, typestr2, titlstr, tinum, PIstr, fs0, iQunt,  
          fnamestr, quntstr, quntstr2, alldat, srvdat, allsim, allboth, allbench, 
          srvsim, cn, rn, chrtcol1, chrtcol2, chrtcol3, yalabel, lthick, lclrs0, 
          lclrs1, lclrs2, iClr,  ltype0, ltype1, ltype2, ltype3, qnum_j, gotdata, 
          cn2;

  /*--------------------------Adjust graph settings--------------------------*/

    plotSetts = plotGetDefaults("xy");
    plotSetLineSymbol(&plotSetts,-ones(pinum_j,1), 1);    
    plotSetAxesPen(&plotSetts, 1, "black");
/*    plotSetXLabel(&plotSetts, "Year", "verdana", 40, "black");
    plotSetXRange(&plotSetts,72,104);     
    plotSetXTicCount(&plotSetts, 5);    
    plotSetYTicCount(&plotSetts, 10); */;
    
     plotSetXLabel(&plotSetts, "Age", "verdana", 20, "black"); 
/*    plotSetXTicCount(&plotSetts, 20);    
    plotSetYTicCount(&plotSetts, 10);
    plotSetTicLabelFont(&plotSetts,"verdana", 16);   */
    plotSetXTicCount(&plotSetts, 8);    
    plotSetYTicCount(&plotSetts, 10);
    plotSetTicLabelFont(&plotSetts,"verdana", 18);
    plotSetXRange(&plotSetts,72,100);   
    plotSetGrid(&plotSetts, "on");

    figdim   = 30|21;

    if grphtype==1; 
        typestr  = "Net Worth";
        typestr2 = "a";
    elseif grphtype==2; 
        typestr  = "Consumption";
        typestr2 = "c";
    elseif grphtype==3; 
        typestr  = "Medex";
        typestr2 = "m";
    elseif grphtype==13; 
        typestr  = "Medex (in NH)";
        typestr2 = "nhm";
    elseif grphtype==20; 
        typestr  = "Medicaid Recipiency";
        typestr2 = "fmc";
    elseif grphtype==21; 
        typestr  = "Survival";
        typestr2 = "sf";
    elseif grphtype==23; 
        typestr  = "Nursing Home Use";
        typestr2 = "nh";
    elseif grphtype==30; 
        typestr  = "Medicaid Use (in NH)";
        typestr2 = "nhfmc";  
    endif;

    if MStype=="";
        MSname   = ", All";
    elseif MStype=="_s_";
        MSname   = ", Singles";
        mortbias = 0;
    elseif MStype=="_is_";
        MSname   = ", Initial Singles";
    elseif MStype=="_ih_";
        MSname   = ", I-Single Men";
    elseif MStype=="_iw_";
        MSname   = ", I-Single Women";
    elseif MStype=="_c_";
        MSname   = ", Couples";
    elseif MStype=="_ic_";
        MSname   = ", Initial Couples";
        mortbias = 0;
    elseif MStype=="_cs_";
        MSname   = ", Ultimate Singles";
        mortbias = 0;
    endif;

    if (grphtype>9)and(grphtype<20);
        mortbias = 0;
    endif;

    typestr2 = typestr2 $+ MStype;
    fs0      = grphpath $+ typestr2;
    titlstr  = ":  ";
    tinum    = 0;
    if pinum_j>1;
        titlstr = "Income"$+titlstr;
        tinum   = 1;
    endif;

    if chrtnum_j>1;
        if tinum==0;
            titlstr = "Cohort"$+titlstr;
        else;
            titlstr = "Cohort and "$+titlstr;
        endif;
        tinum = 1;
    endif;

    if tinum>0;
        titlstr = " by "$+titlstr;
    endif;

    titlstr  = typestr$+titlstr;
    PIstr    = "_"$+ftos(pinum_j,_z,1,0)$+"PI_";

    chrtcol1 = seqa(2,1,pinum_j)|seqa(2*pinum_j+2,1,pinum_j);
    if (pinum_j<3);
         chrtcol1 = chrtcol1|seqa(4*pinum_j+2,1,pinum_j);
    endif;
    chrtcol2 = seqa(pinum_j+2,1,pinum_j)|seqa(3*pinum_j+2,1,pinum_j);
    chrtcol3 = seqa(2,1,chrtnum_j);

    ltype0  = (1|3);
    ltype1  = ltype0.*.ones(pinum_j,1);
    if pinum_j==1;
        ltype2 = ltype0.*.ones(chrtnum_j,1);
    elseif pinum_j<3;  
        ltype2 = ltype0.*.ones(3*pinum_j,1);
    else;
        ltype2 = ltype0.*.ones(2*pinum_j,1);
    endif;
    ltype3  = ltype0.*.ones(2*pinum_j,1);

    lthick  = ones(2*chrtnum_j,1).*.seqa(3,7.5/pinum_j,pinum_j);     @ line widths @
    plotSetLineThickness(&plotSetts, lthick);

    lclrs0   = "green"$|"black"$|"red"$|"blue"$|"purple";
    lclrs1   = {};
    lclrs2   = {};

    if pinum_j==1;
        iClr=1; do until iCLr>3;   
           lclrs1 = lclrs1$|lclrs0[1:chrtnum_j];      @ Common colors for Cohorts @
           lclrs2 = lclrs2$|lclrs0[2|4];      
        iClr=iClr+1; endo;
    else;
        iClr=1; do until iCLr>chrtnum_j;   
           lclrs1 = lclrs1$|lclrs0[1:pinum_j];      @ Common colors for Quantiles @
        iClr=iClr+1; endo;
    endif;

    if grphtype > 19;  
        yalabel = typestr;
    else;	
        yalabel = typestr $+ " (1000s of 2014 dollars)"; 
    endif;
  
    plotSetYLabel(&plotSetts, yalabel, "verdana", 18, "black"); 
    plotSetLineColor(&plotSetts, lclrs1);
 
    if quants_j==0;                                        @ looking at means @
        qnum_j=0;
        iQunt=0;
    else;
        qnum_j=rows(quants_j);
        iQunt=1;
    endif;

    do until iQunt>qnum_j;

        if iQunt==0;
            quntstr = "Mean ";
            quntstr2 = "avg";        
        elseif quants_j[iQunt]==0.5;
            quntstr = "Median ";
            quntstr2 = ftos(50,_z,2,0);
        else;
            quntstr2 = ftos(100*quants_j[iQunt],_z,2,0);
            quntstr  = quntstr2$+"th %tile ";
        endif;

        if grphtype>19;
            quntstr = "";
        endif;            

        plotSetLineStyle(&plotSetts, ltype1);

        fnamestr = makename(grphpath,typestr2$+"alldt",iQunt);
        load alldat = ^fnamestr;

        cn2 = cols(alldat);
        if (pinum_j>3);
           if (chrtnum_j>4);
               cn2 = cn2 - pinum_j; @ drop oldest cohort @
           endif;
        endif;
        
        doplot(alldat[.,1:cn2],ageRange,ageCshn,valRange[iQunt+(iQunt==0),.],
               grphtype,quntstr$+titlstr$+"Data"$+MSname,
               18,fs0$+"data"$+quntstr2$+PIstr$+"1.pdf",figdim);
 
        fnamestr = makename(grphpath,typestr2$+"allsm",iQunt);
        load allsim = ^fnamestr;
        
        doplot(allsim,ageRange,ageCshn,valRange[iQunt+(iQunt==0),.],
               grphtype,quntstr$+titlstr$+"Model"$+MSname,
               18,fs0$+"sim"$+quntstr2$+PIstr$+"1.pdf",figdim);

        if pinum_j>1;
            plotSetLineStyle(&plotSetts, ltype1);
            cn      = chrtcol1;
            doplot(alldat[.,1|cn],ageRange,ageCshn,valRange[iQunt+(iQunt==0),.],
                   grphtype,quntstr$+titlstr$+"Data"$+MSname,
                   18,fs0$+"data"$+quntstr2$+PIstr$+"2.pdf",figdim);
            cn      = chrtcol2;
            doplot(alldat[.,1|cn],ageRange,ageCshn,valRange[iQunt+(iQunt==0),.],
                   grphtype,quntstr$+titlstr$+"Data"$+MSname,
                   18,fs0$+"data"$+quntstr2$+PIstr$+"3.pdf",figdim);
            cn      = chrtcol1;
        else;
            cn = chrtcol3;
        endif;

        plotSetLineStyle(&plotSetts, ltype2);
        rn      = minc(rows(alldat)|rows(allsim));
        gotdata = alldat[1:rn,cn]+0.001;
        gotdata = gotdata./gotdata;
        allboth = alldat[1:rn,1|cn]~(allsim[1:rn,cn].*gotdata);
        
        doplot(allboth,ageRange,ageCshn,valRange[iQunt+(iQunt==0),.],grphtype,
               quntstr$+typestr$+":  Data (Solid) vs. Model (Dashed)"$+MSname,
               18,fs0$+"both"$+quntstr2$+PIstr$+"2.pdf",figdim);

        if pinum_j>1;
            cn      = chrtcol2;
            plotSetLineStyle(&plotSetts, ltype3);
            gotdata = alldat[1:rn,cn]+0.001;
            gotdata = gotdata./gotdata;
            allboth = alldat[1:rn,1|cn]~(allsim[1:rn,cn].*gotdata);
            doplot(allboth,ageRange,ageCshn,valRange[iQunt+(iQunt==0),.],grphtype,
                   quntstr$+typestr$+":  Data (Solid) vs. Model (Dashed)"$+MSname,
                   18,fs0$+"both"$+quntstr2$+PIstr$+"3.pdf",figdim);
        endif;

        if basecase==0;
            fnamestr = makename(grphpath,typestr2$+"allbn",iQunt);
            load allbench = ^fnamestr;
            if pinum_j==1;
                cn   = chrtcol3;
            else;
                cn   = chrtcol1;
            endif;
            plotSetLineStyle(&plotSetts, ltype1);
            rn       = minc(rows(allsim)|rows(allbench));
            allboth = allsim[1:rn,1|cn]~allbench[1:rn,cn];
            doplot(allboth,ageRange,ageCshn,valRange[iQunt+(iQunt==0),.],grphtype,
                   quntstr$+typestr$+":  Experiment (Solid) vs. Baseline (Dashed)"$+MSname,
                   18,fs0$+"comp"$+quntstr2$+PIstr$+"2.pdf",figdim);
        endif;

        if pinum_j==1;
            cn      = 2|4;                                @ drop oldest cohort @
            plotSetLineColor(&plotSetts, lclrs2);
            plotSetLineStyle(&plotSetts, ltype0.*.ones(2,1));

        else;
            cn      = chrtcol1;
            plotSetLineStyle(&plotSetts, ltype2);
        endif;
               
        if mortbias==1;  

          @ Document mortality bias                                                        @
          @ For current singles, this makes no sense, as they may become singles midstream @
            cn=2|3|4;
            plotSetLineStyle(&plotSetts, ltype0.*.ones(pinum_j,1)); 

            fnamestr = makename(grphpath,typestr2$+"srvdt",iQunt);
            load srvdat = ^fnamestr;      
            rn       = minc(rows(alldat)|rows(srvdat));
          @ rn=19; @
            allboth  = alldat[1:rn,1|cn]~srvdat[1:rn,cn];
            doplot(allboth,ageRange,ageCshn,valRange[iQunt+(iQunt==0),.],grphtype,
                   quntstr$+typestr$+":  Everyone in Data (Solid) vs. Survivors (Dashed)"$+MSname, 
                   18,fs0$+"data"$+quntstr2$+PIstr$+"4.pdf",figdim);
       
            fnamestr = makename(grphpath,typestr2$+"srvsm",iQunt);
            load srvsim = ^fnamestr;
            rn       = minc(rows(allsim)|rows(srvsim));
          @ rn=19;@
            allboth  = allsim[1:rn,1|cn]~srvsim[1:rn,cn];
            doplot(allboth,ageRange,ageCshn,valRange[iQunt+(iQunt==0),.],grphtype,
                   quntstr$+typestr$+":  Everyone in Sims (Solid) vs. Survivors (Dashed)"$+MSname, 
                   18,fs0$+"sim"$+quntstr2$+PIstr$+"4.pdf",figdim);

        endif;

    iQunt=iQunt+1; endo;

retp; endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
proc(0) = makeNHplot(quants_n,pinum_n,chrtnum_n,grphtype,MStype,ageRange,ageCshn,
                     valRange);

    local figdim, fnamestr, y, OKvals, gotdata, iQunt, quntstr, quntstr2, typestr, 
          typestr2, MSname, titlstr, tinum, PIstr, fs0, chrtcol1, chrtcol2, yalabel,  
          lsymb0, lsymb1, lthick, lclrs0, lclrs1, lclrs2, iClr, ltype0, ltype1, 
          alldat, allsim, allboth, cn, rn,  qnum_n, cn2;

  /*--------------------------Adjust graph settings--------------------------*/

    plotSetts = plotGetDefaults("xy");
    plotSetLineSymbol(&plotSetts,-ones(pinum_n,1), 1);    
    plotSetAxesPen(&plotSetts, 1, "black");
    plotSetXLabel(&plotSetts, "Age", "verdana", 18, "black");
    plotSetXRange(&plotSetts,72,104);     
    plotSetXTicCount(&plotSetts, 20);    
    plotSetYTicCount(&plotSetts, 10); 
    figdim = 30|21;  


  @ Make sure all graphs show only cells with enough nursing home residents   @
  @ First, load up nhm data. Give any crazy data observation the missing      @
  @ value indicator                                                           @

    if grphtype<20;
        fnamestr = makename(grphpath,"nhm"$+MStype$+"alldt",0);
    else;
        fnamestr = makename(grphpath,"nhfmc"$+MStype$+"alldt",0);
    endif;
    load alldat = ^fnamestr;

  @ Make sure all graphs show only cells with enough Nursing home residents @    
    cn2 = cols(alldat);
    if (pinum_n>3);
        if (chrtnum_n>4);
            cn2 = cn2 - pinum_n; @ drop oldest cohort @
        endif;
    endif;
 
    y       = alldat[.,2:cn2];
    OKvals  = (y.>-1);
    y       = y.*miss(OKvals,0);
    alldat  = alldat[.,1]~y;
    gotdata = alldat+0.001;
    gotdata = gotdata./gotdata; 
    
    if grphtype==3; 
        typestr  = "OOP Medex";
        typestr2 = "m";
    elseif grphtype==13; 
        typestr  = "OOP Medex (in NH)";
        typestr2 = "nhm";
    elseif grphtype==20; 
        typestr  = "Medicaid Recipiency";
        typestr2 = "fmc";
    elseif grphtype==30; 
        typestr  = "Medicaid Use (in NH)";
        typestr2 = "nhfmc"; 
    endif;

    if MStype=="";
        MSname  = ", All";
    elseif MStype=="_s_";
        MSname  = ", Singles";
    elseif MStype=="_is_";
        MSname  = ", Initial Singles";
    elseif MStype=="_ih_";
        MSname  = ", I-Single Men";
    elseif MStype=="_iw_";
        MSname  = ", I-Single Women";
    elseif MStype=="_c_";
        MSname  = ", Couples";
    elseif MStype=="_ic_";
        MSname  = ", Initial Couples";
    elseif MStype=="_cs_";
        MSname  = ", Ultimate Singles";
    endif;

    typestr2 = typestr2 $+ MStype;
    fs0      = grphpath $+ typestr2;
    titlstr = ":  ";
    tinum   = 0;
    if pinum_n>1;
        titlstr = "Income"$+titlstr;
        tinum   = 1;
    endif;

    if chrtnum_n>1;
        if tinum==0;
            titlstr = "Cohort"$+titlstr;
        else;
            titlstr = "Cohort and "$+titlstr;
        endif;
        tinum = 1;
    endif;

    if tinum>0;
        titlstr = " by "$+titlstr;
    endif;

    titlstr  = typestr$+titlstr;
    PIstr    = "_"$+ftos(pinum_n,_z,1,0)$+"PI_";

    chrtcol1 = seqa(2,1,pinum_n)|seqa(2*pinum_n+2,1,pinum_n);
    if (pinum_n<3);
         chrtcol1 = chrtcol1|seqa(4*pinum_n+2,1,pinum_n);
    endif;
    chrtcol2 = seqa(pinum_n+2,1,pinum_n)|seqa(3*pinum_n+2,1,pinum_n);

    lsymb0  = 0|1|5|8|2|9;
    ltype0  = (1|3);
    ltype1  = ltype0.*.ones(pinum_n,1);
    lthick  = ones(2*chrtnum_n,1).*.seqa(3,7.5/pinum_n,pinum_n);     @ line widths @
    lclrs0   = "green"$|"black"$|"red"$|"blue"$|"purple";
    lclrs1   = {};

    if pinum_n==1;
        lsymb1 = ones(3,1).*.lsymb0[1:chrtnum_n];    @ Common symbols for Cohorts @
        iClr=1; do until iCLr>3;  
           lclrs1 = lclrs1$|lclrs0[1:chrtnum_n];      @ Common colors for Cohorts @
           lclrs2 = lclrs2$|lclrs0[2|4];      
        iClr=iClr+1; endo;
    else;
        lsymb1 = ones(chrtnum_n,1).*.lsymb0[1:pinum_n]; @ Common symbols for Quantiles @
        iClr=1; do until iCLr>chrtnum_n;   
           lclrs1 = lclrs1$|lclrs0[1:pinum_n];           @ Common colors for Quantiles @
        iClr=iClr+1; endo;
    endif;

    if grphtype > 19;  
        yalabel = typestr;
    else;	
        yalabel = typestr $+ " (1000s of 2014 dollars)"; 
    endif;
  
    plotSetYLabel(&plotSetts, yalabel, "verdana", 18, "black"); 
    plotSetLineColor(&plotSetts, lclrs1);
    plotSetLineSymbol(&plotSetts, lsymb1, 14);
    plotSetLineThickness(&plotSetts, lthick);
    plotSetLineStyle(&plotSetts, ltype1);
    
    if quants_n==0;                                        @ looking at means @
        qnum_n=0;
        iQunt=0;
    else;
        qnum_n=rows(quants_n);
        iQunt=1;
    endif;

    do until iQunt>qnum_n;

        if iQunt==0;
            quntstr = "Mean ";
            quntstr2 = "avg";        
        elseif quants_n[iQunt]==0.5;
            quntstr = "Median ";
            quntstr2 = ftos(50,_z,2,0);
        else;
            quntstr2 = ftos(100*quants_n[iQunt],_z,2,0);
            quntstr  = quntstr2$+"th %tile ";
        endif;

        if grphtype > 19;
            quntstr = "";
        endif;            

        _ptitlht = 0.18;

        fnamestr = makename(grphpath,typestr2$+"alldt",iQunt);
        load alldat = ^fnamestr;
//      fnamestr = makename(grphpath,typestr2$+"allsm",iQunt);
//      load allsim = ^fnamestr;        

        rn      = minc(rows(gotdata)|rows(alldat));//|rows(allsim));
        alldat  = alldat[1:rn,1:cn2].*gotdata[1:rn,.];
//      allsim  = allsim[1:rn,1:cn2].*gotdata[1:rn,.];
        
        doplot(alldat,ageRange,ageCshn,valRange[iQunt+(iQunt==0),.],
               grphtype,quntstr$+titlstr$+"Data",
               18,fs0$+"data"$+quntstr2$+PIstr$+"1n.pdf",figdim);
        
//      doplot(allsim,ageRange,ageCshn,valRange[iQnt+(iQunt==0),.],
//             grphtype,quntstr$+titlstr$+"Model",
//             18,fs0$+"sim"$+quntstr2$+PIstr$+"1n.pdf",figdim);

        if pinum_n>1;
            cn      = chrtcol1;
            doplot(alldat[.,1|cn],ageRange,ageCshn,valRange[iQunt+(iQunt==0),.],
                   grphtype,quntstr$+titlstr$+"Data"$+MsName,
                   18,fs0$+"data"$+quntstr2$+PIstr$+"2n.pdf",figdim);
//          doplot(allsim[.,1|cn],ageRange,ageCshn,valRange[iQunt+(iQunt==0),.],
//                 grphtype,quntstr$+titlstr$+"Model",
//                 20,fs0$+"sim"$+quntstr2$+PIstr$+"2n.pdf",figdim);                   
            cn      = chrtcol2;
            doplot(alldat[.,1|cn],ageRange,ageCshn,valRange[iQunt+(iQunt==0),.],
                   grphtype,quntstr$+titlstr$+"Data"$+MsName,
                   18,fs0$+"data"$+quntstr2$+PIstr$+"3n.pdf",figdim);
//          doplot(allsim[.,1|cn],ageRange,ageCshn,valRange[iQunt+(iQunt==0),.],
//                 grphtype,quntstr$+titlstr$+"Model"$+MsName,
//                 20,fs0$+"sim"$+quntstr2$+PIstr$+"3n.pdf",figdim);                                      
        endif;

    iQunt=iQunt+1; endo;

retp; endp;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

proc(0) = makeplotx(quants_j,pinum_j,grphtype,MStype,mortbias,ageRange,ageCshn,
                    valRange);

    local figdim, label0, lgndlbl, lgndlbl2, lgndlct, typestr, typestr2, MSname,
          titlstr, PIstr, yalabel, fs0, fs1, tstep, lthick, lsymb1, lsymb2, lclrs, 
          ltype0, ltype1, ltype2, ltype3, iQunt, quntstr, quntstr2, fnamestr, 
          allsim, srvsim, allbench, allboth, cn0, cn, rn, qnum_j, rn2;
  
  /*--------------------------Adjust graph settings--------------------------*/
    plotSetts = plotGetDefaults("xy");
    plotSetLineSymbol(&plotSetts,-ones(pinum_j,1), 1);    
    plotSetAxesPen(&plotSetts, 1, "black");
/*  plotSetXLabel(&plotSetts, "Year", "verdana", 40, "black");
    plotSetXRange(&plotSetts,72,104);     
    plotSetXTicCount(&plotSetts, 5);    
    plotSetYTicCount(&plotSetts, 10); */;
    
    plotSetXLabel(&plotSetts, "Age", "verdana", 20, "black"); 
/*  plotSetXTicCount(&plotSetts, 20);    
    plotSetYTicCount(&plotSetts, 10);
    plotSetTicLabelFont(&plotSetts,"verdana", 16);   */
    plotSetXTicCount(&plotSetts, 8);    
    plotSetYTicCount(&plotSetts, 10);
    plotSetTicLabelFont(&plotSetts,"verdana", 18);
    plotSetXRange(&plotSetts,72,100);        
    plotSetGrid(&plotSetts, "on");

    figdim = 30|21;

    if pinum_j==0;
        label0 = "All";
    elseif pinum_j==3;
        label0  = "top PI"$|"middle PI"$|"bottom PI";
    elseif pinum_j==5;
        label0  = "top"$|"second"$|"third"$|"fourth"$|"bottom";
    endif;
   
    lgndlbl  = label0; //"top"$|"second"$|"third"$|"bottom two";
    lgndlbl2 = label0; //"top two"$|"second"$|"third"$|"fourth"$|"bottom";
    lgndlct = "top left inside";

    if grphtype==1; 
        typestr  = "Net Worth";
        typestr2 = "a";
        lgndlbl  = label0;
        lgndlct  = "top right inside";
    elseif grphtype==2; 
        typestr  = "Consumption";
        typestr2 = "c";
        lgndlbl  = label0;
        lgndlct  = "top right inside";
    elseif grphtype==3; 
        typestr  = "Medical Expenses";
        typestr2 = "m";
    elseif grphtype==4; 
        typestr  = "Income";
        typestr2 = "i";
        lgndlbl  = label0;
    elseif grphtype==5; 
        typestr  = "OOP Medex";
        typestr2 = "oop";
    elseif grphtype==6; 
        typestr  = "Medicaid";
        typestr2 = "mc";
    elseif grphtype==7; 
        typestr  = "Total Medex";
        typestr2 = "tot";
    elseif grphtype==8; 
        typestr  = "Insurer Expenses";
        typestr2 = "isr";
    elseif grphtype==9; 
        typestr  = "OOP + Medicaid";
        typestr2 = "om";
    elseif grphtype==13; 
        typestr  = "Medical Expenses (in NH)";
        typestr2 = "nhm";
    elseif grphtype==15; 
        typestr  = "OOP Medex (in NH)";
        typestr2 = "nhoop";
    elseif grphtype==17; 
        typestr  = "OOP + MCaid (in NH)";
        typestr2 = "nhomc";
    elseif grphtype==20; 
        typestr  = "Medicaid Recipiency";
        typestr2 = "fmc";
        lgndlbl  =  lgndlbl2;
    elseif grphtype==21; 
        typestr  = "Survival";
        typestr2 = "sf";
        _plegstr = label0;
        lgndlct  = "top right inside";
    elseif grphtype==22; 
        typestr  = "Co-payment Rates";
        typestr2 = "q";
    elseif grphtype==23; 
        typestr  = "Nursing Home Use";
        typestr2 = "nh";
        _plegstr = label0;
    elseif grphtype==24; 
        typestr  = "Cat. Needy Receipt";
        typestr2 = "cnr";
        lgndlbl  =  lgndlbl2;
     elseif grphtype==25; 
        typestr  = "Med. Needy Receipt";
        typestr2 = "mnr";
        lgndlbl  = lgndlbl2;
    elseif grphtype==30; 
        typestr  = "Medicaid Use (in NH)";
        typestr2 = "nhfmc";
        lgndlbl  = lgndlbl2;    
    endif;

    if MStype=="";
        MSname  = ", All";
    elseif MStype=="_s_";
        MSname   = ", Singles";
        mortbias = 0;
    elseif MStype=="_is_";
        MSname   = ", Initial Singles";
    elseif MStype=="_ih_";
        MSname   = ", I-Single Men";
    elseif MStype=="_iw_";
        MSname   = ", I-Single Women";
    elseif MStype=="_c_";
        MSname   = ", Couples";
    elseif MStype=="_ic_";
        MSname   = ", Initial Couples";
        mortbias = 0;
    elseif MStype=="_cs_";
        MSname   = ", Ultimate Singles";
        mortbias = 0;
    endif;

    typestr2 = typestr2 $+ MStype;
    fs0      = grphpath $+ typestr2;

    titlstr = "";
    if pinum_j>1;
        titlstr = " by Income Tercile";
    endif;

    titlstr  = typestr$+titlstr;
    PIstr    = "_"$+ftos(pinum_j,_z,1,0)$+"PI_x";
    fs0      = grphpath $+typestr2;
    fs1      = ":  Model";

    lsymb1  = -ones(pinum_j,1); @ -1|-1|8|0|5 @
    lsymb2  = (0|-1).*.ones(pinum_j,1); 
    ltype0  = (1|3);
  
    
    ltype1  = ltype0.*.ones(pinum_j,1);
    ltype2  = rev(ltype0).*.ones(pinum_j,1);
    
        @Rory added below to fix simulated oop graphs@
    if grphtype==5; 
    ltype0  = (1|2|4);
    ltype1  =ltype0;
    elseif grphtype==9; 
    ltype0  = (1|2|4);
    ltype1  =ltype0;
    endif;     

  
    tstep   = 7.5/pinum_j;
    lthick  = ones(2,1).*.seqa(3+(pinum_j-1)*tstep,-tstep,pinum_j);     @ line widths @
    lclrs   = "green"$|"black"$|"red"$|"blue"$|"purple";
    lclrs   = rev(lclrs[1:pinum_j]);
    lclrs   = lclrs$|lclrs;

    if grphtype > 19;  
        yalabel = typestr;
    else;	
        yalabel = typestr $+ " (1000s of 2014 dollars)"; 
    endif;
  
    plotSetYLabel(&plotSetts, yalabel, "verdana", 18, "black");
    plotSetLegendFont(&plotSetts,"verdana", 18, "black");
    plotSetLineColor(&plotSetts, lclrs);
    plotSetLineThickness(&plotSetts, lthick);
 
    if quants_j==0;                                         @ looking at means @
        qnum_j=0;
        iQunt=0;
    else;
        qnum_j=rows(quants_j);
        iQunt=1;
    endif;

    do until iQunt>qnum_j;

        plotSetLegend(&plotSetts,lgndlbl,lgndlct,1);
        plotSetLineStyle(&plotSetts, ltype1);
        plotSetLineSymbol(&plotSetts, lsymb1);
        plotSetLegend(&plotSetts,lgndlbl,lgndlct,1);
        
        if iQunt==0;
            quntstr = "Mean ";
            quntstr2 = "avg";
            
           
            
        elseif quants_j[iQunt]==0.5;
            quntstr = "Median ";
            quntstr2 = ftos(50,_z,2,0);
        else;
            quntstr2 = ftos(100*quants_j[iQunt],_z,2,0);
            quntstr  = quntstr2$+"th Percentile ";
        endif;
        
        if grphtype>19;
            quntstr = "";
            quntstr2 = "avg";        
        endif;            
               
        fnamestr = makename(grphpath,typestr2$+"allsm",iQunt) $+ "x";
        load allsim = ^fnamestr;
        _ptitlht = 0.18;
        
        rn2 = 1 + (grphtype==3)*(agestep==1);  @ Initial entry in 2-year medex average discarded @
        rn  = rows(allsim);
        cn0 = seqa(2,1,cols(allsim)-1);
        cn0 = rev(cn0);                                @ reverse column order @
        cn  = 1|cn0;
                       
        doplot(allsim[rn2:rn,cn],ageRange,ageCshn,valRange[iQunt+(iQunt==0),.],
               grphtype,quntstr$+titlstr$+fs1$+MSname,
               18,fs0$+"sim"$+quntstr2$+PIstr$+"1.pdf",figdim);

        plotSetLegend(&plotSetts, "off");  
        plotSetLineStyle(&plotSetts, ltype2);
        plotSetLineSymbol(&plotSetts, lsymb1);

        if mortbias==1;
            fnamestr = makename(grphpath,typestr2$+"srvsm",iQunt)$+ "x";
            load srvsim = ^fnamestr;
            rn       = minc(rows(allsim)|rows(srvsim));
            allboth  = allsim[1:rn,cn]~srvsim[1:rn,cn0];

            doplot(allboth[rn2:rn,.],ageRange,ageCshn,valRange[iQunt+(iQunt==0),.],grphtype,
                   quntstr$+typestr$+":  Everyone in Sims (Solid) vs. Survivors (Dashed)"$+MsName,
                   16, fs0$+"sim"$+quntstr2$+PIstr$+"4.pdf",figdim);
        endif;

        if (basecase==0);
            fnamestr = makename(grphpath,typestr2$+"allbn",iQunt)$+ "x";
            load allbench = ^fnamestr;
            rn       = minc(rows(allsim)|rows(allbench));
            allboth  = allsim[1:rn,cn]~allbench[1:rn,cn0];
            doplot(allboth[rn2:rn,.],ageRange,ageCshn,valRange[iQunt+(iQunt==0),.],grphtype,
                   quntstr$+typestr$+":  Experiment (Dashed) vs. Baseline (Solid)"$+MsName,
                   18,fs0$+"comp"$+quntstr2$+PIstr$+"2.pdf",figdim);
        endif;

    iQunt=iQunt+1; endo;

retp; endp;

@-----------------------------------------------------------------------------@
@-----------------------------------------------------------------------------@ 

proc(0) = doplot(dat, ageRange, ageCshn, valRange, grphtype, figtitle, titlehgt, 
                 figname, figdim);

    local x, y, OKvals, maxAge, goodAges;

    figtitle;;
    dat;?;
    x     = dat[.,1];
    y     = dat[.,2:cols(dat)];

    if grphtype < 20;
        y = y/1000;
    endif;
    if grphtype <20;
        OKvals = (y.>-1e6);
    else;
        OKvals = (y.>-1);
    endif;
    y = y.*miss(OKvals,0);
    
    if(ageRange[2]-ageRange[1])>0;
        plotSetXRange(&plotSetts, ageRange[1], ageRange[2]);
        if ageCshn>0;
            maxAge   = ageRange[2]-ageCshn;
            goodAges = x.<=maxAge;
            y = y.*miss(goodAges,0);
        endif;
    endif;

    if(valRange[2]-valRange[1])>0;
        plotSetYRange(&plotSetts, valRange[1], valRange[2]);
    endif;


    plotSetTitle(&plotSetts, figtitle, "verdana", titlehgt); // Appears that this must be a global

    plotXY(plotSetts, x, y);
    plotSave(figname, figdim);

retp; endp;
