#delimit ; 
clear all; 
set mem 300m;	
set more 1 ;  
drop _all;
program drop _all;
capture log close;
set excelxlsxlargefile on;

local HRStrim=2791889 ;
local dieage_final=90;
			
local rootpath "C:\Dropbox\ERIC_couples\NewPC\Exported Sim data";
*local rootpath T:\temp;

local HRSTrim=1;
*local titlefig onebeq;
local titlefig 230117;
if `HRSTrim'==1 {;

local savname HRSTrim;
};
else if `HRSTrim'==2 {;

local savname AltTrim;
};
else{;
local savname Simtrim;
};
local savname `savname'_`titlefig';

*log using "`rootpath'\assetprofsim`savname'.log", replace; 

import excel "`rootpath'\wlthmatSIM_`titlefig'.xls", sheet("Sheet1") firstrow;
save "`rootpath'\temp.dta", replace;
use "`rootpath'\temp.dta", clear;

gen HHID=_n;

reshape long assets manheal womanheal hhstatus beq OOP Medicaid consumption xi zeta, i(HHID) j(wave);
drop if wave==13;
gen age=(wave-3)*2+age96;
drop age96;

*Now need to construct dead households properly.;
*Recall using GAUSS hhstatus indexing conventions;
*replace age=. if hhstatus==0;

replace manheal=. if hhstatus==0;
replace womanheal=. if hhstatus==0;
*replace assets=. if hhstatus==0;


sort HHID wave;

gen hhdead=(hhstatus==0);

*C outputs to seperate file for new dead;
replace assets=beq if (hhdead==1 & hhdead[_n-1]==0);

*singles are all those who have hhstatus==1 or 2. Couples have 3;	

gen single_died=(hhstatus==0 & (hhstatus[_n-1]==1|hhstatus[_n-1]==2));
gen couple_died=(hhstatus==0 & hhstatus[_n-1]==3);


gen single_diedPI=single_died*pi_perc;
gen couple_diedPI=couple_died*pi_perc;

*generate single man and woman---using GAUSS CONSISTENT DATA GENERATION;
gen single_m=(hhstatus==1);
gen single_w=(hhstatus==2);

gen single_mPI=single_m*pi_perc;
gen single_wPI=single_w*pi_perc;

*Finally generate some more regressors;
gen hhage=age;
gen hhage2=age^2;
gen hhage3=age^3;


gen pi_perc2=pi_perc^2;
gen pi_perc3=pi_perc^3;
gen pi_perc4=pi_perc^4;
gen pi_perc5=pi_perc^5;

gen single_diedPI2=single_died*pi_perc2;
gen couple_diedPI2=couple_died*pi_perc2;


*gen mandied=((hhstatus[_n-1]==3 & hhstatus==2)|(hhstatus[_n-1]==1 & hhstatus==0)|(hhstatus[_n-1]==3 & hhstatus==0));
*gen womandied=((hhstatus[_n-1]==3 & hhstatus==1)|(hhstatus[_n-1]==2 & hhstatus==0)|(hhstatus[_n-1]==3 & hhstatus==0));
gen mandied=((hhstatus[_n-1]==3 & hhstatus==2 &hhstatus[_n-1]!=. & HHID[_n-1]==HHID)|(hhstatus[_n-1]==1 & hhstatus==0 &hhstatus[_n-1]!=. & HHID[_n-1]==HHID)|(hhstatus[_n-1]==3 & hhstatus==0 &hhstatus[_n-1]!=. & HHID[_n-1]==HHID));
gen womandied=((hhstatus[_n-1]==3 & hhstatus==1 &hhstatus[_n-1]!=. & HHID[_n-1]==HHID)|(hhstatus[_n-1]==2 & hhstatus==0 &hhstatus[_n-1]!=. & HHID[_n-1]==HHID)|(hhstatus[_n-1]==3 & hhstatus==0 &hhstatus[_n-1]!=. & HHID[_n-1]==HHID));


egen maxhhstatus=max(hhstatus), by(HHID);
gen mandead=((maxhhstatus==3 & hhstatus==2)|(maxhhstatus==1 & hhstatus==0)|(maxhhstatus==3 & hhstatus==0));
gen womandead=((maxhhstatus==3 & hhstatus==1)|(maxhhstatus==2 & hhstatus==0)|(maxhhstatus==3 & hhstatus==0));
replace mandead=1 if ((hhstatus==. &  mandead[_n-1]==1 & HHID[_n-1]==HHID)|(hhstatus==. &  mandead[_n-2]==1 & HHID[_n-2]==HHID)|(hhstatus==. &  mandead[_n-3]==1 & HHID[_n-3]==HHID)|(hhstatus==. &  mandead[_n-4]==1 & HHID[_n-4]==HHID)|(hhstatus==. &  mandead[_n-5]==1 & HHID[_n-5]==HHID)|(hhstatus==. &  mandead[_n-6]==1 & HHID[_n-6]==HHID)|(hhstatus==. &  mandead[_n-7]==1 & HHID[_n-7]==HHID)|(hhstatus==. &  mandead[_n-8]==1 & HHID[_n-8]==HHID)|(hhstatus==. &  mandead[_n-9]==1 & HHID[_n-9]==HHID)|(hhstatus==. &  mandead[_n-10]==1 & HHID[_n-10]==HHID));
replace womandead=1 if ((hhstatus==. &  womandead[_n-1]==1 & HHID[_n-1]==HHID)|(hhstatus==. &  womandead[_n-2]==1 & HHID[_n-2]==HHID)|(hhstatus==. &  womandead[_n-3]==1 & HHID[_n-3]==HHID)|(hhstatus==. &  womandead[_n-4]==1 & HHID[_n-4]==HHID)|(hhstatus==. &  womandead[_n-5]==1 & HHID[_n-5]==HHID)|(hhstatus==. &  womandead[_n-6]==1 & HHID[_n-6]==HHID)|(hhstatus==. &  womandead[_n-7]==1 & HHID[_n-7]==HHID)|(hhstatus==. &  womandead[_n-8]==1 & HHID[_n-8]==HHID)|(hhstatus==. &  womandead[_n-9]==1 & HHID[_n-9]==HHID)|(hhstatus==. &  womandead[_n-10]==1 & HHID[_n-10]==HHID));

drop HHID;

rename HHIDsim HHID;

sum assets, det;
*make dead households consistent with the HRS;
replace assets=. if assets==-100000;
drop if assets==.;

*make dead households consistent with the HRS;
replace Medicaid=. if Medicaid==-100000;
drop if Medicaid==.;

*make dead households consistent with the HRS;
replace OOP=. if OOP==-100000;
drop if OOP==.;

*make dead households consistent with the HRS;
replace consumption=. if consumption==-100000;
*drop if consumption==.; *Don't want to drop them because that drops final period;

foreach x in manheal womanheal hhstatus hhdead single_died couple_died single_m single_w mandied womandied mandead womandead{;
egen mode_temp=mode(`x'), by(wave HHID) max;
gen impute_`x'_tmp=(mode_temp!=`x');
egen impute_`x'=max(impute_`x'_tmp), by(wave HHID);
replace `x'=mode_temp;
drop mode_temp impute_`x'_tmp;
};


local vars_list impute_manheal;


foreach x in  womanheal hhstatus hhdead single_died couple_died single_m single_w mandied womandied mandead womandead{;
local vars_list `vars_list' impute_`x';
};
egen demog_impute=rowmax(`vars_list');
tab zeta;

*drop if zeta==6;
*drop if xi==6;
*drop if zeta==5;
*drop if xi==5;
*note: warnings are from all missing values, I believe;
keep assets manheal womanheal hhstatus pi_perc beq age hhdead single_died couple_died single_m single_w mandied womandied HHID wave Medicaid consumption OOP demog_impute mandead womandead;

collapse assets manheal womanheal hhstatus pi_perc beq age hhdead single_died couple_died single_m single_w mandied womandied mandead womandead Medicaid consumption OOP demog_impute, by(HHID wave);
gen medex=OOP+Medicaid;

xtset HHID wave;

//Note in principle could drop in the same way as in HRS using that trim;
sum assets, det;

if `HRSTrim'==1 {;
* removed to line up with data equivalent;
*replace assets=. if assets>`HRStrim';
*don't drop anyone and use the drop in Rachel's matching.;
};
else if `HRSTrim'==2 {;

replace assets=. if assets>=3000000;
};

else{;
replace assets=. if assets>r(p99);

};

*Now have the correct data points;
fillin HHID wave;

*Create the amothers variable, will clean out later for consistency with how we define transfers to other heirs;
gen amothers=beq;

save "`rootpath'\`savname'.dta", replace;

use "`rootpath'\tmp3_rr_match_died_after_3_or_4_or_5_waves_tighter_assets_correct_topcoding_02042020.dta", clear;
				
keep HHID wave HHIDdon;
sort HHID wave;
save "`rootpath'\match.dta", replace;

use "`rootpath'\`savname'.dta", clear;

*merge in wealthmat;
merge m:1 HHID using "C:\Dropbox\hrs\wealthcouples\wlthmat.dta", keepusing(assetsmiss* manhealmiss* womanhealmiss* hhstatusmiss* hhmedcostmiss*);
*I used to drop these households, but now I wnt to make sure that the sample composition alighns with John's data
*drop if _merge!=3;
drop _merge;

rename hhmedcostmiss* medexmiss*;
*now I want to loopthrough some variables and replicate the missing structure;
foreach varnames in assets manheal womanheal hhstatus medex{;
	forvalues wav=3(1)12{;
		replace `varnames'=. if wave==`wav' & `varnames'miss`wav'==1;
		drop `varnames'miss`wav';
	};
	*;
};
*;

	
merge m:1 HHID wave using "`rootpath'\match.dta", keepusing(HHIDdon);
*merge m:1 HHID using "C:\Dropbox\hrs_copy\wealthcouples\eventstudy\eventdonors.dta";

drop if _merge!=3;
drop _merge;
save tmp1.dta, replace;
use "`rootpath'\`savname'.dta";
keep HHID wave assets consumption Medicaid medex OOP demog_impute manheal womanheal age beq amothers mandead womandead; 
rename (HHID assets consumption Medicaid medex OOP demog_impute manheal womanheal age amothers mandead womandead) (HHIDdon assets_don consumption_don Medicaid_don medex_don OOP_don demog_impute_don manheal_don womanheal_don age_don amothers_don mandead_don womandead_don);
save tmp2.dta, replace;




use tmp1.dta, clear;
sort HHIDdon wave;
*merge  HHIDdon wave using tmp2.dta;


merge m:1 HHIDdon wave using tmp2.dta;
keep if _merge==3;
drop if wave==13;


replace amothers_don=0 if mandead_don==1 & womandead_don==1;
replace amothers=0 if mandead==1 & womandead==1; *definitional - we think of these as terminal bequests measured in the assets of households;

save "`rootpath'\event_`savname'.dta", replace;
log close;