# delimit ; 
cap log close;
clear; 
set mem 300m;	
set more 1 ;  
drop _all;
program drop _all;

local noSIM=0;
local rerun=1;
local folderpath "C:\Dropbox\ERIC_couples\NewPC\";
cd "`folderpath'Exported Sim data\";
log using make_validationtables3.log, replace;
if `rerun'==1{;
	if `noSIM'==0{;
		do SIMdeathwealth_rm4_couples5.do;
	};

do deathwealth_rm4_couples5.do;
};
cap log close;
log using make_validationtables5.log, replace;

*option to control SIMULATION;
if `noSIM'==0{;
use couples_simulated.dta, clear;

};
else{;
use couples_HRS.dta, clear;
	replace SIM=0;
*this pretends data is simulation to allow everything to run without estimating structural model;
};

append using couples_HRS.dta;

*1-5 will be couples at death;
*6-10 will be singles at death;
*11-13 will be medical spendin;

*20-25 will be amother amounts transferred outside the house;

*31-33 is couples by tercile;

forvalues iter=1(1)16{;

gen tmp`iter'=diff`iter' if wave==3;
gen setmp`iter'=sediff`iter' if wave==3;

bys SIM: egen base`iter'=max( tmp`iter');

bys SIM: egen sebase`iter'=max( setmp`iter');
	

*generate differences in difference;
gen DiD`iter'=diff`iter'-base`iter';
gen seDiD`iter'=sqrt(sediff`iter'^2+sebase`iter'^2);

gen lbDiD`iter'=DiD`iter'-1.96*seDiD`iter';
gen ubDiD`iter'=DiD`iter'+1.96*seDiD`iter';

*To improve plotting;
replace DiD`iter'=DiD`iter'/1000;
replace seDiD`iter'=seDiD`iter'/1000;
replace lbDiD`iter'=lbDiD`iter'/1000;
replace ubDiD`iter'=ubDiD`iter'/1000;
drop tmp`iter' base`iter';


replace seDiD`iter'=. if wave==3;
replace lbDiD`iter'=0 if wave==3;
replace ubDiD`iter'=0 if wave==3;


};

forvalues iter=21(1)25{;

gen tmp`iter'=diff`iter' if wave==3;
gen setmp`iter'=sediff`iter' if wave==3;

bys SIM: egen base`iter'=max( tmp`iter');

bys SIM: egen sebase`iter'=max( setmp`iter');
	

*generate differences in difference;
gen DiD`iter'=diff`iter'-base`iter';
gen seDiD`iter'=sqrt(sediff`iter'^2+sebase`iter'^2);

gen lbDiD`iter'=DiD`iter'-1.96*seDiD`iter';
gen ubDiD`iter'=DiD`iter'+1.96*seDiD`iter';

*To improve plotting;
replace DiD`iter'=DiD`iter'/1000;
replace seDiD`iter'=seDiD`iter'/1000;
replace lbDiD`iter'=lbDiD`iter'/1000;
replace ubDiD`iter'=ubDiD`iter'/1000;
drop tmp`iter' base`iter';


replace seDiD`iter'=. if wave==3;
replace lbDiD`iter'=0 if wave==3;
replace ubDiD`iter'=0 if wave==3;


};

forvalues iter=31(1)38{;

gen tmp`iter'=diff`iter' if wave==3;
gen setmp`iter'=sediff`iter' if wave==3;

bys SIM: egen base`iter'=max( tmp`iter');

bys SIM: egen sebase`iter'=max( setmp`iter');
	

*generate differences in difference;
gen DiD`iter'=diff`iter'-base`iter';
gen seDiD`iter'=sqrt(sediff`iter'^2+sebase`iter'^2);

gen lbDiD`iter'=DiD`iter'-1.96*seDiD`iter';
gen ubDiD`iter'=DiD`iter'+1.96*seDiD`iter';

*To improve plotting;
replace DiD`iter'=DiD`iter'/1000;
replace seDiD`iter'=seDiD`iter'/1000;
replace lbDiD`iter'=lbDiD`iter'/1000;
replace ubDiD`iter'=ubDiD`iter'/1000;
drop tmp`iter' base`iter';


replace seDiD`iter'=. if wave==3;
replace lbDiD`iter'=0 if wave==3;
replace ubDiD`iter'=0 if wave==3;


};


forvalues iter=41(1)46{;

gen tmp`iter'=diff`iter' if wave==3;
gen setmp`iter'=sediff`iter' if wave==3;

bys SIM: egen base`iter'=max( tmp`iter');

bys SIM: egen sebase`iter'=max( setmp`iter');
	

*generate differences in difference;
gen DiD`iter'=diff`iter'-base`iter';
gen seDiD`iter'=sqrt(sediff`iter'^2+sebase`iter'^2);

gen lbDiD`iter'=DiD`iter'-1.96*seDiD`iter';
gen ubDiD`iter'=DiD`iter'+1.96*seDiD`iter';

*To improve plotting;
replace DiD`iter'=DiD`iter'/1000;
replace seDiD`iter'=seDiD`iter'/1000;
replace lbDiD`iter'=lbDiD`iter'/1000;
replace ubDiD`iter'=ubDiD`iter'/1000;
drop tmp`iter' base`iter';


replace seDiD`iter'=. if wave==3;
replace lbDiD`iter'=0 if wave==3;
replace ubDiD`iter'=0 if wave==3;


};

*set up appropriate intervals;
replace wave =wave-6;

rename wave year;

replace year=year*2;

bys SIM year: sum DiD1 DiD2 DiD3;

keep if year<6;

twoway (rarea lbDiD1 ubDiD1 year if SIM==0, color(blue%20) ) (connected DiD1 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD1 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-400(100)100, grid gmax gmin); 
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD1);

twoway (rarea lbDiD2 ubDiD2 year if SIM==0, color(blue%20) ) (connected DiD2 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD2 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-400(100)100, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_above.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_above.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD2);

twoway (rarea lbDiD3 ubDiD3 year if SIM==0, color(blue%20) ) (connected DiD3 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD3 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-400(100)100, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_below.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_below.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD3);

twoway (rarea lbDiD4 ubDiD4 year if SIM==0, color(blue%20) ) (connected DiD4 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD4 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_abovePI.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_abovePI.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD4);

twoway (rarea lbDiD5 ubDiD5 year if SIM==0, color(blue%20) ) (connected DiD5 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD5 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_belowPI.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_belowPI.eps", as(eps) name("Graph") replace;


bys SIM: tab year, sum(DiD5);


twoway (rarea lbDiD6 ubDiD6 year if SIM==0, color(blue%20) ) (connected DiD6 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD6 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD6);

twoway (rarea lbDiD7 ubDiD7 year if SIM==0, color(blue%20) ) (connected DiD7 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD7 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_above.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_above.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD7);

twoway (rarea lbDiD8 ubDiD8 year if SIM==0, color(blue%20) ) (connected DiD8 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD8 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_below.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_below.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD8);

twoway (rarea lbDiD9 ubDiD9 year if SIM==0, color(blue%20) ) (connected DiD9 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD9 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_abovePI.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_abovePI.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD9);

twoway (rarea lbDiD10 ubDiD10 year if SIM==0, color(blue%20) ) (connected DiD10 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD10 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_belowPI.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_belowPI.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD10);



twoway (rarea lbDiD11 ubDiD11 year if SIM==0, color(blue%20) ) (connected DiD11 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD11 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\medexDiD_couples.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\medexDiD_couples.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD11);

twoway (rarea lbDiD12 ubDiD12 year if SIM==0, color(blue%20) ) (connected DiD12 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD12 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-10(5)15, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD12);

twoway (rarea lbDiD13 ubDiD13 year if SIM==0, color(blue%20) ) (connected DiD13 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD13 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\medicaidDiD_couples.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\medicaidDiD_couples.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD13);




twoway (rarea lbDiD14 ubDiD14 year if SIM==0, color(blue%20) ) (connected DiD14 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD14 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\medexDiD_singles.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\medexDiD_singles.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD14);

twoway (rarea lbDiD15 ubDiD15 year if SIM==0, color(blue%20) ) (connected DiD15 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD15 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_singles.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_singles.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD15);

twoway (rarea lbDiD16 ubDiD16 year if SIM==0, color(blue%20) ) (connected DiD16 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD16 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\medicaidDiD_singles.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\medicaidDiD_singles.eps", as(eps) name("Graph") replace;


bys SIM: tab year, sum(DiD16);


twoway (rarea lbDiD1 ubDiD1 year if SIM==0, color(blue%20) ) (connected DiD1 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin); 
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_DATA.eps", as(eps) name("Graph") replace;

twoway (rarea lbDiD2 ubDiD2 year if SIM==0, color(blue%20) ) (connected DiD2 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) , legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_above_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_above_DATA.eps", as(eps) name("Graph") replace;

twoway (rarea lbDiD3 ubDiD3 year if SIM==0, color(blue%20) ) (connected DiD3 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) , legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_below_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_below_DATA.eps", as(eps) name("Graph") replace;

twoway (rarea lbDiD4 ubDiD4 year if SIM==0, color(blue%20) ) (connected DiD4 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) , legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_abovePI_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_abovePI_DATA.eps", as(eps) name("Graph") replace;

twoway (rarea lbDiD5 ubDiD5 year if SIM==0, color(blue%20) ) (connected DiD5 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) , legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_belowPI_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_belowPI_DATA.eps", as(eps) name("Graph") replace;




twoway (rarea lbDiD6 ubDiD6 year if SIM==0, color(blue%20) ) (connected DiD6 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) , legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_DATA.eps", as(eps) name("Graph") replace;

twoway (rarea lbDiD7 ubDiD7 year if SIM==0, color(blue%20) ) (connected DiD7 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) , legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_above_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_above_DATA.eps", as(eps) name("Graph") replace;

twoway (rarea lbDiD8 ubDiD8 year if SIM==0, color(blue%20) ) (connected DiD8 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) , legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_below_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_below_DATA.eps", as(eps) name("Graph") replace;

twoway (rarea lbDiD9 ubDiD9 year if SIM==0, color(blue%20) ) (connected DiD9 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) , legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_abovePI_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_abovePI_DATA.eps", as(eps) name("Graph") replace;

twoway (rarea lbDiD10 ubDiD10 year if SIM==0, color(blue%20) ) (connected DiD10 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) , legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_belowPI_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_singles_belowPI_DATA.eps", as(eps) name("Graph") replace;



twoway (rarea lbDiD11 ubDiD11 year if SIM==0, color(blue%20) ) (connected DiD11 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) , legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\medexDiD_couples_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\medexDiD_couples_DATA.eps", as(eps) name("Graph") replace;

twoway (rarea lbDiD12 ubDiD12 year if SIM==0, color(blue%20) ) (connected DiD12 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) , legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_DATA.eps", as(eps) name("Graph") replace;

twoway (rarea lbDiD13 ubDiD13 year if SIM==0, color(blue%20) ) (connected DiD13 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) , legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\medicaidDiD_couples_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\medicaidDiD_couples_DATA.eps", as(eps) name("Graph") replace;




twoway (rarea lbDiD14 ubDiD14 year if SIM==0, color(blue%20) ) (connected DiD14 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) , legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\medexDiD_singles_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\medexDiD_singles_DATA.eps", as(eps) name("Graph") replace;

twoway (rarea lbDiD15 ubDiD15 year if SIM==0, color(blue%20) ) (connected DiD15 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) , legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_singles_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_singles_DATA.eps", as(eps) name("Graph") replace;

twoway (rarea lbDiD16 ubDiD16 year if SIM==0, color(blue%20) ) (connected DiD16 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) , legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\medicaidDiD_singles_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\medicaidDiD_singles_DATA.eps", as(eps) name("Graph") replace;

*tercile plots;


twoway (rarea lbDiD31 ubDiD31 year if SIM==0, color(blue%20) ) (connected DiD31 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD31 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-400(100)100, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_lowPI.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_lowPI.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD31);

twoway (rarea lbDiD32 ubDiD32 year if SIM==0, color(blue%20) ) (connected DiD32 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD32 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-400(100)100, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_midPI.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_midPI.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD32);

twoway (rarea lbDiD33 ubDiD33 year if SIM==0, color(blue%20) ) (connected DiD33 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD33 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-400(100)100, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_topPI.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_topPI.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD33);





twoway (rarea lbDiD31 ubDiD31 year if SIM==0, color(blue%20) ) (connected DiD31 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-400(100)100, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_lowPI_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_lowPI_DATA.eps", as(eps) name("Graph") replace;


twoway (rarea lbDiD32 ubDiD32 year if SIM==0, color(blue%20) ) (connected DiD32 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-400(100)100, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_midPI_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_midPI_DATA.eps", as(eps) name("Graph") replace;



twoway (rarea lbDiD33 ubDiD33 year if SIM==0, color(blue%20) ) (connected DiD33 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-400(100)100, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_topPI_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_topPI_DATA.eps", as(eps) name("Graph") replace;



twoway (rarea lbDiD34 ubDiD34 year if SIM==0, color(blue%20) ) (connected DiD34 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD34 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-10(10)30, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_lowPI.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_lowPI.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD34);

twoway (rarea lbDiD35 ubDiD35 year if SIM==0, color(blue%20) ) (connected DiD35 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD35 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-10(10)30, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_midPI.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_midPI.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD35);

twoway (rarea lbDiD36 ubDiD36 year if SIM==0, color(blue%20) ) (connected DiD36 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD36 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-10(10)30, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_topPI.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_topPI.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD36);



twoway (rarea lbDiD34 ubDiD34 year if SIM==0, color(blue%20) ) (connected DiD34 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_lowPI_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_lowPI_DATA.eps", as(eps) name("Graph") replace;


twoway (rarea lbDiD35 ubDiD35 year if SIM==0, color(blue%20) ) (connected DiD35 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_midPI_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_midPI_DATA.eps", as(eps) name("Graph") replace;



twoway (rarea lbDiD36 ubDiD36 year if SIM==0, color(blue%20) ) (connected DiD36 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_topPI_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_topPI_DATA.eps", as(eps) name("Graph") replace;


twoway (rarea lbDiD37 ubDiD37 year if SIM==0, color(blue%20) ) (connected DiD37 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD37 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-10(5)15, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_below.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_below.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD37);

twoway (rarea lbDiD38 ubDiD38 year if SIM==0, color(blue%20) ) (connected DiD38 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD38 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-10(5)15, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_above.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_above.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD38);


twoway (rarea lbDiD37 ubDiD37 year if SIM==0, color(blue%20) ) (connected DiD37 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_below_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_below_DATA.eps", as(eps) name("Graph") replace;


twoway (rarea lbDiD38 ubDiD38 year if SIM==0, color(blue%20) ) (connected DiD38 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_above_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_above_DATA.eps", as(eps) name("Graph") replace;








*age plots;


twoway (rarea lbDiD41 ubDiD41 year if SIM==0, color(blue%20) ) (connected DiD41 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD41 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-400(100)100, grid gmax gmin) yscale(range(-450 100));
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_low_age.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_low_age.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD41);

twoway (rarea lbDiD42 ubDiD42 year if SIM==0, color(blue%20) ) (connected DiD42 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD42 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-400(100)100, grid gmax gmin) yscale(range(-450 100));
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_mid_age.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_mid_age.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD42);

twoway (rarea lbDiD43 ubDiD43 year if SIM==0, color(blue%20) ) (connected DiD43 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD43 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-400(100)100, grid gmax gmin) yscale(range(-450 100));
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_top_age.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_top_age.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD43);





twoway (rarea lbDiD41 ubDiD41 year if SIM==0, color(blue%20) ) (connected DiD41 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-400(100)100, grid gmax gmin) yscale(range(-450 100));
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_low_age_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_low_age_DATA.eps", as(eps) name("Graph") replace;


twoway (rarea lbDiD42 ubDiD42 year if SIM==0, color(blue%20) ) (connected DiD42 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-400(100)100, grid gmax gmin) yscale(range(-450 100));
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_mid_age_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_mid_age_DATA.eps", as(eps) name("Graph") replace;



twoway (rarea lbDiD43 ubDiD43 year if SIM==0, color(blue%20) ) (connected DiD43 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-400(100)100, grid gmax gmin) yscale(range(-450 100));
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_top_age_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\AssetsDiD_couples_top_age_DATA.eps", as(eps) name("Graph") replace;



twoway (rarea lbDiD44 ubDiD44 year if SIM==0, color(blue%20) ) (connected DiD44 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD44 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-10(10)30, grid gmax gmin) yscale(range(-15 30));
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_low_age.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_low_age.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD44);

twoway (rarea lbDiD45 ubDiD45 year if SIM==0, color(blue%20) ) (connected DiD45 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD45 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-10(10)30, grid gmax gmin) yscale(range(-15 30));
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_mid_age.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_mid_age.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD45);

twoway (rarea lbDiD46 ubDiD46 year if SIM==0, color(blue%20) ) (connected DiD46 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)) (line DiD46 year if SIM==1, lcolor(red) lpattern(__)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data") label(3 "Simulations") order(2 1 3)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(-10(10)30, grid gmax gmin) yscale(range(-15 30));
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_top_age.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_top_age.eps", as(eps) name("Graph") replace;

bys SIM: tab year, sum(DiD46);



twoway (rarea lbDiD44 ubDiD44 year if SIM==0, color(blue%20) ) (connected DiD44 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_low_age_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_low_age_DATA.eps", as(eps) name("Graph") replace;


twoway (rarea lbDiD45 ubDiD45 year if SIM==0, color(blue%20) ) (connected DiD45 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_mid_age_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_mid_age_DATA.eps", as(eps) name("Graph") replace;



twoway (rarea lbDiD46 ubDiD46 year if SIM==0, color(blue%20) ) (connected DiD46 year if SIM==0,  lpattern(l) msymbol(O) mcolor(navy) lcolor(navy)), legend(rows(1) position(6) label(1 "95% CI") label(2 "Data")  order(2 1)) xline(0, lpattern(- -)) yline(0, lpattern(--)) xtitle("Years from Death") ytitle("1000s of 2014 Dollars") xlabel(,grid gmax gmin) ylabel(, grid gmax gmin);
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_top_age_DATA.pdf", as(pdf) name("Graph") replace;
graph export "`folderpath'Exported Sim data\DiD\OOPDiD_couples_top_age_DATA.eps", as(eps) name("Graph") replace;

cap log close;