
setwd(main_path)

### Import relevant libraries
library(tidyverse)
library(haven)
library(plot.matrix)

#Store Environment
to_keep <- ls()

file_name<- c('dtafiles/P52_5_Clusters.dta')



df <- read_dta(file_name) %>% 
  filter(!is.na(cluster_52_frailty_bl), agey_e>=Initial_Age)

prefer <- function(x,y){
  subprefer <- function(x,y,i){
    if(x[i]>y[i]){return (TRUE)}
    else if(x[i]==y[i]&i>1){return(subprefer(x,y,i-1))}
    else{return (FALSE)}
  }
  return(subprefer(x,y,length(x)))
}
sort <- function(x){
  for (i in 2:nrow(x)){
    key=x[i,]
    j = i-1
    while(j>0 && prefer(key,x[j,])){
      x[(j+1),] = x[j,]
      j=j-1
    }
    x[(j+1),] = key
  }
  return (x)
}
elem <- function(m){
  fun <- function(x){
    return(nth(x, n = m))
  }
  return(fun)
}
prepare <- function(dta, x){
  dta <- dta %>% filter(between(agey_e, x, x+9), !(Dead==1 & n()==1)) %>%
    group_by(rahhidpn) %>% filter(n() >= 5) %>%
    mutate(across(c("shlt", "frailty_bl"), 
                  list(n1 = elem(1),
                       n2 = elem(2),
                       n3 = elem(3),
                       n4 = elem(4),
                       n5 = elem(5)),
                  .names = "{col}{fn}")) %>% ungroup() %>% 
    filter(rahhidpn != lag(rahhidpn) | is.na(lag(rahhidpn)))
  return(dta)
}
x <- prepare(df, 52) %>% select(starts_with("frailty_bl"), "cluster_52_frailty_bl") %>% select(-frailty_bl) %>% 
  filter(!is.na(cluster_52_frailty_bl), !(is.na(frailty_bln1)), !(is.na(frailty_bln2)), !(is.na(frailty_bln3)), !(is.na(frailty_bln4)), !(is.na(frailty_bln5)))

custom_breaks <- c(0,2/35,4/35,6/35,9/35,12/35,15/35,18/35,24/35,27/35,33/35,1)

for (k in 1:5) {
  # Define filenames
  filename_pdf <- paste0("output/Part2_output/Part2_e_heatmaps/fig3-", k, ".pdf")
  filename_eps <- paste0("output/Part2_output/Part2_e_heatmaps/fig3-", k, ".eps")
  
  # PDF Export
  pdf(filename_pdf, width = 8, height = 6)  # Adjust the width and height as needed
  
  # Filter and prepare the data
  map <- data.matrix(filter(x[1:5], x$cluster_52_frailty_bl == k))
  map <- sort(map)
  colnames(map) <- c(52, 54, 56, 58, 60)
  
  # Format breaks to exactly 2 decimals
  formatted_breaks <- custom_breaks
  
  # Ensure legend displays only formatted values
  legend_labels <- sprintf("%.3f", as.numeric(custom_breaks))  # Ensure numeric values before formatting
  
  # Set graphical parameters
  par(mar = c(5, 5, 2, 2) + 0.1)  # Increase inner margins for larger axis text
  par(oma = c(0, 0, 0, 0))  # No outer margins
  
  # Plot heatmap
  plot(
    map, 
    border = NA, 
    breaks = formatted_breaks,  # Use formatted breaks directly
    col = c("gray97", "gray90", "gray80", "gray70", "gray60", "gray50", 
            "gray40", "gray30", "gray20", "gray10", "gray1"),
    axis.row = NULL, 
    key = list(
      side = 2, 
      cex.axis = 1.5, 
      at = formatted_breaks,  # Explicitly set where ticks appear
      labels = legend_labels  # Explicitly pass formatted labels
    ),  
    xlab = "",  # Remove x-axis label
    cex.axis = 1.5,  # Larger x-axis text size
    ylab = "", 
    main = ""
  )
  
  # Close PDF device
  dev.off()
  
  # EPS Export (if eps == 1)
  if (eps == 1) {
    postscript(filename_eps, width = 8, height = 6, paper = "special", horizontal = FALSE)
    
    # Re-plot heatmap for EPS
    par(mar = c(5, 5, 2, 2) + 0.1)
    par(oma = c(0, 0, 0, 0))
    
    plot(
      map, 
      border = NA, 
      breaks = formatted_breaks, 
      col = c("gray97", "gray90", "gray80", "gray70", "gray60", "gray50", 
              "gray40", "gray30", "gray20", "gray10", "gray1"),
      axis.row = NULL, 
      key = list(
        side = 2, 
        cex.axis = 1.5, 
        at = formatted_breaks, 
        labels = legend_labels
      ),  
      xlab = "",
      cex.axis = 1.5, 
      ylab = "", 
      main = ""
    )
    
    # Close EPS device
    dev.off()
  }
}




#Clear enviroment
rm(list = setdiff(ls(), c(to_keep)))
