*** This do file constructs frailty 

sort rahhidpn year

/* Create a flag for whether each deficit variables is observed (and thus takes
value either 0 or 1 or continuous) and 0 if it's not observed (battery of missing indicators) */

local binaryfrailvars eata dressa beda toilta batha walkra walksa phonea moneya ///
shopa mealsa chaira stoopa lifta mapa medsa clim1a dimea armsa pusha hibpe diabe ///
cancre lunge hearte stroke psyche arthre smokev hosp nrshom bmigte30 ///
walk1a sita climsa

/*removed shltfairpoor */

foreach var in `binaryfrailvars' {
	
	gen `var'Observed=.
	replace `var'Observed=1 if (r`var'==1| r`var'==0)
	replace `var'Observed=0 if (r`var'==.| r`var'==.a | r`var'==.d | r`var'==.n | r`var'==.s | r`var'==.x | r`var'==2 )

}

/* Count number of observed deficits per observation */

gen byte NumObservedDeficits=0

local list_totvar eata dressa beda toilta batha walkra walksa phonea moneya ///
shopa mealsa chaira stoopa lifta mapa medsa clim1a dimea armsa pusha hibpe diabe ///
cancre lunge hearte stroke psyche arthre bmigte30 smokev hosp nrshom ///
walk1a sita climsa

foreach var in `list_totvar' {
	replace NumObservedDeficits=NumObservedDeficits+`var'Observed
}


/* We generate new versions of the previous variables, but replace missing values 
with 0's. */

local list_totvar eata dressa beda toilta batha walkra walksa phonea moneya ///
shopa mealsa chaira stoopa lifta mapa medsa clim1a dimea armsa pusha hibpe diabe ///
cancre lunge hearte stroke psyche arthre bmigte30 smokev hosp nrshom ///
walk1a sita climsa 


foreach var in `list_totvar' {
	gen `var'FI=.
	replace `var'FI=0 if (r`var'==.| r`var'==.a | r`var'==.d | r`var'==.m | r`var'==.n | r`var'==.r | r`var'==.s | r`var'==.x | r`var'==2 )
	replace `var'FI=0 if r`var'==0
	replace `var'FI=1 if r`var'==1
}


*** Sort by ID and year 
sort rahhidpn year 

*** Construct numerator for frailty
egen byte numf = rowtotal(*FI)

*** Construct frailty indices 
*** Option 1: Just for those with 35 deficits 
count if NumObservedDeficits == 35 & NumObservedDeficits!=.
gen double frailty354 = numf/NumObservedDeficits if NumObservedDeficits==35

*** Option 2A: Those with at least 34 deficits 
count if NumObservedDeficits>=34 & NumObservedDeficits!=.
gen double frailty34 = numf/NumObservedDeficits if NumObservedDeficits>=34

*** Option 2B: Those with at least 32 deficits
count if NumObservedDeficits>=32 & NumObservedDeficits!=.
gen  double frailty32 = numf/NumObservedDeficits if NumObservedDeficits>=32


*** Construct self-reported and diagnosed frailty

*** Self-reported frailty 
local list_self eata dressa beda toilta batha walkra walksa phonea moneya ///
shopa mealsa chaira stoopa lifta mapa medsa clim1a dimea armsa pusha walk1a sita climsa ///
bmigte30 smokev

*** Count number of self-reported deficits
gen NumObservedDeficits_self=0

foreach var in `list_self' {
	replace NumObservedDeficits_self=NumObservedDeficits_self+`var'Observed
}

*** Generate numerator for self-reported frailty
egen numf_self = rsum(eataFI dressaFI bedaFI toiltaFI bathaFI walkraFI walksaFI ///
phoneaFI moneyaFI shopaFI mealsaFI chairaFI stoopaFI liftaFI mapaFI medsaFI ///
clim1aFI dimeaFI armsaFI pushaFI walk1aFI sitaFI climsaFI bmigte30FI smokevFI)

*** Generate frailty indices (complete, 2 missing, 3 missing)
gen frailty_self25 = numf_self/NumObservedDeficits_self if NumObservedDeficits_self==25
gen frailty_self23 = numf_self/NumObservedDeficits_self if NumObservedDeficits_self>=23
gen frailty_self22 = numf_self/NumObservedDeficits_self if NumObservedDeficits_self>=22

*** Diagnosed frailty
local list_diag hibpe diabe cancre lunge hearte stroke psyche arthre hosp nrshom 

*** Count number of self-reported deficits
gen NumObservedDeficits_diag=0

foreach var in `list_diag' {
	replace NumObservedDeficits_diag=NumObservedDeficits_diag+`var'Observed
}
*** Generate numerator for diagnosed frailty
egen numf_diag = rsum(hibpeFI diabeFI cancreFI lungeFI hearteFI strokeFI ///
psycheFI arthreFI hospFI nrshomFI)

*** Generate indices (complete, 1 missing, 2 missing)
gen frailty_diag10 = numf_diag/NumObservedDeficits_diag if NumObservedDeficits_diag==10
gen frailty_diag9 = numf_diag/NumObservedDeficits_diag if NumObservedDeficits_diag>=9
gen frailty_diag8 = numf_diag/NumObservedDeficits_diag if NumObservedDeficits_diag>=8

*** Add in frailty index values for those who are dead

foreach x of numlist 32 34 35 {
	replace frailty`x'=1 if Dead==1  
}

foreach x of numlist 25 23 22 {
	replace frailty_self`x'=1 if Dead==1  
}


foreach x of numlist 10 9 8 {
	replace frailty_diag`x'=1 if Dead==1  
}

*Drop intermediary variables used to create frailty
drop *FI *Observed



/*
replace frailty_nodiagnoses=1 if Dead==1
replace frailty_nohealthcare=1 if Dead==1
replace frailty_nodiagnorhc=1 if Dead==1
*/
