# This part of the code test the implication of health types for health dynamics
setwd(main_path)

### Import relevant libraries
library(tidyverse)
library(haven)
library(stats)
library(ggplot2)
library(xtable)
library(stargazer)
library(coefplot)
library(gplots)
library(reshape2)
library(feisr)
library(dplyr)
library(knitr)
library(kpodclustr)
library(Cairo)
library(zoo)
library(labelled)
library(plot.matrix)
library(pscl)
library(multiUS)
library(factoextra)
library(RColorBrewer)
library(nnet)
library(caret)
library(lmtest)
library(pscl)
library(DescTools)
library(kableExtra)

#Store Environment
to_keep <- ls()

## Part3 a: Get data ready
setwd(code_path_p3)
source('Part3_a_get_data_ready.R')
# Description
# Get the clustering sample, generate auxiliaries variables required for estimating
# health dynamics models. 
# Note: Run before running the upcoming codes


## Part3 b: Testing for health types in models for health dynamics
runcode<-1
if (runcode==1){
  setwd(code_path_p3)
  source('Part3_b_testing.R')
}
# Description
# Test for different specification of the health process and evaluate statistical 
# significance of health type.
# Output:
# 1) Excel file with relevant statistical metrics for estimated models
# 2) Table 6 and Table 7
# Output: /output/Part3_output/Part3_b_testing


## Part3 c: Implications for health dynamics: Simulations
runcode<-1
if (runcode==1){
  setwd(code_path_p3)
  source("Part3_c_simulations.R")
}
# Description
# Estimate benchmark model for health dynamics without and with health type and
# simulate the health path of 100000 individuals. 
# Compare simulations with data counterpart of both models
# Output:
# 1) Figures 4 and 5 
# Output: /output/Part3_output/Part3_c_simulations

