## Plots:
setwd(main_path)
# 1) Fraction Alive
# 2) Fraction in Good Health


################################################################################
####################  Model without health types      ##########################
################################################################################

model1_data<- result_mod_1 %>% select(c_age,fraction_alive,fraction_alive,fraction_srhs_type1_alive,
                                      fraction_srhs_type2_alive,fraction_srhs_type3_alive,
                                      fraction_srhs_type4_alive,fraction_srhs_type5_alive,
                                      fraction_goodhealth,fraction_goodhealth_type1,fraction_goodhealth_type2,
                                      fraction_goodhealth_type3,fraction_goodhealth_type4,fraction_goodhealth_type5,
                                      fraction_badhealth,fraction_badhealth_type1,fraction_badhealth_type2,
                                      fraction_badhealth_type3,fraction_badhealth_type4,fraction_badhealth_type5)
empirics_data<- result_mod_3 %>% select(c_age,fraction_alive,fraction_alive,fraction_srhs_type1_alive,
                                        fraction_srhs_type2_alive,fraction_srhs_type3_alive,
                                        fraction_srhs_type4_alive,fraction_srhs_type5_alive,
                                        fraction_goodhealth,fraction_goodhealth_type1,fraction_goodhealth_type2,
                                        fraction_goodhealth_type3,fraction_goodhealth_type4,fraction_goodhealth_type5,
                                        fraction_badhealth,fraction_badhealth_type1,fraction_badhealth_type2,
                                        fraction_badhealth_type3,fraction_badhealth_type4,fraction_badhealth_type5) %>%
  rename(
    c_age2 = c_age,
    fraction_alive2 = fraction_alive,
    fraction_srhs_type1_alive2 = fraction_srhs_type1_alive,
    fraction_srhs_type2_alive2 = fraction_srhs_type2_alive,
    fraction_srhs_type3_alive2 = fraction_srhs_type3_alive,
    fraction_srhs_type4_alive2 = fraction_srhs_type4_alive,
    fraction_srhs_type5_alive2 = fraction_srhs_type5_alive,
    fraction_goodhealth2       = fraction_goodhealth,
    fraction_goodhealth_type1_2 = fraction_goodhealth_type1,
    fraction_goodhealth_type2_2 = fraction_goodhealth_type2,
    fraction_goodhealth_type3_2 = fraction_goodhealth_type3,
    fraction_goodhealth_type4_2 = fraction_goodhealth_type4,
    fraction_goodhealth_type5_2 = fraction_goodhealth_type5,
    fraction_badhealth2       = fraction_badhealth,
    fraction_badhealth_type1_2 = fraction_badhealth_type1,
    fraction_badhealth_type2_2 = fraction_badhealth_type2,
    fraction_badhealth_type3_2 = fraction_badhealth_type3,
    fraction_badhealth_type4_2 = fraction_badhealth_type4,
    fraction_badhealth_type5_2 = fraction_badhealth_type5)

data_to_plot <- cbind(model1_data,empirics_data)
data_to_plot <- subset(data_to_plot, c_age<=70)




#color_type_1<- c('grey80')
#color_type_2<- c('grey65')
#color_type_3<- c('grey45')
#color_type_4<- c('grey25')
#color_type_5<- c('grey0')

# Replace for the following pallets if in color
 color_type_1<- c('#1f78b4')
 color_type_2<- c('#ff7f00')
 color_type_3<- c('#e31a1c')
 color_type_4<- c('#33a02c')
 color_type_5<- c('#6a3d9a')

#########################   Model without health types: Fraction alive   ################################ 
plot_all <- ggplot(data_to_plot, aes(x = c_age)) + 
  #Type 1
  geom_line(aes(y = fraction_srhs_type1_alive2, color = "Type 1"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type1_alive2 == min(fraction_srhs_type1_alive2)), 
            aes(label = "Type 1", x = c_age, y = fraction_srhs_type1_alive2), 
            vjust = -1, hjust = +0.7, size = 5, color = color_type_1) +
  # Mod 1-> Type 1
  geom_line(aes(y = fraction_srhs_type1_alive, color = "Type 1"), size = 1.25, linetype = "dashed") +
  
  #Type 2
  geom_line(aes(y = fraction_srhs_type2_alive2, color = "Type 2"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type2_alive2 == min(fraction_srhs_type2_alive2)), 
            aes(label = "Type 2", x = c_age, y = fraction_srhs_type2_alive2), 
            vjust = +3.5, hjust = +0.7, size = 5, color = color_type_2) +
  # Mod 1-> Type 2
  geom_line(aes(y = fraction_srhs_type2_alive, color = "Type 2"), size = 1.25, linetype = "dashed") +
  
  
  #Type 3
  geom_line(aes(y = fraction_srhs_type3_alive2, color = "Type 3"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type3_alive2 == min(fraction_srhs_type3_alive2))%>%
              mutate(c_age = 60, fraction_srhs_type3_alive2 = 0.5), 
            aes(label = "Type 3", x = c_age, y = fraction_srhs_type3_alive2), 
            vjust = +0, hjust = +0.7, size = 5, color = color_type_3) + 
  # Mod 1-> Type 3
  geom_line(aes(y = fraction_srhs_type3_alive, color = "Type 3"), size = 1.25, linetype = "dashed") +
  
  #Type 4
  geom_line(aes(y = fraction_srhs_type4_alive2, color = "Type 4"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type4_alive2 == min(fraction_srhs_type4_alive2)), 
            aes(label = "Type 4", x = c_age, y = fraction_srhs_type4_alive2), 
            vjust = 2.5, hjust = +0.7, size = 5, color = color_type_4) +
  # Mod 1-> Type 4
  geom_line(aes(y = fraction_srhs_type4_alive, color = "Type 4"), size = 1.25, linetype = "dashed") +
  
  #Type 5
  geom_line(aes(y = fraction_srhs_type5_alive2, color = "Type 5"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type5_alive2 == min(fraction_srhs_type5_alive2)), 
            aes(label = "Type 5", x = c_age, y = fraction_srhs_type5_alive2), 
            vjust = -2.5, hjust = +0.7, size = 5, color = color_type_5) +
  # Mod 1-> Type 5
  geom_line(aes(y = fraction_srhs_type5_alive, color = "Type 5"), size = 1.25, linetype = "dashed") +
  
  
  labs(x = "Age", y = "Fraction Alive") +
  geom_hline(yintercept = 0, color = "black", linetype = "solid", size = 1) +
  theme_minimal() +
  theme(
    axis.text = element_text(size = 18),
    title = element_blank(),
    axis.title = element_text(size = 18),
    panel.grid.major.x = element_line(color = "gray", linetype = "solid"),
    panel.grid.minor.x = element_blank(),
    legend.position = "none",  # Remove legend,
    legend.direction = "horizontal",
    legend.box = "horizontal",
    legend.title = element_blank(),
    legend.text = element_blank(),
    legend.spacing.x = unit(0.5, "cm"),
    legend.key.height = unit(2, "lines")  # Adjust the height of each legend row
  ) +
  scale_color_manual(values = c("Type 1" = color_type_1,
                                "Type 2" = color_type_2,
                                "Type 3" = color_type_3,
                                "Type 4" = color_type_4,
                                "Type 5" = color_type_5))

print(plot_all)

name1<-"fig4-1"
ggsave(file = paste0("output/Part3_output/Part3_c_simulations/", name1, ".pdf"), plot = plot_all,device = pdf,
       width = 6, height = 6, units = "in", dpi = 300)
# Conditional EPS export
if (eps == 1) {
  ggsave(file = paste0("output/Part3_output/Part3_c_simulations/", name1, ".eps"), plot = plot_all,device = cairo_ps,
         width = 6, height = 6, units = "in", dpi = 300)
}

#########################   Model without health types: Fraction in good health     ################################ 
plot_all <- ggplot(data_to_plot, aes(x = c_age)) + 
  #Type 1
  geom_line(aes(y = fraction_goodhealth_type1_2, color = "Type 1"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type1_alive2 == min(fraction_srhs_type1_alive2)), 
            aes(label = "Type 1", x = c_age, y = fraction_srhs_type1_alive2), 
            vjust = 1, hjust = +0.7, size = 5, color = color_type_1) +
  # Mod 1-> Type 1
  geom_line(aes(y = fraction_goodhealth_type1, color = "Type 1"), size = 1.25, linetype = "dashed") +
  
  #Type 2
  geom_line(aes(y = fraction_goodhealth_type2_2, color = "Type 2"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type2_alive2 == min(fraction_srhs_type2_alive2)), 
            aes(label = "Type 2", x = c_age, y = fraction_srhs_type2_alive2), 
            vjust = +8.5, hjust = +0.7, size = 5, color = color_type_2) +
  # Mod 1-> Type 2
  geom_line(aes(y = fraction_goodhealth_type2, color = "Type 2"), size = 1.25, linetype = "dashed") +
  
  
  #Type 3
  geom_line(aes(y = fraction_goodhealth_type3_2, color = "Type 3"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type3_alive2 == min(fraction_srhs_type3_alive2))%>%
              mutate(c_age = 60, fraction_srhs_type3_alive2 = 0.5), 
            aes(label = "Type 3", x = c_age, y = fraction_srhs_type3_alive2), 
            vjust = +1, hjust = +0.7, size = 5, color = color_type_3) + 
  # Mod 1-> Type 3
  geom_line(aes(y = fraction_goodhealth_type3, color = "Type 3"), size = 1.25, linetype = "dashed") +
  
  #Type 4
  geom_line(aes(y = fraction_goodhealth_type4_2, color = "Type 4"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type4_alive2 == min(fraction_srhs_type4_alive2)), 
            aes(label = "Type 4", x = c_age, y = fraction_srhs_type4_alive2), 
            vjust = 7.5, hjust = +0.7, size = 5, color = color_type_4) +
  # Mod 1-> Type 4
  geom_line(aes(y = fraction_goodhealth_type4, color = "Type 4"), size = 1.25, linetype = "dashed") +
  
  #Type 5
  geom_line(aes(y = fraction_goodhealth_type5_2, color = "Type 5"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type5_alive2 == min(fraction_srhs_type5_alive2)), 
            aes(label = "Type 5", x = c_age, y = fraction_srhs_type5_alive2), 
            vjust = -1.5, hjust = +0.7, size = 5, color = color_type_5) +
  # Mod 1-> Type 5
  geom_line(aes(y = fraction_goodhealth_type5, color = "Type 5"), size = 1.25, linetype = "dashed") +
  
  labs(x = "Age", y = "Fraction in Good Health") +
  geom_hline(yintercept = 0, color = "black", linetype = "solid", size = 1) +
  theme_minimal() +
  theme(
    axis.text = element_text(size = 18),
    title = element_blank(),
    axis.title = element_text(size = 18),
    panel.grid.major.x = element_line(color = "gray", linetype = "solid"),
    panel.grid.minor.x = element_blank(),
    legend.position = "none",  # Remove legend,
    legend.direction = "horizontal",
    legend.box = "horizontal",
    legend.title = element_blank(),
    legend.text = element_blank(),
    legend.spacing.x = unit(0.5, "cm"),
    legend.key.height = unit(2, "lines")  # Adjust the height of each legend row
  ) +
  scale_color_manual(values = c("Type 1" = color_type_1,
                                "Type 2" = color_type_2,
                                "Type 3" = color_type_3,
                                "Type 4" = color_type_4,
                                "Type 5" = color_type_5))

print(plot_all)

name1<-"fig4-2"
ggsave(file = paste0("output/Part3_output/Part3_c_simulations/", name1, ".pdf"), plot = plot_all,device = pdf,
       width = 6, height = 6, units = "in", dpi = 300)
# Conditional EPS export
if (eps == 1) {
  ggsave(file = paste0("output/Part3_output/Part3_c_simulations/", name1, ".eps"), plot = plot_all,device = cairo_ps,
         width = 6, height = 6, units = "in", dpi = 300)
}


################################################################################
#######################  Model with health types      ##########################
################################################################################

model2_data<- result_mod_2 %>% select(c_age,fraction_alive,fraction_alive,fraction_srhs_type1_alive,
                                      fraction_srhs_type2_alive,fraction_srhs_type3_alive,
                                      fraction_srhs_type4_alive,fraction_srhs_type5_alive,
                                      fraction_goodhealth,fraction_goodhealth_type1,fraction_goodhealth_type2,
                                      fraction_goodhealth_type3,fraction_goodhealth_type4,fraction_goodhealth_type5,
                                      fraction_badhealth,fraction_badhealth_type1,fraction_badhealth_type2,
                                      fraction_badhealth_type3,fraction_badhealth_type4,fraction_badhealth_type5)
empirics_data<- result_mod_3 %>% select(c_age,fraction_alive,fraction_alive,fraction_srhs_type1_alive,
                                        fraction_srhs_type2_alive,fraction_srhs_type3_alive,
                                        fraction_srhs_type4_alive,fraction_srhs_type5_alive,
                                        fraction_goodhealth,fraction_goodhealth_type1,fraction_goodhealth_type2,
                                        fraction_goodhealth_type3,fraction_goodhealth_type4,fraction_goodhealth_type5,
                                        fraction_badhealth,fraction_badhealth_type1,fraction_badhealth_type2,
                                        fraction_badhealth_type3,fraction_badhealth_type4,fraction_badhealth_type5) %>%
  rename(
    c_age2 = c_age,
    fraction_alive2 = fraction_alive,
    fraction_srhs_type1_alive2 = fraction_srhs_type1_alive,
    fraction_srhs_type2_alive2 = fraction_srhs_type2_alive,
    fraction_srhs_type3_alive2 = fraction_srhs_type3_alive,
    fraction_srhs_type4_alive2 = fraction_srhs_type4_alive,
    fraction_srhs_type5_alive2 = fraction_srhs_type5_alive,
    fraction_goodhealth2       = fraction_goodhealth,
    fraction_goodhealth_type1_2 = fraction_goodhealth_type1,
    fraction_goodhealth_type2_2 = fraction_goodhealth_type2,
    fraction_goodhealth_type3_2 = fraction_goodhealth_type3,
    fraction_goodhealth_type4_2 = fraction_goodhealth_type4,
    fraction_goodhealth_type5_2 = fraction_goodhealth_type5,
    fraction_badhealth2       = fraction_badhealth,
    fraction_badhealth_type1_2 = fraction_badhealth_type1,
    fraction_badhealth_type2_2 = fraction_badhealth_type2,
    fraction_badhealth_type3_2 = fraction_badhealth_type3,
    fraction_badhealth_type4_2 = fraction_badhealth_type4,
    fraction_badhealth_type5_2 = fraction_badhealth_type5)

data_to_plot <- cbind(model2_data,empirics_data)

data_to_plot <- subset(data_to_plot, c_age<=70)

#########################   Model without health types: Fraction alive   ################################ 
plot_all <- ggplot(data_to_plot, aes(x = c_age)) + 
  #Type 1
  geom_line(aes(y = fraction_srhs_type1_alive2, color = "Type 1"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type1_alive2 == min(fraction_srhs_type1_alive2)), 
            aes(label = "Type 1", x = c_age, y = fraction_srhs_type1_alive2), 
            vjust = -1, hjust = +0.7, size = 5, color = color_type_1) +
  # Mod 1-> Type 1
  geom_line(aes(y = fraction_srhs_type1_alive, color = "Type 1"), size = 1.25, linetype = "dashed") +
  
  #Type 2
  geom_line(aes(y = fraction_srhs_type2_alive2, color = "Type 2"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type2_alive2 == min(fraction_srhs_type2_alive2)), 
            aes(label = "Type 2", x = c_age, y = fraction_srhs_type2_alive2), 
            vjust = +3.5, hjust = +0.7, size = 5, color = color_type_2) +
  # Mod 1-> Type 2
  geom_line(aes(y = fraction_srhs_type2_alive, color = "Type 2"), size = 1.25, linetype = "dashed") +
  
  
  #Type 3
  geom_line(aes(y = fraction_srhs_type3_alive2, color = "Type 3"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type3_alive2 == min(fraction_srhs_type3_alive2))%>%
              mutate(c_age = 60, fraction_srhs_type3_alive2 = 0.5), 
            aes(label = "Type 3", x = c_age, y = fraction_srhs_type3_alive2), 
            vjust = +0, hjust = +0.7, size = 5, color = color_type_3) + 
  # Mod 1-> Type 3
  geom_line(aes(y = fraction_srhs_type3_alive, color = "Type 3"), size = 1.25, linetype = "dashed") +
  
  #Type 4
  geom_line(aes(y = fraction_srhs_type4_alive2, color = "Type 4"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type4_alive2 == min(fraction_srhs_type4_alive2)), 
            aes(label = "Type 4", x = c_age, y = fraction_srhs_type4_alive2), 
            vjust = 2.5, hjust = +0.7, size = 5, color = color_type_4) +
  # Mod 1-> Type 4
  geom_line(aes(y = fraction_srhs_type4_alive, color = "Type 4"), size = 1.25, linetype = "dashed") +
  
  #Type 5
  geom_line(aes(y = fraction_srhs_type5_alive2, color = "Type 5"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type5_alive2 == min(fraction_srhs_type5_alive2)), 
            aes(label = "Type 5", x = c_age, y = fraction_srhs_type5_alive2), 
            vjust = -2.5, hjust = +0.7, size = 5, color = color_type_5) +
  # Mod 1-> Type 5
  geom_line(aes(y = fraction_srhs_type5_alive, color = "Type 5"), size = 1.25, linetype = "dashed") +
  
  
  labs(x = "Age", y = "Fraction Alive") +
  geom_hline(yintercept = 0, color = "black", linetype = "solid", size = 1) +
  theme_minimal() +
  theme(
    axis.text = element_text(size = 18),
    title = element_blank(),
    axis.title = element_text(size = 18),
    panel.grid.major.x = element_line(color = "gray", linetype = "solid"),
    panel.grid.minor.x = element_blank(),
    legend.position = "none",  # Remove legend,
    legend.direction = "horizontal",
    legend.box = "horizontal",
    legend.title = element_blank(),
    legend.text = element_blank(),
    legend.spacing.x = unit(0.5, "cm"),
    legend.key.height = unit(2, "lines")  # Adjust the height of each legend row
  ) +
  scale_color_manual(values = c("Type 1" = color_type_1,
                                "Type 2" = color_type_2,
                                "Type 3" = color_type_3,
                                "Type 4" = color_type_4,
                                "Type 5" = color_type_5))

print(plot_all)

name1<-"fig5-1"
ggsave(file = paste0("output/Part3_output/Part3_c_simulations/", name1, ".pdf"), plot = plot_all,device = pdf,
       width = 6, height = 6, units = "in", dpi = 300)
# Conditional EPS export
if (eps == 1) {
  ggsave(file = paste0("output/Part3_output/Part3_c_simulations/", name1, ".eps"), plot = plot_all,device = cairo_ps,
         width = 6, height = 6, units = "in", dpi = 300)
}


#########################   Model without health types: Fraction in good health     ################################ 
plot_all <- ggplot(data_to_plot, aes(x = c_age)) + 
  #Type 1
  geom_line(aes(y = fraction_goodhealth_type1_2, color = "Type 1"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type1_alive2 == min(fraction_srhs_type1_alive2)), 
            aes(label = "Type 1", x = c_age, y = fraction_srhs_type1_alive2), 
            vjust = 1, hjust = +0.7, size = 5, color = color_type_1) +
  # Mod 1-> Type 1
  geom_line(aes(y = fraction_goodhealth_type1, color = "Type 1"), size = 1.25, linetype = "dashed") +
  
  #Type 2
  geom_line(aes(y = fraction_goodhealth_type2_2, color = "Type 2"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type2_alive2 == min(fraction_srhs_type2_alive2)), 
            aes(label = "Type 2", x = c_age, y = fraction_srhs_type2_alive2), 
            vjust = +8.5, hjust = +0.7, size = 5, color = color_type_2) +
  # Mod 1-> Type 2
  geom_line(aes(y = fraction_goodhealth_type2, color = "Type 2"), size = 1.25, linetype = "dashed") +
  
  
  #Type 3
  geom_line(aes(y = fraction_goodhealth_type3_2, color = "Type 3"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type3_alive2 == min(fraction_srhs_type3_alive2))%>%
              mutate(c_age = 60, fraction_srhs_type3_alive2 = 0.5), 
            aes(label = "Type 3", x = c_age, y = fraction_srhs_type3_alive2), 
            vjust = +1, hjust = +0.7, size = 5, color = color_type_3) + 
  # Mod 1-> Type 3
  geom_line(aes(y = fraction_goodhealth_type3, color = "Type 3"), size = 1.25, linetype = "dashed") +
  
  #Type 4
  geom_line(aes(y = fraction_goodhealth_type4_2, color = "Type 4"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type4_alive2 == min(fraction_srhs_type4_alive2)), 
            aes(label = "Type 4", x = c_age, y = fraction_srhs_type4_alive2), 
            vjust = 7.5, hjust = +0.7, size = 5, color = color_type_4) +
  # Mod 1-> Type 4
  geom_line(aes(y = fraction_goodhealth_type4, color = "Type 4"), size = 1.25, linetype = "dashed") +
  
  #Type 5
  geom_line(aes(y = fraction_goodhealth_type5_2, color = "Type 5"), size = 1.5, linetype = "solid") +
  geom_text(data = subset(data_to_plot, fraction_srhs_type5_alive2 == min(fraction_srhs_type5_alive2)), 
            aes(label = "Type 5", x = c_age, y = fraction_srhs_type5_alive2), 
            vjust = -1.5, hjust = +0.7, size = 5, color = color_type_5) +
  # Mod 1-> Type 5
  geom_line(aes(y = fraction_goodhealth_type5, color = "Type 5"), size = 1.25, linetype = "dashed") +
  
  labs(x = "Age", y = "Fraction in Good Health") +
  geom_hline(yintercept = 0, color = "black", linetype = "solid", size = 1) +
  theme_minimal() +
  theme(
    axis.text = element_text(size = 18),
    title = element_blank(),
    axis.title = element_text(size = 18),
    panel.grid.major.x = element_line(color = "gray", linetype = "solid"),
    panel.grid.minor.x = element_blank(),
    legend.position = "none",  # Remove legend,
    legend.direction = "horizontal",
    legend.box = "horizontal",
    legend.title = element_blank(),
    legend.text = element_blank(),
    legend.spacing.x = unit(0.5, "cm"),
    legend.key.height = unit(2, "lines")  # Adjust the height of each legend row
  ) +
  scale_color_manual(values = c("Type 1" = color_type_1,
                                "Type 2" = color_type_2,
                                "Type 3" = color_type_3,
                                "Type 4" = color_type_4,
                                "Type 5" = color_type_5))

print(plot_all)

name1<-"fig5-2"
ggsave(file = paste0("output/Part3_output/Part3_c_simulations/", name1, ".pdf"), plot = plot_all,device = pdf,
       width = 6, height = 6, units = "in", dpi = 300)
# Conditional EPS export
if (eps == 1) {
  ggsave(file = paste0("output/Part3_output/Part3_c_simulations/", name1, ".eps"), plot = plot_all,device = cairo_ps,
         width = 6, height = 6, units = "in", dpi = 300)
}


