setwd(main_path)

## Import relevant libraries
library(tidyverse)
library(haven)
library(stargazer)
library(xtable)
library(data.table)
library(foreach)
library(tidyverse)
library(haven)
library(stats)
library(ggplot2)
library(xtable)
library(stargazer)
library(coefplot)
library(gplots)
library(reshape2)
library(feisr)
library(dplyr)
library(knitr)
library(kpodclustr)
library(Cairo)
library(zoo)
library(labelled)
library(plot.matrix)
library(pscl)
library(multiUS)
library(factoextra)
library(RColorBrewer)
library(nnet)
library(caret)
library(lmtest)
library(DescTools)
library(openxlsx)
library(caret)
library(mefa)
library(kableExtra)
##


#Store Environment
to_keep <- ls()
start_time <- Sys.time()

file_name<- c('dtafiles/P52_5_Clusters.dta')
data_final<-1


df5 <- read_dta(file_name) %>% filter(!is.na(cluster_52_frailty_bl)) %>% filter(agey_e>=Initial_Age) %>% 
  arrange(rahhidpn,year) %>% group_by(rahhidpn) %>%
  mutate(posit=row_number()) %>% filter(posit==1) %>% mutate(priv_cov=ifelse(prpcnt>0,1,0))

## Add relevant variables to out database
#HH Income
df5$pnumber <- as.numeric(substr(df5$rahhidpn, nchar(df5$rahhidpn) - 1, nchar(df5$rahhidpn)))
df5$hhid <- as.numeric(df5$rahhidpn-df5$pnumber)

df5 <- df5 %>% mutate(total_individual_income = iearn + issdi + isret)
df5 <- df5 %>% group_by(hhid,year) %>% mutate(total_hh_income = sum(total_individual_income, na.rm = TRUE))


df5$genderd <- as.numeric(ifelse(df5$ragender==2,1,0))
df5$mstatusd <- as.numeric(ifelse(df5$hcpl==1,1,
                                 ifelse(df5$hcpl==0,0,NA)))

df5$srhs <- as.factor(df5$shlt)

#Education
df5<- df5 %>% mutate(educ_cat = ifelse(raedyrs<12,1,
                                     ifelse(raedyrs==12,2,
                                            ifelse(raedyrs>12,3,
                                                   ifelse(is.na(raedyrs),NA,NA)))))

# Add merge and Full frailty
## Additional data: Self reported probability of dying and frailty components.

tracker_life_exp<- read_dta("dtafiles/SelfProbDying.dta") %>% mutate(rahhidpn = as.numeric(paste0(hhid, pn))) 

df5 <- left_join(df5, tracker_life_exp, by = c("rahhidpn", "wave"))  

#Include Frailty composition 
adl_index_var<-c('batha','dressa','eata','beda','toilta','walkra','walk1a','walksa')
iadl_index_var<-c('shopa','phonea','moneya','mealsa','medsa','mapa')
ofl_index_var<-c('clim1a','climsa','chaira','stoopa','lifta','armsa','dimea','pusha','sita')
diag_index_var<-c('hibpe','diabe','cancre','lunge', 'hearte','stroke','psyche','arthre')
hosp_index_var<-c('hosp','nrshom')
beh_index_var<-c('bmigte30','smokev')


df5 <- df5 %>%
  mutate(adl_index = rowMeans(across(all_of(adl_index_var)), na.rm = TRUE),
         iadl_index = rowMeans(across(all_of(iadl_index_var)), na.rm = TRUE),
         ofl_index = rowMeans(across(all_of(ofl_index_var)), na.rm = TRUE),
         diag_index = rowMeans(across(all_of(diag_index_var)), na.rm = TRUE),
         hosp_index = rowMeans(across(all_of(hosp_index_var)), na.rm = TRUE),
         beh_index = rowMeans(across(all_of(beh_index_var)), na.rm = TRUE))
  




## Testing different specifications
formula_1<- cluster_52_frailty_bl ~ factor(genderd) + factor(raracem) +  factor(mstatusd) + factor(racohbyr) + raedyrs +  total_hh_income 
formula_2<- cluster_52_frailty_bl ~ factor(genderd) + factor(raracem) +  factor(mstatusd) + factor(racohbyr) + raedyrs +  total_hh_income + factor(smokev) + factor(vigact) 
formula_3<- cluster_52_frailty_bl ~ factor(genderd) + factor(raracem) +  factor(mstatusd) + factor(racohbyr) + raedyrs +  total_hh_income + factor(smokev) + factor(vigact) + factor(higov)+ factor(priv_cov) 
formula_4<- cluster_52_frailty_bl ~  factor(srhs)
formula_5<- cluster_52_frailty_bl ~  frailty_bl
formula_6<- cluster_52_frailty_bl ~  factor(srhs) + factor(genderd) + factor(raracem) +  factor(mstatusd) + factor(racohbyr) + raedyrs +  total_hh_income + factor(smokev) + factor(vigact) + factor(higov)+ factor(priv_cov)
formula_7<- cluster_52_frailty_bl ~  frailty_bl + factor(genderd) + factor(raracem) +  factor(mstatusd) + factor(racohbyr) + raedyrs +  total_hh_income + factor(smokev) + factor(vigact) + factor(higov)+ factor(priv_cov)
formula_8<- cluster_52_frailty_bl ~  frailty_bl + factor(srhs) + factor(genderd) + factor(raracem) +  factor(mstatusd) + factor(racohbyr) + raedyrs +  total_hh_income + factor(smokev) + factor(vigact) + factor(higov)+ factor(priv_cov)
formula_9<- cluster_52_frailty_bl ~  liv75
formula_10<- cluster_52_frailty_bl ~  frailty_bl+ liv75
formula_11<- cluster_52_frailty_bl ~  adl_index + iadl_index +  ofl_index + diag_index + hosp_index + beh_index
formula_12<- cluster_52_frailty_bl ~  adl_index + iadl_index +  ofl_index + diag_index + hosp_index + beh_index + factor(genderd) + factor(raracem) +  factor(mstatusd) + factor(racohbyr) + raedyrs +  total_hh_income + factor(smokev) + factor(vigact) + factor(higov)+ factor(priv_cov)
formula_13<- cluster_52_frailty_bl ~  liv75 + factor(genderd) + factor(raracem) +  factor(mstatusd) + factor(racohbyr) + raedyrs +  total_hh_income + factor(smokev) + factor(vigact) + factor(higov)+ factor(priv_cov)
formula_14<- cluster_52_frailty_bl ~  frailty_bl+ liv75 + factor(genderd) + factor(raracem) +  factor(mstatusd) + factor(racohbyr) + raedyrs +  total_hh_income + factor(smokev) + factor(vigact) + factor(higov)+ factor(priv_cov)



# Calcualte accuracy 10-fold Cross val
# Seet Seed:
set.seed(123)
#Randomly shuffle the data
yourData<-df5[sample(nrow(df5)),]

#Create 10 equally size folds
folds <- cut(seq(1,nrow(yourData)),breaks=10,labels=FALSE)


# Define accuracy
calculate_accuracy <- function(model, train, test,naive) {
  # Predicting the values for train dataset
  train$ClassPredicted <- predict(model, newdata = train, "class")
  
    # Building classification table
  tab_train <- table(train$cluster_52_frailty_bl, train$ClassPredicted)
  # Calculating accuracy - sum of diagonal elements divided by total obs
  a <- round((sum(diag(tab_train)) / sum(tab_train)) * 100, 5)
  a_1<-tab_train[1, 1] / sum(tab_train[1, ])
  a_2<-tab_train[2, 2] / sum(tab_train[2, ])
  a_3<-tab_train[3, 3] / sum(tab_train[3, ])
  a_4<-tab_train[4, 4] / sum(tab_train[4, ])
  a_5<-tab_train[5, 5] / sum(tab_train[5, ])
  
  #####            Predicting the values for test dataset   #############################
  test$ClassPredicted <- predict(model, newdata = test, "class")
  
  tab_test_acc <- table(test$cluster_52_frailty_bl, test$ClassPredicted)
  # Calculating accuracy - sum of diagonal elements divided by total obs
  v_acc <- round((sum(diag(tab_test_acc)) / sum(tab_test_acc)) * 100, 5)
  v_acc_1<-tab_test_acc[1, 1] / sum(tab_test_acc[1, ])
  v_acc_2<-tab_test_acc[2, 2] / sum(tab_test_acc[2, ])
  v_acc_3<-tab_test_acc[3, 3] / sum(tab_test_acc[3, ])
  v_acc_4<-tab_test_acc[4, 4] / sum(tab_test_acc[4, ])
  v_acc_5<-tab_test_acc[5, 5] / sum(tab_test_acc[5, ])
  
  
  # Predict probability of belonging to different health types in the test data
  prob_predict <- predict(model, newdata = test, "prob")
  
  #Calculate Accuracy based on these probabilities
  
  e_p <- round(prob_predict,10)
  e_n <- test %>% ungroup() %>% select(rahhidpn,cluster_52_frailty_bl)
  e_1 <- cbind(e_n,e_p)
  ## Expand data by 1000
  names(e_1) <- c("rahhidpn","cluster_52_frailty_bl","type1","type2","type3","type4","type5")
  
  
  if (naive==1){
    #Naive =1 means types are uniformly distribute
  #Compute thresholds
  thresholds<- e_1 %>% mutate(interval_1=0.2,
                              interval_2=interval_1 + 0.2,
                              interval_3=interval_2 + 0.2,
                              interval_4=interval_3 + 0.2,
                              interval_5=interval_4 + 0.2)
  }

  if (naive==0){
    #Compute thresholds
    #Naive =0 means types are  distribute as in the data
    thresholds<- e_1 %>% mutate(interval_1=type1,
                                interval_2=interval_1 + type2,
                                interval_3=interval_2 + type3,
                                interval_4=interval_3 + type4,
                                interval_5=interval_4 + type5)
  }
  
  N <- 100
  # Expand e_1 by repeating each row N times
  thresholds <- thresholds %>%
    slice(rep(row_number(), each = N))
  
  
  #Generate random states
  thresholds$random_state<-runif(length(thresholds$rahhidpn))
  
  
  # Assigment
  thresholds <- thresholds %>% 
    mutate(Type_1 = ifelse(random_state<=interval_1,1,0),
           Type_2 = ifelse(random_state<=interval_2 & random_state>interval_1,1,0),
           Type_3 = ifelse(random_state<=interval_3 & random_state>interval_2,1,0),
           Type_4 = ifelse(random_state<=interval_4 & random_state>interval_3,1,0),
           Type_5 = ifelse(random_state<=interval_5 & random_state>interval_4,1,0),
           class_predicted = ifelse(Type_1==1,1,
                                    ifelse(Type_2==1,2,
                                           ifelse(Type_3==1,3,
                                                  ifelse(Type_4==1,4,
                                                         ifelse(Type_5==1,5,NA))))))
  
  final_data<-thresholds %>% select("rahhidpn","cluster_52_frailty_bl","class_predicted") 
  
  # Building classification table
  tab_test <- table(final_data$cluster_52_frailty_bl, final_data$class_predicted)
  # Calculating accuracy - sum of diagonal elements divided by total obs
  v <- round((sum(diag(tab_test)) / sum(tab_test)) * 100, 5)
  v_1<-tab_test[1, 1] / sum(tab_test[1, ])
  v_2<-tab_test[2, 2] / sum(tab_test[2, ])
  v_3<-tab_test[3, 3] / sum(tab_test[3, ])
  v_4<-tab_test[4, 4] / sum(tab_test[4, ])
  v_5<-tab_test[5, 5] / sum(tab_test[5, ])
  
  return(list(a = a,a_1=a_1,a_2=a_2,a_3=a_3,a_4=a_4,a_5=a_5, 
              v = v,v_1=v_1,v_2=v_2,v_3=v_3,v_4=v_4,v_5=v_5,
              v_acc=v_acc, v_acc_1=v_acc_1,v_acc_2=v_acc_2,v_acc_3=v_acc_3,v_acc_4=v_acc_4,v_acc_5=v_acc_5))
}


#Perform 10 fold cross validation

#Number of models
pp<-14

# Initialize matrices to store results
n_obs_matrix <- matrix(NA, nrow = 1, ncol = pp)
log_likelihood_matrix <- matrix(NA, nrow = 1, ncol = pp)
pseudo_r2_matrix <- matrix(NA, nrow = 1, ncol = pp)
aic_matrix <- matrix(NA, nrow = 1, ncol = pp)
bic_matrix <- matrix(NA, nrow = 1, ncol = pp)
accuracy_train<- matrix(NA, nrow = 1, ncol = pp)

accuracy_test_acc<- matrix(NA, nrow = 1, ncol = pp)
accuracy_test_acc_v1<- matrix(NA, nrow = 1, ncol = pp)
accuracy_test_acc_v2<- matrix(NA, nrow = 1, ncol = pp)
accuracy_test_acc_v3<- matrix(NA, nrow = 1, ncol = pp)
accuracy_test_acc_v4<- matrix(NA, nrow = 1, ncol = pp)
accuracy_test_acc_v5<- matrix(NA, nrow = 1, ncol = pp)

accuracy_test<- matrix(NA, nrow = 1, ncol = pp)
accuracy_test_v1<- matrix(NA, nrow = 1, ncol = pp)
accuracy_test_v2<- matrix(NA, nrow = 1, ncol = pp)
accuracy_test_v3<- matrix(NA, nrow = 1, ncol = pp)
accuracy_test_v4<- matrix(NA, nrow = 1, ncol = pp)
accuracy_test_v5<- matrix(NA, nrow = 1, ncol = pp)
Formulas <- vector("list", length = pp)

# Fit the models and store results
for (i in 1:pp) {
  # Fit the model
  formula_to_run <- get(paste0("formula_", i))
  k<-i

  model_full <- multinom(formula_to_run,model=TRUE, data = df5, maxit = 5000)
  
    # Number of observations
  n_obs <- nrow(model_full$fitted.values)
  n_obs_matrix[1, k] <- n_obs
  
  # Log-likelihood
  log_likelihood <- logLik(model_full)
  log_likelihood_matrix[1, k] <- log_likelihood
  
  # Pseudo R-squared (McFadden's R-squared)
  PseudoR2_model <- PseudoR2(model_full, which = NULL)
  pseudo_r2_matrix[1, k] <- PseudoR2_model
  
  # AIC
  aic_value <- AIC(model_full)
  aic_matrix[1, k] <- aic_value
  
  # BIC
  bic_value <- BIC(model_full)
  bic_matrix[1, k] <- bic_value
  
  
  ## Estimate Accuracy
  accuracy_test_10_fold <- matrix(NA, nrow = 1, ncol = 10)
  accuracy_test_10_fold_v1<- matrix(NA, nrow = 1, ncol = 10)
  accuracy_test_10_fold_v2<- matrix(NA, nrow = 1, ncol = 10)
  accuracy_test_10_fold_v3<- matrix(NA, nrow = 1, ncol = 10)
  accuracy_test_10_fold_v4<- matrix(NA, nrow = 1, ncol = 10)
  accuracy_test_10_fold_v5<- matrix(NA, nrow = 1, ncol = 10)
  accuracy_train_10_fold <- matrix(NA, nrow = 1, ncol = 10)

  accuracy_test_10_fold_acc <- matrix(NA, nrow = 1, ncol = 10)
  accuracy_test_10_fold_acc_v1<- matrix(NA, nrow = 1, ncol = 10)
  accuracy_test_10_fold_acc_v2<- matrix(NA, nrow = 1, ncol = 10)
  accuracy_test_10_fold_acc_v3<- matrix(NA, nrow = 1, ncol = 10)
  accuracy_test_10_fold_acc_v4<- matrix(NA, nrow = 1, ncol = 10)
  accuracy_test_10_fold_acc_v5<- matrix(NA, nrow = 1, ncol = 10)
    
  for(j in 1:10){
    #Segement your data by fold using the which() function 
    testIndexes <- which(folds==j,arr.ind=TRUE)
    testData <- yourData[testIndexes, ]
    trainData <- yourData[-testIndexes, ]
    #Use the test and train data partitions however you desire...
    
    model_for_accuracy <- multinom(formula_to_run,model=TRUE, data = trainData, maxit = 5000)

    Naive<-0
    result <- calculate_accuracy(model_for_accuracy, trainData, testData,Naive)
    a <- result$a
    v <- result$v
    
    accuracy_train_10_fold[1,j]<- a
    accuracy_test_10_fold[1,j]<- v
    accuracy_test_10_fold_v1[1,j]<- result$v_1
    accuracy_test_10_fold_v2[1,j]<- result$v_2
    accuracy_test_10_fold_v3[1,j]<- result$v_3
    accuracy_test_10_fold_v4[1,j]<- result$v_4
    accuracy_test_10_fold_v5[1,j]<- result$v_5
    
    accuracy_test_10_fold_acc[1,j]<- result$v_acc
    accuracy_test_10_fold_acc_v1[1,j]<- result$v_acc_1
    accuracy_test_10_fold_acc_v2[1,j]<- result$v_acc_2
    accuracy_test_10_fold_acc_v3[1,j]<- result$v_acc_3
    accuracy_test_10_fold_acc_v4[1,j]<- result$v_acc_4
    accuracy_test_10_fold_acc_v5[1,j]<- result$v_acc_5
    
    
  }
  

  accuracy_train[1,k]<- mean(accuracy_train_10_fold)
  accuracy_test[1,k]<- mean(accuracy_test_10_fold)
  accuracy_test_v1[1,k]<- mean(accuracy_test_10_fold_v1)
  accuracy_test_v2[1,k]<- mean(accuracy_test_10_fold_v2)
  accuracy_test_v3[1,k]<- mean(accuracy_test_10_fold_v3)
  accuracy_test_v4[1,k]<- mean(accuracy_test_10_fold_v4)
  accuracy_test_v5[1,k]<- mean(accuracy_test_10_fold_v5)
  accuracy_test_acc[1,k]<- mean(accuracy_test_10_fold_acc)
  accuracy_test_acc_v1[1,k]<- mean(accuracy_test_10_fold_acc_v1)
  accuracy_test_acc_v2[1,k]<- mean(accuracy_test_10_fold_acc_v2)
  accuracy_test_acc_v3[1,k]<- mean(accuracy_test_10_fold_acc_v3)
  accuracy_test_acc_v4[1,k]<- mean(accuracy_test_10_fold_acc_v4)
  accuracy_test_acc_v5[1,k]<- mean(accuracy_test_10_fold_acc_v5)
  
  
  Formulas[[k]] <- formula_to_run

}


# Transpose matrices
n_obs_matrix <- t(n_obs_matrix)
log_likelihood_matrix <- t(log_likelihood_matrix)
pseudo_r2_matrix <- t(pseudo_r2_matrix)
aic_matrix <- t(aic_matrix)
bic_matrix <- t(bic_matrix)
accuracy_train <- t(accuracy_train)
accuracy_test <- t(accuracy_test)
accuracy_test_v1 <- t(accuracy_test_v1)
accuracy_test_v2 <- t(accuracy_test_v2)
accuracy_test_v3 <- t(accuracy_test_v3)
accuracy_test_v4 <- t(accuracy_test_v4)
accuracy_test_v5 <- t(accuracy_test_v5)

accuracy_test_acc <- t(accuracy_test_acc)
accuracy_test_acc_v1 <- t(accuracy_test_acc_v1)
accuracy_test_acc_v2 <- t(accuracy_test_acc_v2)
accuracy_test_acc_v3 <- t(accuracy_test_acc_v3)
accuracy_test_acc_v4 <- t(accuracy_test_acc_v4)
accuracy_test_acc_v5 <- t(accuracy_test_acc_v5)


formulas_as_strings <- sapply(Formulas, as.character)

# Create a dataframe with formulas
formulas_df <- data.frame(Formulas = formulas_as_strings)
formulas_df <- formulas_df[3,] 
formulas_df<-t(formulas_df)

# Combine results into a dataframe
results_df <- data.frame(
  Model = paste0("Model ", 1:pp),
  Observations = n_obs_matrix[, 1],
  LogLikelihood = log_likelihood_matrix[, 1],
  PseudoR2 = pseudo_r2_matrix[, 1],
  AIC = aic_matrix[, 1],
  BIC = bic_matrix[, 1],
  Acc_train = accuracy_train[,1],
  Acc_test_acc = accuracy_test_acc[,1],
  Acc_test_acc_v1 = accuracy_test_acc_v1[,1],
  Acc_test_acc_v2 = accuracy_test_acc_v2[,1],
  Acc_test_acc_v3 = accuracy_test_acc_v3[,1],
  Acc_test_acc_v4 = accuracy_test_acc_v4[,1],
  Acc_test_acc_v5 = accuracy_test_acc_v5[,1],
  Acc_test = accuracy_test[,1],
  Acc_test_v1 = accuracy_test_v1[,1],
  Acc_test_v2 = accuracy_test_v2[,1],
  Acc_test_v3 = accuracy_test_v3[,1],
  Acc_test_v4 = accuracy_test_v4[,1],
  Acc_test_v5 = accuracy_test_v5[,1],
  Formulas = formulas_df[,1]
)

# Print the results
print(results_df)


# Define file paths
file_path_excel <- "output/Part2_output/Part2_j_mlogit/model_statistics.xlsx"
file_path_csv <- "output/Part2_output/Part2_j_mlogit/model_statistics.csv"

# Write dataframe to Excel file
write.xlsx(results_df, file_path_excel, rowNames = FALSE)

# Write dataframe to CSV file
write.csv(results_df, file_path_csv, row.names = FALSE)

#########################################################

###############################################################################
# Table  5
###############################################################################
# Define Pseudo-R^2 values
pr2_mod1 <- round(results_df$PseudoR2[3], 3)
pr2_mod2 <- round(results_df$PseudoR2[5], 3)
pr2_mod3 <- round(results_df$PseudoR2[7], 3)

# Create the table data as a data frame
table_data <- data.frame(
  Category = c("\\textit{Initial frailty}", "\\textit{Demographics}", "\\textit{Health behaviours}", "\\textit{Health insurance}", "Pseudo-$R^2$"),
  Mod1 = c("", "x", "x", "x", pr2_mod1),
  Mod2 = c("x", "", "", "", pr2_mod2),
  Mod3 = c("x", "x", "x", "x", pr2_mod3)
)

# Convert the data frame to a LaTeX table
tab5 <- kable(
  table_data, 
  format = "latex", 
  booktabs = TRUE, 
  escape = FALSE,  # Allow LaTeX formatting
  align = c("l", "c", "c", "c"),  # Align first column left, others center
  col.names = c("", "(1)", "(2)", "(3)")
) %>%
  add_header_above(c(" " = 1, "Health types" = 3)) %>%
  kable_styling(latex_options = c("hold_position"), full_width = FALSE) %>%
  row_spec(4, hline_after = TRUE)  # Add a horizontal line above "Pseudo-$R^2$"

# Post-process the LaTeX output to fix `\midrule`
tab5 <- gsub("\\\\midrule\\\\\\\\", "\\\\midrule", tab5)

# Export the LaTeX table to a .tex file
writeLines(tab5, "output/Part2_output/Part2_j_mlogit/tab5.tex")

################################################################################
# Appendix G: Table 14
################################################################################
# Define Pseudo-R^2 values
pr2_mod1 <- round(results_df$PseudoR2[5], 3)
pr2_mod2 <- round(results_df$PseudoR2[11], 3)
pr2_mod3 <- round(results_df$PseudoR2[7], 3)
pr2_mod4 <- round(results_df$PseudoR2[12], 3)

# Define the table data as a data frame
table_data <- data.frame(
  Category = c(
    "\\textit{Initial frailty}",
    "\\textit{Initial frailty composition}",
    "\\textit{Demographics}",
    "\\textit{Health behaviours}",
    "\\textit{Health insurance}",
    "Pseudo-$R^2$"
  ),
  Mod1 = c("x", "", "", "", "", pr2_mod1),
  Mod2 = c("", "x", "", "", "", pr2_mod2),
  Mod3 = c("x", "", "x", "x", "x", pr2_mod3),
  Mod4 = c("", "x", "x", "x", "x", pr2_mod4)
)

# Create the LaTeX table
tab <- kable(
  table_data, 
  format = "latex", 
  booktabs = TRUE, 
  escape = FALSE, 
  align = c("l", "c", "c", "c", "c"),  # First column left-aligned, others centered
  col.names = c("", "(1)", "(2)", "(3)", "(4)")  # Model column names
) %>%
  add_header_above(c(" " = 1, "Health types" = 4)) %>%  # Header for Health Types
  kable_styling(latex_options = c("hold_position"), full_width = FALSE) %>%
  row_spec(5, hline_after = TRUE)  # Add \hline above Pseudo-$R^2$

# Post-process the LaTeX output to fix \midrule (if needed)
tab <- gsub("\\\\midrule\\\\\\\\", "\\\\midrule", tab)

# Export the LaTeX table to a .tex file
writeLines(tab, "output/Part2_output/Part2_j_mlogit/tab14.tex")


end_time <- Sys.time()
runtime <- end_time-start_time
print(runtime)

#Clear enviroment
rm(list = setdiff(ls(), c(to_keep)))

