## This master code produce all the result of "Health Inequality and Health Types"
## by Margherita Borella, Francisco Bullano, Mariacristina De Nardi,
## Benjamin Krueger, and Elena Manresa.

# This version of the code: 02/01/2025

# Note: Before running this code, run /ccodes/Master_Stata.do
# That will create the following datasets:
# /dtafiles/CleanPanelBalanced.dta
# /dtafiles/SelfProbDying.dta
# /dtafiles/DeathCause.dta
# Refer to the /ReadMe.pdf file to get all necessary inputs to run /ccodes/Master_Stata.do



# The code is structure as follows:
# This main code will call sub routines that will produce specific results.
# The main code is structure in 3 parts.

# Part 1: Setting directories and installing all require R.Packages
# Part 2: Get all results from the paper except for Section 5
# Part 3: Get results for Section 5: Health types and implications for health dynamics



# Clear console
rm(list = ls()) 
cat("\014")  # ctrl+L

start.time <- Sys.time()



############################   Part 1: Start   ###################################
############################                 ###################################
################################################################################
# Set directory
# main_path -> Include path for the Replication Package folder
main_path <- "   " #Insert path here
data_path <-    paste0(main_path,"/dtafiles")
raw_data_path <-    paste0(main_path,"/rawdata")
code_path <-    paste0(main_path,"/acodes")
code_path_p1 <- paste0(code_path,"/Part1")
code_path_p2 <- paste0(code_path,"/Part2")
code_path_p3 <- paste0(code_path,"/Part3")

# Conditional EPS export: eps=1 export figures in eps as well.
eps<-1

setwd(main_path)


# If this is the first time runing the code, set intall_lib==1 and get all needed packages.
# If already installed, set intall_lib==0

# Install relevant libraries 
intall_lib<-0
if (intall_lib==1) {
setwd(code_path_p1)
source("Install_Libraries.R")
setwd(main_path)
}

# Import relevant libraries. 
import_lib<-1
if (import_lib==1) {
  setwd(code_path_p1)
  source("Import_Libraries.R")
  setwd(main_path)
}

############################   Part 1: End   ###################################
############################                 ###################################
################################################################################


############################  Part 2: Start  ###################################
############################                 ###################################
################################################################################
## Part 2: Get Main results of the paper
setwd(code_path_p2)
source("Part2_main_code.R")
# This R file is divided into 10 sub-routines. Open Part2_main_code.r for a description 
# of each of them and relevant outputs.

# a) Clustering
# b) Health dynamics by cluster
# c) Cross-validation
# d) Health type and observable characteristics
# e) Individual frailty dynamics (Heat maps)
# f) Deficits prevalence analysis
# g) Out-of-sample predictive exercise
# h) Cause of death
# i) Distribution of frailty
# j) Predicting health types

############################   Part 2: End   ###################################
############################                 ###################################
################################################################################


############################  Part 3: Start  ###################################
############################                 ###################################
################################################################################
## Part 3: Implication for Health dynamics
setwd(code_path_p3)
source("Part3_main_code.R")
# This R file is divided into 3 sub-routines. Open Part3_main_code.R for a description 
# of each of them and relevant outputs.

# a) Prepare data
# b) Test for health types in models for health dynamics
# c) Implications for health dynamics: Simulations

############################   Part 3: End   ###################################
############################                 ###################################
################################################################################

end.time <- Sys.time()
time.taken <- end.time - start.time
print(time.taken)