# delimit;
set more 1;
capture log close;

log using output.log, replace;
drop _all;

use dataratio;

sort lcode bcode;
encode lcode, gen(lcodeid);
encode bcode, gen(bcodeid);

iis bcodeid;
tis lcodeid;


*table 3, column 3;
xi: reg llon9496  gcrhyb  inveasy lgdp9496 lpc9496 ldist ling stddbix inf9193 grow9193 gexp9193 i.lcode;

*table  4, column 1;
xi: reg ratio  gcrhyb taxall incen restrict  lgdp9496 lpc9496 ldist ling stddbix  i.lcode;

*table  4, column 2;
xi: xtreg ratio  gcrhyb taxall incen restrict  lgdp9496 lpc9496 ldist ling stddbix  i.lcode, re;

*table  4, column 3;
xi: reg ratio ti taxall incen restrict  lgdp9496 lpc9496 ldist ling stddbix  i.lcode;

*table  4, column 4;
xi: xtreg ratio ti taxall incen restrict  lgdp9496 lpc9496 ldist ling stddbix  i.lcode, re;

*table  4, column 6;
quietly xi: ivreg ratio incen restrict lgdp9496 lpc9496 ldist ling stddbix i.lcode (gcrhyb= efl leg_fren leg_germ leg_scan leg_soci);
gen spiv=e(sample);

*first-stage regression;
reg gcrhyb efl leg_fren leg_germ leg_scan leg_soci if spiv==1;
predict double gcrhhat if spiv==1;
*second-stage regression;
xi: reg ratio gcrhhat incen restrict lgdp9496 lpc9496 ldist ling stddbix i.lcode if spiv==1;

*correct the variabnce-covariance by applying the correct MSE;
rename gcrhhat gcrho;
rename gcrhyb gcrhhat;

predict double res if spiv==1, residual;
rename gcrhhat gcrhyb;
rename gcrho gcrhhat;

replace res=res^2 if spiv==1;
sum res;
scalar realmse=r(mean)*r(N)/e(df_r);

matrix bmatrix = e(b);
matrix Vmatrix = e(V);
matrix Vmatrix = e(V) * realmse / e(rmse)^2;


/* e-class program to post out adjusted matrix */
capture program drop postit;
program define postit, eclass;
	ereturn post bmatrix Vmatrix, noclear;
end;
postit;

ereturn display;

*test of over-identifying restriction;
xi: reg ratio gcrhhat incen restrict lgdp9496 lpc9496 ldist ling stddbix i.lcode if spiv==1;
predict ehat, resid;
reg ehat efl leg_fren leg_germ leg_scan leg_soci;
scalar trrsq=_result(1)*_result(7);
scalar pippo=chiprob(4,trrsq);
display pippo;

