/*
Dynare code for Paper "Trade Reforms And Current Account Imbalances"
Date: Feb. 2020
Objective: To compute the transition path under credit constraint
*/

//**************  Mian Part of Perfect Foresight Model  ******************

var y c i k b d x1 x2 r w p1 p2 p Lam Ome r1 r2 k1 k2;
 
varexo a1 a2 tau1 tau2;

parameters beta gamma alpha1 alpha2 omega psib delta psi l psik rstar 
wstar cbar bbar muk p1star p2star;

load('param.mat');
load('exo_cr.mat');
load('end_cr.mat');

beta    = parameter(1);  
gamma   = parameter(2);
alpha1  = parameter(3);
alpha2  = parameter(4);
omega   = parameter(5);
psib    = parameter(6);
delta   = parameter(7);
psi     = parameter(8);
l       = parameter(9);
psik    = parameter(10);
rstar   = parameter(11);
wstar   = parameter(12);
cbar    = parameter(13);
bbar    = parameter(14);

muk = 0.434;
p1star = wstar^(1-alpha1)* rstar^alpha1;
p2star = wstar^(1-alpha2)* rstar^alpha2;

model;
// 1. FOC with Consumption
c^(-gamma)/p = Ome ;

// 2. FOC with Inv.
Lam * (1- psik * (i/k(-1)-delta))=Ome;

// 3. FOC with K_t+1
Lam = beta * (c/y)^(-psi) * cbar^psi * ( Lam(+1) * ( 1-delta + 
psik/2 *(i(+1)/k-delta)*(i(+1)/k+delta) ) + Ome(+1) * r(+1) );

// 4. Euler equation
Ome * (1 + psib * p * (b-bbar)) = (c/y)^(-psi) * cbar^psi 
* Ome(+1);

//r = rstar * ( (a1/a2)^((1-alpha1)*(1-alpha2))/ ((1+tau1)^(1-alpha2)*(1+tau2)^(1-alpha1)) )^(1/(alpha1-alpha2));
//w = wstar * ( a1^((1-alpha1)* alpha2) / ( a2^((1-alpha2)* alpha1) )/ ( (1+tau1)^alpha2*(1+tau2)^alpha1) )^(1/(alpha2-alpha1));

// 5. Export price
p1 = p1star/(1+tau1);

// 6. Import price
p2 = p2star* (1+tau2);

// 7. Home sectoral price
p1 = (w/a1)^(1-alpha1) * r1^alpha1 ;

// 8. Home sectoral price
p2 = (w/a2)^(1-alpha2) * r2^alpha2 ;

// 9. Home aggregate price
p = p1^omega * p2^(1-omega) ;

//alpha1 * p1 * x1 + alpha2 * p2 * x2 = r * k(-1) ;

// 10. Return to cap for sector 1
alpha1 * p1 * x1 = r1 * k1 ;

// 11. Return to cap for sector 2
alpha2 * p2 * x2 = r2 * k2 ;

// 12. Cap market clearing
k(-1) = k1 + k2;

// 13. Average cap rent
r = muk * r1 + (1-muk) * r2 ;

// 14. Financial friction
k1 / k2 = muk / (1-muk);

// 15. Return to labor
(1-alpha1) * p1 * x1 + (1-alpha2) * p2 * x2 = w * l ;

// 16. Law of motion for cap
k = k(-1) * (1-delta) + i - 1/2 * psik * (i/k(-1)-delta)^2 * k(-1);

// 17. Final goods clearing
d = c + i/p + psib/2 * (b-bbar)^2;

// 18. Budget constraint
p1 * x1 * (1+tau1) + p2 * x2 / (1+tau2) + (1/beta-1) * b(-1)
= p * d * ( omega * (1+tau1) + (1-omega)/ (1+tau2) ) + b - b(-1) ;

// 19. Define GDP    
p * y = p1 * x1 + p2 * x2 ;

end;

initval;
a1      = exovar(1,1);
a2      = exovar(2,1);
tau1    = exovar(3,1);
tau2    = exovar(4,1);

y       = endvar(1,1) ;
c       = endvar(2,1) ; 
i       = endvar(3,1) ;
k       = endvar(4,1) ;
b       = endvar(5,1) ;
d       = endvar(6,1) ;
x1      = endvar(7,1) ;
x2      = endvar(8,1) ;
r       = endvar(9,1) ;
w       = endvar(10,1) ;
p1      = endvar(11,1) ;
p2      = endvar(12,1) ;
p       = endvar(13,1) ;
Ome     = endvar(14,1) ;
Lam     = endvar(15,1) ;
r1      = endvar(16,1) ;
r2      = endvar(17,1) ;
k1      = endvar(18,1) ;
k2      = endvar(19,1) ;
end;
steady;

endval;
a1      = exovar(1,2);
a2      = exovar(2,2);
tau1    = exovar(3,2);
tau2    = exovar(4,2);

y       = endvar(1,2) ;
c       = endvar(2,2) ;
i       = endvar(3,2) ;
k       = endvar(4,2) ;
b       = endvar(5,2) ;
d       = endvar(6,2) ;
x1      = endvar(7,2) ;
x2      = endvar(8,2) ;
r       = endvar(9,2) ;
w       = endvar(10,2) ;
p1      = endvar(11,2) ;
p2      = endvar(12,2) ;
p       = endvar(13,2) ;
Ome     = endvar(14,2) ;
Lam     = endvar(15,2) ;
r1      = endvar(16,2) ;
r2      = endvar(17,2) ;
k1      = endvar(18,2) ;
k2      = endvar(19,2) ;
end;
steady;

check;

simul(periods = 500);

dynasave('simul_credit_result');

// Plot key charts
t = 40;
tau1_s = oo_.exo_simul(:,3);
tau2_s = oo_.exo_simul(:,4);

l1 = (1-alpha1).* p1.* x1./ w;
l2 = (1-alpha2).* p2.* x2./ w;
sx = (p1.* x1 - omega.* p.* d)./ (p1.* x1 + p2.* x2);
sm = (p2.* x2 - (1-omega).* p.* d)./ (p1.* x1 + p2.* x2);
tv2gdp = abs(sx.*(1+tau1_s)) + abs(sm./(1+tau2_s));
tb2gdp = sx.*(1+tau1_s) + sm./(1+tau2_s);
b2gdp  = b./ (y.* p);
ca     = b - lagmatrix(b,1);
ca(1)  = 0;
ca2gdp = ca./ (y.* p);
i2gdp  = i./ (y.* p) ;
s2gdp  = (i + ca)./ (y.* p) ;

endvar2 = [y c k i r1 r2 w w k1 k2 l1 l2 x1 x2 sx sm];

titles = {'Y','C','K','I','r1','r2','w1','w2','K1','K2',...
          'L1','L2','X1','X2','sx','sm'};
   
figure();
for itr = 1:16  
subplot(4,4,itr);
h = plot(endvar2(1:t,itr),'-b','LineWidth',1.5);
title(titles(itr));
end 

figure();
subplot(221)
plot(tv2gdp(1:t),'b-','LineWidth',2.5);
xlabel('Quarters');
ylabel('Trade Volume/GDP');
set(gca, 'XLim',[1,t]);
title('Trade Volume/GDP ');

subplot(222)
plot(ca2gdp(1:t),'b-','LineWidth',2.5);
hold on;
plot(tb2gdp(1:t),'r--','LineWidth',2.5);
legend('CA/GDP','TB/GDP');
xlabel('Quarters');
ylabel('CA/GDP(TB/GDP)');
set(gca, 'XLim',[1,t]);
title('Trade Balance/GDP & Current Account/GDP');

subplot(223)
plot(s2gdp(1:t),'b-','LineWidth',2.5);
hold on;
plot(i2gdp(1:t),'r--','LineWidth',2.5);
legend('S/GDP','I/GDP');
xlabel('Quarters');
ylabel('S/GDP(I/GDP)');
set(gca, 'XLim',[1,t]);
title('Saving/GDP & Investment/GDP');

subplot(224)
plot(b2gdp(1:t),'b-','LineWidth',2.5);
xlabel('Quarters');
ylabel('B/GDP');
set(gca, 'XLim',[1,t]);
title('Foreign Asset/GDP');
