function F = Findss(var,parm)

% Parameters
beta    = parm(1);  
gamma   = parm(2);
alpha1  = parm(3);
alpha2  = parm(4);
omega   = parm(5);
psib    = parm(6);
delta   = parm(7);
psi     = parm(8);
l       = parm(9);
psik    = parm(10);
rstar   = parm(11);
wstar   = parm(12);
cbar    = parm(13);
bbar    = parm(14);
a1      = parm(15);
a2      = parm(16);
tau1    = parm(17);
tau2    = parm(18);

% Endogenous variables
y       = var(1);
c       = var(2);
i       = var(3);
k       = var(4);
b       = var(5);
d       = var(6);
x1      = var(7);
x2      = var(8);
r       = var(9);
w       = var(10);
p1      = var(11);
p2      = var(12);
p       = var(13);
Ome     = var(14);
Lam     = var(15);

% Equations at SS

F(1) = c.^(-gamma)./ p - Ome;

F(2) = Lam.* (1- psik.* (i/k-delta))- Ome;

F(3) = beta.* (c./y)^(-psi).* cbar.^psi * ( Lam.* ( 1-delta + ... 
psik./2.*(i./k-delta).*(i./k+delta) ) + Ome.* r ) - Lam;

F(4) = Ome.* (1+ psib.* p.* (b-bbar)) - (c/y).^(-psi).* cbar.^psi ... 
.* Ome;

F(5) = r - rstar.* ( (a1/a2).^((1-alpha1).*(1-alpha2))...
    ./ ((1+tau1).^(1-alpha2).*(1+tau2).^(1-alpha1)) ).^(1/(alpha1-alpha2));

F(6) = w - wstar.* ( a1.^((1-alpha1).* alpha2)...
    ./ ( a2.^((1-alpha2).* alpha1) )...
    ./ ( (1+tau1).^alpha2.*(1+tau2).^alpha1) ).^(1/(alpha2-alpha1));

F(7) = p1 - (w/a1).^(1-alpha1).* r.^alpha1 ;

F(8) = p2 - (w/a2).^(1-alpha2).* r.^alpha2 ;

F(9) = p - p1.^omega .* p2.^(1-omega) ;

F(10) = alpha1.* p1.* x1 + alpha2.* p2.* x2 - r.* k ;

F(11) = (1-alpha1).* p1.* x1 + (1-alpha2).* p2.* x2 - w.* l ;

F(12) = k.* (1-delta) + i - psik/2.* (i./k - delta).^2 .* k - k;

F(13) = c + i./p + psib/2.* (b-bbar).^2 - d ;

F(14) = p1.* x1.* (1+tau1) + p2.* x2./ (1+tau2) + (1/beta-1).* b ...
        - p.* d.* ( omega.* (1+tau1) + (1-omega)./ (1+tau2) ) ;
    
F(15) = p.* y - p1.* x1 - p2.* x2 ;




% F(1) = c.^(-gamma)./ p - Ome;
% 
% F(2) = Lam.* (1- psik.* (i/k-delta))- Ome;
% 
% F(3) = beta.* (c./y)^(-psi).* cbar.^psi * ( Lam.* ( 1-delta + ... 
% psik./2.*(i./k-delta).*(i./k+delta) ) + Ome.* r ) - Lam;
% 
% F(4) = Ome.* (1+ psib.* p.* (b-bbar)) - beta.* (c/y).^(-psi).* cbar.^psi ... 
% .* Ome.* (1+ rstar);
% 
% F(5) = r - rstar.* ( (a1/a2).^((1-alpha1).*(1-alpha2))...
%     ./ ((1+tau1).^(1-alpha2).*(1+tau2).^(1-alpha1)) ).^(1/(alpha1-alpha2));
% 
% F(6) = w - wstar.* ( a1.^((1-alpha1).* alpha2)...
%     ./ ( a2.^((1-alpha2).* alpha1) )...
%     ./ ( (1+tau1).^alpha2.*(1+tau2).^alpha1) ).^(1/(alpha2-alpha1));
% 
% F(7) = p1 - (w/a1).^(1-alpha1).* r.^alpha1 ;
% 
% F(8) = p2 - (w/a2).^(1-alpha2).* r.^alpha2 ;
% 
% F(9) = p - p1.^omega .* p2.^(1-omega) ;
% 
% F(10) = alpha1.* p1.* x1 + alpha2.* p2.* x2 - r.* k ;
% 
% F(11) = (1-alpha1).* p1.* x1 + (1-alpha2).* p2.* x2 - w.* l ;
% 
% F(12) = k.* (1-delta) + i - psik/2.* (i./k - delta).^2 .* k - k;
% 
% F(13) = c + i./p + psib/2.* (b-bbar).^2 - d ;
% 
% F(14) = p1.* x1.* (1+tau1) + p2.* x2./ (1+tau2) + rstar.* b ...
%         - p.* d.* ( omega.* (1+tau1) + (1-omega)./ (1+tau2) ) ;
%     
% F(15) = p.* y - p1.* x1 - p2.* x2 ;

end






