/* This program replicates Table 5 in Wei and Zhang (NBER WP 12667) */

* load database jde.dta, available from Shang-Jin Wei's NBER website

set more off

/* 1.1 keep cty with prog but without TC, and cty with TC between 96 and 2000 */
 keep if cty1==913 |  cty1==223 |  cty1==628 |  cty1==233 |  cty1==238 |  cty1==935 |  cty1==611 |  cty1==321 |  cty1==243 /*
*/ |  cty1==253 |  cty1==258 |  cty1==542 |  cty1==273 |  cty1==853 |  cty1==293 |  cty1==964 |  cty1==724 |  cty1==936 /*
*/ |  cty1==578 |  cty1==742 |  cty1==299 |  cty1==923 |  cty1==915 |  cty1==738 |  cty1==648 |  cty1==688 /*
*/ |  cty1==624	|  cty1==918 |  cty1==678 |  cty1==714 |  cty1==662 |  cty1==754 |  cty1==213 |  cty1==218 |  cty1==694 /*
*/ |  cty1==656 |  cty1==716 |  cty1==622	|  cty1==960 |  cty1==298 |  cty1==692 |  cty1==674	|  cty1==968 |  cty1==536 /*
*/ |  cty1==939	|  cty1==474 |  cty1==944 |  cty1==963 

tab cty1, gen(_Icty1)
tab cty2, gen(_Icty2)
tab year, gen(_Iyear)

/* 1.2 run regressions with TC dummies*/

global x1 " wto1 wto2 border colony comcol comlang custrict ldist regional lrgdp_i lrgdp_e lpop_i lpop_e "
reg impo tc_im $x1 _Icty1* _Icty2* _Iyear*, cluster(pairid)
outreg tc_im $x1 using "U:\Scripts\table5.txt", se noaster nocon replace bracket

global x1 "prog post_prog  wto1 wto2 border colony comcol comlang custrict ldist regional lrgdp_i lrgdp_e lpop_i lpop_e "
reg impo tc_im $x1 _Icty1* _Icty2* _Iyear* , cluster(pairid)
outreg tc_im $x1 using "U:\Scripts\table5.txt", se noaster  nocon append

global x1 "rer rer_BI prog post_prog  wto1 wto2 border colony comcol comlang custrict ldist regional lrgdp_i lrgdp_e lpop_i lpop_e "
reg impo tc_im $x1 _Icty1* _Icty2* _Iyear*, cluster(pairid)
outreg tc_im $x1 using "U:\Scripts\table5.txt", se noaster  nocon append

global x1 "mymills impohat  wto1 wto2 border colony comcol comlang custrict ldist regional lrgdp_i lrgdp_e lpop_i lpop_e "
reg impo tc_im $x1 _Icty1* _Icty2* _Iyear*, cluster(pairid)
outreg tc_im $x1 using "U:\Scripts\table5.txt", se noaster  nocon append

global x1 "prog post_prog mymills impohat  wto1 wto2 border colony comcol comlang custrict ldist regional lrgdp_i lrgdp_e lpop_i lpop_e "
reg impo tc_im $x1 _Icty1* _Icty2* _Iyear*, cluster(pairid)
outreg tc_im $x1 using "U:\Scripts\table5.txt", se noaster  nocon append

global x1 "rer rer_BI prog post_prog mymills impohat  wto1 wto2 border colony comcol comlang custrict ldist regional lrgdp_i lrgdp_e lpop_i lpop_e "
reg impo tc_im $x1 _Icty1* _Icty2* _Iyear*, cluster(pairid)
outreg tc_im $x1 using "U:\Scripts\table5.txt", se noaster  nocon append

