%==========================================================================
%   Project:          Quantification Exercise for the Paper                      
%                     "Trade Reforms And Current Account Imbalances: 
%                     When Does The General Equilibrium Effect 
%                     Overturn A Partial Equilibrium Intuition?"                        
%
%   Purpose:          Compute SS and call dynare file
%
%   Date of editing:  Feb. 2020
%
%==========================================================================

addpath('C:\Users\JJ Tang\OD\dynare\work\QEx');
cd 'C:\Users\JJ Tang\OD\dynare\work\QEx';

clear all;
close all;
format long G;

% Parameters
load('param.mat');
beta    = parameter(1);  
gamma   = parameter(2);
alpha1  = parameter(3);
alpha2  = parameter(4);
omega   = parameter(5);
psib    = parameter(6);
delta   = parameter(7);
psi     = parameter(8);
l       = parameter(9);
psik    = parameter(10);
rstar   = parameter(11);
wstar   = parameter(12);
cbar    = parameter(13);
bbar    = parameter(14);

% Check Initial SS
load('var.mat');
var_v(14,:) = var_v(2,:).^(-gamma)./var_v(13,:); % Compute Ome
var_v(15,:) = var_v(14,:);  % Compute Lam
var1        = var_v(:,1);
var2        = var_v(:,2);

load('shocks.mat');
shock1  = shock_v(:,1);
parm = [ parameter shock1'];
var0 = var1; 

options = optimoptions('fsolve','Display','iter');
options.MaxFunctionEvaluations = 15*5000;
options.MaxIterations = 10^8;
[var, fval] = fsolve(@(var) Findss(var,parm),var0,options);

if max(var1-var)<10^-18
    disp('Initial SS is correct');
else
    disp('Initial SS is wrong');
end 
var1 = var;

%% Import tariff cut
shock_tf    = shock_v(:,1);
shock_tf(4) = shock_v(4,2);
parm = [ parameter shock_tf'];
var0 = var1; 
[var, fval] = fsolve(@(var) Findss(var,parm),var0,options);
var_tf = var;
exovar = [shock1 shock_tf];
endvar = [var1 var_tf];
save('exo.mat','exovar');
save('end.mat','endvar');
dynare simul2;

% Check SS computation
if max((endvar(:,1)-oo_.endo_simul(:,1))./endvar(:,1))<10^-3
    disp('Initial SS computation is correct');
else
    disp('Initial SS computation is wrong');
    disp('The difference is:')
    max((endvar(:,1)-oo_.endo_simul(:,1))./endvar(:,1))
end 

if max((endvar(:,2)-oo_.endo_simul(:,301))./endvar(:,2))<10^-3
    disp('Final SS is correct');
else
    disp('Final SS is wrong');
    disp('The difference is:')
    max((endvar(:,2)-oo_.endo_simul(:,301))./endvar(:,2))
end 

tf.tv2gdp = tv2gdp;
tf.tb2gdp = tb2gdp;
tf.ca2gdp = ca2gdp;
tf.s2gdp = s2gdp;
tf.i2gdp = i2gdp;
tf.b2gdp = b2gdp;
save('tf.mat','tf');

%% Effect of tariff cut
shock_tf2    = shock_v(:,1);
shock_tf2(4) = 0.15;
parm = [ parameter shock_tf2'];
var0 = var1; 
[var, fval] = fsolve(@(var) Findss(var,parm),var0,options);
var_tf2 = var;
var_tf_tab = [var1 var_tf var_tf2] ;
var_tf_tab(16,:) = var_tf_tab(9,:);  % r1 = r
var_tf_tab(17,:) = var_tf_tab(9,:);  % r2 = r
var_tf_tab(18,:) = alpha1.* var_tf_tab(11,:).* var_tf_tab(7,:)...
                   ./ var_tf_tab(9,:);  % k1 = alpha1.* p1.* x1./ r
var_tf_tab(19,:) = alpha2.* var_tf_tab(12,:).* var_tf_tab(8,:)...
                   ./ var_tf_tab(9,:);  % k2 = alpha2.* p2.* x2./ r;              
save('var_tf_tab.mat','var_tf_tab');

%% Sensitivity to psik
parameter(10) = 8;
save('param_sen.mat','parameter');
parm = [ parameter shock_tf'];
var0 = var1; 
[var, fval] = fsolve(@(var) Findss(var,parm),var0,options);
var_psik8 = var;
exovar = [shock1 shock_tf];
endvar = [var1 var_psik8];
save('exo.mat','exovar');
save('end.mat','endvar');
dynare simul_sen;
psik8.tv2gdp = tv2gdp;
psik8.ca2gdp = ca2gdp;
psik8.b2gdp = b2gdp;

parameter(10) = 12;
save('param_sen.mat','parameter');
parm = [ parameter shock_tf'];
var0 = var1; 
[var, fval] = fsolve(@(var) Findss(var,parm),var0,options);
var_psik12 = var;
exovar = [shock1 shock_tf];
endvar = [var1 var_psik12];
save('exo.mat','exovar');
save('end.mat','endvar');
dynare simul_sen;
psik12.tv2gdp = tv2gdp;
psik12.ca2gdp = ca2gdp;
psik12.b2gdp = b2gdp;
save('psik8.mat','psik8');
save('psik12.mat','psik12');

%% Sensitivity to psib
parameter(6) = 0.005;
parameter(10)= 4;
save('param_sen.mat','parameter');
parm = [ parameter shock_tf'];
var0 = var1; 
[var, fval] = fsolve(@(var) Findss(var,parm),var0,options);
var_psib5 = var;
exovar = [shock1 shock_tf];
endvar = [var1 var_psib5];
save('exo.mat','exovar');
save('end.mat','endvar');
dynare simul_sen;
psib5.tv2gdp = tv2gdp;
psib5.ca2gdp = ca2gdp;
psib5.b2gdp = b2gdp;

parameter(6) = 0.008;
parameter(10)= 4;
save('param_sen.mat','parameter');
parm = [ parameter shock_tf'];
var0 = var1; 
[var, fval] = fsolve(@(var) Findss(var,parm),var0,options);
var_psib8 = var;
exovar = [shock1 shock_tf];
endvar = [var1 var_psib8];
save('exo.mat','exovar');
save('end.mat','endvar');
dynare simul_sen;
psib8.tv2gdp = tv2gdp;
psib8.ca2gdp = ca2gdp;
psib8.b2gdp = b2gdp;
save('psib5.mat','psib5');
save('psib8.mat','psib8');

%% Export cost reduction
shock_ep    = shock_v(:,1);
shock_ep(3) = shock_v(3,2);
parm = [ parameter shock_ep'];
[var, fval] = fsolve(@(var) Findss(var,parm),var0,options);
var_ep = var;

%% Export + Import cost reduction
shock_tfep      = shock_v(:,1);
shock_tfep(3:4) = shock_v(3:4,2);
parm = [ parameter shock_tfep'];
[var, fval] = fsolve(@(var) Findss(var,parm),var0,options);
var_tfep = var;
exovar = [shock1 shock_tfep];
endvar = [var1 var_tfep];
save('exo.mat','exovar');
save('end.mat','endvar');
dynare simul2;
tfep.tv2gdp = tv2gdp;
tfep.tb2gdp = tb2gdp;
tfep.ca2gdp = ca2gdp;
tfep.s2gdp = s2gdp;
tfep.i2gdp = i2gdp;
tfep.b2gdp = b2gdp;
save('tfep.mat','tfep');

%% TFP improvement in sector 1
shock_a1    = shock_v(:,1);
shock_a1(1) = shock_v(1,2);
parm = [ parameter shock_a1'];
[var, fval] = fsolve(@(var) Findss(var,parm),var0,options);
var_a1 = var;

%% TFP improvement in sector 2
shock_a2    = shock_v(:,1);
shock_a2(2) = shock_v(2,2);
parm = [ parameter shock_a2'];
[var, fval] = fsolve(@(var) Findss(var,parm),var0,options);
var_a2 = var;

%% Aggregate TFP improvement
shock_a    = shock_v(:,1);
shock_a(1:2) = shock_v(1:2,2);
parm = [ parameter shock_a'];
[var, fval] = fsolve(@(var) Findss(var,parm),var0,options);
var_a = var;

%% Aggregate TFP + tariff
shock_atf    = shock_v(:,2);
shock_atf(3) = shock_v(3,1);
parm = [ parameter shock_atf'];
[var, fval] = fsolve(@(var) Findss(var,parm),var0,options);
var_atf = var;

%% Aggregate TFP + export
shock_aep    = shock_v(:,2);
shock_aep(4) = shock_v(4,1);
parm = [ parameter shock_aep'];
[var, fval] = fsolve(@(var) Findss(var,parm),var0,options);
var_aep = var;

%% Total effects
shock_t  = shock_v(:,2);
parm = [ parameter shock_t'];
var0 = var2;
[var, fval] = fsolve(@(var) Findss(var,parm),var0,options);
if max(var2-var)<10^-18
    disp('Final SS is correct');
else
    disp('Final SS is wrong');
end 
var_t = var2;

var_decomp = [var1 var_tf var_ep var_a1 var_a2 var_a var_atf var_aep ...
              var_t] ;
save('var_decomp.mat','var_decomp');

%% Credit constraint
muk = 0.434;  % k1/k in no-constraint case
load('shocks.mat');
shock1  = shock_v(:,1);
parm = [ parameter shock1' muk];
var0 = [var1; 0.036; 0.035; 18.2544; 23.78854;]; 
[var, fval] = fsolve(@(var) Findss_credit(var,parm),var0,options);
var1_cr = var;

shock_tf    = shock_v(:,1);
shock_tf(4) = shock_v(4,2);
parm = [ parameter shock_tf' muk];
var0 = [var1; 0.036; 0.035; 18.2544; 23.78854;]; 
[var, fval] = fsolve(@(var) Findss_credit(var,parm),var0,options);
var_tf_cr = var;

shock_tf2    = shock_v(:,1);
shock_tf2(4) = 0.15;
parm = [ parameter shock_tf2' muk];
var0 = [var1; 0.036; 0.035; 18.2544; 23.78854;]; 
[var, fval] = fsolve(@(var) Findss_credit(var,parm),var0,options);
var_tf2_cr = var;

var_tf_tab = [var_tf_tab var1_cr var_tf_cr var_tf2_cr] ;
save('var_tf_tab.mat','var_tf_tab');

exovar = [shock1 shock_tf];
endvar = [var1_cr var_tf_cr];
save('exo_cr.mat','exovar');
save('end_cr.mat','endvar');
dynare simul_credit2;

% Check SS computation
if max((endvar(:,1)-oo_.endo_simul(:,1))./endvar(:,1))<10^-3
    disp('Initial SS computation is correct');
else
    disp('Initial SS computation is wrong');
    disp('The difference is:')
    max((endvar(:,1)-oo_.endo_simul(:,1))./endvar(:,1))
end 

if max((endvar(:,2)-oo_.endo_simul(:,501))./endvar(:,2))<10^-3
    disp('Final SS is correct');
else
    disp('Final SS is wrong');
    disp('The difference is:')
    max((endvar(:,2)-oo_.endo_simul(:,501))./endvar(:,2))
end 

tf_cr.tv2gdp = tv2gdp;
tf_cr.tb2gdp = tb2gdp;
tf_cr.ca2gdp = ca2gdp;
tf_cr.s2gdp = s2gdp;
tf_cr.i2gdp = i2gdp;
tf_cr.b2gdp = b2gdp;
save('tf_cr.mat','tf_cr');

