/** This file is the same as election2.do except that it corrects for heteroscedasticity **/

# delimit ;
capture log using program.log, replace;
set maxvar 200;

use all;
version 4.0;

/** in levels **/
/* elect3 just dummies out the 1906 election*/
hreg voteinc unemp realw gdp infln ww1 ww2 honey elect3;
hreg voteinc unemp realw gdp infln d1931 d1975 ww1 ww2 honey elect3;
hreg voteinc unemp realw gdp infln d1931 d1975 ww1 ww2 inc inter inter3 honey elect3;

/** difference between election date figure and 10 year moving average **/
hreg voteinc dunemp10 drealw10 dgdp10 dinfln10 d1931 d1975 ww1 ww2 honey elect3;
hreg voteinc difunemp difrealw difgdp difinfl d1931 d1975 ww1 ww2 honey elect3; 

/** Electorate Level **/
replace inter=inc*dunemp10;
replace inter3=inc*dinfln10;
hreg kinc dunemp10 drealw10 dgdp10 dinfln10 inc inter inter3 d1975 honey;
hreg mpinc dunemp10 drealw10 dgdp10 dinfln10 inc inter inter3 d1975 honey;
hreg latrobe dunemp10 drealw10 dgdp10 dinfln10 inc inter inter3 d1975 honey;

log close;
