void loadM2(FILE *fp, double **mat, int xDIM, int yDIM);
double ** newmat2(int m, int n);
void freemat2(double **mat2, int xDim);

double *** newmat3(int m, int n, int k);
void freemat3(double *** mat3, int xDim, int yDim);
void clearmat3(double *** mat3, int xDim, int yDim, int);

double **** newmat4(int m, int n, int k, int l);
void freemat4(double **** mat4, int xDim, int yDim, int zDim);
void clearmat4(double **** mat4, int xDim, int yDim, int zDim, int);

double ****** newmat6(int xDim, int yDim, int zDim, int uDim, int vDim, int wDim);
void freemat6(double ****** mat6, int xDim, int yDim, int zDim, int uDim, int vDim);
void clearmat6(double ****** mat6, int xDim, int yDim, int zDim, int uDim, int vDim, int);

double ******* newmat7(int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim);
void freemat7(double ******* mat6, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim);
void clearmat7(double ******* mat6, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int);

float ** newmat_f2(int m, int n);
void freemat_f2(float **mat_f2, int xDim);

float *** newmat_f3(int m, int n, int k);
void freemat_f3(float *** mat_f3, int xDim, int yDim);
void clearmat_f3(float *** mat_f3, int xDim, int yDim, int);

float **** newmat_f4(int m, int n, int k, int l);
void freemat_f4(float **** mat_f4, int xDim, int yDim, int zDim);
void clearmat_f4(float **** mat_f4, int xDim, int yDim, int zDim, int);

float ****** newmat_f6(int xDim, int yDim, int zDim, int uDim, int vDim, int wDim);
void freemat_f6(float ****** mat_f6, int xDim, int yDim, int zDim, int uDim, int vDim);
void clearmat_f6(float ****** mat_f6, int xDim, int yDim, int zDim, int uDim, int vDim, int);

float ******* newmat_f7(int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim);
void freemat_f7(float ******* mat_f6, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim);
void clearmat_f7(float ******* mat_f6, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int);


double ***** newmat5(int xDim, int yDim, int zDim, int uDim, int vDim)
{double *****matrixP;
	int iInd1;
	matrixP=(double *****)calloc(xDim,sizeof(double ****));
	for (iInd1=0; iInd1<xDim; iInd1++) 	{		
	matrixP[iInd1]=newmat4(yDim,  zDim,  uDim, vDim);
	}
	return matrixP;
}
void freemat5(double ***** mat5, int xDim, int yDim, int zDim, int uDim)
{	int iInd1;
	for (iInd1=0; iInd1<xDim; iInd1++) { freemat4(mat5[iInd1], yDim,  zDim, uDim);}
	free(mat5);
}
void clearmat5(double ***** mat5, int xDim, int yDim, int zDim, int uDim, int vDim)
{	int iInd1;
	for (iInd1=0; iInd1<xDim; iInd1++) { clearmat4(mat5[iInd1], yDim,  zDim,  uDim, vDim);}
}

float ***** newmat_f5(int xDim, int yDim, int zDim, int uDim, int vDim)
{
float *****matrixP;
	int iInd1;
	matrixP=(float *****)calloc(xDim,sizeof(float ****));
	for (iInd1=0; iInd1<xDim; iInd1++) 
	{		
	matrixP[iInd1]=newmat_f4(yDim,  zDim,  uDim, vDim);
	}
	return matrixP;
}
void freemat_f5(float ***** mat_f5, int xDim, int yDim, int zDim, int uDim)
{	int iInd1;
	for (iInd1=0; iInd1<xDim; iInd1++) { freemat_f4(mat_f5[iInd1], yDim,  zDim, uDim);}
free(mat_f5);
}
void clearmat_f5(float ***** mat_f5, int xDim, int yDim, int zDim, int uDim)
{	int iInd1;
	for (iInd1=0; iInd1<xDim; iInd1++) { clearmat_f4(mat_f5[iInd1], yDim,  zDim,  uDim, uDim);}
}


double ******** newmat8(int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim, int wwwDim)
{double ********matrixP;
	int iInd1;
	matrixP=(double ********)calloc(xDim,sizeof(double *******));
	for (iInd1=0; iInd1<xDim; iInd1++) 	{
		matrixP[iInd1]=newmat7(yDim,  zDim,  uDim, vDim,wDim, wwDim,  wwwDim);
	}	return matrixP;
}

void freemat8(double ******** mat7, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim)
{	int iInd1;
	for (iInd1=0; iInd1<xDim; iInd1++) { freemat7(mat7[iInd1], yDim,  zDim,  uDim, vDim,wDim, wwDim);}
free(mat7); }

void clearmat8(double ******** mat7, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim,int wwwDim)
{	int iInd1;
	for (iInd1=0; iInd1<xDim; iInd1++) 
	{ clearmat7(mat7[iInd1], yDim,  zDim,  uDim, vDim,wDim, wwDim,wwwDim);}
}


float ******** newmat_f8(int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim, int wwwDim)
{
float ********matrixP;
	int iInd1;
	matrixP=(float ********)calloc(xDim,sizeof(float *******));
	for (iInd1=0; iInd1<xDim; iInd1++) 
	{		
	matrixP[iInd1]=newmat_f7(yDim,  zDim,  uDim, vDim,wDim, wwDim,  wwwDim);
	}
	return matrixP;
}

void freemat_f8(float ******** mat_f7, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim)
{
	int iInd1;
	for (iInd1=0; iInd1<xDim; iInd1++) { freemat_f7(mat_f7[iInd1], yDim,  zDim,  uDim, vDim,wDim, wwDim);}
free(mat_f7);
}

void clearmat_f8(float ******** mat_f7, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim,int wwwDim)
{	int iInd1;
	for (iInd1=0; iInd1<xDim; iInd1++) { clearmat_f7(mat_f7[iInd1], yDim,  zDim,  uDim, vDim,wDim, wwDim,wwwDim);}
}

double ********* newmat9(int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim, int wwwDim, int wwwwDim)
{
double *********matrixP;
	int iInd1;
	matrixP=(double *********)calloc(xDim,sizeof(double ********));
	for (iInd1=0; iInd1<xDim; iInd1++) 	{		
	matrixP[iInd1]=newmat8(yDim,  zDim,  uDim, vDim,wDim, wwDim,  wwwDim,  wwwwDim);
	}
	return matrixP;
}

void freemat9(double ********* mat, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim, int wwwDim)
{
	int iInd1;
	for (iInd1=0; iInd1<xDim; iInd1++) { freemat8(mat[iInd1], yDim,  zDim,  uDim, vDim,wDim, wwDim,wwwDim);}
free(mat); }

void clearmat9(double ********* mat, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim,int wwwDim,int wwwwDim)
{	int iInd1;
	for (iInd1=0; iInd1<xDim; iInd1++) { clearmat8(mat[iInd1], yDim,  zDim,  uDim, vDim,wDim, wwDim,wwwDim, wwwwDim);}
}

double ********** newmat10(int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim, int wwwDim, int wwwwDim,int wwwwwDim)
{double **********matrixP;
	int iInd1;
	matrixP=(double **********)calloc(xDim,sizeof(double *********));
	for (iInd1=0; iInd1<xDim; iInd1++) 	{		
	matrixP[iInd1]=newmat9(yDim,  zDim,  uDim, vDim,wDim, wwDim,  wwwDim,  wwwwDim, wwwwwDim);
	}	return matrixP;
}

void freemat10(double ********** mat, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim, int wwwDim,int wwwwDim)
{	int iInd1;
	for (iInd1=0; iInd1<xDim; iInd1++) { freemat9(mat[iInd1], yDim,  zDim,  uDim, vDim,wDim, wwDim,wwwDim, wwwwDim);}
free(mat); }

void clearmat10(double ********** mat, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim,int wwwDim,int wwwwDim, int wwwwwDim)
{	int iInd1;
	for (iInd1=0; iInd1<xDim; iInd1++) 
	{ clearmat9(mat[iInd1], yDim,  zDim,  uDim, vDim,wDim, wwDim,wwwDim, wwwwDim, wwwwwDim);}
}


void loadM2(FILE *fp, double **mat, int xDIM, int yDIM)
{
	int zInd, wInd;
	for (zInd = 0;zInd<xDIM;zInd++)
		{
			for (wInd = 0;wInd<yDIM; wInd++)
			{fscanf( fp, "%lf",	 &mat[zInd][wInd]);
			}
		}
}


double ** newmat2(int m, int n)
{
	double **matrixP;	int i;
	matrixP=(double **)malloc(m * sizeof(double* ));
	for (i=0;i<m; i++)	{
	*(matrixP+i)=(double *)malloc(n * sizeof(double));
	memset(*(matrixP+i), 0, sizeof(double)*n);
	}
	return matrixP;
}
void freemat2(double **mat2, int xDim)
{	int i;
	for (i=0;i<xDim; i++)	{	free(mat2[i]);	}
	free(mat2);
}

double *** newmat3(int m, int n, int k)
{
	double ***matrixP;
	int i, j;
	matrixP=(double ***)malloc(m * sizeof(double** ));
	for (i=0;i<m; i++)	{
	*(matrixP+i)=(double **)malloc(n * sizeof(double*));
	for (j=0;j<n; j++)	{
	*(*(matrixP+i)+j)=(double *)malloc(k * sizeof(double));
	memset(*(*(matrixP+i)+j), 0, sizeof(double)*k);
	}	}
	return matrixP;
}

void freemat3(double *** mat3, int xDim, int yDim)
{	int i, j;
	for (i=0;i<xDim; i++)	{
		for (j = 0;j<yDim; j++)		{	free(mat3[i][j]);		}
	free(mat3[i]);	}
	free(mat3);
}

void clearmat3(double *** mat3, int xDim, int yDim, int zDim)
{
	int i, j;

	for (i=0;i<xDim; i++)
	{
		for (j = 0;j<yDim; j++)
		{
	memset(mat3[i][j], 0, sizeof(double)*zDim);
		}
	}
}

double **** newmat4(int m, int n, int k, int l)
{
	double ****matrixP;
	int i, j, z;
	matrixP=(double ****)malloc(m * sizeof(double*** ));

	for (i=0;i<m; i++)
	{
	*(matrixP+i)=(double ***)malloc(n * sizeof(double**));
	for (j=0;j<n; j++)
	{
	*(*(matrixP+i)+j)=(double **)malloc(k * sizeof(double*));

	for (z=0;z<k; z++)
	{
	*(*(*(matrixP+i)+j)+z)=(double *)malloc(l * sizeof(double));
	memset(*(*(*(matrixP+i)+j)+z), 0, sizeof(double)*l);
	}
	}
	}
	return matrixP;
}

void clearmat4(double **** mat4, int xDim, int yDim, int zDim, int uDim)
{
	int i, j, k;

	for (i=0;i<xDim; i++)
	{
		for (j = 0;j<yDim; j++)
		{
		for (k = 0;k<zDim; k++)
		{
	memset(*(*(*(mat4+i)+j)+k), 0, sizeof(double)*uDim);
		}
		}
	}

}




void freemat4(double **** mat4, int xDim, int yDim, int zDim)
{	int i, j, k;

	for (i=0;i<xDim; i++)	{
		for (j = 0;j<yDim; j++)		{
		for (k = 0;k<zDim; k++)		{
	free(mat4[i][j][k]);
		}
	free(mat4[i][j]);
		}
	free(mat4[i]);
	}
	free(mat4);
}




double ****** newmat6(int xDim, int yDim, int zDim, int uDim, int vDim, int wDim)
{	double ******matrixP;
	int iInd1,iInd2,iInd3,iInd4,iInd5;
	matrixP=(double ******)calloc(xDim,sizeof(double *****));
	for (iInd1=0; iInd1<xDim; iInd1++) 	{		
	matrixP[iInd1]=(double *****)calloc(yDim,sizeof(double ****));
		for (iInd2=0; iInd2<yDim; iInd2++) 		{
	matrixP[iInd1][iInd2]=(double ****)calloc(zDim,sizeof(double ***));
			for (iInd3=0; iInd3<zDim; iInd3++) 			{
					matrixP[iInd1][iInd2][iInd3]=(double ***)calloc(uDim,sizeof(double **));
				for (iInd4=0; iInd4<uDim; iInd4++) 				{	
					matrixP[iInd1][iInd2][iInd3][iInd4]=(double **)calloc(vDim,sizeof(double *));
					for (iInd5=0; iInd5<vDim; iInd5++) 					{
	matrixP[iInd1][iInd2][iInd3][iInd4][iInd5]=(double *)calloc(wDim,sizeof(double ));
memset(matrixP[iInd1][iInd2][iInd3][iInd4][iInd5], 0, sizeof(double)*wDim);
					}}}}}
	return matrixP;
}

void clearmat6(double ****** mat6, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim)
{		int iInd1,iInd2,iInd3,iInd4,iInd5;
	for (iInd1=0; iInd1<xDim; iInd1++) 	{		
		for (iInd2=0; iInd2<yDim; iInd2++) 		{
			for (iInd3=0; iInd3<zDim; iInd3++) 			{
				for (iInd4=0; iInd4<uDim; iInd4++) 				{	
					for (iInd5=0; iInd5<vDim; iInd5++) 					{	
memset(mat6[iInd1][iInd2][iInd3][iInd4][iInd5], 0, sizeof(double)*wDim);
					}				}}}}
}

void freemat6(double ****** mat6, int xDim, int yDim, int zDim, int uDim, int vDim)
{		int iInd1,iInd2,iInd3,iInd4,iInd5;
	for (iInd1=0; iInd1<xDim; iInd1++) 	{		
		for (iInd2=0; iInd2<yDim; iInd2++) 		{
			for (iInd3=0; iInd3<zDim; iInd3++) 			{
				for (iInd4=0; iInd4<uDim; iInd4++) 				{	
					for (iInd5=0; iInd5<vDim; iInd5++) 					{	
						free(mat6[iInd1][iInd2][iInd3][iInd4][iInd5]);					}
					free(mat6[iInd1][iInd2][iInd3][iInd4]);				}
				free(mat6[iInd1][iInd2][iInd3]);}
			free(mat6[iInd1][iInd2]);}
		free(mat6[iInd1]);}
	free(mat6);
}

double ******* newmat7(int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim)
{	double *******matrixP;
	int iInd1,iInd2,iInd3,iInd4,iInd5, iInd6;
	matrixP=(double *******)calloc(xDim,sizeof(double ******));
	for (iInd1=0; iInd1<xDim; iInd1++) 	{		
	matrixP[iInd1]=(double ******)calloc(yDim,sizeof(double *****));
		for (iInd2=0; iInd2<yDim; iInd2++) 		{
	matrixP[iInd1][iInd2]=(double *****)calloc(zDim,sizeof(double ****));
			for (iInd3=0; iInd3<zDim; iInd3++) 			{
					matrixP[iInd1][iInd2][iInd3]=(double ****)calloc(uDim,sizeof(double ***));
				for (iInd4=0; iInd4<uDim; iInd4++) 				{	
					matrixP[iInd1][iInd2][iInd3][iInd4]=(double ***)calloc(vDim,sizeof(double **));
					for (iInd5=0; iInd5<vDim; iInd5++) 					{
	matrixP[iInd1][iInd2][iInd3][iInd4][iInd5]=(double **)calloc(wDim,sizeof(double* ));
					for (iInd6=0; iInd6<wDim; iInd6++)					{
	matrixP[iInd1][iInd2][iInd3][iInd4][iInd5][iInd6]=(double *)calloc(wwDim,sizeof(double ));
memset(matrixP[iInd1][iInd2][iInd3][iInd4][iInd5][iInd6], 0, sizeof(double)*wwDim);
					}					}}}}}
	return matrixP;
}
void freemat7(double ******* mat7, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim)
{		int iInd1,iInd2,iInd3,iInd4,iInd5, iInd6;
	for (iInd1=0; iInd1<xDim; iInd1++) 	{		
		for (iInd2=0; iInd2<yDim; iInd2++) 		{
			for (iInd3=0; iInd3<zDim; iInd3++) 			{
				for (iInd4=0; iInd4<uDim; iInd4++) 				{	
					for (iInd5=0; iInd5<vDim; iInd5++) 					{	
					for (iInd6=0; iInd6<wDim; iInd6++)					{
					free(mat7[iInd1][iInd2][iInd3][iInd4][iInd5][iInd6]);					}
					free(mat7[iInd1][iInd2][iInd3][iInd4][iInd5]);					}
					free(mat7[iInd1][iInd2][iInd3][iInd4]);				}
				free(mat7[iInd1][iInd2][iInd3]);			}
			free(mat7[iInd1][iInd2]);	}
		free(mat7[iInd1]);}
	free(mat7);
}

void clearmat7(double ******* mat7, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim)
{
		int iInd1,iInd2,iInd3,iInd4,iInd5, iInd6;
	for (iInd1=0; iInd1<xDim; iInd1++) 
	{		
		for (iInd2=0; iInd2<yDim; iInd2++) 
		{
			for (iInd3=0; iInd3<zDim; iInd3++) 
			{
				for (iInd4=0; iInd4<uDim; iInd4++) 
				{	

					for (iInd5=0; iInd5<vDim; iInd5++) 
					{	
					for (iInd6=0; iInd6<wDim; iInd6++) 
					{
memset(mat7[iInd1][iInd2][iInd3][iInd4][iInd5][iInd6], 0, sizeof(double)*wwDim);
					}
					}
				}
}
}
}
}







float ** newmat_f2(int m, int n)
{
	float **matrixP;
	int i;
	matrixP=(float **)malloc(m * sizeof(float* ));

	for (i=0;i<m; i++)
	{
	*(matrixP+i)=(float *)malloc(n * sizeof(float));
	memset(*(matrixP+i), 0, sizeof(float)*n);
	}
	return matrixP;
}


float *** newmat_f3(int m, int n, int k)
{
	float ***matrixP;
	int i, j;
	matrixP=(float ***)malloc(m * sizeof(float** ));

	for (i=0;i<m; i++)
	{
	*(matrixP+i)=(float **)malloc(n * sizeof(float*));
	for (j=0;j<n; j++)
	{
	*(*(matrixP+i)+j)=(float *)malloc(k * sizeof(float));
	memset(*(*(matrixP+i)+j), 0, sizeof(float)*k);
	}
	}
	return matrixP;
}

void freemat_f3(float *** mat_f3, int xDim, int yDim)
{
	int i, j;

	for (i=0;i<xDim; i++)
	{
		for (j = 0;j<yDim; j++)
		{
	free(mat_f3[i][j]);
		}
	free(mat_f3[i]);
	}
	free(mat_f3);
}

void clearmat_f3(float *** mat_f3, int xDim, int yDim, int zDim)
{
	int i, j;

	for (i=0;i<xDim; i++)
	{
		for (j = 0;j<yDim; j++)
		{
	memset(mat_f3[i][j], 0, sizeof(float)*zDim);
		}
	}
}


void freemat_f2(float **mat_f2, int xDim)
{
	int i;

	for (i=0;i<xDim; i++)
	{
	free(mat_f2[i]);
	}
	free(mat_f2);
}


float **** newmat_f4(int m, int n, int k, int l)
{
	float ****matrixP;
	int i, j, z;
	matrixP=(float ****)malloc(m * sizeof(float*** ));

	for (i=0;i<m; i++)
	{
	*(matrixP+i)=(float ***)malloc(n * sizeof(float**));
	for (j=0;j<n; j++)
	{
	*(*(matrixP+i)+j)=(float **)malloc(k * sizeof(float*));

	for (z=0;z<k; z++)
	{
	*(*(*(matrixP+i)+j)+z)=(float *)malloc(l * sizeof(float));
	memset(*(*(*(matrixP+i)+j)+z), 0, sizeof(float)*l);
	}
	}
	}
	return matrixP;
}

void clearmat_f4(float **** mat_f4, int xDim, int yDim, int zDim, int uDim)
{
	int i, j, k;

	for (i=0;i<xDim; i++)
	{
		for (j = 0;j<yDim; j++)
		{
		for (k = 0;k<zDim; k++)
		{
	memset(*(*(*(mat_f4+i)+j)+k), 0, sizeof(float)*uDim);
		}
		}
	}

}




void freemat_f4(float **** mat_f4, int xDim, int yDim, int zDim)
{
	int i, j, k;

	for (i=0;i<xDim; i++)
	{
		for (j = 0;j<yDim; j++)
		{
		for (k = 0;k<zDim; k++)
		{
	free(mat_f4[i][j][k]);
		}
	free(mat_f4[i][j]);
		}
	free(mat_f4[i]);
	}
	free(mat_f4);

}




float ****** newmat_f6(int xDim, int yDim, int zDim, int uDim, int vDim, int wDim)
{
	float ******matrixP;
	int iInd1,iInd2,iInd3,iInd4,iInd5;
	matrixP=(float ******)calloc(xDim,sizeof(float *****));
	for (iInd1=0; iInd1<xDim; iInd1++) 
	{		
	matrixP[iInd1]=(float *****)calloc(yDim,sizeof(float ****));
		for (iInd2=0; iInd2<yDim; iInd2++) 
		{
	matrixP[iInd1][iInd2]=(float ****)calloc(zDim,sizeof(float ***));
			for (iInd3=0; iInd3<zDim; iInd3++) 
			{
					matrixP[iInd1][iInd2][iInd3]=(float ***)calloc(uDim,sizeof(float **));
				for (iInd4=0; iInd4<uDim; iInd4++) 
				{	
					matrixP[iInd1][iInd2][iInd3][iInd4]=(float **)calloc(vDim,sizeof(float *));

					for (iInd5=0; iInd5<vDim; iInd5++) 
					{
	matrixP[iInd1][iInd2][iInd3][iInd4][iInd5]=(float *)calloc(wDim,sizeof(float ));
memset(matrixP[iInd1][iInd2][iInd3][iInd4][iInd5], 0, sizeof(float)*wDim);
					}}}}}
	return matrixP;
}

void clearmat_f6(float ****** mat_f6, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim)
{
		int iInd1,iInd2,iInd3,iInd4,iInd5;
	for (iInd1=0; iInd1<xDim; iInd1++) 
	{		
		for (iInd2=0; iInd2<yDim; iInd2++) 
		{
			for (iInd3=0; iInd3<zDim; iInd3++) 
			{
				for (iInd4=0; iInd4<uDim; iInd4++) 
				{	

					for (iInd5=0; iInd5<vDim; iInd5++) 
					{	
memset(mat_f6[iInd1][iInd2][iInd3][iInd4][iInd5], 0, sizeof(float)*wDim);
					}
				}
}
}
}
}







void freemat_f6(float ****** mat_f6, int xDim, int yDim, int zDim, int uDim, int vDim)
{
		int iInd1,iInd2,iInd3,iInd4,iInd5;
	for (iInd1=0; iInd1<xDim; iInd1++) 
	{		
		for (iInd2=0; iInd2<yDim; iInd2++) 
		{
			for (iInd3=0; iInd3<zDim; iInd3++) 
			{
				for (iInd4=0; iInd4<uDim; iInd4++) 
				{	

					for (iInd5=0; iInd5<vDim; iInd5++) 
					{	
						free(mat_f6[iInd1][iInd2][iInd3][iInd4][iInd5]);
					}
					free(mat_f6[iInd1][iInd2][iInd3][iInd4]);
				}
				free(mat_f6[iInd1][iInd2][iInd3]);
}
			free(mat_f6[iInd1][iInd2]);
}
		free(mat_f6[iInd1]);
}free(mat_f6);
}





float ******* newmat_f7(int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim)
{
	float *******matrixP;
	int iInd1,iInd2,iInd3,iInd4,iInd5, iInd6;
	matrixP=(float *******)calloc(xDim,sizeof(float ******));
	for (iInd1=0; iInd1<xDim; iInd1++) 
	{		
	matrixP[iInd1]=(float ******)calloc(yDim,sizeof(float *****));
		for (iInd2=0; iInd2<yDim; iInd2++) 
		{
	matrixP[iInd1][iInd2]=(float *****)calloc(zDim,sizeof(float ****));
			for (iInd3=0; iInd3<zDim; iInd3++) 
			{
					matrixP[iInd1][iInd2][iInd3]=(float ****)calloc(uDim,sizeof(float ***));
				for (iInd4=0; iInd4<uDim; iInd4++) 
				{	
					matrixP[iInd1][iInd2][iInd3][iInd4]=(float ***)calloc(vDim,sizeof(float **));

					for (iInd5=0; iInd5<vDim; iInd5++) 
					{
	matrixP[iInd1][iInd2][iInd3][iInd4][iInd5]=(float **)calloc(wDim,sizeof(float* ));
					for (iInd6=0; iInd6<wDim; iInd6++) 
					{
	matrixP[iInd1][iInd2][iInd3][iInd4][iInd5][iInd6]=(float *)calloc(wwDim,sizeof(float ));
memset(matrixP[iInd1][iInd2][iInd3][iInd4][iInd5][iInd6], 0, sizeof(float)*wwDim);
					}
					}}}}}
	return matrixP;
}

void clearmat_f7(float ******* mat_f7, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim)
{
		int iInd1,iInd2,iInd3,iInd4,iInd5, iInd6;
	for (iInd1=0; iInd1<xDim; iInd1++) 
	{		
		for (iInd2=0; iInd2<yDim; iInd2++) 
		{
			for (iInd3=0; iInd3<zDim; iInd3++) 
			{
				for (iInd4=0; iInd4<uDim; iInd4++) 
				{	

					for (iInd5=0; iInd5<vDim; iInd5++) 
					{	
					for (iInd6=0; iInd6<wDim; iInd6++) 
					{
memset(mat_f7[iInd1][iInd2][iInd3][iInd4][iInd5][iInd6], 0, sizeof(float)*wwDim);
					}
					}
				}
}
}
}
}


void freemat_f7(float ******* mat_f7, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim)
{
		int iInd1,iInd2,iInd3,iInd4,iInd5, iInd6;
	for (iInd1=0; iInd1<xDim; iInd1++) 
	{		
		for (iInd2=0; iInd2<yDim; iInd2++) 
		{
			for (iInd3=0; iInd3<zDim; iInd3++) 
			{
				for (iInd4=0; iInd4<uDim; iInd4++) 
				{	

					for (iInd5=0; iInd5<vDim; iInd5++) 
					{	
					for (iInd6=0; iInd6<wDim; iInd6++) 
					{
					free(mat_f7[iInd1][iInd2][iInd3][iInd4][iInd5][iInd6]);
					}
					free(mat_f7[iInd1][iInd2][iInd3][iInd4][iInd5]);
					}
					free(mat_f7[iInd1][iInd2][iInd3][iInd4]);
				}
				free(mat_f7[iInd1][iInd2][iInd3]);
}
			free(mat_f7[iInd1][iInd2]);
}
		free(mat_f7[iInd1]);
}free(mat_f7);
}

float ********* newmat_f9(int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim, int wwwDim, int wwwwDim)
{
float *********matrixP;
	int iInd1;
	matrixP=(float *********)calloc(xDim,sizeof(float ********));
	for (iInd1=0; iInd1<xDim; iInd1++) 	{		
	matrixP[iInd1]=newmat_f8(yDim,  zDim,  uDim, vDim,wDim, wwDim,  wwwDim,  wwwwDim);
	}
	return matrixP;
}

void freemat_f9(float ********* mat, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim, int wwwDim)
{
	int iInd1;
	for (iInd1=0; iInd1<xDim; iInd1++) { freemat_f8(mat[iInd1], yDim,  zDim,  uDim, vDim,wDim, wwDim,wwwDim);}
free(mat); }

void clearmat_f9(float ********* mat, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim,int wwwDim,int wwwwDim)
{	int iInd1;
	for (iInd1=0; iInd1<xDim; iInd1++) { clearmat_f8(mat[iInd1], yDim,  zDim,  uDim, vDim,wDim, wwDim,wwwDim, wwwwDim);}
}


float ********** newmat_f10(int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim, int wwwDim, int wwwwDim,int wwwwwDim)
{float **********matrixP;
	int iInd1;
	matrixP=(float **********)calloc(xDim,sizeof(float *********));
	for (iInd1=0; iInd1<xDim; iInd1++) 	{		
	matrixP[iInd1]=newmat_f9(yDim,  zDim,  uDim, vDim,wDim, wwDim,  wwwDim,  wwwwDim, wwwwwDim);
	}	return matrixP;
}

void freemat_f10(float ********** mat, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim, int wwwDim,int wwwwDim)
{	int iInd1;
	for (iInd1=0; iInd1<xDim; iInd1++) { freemat_f9(mat[iInd1], yDim,  zDim,  uDim, vDim,wDim, wwDim,wwwDim, wwwwDim);}
free(mat); }

void clearmat_f10(float ********** mat, int xDim, int yDim, int zDim, int uDim, int vDim, int wDim, int wwDim,int wwwDim,int wwwwDim, int wwwwwDim)
{	int iInd1;
	for (iInd1=0; iInd1<xDim; iInd1++) 
	{ clearmat_f9(mat[iInd1], yDim,  zDim,  uDim, vDim,wDim, wwDim,wwwDim, wwwwDim, wwwwwDim);}
}

