PROGRAM entrtax
USE numerical_libraries
IMPLICIT NONE

! *****************  PARAMETER VALUES
! grids
INTEGER, PARAMETER :: da1=40,da2=220 ! # asset levels for each grid
INTEGER, PARAMETER :: da=da1+da2     !370       ! # asset levels 
INTEGER, PARAMETER :: dr=2     ! # entrep. ability realiz. 
INTEGER, PARAMETER :: dy=5     ! # income realizations
INTEGER, PARAMETER :: dk=da    ! # k level
! preferences and technology
REAL, PARAMETER :: bet=.867
REAL, PARAMETER :: gam=1.5
REAL, PARAMETER :: delt=.06     ! capital deprec.
REAL, PARAMETER :: eta=1.0      ! altruism toward children
REAL, PARAMETER :: ni=0.88  ! decr returns
REAL, PARAMETER :: alph=.33     ! capital share in non entr sector
REAL, PARAMETER :: abig=1        ! constant in nonentr prod fn
! degree of decreasing returns to entrep. inv.
! grid for a
REAL, PARAMETER :: mina=0.0
REAL, PARAMETER :: maxa=1700
! entrepreneurs
REAL, PARAMETER :: mink=0.05    ! minimum investment level 
REAL, PARAMETER :: maxk=maxa    ! maximum investment level
! aging
REAL, PARAMETER :: pyou=.9778   ! prob. staying young
REAL, PARAMETER :: pold=.911    ! prob. staying old (not dying)
! government parameters
REAL, PARAMETER :: replrate=0.4 ! repl. rate for pensions
REAL, PARAMETER :: tauc=0.0 !0.11   ! consumption tax
REAL, PARAMETER :: taua=0.0         ! capital income tax
! cricri
!INTEGER, PARAMETER :: indtaua=0 ! 0 if taua=0, 1 if taua>0
INTEGER, PARAMETER :: indtaua=1 ! 0 if taua=0, 1 if taua>0
!REAL, PARAMETER :: taue=0.20
REAL, PARAMETER :: tauls=0.0    ! lump sum tax
REAL, PARAMETER :: exem=500 !20.0    ! estate taxes exemption level
REAL, PARAMETER :: taub=0.0     ! tax rate on estates
REAL, PARAMETER :: gfrac=0.0  ! frac gov exp / gdp
REAL, PARAMETER :: debtfrac=0.10 ! frac gov debt /total capital
! enforcement
REAL, PARAMETER :: eff=0.75     ! prop k kept when defaulting
! transition matrix nonzero elements
INTEGER, PARAMETER :: nyoung=dr*dy*da   ! # possible states for young w or entr
INTEGER, PARAMETER :: noe=da*dr         ! # possible states for old entr
INTEGER, PARAMETER :: nstates=2*nyoung+noe+da   ! # states (total)
INTEGER, PARAMETER :: nonzero=2*(dy*dr+dr+1)*nyoung+(dy*dr+dr+1)*noe+&
                        &       (dy*dr+1)*da
INTEGER, PARAMETER :: sizeM=2*nyoung+noe+da     !dimension of trans mat M
! number of iterations on iterakhat for which we want to save value functions
INTEGER, PARAMETER :: nite=6

! *****************  VARIABLES
! indexes
INTEGER :: i,i2,j,j1,j2,jj,l,ll,OpenStatus
INTEGER, DIMENSION(1) :: imax,indanet
INTEGER, DIMENSION(2) :: imaxmat
! convergence criteria
REAL :: epsi,epsimin,epsinv,epsinvmin,epsir,epsirmin,epsigov,epsigovmin
INTEGER :: epsihato ! kohat-newkohat: how bc changes across iter for old
INTEGER :: epsihaty ! kyhat-newkyhat: how bc changes across iter for young
INTEGER :: epsihat  ! epsihat=abs((kyhat-newkyhat)+(kohat-newkohat))=0
                    ! iterate on val funs and bc until it's zero.
! equilibrium risk-free interest rate and wages
REAL :: rbar,rbarmin,rbarmax,rimplied,wage,wageimplied
! pensions
REAL :: transf
! grids
REAL, DIMENSION(da) :: a,anet       ! grid for assets
REAL, DIMENSION(dk) :: k        ! grid for k
REAL, DIMENSION(dr) :: r        ! grid for entrepr. ability
REAL, DIMENSION(dy) :: y        ! grid for worker ability   
REAL, DIMENSION(dr*dy,dr*dy) :: Pyr,Pyrtr ! joint distr. of y and r
REAL, DIMENSION(dr,dr) :: Pr, Prtr  ! p(r'|r)
REAL, DIMENSION(dy,dy) :: Py,Pytr   ! p(y'|y)
REAL, DIMENSION(dy*dr) ::   invyr   ! invariant distr of y and r
REAL, DIMENSION(dy) ::      invy    ! invariant distr of y and r
REAL, DIMENSION(dr) :: invr         ! inv dist for r
! taxes estimated using Gouveia Strauss tau=b-b*(s*y**p+1)**(-1/p)
! stax depends on income normalization
REAL :: btaxw,staxw,ptaxw,staxwbase,avgywsim
REAL :: btaxe,staxe,ptaxe,staxebase,avgyesim
!value functions
! young
REAL, DIMENSION(da,dy,dr) :: Vy   ! young
REAL, DIMENSION(da,dy,dr) :: Vye  ! young that is entrep for this period
REAL, DIMENSION(da,dy,dr) :: Vyw  ! young that is worker for this period
! old
REAL, DIMENSION(da,dr) :: Voee   ! old entrepreneur staying entrep
REAL, DIMENSION(da) :: Vow       ! old, retired, worker
REAL, DIMENSION(da,dr) :: Voe    ! old entrepreneur
! defaulted guys
REAL, DIMENSION(dk,dy,dr) :: Vwkeff ! defaulted worker
REAL, DIMENSION(dk) :: Vokeff    ! defaulted OLD worker
! decendants
REAL, DIMENSION(da) :: Vynet    ! val fun for descendant (net of estate tax)
REAL, DIMENSION(da) :: EVnewbw   ! exp value newborn worker
REAL, DIMENSION(da,dr) :: EVnewbe    ! exp value newborn entr
REAL, DIMENSION(da,dy,dr) :: EVy
! policy functions
! young
INTEGER, DIMENSION(da,dy,dr) :: apolye,kpolye ! young that is entr for this period
INTEGER, DIMENSION(da,dy,dr) :: apolyw        ! young that is worker this period
INTEGER, DIMENSION(da,dy,dr) :: apoly,kpoly   ! young
! old
INTEGER, DIMENSION(da) :: apolow              ! old, retired, worker
INTEGER, DIMENSION(da) :: apolownet           ! as above net of estate tax
INTEGER, DIMENSION(da,dr) :: apoloe,kpoloe    ! old entrepreneur
INTEGER, DIMENSION(da,dr) :: apoloenet        ! as above net of estate tax
! exogenous investment limits
INTEGER, DIMENSION(da,dy,dr) :: kyhat         ! young entr: max k(a,y,r)
INTEGER, DIMENSION(da,dr) :: kohat            ! old entr: max k(a,r)
INTEGER, DIMENSION(da,dy,dr) :: newkyhat      ! 
INTEGER, DIMENSION(da,dr) :: newkohat         ! 
! transition matrix
INTEGER, DIMENSION(nonzero) :: colM, rowM     ! row and col index
REAL, DIMENSION(nonzero) :: valM              ! value (trans probability)
! invariant distribution
REAL, DIMENSION(nstates) :: invm,invm1  ! invar distr prob
REAL, DIMENSION(da) :: prgrid           ! invariant distr on a
REAL, DIMENSION(da) :: prgridyw,prgridye,prgridoe,prgridow  ! same by groups
REAL :: totayw,totaye,totaow,totaoe
REAL, DIMENSION(nstates-da) :: invlevk,invrk  ! k and r level corr to invm
INTEGER, DIMENSION(nstates-da):: invpolk      ! k policy corr to invm
REAL :: totk,inck   !capital employed by entrepreneur and entr gross product
REAL :: tota,k2gdp,totkcorp,gdp   ! total a, k2gdp ratio, total k in corp sector
REAL :: ykshare,totke ! share of gross income to entrepr, totke
REAL :: yktotsh        !total share of income that goes to capital              
REAL :: totentr                         ! number of entrepreneurs
REAL :: totret                          ! number of retirees
REAL :: totL,toteffL    ! number of workers  and total efficiency units of work in the corporate sector
REAL :: beq2gdp !beq2w                      ! bequests as a fraction of gdp,
INTEGER, DIMENSION(nstates) :: ifswitchew         ! 1=if from e to w
INTEGER, DIMENSION(nstates) :: ifswitchwe         ! 1=if from w to e
REAL ::  propewswitch, propweswitch               ! prop. of switch from e to w
! government revenues
REAL, DIMENSION(nstates) :: vectaxcw,vectaxce,vectaxl,vectaxe,vectaxa,vectaxbw,vectaxbe
REAL, DIMENSION(nstates) :: vectotincw,vecwe2yw,vecwe2ye
REAL :: tottaxcw,tottaxce,tottaxe,tottaxa,tottaxbw,tottaxbe,tottaxl,totincw
REAL :: govdebt,govbal,govbal1,govbalold,govbalinf,govbalsup
REAL :: taubal,taubal1,taubalold,taubalinf,taubalsup
! temporary objects
REAL :: ytaxw,taxw,taxo,ytaxo
REAL, DIMENSION(dk) :: ytaxe,taxe
REAL, DIMENSION(da) :: ucons,cs
REAL, DIMENSION(da,da) :: uconsold
REAL, DIMENSION(da,da,dr,dk) :: uconsolde
REAL, DIMENSION(da,da,dy) :: uconsw
REAL, DIMENSION(da,da,dr-1,dk) :: uconse ! note change in dimensions nnnnn
REAL, DIMENSION(dk) :: uconsl,csl
REAL, DIMENSION(da,dy,dr) :: newVy
REAL, DIMENSION(da,dy,dr) :: newVyw,newVye
REAL, DIMENSION(da,dr) :: newVoe    ! old entrepreneur
REAL, DIMENSION(da) :: newVow       ! old, retired, worker
REAL, DIMENSION(da) :: Vowtemp
REAL, DIMENSION(da):: Vywtemp
REAL, DIMENSION(dk,da) :: Vyetemp
REAL, DIMENSION(dk,da) :: Veetemp
REAL, DIMENSION(dk,da) :: Voeetemp
REAL, DIMENSION(sizeM) :: sumrowM
REAL :: ahere,khere,rhere,entinchere,winchere
! miscellanea
REAL, DIMENSION(dy) ::eigvaly
COMPLEX, DIMENSION(dy) :: eigvalcy
REAL, DIMENSION(dy*dr) ::eigvalyr
COMPLEX, DIMENSION(dy*dr) :: eigvalcyr
REAL, DIMENSION(dy,dy) ::eigvecy
COMPLEX, DIMENSION(dy,dy) :: eigveccy
REAL, DIMENSION(dy*dr,dy*dr) ::eigvecyr
COMPLEX, DIMENSION(dy*dr,dy*dr) :: eigveccyr
REAL, DIMENSION(dr) ::eigvalr
COMPLEX, DIMENSION(dr) :: eigvalcr
REAL, DIMENSION(dr,dr) ::eigvecr
COMPLEX, DIMENSION(dr,dr) :: eigveccr
INTEGER :: counter,crow,count1,count2

INTEGER :: iterar,iterarmax,itera,iteragov,iteragovmax,iterakhat
CHARACTER(20) :: fname
REAL :: penalty,relax
! relaxation  parameter for gov. distance first  two starting pts for taul in algo
REAL :: relaxgov,pertgov
REAL, DIMENSION(50) :: fundiff,funtota,funtotk,funrbar
REAL :: we2ye,we2yw,we2ywmedian,we2yemedian ! wealth to income ratio for entrep and workers
REAL :: gridabreak  !cutoff for two types of grid
INTEGER :: bracket,noneedrbarmax ! noneedrbarmax is a switch indicator 
REAL :: fundiffnow,fundiffmin,fundiffmax

! define val funs that we save when iterating on iterakhat to speed up computation time
!value functions
REAL, DIMENSION(da,dy,dr,nite) :: Vyer   ! young entr for the period
REAL, DIMENSION(da,dy,dr,nite) :: Vywr   ! young worker for the period
REAL, DIMENSION(da,dy,dr,nite) :: Vyr    ! young
REAL, DIMENSION(da,dr,nite) :: Voeer     ! old entrepreneur staying entrep
REAL, DIMENSION(da,nite) :: Vowr         ! old, retired, worker
REAL, DIMENSION(da,dr,nite) :: Voer  ! old entrepreneur

INTEGER :: counterinvm ! counter used when computing w2's
REAL :: incomei, w2iwi,w2iei,kborrowed ! convenient constants used to compute w2's

REAL :: ykshare1    !previous wrong def of ykshare
REAL :: totkborr    !total amount borrowed by e
REAL :: totyshe     !total shadow labor income for e
REAL, DIMENSION(nstates-da) :: invkborr ! capital borrowed by e for each state var
REAL, DIMENSION(nstates-da) :: invyshe ! shadow y for e for each state var

! the following used in the median w/y computation
INTEGER :: nentr,nywork
INTEGER, DIMENSION(nstates) :: whoise   !=1 if entr, 0 if y work, 2 if old ret
REAL, ALLOCATABLE, DIMENSION(:) :: vecwe2yeonly,invmeonly
REAL, ALLOCATABLE, DIMENSION(:) :: vecwe2ywonly,invmywonly

! ******************  INTERFACE SUBROUTINES
INTERFACE
SUBROUTINE linspace (xmin,xmax,npoints,lspace)
IMPLICIT NONE
REAL, INTENT(IN) :: xmin,xmax
INTEGER, INTENT(IN) :: npoints
REAL, DIMENSION(npoints), INTENT(OUT) :: lspace
END SUBROUTINE linspace

SUBROUTINE  interplin(l,x,y,n,z,v)
IMPLICIT NONE
INTEGER, INTENT(IN) :: l
INTEGER, INTENT(IN) :: n
REAL, DIMENSION(l), INTENT(IN) :: x
REAL, DIMENSION(l), INTENT(IN) :: y
REAL, DIMENSION(n), INTENT(IN) :: z
REAL, DIMENSION(n), INTENT(OUT) :: v
END SUBROUTINE

SUBROUTINE checkrow1 (A,dA)
IMPLICIT NONE
REAL, DIMENSION(:,:), INTENT(IN) :: A
INTEGER, INTENT(IN) :: dA
END SUBROUTINE

SUBROUTINE quantilweighted (series,weights,qprop,quant)
IMPLICIT NONE
REAL, DIMENSION(:), INTENT(IN) :: series,weights
REAL, INTENT(IN) :: qprop
REAL, INTENT(OUT) :: quant
END SUBROUTINE

END INTERFACE

fname="indcolM"
OPEN (unit=32,file=fname,status="replace", &
&       action="write",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
WRITE (unit=32, fmt=*) "indcolM"
CLOSE (unit=32)

! *******************  INITIALIZE STUFF
relax=0.0 ! relaxation parameter for val. funcs (weight on OLD iteration)
relaxgov=0.0    ! relax par for tau. weight on OLD iteration
pertgov=.005
epsimin=4e-05
epsinvmin=1e-06
epsirmin=1e-04 
epsigovmin=1e-04
penalty=-1e+7
iterarmax=50
iteragovmax=20

invm=1.0/REAL(nstates)

Vye=0.0
Vyw=0.0
Vy=0.0
Voee=0.0
Vow=0.0
Voe=0.0

! initialize val fns saved to see if we can speed up

Vyer=0.0
Vywr=0.0
Vy=0.0
Voeer=0.0
Vowr=0.0
Voer=0.0     

!Gouveia Strauss parameters
!btaxw=.32
!staxw=.2154
!ptaxw=.7646
!btaxe=.2562
!staxe=.42
!ptaxe=1.4
!
btaxw=0
staxw=.2439
ptaxw=.8179
btaxe=btaxw
staxe=0
ptaxe=ptaxw
! way to impose proportional taxation?
!staxw=1e8
!staxe=1e8
!btaxe=.25
!btaxw=.18

avgywsim=1.33
avgyesim=1.33
!stax is estimated on inc/25000
!so staxest*(y/25000)**p=staxbar*(45/25)**p * (y/45000)**p
staxwbase=staxw*(45/25)**ptaxw
!note: basically we are normalizing to avg inc w also for e!
staxebase=staxe*(45/25)**ptaxe  !note: basically we are normalizing to avg inc w also for e!
!further correction for ymedium in sim
staxw=staxwbase*(avgywsim)**(-ptaxw)
staxe=staxebase*(avgyesim)**(-ptaxe)

!******************** LOAD STUFF
fname="yentr2"
! reading income and transitions
open (unit=32,file=fname,status="old", &
&       action="read",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
READ (unit=32, fmt=*) y

Py=0
DO i=1,dy
    READ (unit=32, fmt=*) Py(i,:)
    !we'll normalize the submatrix below
    Py(i,:)=Py(i,:)/SUM(Py(i,:))
END DO
CLOSE (unit=32)

gridabreak=3.0
! Entrepreneurial ability. ALWAYS SET THE FIRST ONE TO ZERO!
r=(/0.0, 0.514/)
Pr(1,:)=(/0.964,0.036/)
Pr(2,:)=(/0.206,0.794/)

CALL checkrow1 (Pr,dr)

! compute invariant distr for Pr
Prtr=TRANSPOSE(Pr)
CALL evcrg (dr,Prtr,dr,eigvalcr,eigveccr,dr)
eigvalr=REAL(eigvalcr)
eigvecr=REAL(eigveccr)
imax=MAXLOC(eigvalr)
invr=eigvecr(:,imax(1))
invr=invr/SUM(invr)
WRITE(*,*)  "Invariant distribution on r"
WRITE(*,*) invr

! make up joint distr for y and r. y is outside
DO j=1,dy       !   y today
    DO jj=1,dy  !   y tomorrow
        Pyr((j-1)*dr+1:j*dr,(jj-1)*dr+1:jj*dr)=Py(j,jj)*Pr      
    END DO
END DO
DO i=1,dy*dr
    Pyr(i,:)=Pyr(i,:)/SUM(Pyr(i,:)) 
END DO

Pyrtr=TRANSPOSE(Pyr) ! compute inv dist for joint of y and r
CALL evcrg (dy*dr,Pyrtr,dy*dr,eigvalcyr,eigveccyr,dy*dr)
eigvalyr=REAL(eigvalcyr)
eigvecyr=REAL(eigveccyr)
imax=MAXLOC(eigvalyr)
invyr=eigvecyr(:,imax(1))
invyr=invyr/SUM(invyr)

Pytr=TRANSPOSE(Py)    ! compute inv dist for y 
CALL evcrg (dy,Pytr,dy,eigvalcy,eigveccy,dy)
eigvaly=REAL(eigvalcy)
eigvecy=REAL(eigveccy)
imax=MAXLOC(eigvaly)
invy=eigvecy(:,imax(1))
invy=invy/SUM(invy)

fname="cacca"
OPEN (unit=32,file=fname,status="replace", &
&       action="write",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
WRITE (unit=32, fmt=*) "***************************************"
WRITE (unit=32, fmt=*) "da=",da,"  dk=",dk,"  maxa=",maxa
WRITE (unit=32, fmt=*) "da1=",da1,"   da2=",da2,"   gridabreak=",gridabreak
WRITE (unit=32, fmt=*) "bet=",bet,"   gam=",gam,"   eta=",eta
WRITE (unit=32, fmt=*) "ni= ",ni,"  theta=",r(2),"   eff=",eff
WRITE (unit=32, fmt=*) "delt=",delt   
WRITE (unit=32, fmt=*) "alph=",alph,"   abig=",abig
WRITE (unit=32, fmt=*) "repl rate=",replrate,"   tauc=",tauc,"   taua=",taua
WRITE (unit=32, fmt=*)  "tauls=",tauls,"  exem=",exem,"  taub=",taub
WRITE (unit=32, fmt=*) "btaxw=",btaxw,"   staxw=",staxw,"   ptaxw=",ptaxw
WRITE (unit=32, fmt=*) "btaxe=",btaxe,"   staxe=",staxe,"   ptaxe=",ptaxe
WRITE (unit=32, fmt=*) "gfrac=",gfrac,"   debtfrac=",debtfrac
WRITE (unit=32, fmt=*) "***************************************"
CLOSE (unit=32)

!********************  START COMPUTING
!CALL linspace(SQRT(mina),SQRT(maxa),da,a)
!a=a**2
CALL linspace(mina,gridabreak,da1,a(1:da1))
!CALL linspace(sqrt(gridabreak),sqrt(maxa),da2+1,a(da1:da))
CALL linspace(0.0,sqrt(maxa-gridabreak),da2+1,a(da1:da))
a(da1:da)=gridabreak+a(da1:da)**2
CALL linspace(mink,gridabreak,da1,k(1:da1))
CALL linspace(0.0,sqrt(maxk-gridabreak),da2+1,k(da1:da))
k(da1:da)=gridabreak+k(da1:da)**2


rbarmin=0.063
rbarmax=0.067

anet=a
WHERE (anet.GT.exem) anet=(a-exem)*(1-taub)+exem

!loop for government TBD
!*********************
iteragov=1
taubal=0.1415
! initialize bounds at very large values
taubalinf=0.0
govbalinf=-10
taubalsup=1.0
govbalsup=10
epsigov=1.0
DO WHILE ((epsigov>epsigovmin).AND.(iteragov.LE.iteragovmax))
    ! loop for rbar
    ! init stuff for rbar loop INSIDE govt bc
    epsir=10
    IF (iteragov.GT.1) THEN
        rbarmin=rbar-.002
        rbarmax=rbar+.002
    END IF
    fundiff=0
    iterar=1
    bracket=1
    noneedrbarmax=0
    ! loop on equilibrium interest rate
    DO WHILE ((epsir>epsirmin).AND.(iterar.LE.iterarmax))
        !false position method. first we must compute the value of fundiff in the extremes
        !(bracket=1 and 2), then we start interpolating the extremes    
        IF (bracket==1) THEN
            rbar=rbarmin
        ELSE IF ((bracket==2).AND.(noneedrbarmax==0)) THEN
            rbar=rbarmax
        ELSE
            !this should be the zero for the linear interpolation
            rbar=rbarmin-(rbarmax-rbarmin)*fundiffmin/(fundiffmax-fundiffmin)
        END IF
        !wage=1
        wage=(1-alph)*abig*((rbar+delt)/(alph*abig))**(alph/(alph-1))
        transf=replrate*wage*DOT_PRODUCT(y,invy)

        ! we now compute U(c) since it does not depend on V and borrowing constr
        uconsold=0.0    ! old retired.   rows=a, column=a'
        DO i=1,da ! today's assets
            ytaxo=transf+(1-indtaua)*rbar*a(i)
            taxo=(btaxw-btaxw*(staxw*ytaxo**ptaxw+1)**(-1/ptaxw))*ytaxo &
            & +indtaua*rbar*a(i)*taua ! cricri: do we want to tax these?  +taubal*ytaxo
            cs=(a(i)*(1+rbar)+transf-a-tauls-taxo)/(1+tauc)
            WHERE (cs>0)
                ucons=(cs**(1-gam))/(1-gam)
            ELSEWHERE 
                ucons=penalty
            END WHERE
            uconsold(i,:)=ucons
        END DO
        uconsolde=0.0       ! old entrepreneur staying entr (da,da',dr,dk)
        DO i=1,da       !today's assets
            DO j=1,dr   ! today's r
                ytaxe=r(j)*k**ni-delt*k-rbar*(k-a(i))
                ! those with r=0 can have negative income. set taxes to zero in such case
                WHERE (ytaxe>0.0) 
                    taxe=(btaxe-btaxe*(staxe*ytaxe**ptaxe+1)**(-1/ptaxe))* &
                    & ytaxe ! cricri +taubal*ytaxe
                ELSEWHERE 
                    taxe=0.0
                END WHERE
                DO jj=1,da  ! tomorrow's a'
                    csl=(ytaxe-taxe+a(i)-a(jj)-tauls)/(1+tauc)
                    WHERE (csl>0.0)                         
                        uconsl=(csl**(1-gam))/(1-gam)
                    ELSEWHERE 
                        uconsl=penalty
                    END WHERE
                    uconsolde(i,jj,j,:)=uconsl                      
                END DO
            END DO
        END DO              
        uconsw=0.0  ! young worker  (da,da',dy) note: does not depend on r!
        DO i=1,da ! today
            DO j=1,dy ! today's y                       
                ytaxw=wage*y(j)+(1-indtaua)*rbar*a(i)                       
                taxw=(btaxw-btaxw*(staxw*ytaxw**ptaxw+1)**(-1/ptaxw))&
                    &   *ytaxw+indtaua*rbar*a(i)*taua+taubal*ytaxw
                cs=((1+rbar)*a(i)+wage*y(j)-taxw-a-tauls)/(1+tauc)
                WHERE (cs>0)
                    ucons=(cs**(1-gam))/(1-gam)
                ELSEWHERE 
                    ucons=penalty
                END WHERE
                uconsw(i,:,j)=ucons
            END DO
        END DO
        uconse=0.0  !   young e     (da,da',dr,dk)
        DO i=1,da       !today's assets
            DO j=2,dr   ! today's r ! changed from dy=1,dr
                ! nnnnn j1 does not appear to be used here
                ! DO j1=1,dy    !today's y  
                    ytaxe=r(j)*k**ni-delt*k-rbar*(k-a(i))
                    taxe=(btaxe-btaxe*(staxe*ytaxe**ptaxe+1)**(-1/ptaxe)) &
                    &   *ytaxe ! cricri +taubal*ytaxe
                    DO jj=1,da  ! tomorrow's a'
                        csl=(ytaxe-taxe+a(i)-a(jj)-tauls)/(1+tauc)
                        WHERE (csl>0.0)
                            uconsl=(csl**(1.0-gam))/(1.0-gam)
                        ELSEWHERE 
                            uconsl=penalty
                        END WHERE
                        uconse(i,jj,j-1,:)=uconsl ! nnnn changed index for j
                    END DO
                !END DO nnnnn
            END DO
        END DO

        epsi=10
        ! investment limit iniat. start over at the max k for any given rbar.
        ! later on we will check if there is a more efficient way to do it
        kyhat=dk 
        kohat=dk
        ! and impose that people with r=0 cannot borrow (it would be true anyway)
        ! might as well save computations
        kyhat(:,:,1)=0
        kohat(:,1)=0    
        iterakhat=1
        epsihat=1
        DO WHILE (epsihat>0) ! loop on endogenous borrowing constraints
            itera=0
            epsihat=0
            ! start value function iterations, given khat for young and old
            epsi=10
            IF (iterakhat.LE.nite .AND. iterar.NE.1) THEN
                Vye=Vyer(:,:,:,iterakhat) 
                    Vyw=Vywr(:,:,:,iterakhat)
                        Vy=Vyr(:,:,:,iterakhat)
                Voee=Voeer(:,:,iterakhat)
                Vow=Vowr(:,iterakhat)
                Voe=Voer(:,:,iterakhat)
            END IF
            DO WHILE (epsi>epsimin) ! loop on value funcs for given b.c 
                itera=itera+1
                ! compute expected value of V of NEWBORNS
                ! only NEWBORN ENTREPRENEUR, INHERITS parent's r'
                EVnewbw=0.0
                EVnewbe=0.0 
                DO i=1,dy ! tomorrow
                    DO j=1,dr
                        call interplin(da,a,Vy(:,i,j),da,anet,Vynet)
                        EVnewbw=invyr((i-1)*dr+j)*Vynet+EVnewbw
                        EVnewbe(:,j)=invy(i)*Vynet+EVnewbe(:,j)
                    END DO
                END DO
                !loop for OLD WORKER
                DO i=1,da ! today's assets
                    Vowtemp=uconsold(i,:)+bet*pold*Vow+eta*bet*(1.0-pold)*EVnewbw
                    imax=MAXLOC(Vowtemp)
                    newVow(i)=Vowtemp(imax(1))
                    apolow(i)=imax(1)
                END DO  
                ! loop for old entrepreneur
                ! entrepreneur staying entrepreneur
                DO i=1,da       !today's assets
                    DO j=1,dr   ! today's r
                        DO jj=1,da  ! tomorrow's a'
                            Voeetemp(:,jj)=uconsolde(i,jj,j,:)+&
                            &   bet*pold*DOT_PRODUCT(Voe(jj,:),Pr(j,:))+&
                            &   eta*bet*(1.0-pold)*DOT_PRODUCT(EVnewbe(jj,:),Pr(j,:))
                            ! impose kohat
                            IF (kohat(i,j).LT.dk) THEN
                                !** when cannot borrow (kohat=last at which one can borrow)
                                Voeetemp(kohat(i,j)+1:,jj)=penalty
                            END IF
                        END DO
                        imaxmat=MAXLOC(Voeetemp)
                        Voee(i,j)=Voeetemp(imaxmat(1),imaxmat(2))
                        IF (Voee(i,j).GT.newVow(i)) THEN
                            newVoe(i,j)=Voee(i,j)
                            apoloe(i,j)=imaxmat(2)
                            kpoloe(i,j)=imaxmat(1)
                        ELSE
                            newVoe(i,j)=newVow(i)
                            apoloe(i,j)=apolow(i)
                            kpoloe(i,j)=-1              
                        END IF
                    END DO
                END DO
                EVy=0.0
                DO i=1,dy           !today
                    DO j=1,dr
                        DO i2=1,dy          !tomorrow
                            DO j2=1,dr
                                EVy(:,i,j)=Pyr((i-1)*dr+j,(i2-1)*dr+j2)*&
                                & Vy(:,i2,j2)+EVy(:,i,j)
                            END DO
                        END DO
                    END DO
                END DO
                !val fn for young that is a worker for the period   
                DO i=1,da ! today
                    DO j=1,dy ! today's y                       
                        DO jj=1,dr ! todays' r
                            Vywtemp=uconsw(i,:,j)+bet*pyou*EVy(:,j,jj)+&
                            &   bet*(1.0-pyou)*newVow
                            imax=MAXLOC(Vywtemp)
                            newVyw(i,j,jj)=Vywtemp(imax(1))
                            apolyw(i,j,jj)=imax(1)
                        END DO
                    END DO
                END DO
                
                ! NOTE THAT THE ** YOUNG** GUYS WITH ZERO ENTR ABILITY
                ! ALWAYS CHOOSE TO BE WORKERS, BECAUSE THIS WAY THEY GET
                ! THE WAGE. LET'S EXPLOIT THIS
                ! val fn for young that is a ENTR for the period    
                ! LET US COMPUTE IT ONLY FOR GUYS WITH POSITIVE R
                ! young entrepreneur decisions
                DO i=1,da       !today's assets
                    DO j=2,dr   ! today's r ! changed from dy=1,dr
                        DO j1=1,dy  !today's y
                            DO jj=1,da  ! tomorrow's a'
                                ! changed index in uncose for j nnnnn
                                Vyetemp(:,jj)=uconse(i,jj,j-1,:)+ &
                                &   bet*pyou*EVy(jj,j1,j)+ &
                                &   bet*(1.0-pyou)*DOT_PRODUCT(newVoe(jj,:),Pr(j,:))
                                ! impose kyhat
                                IF (kyhat(i,j1,j).LT.dk) THEN
                                    Vyetemp(1+kyhat(i,j1,j):,jj)=penalty
                                END IF                  
                            END DO
                            imaxmat=MAXLOC(Vyetemp)
                            newVye(i,j1,j)=Vyetemp(imaxmat(1),imaxmat(2))
                            apolye(i,j1,j)=imaxmat(2)
                            kpolye(i,j1,j)=imaxmat(1)
                            ! YOUNG decide if e or w
                            IF (newVye(i,j1,j).GT.newVyw(i,j1,j)) THEN  
                                newVy(i,j1,j)=newVye(i,j1,j)
                                apoly(i,j1,j)=apolye(i,j1,j)
                                kpoly(i,j1,j)=kpolye(i,j1,j)
                            ELSE
                                newVy(i,j1,j)=newVyw(i,j1,j)
                                apoly(i,j1,j)=apolyw(i,j1,j)
                                kpoly(i,j1,j)=-1            
                            END IF
                        END DO
                    END DO
                END DO
                ! now use the fact that YOUNG guys with r=0 always choose
                ! to be workers
                newVye(:,:,1)=newVyw(:,:,1)
                apolye(:,:,1)=apolyw(:,:,1)
                kpolye(:,:,1)=-1
                newVy(:,:,1)=newVyw(:,:,1)
                apoly(:,:,1)=apolyw(:,:,1)
                kpoly(:,:,1)=-1         

                epsi=MAXVAL(ABS(newVow-Vow))+MAXVAL(ABS(newVoe-Voe))+ &
                &   MAXVAL(ABS(newVye-Vye))+MAXVAL(ABS(newVyw-Vyw))+&
                &   MAXVAL(ABS(newVy-Vy))
                WRITE(*,*) itera,epsi
                Vow=(1.0-relax)*newVow+relax*Vow
                Voe=(1.0-relax)*newVoe+relax*Voe
                Vyw=(1.0-relax)*newVyw+relax*Vyw
                Vye=(1.0-relax)*newVye+relax*Vye
                Vy=(1.0-relax)*newVy+relax*Vy
            END DO ! WHILE
            CALL printvalfun()      
            ! now check temptation to run with borrowed money
            ! value function of the OLD WORKER STARTING OFF AFTER DEFAULT 
            ! (with assets k*eff)
            CALL interplin(da,a,Vow,dk,eff*k,Vokeff)
            DO i=1,da
                DO j=2,dr
                    count1=1
                    count2=1
                    DO WHILE (count1.GT.0)
                        IF (Voe(i,j).LT.Vokeff(count2)) THEN
                            newkohat(i,j)=count2-1
                            count1=0
                        END IF
                        count2=count2+1
                        IF (count2==(dk+1)) THEN 
                            newkohat(i,j)=dk
                            count1=0
                        END IF
                    END DO
                END DO
            END DO
            ! impose no borrowing for people with r=0, which we know would be true
            newkohat(:,1)=0
            epsihato=MAXVAL(ABS(newkohat-kohat))
            WRITE(*,*) "MAXVAL(newkohat-kohat)",MAXVAL(newkohat-kohat)
            kohat=newkohat

            ! value function of the young worker starting off after default 
            ! (with assets k*eff)
            DO j1=1,dy
                DO j=1,dr                   
                    CALL interplin(da,a,Vyw(:,j1,j),dk,eff*k,Vwkeff(:,j1,j))
                END DO
            END DO
            DO i=1,da
                DO j1=1,dy
                    DO j=2,dr
                        count1=1
                        count2=1
                        DO WHILE (count1.GT.0)
                            IF (Vye(i,j1,j).LT.Vwkeff(count2,j1,j)) THEN
                                newkyhat(i,j1,j)=count2-1
                                count1=0
                            END IF
                            count2=count2+1
                            IF (count2==(dk+1)) THEN 
                                newkyhat(i,j1,j)=dk
                                count1=0
                            END IF
                        END DO      
                    END DO
                END DO
            END DO
            ! impose no borrowing for people with r=0, which we know would be true
            newkyhat(:,:,1)=0
            epsihaty=MAXVAL(ABS(newkyhat-kyhat))
            WRITE(*,*) "MAXVAL(newkyhat-kyhat)",MAXVAL(newkyhat-kyhat)
            kyhat=newkyhat
            epsihat=epsihato+epsihaty
            WRITE (*,*) "iterakhat",iterakhat," epsihato",epsihato," epsihaty",epsihaty
            IF (iterakhat.LE.nite) THEN
                Vyer(:,:,:,iterakhat)=Vye
                Vywr(:,:,:,iterakhat)=Vyw
                Vyr(:,:,:,iterakhat)=Vy 
                Voeer(:,:,iterakhat)=Voee
                Vowr(:,iterakhat)=Vow
                Voer(:,:,iterakhat)=Voe
            END IF
            iterakhat=iterakhat+1
        END DO ! DO WHILE(countkhat)

        !constructing the TRANSITION MATRIX in sparse form
        ! sparse=row indices, col indices, values
        ! 
        ! order of the transition matrix:
        ! y workers-        r - y - assets
        ! y entrepreneurs-  r - y - assets
        ! old entr          r -     assets
        ! old                       assets
        !
        rowM=0
        colM=0
        valM=0.0
        !***************** assets net of bequest taxes
        DO i=1,da
            IF (a(apolow(i)).LE.exem) THEN
                apolownet(i)=apolow(i)
            ELSE
                indanet=MINLOC(ABS(a-(1-taub)*(a(apolow(i))-exem)-exem))
                apolownet(i)=indanet(1)
            END IF
        END DO
        DO i=1,da
            DO j=1,dr
                IF (a(apoloe(i,j)).LE.exem) THEN
                    apoloenet(i,j)=apoloe(i,j)
                ELSE
                    indanet=MINLOC(ABS(a-(1-taub)*(a(apoloe(i,j))-exem)-exem))
                    apoloenet(i,j)=indanet(1)
                END IF  
            END DO
        END DO
        counter=nonzero-(da*(dy*dr+1))+1    ! number of elements for the old
        !block transition oldw - ?
        DO i=1,da               !asset today
            crow=sizeM-da+i     !row of M
            !if reborn
            DO ll=1,dr          ! r tomorrow
                DO jj=1,dy      ! y tomorrow
                    rowM(counter)=crow
                    colM(counter)=(ll-1)*dy*da+(jj-1)*da+apolownet(i)
                    valM(counter)=invyr((jj-1)*dr+ll)*(1.0-pold)
                    counter=counter+1
                END DO
            END DO
            ! if remains old
            rowM(counter)=crow
            colM(counter)=2*nyoung+noe+apolow(i)
            valM(counter)=pold
            counter=counter+1
        END DO
        !block transition old entr - ?
        counter=2*(dy*dr+dr+1)*nyoung+1
        DO l=1,dr       ! r today
            DO i=1,da   ! a today
                crow=2*nyoung+(l-1)*da+i
                ! if reborn
                DO ll=1,dr ! r', the one the children inherit
                    DO jj=1,dy  ! child's y, drawn from invariant distrbn
                        rowM(counter)=crow
                        ! if remain entr, this is col
                        colM(counter)=(ll-1)*dy*da+(jj-1)*da+apoloenet(i,l)
                        ! if become work, add some elements to col
                        IF  (kpoloe(i,l).GT.0) THEN
                            colM(counter)=colM(counter)+nyoung
                        END IF
                        valM(counter)=(1.0-pold)*invy(jj)*Pr(l,ll)
                        counter=counter+1
                    END DO
                END DO
                ! if remains old
                IF  (kpoloe(i,l)==-1) THEN  ! becomes worker
                    rowM(counter)=crow
                    colM(counter)=2*nyoung+noe+apoloe(i,l)
                    valM(counter)=pold
                    counter=counter+1
                    DO ll=1,dr
                        rowM(counter)=crow
                        colM(counter)=2*nyoung+(ll-1)*da+apoloe(i,l)
                        valM(counter)=0.0
                        counter=counter+1
                    END DO
                ELSE                    ! remains entrepreneur
                    rowM(counter)=crow
                    colM(counter)=2*nyoung+noe+apoloe(i,l)
                    valM(counter)=0.0
                    counter=counter+1
                    DO ll=1,dr
                        rowM(counter)=crow
                        colM(counter)=2*nyoung+(ll-1)*da+apoloe(i,l)
                        valM(counter)=Pr(l,ll)*pold
                        counter=counter+1
                    END DO
                END IF      
            END DO
        END DO
        !block transition young work - ?        
        counter=1
        DO l=1,dr   !today
            DO j=1,dy   !today
                DO i=1,da   !today
                    crow=(l-1)*da*dy+(j-1)*da+i
                    !   if next period remains young
                    DO ll=1,dr ! tomorrow
                        DO jj=1,dy
                            rowM(counter)=crow
                            ! if remain work, this is col
                            colM(counter)=(ll-1)*dy*da+(jj-1)*da+apoly(i,j,l)
                            CALL checkcolM(1)
                            ! if become entr, add some elements to col
                            IF  (kpoly(i,j,l).GT.0) THEN
                                colM(counter)=colM(counter)+nyoung
                                CALL checkcolM(2)
                            END IF
                            valM(counter)=pyou*Pyr((j-1)*dr+l,(jj-1)*dr+ll)
                            counter=counter+1
                        END DO
                    END DO
                    !   if next period becomes old
                    IF  (kpoly(i,j,l)==-1) THEN     !   if remains worker
                        rowM(counter)=crow
                        colM(counter)=2*nyoung+noe+apoly(i,j,l)
                        CALL checkcolM(3)
                        valM(counter)=(1-pyou)
                        counter=counter+1
                        DO ll=1,dr
                            rowM(counter)=crow
                            colM(counter)=2*nyoung+(ll-1)*da+apoly(i,j,l)
                            CALL checkcolM(4)
                            valM(counter)=0.0
                            counter=counter+1
                        END DO
                    ELSE                            !   if becomes entr
                        rowM(counter)=crow
                        colM(counter)=2*nyoung+noe+apoly(i,j,l)
                        CALL checkcolM(5)
                        valM(counter)=0.0
                        counter=counter+1
                        DO ll=1,dr
                            rowM(counter)=crow                          
                            colM(counter)=2*nyoung+(ll-1)*da+apoly(i,j,l)
                            CALL checkcolM(6)
                            valM(counter)=Pr(l,ll)*(1-pyou)
                            counter=counter+1
                        END DO
                    END IF  
                END DO
            END DO
        END DO
        !block young entr - ?
        IF (counter.NE.nyoung*(dy*dr+dr+1)+1) WRITE(*,*) "counter does not match!!"
            DO l=1,dr   !today
                DO j=1,dy   !today
                    DO i=1,da   !today
                        crow=nyoung+(l-1)*da*dy+(j-1)*da+i
                    !   if next period remains young
                    DO ll=1,dr
                        DO jj=1,dy
                            rowM(counter)=crow
                            ! if becomes work, this is col                          
                            colM(counter)=(ll-1)*dy*da+(jj-1)*da+apoly(i,j,l)
                            ! if become entr, add some elements to col                          
                            IF  (kpoly(i,j,l).GT.0) THEN
                                colM(counter)=colM(counter)+nyoung
                            END IF
                            valM(counter)=pyou*Pyr((j-1)*dr+l,(jj-1)*dr+ll)
                            counter=counter+1
                        END DO
                    END DO
                    !   if next period becomes old                  
                    IF  (kpoly(i,j,l)==-1) THEN     !   if becomes worker
                        rowM(counter)=crow                      
                        colM(counter)=2*nyoung+noe+apoly(i,j,l)
                        valM(counter)=(1-pyou)
                        counter=counter+1
                        DO ll=1,dr
                            rowM(counter)=crow                      
                            colM(counter)=2*nyoung+(ll-1)*da+apoly(i,j,l)
                            valM(counter)=0.0
                            counter=counter+1
                        END DO
                    ELSE                            !   if becomes entr
                        rowM(counter)=crow                  
                        colM(counter)=2*nyoung+noe+apoly(i,j,l)
                        valM(counter)=0.0
                        counter=counter+1
                        DO ll=1,dr
                            rowM(counter)=crow                          
                            colM(counter)=2*nyoung+(ll-1)*da+apoly(i,j,l)
                            valM(counter)=Pr(l,ll)*(1-pyou)
                            counter=counter+1
                        END DO
                    END IF  
                END DO
            END DO
        END DO

        CALL checksumrowM()

        !   compute invariant distribution
        itera=0 
        epsinv=10
        DO WHILE (epsinv> epsinvmin)
            invm1=invm
            invm=0.0
            ! this do loop is the product M'*invm, M sparse
            ! to transpose M, we simply use colM instead of rowM
            ! invm= new inv distr
            ! invm1= old inv distr
            DO i=1,nonzero
                invm(colM(i))=invm(colM(i))+invm1(rowM(i))*valM(i)
            END DO
            epsinv=MAXVAL(ABS(invm-invm1))
            itera=itera+1
        END DO
        invm=invm/sum(invm)
        WRITE(*,*) "invdistr computed"

        !invariant distribution of a on young workers
        prgridyw=0.0
        DO i2=1,dy*dr
            prgridyw=prgridyw+invm((i2-1)*da+1:i2*da)
        END DO
        !invariant distribution of a on young entr
        prgridye=0.0
        DO i2=1,dy*dr
            prgridye=prgridye+invm(nyoung+(i2-1)*da+1:nyoung+i2*da)
        END DO                                                          
        !invariant distribution of a on old entr
        prgridoe=0.0
        DO i2=1,dr
            prgridoe=prgridoe+invm(2*nyoung+(i2-1)*da+1:2*nyoung+i2*da)
        END DO
        ! compute total number of entrepreneurs (which should also be a fraction,
        ! since we normalized total population to be 1)
        totentr=SUM(prgridye)+SUM(prgridoe)
        ! compute number of workers in the corporate sector
        totL=SUM(prgridyw)
        ! compute number of retirees 
        totret=1-totentr-totL
        !invariant distribution of a on old workers
        prgridow=invm(nstates-da+1:)
        !total invariant distr
        prgrid=prgridyw+prgridye+prgridoe+prgridow
    
        invpolk=0   ! k pol fn corresponding to each element of invm
        invlevk=0.0 ! k level ...
        invrk=0.0   ! return corresponding to each element of invm (except old work)
        invkborr=0.0    !amount borrowed by e, kbor=k-a
        invyshe=0.0     !shadow y for e
        ifswitchew=0    ! 1 if switch from e to non e (w or ret)
        ifswitchwe=0    ! 1 if switch from w to e
        toteffL=0.0 ! total efficiency units (.neq.totL because entr choice depends on y).
        counter=1
        DO l=1,dr   ! young workers
            invrk((l-1)*da*dy+1:l*da*dy)=r(l)
            DO j=1,dy
                DO i=1,da               
                    invpolk(counter)=kpoly(i,j,l)
                    IF (kpoly(i,j,l).GT.0) THEN
                        invlevk(counter)=k(kpoly(i,j,l))
                        invkborr(counter)=k(kpoly(i,j,l))-a(i)                  
                        invyshe(counter)=y(j)*wage
                        ifswitchwe(counter)=1
                    ELSE
                        toteffL=toteffL+y(j)*invm((l-1)*da*dy+(j-1)*da+i)
                    END IF
                    counter=counter+1
                END DO
            END DO
        END DO  
        DO l=1,dr   ! young entrepreneurs
            invrk(nyoung+(l-1)*da*dy+1:nyoung+l*da*dy)=r(l)
            DO j=1,dy
                DO i=1,da
                    invpolk(counter)=kpoly(i,j,l)
                    IF (kpoly(i,j,l).GT.0) THEN

                        invlevk(counter)=k(kpoly(i,j,l))
                        invkborr(counter)=k(kpoly(i,j,l))-a(i)
                        invyshe(counter)=y(j)*wage
                    ELSE
                        ifswitchew(counter)=1
                        toteffL=toteffL+y(j)*invm(nyoung+(l-1)*da*dy+(j-1)*da+i)
                    END IF
                    counter=counter+1
                END DO
            END DO
        END DO
        DO l=1,dr   !   old entrepreneurs
            invrk(2*nyoung+(l-1)*da+1:2*nyoung+l*da)=r(l)
            DO i=1,da
                invpolk(counter)=kpoloe(i,l)
                IF (kpoloe(i,l).GT.0) THEN
                    invlevk(counter)=k(kpoloe(i,l))
                    invkborr(counter)=k(kpoloe(i,l))-a(i)
                    invyshe(counter)=transf
                ELSE
                    ifswitchew(counter)=1
                END IF
                counter=counter+1
            END DO
        END DO
        ! capital EMPLOYED by entreprepr
        totk=DOT_PRODUCT(invlevk,invm(:nstates-da))
        !gross entrepreneurial income. here I think it is ok because
        ! F=(1-delt)k + thet* k**nu, so thet*k**nu has not been subtracted by depr yet
        inck=DOT_PRODUCT(invrk*(invlevk**ni),invm(:nstates-da)) 
        tota=DOT_PRODUCT(a,prgrid)
        totayw=DOT_PRODUCT(a,prgridyw)
        totaye=DOT_PRODUCT(a,prgridye)
        totaow=DOT_PRODUCT(a,prgridow)
        totaoe=DOT_PRODUCT(a,prgridoe)

        !computed from tota=totk+totcorp+debtfrac*(totk+totcorp)
        totkcorp=tota/(1+debtfrac)-totk
        !rimplied=abig*alph*(totkcorp/totL)**(alph-1)-delt
        rimplied=abig*alph*(totkcorp/toteffL)**(alph-1)-delt
        wageimplied=abig*(1-alph)*((rimplied+delt)/(abig*alph))**(alph/(alph-1))
        govdebt=debtfrac*(totkcorp+totk)
        !using wage and rbar, not implied. Gross of depreciation
        !gdp=wage*totL+(rbar+delt)*totkcorp+inck
        gdp=wage*toteffL+(rbar+delt)*totkcorp+inck
        !beq2w=DOT_PRODUCT(a,(prgridoe+prgridow))*(1-pold)/tota
        beq2gdp=DOT_PRODUCT(a,(prgridoe+prgridow))*(1-pold)/gdp
        k2gdp=(totk+totkcorp)/gdp
        !total wealth held by entrepreneurs (at beginning of period)
        totke=DOT_PRODUCT(a,prgridye)+DOT_PRODUCT(a,prgridoe)
        ! ykshare1 is the fration of gross income produced by the _entr sector_
        ykshare1=inck/gdp
        !ykshare=fraction of gross income that goes to entrepreneurs (net of interest payment)
        totkborr=DOT_PRODUCT(invkborr,invm(:nstates-da))
        totyshe=DOT_PRODUCT(invyshe,invm(:nstates-da))
        !ykshare=(inck-(rbar+delt)*totkborr)/gdp
        ykshare=(inck-rbar*totkborr)/gdp
        ! income to capital
        yktotsh=(inck+(rbar+delt)*totkcorp)/gdp
        !fraction of e switching from e to y and from y to e
        propewswitch=DOT_PRODUCT(ifswitchew,invm)/(SUM(prgridye)+SUM(prgridoe))
        propweswitch=DOT_PRODUCT(ifswitchwe,invm)/SUM(prgridyw)
        CALL printinvdistr()

        fundiffnow=rbar-rimplied
        fundiff(iterar)=fundiffnow
        funtota(iterar)=tota
        funtotk(iterar)=totk
        funrbar(iterar)=rbar

        fname="cacca"
        OPEN (unit=32,file=fname,status="OLD", &
        &       action="write",position="append",iostat=OpenStatus)
        IF (OpenStatus.NE.0) THEN
            WRITE(*,*) 'problems opening ', fname
        END IF
        WRITE (unit=32, fmt=*) "***********************************"
        WRITE (unit=32, fmt=*) "iterar",iterar,"     iteragov=",iteragov
        WRITE (unit=32, fmt=*) "RIMPLIED",rimplied, "   rbar",rbar
        WRITE (unit=32, fmt=*) "rbarmin",rbarmin, "   rbarmax",rbarmax
        WRITE (unit=32, fmt=*) "wageimplied=",wageimplied 
        WRITE (unit=32, fmt=*)  "fundiffnow=",fundiffnow
        WRITE (unit=32, fmt=*) "fundiffmin=", fundiffmin,"fundiffmax=",fundiffmax
        WRITE (unit=32, fmt=*) "k2gdp=",k2gdp,"gdp=",gdp
        WRITE (unit=32, fmt=*) "taubal",taubal, "govbal=",govbal,"(previous)"
        WRITE (unit=32, fmt=*) "tota=",tota,"  totkcorp=",totkcorp,"  totk",totk
        WRITE (unit=32, fmt=*) "totayw=",totayw,"  totaye=",totaye
        WRITE (unit=32, fmt=*) "totaow=",totaow,"  totaoe=",totaoe  
        WRITE (unit=32, fmt=*) "tottaxl=",tottaxl,"tottaxe=",tottaxe
        WRITE (unit=32, fmt=*) "totaxa=",tottaxa
        WRITE (unit=32, fmt=*) "tottaxcw=",tottaxcw,"totaxce=",tottaxce
        WRITE (unit=32, fmt=*) "totaxbe=",tottaxbe,"totaxbw=",tottaxbw
        WRITE (unit=32, fmt=*) "totincw=",totincw,"(previous govbal)",govbal
        WRITE (unit=32, fmt=*) " "
        WRITE (unit=32, fmt=*) " "
        CLOSE (unit=32)

        WRITE(*,*) "taubal=",taubal,"   k2gdp=",k2gdp
        WRITE(*,*) "rbarmin=", rbarmin,"   rbarmax=",rbarmax
        WRITE(*,*) "rbar=",rbar,"   rimplied=",rimplied
        WRITE(*,*) "fundiffnow=",fundiffnow
        WRITE(*,*) "fundiffmin=", fundiffmin,"fundiffmax=",fundiffmax
        WRITE(*,*) "tota=",tota,"   totkcorp=",totkcorp
        WRITE(*,*) "totayw=",totayw,"  totaye=",totaye
        WRITE(*,*) "totaow=",totaow,"  totaoe=",totaoe
        WRITE(*,*) "iterar=",iterar,"  iteragov=",iteragov
        WRITE(*,*) "**********************"
        WRITE(*,*) " "

        !using bisection algorithm to update rbar
        !bisection algorithm
        IF (bracket==1) THEN
            fundiffmin=fundiffnow
            bracket=2
            IF (fundiffmin.GT.0.0) THEN
                WRITE (*,*) "***************************"
                WRITE (*,*) "rbarmin gives a positive fundiff=",fundiffnow
                WRITE (*,*) "trying another rbarmin"
                WRITE (*,*) "***************************"
                fname="cacca"
                OPEN (unit=32,file=fname,status="OLD", &
                    &   action="write",position="append",iostat=OpenStatus)
                WRITE (unit=32, fmt=*) "***************************"
                WRITE (unit=32, fmt=*) "rbarmin gives a positive fundiff=",fundiffnow
                WRITE (unit=32, fmt=*) "trying another rbarmin"
                WRITE (unit=32, fmt=*) "***************************"
                CLOSE (unit=32)             
                bracket=1
                noneedrbarmax=1
                fundiffmax=fundiffnow
                rbarmax=rbarmin
                rbarmin=rbarmin-.005
            END IF  
            IF ((fundiffmin.LE.0.0).AND.(noneedrbarmax==1)) THEN
                bracket=0
            END IF      
        ELSE IF (bracket==2) THEN
            fundiffmax=fundiffnow
            bracket=0
            IF (fundiffmax.LT.0.0) THEN
                WRITE (*,*) "***************************"
                WRITE (*,*) "rbarmax gives a negative fundiff=",fundiffnow
                WRITE (*,*) "trying another rbarmax"
                WRITE (*,*) "***************************"
                fname="cacca"
                OPEN (unit=32,file=fname,status="OLD", &
                    &   action="write",position="append",iostat=OpenStatus)
                WRITE (unit=32, fmt=*) "***************************"
                WRITE (unit=32, fmt=*) "rbarmax gives a positive fundiff=",fundiffnow
                WRITE (unit=32, fmt=*) "trying another rbarmax"
                WRITE (unit=32, fmt=*) "***************************"
                CLOSE (unit=32)
                bracket=2
                rbarmin=rbarmax
                rbarmax=rbarmax+.005
            END IF
        ELSE
            ! convergence criterion 
            epsir=min(ABS(fundiffnow),ABS(rbarmax-rbarmin))
            IF (fundiffnow.GT.0.0) THEN
                rbarmax=rbar
                fundiffmax=fundiffnow
            ELSE
                rbarmin=rbar
                fundiffmin=fundiffnow
            END IF
        END IF
        CALL printtotfun()
        iterar=iterar+1
        WRITE(*,*) "iterar on rbar",iterar
    END DO      !end do while for rbar

    !************************
    !   compute tax revenues
    vectaxcw=0.0
    vectaxce=0.0
    vectaxl=0.0
    vectaxe=0.0
    vectaxa=0.0
    vectaxbw=0.0
    vectaxbe=0.0
    !compute average income workers
    vectotincw=0.0
    vecwe2yw=0.0
    vecwe2ye=0.0
    whoise=0
    counter=1
    DO l=1,dr   ! young workers
        rhere=r(l)
        DO j=1,dy
            DO i=1,da
                ahere=a(apoly(i,j,l))                   
                IF (kpoly(i,j,l).GT.0) THEN
                    khere=k(kpoly(i,j,l))
                    entinchere=rhere*khere**ni-delt*khere-rbar*(khere-a(i))
                    vectaxe(counter)=(btaxe-btaxe*(staxe*entinchere**ptaxe+1) &
                    &   **(-1/ptaxe))*entinchere ! cricri +taubal*entinchere                          
                    vectaxce(counter)=tauc*(entinchere-vectaxe(counter) &
                    & +a(i)-tauls-ahere)/(1+tauc)
                    vecwe2ye(counter)=a(i)/entinchere
                    whoise(counter)=1
                ELSE                        
                    winchere=wage*y(j)+(1-indtaua)*rbar*a(i)
                    vectaxl(counter)=(btaxw-btaxw*(staxw*winchere**ptaxw+1)**(-1/ptaxw))&
                        &   *winchere+taubal*winchere
                    vectaxa(counter)=taua*rbar*a(i)
                    vectaxcw(counter)=tauc*((1+rbar)*a(i)+wage*y(j) &
                    &   -vectaxl(counter)-vectaxa(counter)-ahere-tauls)/(1+tauc)
                    vectotincw(counter)=wage*y(j)+rbar*a(i)
                    !note this must be changed if indtaua.ne.0
                    vecwe2yw(counter)=a(i)/winchere
                END IF
                counter=counter+1
            END DO
        END DO
    END DO
    DO l=1,dr   ! young entrepreneurs
        rhere=r(l)
        DO j=1,dy
            DO i=1,da
                ahere=a(apoly(i,j,l))           
                IF (kpoly(i,j,l).GT.0) THEN
                    khere=k(kpoly(i,j,l))
                    entinchere=rhere*khere**ni-delt*khere-rbar*(khere-a(i))
                    vectaxe(counter)=(btaxe-btaxe*(staxe*entinchere**ptaxe+1) &
                    &   **(-1/ptaxe))*entinchere ! cricri+taubal*entinchere                          
                    vectaxce(counter)=tauc*(entinchere-vectaxe(counter) &
                    & +a(i)-tauls-ahere)/(1+tauc)
                    vecwe2ye(counter)=a(i)/entinchere 
                    whoise(counter)=1
                ELSE
                    winchere=wage*y(j)+(1-indtaua)*rbar*a(i)
                    vectaxl(counter)=(btaxw-btaxw*(staxw*winchere**ptaxw+1)**(-1/ptaxw))&
                        &   *winchere+taubal*winchere
                    vectaxa(counter)=taua*rbar*a(i)
                    vectaxcw(counter)=tauc*((1+rbar)*a(i)+wage*y(j) &
                    &   -vectaxl(counter)-vectaxa(counter)-ahere-tauls)/(1+tauc)
                    vectotincw(counter)=wage*y(j)+rbar*a(i)
                    vecwe2yw(counter)=a(i)/winchere
                END IF
                counter=counter+1
            END DO
        END DO
    END DO
    DO l=1,dr   !   old entrepreneurs
        rhere=r(l)
        DO i=1,da
            ahere=a(apoloe(i,l))        
            IF (kpoloe(i,l).GT.0) THEN
                khere=k(kpoloe(i,l))
                entinchere=rhere*khere**ni-delt*khere-rbar*(khere-a(i))
                vectaxe(counter)=(btaxe-btaxe*(staxe*entinchere**ptaxe+1) &
                    &   **(-1/ptaxe))*entinchere ! cricri +taubal*entinchere                          
                vectaxce(counter)=tauc*(entinchere-vectaxe(counter) &
                    & +a(i)-tauls-ahere)/(1+tauc)
                vectaxbe(counter)=max(0.0,(ahere-exem))*taub
                vecwe2ye(counter)=a(i)/entinchere
                whoise(counter)=1
            ELSE
                winchere=transf+(1-indtaua)*rbar*a(i)
                vectaxl(counter)=(btaxw-btaxw*(staxw*winchere**ptaxw+1)**(-1/ptaxw))*winchere &
                    & +taubal*winchere
                vectaxa(counter)=taua*rbar*a(i)
                vectaxcw(counter)=tauc*(a(i)*(1+rbar)+transf-ahere-tauls-&
                & vectaxl(counter)-vectaxa(counter))/(1+tauc)
                vectaxbw(counter)=max(0.0,(ahere-exem))*taub
                vectotincw(counter)=transf+rbar*a(i)
                whoise(counter)=2
            END IF
            counter=counter+1
        END DO
    END DO
    DO i=1,da  !    old retirees
        ahere=a(apolow(i))
        winchere=transf+(1-indtaua)*rbar*a(i)
        vectaxl(counter)=(btaxw-btaxw*(staxw*winchere**ptaxw+1)**(-1/ptaxw))*winchere &
                & +taubal*winchere
        vectaxa(counter)=taua*rbar*a(i)
        vectaxcw(counter)=tauc*(a(i)*(1+rbar)+transf-ahere-tauls- &
        &   vectaxl(counter)-vectaxa(counter))/(1+tauc)
        vectaxbw(counter)=max(0.0,(ahere-exem))*taub
        vectotincw(counter)=transf+rbar*a(i)
        whoise(counter)=2               
        counter=counter+1
    END DO
    tottaxl=DOT_PRODUCT(invm,vectaxl)
    tottaxe=DOT_PRODUCT(invm,vectaxe)
    tottaxa=DOT_PRODUCT(invm,vectaxa)
    tottaxcw=DOT_PRODUCT(invm,vectaxcw)
    tottaxce=DOT_PRODUCT(invm,vectaxce)
    tottaxbw=DOT_PRODUCT(invm,vectaxbw)*(1-pold)
    tottaxbe=DOT_PRODUCT(invm,vectaxbe)*(1-pold)
    totincw=DOT_PRODUCT(invm,vectotincw)/(1-totentr)
    we2yw=DOT_PRODUCT(invm,vecwe2yw)/totL
    we2ye=DOT_PRODUCT(invm,vecwe2ye)/totentr
    nentr=count(whoise==1)
    ALLOCATE (vecwe2yeonly(nentr),invmeonly(nentr))
    vecwe2yeonly=PACK(vecwe2ye,mask=whoise==1)
    invmeonly=PACK(invm,mask=whoise==1)
    CALL quantilweighted(vecwe2yeonly,invmeonly/sum(invmeonly),0.5,we2yemedian)
    DEALLOCATE (vecwe2yeonly,invmeonly)
    nywork=count(whoise==0)
    ALLOCATE (vecwe2ywonly(nywork),invmywonly(nywork))
    vecwe2ywonly=pack(vecwe2yw,mask=whoise==0)
    invmywonly=pack(invm,mask=whoise==0)
    CALL quantilweighted(vecwe2ywonly,invmywonly/sum(invmywonly),0.5,we2ywmedian)
    DEALLOCATE (vecwe2ywonly,invmywonly)
    !call quantilweighted(vecwe2yw,invm/totL,0.5,we2ywmedian)
    !call quantilweighted(vecwe2ye,invm/totentr,0.5,we2yemedian)
    govbal=tottaxl+tottaxe+tottaxa+tottaxcw+tottaxce+tottaxbw+tottaxbe- &
        & gfrac*gdp-rbar*govdebt-transf*(totret-SUM(prgridoe))
    epsigov=ABS(govbal)
    IF ((iteragov==1).AND.(epsigov.GT.epsigovmin)) THEN
        taubal1=taubal
        govbal1=govbal
        IF ((govbal.LT.0.0)) THEN 
            taubal=taubal+pertgov
        ELSE
            taubal=taubal-pertgov
        END IF
        !start keeping track of closest govbals
        IF (govbal.LT.0.0) THEN
            govbalinf=govbal
            taubalinf=taubal
        ELSE
            govbalsup=govbal
            taubalsup=taubal
        END IF
    END IF
    IF ((iteragov.GT.1).AND.(epsigov.GT.epsigovmin)) THEN
        taubalold=taubal1
        govbalold=govbal1
        taubal1=taubal
        govbal1=govbal
            taubal=taubal-(1.0-relaxgov)*govbal*(taubalold-taubal)/(govbalold-govbal)
        !sometimes, you may shoot outside of the brackets, in which case it's best to
        !do bisection with the relevant bracket. keep track of taubals closest
        !IF (taubal.LT.taubalinf) THEN   
        !    taubal=taubal1-govbal1*(taubalinf-taubal1)/(govbalinf-govbal1)
        !ELSE IF (taubal.GT.taubalsup) THEN
        !    taubal=taubal1-govbal1*(taubalsup-taubal1)/(govbalsup-govbal1)
        !END IF
        IF ((govbal1.LT.0.0).AND.(govbal1.GT.govbalinf)) THEN
            govbalinf=govbal1
            taubalinf=taubal1
        END IF
        IF ((govbal1.GT.0.0).AND.(govbal1.LT.govbalsup)) THEN
            govbalsup=govbal1
            taubalsup=taubal1
        END IF  
    END IF
    iteragov=iteragov+1
    WRITE (*,*) "govbal", govbal, "iteragov", iteragov, "  taubal=",taubal
    WRITE (*,*) "totincw=",totincw
    fname="cacca"
    OPEN (unit=32,file=fname,status="OLD", &
    &       action="write",position="append",iostat=OpenStatus)
    WRITE (unit=32,fmt=*) "results for: iteragov", iteragov-1
    IF (epsigov.GT.epsigovmin) THEN
        WRITE (unit=32,fmt=*) "govbal", govbal, "  taubal=",taubal1
        WRITE (unit=32,fmt=*) "new taubal=",taubal
    ELSE
        WRITE (unit=32,fmt=*) "govbal", govbal, "  taubal=",taubal
        WRITE (unit=32,fmt=*) "reached convergence"
    END IF
    WRITE (unit=32,fmt=*) "tottaxl= ",tottaxl,"  tottaxe=",tottaxe,"tottaxa= ",tottaxa
    WRITE (unit=32,fmt=*) "tottacw= ",tottaxcw,"tottace= ",tottaxce
    WRITE (unit=32,fmt=*) "tottabw= ",tottaxbw,"tottabe= ",tottaxbe
    WRITE (unit=32,fmt=*) "tota=",tota," gdp=",gdp
    WRITE (unit=32,fmt=*) "totincw=",totincw
    WRITE (unit=32,fmt=*) "we2yw=",we2yw,"   we2ye=",we2ye
    WRITE (unit=32,fmt=*) "we2ywmedian=",we2ywmedian,"   we2yemedian=",we2yemedian
    CLOSE (unit=32)
    !update staxw
    staxw=staxwbase*totincw**(-ptaxw)
    staxe=staxebase*totincw**(-ptaxe)
END DO !end government budget loop

fname="cacca"
OPEN (unit=32,file=fname,status="OLD", &
    &       action="write",position="append",iostat=OpenStatus)
WRITE (unit=32, fmt=*) "***********************************"
WRITE (unit=32, fmt=*) "program stopped in iterar=",iterar-1,"  iteragov=",iteragov-1
WRITE (unit=32, fmt=*) "RIMPLIED",rimplied, "   rbar",rbar
WRITE (unit=32, fmt=*) "rbarmin",rbarmin, "   rbarmax",rbarmax
WRITE (unit=32, fmt=*) "wageimplied=",wageimplied 
WRITE (unit=32, fmt=*) "fundiffnow=",fundiffnow
WRITE (unit=32, fmt=*) "fundiffmin=", fundiffmin,"fundiffmax=",fundiffmax
WRITE (unit=32, fmt=*) "k2gdp=",k2gdp,"   gdp=",gdp
WRITE (unit=32, fmt=*) "taubal",taubal
WRITE (unit=32, fmt=*) "tota=",tota,"  totkcorp=",totkcorp,"  totk",totk
WRITE (unit=32, fmt=*) "totayw=",totayw,"  totaye=",totaye
WRITE (unit=32, fmt=*) "totaow=",totaow,"  totaoe=",totaoe
WRITE (unit=32, fmt=*) "govbal= ",govbal
WRITE (unit=32, fmt=*) "taxes:"
WRITE (unit=32, fmt=*) "lab=",tottaxl,"   cap inc=",tottaxa,"  entr=",tottaxe
WRITE (unit=32, fmt=*) "cw,ce,bw,be"
WRITE (unit=32, fmt=*)  tottaxcw,tottaxce,tottaxbw,tottaxbe
WRITE (unit=32, fmt=*) "totincw=",totincw
WRITE (unit=32, fmt=*) "we2yw=",we2yw,"   we2ye=",we2ye
WRITE (unit=32,fmt=*) "we2ywmedian=",we2ywmedian,"   we2yemedian=",we2yemedian
WRITE (unit=32, fmt=*) " "
CLOSE (unit=32)

CALL printwe2inc()
CALL printtotgov()

call quantilweighted(vecwe2yw,invm/totL,0.5,we2ywmedian)
call quantilweighted(vecwe2ye,invm/totentr,0.5,we2yemedian)
    
CONTAINS

SUBROUTINE printvalfun
fname="valfun"
! saving value functions
open (unit=32,file=fname,status="replace", &
&       action="WRITE",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
WRITE(unit=32,fmt=*) da
WRITE(unit=32,fmt=*) dy
WRITE(unit=32,fmt=*) dr
WRITE(unit=32,fmt=*) dk
DO i=1,da
    WRITE(unit=32,fmt=*) a(i)
END DO
DO i=1,dy 
    WRITE(unit=32,fmt=*) y(i)
END DO
DO i=1,dr
    WRITE(unit=32,fmt=*) r(i)
END DO
DO i=1,dk
    WRITE(unit=32,fmt=*) k(i)
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) Vy(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) Vyw(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) Vye(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) Vow(i)
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) Voe(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) Voee(i,jj)
    END DO
END DO
DO i=1,dk
    WRITE(unit=32,fmt=*) Vokeff(i)
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) apoly(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) kpoly(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) apolye(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) kpolye(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) apolyw(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) apolow(i)
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) apolownet(i)
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) apoloe(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) apoloenet(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) kpoloe(i,jj)
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) kyhat(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) kohat(i,jj)
    END DO
END DO

CLOSE (unit=32)
END SUBROUTINE printvalfun

SUBROUTINE printinvdistr
fname="invdistr"
! saving invariant distr
open (unit=32,file=fname,status="replace", &
&       action="WRITE",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
WRITE(unit=32,fmt=*) nstates
WRITE(unit=32,fmt=*) nyoung
WRITE(unit=32,fmt=*) noe
DO i=1,nstates
    WRITE(unit=32,fmt=*) invm(i)
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) prgrid(i)
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) prgridyw(i)
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) prgridye(i)
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) prgridoe(i)
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) prgridow(i)
END DO
WRITE(unit=32,fmt=*) tota
WRITE(unit=32,fmt=*) totk
WRITE(unit=32,fmt=*) inck
DO i=1,(nstates-da) 
    WRITE(unit=32,fmt=*) invlevk(i)
END DO  
DO i=1,(nstates-da) 
    WRITE(unit=32,fmt=*) invpolk(i)
END DO  
DO i=1,(nstates-da)
    WRITE(unit=32,fmt=*) invrk(i)
END DO
WRITE(unit=32,fmt=*) k2gdp
WRITE(unit=32,fmt=*) ykshare
WRITE(unit=32,fmt=*) rbar
DO i=1,dr
    WRITE(unit=32,fmt=*) invr(i)
END DO
WRITE(unit=32,fmt=*) totke
WRITE(unit=32,fmt=*) bet
WRITE(unit=32,fmt=*) gam
WRITE(unit=32,fmt=*) eff
WRITE(unit=32,fmt=*) eta
WRITE(unit=32,fmt=*) ni
WRITE(unit=32,fmt=*) propewswitch
WRITE(unit=32,fmt=*) propweswitch
WRITE(unit=32,fmt=*) alph
DO i=1,dy
    WRITE(unit=32,fmt=*) invy(i)
END DO
DO i=1,dr
    DO j=1,dr
        WRITE(unit=32,fmt=*) Pr(i,j)
    END DO
END DO
WRITE(unit=32,fmt=*) yktotsh
WRITE(unit=32,fmt=*) totentr 
WRITE(unit=32,fmt=*) totret
WRITE(unit=32,fmt=*) totL
WRITE(unit=32,fmt=*) wage
WRITE(unit=32,fmt=*) beq2gdp
WRITE(unit=32,fmt=*) totkborr
WRITE(unit=32,fmt=*) totyshe
WRITE(unit=32,fmt=*) toteffL
CLOSE (unit=32)
END SUBROUTINE printinvdistr

SUBROUTINE printtotfun()
fname="funtot"
! saving tots
open (unit=32,file=fname,status="replace", &
&       action="WRITE",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
DO i=1,iterar
    WRITE(unit=32,fmt=*) fundiff(i)
END DO
DO i=1,iterar
    WRITE(unit=32,fmt=*) funtota(i)
END DO
DO i=1,iterar
    WRITE(unit=32,fmt=*) funtotk(i)
END DO
DO i=1,iterar
    WRITE(unit=32,fmt=*) funrbar(i)
END DO
CLOSE(unit=32)
END SUBROUTINE printtotfun

SUBROUTINE printwe2inc()
fname="we2inc"
! saving tots
open (unit=32,file=fname,status="replace", &
&       action="WRITE",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
WRITE(unit=32,fmt=*) we2ye
WRITE(unit=32,fmt=*) we2yw
CLOSE(unit=32)
END SUBROUTINE printwe2inc

SUBROUTINE printtotgov()
fname="govtax"
! saving totals for government
open (unit=32,file=fname,status="replace", &
&       action="WRITE",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
WRITE(unit=32,fmt=*)    gdp
WRITE(unit=32,fmt=*)    govdebt
WRITE(unit=32,fmt=*)    transf
WRITE(unit=32,fmt=*)    gfrac
WRITE(unit=32,fmt=*)    tottaxl
WRITE(unit=32,fmt=*)    tottaxe
WRITE(unit=32,fmt=*)    tottaxa
WRITE(unit=32,fmt=*)    tottaxcw
WRITE(unit=32,fmt=*)    tottaxce
WRITE(unit=32,fmt=*)    tottaxbw
WRITE(unit=32,fmt=*)    tottaxbe    
WRITE(unit=32,fmt=*)    govbal
WRITE(unit=32,fmt=*)    taubal
CLOSE(unit=32)
END SUBROUTINE printtotgov


SUBROUTINE checksumrowM()
sumrowM=0.0
DO i=1,sizeM
    DO j=1,nonzero
    IF (rowM(j)==i) THEN
        sumrowM(i)=sumrowM(i)+valM(j)
    END IF
    END DO
    IF (ABS(sumrowM(i)-1).GE.1e-5) THEN
        WRITE (*,*) "sum of row",i," equals",sumrowM(i)
    END IF
END DO
END SUBROUTINE checksumrowM

SUBROUTINE checkcolM(posiz)
IMPLICIT NONE
INTEGER, INTENT(IN) :: posiz
CHARACTER(10) :: fname3

fname3='indcolM'
IF (colM(counter).GT.nstates) THEN
    open (unit=32,file=fname3,status="OLD", &
    &       action="READWRITE",position="APPEND",iostat=OpenStatus)
    IF (OpenStatus.NE.0) THEN
        WRITE(*,*) 'problems opening ', fname3
    END IF
    WRITE(unit=32,fmt=*) posiz,l,j,i,ll,jj,counter,apoly(i,j,l)
    CLOSE (unit=32)
END IF
END SUBROUTINE checkcolM


END PROGRAM entrtax
!******************************************

SUBROUTINE linspace(xmin,xmax,npoints,lspace)
IMPLICIT NONE
REAL, INTENT(IN) :: xmin,xmax
INTEGER, INTENT(IN) :: npoints
REAL, DIMENSION(npoints), INTENT(OUT) :: lspace
INTEGER :: i
lspace=real( (/ (i,i=0,npoints-1) /) )/real(npoints-1)*(xmax-xmin)+xmin
END SUBROUTINE linspace

SUBROUTINE  interplin(l,x,y,n,z,v)
! interpolate, from values of the fn given as ordinates of
! input data points in an x-y plane and for a given set of
! x values (abscissas), the values of a single-valued fn y=f(x)
! input parameters are
!     l  = # of data points (2 or greater)
!     x  = array of dimension l storing the x values (abscissas)
!          of input data points (in ascending order)
!     y  = array of dimension l storing the y values (ordinates)
!          of input data points
!     n  = # of points at which interpolation of the y value (ordinate)
!          (ordinate) is needed (1 or greater)
!     z  = array of dimension n storing the x values (abscissas) of
!          desired points
! output parameter
!     v  = array of dimension n where the interpolated y values
!          (ordinates) are to be displayed
IMPLICIT NONE

INTEGER, INTENT(IN) :: l
INTEGER, INTENT(IN) :: n
REAL, DIMENSION(l), INTENT(IN) :: x
REAL, DIMENSION(l), INTENT(IN) :: y
REAL, DIMENSION(n), INTENT(IN) :: z
REAL, DIMENSION(n), INTENT(OUT) :: v

INTEGER :: i,ind
INTEGER, DIMENSION(1) :: k
REAL :: diff

DO i=1,n
    k=MAXLOC(-ABS(z(i)-x))
    ind=k(1)
    diff=z(i)-x(ind)
    IF (abs(diff)<1e-04) THEN
        v(i)=y(ind)
    ELSE
        IF (diff<0) THEN
            v(i)=y(ind-1)+(z(i)-x(ind-1))/(x(ind)-x(ind-1))&
                     & *(y(ind)-y(ind-1))
        ELSE
            v(i)=y(ind)+(z(i)-x(ind))/(x(ind+1)-x(ind))*(y(ind+1)-y(ind))
        END IF
    END IF
END DO ! DO i=1,n
END SUBROUTINE interplin

SUBROUTINE checkrow1 (A,dA)
IMPLICIT NONE
REAL, DIMENSION(:,:), INTENT(IN) :: A
INTEGER, INTENT(IN) :: dA
INTEGER :: i
DO i=1,dA
        IF ( ABS(sum(A(i,:))-1).GT.1e-6 ) THEN
                WRITE (*,*) "row",i," of matrix doesn't sum to 1"
        END IF
END DO
END SUBROUTINE checkrow1

SUBROUTINE quantilweighted (series,weights,qprop,quant)

USE numerical_libraries
IMPLICIT NONE
REAL, DIMENSION(:), INTENT(IN) :: series,weights
REAL, INTENT(IN) :: qprop
REAL, INTENT(OUT) :: quant
REAL, ALLOCATABLE, DIMENSION(:)  :: seriesord,weightord,csum
INTEGER, ALLOCATABLE, DIMENSION(:) :: iperm
INTEGER :: lvec,i,j,cuth
INTEGER, DIMENSION(1) :: cuthp
REAL :: wt

! first, we need to order series, in ascending order
!  seriesord and the corresponding weightord
! then we construct the cumulative sum of weights csum
lvec=size(series)
allocate(seriesord(lvec),iperm(lvec),csum(lvec),weightord(lvec))
iperm= (/ (j, j=1,lvec) /)
!the following reorders the series and outputs iperm, the vector of indices shifted
CALL svrgp (lvec,series,seriesord,iperm)

!way in which csum is computed:
! suppose you have  s1  s2      s3      s4
! with weights      w1  w2      w3      w4
! the csum is:      c1  c2      c3      c4
! equal to      w1/2    c1+w1/2+w2/2    c2+w2/2+w3/2    c3+w3/2+w4/2
!
! ie for each point s, csum is equal to the pr<s plus 1/2 of the pr of being in
! that point. I don't remember exactly why i did it that way, with the interpolation
! suppose you have s1 s2 s3 with 1/3 1/3 1/3
! then csum is 1/6 1/2 5/6, so median q=.5 would give you s2 (as it should)
! if you have q=.75, it will give you a point between s2 s3, closer to s3.

!the following was wrong!
!weightord(1)=weights(iperm(1))/2
!the following was wrong!
!csum(1)=weightord(1)
DO i=1,lvec
    weightord(i)=weights(iperm(i))
    ! this should not be here either! 
    ! csum(i)=weightord(i)+csum(i-1)
END DO
csum(1)=weightord(1)/2
DO i=2,lvec
    csum(i)=csum(i-1)+weightord(i)/2+weightord(i-1)/2
END DO
!here we find where the required quantile falls
!this command picks the min of csum for those elements of csum that are greater than qprop
cuthp=minloc(csum,csum.GT.qprop)
cuth=cuthp(1)
if (cuth==1) then   ! if the required quantile is below the first, then set it to the first
    quant=series(1)
else if (qprop.GE.csum(lvec)) then  !above the last
    quant=seriesord(lvec)
else            ! interpolate between the closest gridpoints
    quant=seriesord(cuth-1)+(qprop-csum(cuth-1))/ &
    &   (csum(cuth)-csum(cuth-1))*(seriesord(cuth)-seriesord(cuth-1))
end if
END SUBROUTINE quantilweighted
