% Computes and plots welfare compensations

incdoll=0.045;

% construct consumption compensation to equate value function 2 to value function
% the latter being the benchmark.
% computation: Valfun=(1+x)^(1-gam)*Valfun2 hence
% x=(Valfun/Valfun2)^(1/(1-gam))-1

load -ascii valfunT2;
datavec=valfunT2; 
clear valfunT2;

% define data from fortran ascii file
Vy=zeros(da,dy,dr);
for i=1:da,
	for j=1:dy,
		for jj=1:dr,
			Vy(i,j,jj)=datavec(jj+(j-1)*dr+(i-1)*dr*dy);           
		end; % i
	end; % j0
end;% k
datavec=datavec(da*dr*dy+1:length(datavec));
Vyw=zeros(da,dy,dr);
for i=1:da,
	for j=1:dy,
		for jj=1:dr,
         Vyw(i,j,jj)=datavec(jj+(j-1)*dr+(i-1)*dr*dy);
      end; % i
   end; % j0
end;% k
datavec=datavec(da*dr*dy+1:length(datavec));
Vye=zeros(da,dy,dr);
for i=1:da,
	for j=1:dy,
		for jj=1:dr,
         Vye(i,j,jj)=datavec(jj+(j-1)*dr+(i-1)*dr*dy);
      end; % i
   end; % j0
end;% k
datavec=datavec(da*dr*dy+1:length(datavec));
Vow=datavec(1:da);
datavec=datavec(da+1:length(datavec));
Voe=zeros(da,dr);
for i=1:da,
	for jj=1:dr,
   	Voe(i,jj)=datavec(jj+(i-1)*dr);
   end; % i
end;% k
datavec=datavec(da*dr+1:length(datavec));
Voee=zeros(da,dr);
for i=1:da,
	for jj=1:dr,
   	Voee(i,jj)=datavec(jj+(i-1)*dr);
   end; % i
end;% k

% clean up work space
Vy2=Vy;
Vow2=Vow;
Voe2=Voe;
invm2=invm;
save stuff2 Vy2 Vow2 Voe2 invm2;
clear;
load stuff2;
incdoll=0.045; % check also later

load -ascii valfun;
datavec=valfun; 
clear valfun;

% define data from fortran ascii file
da=datavec(1);
dy=datavec(2);
dr=datavec(3);
dk=datavec(4);
datavec=datavec(5:length(datavec));
a=datavec(1:da);
y=datavec(da+1:da+dy);
r=datavec(da+dy+1:da+dy+dr);
k=datavec(da+dy+dr+1:da+dy+dr+dk);
datavec=datavec(da+dy+dr+dk+1:length(datavec));
Vy=zeros(da,dy,dr);
for i=1:da,
	for j=1:dy,
		for jj=1:dr,
			Vy(i,j,jj)=datavec(jj+(j-1)*dr+(i-1)*dr*dy);
		end; % i
	end; % j0
end;% k
datavec=datavec(da*dr*dy+1:length(datavec));
Vyw=zeros(da,dy,dr);
for i=1:da,
	for j=1:dy,
		for jj=1:dr,
         Vyw(i,j,jj)=datavec(jj+(j-1)*dr+(i-1)*dr*dy);
      end; % i
   end; % j0
end;% k
datavec=datavec(da*dr*dy+1:length(datavec));
Vye=zeros(da,dy,dr);
for i=1:da,
	for j=1:dy,
		for jj=1:dr,
         Vye(i,j,jj)=datavec(jj+(j-1)*dr+(i-1)*dr*dy);
      end; % i
   end; % j0
end;% k
datavec=datavec(da*dr*dy+1:length(datavec));
Vow=datavec(1:da);
datavec=datavec(da+1:length(datavec));
Voe=zeros(da,dr);
for i=1:da,
	for jj=1:dr,
   	Voe(i,jj)=datavec(jj+(i-1)*dr);
   end; % i
end;% k
datavec=datavec(da*dr+1:length(datavec));
Voee=zeros(da,dr);
for i=1:da,
	for jj=1:dr,
   	Voee(i,jj)=datavec(jj+(i-1)*dr);
   end; % i
end;% k
datavec=datavec(da*dr+1:length(datavec));
Vokeff=datavec(1:dk);
datavec=datavec(dk+1:length(datavec));
counter=1;
apoly=zeros(da,dy,dr);
for i=1:da
	for j=1:dy
		for jj=1:dr
         apoly(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
kpoly=zeros(da,dy,dr)-1;
for i=1:da
	for j=1:dy
		for jj=1:dr
         kpoly(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
apolye=zeros(da,dy,dr);
for i=1:da
	for j=1:dy
		for jj=1:dr
         apolye(i,j,jj)=datavec(counter);
   	     counter=counter+1;
	   end;
	end;
end;
kpolye=zeros(da,dy,dr)-1;
for i=1:da
	for j=1:dy
		for jj=1:dr
         kpolye(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
apolyw=zeros(da,dy,dr);
for i=1:da
	for j=1:dy
		for jj=1:dr
         apolyw(i,j,jj)=datavec(counter);
   	     counter=counter+1;
	   end;
	end;
end;
apolow=zeros(da,1);
for i=1:da
   apolow(i)=datavec(counter);
   counter=counter+1;
end;
apolownet=zeros(da,1);
for i=1:da
   apolownet(i)=datavec(counter);
   counter=counter+1;
end;
apoloe=zeros(da,dr);
for i=1:da
	for jj=1:dr
      apoloe(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;
apoloenet=zeros(da,dr);
for i=1:da
	for jj=1:dr
      apoloenet(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;
kpoloe=zeros(da,dr)-1;
for i=1:da
	for jj=1:dr
      kpoloe(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;
kyhat=zeros(da,dy,dr)-1;
for i=1:da
	for j=1:dy
		for jj=1:dr
         kyhat(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
kohat=zeros(da,dr)-1;
for i=1:da
	for jj=1:dr
      kohat(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;

load -ascii invdistr;
datavec=invdistr; 
clear invdistr;

nstates=datavec(1);
nyoung=datavec(2);
noe=datavec(3);
invm=datavec(4:nstates+3);
datavec=datavec(nstates+4:length(datavec));
prgrid=datavec(1:da);
datavec=datavec(da+1:length(datavec));
prgridyw=datavec(1:da);
prgridye=datavec(da+1:2*da);
prgridoe=datavec(2*da+1:3*da);
prgridow=datavec(3*da+1:4*da);
datavec=datavec(4*da+1:length(datavec));
tota=datavec(1);
totk=datavec(2);
inck=datavec(3);
invlevk=datavec(4:nstates-da+3);
datavec=datavec(nstates-da+4:length(datavec));
invpolk=datavec(1:nstates-da);
invrk=datavec(nstates-da+1:2*(nstates-da));
datavec=datavec(2*(nstates-da)+1:length(datavec));
k2gdp=datavec(1);
ykshare=datavec(2);
rbar=datavec(3);
invr=datavec(4:4+dr-1);
datavec=datavec(4+dr:length(datavec));
totke=datavec(1);
bet=datavec(2);
gam=datavec(3);
eff=datavec(4);
eta=datavec(5);
ni=datavec(6);
propewswitch=datavec(7);
propweswitch=datavec(8);
%alph=datavec(9);
alph=datavec(9);
invy=datavec(10:10+dy-1);
datavec=datavec(10+dy:length(datavec));
for i=1:dr,
	for j=1:dr,
		Pr(i,j)=datavec((i-1)*dr+j);
	end;
end;
datavec=datavec(dr*dr+1:length(datavec));
yktotsh=datavec(1);
totentr=datavec(2);
totret=datavec(3);
totL=datavec(4);
grossw=datavec(5);
beq2gdp=datavec(6);
totkborr=datavec(7);
totyshe=datavec(8);
toteffL=datavec(9);

% construct consumption compensation vectors
conscompVy=zeros(da,dy,dr);
conscompVoe=zeros(da,dr);
conscompVow=zeros(da,1);

% young
for j=1:da,
    for jj=1:dy,
        for jjj=1:dr,
            % switched indexes in Vy cricri
            conscompVy(j,jj,jjj)=(Vy2(j,jj,jjj)/Vy(j,jj,jjj))^(1/(1-gam))-1;
        end;
    end;
end;

% old entr
for j=1:da
    for jjj=1:dr
        % switched indexes in Voe cricri
        conscompVoe(j,jjj)=(Voe2(j,jjj)/Voe(j,jjj))^(1/(1-gam))-1;
    end;
end;

% old worker
for j=1:da
    % switched indexes in Voe cricri
     conscompVow(j)=(Vow2(j)/Vow(j))^(1/(1-gam))-1;
end;

%plotting with change in scale (power function)

% define x label axis
labelswewant=[0;0.01;0.1;0.5;1;10;20;25]; %in millions of dollars
nlabels=size(labelswewant,1);
tick_position=zeros(nlabels,1);
pickrows=zeros(nlabels,1);
for i=1:nlabels,
        fid=find(a*incdoll<=labelswewant(i,1));
        pickrows(i,1)=max(fid);
end,
tick_value=labelswewant;

%if we use the same scale throughout, we can define these at the beginning
adjust=1/4;

xaxismax=25; %in millions of dollars
xaxismaxplot=20;
fid=max(find(a*incdoll<xaxismax));

a_scaled=(incdoll*a(1:fid)).^adjust; %axis transformation
xaxismax_scaled=xaxismax^adjust; %we need to apply the same trasformation as a_scaled
xaxismaxplot_scaled=xaxismaxplot^adjust; %we need to apply the same trasformation as a_scaled

tick_position=a_scaled(pickrows);

% make pretty plots
conscompVoeshort=zeros(fid,dr);
conscompVyshort=zeros(fid,dy,dr);
conscompVoeshort(:,:)=conscompVoe(1:fid,:);
conscompVyshort(:,:,:)=conscompVy(1:fid,:,:);
conscompVoesmooth=zeros(fid,dr);
conscompVysmooth=zeros(fid,dy,dr);
conscompVoesmooth(:,1)=conscompVoeshort(:,1);
conscompVysmooth(:,:,1)=conscompVyshort(:,:,1);

nold=5; % degree of fitted polynomial for old
oldcoeff=zeros(nold+1,1); % polynomial coefficients for old
% only smooth out those with high ability
oldcoeff = polyfit(a_scaled,conscompVoeshort(:,dr),nold)';
conscompVoesmooth(:,dr)=polyval(oldcoeff,a_scaled);

figure(1);
plot(a_scaled,conscompVoe(1:fid,dr),'-',a_scaled,conscompVoesmooth(:,dr),'-.')
axis([0 xaxismaxplot_scaled -0.02 0.08]) ;
grid;

figure(2);
clf reset
plot(a_scaled,conscompVoesmooth(:,1),'--',a_scaled,conscompVoesmooth(:,2),'-.')
axis([0 xaxismaxplot_scaled -0.02 0.072]) ;
set(gca,'XTick',tick_position,'XTickLabel', tick_value);
ax1 = gca;
set(ax1,'XColor','k','YColor','k')
grid
ylabel('Welfare gain for the old');
legend('Low \theta','High \theta','Location','South');
%hold on
ax2 = axes('Position',get(ax1,'Position'),'YAxisLocation','right', ...
           'Color','none','XColor','k','YColor','k');
line(a_scaled,cumsum(prgridoe(1:fid)+prgridow(1:fid))./sum(prgridoe(1:fid)+prgridow(1:fid)),'LineStyle','-');
axis([0 xaxismaxplot_scaled 0.0 1]);
set(gca,'XTick',tick_position,'XTickLabel', tick_value, ...
'YAxisLocation','right' );
xlabel('Wealth (millions)');
ylabel('Cumulative distribution');
legend('c.d.f.','Location','North');
print -deps constranstauco.eps

% YOUNG
nyoung=8; % degree of fitted polynomial for old
youngcoeff=zeros(nyoung+1,dy); % polynomial coefficients for old
% only smooth out those with high ability
for j=1:dy,
    youngcoeff(:,j) = polyfit(a_scaled,conscompVyshort(:,j,dr),nyoung)';
    conscompVysmooth(:,j,dr)=polyval(youngcoeff(:,j),a_scaled);
end,

    
figure(3);
plot(a_scaled,conscompVy(1:fid,3,dr),'-',a_scaled,conscompVysmooth(:,3,dr),'-.',a_scaled,conscompVysmooth(:,3,1),'-.')
axis([0 xaxismaxplot_scaled -0.02 0.08]) ;
grid;

figure(4);
clf reset
plot(a_scaled,conscompVysmooth(:,3,1),'--',a_scaled,conscompVysmooth(:,3,2),'-.')
axis([0 xaxismax_scaled -0.02 0.01]);
set(gca,'XTick',tick_position,'XTickLabel', tick_value);
ax1 = gca;
set(ax1,'XColor','k','YColor','k')
grid
ylabel('Welfare gain for the young');
legend('Low \theta','High \theta','Location','South');
%hold on
ax2 = axes('Position',get(ax1,'Position'),'YAxisLocation','right', ...
           'Color','none','XColor','k','YColor','k');
line(a_scaled,cumsum(prgridye(1:fid)+prgridyw(1:fid))./sum(prgridye(1:fid)+prgridyw(1:fid)),'LineStyle','-');
axis([0 xaxismax_scaled 0.0 1]);
set(gca,'XTick',tick_position,'XTickLabel', tick_value, ...
'YAxisLocation','right' );
xlabel('Wealth (millions)');
ylabel('Cumulative distribution of young');
legend('c.d.f.','Location','North');
print -deps constranstaucy.eps


figure(5);
plot(a*incdoll,conscompVy(:,3,1),'-',a*incdoll,conscompVy(:,3,2),'-.')
axis([0 60 -0.02 0.07]) ;
grid;
set(gca,'FontSize',16,'FontName','Times New Roman');
xlabel('Wealth, in millions of dollars');
ylabel('Welfare gain for the young');
legend('Low \theta','High \theta',0);


figure(6)
plot(a*incdoll,conscompVoe(:,1),'-',a*incdoll,conscompVoe(:,2),'-.')
axis([0 60 -0.02 0.07]) ;
grid;
set(gca,'FontSize',16,'FontName','Times New Roman');
xlabel('Wealth, in millions of dollars');
ylabel('Welfare gain for the old');
legend('Low \theta','High \theta',0);


break;
assets=a*incdoll;
nold=5; % degree of fitted polynomial for old
oldcoeff=zeros(nold+1,1); % polynomial coefficients for old
conscompVoesmooth=zeros(1:da,dr);
% only smooth out those with high ability
conscompVoesmooth(:,1)=conscompVoe(:,1);
oldcoeff = polyfit(assets,conscompVoe(:,dr),nold)';
conscompVoesmooth(:,dr)=polyval(oldcoeff,assets);

%figure(3);
plot(assets,conscompVoe(:,dr),'-',assets,conscompVoesmooth(:,dr),'-.')
axis([0 20 -0.02 0.06]) ;
grid;


% make prettier plots
maxasmooth=20;
fid=max(find(a*incdoll<maxasmooth));
assets=a(1:fid)*incdoll;
conscompVoeshort=zeros(fid,dr);
conscompVyshort=zeros(fid,dy,dr);
conscompVoeshort(:,:)=conscompVoe(1:fid,:);
conscompVyshort(:,:,:)=conscompVy(1:fid,:,:);

nold=5; % degree of fitted polynomial for old
oldcoeff=zeros(nold+1,1); % polynomial coefficients for old
conscompVoesmooth=zeros(fid,dr);
% only smooth out those with high ability
conscompVoesmooth(:,1)=conscompVoeshort(:,1);
oldcoeff = polyfit(assets,conscompVoeshort(:,dr),nold)';
conscompVoesmooth(:,dr)=polyval(oldcoeff,assets);

%figure(3);
plot(assets,conscompVoe(1:fid,dr),'-',assets,conscompVoesmooth(:,dr),'-.')
axis([0 20 -0.02 0.06]) ;
grid;

figure(5)
plot(assets,conscompVoe(1:fid,1),'-',assets,conscompVoesmooth(:,dr),'-.')
axis([0 10 -0.02 0.06]) ;
grid;
set(gca,'FontSize',16,'FontName','Times New Roman');
xlabel('Wealth, in millions of dollars');
ylabel('Welfare gain for the old');
legend('Low \theta','High \theta',0);
print -deps cutgtransos.eps;

nyoung=6; % degree of fitted polynomial for young
youngcoeff=zeros(nyoung+1,dy); % polynomial coefficients for young
conscompVysmooth=zeros(fid,dy,dr);
% only smooth out those with high ability
conscompVysmooth(:,:,1)=conscompVyshort(:,:,1);
for jj=1:dy,
    youngcoeff(:,jj) = polyfit(assets,conscompVyshort(:,jj,dr),nyoung)';
    conscompVymooth(:,jj,dr)=polyval(youngcoeff(:,jj),assets);
end,
%figure(5)
%plot(assets,conscompVy(1:fid,3,dr),'-',assets,conscompVysmooth(:,3,dr),'-.')
%axis([0 20 -0.02 0.06]) ;
%grid;

%plotting welf changes for percentiles
percwall=cumsum(prgrid)*100;

figure(6);
plot(percwall,conscompVy(:,3,1),'-',percwall,conscompVy(:,3,2),'-.')
axis([0 100 -0.02 0.08]) ;
grid;
set(gca,'FontSize',16,'FontName','Times New Roman');
xlabel('Wealth percentile');
ylabel('Welfare gain for the young');
legend('Low \theta','High \theta',0);
%print -deps cutgtransyP.eps;

figure(7)
plot(percwall,conscompVoe(:,1),'-',percwall,conscompVoe(:,2),'-.')
axis([0 100 -0.02 0.08]) ;
grid;
set(gca,'FontSize',16,'FontName','Times New Roman');
xlabel('Wealth percentile');
ylabel('Welfare gain for the old');
legend('Low \theta','High \theta',0);
%print -deps cutgtransoP.eps;

% compute an aggregate measure.
% Easiest, we simply average of consumption compensations
% weighting everybody the same (ie by invm)                                                            
% order of the transition matrix/invm
% y workers-        r - y - assets
% y entrepreneurs-  r - y - assets
% old entr          r -     assets
% old                       assets
% size of cons comp vectors
% conscompVy=zeros(da,dy,dr);
% conscompVoe=zeros(da,dr);
% conscompVow=zeros(da,1);
avgCcomp=0;
counter=1;
%we first sum young (workers and entrepreneurs)
for i=1:dr,
    for j=1:dy,
        for jj=1:da,
            avgCcomp=avgCcomp+conscompVy(jj,j,i)*(invm(counter)+invm(nyoung+counter));
            counter=counter+1;
        end;
     end;
end;
%old entrepreneurs
counter=2*nyoung+1;
for i=1:dr,
    for j=1:da,
        avgCcomp=avgCcomp+conscompVoe(j,i)*invm(counter);
        counter=counter+1;
    end;
end;
%old workers
for i=1:da,
    avgCcomp=avgCcomp+conscompVow(i)*invm(counter);
    counter=counter+1;
end;

