function [invmall,invmpropall,invm2eall,invmprop2eall,invm2wall,invmprop2wall]=stackinvec(invm,matpoly,matpoloe,matpolow,kpoly,kpoloe,da,dy,dr)
% creates vector of variable levels (invmall*) and proportions of people
% (invmprop*). invmall and invmpropall are for all people, *2eall are for
% the entrepreneurs during the current period only
% also compute distrbution and dependent variable dropping the top 5% (of
% consumption, income, etc)
% we have  policy fn, stack it in the same order
% as invm. 

nyoung=da*dr*dy;
noe=da*dr;
invmy=zeros(nyoung,1);
invmoe=zeros(da*dr,1);
invmow=zeros(da,1);
% the following indicates those who decide to be e or w in the period
invmpropy2e=zeros(nyoung,1);
invmpropy2w=zeros(nyoung,1);
invmpropo2e=zeros(noe,1);
invmpropo2w=zeros(da,1);
% the following indicates those who decide to be e or w in the period
counter=1;
% do young people
for jj=1:dr
    for j=1:dy
        for i=1:da
            invmy(counter)=matpoly(i,j,jj); % record consumption given state variables in invm for young
            % count those that decide to be entrepreneurs in the period,
            % and those who decide to be workers, conditional on beginning
            % of period state variables.
            % use that your occupational choice does not depend
            % on whether you were w or e last period, so we add up.
            if ((kpoly(i,j,jj)>0))
                invmpropy2e(counter)=invm(counter)+invm(nyoung+counter);
            else
                invmpropy2w(counter)=invm(counter)+invm(nyoung+counter);
            end
            counter=counter+1;
        end;
    end;
end;
if (counter-1 ~= nyoung)
    disp('error in creating invmstacked, size=',counter-1,'   nyoung=',nyoung)
end;
invmpropyoung=invm(1:nyoung)+invm(nyoung+1:2*nyoung); % here we again use the irrelevance of previous occ. choice
counter=1;
for jj=1:dr
    for i=1:da
        invmoe(counter)=matpoloe(i,jj);
        % here we condition on current occupational choice to compute conditional consumption distributions
        if ((kpoloe(i,jj)>0))
            invmpropo2e(counter)=invm(2*nyoung+counter);
        else
            invmpropo2w(i)=invm(2*nyoung+counter)+invmpropo2w(i);
        end        
        counter=counter+1;
    end;
end;
invmpropo2w=invmpropo2w+invm(2*nyoung+noe+1:2*nyoung+noe+da);
invmpropoe=invm((2*nyoung+1):(2*nyoung+noe));
counter=1;
for i=1:da
	invmow(counter)=matpolow(i);
	counter=counter+1;
end;
invmpropow=invm(2*nyoung+noe+1:2*nyoung+noe+da);
invmall=[invmy;invmoe;invmow];
invmpropall=[invmpropyoung;invmpropoe;invmpropow];

% conditional for those who become e. 
% take off zero mass (=become worker)
invm2temp=[invmpropy2e;invmpropo2e];
fid=find(invm2temp>0);
invmprop2eall=invm2temp(fid);
clear invm2temp;
invm2temp=[invmy;invmoe];
invm2eall=invm2temp(fid);

% conditional for those who become w. 
% take off zero mass (=become entr)
invm2temp=[invmpropy2w;invmpropo2w];
fid=find(invm2temp>0);
invmprop2wall=invm2temp(fid);
clear invm2temp;
invm2temp=[invmy;invmoe];
invm2wall=invm2temp(fid);


