
% graphs for tax paper OCT06

clear;

nfig=1;
% graphs
% define relevant yearly income to transform into 1000 dollars
incdoll=45;
percsup=.085
%%%%%%%%%%%%%%%%%%%%%% load DATA SCF89
%order of variables in file scf89_1.txt
%X1	X3128	X3228	X3328	XX1	BUS	NETWORTH 	yrint	wt	hasbus	actbus	age	selfe	selfep	
%bus1	bus2	bus3	busotr	gh	totvalb2	totvalb3	totvalb	typeb1	howacq1	yreduc
load scf89dat_1.txt;
i=1;
X1=scf89dat_1(:,i); i=i+1;
X3128	=scf89dat_1(:,i); i=i+1;
X3228	=scf89dat_1(:,i); i=i+1;
X3328	=scf89dat_1(:,i); i=i+1;
XX1	=scf89dat_1(:,i); i=i+1;
bus	=scf89dat_1(:,i); i=i+1;
networth=scf89dat_1(:,i); i=i+1;
yrint	=scf89dat_1(:,i); i=i+1;
wt	=scf89dat_1(:,i); i=i+1;
hasbus=scf89dat_1(:,i); i=i+1;	
actbus=scf89dat_1(:,i); i=i+1;	
age	=scf89dat_1(:,i); i=i+1;
selfe	=scf89dat_1(:,i); i=i+1;
selfep=scf89dat_1(:,i); i=i+1;	
bus1	=scf89dat_1(:,i); i=i+1;
bus2	=scf89dat_1(:,i); i=i+1;
bus3	=scf89dat_1(:,i); i=i+1;
busotr=scf89dat_1(:,i); i=i+1;	
gh	=scf89dat_1(:,i); i=i+1;
totvalb2=scf89dat_1(:,i); i=i+1;	
totvalb3=scf89dat_1(:,i); i=i+1;	
totvalb=scf89dat_1(:,i); i=i+1;	
typeb1=scf89dat_1(:,i); i=i+1;	
howacq1=scf89dat_1(:,i); i=i+1;	
yreduc=scf89dat_1(:,i); i=i+1;

networth=networth/1000;
weight=wt/sum(wt);

netsup=5000;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%% baseline wealth and data
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%load benchmark OCT02
load dat.mat;

figure(nfig); nfig=nfig+1;
incdoll=45;
networthbench=a*incdoll;
%create a sort of histogram
[netdat,wdat]=distwhist(networth,weight,100,20000);
%it may be useful to rearrange the simulations as well
[netbench,wbench]=distwhist(networthbench,prgrid,100,20000);
%percsup=max(wbench(2:size(wbench,1)))+.005;
plot(netbench,wbench,'-',netdat,wdat,'-.');
axis([0 netsup 0 percsup]);
set(gca,'FontSize',26,'FontName','Times New Roman');
xlabel('Positive wealth, in thousands of dollars');
ylabel('Fraction of people');
print -deps benchdistDEC06.eps


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%% plot wealth distribution entrepreneurs, baseline and data
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%entrepreneurs GH
figure(nfig); nfig=nfig+1;
perce=sum(prgridye+prgridoe);
fid=find(actbus==1 & bus>0);
weightGH=weight(fid);
percGH=sum(weightGH);
networthGH=networth(fid);
[netdatGH,wdatGH]=distwhist(networthGH,weightGH/percGH,100,20000);
%it may be useful to rearrange the simulations as well
[netbenchGH,wbenchGH]=distwhist(networthbench,(prgridye+prgridoe)/perce,100,20000);
%percsup=max(wdatGH(2:size(wdatGH,1)))+.005;
plot(netbenchGH,wbenchGH,'-',netdatGH,wdatGH,'-.');
axis([0 netsup 0 percsup]);
set(gca,'FontSize',26,'FontName','Times New Roman');
xlabel('Positive wealth, in thousands of dollars');
ylabel('Fraction of people');
print -deps benchdisteDEC06.eps;


