PROGRAM entrtrans

! dorloop=0: no iteration on prices, otherwise: endogenous prices

! THIS RUN changes G to make up for tax shortfalls. keeps debtfrac constant
! ratio of debt to totk+totkcorp
!
! load INITIAL SS DATA:
! loading final SS: valfun, invdistr, govtax

! check DIMENSIONS and other hard-wired inputs!

USE numerical_libraries

IMPLICIT NONE

! *****************  PARAMETER VALUES
REAL, PARAMETER :: tauc1ss=0.11, tauc2ss=0.11
REAL, PARAMETER :: taubal1ss=0.036079269, taubal2ss=0.036079269	

! grids
INTEGER, PARAMETER :: da1=40,da2=220    ! # asset levels for each grid
INTEGER, PARAMETER :: da=da1+da2         ! # asset levels 
INTEGER, PARAMETER :: dk1=da1,dk2=da2   ! # asset levels for each grid
INTEGER, PARAMETER :: dk=dk1+dk2         ! # asset levels 
INTEGER, PARAMETER :: dr=2     ! # entrep. ability realiz. 
INTEGER, PARAMETER :: dy=5     ! # income realizations

! prices convergence speed
REAL, PARAMETER :: weightoldprices=0.95

! corporate prof fn
REAL, PARAMETER :: abig=1 ! constant in front

! transition matrix nonzero elements
INTEGER, PARAMETER :: nyoung=dr*dy*da   ! # possible states for young w or entr
INTEGER, PARAMETER :: noe=da*dr         ! # possible states for old entr
INTEGER, PARAMETER :: nstates=2*nyoung+noe+da   ! # states (total)
INTEGER, PARAMETER :: nonzero=2*(dy*dr+dr+1)*nyoung+(dy*dr+dr+1)*noe+&
                        &       (dy*dr+1)*da
INTEGER, PARAMETER :: sizeM=2*nyoung+noe+da     !dimension of trans mat M

! transition parameters
INTEGER, PARAMETER :: T1=5,T2=5,T3=138, T4=2 ! T1 and T2: tau is changing until T1+T2-1
INTEGER, PARAMETER :: Ttrans=T1+T2+T3+T4, Ttransold=T1+T2+T3

! switches
INTEGER, PARAMETER :: switchbc=2        ! =0 EXO, 1=ENDO for OLD only, 2=Young and Old
INTEGER, PARAMETER :: usetax2balance=1  ! =0 use taubal, =1 (or other value) use tauc
INTEGER, PARAMETER :: dorloop=1         ! 0=don't do r loop
INTEGER, PARAMETER :: loadrpathold=1       ! 1=load rpath from a previous run

! preferences and technology
REAL :: bet
REAL :: gam
REAL :: delt     ! capital deprec.
REAL :: eta      ! altruism toward children
REAL :: ni       ! decr returns
REAL :: alph     ! capital share in non entr sector
REAL :: alphe    ! capital share in entr sector
REAL, PARAMETER :: pyou=.9778   ! prob. staying young
REAL, PARAMETER :: pold=.911    ! prob. staying old (not dying)

! government parameters
REAL, PARAMETER :: replrate=0.4 ! repl. rate for pensions
REAL :: gfrac    ! frac gov exp / gdp
REAL :: debtfrac ! frac gov debt /total capital

! enforcement
REAL :: eff      ! prop k kept when defaulting


! bcs
INTEGER :: epsihato ! kohat-newkohat: how bc changes across iter for old
INTEGER :: epsihaty ! kyhat-newkyhat: how bc changes across iter for young
INTEGER :: epsihat  ! epsihat=abs((kyhat-newkyhat)+(kohat-newkohat))=0
                    ! iterate on val funs and bc until it's zero.

!miscellanea 
CHARACTER(20) :: fname
REAL :: cacca ! useless placemarkers
REAL, DIMENSION(T1-2) :: cacca1v
REAL, DIMENSION(T2-1) :: cacca2v
REAL, DIMENSION(Ttrans-2) :: cacca3v
INTEGER, DIMENSION(2) :: imaxmat

! prices and stuff
REAL :: wage, rbar, invprodrbar, wageimplied, rimplied, Pvprimgovsurp,govbalPV,govbalPVmin,govbalPVmax
REAL :: rbar1ss,rbar2ss

! transition objects
REAL,  DIMENSION(Ttrans) :: taucpath, taubalpath, rbarpath,wagepath, govdebtT, taxeslesstransfT
REAL :: tauc, taucinterp, taucadj, taucadjmin,taucadjmax ! param adjusting path of tauc
REAL :: taubal, taubalinterp, taubaladj, taubaladjmin,taubaladjmax 

! indexes
INTEGER :: i,i2,j,j1,j2,jj,l,ll,Ttime, Tfinal, OpenStatus, iteragovbal, iterakhat, iterar
INTEGER, DIMENSION(1) :: imax 

! convergence criteria
REAL :: epsigovmin, epsigov, epsinvm, epsir, epsirmin 

! pensions
REAL :: transf, transf2ss
! grids
REAL, DIMENSION(da) :: a !,anet       ! grid for assets
REAL, DIMENSION(dk) :: k        ! grid for k
REAL, DIMENSION(dr) :: r        ! grid for entrepr. ability
REAL, DIMENSION(dy) :: y        ! grid for worker ability   
REAL, DIMENSION(dr*dy,dr*dy) :: Pyr,Pyrtr ! joint distr. of y and r
REAL, DIMENSION(dr,dr) :: Pr, Prtr  ! p(r'|r)
REAL, DIMENSION(dy,dy) :: Py,Pytr   ! p(y'|y)
REAL, DIMENSION(dy*dr) ::   invyr   ! invariant distr of y and r
REAL, DIMENSION(dy) ::      invy    ! invariant distr of y and r
!REAL, DIMENSION(dr) :: invr         ! inv dist for r

! taxes estimated using Gouveia Strauss tau=b-b*(s*y**p+1)**(-1/p)
! stax depends on income normalization
REAL :: btaxw,staxw,ptaxw,staxwbase
REAL :: btaxe,staxe,ptaxe,staxebase

!value functions
! young
REAL, DIMENSION(da,dy,dr) :: Vy, Vynext, Vynext2ss   ! young, current, and next period's vf
REAL, DIMENSION(da,dy,dr) :: Vye  ! young that is entrep for this period
REAL, DIMENSION(da,dy,dr) :: Vyw  ! young that is worker for this period
! old
REAL, DIMENSION(da,dr) :: Voee   ! old entrepreneur staying entrep
REAL, DIMENSION(da) :: Vow, Vownext, Vownext2ss      ! old, retired, worker,  current, and next period's vf
REAL, DIMENSION(da,dr) :: Voe, Voenext, Voenext2ss    ! old entrepreneur,  current, and next period's vf
REAL, DIMENSION(da) :: EVnewbw   ! exp value newborn worker
REAL, DIMENSION(da,dr) :: EVnewbe    ! exp value newborn entr
REAL, DIMENSION(da,dy,dr) :: EVy
! defaulted guys
REAL, DIMENSION(dk,dy,dr) :: Vwkeff ! defaulted worker
REAL, DIMENSION(dk) :: Vokeff    ! defaulted OLD worker

! policy functions
! young
INTEGER, DIMENSION(da,dy,dr) :: apolye, kpolye ! young that is entr for this period
INTEGER, DIMENSION(da,dy,dr) :: apolyw         ! young that is worker this period
REAL, DIMENSION(da,dy,dr) :: labpoly           ! labor demand for young entr
INTEGER, DIMENSION(da,dy,dr,Ttrans) :: apolyT,kpolyT   ! young
REAL, DIMENSION(da,dy,dr,Ttrans) :: labpolyT         ! labor demand for young entr
INTEGER, DIMENSION(da,dy,dr) :: apoly2ss,kpoly2ss   ! young
REAL, DIMENSION(da,dy,dr) :: labpoly2ss        ! labor demand for young entr


! old
INTEGER, DIMENSION(da,Ttrans) :: apolowT               ! old, retired, worker
INTEGER, DIMENSION(da,dr,Ttrans) :: apoloeT,kpoloeT    ! old entrepreneur
REAL, DIMENSION(da,dr,Ttrans) :: labpoloeT         ! labor demand for old entrep
INTEGER, DIMENSION(da) :: apolow2ss               ! old, retired, worker
INTEGER, DIMENSION(da,dr) :: apoloe2ss,kpoloe2ss    ! old entrepreneur
REAL, DIMENSION(da,dr) :: labpoloe2ss         ! labor demand for old entrep

! exogenous investment limits
INTEGER, DIMENSION(da,dy,dr) :: kyhat, kyhat2ss   ! young entr: max k(a,y,r)
INTEGER, DIMENSION(da,dr) :: kohat, kohat2ss      ! old entr: max k(a,r)
INTEGER, DIMENSION(da,dy,dr) :: newkyhat      ! 
INTEGER, DIMENSION(da,dr) :: newkohat         ! 

! transition matrix
INTEGER, DIMENSION(nonzero) :: colM, rowM     ! row and col index
REAL, DIMENSION(nonzero) :: valM              ! value (trans probability)

! invariant distribution
REAL, DIMENSION(nstates) :: invm,invm1,invm1ss  ! invar distr prob
REAL, DIMENSION(da) :: prgrid           ! invariant distr on a
REAL, DIMENSION(da) :: prgridyw,prgridye,prgridoe,prgridow  ! same by groups
REAL :: totayw,totaye,totaow,totaoe
REAL, DIMENSION(nstates-da) :: invlevk,invrk   ! k and r level corr to invm
!INTEGER, DIMENSION(nstates-da):: invpolk      ! k policy corr to invm

REAL, DIMENSION(nstates-da) :: invlabe,invtotlabe ! outside labor and total labor demand to invm
REAL :: hiredlabe								  ! labor employed by entr and 
REAL :: incky,incko                               ! entr's gross product (young and old)
REAL :: k2gdp									  ! k2gdp ratio
REAL, DIMENSION(Ttrans) :: totaT, gdpT, govprimsurpT, totkcorpT ! keep track of aggr during transition
REAL, DIMENSION(Ttrans) :: totkT, totlcorpT, inckT,gpublicT
REAL, DIMENSION(Ttrans) :: rimpliedT,wageimpliedT
REAL, DIMENSION(2*nyoung) :: invrky,invlevky,invtotlabye,invmy  ! var to calculate incky and incko
REAL, DIMENSION(noe) :: invrko,invlevko,invtotlaboe,invmo       ! var to calculate incky and incko

REAL :: totentr                         ! number of entrepreneurs
REAL :: totret                          ! number of retirees
REAL :: totL,toteffL    ! number of workers  and total efficiency units of labor
! government revenues
REAL, DIMENSION(nstates) :: vectaxcw,vectaxce,vectaxl,vectaxe ! vectaxa, vectaxbw, vectaxbe
REAL :: tottaxcw,tottaxce,tottaxe,tottaxl,totincw, totincw2ss ! tottaxbw,tottaxbe, tottaxa
REAL :: govdebt1ss, govdebt2ss, govbal

! temporary objects
REAL :: ytaxw,taxw,taxo,ytaxo
REAL, DIMENSION(dk) :: ytaxe,taxe
REAL, DIMENSION(da) :: ucons,cs
REAL, DIMENSION(da,da) :: uconsold
REAL, DIMENSION(da,da,dr,dk) :: uconsolde
REAL, DIMENSION(da,da,dy) :: uconsw
REAL, DIMENSION(da,da,dr-1,dk) :: uconse 
REAL, DIMENSION(dk) :: uconsl,csl
REAL, DIMENSION(da,dy,dr) :: newVy 
REAL, DIMENSION(da,dy,dr) :: newVyw,newVye
REAL, DIMENSION(da,dr) :: newVoe    ! old entrepreneur
REAL, DIMENSION(da) :: newVow       ! old, retired, worker
REAL, DIMENSION(da) :: Vowtemp
REAL, DIMENSION(da):: Vywtemp
REAL, DIMENSION(dk,da) :: Vyetemp
REAL, DIMENSION(dk,da) :: Veetemp
REAL, DIMENSION(dk,da) :: Voeetemp
REAL, DIMENSION(sizeM) :: sumrowM

REAL :: ahere,khere,rhere,entinchere,winchere,lhere,taxwhere,taxehere,inchere  ! add lhere
REAL, DIMENSION(dk) :: laboe,labye           ! outside labor demand for old and young entr
REAL :: term1,front1,labdemand               ! additional variables for entr's labor demand

! miscellanea
REAL, DIMENSION(dy*dr) ::eigvalyr
COMPLEX, DIMENSION(dy*dr) :: eigvalcyr
REAL, DIMENSION(dy*dr,dy*dr) ::eigvecyr
COMPLEX, DIMENSION(dy*dr,dy*dr) :: eigveccyr
INTEGER :: counter,crow,count1,count2,counter2
REAL :: penalty
REAL :: pertgov

INTEGER :: bracketgov,havetaucmin, havetaubalmin

REAL :: fundiffnow,fundiffmin,fundiffmax

REAL :: totkborr    !total amount borrowed by e
REAL :: totyshe     !total shadow labor income for e

! ******************  INTERFACE SUBROUTINES
INTERFACE

SUBROUTINE linspace (xmin,xmax,npoints,lspace)
IMPLICIT NONE
REAL, INTENT(IN) :: xmin,xmax
INTEGER, INTENT(IN) :: npoints
REAL, DIMENSION(npoints), INTENT(OUT) :: lspace
END SUBROUTINE linspace

SUBROUTINE  interplin(l,x,y,n,z,v)
IMPLICIT NONE
INTEGER, INTENT(IN) :: l
INTEGER, INTENT(IN) :: n
REAL, DIMENSION(l), INTENT(IN) :: x
REAL, DIMENSION(l), INTENT(IN) :: y
REAL, DIMENSION(n), INTENT(IN) :: z
REAL, DIMENSION(n), INTENT(OUT) :: v
END SUBROUTINE

END INTERFACE

! load stuff from initial and final ss

! reading borrowing contraints
fname="exobcFINALSS"
open (unit=32,file=fname,status="old", &
&       action="read",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE (*,*) 'problems opening ', fname
END IF
DO i=1,da
	DO j=1,dy
		DO jj=1,dr
			READ (unit=32, fmt=*) kyhat2ss(i,j,jj)
		END DO
	END DO
END DO
DO i=1,da
	DO jj=1,dr
		READ (unit=32, fmt=*) kohat2ss(i,jj)
	END DO
END DO
CLOSE (unit=32)

! read in value functions FROM FINAL SS
fname="valfunFINALSS"
open (unit=32,file=fname,status="old", &
&       action="read",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
READ(unit=32,fmt=*) cacca
READ(unit=32,fmt=*) cacca
READ(unit=32,fmt=*) cacca
READ(unit=32,fmt=*) cacca
DO i=1,da
    READ(unit=32,fmt=*) a(i)
END DO
DO i=1,dy 
    READ(unit=32,fmt=*) y(i)
END DO
DO i=1,dr
    READ(unit=32,fmt=*) r(i)
END DO
DO i=1,dk
    READ(unit=32,fmt=*) k(i)
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) Vynext2ss(i,j,jj) ! t+1 val fun taken as given in t
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) Vyw(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) Vye(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    READ(unit=32,fmt=*) Vownext2ss(i)
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) Voenext2ss(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) Voee(i,jj)
    END DO
END DO
DO i=1,dk
    READ(unit=32,fmt=*) cacca !Vokeff(i)
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) apoly2ss(i,j,jj) 
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) kpoly2ss(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) cacca ! apolye(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) cacca !kpolye(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) cacca !apolyw(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    READ(unit=32,fmt=*) apolow2ss(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) cacca !apolownet(i)
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) apoloe2ss(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) cacca !apoloenet(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) kpoloe2ss(i,jj)
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) cacca
        END DO
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) cacca
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) labpoly2ss(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) labpoloe2ss(i,jj)
    END DO
END DO
READ(unit=32,fmt=*) delt
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) cacca !conspoly(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) cacca !netincy(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) cacca !grossincy(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    READ(unit=32,fmt=*) cacca ! conspolow(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) cacca ! netincow(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) cacca ! grossincow(i)
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) cacca ! conspoloe(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) cacca ! netincoe(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) cacca ! grossincoe(i,jj)
    END DO
END DO
CLOSE (unit=32)


fname="invdistr"
! saving invariant distr
open (unit=32,file=fname,status="old", &
&       action="READ", position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
READ(unit=32,fmt=*) cacca
READ(unit=32,fmt=*) cacca
READ(unit=32,fmt=*) cacca
DO i=1,nstates
    READ(unit=32,fmt=*) invm1ss(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) prgrid(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) prgridyw(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) prgridye(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) prgridoe(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) prgridow(i)
END DO
READ(unit=32,fmt=*) totaT(1)
READ(unit=32,fmt=*) totkT(1)
READ(unit=32,fmt=*) inckT(1)
DO i=1,(nstates-da) 
    READ(unit=32,fmt=*) invlevk(i)
END DO  
DO i=1,(nstates-da) 
    READ(unit=32,fmt=*) cacca !invpolk(i)
END DO  
DO i=1,(nstates-da)
    READ(unit=32,fmt=*) invrk(i)
END DO
READ(unit=32,fmt=*) k2gdp
READ(unit=32,fmt=*) cacca !ykshare
READ(unit=32,fmt=*) rbar1ss
DO i=1,dr
    READ(unit=32,fmt=*) cacca !invr(i)
END DO
READ(unit=32,fmt=*) cacca ! totke
READ(unit=32,fmt=*) bet
READ(unit=32,fmt=*) gam
READ(unit=32,fmt=*) eff
READ(unit=32,fmt=*) eta
READ(unit=32,fmt=*) ni
READ(unit=32,fmt=*) cacca !propewswitch
READ(unit=32,fmt=*) cacca !propweswitch
READ(unit=32,fmt=*) alph
DO i=1,dy
    READ(unit=32,fmt=*) invy(i)
END DO
DO i=1,dr
    DO j=1,dr
        READ(unit=32,fmt=*) Pr(i,j)
    END DO
END DO
READ(unit=32,fmt=*) cacca !yktotsh
READ(unit=32,fmt=*) totentr 
READ(unit=32,fmt=*) totret
READ(unit=32,fmt=*) totL
READ(unit=32,fmt=*) wagepath(1)
READ(unit=32,fmt=*) cacca !beq2gdp
READ(unit=32,fmt=*) totkborr
READ(unit=32,fmt=*) totyshe
READ(unit=32,fmt=*) toteffL
READ(unit=32,fmt=*) totlcorpT(1)
READ(unit=32,fmt=*) hiredlabe
DO i=1,(2*nyoung)
    READ(unit=32,fmt=*) invtotlabye(i)
END DO
DO i=1,noe
    READ(unit=32,fmt=*) invtotlaboe(i)
END DO
READ(unit=32,fmt=*) alphe
CLOSE (unit=32)


fname="invdistrFINALSS"
! saving invariant distr
open (unit=32,file=fname,status="old", &
&       action="READ", position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
READ(unit=32,fmt=*) cacca
READ(unit=32,fmt=*) cacca
READ(unit=32,fmt=*) cacca
DO i=1,nstates
    READ(unit=32,fmt=*) cacca ! invm(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) cacca !prgrid(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) cacca !prgridyw(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) cacca !prgridye(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) cacca !prgridoe(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) cacca ! prgridow(i)
END DO
READ(unit=32,fmt=*) totaT(Ttrans)
READ(unit=32,fmt=*) totkT(Ttrans)
READ(unit=32,fmt=*) inckT(Ttrans)
DO i=1,(nstates-da) 
    READ(unit=32,fmt=*) cacca ! invlevk(i)
END DO  
DO i=1,(nstates-da) 
    READ(unit=32,fmt=*) cacca !invpolk(i)
END DO  
DO i=1,(nstates-da)
    READ(unit=32,fmt=*) cacca ! invrk(i)
END DO
READ(unit=32,fmt=*) cacca ! k2gdp
READ(unit=32,fmt=*) cacca !ykshare
READ(unit=32,fmt=*) rbar2ss
DO i=1,dr
    READ(unit=32,fmt=*) cacca !invr(i)
END DO
READ(unit=32,fmt=*) cacca ! totke
READ(unit=32,fmt=*) cacca ! bet
READ(unit=32,fmt=*) cacca !gam
READ(unit=32,fmt=*) cacca !eff
READ(unit=32,fmt=*) cacca !eta
READ(unit=32,fmt=*) cacca !ni
READ(unit=32,fmt=*) cacca !propewswitch
READ(unit=32,fmt=*) cacca !propweswitch
READ(unit=32,fmt=*) cacca !alph
DO i=1,dy
    READ(unit=32,fmt=*) cacca !invy(i)
END DO
DO i=1,dr
    DO j=1,dr
        READ(unit=32,fmt=*) cacca !Pr(i,j)
    END DO
END DO
READ(unit=32,fmt=*) cacca !yktotsh
READ(unit=32,fmt=*) cacca !totentr 
READ(unit=32,fmt=*) cacca !totret
READ(unit=32,fmt=*) cacca !totL
READ(unit=32,fmt=*) wagepath(Ttrans)
READ(unit=32,fmt=*) cacca !beq2gdp
READ(unit=32,fmt=*) cacca ! totkborr
READ(unit=32,fmt=*) cacca !totyshe
READ(unit=32,fmt=*) cacca !toteffL
READ(unit=32,fmt=*) totlcorpT(Ttrans)
READ(unit=32,fmt=*) cacca !hiredlabe
DO i=1,(2*nyoung)
    READ(unit=32,fmt=*) cacca !invtotlabye(i)
END DO
DO i=1,noe
    READ(unit=32,fmt=*) cacca !invtotlaboe(i)
END DO
READ(unit=32,fmt=*) cacca !alphe
CLOSE (unit=32)

fname="govtax"
! saving totals for government
open (unit=32,file=fname,status="old", &
&       action="READ",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
	WRITE(*,*) 'problems opening ', fname
END IF
READ(unit=32,fmt=*) gdpT(1)
READ(unit=32,fmt=*) govdebt1ss
READ(unit=32,fmt=*)	transf
READ(unit=32,fmt=*)	gfrac
READ(unit=32,fmt=*)	debtfrac
READ(unit=32,fmt=*)	tottaxl
READ(unit=32,fmt=*)	tottaxe
READ(unit=32,fmt=*)	cacca !tottaxa
READ(unit=32,fmt=*)	tottaxcw
READ(unit=32,fmt=*)	tottaxce
READ(unit=32,fmt=*)	cacca !tottaxbw
READ(unit=32,fmt=*)	cacca !tottaxbe    
READ(unit=32,fmt=*)	cacca !govbal
READ(unit=32,fmt=*)	taubal
READ(unit=32,fmt=*)	btaxw
READ(unit=32,fmt=*)	staxw
READ(unit=32,fmt=*)	ptaxw
READ(unit=32,fmt=*)	staxwbase
READ(unit=32,fmt=*)	totincw
READ(unit=32,fmt=*)	btaxe
READ(unit=32,fmt=*)	staxe
READ(unit=32,fmt=*)	ptaxe
READ(unit=32,fmt=*)	staxebase
READ(unit=32,fmt=*)	cacca !totincw
READ(unit=32,fmt=*)	cacca
READ(unit=32,fmt=*)	cacca
READ(unit=32,fmt=*)	cacca
READ(unit=32,fmt=*)	cacca
READ(unit=32,fmt=*)	cacca
CLOSE(unit=32)

totkcorpT(1)=totaT(1)/(1.0+debtfrac)-totkT(1)

fname="govtaxFINALSS"
! saving totals for government
open (unit=32,file=fname,status="old", &
&       action="READ",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
READ(unit=32,fmt=*) gdpT(Ttrans)
READ(unit=32,fmt=*) govdebt2ss
READ(unit=32,fmt=*)	transf2ss !transf
READ(unit=32,fmt=*)	cacca !gfrac
READ(unit=32,fmt=*)	cacca !debtfrac
READ(unit=32,fmt=*)	cacca !tottaxl
READ(unit=32,fmt=*)	cacca !tottaxe
READ(unit=32,fmt=*)	cacca !tottaxa
READ(unit=32,fmt=*)	cacca !tottaxcw
READ(unit=32,fmt=*)	cacca !tottaxce
READ(unit=32,fmt=*)	cacca !tottaxbw
READ(unit=32,fmt=*)	cacca !tottaxbe    
READ(unit=32,fmt=*)	cacca !govbal
READ(unit=32,fmt=*)	cacca !taubal
READ(unit=32,fmt=*)	cacca !btaxw
READ(unit=32,fmt=*)	cacca !staxw
READ(unit=32,fmt=*)	cacca !ptaxw
READ(unit=32,fmt=*)	cacca !staxwbase
READ(unit=32,fmt=*)	totincw2ss
READ(unit=32,fmt=*)	cacca !btaxe
READ(unit=32,fmt=*)	cacca !staxe
READ(unit=32,fmt=*)	cacca !ptaxe
READ(unit=32,fmt=*)	cacca !staxebase
READ(unit=32,fmt=*)	cacca !totincw
READ(unit=32,fmt=*)	cacca
READ(unit=32,fmt=*)	cacca
READ(unit=32,fmt=*)	cacca
READ(unit=32,fmt=*)	cacca
READ(unit=32,fmt=*)	cacca
CLOSE(unit=32)

fname="yentr2"
! reading income and transitions
open (unit=32,file=fname,status="old", &
&       action="read",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE (*,*) 'problems opening ', fname
END IF
READ (unit=32, fmt=*) y

Py=0
DO i=1,dy
    READ (unit=32, fmt=*) Py(i,:)
    !we'll normalize the submatrix below
    Py(i,:)=Py(i,:)/SUM(Py(i,:))
END DO
CLOSE (unit=32)


! make up joint distr for y and r. y is outside
DO j=1,dy       !   y today
    DO jj=1,dy  !   y tomorrow
        Pyr((j-1)*dr+1:j*dr,(jj-1)*dr+1:jj*dr)=Py(j,jj)*Pr      
    END DO
END DO
DO i=1,dy*dr
    Pyr(i,:)=Pyr(i,:)/SUM(Pyr(i,:)) 
END DO


Pyrtr=TRANSPOSE(Pyr) ! compute inv dist for joint of y and r
CALL evcrg (dy*dr,Pyrtr,dy*dr,eigvalcyr,eigveccyr,dy*dr)
eigvalyr=REAL(eigvalcyr)
eigvecyr=REAL(eigveccyr)
imax=MAXLOC(eigvalyr)
invyr=eigvecyr(:,imax(1))
invyr=invyr/SUM(invyr)

fname="output"
OPEN (unit=32,file=fname,status="replace", &
&       action="write",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE (*,*) 'problems opening ', fname
END IF
WRITE (unit=32, fmt=*) "***************************************"
WRITE (unit=32, fmt=*) "bet=",bet,"   gam=",gam,"   eta=",eta
WRITE (unit=32, fmt=*) "ni= ",ni,"  theta=",r(2),"   eff=",eff
WRITE (unit=32, fmt=*) "delt=",delt   
WRITE (unit=32, fmt=*) "alph=",alph,"   alphe=",alphe
WRITE (unit=32, fmt=*) "abig=",abig
WRITE (unit=32, fmt=*) "pyou=",pyou, "	pold=", pold
WRITE (unit=32, fmt=*) "eff=",eff
WRITE (unit=32, fmt=*) "replrate=",replrate
WRITE (unit=32, fmt=*) "gfrac=",gfrac,"   debtfrac=", debtfrac
WRITE (unit=32, fmt=*) "taubal1ss=",taubal1ss,"   taubal2ss=",taubal2ss
WRITE (unit=32, fmt=*) "tauc1ss=",tauc1ss,"   tauc2ss=",tauc2ss
WRITE (unit=32, fmt=*) "govdebt1ss=", govdebt1ss, "govdebt2ss=", govdebt2ss
WRITE (unit=32, fmt=*) "rbar1ss=",rbar1ss,"   rbar2ss=",rbar2ss
WRITE (unit=32, fmt=*) "epsigovmin=",epsigovmin
WRITE (unit=32, fmt=*) "epsir=",epsir
WRITE (unit=32, fmt=*) "***************************************"
CLOSE (unit=32)

fname="checkgovdebt"
OPEN (unit=32,file=fname,status="replace", &
&       action="write",position="rewind",iostat=OpenStatus)
WRITE (unit=32, fmt=*) "--------"
CLOSE (unit=32)			        


! initialize some stuff
pertgov=0.0000 ! (taucadj+or-pertgov)*taucinterp

! convergence criterions and penalty
epsigovmin=.00005
epsirmin=1e-05
penalty=-1e+7

! INTIALIZE, JUST IN CASE
apolyT=0
kpolyT=0
labpolyT=0.0
apolowT=0
apoloeT=0
kpoloeT=0
labpoloeT=0.0

! fill in values for final steady ss policy fns
IF (dorloop==0) THEN ! exogenous prices, pol fns constant after T2+T2
	DO i=T1+T2,Ttrans
		apolyT(:,:,:,i)=apoly2ss
		kpolyT(:,:,:,i)=kpoly2ss
		labpolyT(:,:,:,i)=labpoly2ss
		apolowT(:,i)=apolow2ss
		apoloeT(:,:,i)=apoloe2ss
		kpoloeT(:,:,i)=kpoloe2ss
		labpoloeT(:,:,i)=labpoloe2ss
	END DO
ELSE  ! endo prices, pol fns potentially change over all of Ttrans
	DO i=Ttransold,Ttrans
		apolyT(:,:,:,i)=apoly2ss
		kpolyT(:,:,:,i)=kpoly2ss
		labpolyT(:,:,:,i)=labpoly2ss
		apolowT(:,i)=apolow2ss
		apoloeT(:,:,i)=apoloe2ss
		kpoloeT(:,:,i)=kpoloe2ss
		labpoloeT(:,:,i)=labpoloe2ss
	END DO
END IF


!define staxw and staxe. note that totincw is fixed over transition and final ss
staxw=staxwbase*totincw2ss**(-ptaxw)
staxe=staxebase*totincw2ss**(-ptaxe)


! defining initial (linear) guess for rbarpath
rbarpath(1)=rbar1ss
rbarpath(Ttransold:Ttrans)=rbar2ss
CALL linspace(2.0,Ttransold-1.0,Ttransold-2,cacca3v)
CALL interplin(2,(/1.0, REAL(Ttransold)/),(/rbar1ss, rbar2ss /), &
		Ttransold-2,cacca3v,rbarpath(2:Ttransold-1))
IF (loadrpathold==1) THEN
	fname="rpath0604"
	! loading rbarpath from previous run
	open (unit=32,file=fname,status="old", &
	&       action="READ", position="rewind",iostat=OpenStatus)
		IF (OpenStatus.NE.0) THEN
		WRITE(*,*) 'problems opening ', fname
	END IF  
	DO i=2,Ttransold-1
		READ(unit=32,fmt=*) rbarpath(i)
	END DO
	CLOSE (unit=32)
END IF
wagepath=(1-alph)*abig*((rbarpath+delt)/(alph*abig))**(alph/(alph-1))
! these two below are never updated, so we simply define them here
rimpliedT(1)=rbar1ss
rimpliedT(Ttrans)=rbar2ss
wageimpliedT(1)=(1-alph)*abig*((rbar1ss+delt)/(alph*abig))**(alph/(alph-1))
wageimpliedT(Ttrans)=(1-alph)*abig*((rbar2ss+delt)/(alph*abig))**(alph/(alph-1))


! define initial guess for tax path
IF (usetax2balance==0) THEN ! use taubal to balance govt bc	
	! define taubalpath
	taubaladj=0.0 ! taubal "peaks" at T1 during trans
	! taubal btw T=2, and T2-1 as interpolated values, T1 is breakpoint
	taubalinterp=taubal1ss+REAL(T1)/REAL((T1+T2))*(taubal2ss-taubal1ss)
	taubalpath(1)=taubal1ss 
	taubalpath(T1)=taubalinterp*(1+taubaladj)
	taubalpath(T1+T2:Ttrans)=taubal2ss		
	! FROM 2 TO T1-1	
	CALL linspace(2.0,T1-1.0,T1-2,cacca1v)
	WRITE(*,*) "cacca1v", cacca1v
	CALL interplin(2,(/1.0, REAL(T1)/),(/taubal1ss, taubalinterp*(1+taubaladj)/),T1-2,cacca1v,taubalpath(2:T1-1))
	! FROM T1+1 to T2-1
	CALL linspace(T1+1.0,T1+T2-1.0,T2-1,cacca2v)
	CALL interplin(2,(/REAL(T1), REAL(T1+T2)/),(/taubalinterp*(1+taubaladj), taubal2ss/),T2-1,cacca2v,taubalpath(T1+1:T1+T2-1))	
	! define tauc and taucpath
	tauc=tauc1ss ! define what tauc is
	taucinterp=tauc1ss+REAL(T1)/REAL((T1+T2))*(tauc2ss-tauc1ss) ! initialize as a check
	taucadj=0.0    ! initialize as a check
	taucadjmin=0.0 ! initialize as a check
	taucadjmax=0.0 ! initialize as a check	
	taucpath=tauc1ss  ! initialize as a check
ELSE  ! use consumption tax to balance govt bc	
	! define taucpath	
	taucadj=0 ! tauc "peaks" at T1 during trans, with (1+taucadj)*tauinterp as value
	! determine tauc btw T=2, and T2-1 as interpolated values, T1 is breakpoint
	taucinterp=tauc1ss+REAL(T1)/REAL((T1+T2))*(tauc2ss-tauc1ss)
	taucpath(1)=tauc1ss 
	taucpath(T1)=taucinterp*(1+taucadj)
	taucpath(T1+T2:Ttrans)=tauc2ss		
	taubalinterp=taubal1ss+REAL(T1)/REAL((T1+T2))*(taubal2ss-taubal1ss) ! initialize as a check
	! FROM 2 TO T1-1
	CALL linspace(2.0,T1-1.0,T1-2,cacca1v)
	CALL interplin(2,(/1.0, REAL(T1)/),(/tauc1ss, taucinterp*(1+taucadj)/),T1-2,cacca1v,taucpath(2:T1-1))		
	! FROM T1+1 to T2-1
	CALL linspace(T1+1.0,T1+T2-1.0,T2-1,cacca2v)
	WRITE(*,*) "cacca2v", cacca2v
	CALL interplin(2,(/REAL(T1), REAL(T1+T2)/),(/taucinterp*(1+taucadj), tauc2ss/),T2-1,cacca2v,taucpath(T1+1:T1+T2-1))	
	WRITE(*,*) "taucpath(1:T1+T2))", taucpath(1:T1+T2)
	! define taubal and taubalpath
	taubal=taubal1ss
	taubaladj=0.0    ! initialize just as a check
	taubaladjmin=0.0 ! initialize just as a check
	taubaladjmax=0.0 ! initialize just as a check
	taubalpath=taubal1ss
END IF ! IF (usetax2balance==0) THEN

taucpath=tauc1ss
taubalpath=taubal1ss

! initialize error for r bar computation and counter for prices loop
epsir=1.0
iterar=1

fname="rpath"
open (unit=32,file=fname,status="replace", &
	&       action="WRITE",position="rewind",iostat=OpenStatus)
	IF (OpenStatus.NE.0) THEN
		WRITE(*,*) 'problems opening ', fname
	END IF
	WRITE(unit=32,fmt=*) Ttrans
CLOSE (unit=32)	

! loop on equilibrium interest rate path
DO WHILE ((epsir>epsirmin))    		
	epsigov=10.0
	bracketgov=1 ! need to compute first bound for taucadjust
	iteragovbal=0
	havetaubalmin=0
	DO WHILE (epsigov>epsigovmin) 
		
		WRITE(*,*) "****************************** "
		WRITE(*,*) "iteragovbal=", iteragovbal
		WRITE(*,*) "iterar=", iterar
		WRITE(*,*) "****************************** "
					
		iteragovbal=iteragovbal+1
		
		fname="rpath"
		open (unit=32,file=fname,status="replace", &
		&       action="WRITE",position="rewind",iostat=OpenStatus)
		IF (OpenStatus.NE.0) THEN
			WRITE(*,*) 'problems opening ', fname
		END IF
		DO i=1,Ttrans
			WRITE(unit=32,fmt=*) rbarpath(i)
		END DO
		CLOSE (unit=32)	
		

		! define index to compute pol funs and val fun: up to T1+T2-1 if exo prices,
		! up to Ttransold-1 if endo prices
		IF (dorloop==0) THEN
			Tfinal=T1+T2-1
		ELSE
			Tfinal=Ttransold-1
		END IF
		
		! reinitialize final ss from correct value
		Vynext=Vynext2ss
		Voenext=Voenext2ss
		Vownext=Vownext2ss
		kyhat=kyhat2ss
		kohat=kohat2ss

		! ***************************************************************************
		! Go backward in time to compute value funs and pol funs starting from FINAL SS				
		! ***************************************************************************		
		DO Ttime=Tfinal,2,-1		
			rbar=rbarpath(Ttime)
			wage=wagepath(Ttime)
			transf=replrate*wage*DOT_PRODUCT(y,invy)						
			! define useful constants
			term1=1.0/((1.0-alphe)*ni-1.0)
			front1=(wage/(ni*(1.0-alphe)))**term1	

			WRITE(*,*) "TtimeFIRST", Ttime
		
			IF (usetax2balance==0) THEN
				taubal=taubalpath(Ttime)	
			ELSE
				tauc=taucpath(Ttime) 
			END IF
				 
			! we now compute U(c) since it does not depend on V and borrowing constr
			uconsold=0.0    ! old retired.   rows=a, column=a'
			DO i=1,da ! today's assets
				ytaxo=transf+rbar*a(i)
				taxo=(btaxw-btaxw*(staxw*ytaxo**ptaxw+1)**(-1/ptaxw))*ytaxo &
					 & +taubal*ytaxo
				cs=(a(i)*(1+rbar)+transf-a-taxo)/(1+tauc)
				WHERE (cs>0)
					ucons=(cs**(1-gam))/(1-gam)
				ELSEWHERE 
					ucons=penalty
				END WHERE
				uconsold(i,:)=ucons
			END DO
        
			uconsolde=0.0       ! old entrepreneur staying entr (da,da',dr,dk)
			DO i=1,da           ! today's assets
				DO j=1,dr       ! today's r
					laboe=front1*r(j)**(-term1)*k**(-alphe*ni*term1)
					laboe=max(0.0,laboe-1.0)
					ytaxe=r(j)*(k**alphe*(1.0+laboe)**(1.0-alphe))**ni-delt*k-rbar*(k-a(i))-wage*laboe
					! those with r=0 can have negative income. set taxes to zero in such case
					WHERE (ytaxe>0.0) 
						taxe=(btaxe-btaxe*(staxe*ytaxe**ptaxe+1)**(-1/ptaxe))* &
						& ytaxe+taubal*ytaxe
					ELSEWHERE 
						taxe=0.0
					END WHERE
					DO jj=1,da  ! tomorrow's a'
						csl=(ytaxe-taxe+a(i)-a(jj))/(1+tauc)
						WHERE (csl>0.0)                         
							uconsl=(csl**(1-gam))/(1-gam)
						ELSEWHERE 
							uconsl=penalty
						END WHERE
						uconsolde(i,jj,j,:)=uconsl                      
					END DO
				END DO
			END DO     

			uconsw=0.0  ! young worker  (da,da',dy) note: does not depend on r!
			DO i=1,da ! today
				DO j=1,dy ! today's y                       
					ytaxw=wage*y(j)+rbar*a(i)                       
					taxw=(btaxw-btaxw*(staxw*ytaxw**ptaxw+1)**(-1/ptaxw))&
						&   *ytaxw+taubal*ytaxw
					cs=((1+rbar)*a(i)+wage*y(j)-taxw-a)/(1+tauc)
					WHERE (cs>0)
						ucons=(cs**(1-gam))/(1-gam)
					ELSEWHERE 
						ucons=penalty
					END WHERE
					uconsw(i,:,j)=ucons
				END DO
			END DO
  
			! young entrepreneur 
		    uconse=0.0  !   young e     (da,da',dr,dk)
	        DO i=1,da       !today's assets
				DO j=2,dr   ! today's r ! changed from dy=1,dr
					labye=front1*r(j)**(-term1)*k**(-alphe*ni*term1)
					labye=max(0.0,labye-1.0)                
					ytaxe=r(j)*(k**alphe*(1.0+labye)**(1.0-alphe))**ni-delt*k-rbar*(k-a(i))-wage*labye 
					taxe=(btaxe-btaxe*(staxe*ytaxe**ptaxe+1)**(-1/ptaxe)) &
					&   *ytaxe+taubal*ytaxe
					DO jj=1,da  ! tomorrow's a'
						csl=(ytaxe-taxe+a(i)-a(jj))/(1+tauc)
						WHERE (csl>0.0)
							uconsl=(csl**(1.0-gam))/(1.0-gam)
	                    ELSEWHERE 
		                    uconsl=penalty
			            END WHERE
				        uconse(i,jj,j-1,:)=uconsl 
					END DO
				END DO 
			END DO
		
			! if exo bc, we loaded them already, otherwise, as follows
			IF (switchbc==2) THEN !endo for young and old			
				! START OVER FROM PREVIOUS +SOMETHING, 
				DO i=1,da
					DO j=1,dy
						DO jj=1,dr
							kyhat(i,j,jj)=MIN(kyhat(i,j,jj)+5,dk)
						END DO
					END DO
				END DO
				DO i=1,da
					DO jj=1,dr
						kohat(i,jj)=MIN(kohat(i,jj)+5,dk)
					END DO
				END DO
			END IF 
			IF (switchbc==1) THEN ! old only
				DO i=1,da
					DO jj=1,dr
						kohat(i,jj)=MIN(kohat(i,jj)+5,dk)
					END DO
				END DO			
			END IF	

		
			! regardless of type of bc impose that people with r=0 cannot borrow (true anyway)
			kyhat(:,:,1)=0
			kohat(:,1)=0    
		
			iterakhat=1 ! first round for given rbar and taul
			! go and compute value fn for given bc
			epsihat=1		
			DO WHILE (epsihat>0) ! loop on endogenous borrowing constraints
				epsihat=0            			
				! compute expected value of V of NEWBORNS
				! only NEWBORN ENTREPRENEUR, INHERITS parent's r'
				EVnewbw=0.0
				EVnewbe=0.0 
			    DO i=1,dy ! tomorrow
					DO j=1,dr                        
						EVnewbw=invyr((i-1)*dr+j)*Vynext(:,i,j)+EVnewbw
				        EVnewbe(:,j)=invy(i)*Vynext(:,i,j)+EVnewbe(:,j)
				   END DO
				END DO

				!loop for OLD WORKER
				DO i=1,da ! today's assets
			      Vowtemp=uconsold(i,:)+bet*pold*Vownext+eta*bet*(1.0-pold)*EVnewbw
			       imax=MAXLOC(Vowtemp)
			       newVow(i)=Vowtemp(imax(1))
			       apolowT(i,Ttime)=imax(1)
			    END DO  
          
				! loop for old entrepreneur
				! entrepreneur staying entrepreneur
				DO i=1,da       !today's assets
					DO j=1,dr   ! today's r
						DO jj=1,da  ! tomorrow's a'
							Voeetemp(:,jj)=uconsolde(i,jj,j,:)+&
								&   bet*pold*DOT_PRODUCT(Voenext(jj,:),Pr(j,:))+&
				                &   eta*bet*(1.0-pold)*DOT_PRODUCT(EVnewbe(jj,:),Pr(j,:))
					            ! impose kohat
							IF (kohat(i,j).LT.dk) THEN
						        !** when cannot borrow (kohat=last at which one can borrow)
								Voeetemp(kohat(i,j)+1:,jj)=penalty
							END IF
						END DO    
						imaxmat=MAXLOC(Voeetemp)
						Voee(i,j)=Voeetemp(imaxmat(1),imaxmat(2))						  
						IF (Voee(i,j).GT.newVow(i)) THEN
							newVoe(i,j)=Voee(i,j)
							apoloeT(i,j,Ttime)=imaxmat(2)
							kpoloeT(i,j,Ttime)=imaxmat(1)
						ELSE
						   newVoe(i,j)=newVow(i)
						   apoloeT(i,j,Ttime)=apolowT(i,Ttime)
						   kpoloeT(i,j,Ttime)=-1              							
						END IF
						! get optimal policy for labor demand
						IF (kpoloeT(i,j,Ttime) .ne. -1) then
							labdemand=front1*r(j)**(-term1)*k(kpoloeT(i,j,Ttime))**(-alphe*ni*term1)
						    labpoloeT(i,j,Ttime)=max(0.0,labdemand-1.0)           
						ELSE
							labpoloeT(i,j,Ttime)=0.0
						ENDIF
					END DO ! j, today's r
				END DO ! i, today's assets
			              
				EVy=0.0
				DO i=1,dy                   !today
					DO j=1,dr
						DO i2=1,dy          !tomorrow
							DO j2=1,dr
								EVy(:,i,j)=Pyr((i-1)*dr+j,(i2-1)*dr+j2)*&
								& Vynext(:,i2,j2)+EVy(:,i,j)
							END DO
						END DO
					END DO
				END DO

				!val fn for young that is a worker for the period   
				DO i=1,da ! today
					DO j=1,dy ! today's y                       
						DO jj=1,dr ! todays' r
							Vywtemp=uconsw(i,:,j)+bet*pyou*EVy(:,j,jj)+&
								&   bet*(1.0-pyou)*Vownext
							imax=MAXLOC(Vywtemp)
							newVyw(i,j,jj)=Vywtemp(imax(1))
							apolyw(i,j,jj)=imax(1)
						END DO
					END DO
				END DO
                
				! NOTE THAT THE ** YOUNG** GUYS WITH ZERO ENTR ABILITY
				! ALWAYS CHOOSE TO BE WORKERS, BECAUSE THIS WAY THEY GET
				! THE WAGE. LET'S EXPLOIT THIS
				! val fn for young that is a ENTR for the period    
				! LET US COMPUTE IT ONLY FOR GUYS WITH POSITIVE R
				! young entrepreneur decisions
				DO i=1,da       !today's assets
					DO j=2,dr   ! today's r ! changed from dy=1,dr
						DO j1=1,dy  !today's y
							DO jj=1,da  ! tomorrow's a'
								Vyetemp(:,jj)=uconse(i,jj,j-1,:)+ &
						            &   bet*pyou*EVy(jj,j1,j)+ &
							        &   bet*(1.0-pyou)*DOT_PRODUCT(Voenext(jj,:),Pr(j,:))   
							        ! impose kyhat
								 IF (kyhat(i,j1,j).LT.dk) THEN
									Vyetemp(1+kyhat(i,j1,j):,jj)=penalty
								END IF                  
							END DO
							imaxmat=MAXLOC(Vyetemp)
							newVye(i,j1,j)=Vyetemp(imaxmat(1),imaxmat(2))
							apolye(i,j1,j)=imaxmat(2)
							kpolye(i,j1,j)=imaxmat(1)
                            
							! YOUNG decide if e or w
						   IF (newVye(i,j1,j).GT.newVyw(i,j1,j)) THEN  
								newVy(i,j1,j)=newVye(i,j1,j)
						       apolyT(i,j1,j,Ttime)=apolye(i,j1,j)
						       kpolyT(i,j1,j,Ttime)=kpolye(i,j1,j)
						   ELSE
						       newVy(i,j1,j)=newVyw(i,j1,j)
						       apolyT(i,j1,j,Ttime)=apolyw(i,j1,j)
						       kpolyT(i,j1,j,Ttime)=-1          
						    END IF
							! get optimal policy for labor demand                            
							IF (kpolyT(i,j1,j,Ttime) .ne. -1) then
								labdemand=front1*r(j)**(-term1)*k(kpolyT(i,j1,j,Ttime))**(-alphe*ni*term1)
								labpolyT(i,j1,j,Ttime)=max(0.0,labdemand-1.0)           
							ELSE
								labpolyT(i,j1,j,Ttime)=0.0
							ENDIF
						END DO !j1=1,dy  !today's y
					END DO
				END DO

				! now use the fact that YOUNG guys with r=0 always choose
				! to be workers
				newVye(:,:,1)=newVyw(:,:,1)
				apolye(:,:,1)=apolyw(:,:,1)
				kpolye(:,:,1)=-1
				newVy(:,:,1)=newVyw(:,:,1)
				apolyT(:,:,1,Ttime)=apolyw(:,:,1)
				kpolyT(:,:,1,Ttime)=-1   
				labpolyT(:,:,1,Ttime)=0.0     
	
				Vow=newVow ! update current t period val fun for endo bcs, taking t+1 val fun as given
				Voe=newVoe
				Vyw=newVyw
				Vye=newVye
				Vy=newVy
		
				IF (switchbc==2) THEN ! both young and old endo bc
					! now check temptation to run with borrowed money
					! value function of the OLD WORKER STARTING OFF AFTER DEFAULT 
					! (with assets k*eff)
            
					CALL interplin(da,a,Vow,dk,eff*k,Vokeff)            			
					DO i=1,da
						DO j=2,dr
							count1=1
							count2=1
							DO WHILE (count1.GT.0)
								IF (Voe(i,j).LT.Vokeff(count2)) THEN
									newkohat(i,j)=count2-1
									count1=0
								END IF
								count2=count2+1
								IF (count2==(dk+1)) THEN 
									newkohat(i,j)=dk
									count1=0
								END IF
							END DO
						END DO
					END DO
					! impose no borrowing for people with r=0, which we know would be true
					newkohat(:,1)=0
					epsihato=MAXVAL(ABS(newkohat-kohat))
					WRITE (*,*) "MAXVAL(newkohat-kohat)",MAXVAL(newkohat-kohat)
					kohat=newkohat

					! value function of the young worker starting off after default 
					! (with assets k*eff)
					DO j1=1,dy
						DO j=1,dr                   
							CALL interplin(da,a,Vyw(:,j1,j),dk,eff*k,Vwkeff(:,j1,j))
						END DO
					END DO
					DO i=1,da
						DO j1=1,dy
							DO j=2,dr
								count1=1
								count2=1
								DO WHILE (count1.GT.0)
									IF (Vye(i,j1,j).LT.Vwkeff(count2,j1,j)) THEN
										newkyhat(i,j1,j)=count2-1
										count1=0
									END IF
									count2=count2+1
									IF (count2==(dk+1)) THEN 
										newkyhat(i,j1,j)=dk
										count1=0
									END IF
								END DO      
							END DO
						END DO
					END DO
					! impose no borrowing for people with r=0, which we know would be true
					newkyhat(:,:,1)=0
					epsihaty=MAXVAL(ABS(newkyhat-kyhat))
					WRITE (*,*) "MAXVAL(newkyhat-kyhat)",MAXVAL(newkyhat-kyhat)
					kyhat=newkyhat
					epsihat=epsihato+epsihaty
					WRITE (*,*) "iterakhat",iterakhat," epsihato",epsihato," epsihaty",epsihaty
					iterakhat=iterakhat+1
				END IF	! IF (switchbc==2) THEN ! both young and old endo bc
			
				IF (switchbc==1) THEN ! old ONLY
					! now check temptation to run with borrowed money
					! value function of the OLD WORKER STARTING OFF AFTER DEFAULT 
					! (with assets k*eff)
					CALL interplin(da,a,Vow,dk,eff*k,Vokeff)            			
					DO i=1,da
						DO j=2,dr
							count1=1
							count2=1
							DO WHILE (count1.GT.0)
								IF (Voe(i,j).LT.Vokeff(count2)) THEN
									newkohat(i,j)=count2-1
									count1=0
								END IF
								count2=count2+1
								IF (count2==(dk+1)) THEN 
									newkohat(i,j)=dk
									count1=0
								END IF
							END DO
						END DO
					END DO
					! impose no borrowing for people with r=0, which we know would be true
					newkohat(:,1)=0
					epsihato=MAXVAL(ABS(newkohat-kohat))
					WRITE (*,*) "MAXVAL(newkohat-kohat)",MAXVAL(newkohat-kohat)
					kohat=newkohat

					newkyhat(:,:,1)=0
					epsihaty=0
					epsihat=epsihato+epsihaty
					WRITE (*,*) "iterakhat",iterakhat," epsihato",epsihato
					iterakhat=iterakhat+1
				END IF	! IF (switchbc==1) THEN ! old ONLY
				IF (switchbc==0) THEN ! exo FOR ALL
					epsihat=0
				END IF							
			END DO ! DO WHILE(countkhat)
			Vownext=newVow ! iterate vfs over time: for t, take t+1 val fun as given
			Voenext=newVoe
			Vynext=newVy	
			
			! SAVE VALUE FUNCTIONS FOR WELFARE COMPARISON WITH INITIAL ss
			! IT IS THE ONE FOR Ttime=2
			IF (Ttime==2) THEN 
				CALL printvalfunT2()
			END IF
		END DO ! DO Ttime=Tfinal,2 this is the backward loop 
		! ***************************************************************************
		! computed value funs and pol funs starting from FINAL SS				
		! ***************************************************************************
		! init
		taxeslesstransfT=0.0

		govdebtT=0.0
		govdebtT(1)=govdebt1ss
		govdebtT(Ttrans)=govdebt2ss
		govprimsurpT=0.0
		govprimsurpT(Ttrans)=rbarpath(Ttrans)*govdebt2ss
		gpublicT=0.0
		gpublicT(1)=gfrac*gdpT(1)


		! ********************************************************************************
		! go forward in time from initial SS, compute time path of aggregates and govt bc
		! ********************************************************************************
		invm=invm1ss ! every time we change tau, we need to restart from initial ss


		DO Ttime=2,Ttrans-1 			
			rbar=rbarpath(Ttime)
			wage=wagepath(Ttime)
			transf=replrate*wage*DOT_PRODUCT(y,invy)			
			! define useful constants
			term1=1.0/((1.0-alphe)*ni-1.0)
			front1=(wage/(ni*(1.0-alphe)))**term1	

			IF (usetax2balance==0) THEN
				taubal=taubalpath(Ttime)	
			ELSE
				tauc=taucpath(Ttime) 
			END IF
			
			IF (dorloop==0) THEN  ! if fixed prices, no need to compute invm after T1+T2
				Tfinal=T1+T2
			ELSE
				Tfinal=Ttransold
			END IF
			
			IF (Ttime.LE.Tfinal) THEN			   		
				! constructing the TRANSITION MATRIX in sparse form
				! sparse=row indices, col indices, values			 
				! order of the transition matrix:
				! y workers-        r - y - assets
				! y entrepreneurs-  r - y - assets
				! old entr          r -     assets
				! old                       assets
				!
				rowM=0
				colM=0
				valM=0.0
				counter=nonzero-(da*(dy*dr+1))+1    ! number of elements for the old
				!block transition oldw - ?
				DO i=1,da               !asset today
					crow=sizeM-da+i     !row of M
					!if reborn
					DO ll=1,dr          ! r tomorrow
						DO jj=1,dy      ! y tomorrow
							rowM(counter)=crow
							colM(counter)=(ll-1)*dy*da+(jj-1)*da+apolowT(i,Ttime)
							valM(counter)=invyr((jj-1)*dr+ll)*(1.0-pold)
							counter=counter+1
						END DO
					END DO
					! if remains old
					rowM(counter)=crow
					colM(counter)=2*nyoung+noe+apolowT(i,Ttime)
					valM(counter)=pold
					counter=counter+1
				END DO
		
				!block transition old entr - ?
				counter=2*(dy*dr+dr+1)*nyoung+1
				DO l=1,dr       ! r today
					DO i=1,da   ! a today
						crow=2*nyoung+(l-1)*da+i
						! if reborn
						DO ll=1,dr ! r', the one the children inherit
							DO jj=1,dy  ! child's y, drawn from invariant distr
								rowM(counter)=crow
								! if remain entr, this is col
								colM(counter)=(ll-1)*dy*da+(jj-1)*da+apoloeT(i,l,Ttime)
								! if become work, add some elements to col
								IF  (kpoloeT(i,l,Ttime).GT.0) THEN
									colM(counter)=colM(counter)+nyoung
								END IF
								valM(counter)=(1.0-pold)*invy(jj)*Pr(l,ll)
								counter=counter+1
							END DO
						END DO
						! if remains old
						IF  (kpoloeT(i,l,Ttime)==-1) THEN  ! becomes worker
							rowM(counter)=crow
							colM(counter)=2*nyoung+noe+apoloeT(i,l,Ttime)
							valM(counter)=pold
							counter=counter+1
							DO ll=1,dr
								rowM(counter)=crow
								colM(counter)=2*nyoung+(ll-1)*da+apoloeT(i,l,Ttime)
								valM(counter)=0.0
								counter=counter+1
							END DO
						ELSE                    ! remains entrepreneur
							rowM(counter)=crow
							colM(counter)=2*nyoung+noe+apoloeT(i,l,Ttime)
							valM(counter)=0.0
							counter=counter+1
							DO ll=1,dr
								rowM(counter)=crow
								colM(counter)=2*nyoung+(ll-1)*da+apoloeT(i,l,Ttime)
								valM(counter)=Pr(l,ll)*pold
								counter=counter+1
							END DO
						END IF      
					END DO
				END DO

				!block transition young work - ?        
				counter=1
				DO l=1,dr   !today
					DO j=1,dy   !today
						DO i=1,da   !today
							crow=(l-1)*da*dy+(j-1)*da+i
							!   if next period remains young
							DO ll=1,dr ! tomorrow
								DO jj=1,dy
									rowM(counter)=crow
									! if remain work, this is col
									colM(counter)=(ll-1)*dy*da+(jj-1)*da+apolyT(i,j,l,Ttime)
									! CALL checkcolM(1)
									! if become entr, add some elements to col
									IF  (kpolyT(i,j,l,Ttime).GT.0) THEN
										colM(counter)=colM(counter)+nyoung								
									END IF
									valM(counter)=pyou*Pyr((j-1)*dr+l,(jj-1)*dr+ll)
									counter=counter+1
								END DO
							END DO
							!   if next period becomes old
							IF  (kpolyT(i,j,l,Ttime)==-1) THEN ! if remains worker
								rowM(counter)=crow
								colM(counter)=2*nyoung+noe+apolyT(i,j,l,Ttime)
							    valM(counter)=(1-pyou)
								counter=counter+1
								DO ll=1,dr
									rowM(counter)=crow
									colM(counter)=2*nyoung+(ll-1)*da+apolyT(i,j,l,Ttime)
						           valM(counter)=0.0
									counter=counter+1
								END DO
							ELSE                               ! if becomes entr
								rowM(counter)=crow
								colM(counter)=2*nyoung+noe+apolyT(i,j,l,Ttime)
							  valM(counter)=0.0
								counter=counter+1
								DO ll=1,dr
									rowM(counter)=crow                          
									colM(counter)=2*nyoung+(ll-1)*da+apolyT(i,j,l,Ttime)
								    valM(counter)=Pr(l,ll)*(1-pyou)
									counter=counter+1
								END DO
							END IF  
						END DO
					END DO
				END DO

				!block young entr - ?
				IF (counter.NE.nyoung*(dy*dr+dr+1)+1) WRITE(*,*) "counter does not match!!"
					DO l=1,dr   !today
						DO j=1,dy   !today
							DO i=1,da   !today
								crow=nyoung+(l-1)*da*dy+(j-1)*da+i
								!   if next period remains young
								DO ll=1,dr
									DO jj=1,dy
										rowM(counter)=crow
										! if becomes work, this is col                          
										colM(counter)=(ll-1)*dy*da+(jj-1)*da+apolyT(i,j,l,Ttime)
										! if become entr, add some elements to col                          
										IF  (kpolyT(i,j,l,Ttime).GT.0) THEN
											colM(counter)=colM(counter)+nyoung
										END IF
										valM(counter)=pyou*Pyr((j-1)*dr+l,(jj-1)*dr+ll)
										counter=counter+1
									END DO
								END DO
								!   if next period becomes old                  
								IF  (kpolyT(i,j,l,Ttime)==-1) THEN ! if becomes worker
									rowM(counter)=crow                      
									colM(counter)=2*nyoung+noe+apolyT(i,j,l,Ttime)
									valM(counter)=(1-pyou)
									counter=counter+1
									DO ll=1,dr
										rowM(counter)=crow                      
										colM(counter)=2*nyoung+(ll-1)*da+apolyT(i,j,l,Ttime)
										valM(counter)=0.0
										counter=counter+1
									END DO
								ELSE                               ! if becomes entr
									rowM(counter)=crow                  
									colM(counter)=2*nyoung+noe+apolyT(i,j,l,Ttime)
									valM(counter)=0.0
									counter=counter+1
									DO ll=1,dr
										rowM(counter)=crow                          
										colM(counter)=2*nyoung+(ll-1)*da+apolyT(i,j,l,Ttime)
										valM(counter)=Pr(l,ll)*(1-pyou)
										counter=counter+1
									END DO
								END IF  
						END DO
					END DO
				END DO
			END IF ! IF (Ttime.LE.Tfinal) THEN ! transition M is same after T1+T2
			! only if prices are exogenous: in that case, polfun do not change
		
			!   compute next period's distribution
			epsinvm=MAXVAL(ABS(invm-invm1))
			invm1=invm		
			invm=0.0
			! this do loop is the product M'*invm, M sparse
		    ! to transpose M, we simply use colM instead of rowM
			! invm= new inv distr
            ! invm1= old inv distr		
			DO i=1,nonzero
				invm(colM(i))=invm(colM(i))+invm1(rowM(i))*valM(i)
			END DO
			invm=invm/sum(invm)
			WRITE (*,*) "DISTR COMPUTED for Ttime=", Ttime

			!invariant distribution of a on young workers
			prgridyw=0.0
			DO i2=1,dy*dr
				prgridyw=prgridyw+invm((i2-1)*da+1:i2*da)
			END DO
			!invariant distribution of a on young entr
			prgridye=0.0
			DO i2=1,dy*dr
				prgridye=prgridye+invm(nyoung+(i2-1)*da+1:nyoung+i2*da)
			END DO                                                          
			!invariant distribution of a on old entr
			prgridoe=0.0
			DO i2=1,dr
				prgridoe=prgridoe+invm(2*nyoung+(i2-1)*da+1:2*nyoung+i2*da)
			END DO
			! compute total number of entr (which should also be a fraction,
			! since we normalized total population to be 1)
			totentr=SUM(prgridye)+SUM(prgridoe)
			! compute number of workers (young NE) 
			totL=SUM(prgridyw)
			! compute number of retirees 
			totret=1-totentr-totL
			!invariant distribution of a on old workers
			prgridow=invm(nstates-da+1:)
			!total invariant distr
			prgrid=prgridyw+prgridye+prgridoe+prgridow

			invlevk=0.0 ! k level ...
			invrk=0.0   ! return corresp. to each element of invm (except old work)
			invlabe=0.0 ! outside labor demand to invm
			invtotlabe=0.0 ! tot. labor demand to invm
			toteffL=0.0    ! tot. eff. units (.neq.totL bcs entr choice depends on y).
			counter=1
			DO l=1,dr   ! young workers
				invrk((l-1)*da*dy+1:l*da*dy)=r(l)
				DO j=1,dy
					DO i=1,da               
						IF (kpolyT(i,j,l,Ttime).GT.0) THEN
							invlevk(counter)=k(kpolyT(i,j,l,Ttime))
						    invlabe(counter)=labpolyT(i,j,l,Ttime)
							invtotlabe(counter)=1.0+invlabe(counter) !!! Check                     
						ELSE
							toteffL=toteffL+y(j)*invm((l-1)*da*dy+(j-1)*da+i)
						END IF
						counter=counter+1
					END DO
				END DO
			END DO  
			DO l=1,dr   ! young entrepreneurs
				invrk(nyoung+(l-1)*da*dy+1:nyoung+l*da*dy)=r(l)
				DO j=1,dy
					DO i=1,da
						IF (kpolyT(i,j,l,Ttime).GT.0) THEN
							invlevk(counter)=k(kpolyT(i,j,l,Ttime))
							invlabe(counter)=labpolyT(i,j,l,Ttime)
							invtotlabe(counter)=1.0+invlabe(counter) ! check
						ELSE                        
							toteffL=toteffL+y(j)*invm(nyoung+(l-1)*da*dy+(j-1)*da+i)
						END IF
						counter=counter+1
					END DO
				END DO
			END DO
			DO l=1,dr   !   old entrepreneurs
				invrk(2*nyoung+(l-1)*da+1:2*nyoung+l*da)=r(l)
				DO i=1,da
					IF (kpoloeT(i,l,Ttime).GT.0) THEN
						invlevk(counter)=k(kpoloeT(i,l,Ttime))
						invlabe(counter)=labpoloeT(i,l,Ttime)
						invtotlabe(counter)=1.0+invlabe(counter)                   
					END IF
					counter=counter+1
				END DO
			END DO
			! capital and effective outside labor EMPLOYED by entr
			totkT(Ttime)=DOT_PRODUCT(invlevk,invm(:nstates-da))
			
			hiredlabe=DOT_PRODUCT(invlabe,invm(:nstates-da))
		                         
			invrky=invrk(:2*nyoung)
			invrko=invrk(2*nyoung+1:nstates-da)
			invlevky=invlevk(:2*nyoung)
			invlevko=invlevk(2*nyoung+1:nstates-da)
			invtotlabye=invtotlabe(:2*nyoung)
			invtotlaboe=invtotlabe(2*nyoung+1:nstates-da)
			invmy=invm(:2*nyoung)
			invmo=invm(2*nyoung+1:nstates-da)
			! GROSS entr. output
			! note inck includes wages paid  interest owed and depr. check
			incky=DOT_PRODUCT(invrky*(invlevky**alphe*invtotlabye**(1.0-alphe))**ni,invmy)
			incko=DOT_PRODUCT(invrko*(invlevko**alphe*invtotlaboe**(1.0-alphe))**ni,invmo)
			inckT(Ttime)=incky+incko
			
			totaT(Ttime)=DOT_PRODUCT(a,prgrid)
			totayw=DOT_PRODUCT(a,prgridyw)
			totaye=DOT_PRODUCT(a,prgridye)
			totaow=DOT_PRODUCT(a,prgridow)
			totaoe=DOT_PRODUCT(a,prgridoe)       
		
			! check need to check positivity
			totlcorpT(Ttime)=toteffL-hiredlabe  ! total effective labor in corporate sector
			IF (totlcorpT(Ttime) .LE. 0.0) THEN 
				WRITE(*,*) 'totlcorpT(Ttime)', totlcorpT(Ttime)  
				WRITE(*,*) 'LABOR IN CORP SECTOR IS NEGATIVE'
				STOP
			END IF
					
			!************************
			!   compute tax revenues
			vectaxcw=0.0
			vectaxce=0.0
			vectaxl=0.0
			vectaxe=0.0
			!compute average income workers
			counter=1
			DO l=1,dr   ! young workers
				rhere=r(l)
				DO j=1,dy
					DO i=1,da
						ahere=a(apolyT(i,j,l,Ttime))                   
						IF (kpolyT(i,j,l,Ttime).GT.0) THEN
							khere=k(kpolyT(i,j,l,Ttime))
							lhere=labpolyT(i,j,l,Ttime)
							entinchere=rhere*(khere**alphe*(1.0+lhere)**(1.0-alphe))**ni-delt*khere-rbar*(khere-a(i))-wage*lhere
							vectaxe(counter)=(btaxe-btaxe*(staxe*entinchere**ptaxe+1) &
							&   **(-1/ptaxe))*entinchere+taubal*entinchere                          
							vectaxce(counter)=tauc*(entinchere-vectaxe(counter) &
							& +a(i)-ahere)/(1+tauc)						
						ELSE                        
							winchere=wage*y(j)+rbar*a(i)
							vectaxl(counter)=(btaxw-btaxw*(staxw*winchere**ptaxw+1)**(-1/ptaxw))&
							&   *winchere+taubal*winchere						
							vectaxcw(counter)=tauc*((1+rbar)*a(i)+wage*y(j) &
							&   -vectaxl(counter)-ahere)/(1+tauc)
						END IF
						counter=counter+1
					END DO
				END DO
			END DO
				
			DO l=1,dr   ! young entrepreneurs
				rhere=r(l)
				DO j=1,dy
					DO i=1,da
						ahere=a(apolyT(i,j,l,Ttime))           
						IF (kpolyT(i,j,l,Ttime).GT.0) THEN
							khere=k(kpolyT(i,j,l,Ttime))
							lhere=labpolyT(i,j,l,Ttime)
							entinchere=rhere*(khere**alphe*(1.0+lhere)**(1.0-alphe))**ni-delt*khere-rbar*(khere-a(i))-wage*lhere				    			        
							vectaxe(counter)=(btaxe-btaxe*(staxe*entinchere**ptaxe+1) &
							&   **(-1/ptaxe))*entinchere+taubal*entinchere                          
							vectaxce(counter)=tauc*(entinchere-vectaxe(counter) &
							& +a(i)-ahere)/(1+tauc)											
						ELSE
							winchere=wage*y(j)+rbar*a(i)
							vectaxl(counter)=(btaxw-btaxw*(staxw*winchere**ptaxw+1)**(-1/ptaxw))&
							&   *winchere+taubal*winchere	                    
							vectaxcw(counter)=tauc*((1+rbar)*a(i)+wage*y(j) &
							&   -vectaxl(counter)-ahere)/(1+tauc)
						END IF
						counter=counter+1
					END DO
				END DO
			END DO
			DO l=1,dr   !   old entrepreneurs
				rhere=r(l)
				DO i=1,da
					ahere=a(apoloeT(i,l,Ttime))        
					IF (kpoloeT(i,l,Ttime).GT.0) THEN
						khere=k(kpoloeT(i,l,Ttime))
						lhere=labpoloeT(i,l,Ttime)
						entinchere=rhere*(khere**alphe*(1.0+lhere)**(1.0-alphe))**ni-delt*khere-rbar*(khere-a(i))-wage*lhere
						vectaxe(counter)=(btaxe-btaxe*(staxe*entinchere**ptaxe+1) &
						&   **(-1/ptaxe))*entinchere+taubal*entinchere                          
						vectaxce(counter)=tauc*(entinchere-vectaxe(counter) &
						& +a(i)-ahere)/(1+tauc)
					ELSE
						winchere=transf+rbar*a(i)
						vectaxl(counter)=(btaxw-btaxw*(staxw*winchere**ptaxw+1)**(-1/ptaxw))*winchere &
						& +taubal*winchere					
						vectaxcw(counter)=tauc*(a(i)*(1+rbar)+transf-ahere-&
						& vectaxl(counter))/(1+tauc)
					END IF
					counter=counter+1
				END DO
			END DO
		
			DO i=1,da  !    old retirees
				ahere=a(apolowT(i,Ttime))
				winchere=transf+rbar*a(i)
				vectaxl(counter)=(btaxw-btaxw*(staxw*winchere**ptaxw+1)**(-1/ptaxw))*winchere &
					& +taubal*winchere
				vectaxcw(counter)=tauc*(a(i)*(1+rbar)+transf-ahere- &
				&   vectaxl(counter))/(1+tauc)
				counter=counter+1
			END DO
			tottaxl=DOT_PRODUCT(invm,vectaxl)
			tottaxe=DOT_PRODUCT(invm,vectaxe)
			tottaxcw=DOT_PRODUCT(invm,vectaxcw)
			tottaxce=DOT_PRODUCT(invm,vectaxce)
			
			taxeslesstransfT(Ttime)=tottaxl+tottaxe+tottaxcw+tottaxce-transf*(totret-SUM(prgridoe))							

			! govdebt constant as a ratio to previous totkcorp
			govdebtT(Ttime)=debtfrac*(totkT(Ttime-1)+totkcorpT(Ttime-1))
			totkcorpT(Ttime)=totaT(Ttime)-totkT(Ttime)-govdebtT(Ttime)
			!this is a different timing, in line with what done in previous entrtrans10 file
			govprimsurpT(Ttime)=(1+rbarpath(Ttime))*govdebtT(Ttime-1)-govdebtT(Ttime)
			gpublicT(Ttime)=taxeslesstransfT(Ttime)-govprimsurpT(Ttime)
			
			rimpliedT(Ttime)=abig*alph*(totkcorpT(Ttime)/totlcorpT(Ttime))**(alph-1)-delt ! change toteffL to totlcorp                
			wageimpliedT(Ttime)=abig*(1-alph)*((rimpliedT(Ttime)+delt)/(abig*alph))**(alph/(alph-1))
        
			!using wage and rbar, not implied. Gross of depreciation
			gdpT(Ttime)=wage*totlcorpT(Ttime)+(rbar+delt)*totkcorpT(Ttime)+inckT(Ttime) ! change toteffL to totlcorp   			
			k2gdp=(totkT(Ttime)+totkcorpT(Ttime))/gdpT(Ttime)			

			fname="checkgovdebt"
			OPEN (unit=32,file=fname,status="OLD", &
			&       action="write",position="append",iostat=OpenStatus)
			WRITE (unit=32, fmt=*) "Ttime=", Ttime
			WRITE (unit=32, fmt=*) "govdebtT(Ttime)=", govdebtT(Ttime), "govdebtT(Ttime)=", govdebtT(Ttime)
			WRITE (unit=32, fmt=*) "rbarpath(Ttime)=", rbarpath(Ttime)
			WRITE (unit=32, fmt=*) "govprimsurpT(Ttime)", govprimsurpT(Ttime)
			WRITE (unit=32, fmt=*) "-----------------------------------------------------------"
			CLOSE (unit=32)	
		
		! *********************************************************************
		END DO ! forward in time from first SS to compute time path of aggregates
			   ! DO Ttime=2,Tfinal 
		! *********************************************************************
	


		! compute present value of govt inbalance
		! check index in rbars
		
		Pvprimgovsurp=0.0
		invprodrbar=1.0
		DO i=2,Ttrans-1
			invprodrbar=invprodrbar/(1+rbarpath(i))
            PVprimgovsurp=PVprimgovsurp+govprimsurpT(i)*invprodrbar
		END DO
					
		! if govbalPV is positive, must raise taucdj
		govbalPV=govdebt1ss-govdebt2ss*invprodrbar-PVprimgovsurp
		
		! just to give an order of magnitude about what we iterate on
		epsigov=abs(govbalPV/gdpT(1))
		

		
		epsigov=epsigovmin/2.0


		fname="output"
		OPEN (unit=32,file=fname,status="OLD", &
		&       action="write",position="append",iostat=OpenStatus)
		IF (epsigov.LT.epsigovmin) THEN	
			WRITE (unit=32,fmt=*) "reached convergence for GOVT BC"
		END IF
		WRITE (unit=32, fmt=*) "**************************************"
		WRITE (unit=32, fmt=*) "-----------------TAXES----------------"
		WRITE (unit=32, fmt=*) "Iteragovbal", iteragovbal
		WRITE (unit=32, fmt=*) "taubal1ss", taubal1ss
		WRITE (unit=32, fmt=*) "taubal2ss", taubal2ss
		WRITE (unit=32, fmt=*) "taubalintep", taubalinterp
		WRITE (unit=32, fmt=*) "taubaladj", taubaladj
		WRITE (unit=32, fmt=*) "taubaladjmin", taubaladjmin
		WRITE (unit=32, fmt=*) "taubaladjmax", taubaladjmax		
		WRITE (unit=32, fmt=*) "taubalpath(1:T1+T2)", taubalpath(1:T1+T2)
		WRITE (unit=32, fmt=*) "tauc1ss", tauc1ss
		WRITE (unit=32, fmt=*) "tauc2ss", tauc2ss
		WRITE (unit=32, fmt=*) "taucinterp", taucinterp
		WRITE (unit=32, fmt=*) "taucadjmin", taucadjmin
		WRITE (unit=32, fmt=*) "taucadjmax", taucadjmax
		WRITE (unit=32, fmt=*) "taucadj", taucadj
		WRITE (unit=32, fmt=*) "taucpath(1:T1+T2)", taucpath(1:T1+T2)						
		WRITE (unit=32, fmt=*) "epsigov", epsigov
		WRITE (unit=32, fmt=*) "govbalPV", govbalPV
		WRITE (unit=32, fmt=*) "govbalPVgdp=",govbalPV/gdpT(1) 
		WRITE (unit=32, fmt=*) "govbalPVmin", govbalPVmin
		WRITE (unit=32, fmt=*) "govbalPVmax", govbalPVmax			
		WRITE (unit=32, fmt=*) "govbalPV2gdpmin=",govbalPVmin/gdpT(1)," govbalPV2gdpmax=",govbalPVmax/gdpT(1)
		WRITE (unit=32, fmt=*) "tota", totaT(Ttime)
		WRITE (unit=32, fmt=*) "PVprimgovsurp", PVprimgovsurp
		WRITE (unit=32, fmt=*) "govprimsup", govprimsurpT(Ttime)
		WRITE (unit=32, fmt=*) "----------------PRICES----------------"
		WRITE (unit=32, fmt=*) "Iterar", iterar
		WRITE (unit=32, fmt=*) "epsir", epsir
		WRITE (unit=32, fmt=*) "rbarpath(1:T1+T2)", rbarpath(1:T1+T2)
		WRITE (unit=32, fmt=*) "***************************************"
		CLOSE (unit=32)			        
		
		fname="vectorsanddata"
		open (unit=32,file=fname,status="replace", &
	 	&       action="WRITE",position="rewind",iostat=OpenStatus)
		IF (OpenStatus.NE.0) THEN
			WRITE(*,*) 'problems opening ', fname
		END IF
		WRITE(unit=32,fmt=*) Ttrans
		WRITE(unit=32,fmt=*) govdebt1ss
		WRITE(unit=32,fmt=*) govdebt2ss 
		DO i=1,Ttrans
			WRITE(unit=32,fmt=*) taucpath(i)
		END DO
		DO i=1,Ttrans
			WRITE(unit=32,fmt=*) taubalpath(i)
		END DO
		DO i=1,Ttrans
			WRITE(unit=32,fmt=*) totaT(i)
		END DO
		DO i=1,Ttrans
			WRITE(unit=32,fmt=*) gdpT(i)
		END DO
		DO i=1,Ttrans
			WRITE(unit=32,fmt=*) govprimsurpT(i)
		END DO
		DO i=1,Ttrans
			WRITE(unit=32,fmt=*) wageimpliedT(i)
		END DO
		DO i=1,Ttrans
			WRITE(unit=32,fmt=*) rimpliedT(i)
		END DO
		WRITE(unit=32,fmt=*) PVprimgovsurp
		WRITE(unit=32,fmt=*) govbalPV
		WRITE(unit=32,fmt=*) govbalPVmin
		WRITE(unit=32,fmt=*) govbalPVmax
		WRITE(unit=32,fmt=*) taucadj
		WRITE(unit=32,fmt=*) taucadjmin
		WRITE(unit=32,fmt=*) taucadjmax
		WRITE(unit=32,fmt=*) taucinterp
		WRITE(unit=32,fmt=*) epsigov
		WRITE(unit=32,fmt=*) rbar 
		WRITE(unit=32,fmt=*) wage
		WRITE(unit=32,fmt=*) epsinvm
		WRITE(unit=32,fmt=*) nstates
		DO i=1,nstates
			WRITE(unit=32,fmt=*) invm(i)
		END DO
		DO i=1,Ttrans
			WRITE(unit=32,fmt=*) govdebtT(i)
		END DO
		DO i=1,Ttrans
			WRITE(unit=32,fmt=*) rbarpath(i)
		END DO
		DO i=1,Ttrans
			WRITE(unit=32,fmt=*) wagepath(i)
		END DO
		DO i=1,Ttrans
			WRITE(unit=32,fmt=*) totkT(i)
		END DO
		DO i=1,Ttrans
			WRITE(unit=32,fmt=*) totlcorpT(i)
		END DO
		DO i=1,Ttrans
			WRITE(unit=32,fmt=*) inckT(i)
		END DO
		CLOSE (unit=32)


		IF (epsigov>epsigovmin) THEN			
			! using bisection algorithm to update tau
			! start with a tax, figure out if min or max, add or subtract pertgov
			! could be the opposite sign, start bisection, if another min or max,
			! apply pertgov again until bracketing	
			! NOTE" when govPV>0, need to increase TAU
			IF (usetax2balance==1) THEN ! USE CONSUMPTION TAX TO BALANCE
				IF (bracketgov==1) THEN
					IF (govbalPV.GT.0.0) THEN
						havetaucmin=1 ! switch: note that we computed taucmin
						! in this case
           				govbalPVmin=govbalPV
           				taucadjmin=taucadj
           				taucadj=taucadj+pertgov
						WRITE(*,*) "	IN BRACKETGOV=1, GOVBALPV>0) TAUCADJ",taucadj
						bracketgov=2
					ELSE
						govbalPVmax=govbalPV
           				taucadjmax=taucadj
           				taucadj=taucadj-pertgov	
       					bracketgov=2
					END IF  					     
				ELSE IF (bracketgov==2) THEN ! distinguish btw bracketing and no bracketing
					IF ((govbalPV.GT.0.0).AND.(havetaucmin==1)) THEN ! then have two min						
						WRITE (*,*) "***************************"
						WRITE (*,*) "no bracketing for taucadj yet="
            			WRITE (*,*) "trying another taucadjmax"
						WRITE (*,*) "***************************"
            			fname="output"
            			OPEN (unit=32,file=fname,status="OLD", &
							&   action="write",position="append",iostat=OpenStatus)
 						WRITE (unit=32,fmt=*) "***************************"
						WRITE (unit=32,fmt=*) "no bracketing for taucadj yet="
						WRITE (unit=32,fmt=*) "trying another taucadjmax"
						WRITE (unit=32,fmt=*) "***************************"
						CLOSE (unit=32)
            			bracketgov=2 ! still looking for a taucmax
            			taucadjmin=taucadj
            			taucadj=taucadjmin+pertgov
						govbalPVmin=govbalPV
       				END IF ! for two mins
					IF ((govbalPV.LT.0.0).AND.(havetaucmin.NE.1)) THEN ! two max						
						WRITE (*,*) "***************************"
						WRITE (*,*) "no bracketing for taucadj yet="
            			WRITE (*,*) "trying another taucadjmin"
						WRITE (*,*) "***************************"
            			fname="output"
            			OPEN (unit=32,file=fname,status="OLD", &
							&   action="write",position="append",iostat=OpenStatus)
 						WRITE (unit=32,fmt=*) "***************************"
						WRITE (unit=32,fmt=*) "no bracketing for taucadj yet="
            			WRITE (unit=32,fmt=*) "trying another taucadjmin"
						WRITE (unit=32,fmt=*) "***************************"
						CLOSE (unit=32)
            			bracketgov=2 ! still looking for a taucmin
            			taucadjmax=taucadj
            			taucadj=taucadjmax-pertgov
						govbalPVmax=govbalPV
       				END IF ! for two maxes
					IF ((govbalPV.GT.0.0).AND.(havetaucmin.NE.1)) THEN !first max, now min
						taucadjmin=taucadj
		        		govbalPVmin=govbalPV
						bracketgov=3
						! compute new taucadj
						taucadj=taucadjmin-(taucadjmax-taucadjmin)*govbalPVmin/(govbalPVmax-govbalPVmin)
					END IF ! for max first, min then
					IF ((govbalPV.LT.0.0).AND.(havetaucmin==1)) THEN !first min, now max
						taucadjmax=taucadj
            			govbalPVmax=govbalPV
						bracketgov=3
						! compute new taucadj
						taucadj=taucadjmin-(taucadjmax-taucadjmin)*govbalPVmin/(govbalPVmax-govbalPVmin)
					END IF ! for max first, min then
				ELSE ! for bracketgov>2
					IF (govbalPV.GT.0.0) THEN ! just found ANOTHER min
						taucadjmin=taucadj
						govbalPVmin=govbalPV
						! compute new taucadj
						taucadj=taucadjmin-(taucadjmax-taucadjmin)*govbalPVmin/(govbalPVmax-govbalPVmin)
					END IF ! for min now
					IF (govbalPV.LT.0.0) THEN ! just found a new max
						taucadjmax=taucadj
						govbalPVmax=govbalPV
						! compute new taucadj
						taucadj=taucadjmin-(taucadjmax-taucadjmin)*govbalPVmin/(govbalPVmax-govbalPVmin)
					END IF ! for min now						
				END IF
				fname="savetaxstuff"
				OPEN (unit=32,file=fname,status="OLD", &
					&       action="write",position="append",iostat=OpenStatus)
				WRITE (unit=32, fmt=*) taucpath(T1), govbalPV, govbalPVmin, govbalPVmax 
				CLOSE (unit=32)
						
				WRITE(*,*) "tauc1ss", tauc1ss
				WRITE(*,*) "tauc2ss", tauc2ss
				WRITE(*,*) "taucintep", taucinterp	
				WRITE(*,*) "cacca1v", cacca1v
				WRITE(*,*) "cacca2v", cacca2v
				WRITE(*,*) "taucpath(1:T1+T2))", taucpath(1:T1+T2)	
							   												
				! determine tauc btw T=1, and Ttrans as interp. values, T1 is breakpoint
				!taucpath(T1)=taucinterp*(1+taucadj)

				!CALL interplin(2,(/1.0, REAL(T1)/),(/tauc1ss, taucinterp*(1+taucadj)/),T1-2,cacca1v,taucpath(2:T1-1))
    			!CALL interplin(2,(/REAL(T1), REAL(T1+T2)/),(/taucinterp*(1+taucadj), tauc2ss/),T2-1,cacca2v,taucpath(T1+1:T1+T2-1))	
				
				taucpath=tauc1ss

			END IF ! FOR BALANCING WITH CONSUMPTION TAX

			IF (usetax2balance==0) THEN ! USE labor TAX TO BALANCE
				IF (bracketgov==1) THEN
					IF (govbalPV.GT.0.0) THEN
						havetaubalmin=1 ! switch: note, we computed taubalmin
						! in this case
           				govbalPVmin=govbalPV
           				taubaladjmin=taubaladj
           				taubaladj=taubaladj+pertgov
						WRITE(*,*) "	IN BRACKETGOV=1, GOVBALPV>0) taubalADJ",taubaladj
						bracketgov=2
					ELSE
						govbalPVmax=govbalPV
           				taubaladjmax=taubaladj
           				taubaladj=taubaladj-pertgov	
       					bracketgov=2
					END IF  					     
				ELSE IF (bracketgov==2) THEN ! distinguish btw bracketing and no bracketing
					IF ((govbalPV.GT.0.0).AND.(havetaubalmin==1)) THEN ! then two min						
						WRITE (*,*) "***************************"
						WRITE (*,*) "no bracketing for taubaladj yet="
            			WRITE (*,*) "trying another taubaladjmax"
						WRITE (*,*) "***************************"
            			fname="output"
            			OPEN (unit=32,file=fname,status="OLD", &
							&   action="write",position="append",iostat=OpenStatus)
 						WRITE (unit=32,fmt=*) "***************************"
						WRITE (unit=32,fmt=*) "no bracketing for taubaladj yet="
						WRITE (unit=32,fmt=*) "trying another taubaladjmax"
						WRITE (unit=32,fmt=*) "***************************"
						CLOSE (unit=32)
            			bracketgov=2 ! still looking for a taubalmax
            			taubaladjmin=taubaladj
            			taubaladj=taubaladjmin+pertgov
						govbalPVmin=govbalPV
       				END IF ! for two mins
					IF ((govbalPV.LT.0.0).AND.(havetaubalmin.NE.1)) THEN ! then two max						
						WRITE (*,*) "***************************"
						WRITE (*,*) "no bracketing for taubaladj yet="
            			WRITE (*,*) "trying another taubaladjmin"
						WRITE (*,*) "***************************"
            			fname="output"
            			OPEN (unit=32,file=fname,status="OLD", &
							&   action="write",position="append",iostat=OpenStatus)
 						WRITE (unit=32,fmt=*) "***************************"
						WRITE (unit=32,fmt=*) "no bracketing for taubaladj yet="
            			WRITE (unit=32,fmt=*) "trying another taubaladjmin"
						WRITE (unit=32,fmt=*) "***************************"
						CLOSE (unit=32)
            			bracketgov=2 ! still looking for a taubalmin
            			taubaladjmax=taubaladj
            			taubaladj=taubaladjmax-pertgov
						govbalPVmax=govbalPV
       				END IF ! for two maxes
					IF ((govbalPV.GT.0.0).AND.(havetaubalmin.NE.1)) THEN ! first max, now min
						taubaladjmin=taubaladj
		        		govbalPVmin=govbalPV
						bracketgov=3
						! compute new taubaladj
						taubaladj=taubaladjmin-(taubaladjmax-taubaladjmin)*govbalPVmin/(govbalPVmax-govbalPVmin)
					END IF ! for max first, min then
					IF ((govbalPV.LT.0.0).AND.(havetaubalmin==1)) THEN ! first min, now max
						taubaladjmax=taubaladj
            			govbalPVmax=govbalPV
						bracketgov=3
						! compute new taubaladj
						taubaladj=taubaladjmin-(taubaladjmax-taubaladjmin)*govbalPVmin/(govbalPVmax-govbalPVmin)
					END IF ! for max first, min then
				ELSE ! for bracketgov>2
					IF (govbalPV.GT.0.0) THEN !we now just found ANOTHER min
						taubaladjmin=taubaladj
						govbalPVmin=govbalPV
						! compute new taubaladj
						taubaladj=taubaladjmin-(taubaladjmax-taubaladjmin)*govbalPVmin/(govbalPVmax-govbalPVmin)
					END IF ! for min now
					IF (govbalPV.LT.0.0) THEN !we just found a new max
						taubaladjmax=taubaladj
						govbalPVmax=govbalPV
						! compute new taubaladj
						taubaladj=taubaladjmin-(taubaladjmax-taubaladjmin)*govbalPVmin/(govbalPVmax-govbalPVmin)
					END IF ! for min now						
				END IF
				fname="savetaxstuff"
				OPEN (unit=32,file=fname,status="OLD", &
					&       action="write",position="append",iostat=OpenStatus)
				WRITE (unit=32, fmt=*) taubalpath(T1), govbalPV, govbalPVmin, govbalPVmax 
				CLOSE (unit=32)
						
				WRITE(*,*) "taubal1ss", taubal1ss
				WRITE(*,*) "taubal2ss", taubal2ss
				WRITE(*,*) "taubalintep", taubalinterp	
				WRITE(*,*) "cacca1v", cacca1v
				WRITE(*,*) "cacca2v", cacca2v
				WRITE(*,*) "taubalpath(1:T1+T2))", taubalpath(1:T1+T2)

				! determine taubal btw T=1, and Ttrans as interp values, T1 is breakpoint
				taubalpath(T1)=taubalinterp*(1+taubaladj)
				CALL interplin(2,(/1.0, REAL(T1)/),(/taubal1ss, taubalinterp*(1+taubaladj)/),T1-2,cacca1v,taubalpath(2:T1-1))
    			CALL interplin(2,(/REAL(T1), REAL(T1+T2)/),(/taubalinterp*(1+taubaladj), taubal2ss/),T2-1,cacca2v,taubalpath(T1+1:T1+T2-1))			
			END IF ! FOR BALANCING WITH LABOR TAX

			
		END IF !IF (epsigov>epsigovmin) THEN

		WRITE(*,*) "outside of forward t loop"
		WRITE(*,*) "taucpath(1:T1+T2)", taucpath(1:T1+T2)
		WRITE(*,*) "taubalpath(1:T1+T2)", taubalpath(1:T1+T2)
		!WRITE(*,*) "tota", totaT(Ttime-1)
		WRITE(*,*) "Ttime", Ttime
		WRITE(*,*) "PVprimgovsurp", PVprimgovsurp
		WRITE(*,*) "govprimsup", govprimsurpT(Ttime)
		WRITE(*,*) "taucadj", taucadj
		WRITE(*,*) "taucadjmin", taucadjmin
		WRITE(*,*) "taucadjmax", taucadjmax
		WRITE(*,*) "taucinterp", taucinterp
		WRITE(*,*) "taubaladj", taubaladj
		WRITE(*,*) "taubaladjmin", taubaladjmin
		WRITE(*,*) "taubaladjmax", taubaladjmax
		WRITE(*,*) "taubalinterp", taubalinterp	
		WRITE(*,*) "epsigov", epsigov
		WRITE(*,*) "govbalPV", govbalPV
		WRITE(*,*) "govbalPVmin", govbalPVmin
		WRITE(*,*) "govbalPVmax", govbalPVmax					

	END DO ! WHILE (EPSIGOV)
	
	! COMPUTE HERE ERROR IN RBARPATH

	epsir=0.0
	DO Ttime=1,Ttrans
		epsir=epsir+ABS(rimpliedT(Ttime)-rbarpath(Ttime))
	END DO
	epsir=epsir/Ttrans
	
	fname="vectorsanddata2"
	open (unit=32,file=fname,status="replace", &
	&       action="WRITE",position="rewind",iostat=OpenStatus)
	IF (OpenStatus.NE.0) THEN
		WRITE(*,*) 'problems opening ', fname
	END IF
	WRITE(unit=32,fmt=*) Ttrans
	WRITE(unit=32,fmt=*) govdebt1ss
	WRITE(unit=32,fmt=*) govdebt2ss 
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) taucpath(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) taubalpath(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) totaT(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) gdpT(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) govprimsurpT(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) wageimpliedT(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) rimpliedT(i)
	END DO
	WRITE(unit=32,fmt=*) PVprimgovsurp
	WRITE(unit=32,fmt=*) govbalPV
	WRITE(unit=32,fmt=*) govbalPVmin
	WRITE(unit=32,fmt=*) govbalPVmax
	WRITE(unit=32,fmt=*) taucadj
	WRITE(unit=32,fmt=*) taucadjmin
	WRITE(unit=32,fmt=*) taucadjmax
	WRITE(unit=32,fmt=*) taucinterp
	WRITE(unit=32,fmt=*) epsigov
	WRITE(unit=32,fmt=*) rbar 
	WRITE(unit=32,fmt=*) wage
	WRITE(unit=32,fmt=*) epsinvm
	WRITE(unit=32,fmt=*) nstates
	DO i=1,nstates
		WRITE(unit=32,fmt=*) invm(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) govdebtT(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) rbarpath(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) wagepath(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) totkT(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) totlcorpT(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) inckT(i)
	END DO
	WRITE(unit=32,fmt=*) epsir

	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) gpublicT(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) taxeslesstransfT(i)
	END DO

	CLOSE (unit=32)

	IF (dorloop==0) THEN
		epsir=epsirmin/2.0		
	ELSE  	
		! using relaxation algorithm to update price path
		! bisection algorithm	 
		IF (epsir>epsirmin) THEN 
			rbarpath(2:Ttransold-1)=weightoldprices*rbarpath(2:Ttransold-1)+ &
			& (1-weightoldprices)*rimpliedT(2:Ttransold-1)
		END IF				   
	END IF
			
	WRITE (*,*) "finished computing"
	iterar=iterar+1
END DO ! WHILE (EPSIR)


CONTAINS


SUBROUTINE printvalfunT2
fname="valfunT2"
! saving value functions
open (unit=32,file=fname,status="replace", &
&       action="WRITE",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) Vy(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) Vyw(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) Vye(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) Vow(i)
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) Voe(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) Voee(i,jj)
    END DO
END DO
CLOSE (unit=32)
END SUBROUTINE printvalfunT2



END PROGRAM entrtrans
!******************************************

SUBROUTINE linspace(xmin,xmax,npoints,lspace)
IMPLICIT NONE
REAL, INTENT(IN) :: xmin,xmax
INTEGER, INTENT(IN) :: npoints
REAL, DIMENSION(npoints), INTENT(OUT) :: lspace
INTEGER :: i
lspace=real( (/ (i,i=0,npoints-1) /) )/real(npoints-1)*(xmax-xmin)+xmin
END SUBROUTINE linspace

SUBROUTINE  interplin(l,x,y,n,z,v)
! interpolate, from values of the fn given as ordinates of
! input data points in an x-y plane and for a given set of
! x values (abscissas), the values of a single-valued fn y=f(x)
! input parameters are
!     l  = # of data points (2 or greater)
!     x  = array of dimension l storing the x values (abscissas)
!          of input data points (in ascending order)
!     y  = array of dimension l storing the y values (ordinates)
!          of input data points
!     n  = # of points at which interpolation of the y value (ordinate)
!          (ordinate) is needed (1 or greater)
!     z  = array of dimension n storing the x values (abscissas) of
!          desired points
! output parameter
!     v  = array of dimension n where the interpolated y values
!          (ordinates) are to be displayed
IMPLICIT NONE

INTEGER, INTENT(IN) :: l
INTEGER, INTENT(IN) :: n
REAL, DIMENSION(l), INTENT(IN) :: x
REAL, DIMENSION(l), INTENT(IN) :: y
REAL, DIMENSION(n), INTENT(IN) :: z
REAL, DIMENSION(n), INTENT(OUT) :: v

INTEGER :: i,ind
INTEGER, DIMENSION(1) :: k
REAL :: diff

DO i=1,n
    k=MAXLOC(-ABS(z(i)-x))
    ind=k(1)
    diff=z(i)-x(ind)
    IF (abs(diff)<1e-04) THEN
        v(i)=y(ind)
    ELSE
        IF (diff<0) THEN
            v(i)=y(ind-1)+(z(i)-x(ind-1))/(x(ind)-x(ind-1))&
                     & *(y(ind)-y(ind-1))
        ELSE
            v(i)=y(ind)+(z(i)-x(ind))/(x(ind+1)-x(ind))*(y(ind+1)-y(ind))
        END IF
    END IF
END DO ! DO i=1,n
END SUBROUTINE interplin

