% This files loads data and performs a few computations to prepare the
% graphs of the transition

savepolfun=0;

switchequalss=1; % =1 if the initial and final SS are the same
Ttransplot=35; % Number of periods to plot

% Average income measured in thousands of dollars (to undo the
% normalization to 1 in the code)
incdoll=45;

if switchequalss==1,
    load -ascii valfun;
    datavec=valfun; 
    clear valfun;
else,
    load -ascii valfunFINALSS;
    datavec=valfunFINALSS; 
    clear valfunFINALSS;
end;

% load and define data from fortran ascii file
% (including some parameters, various value functions and policy
% functions, and various measures of gross income)
da=datavec(1);
dy=datavec(2);
dr=datavec(3);
dk=datavec(4);
datavec=datavec(5:length(datavec));
a=datavec(1:da);
y=datavec(da+1:da+dy);
r=datavec(da+dy+1:da+dy+dr);
k=datavec(da+dy+dr+1:da+dy+dr+dk);
datavec=datavec(da+dy+dr+dk+1:length(datavec));
Vy=zeros(da,dy,dr);
for i=1:da,
	for j=1:dy,
		for jj=1:dr,
			Vy(i,j,jj)=datavec(jj+(j-1)*dr+(i-1)*dr*dy);
		end; % i
	end; % j0
end;% k
datavec=datavec(da*dr*dy+1:length(datavec));
Vyw=zeros(da,dy,dr);
for i=1:da,
	for j=1:dy,
		for jj=1:dr,
         Vyw(i,j,jj)=datavec(jj+(j-1)*dr+(i-1)*dr*dy);
      end; % i
   end; % j0
end;% k
datavec=datavec(da*dr*dy+1:length(datavec));
Vye=zeros(da,dy,dr);
for i=1:da,
	for j=1:dy,
		for jj=1:dr,
         Vye(i,j,jj)=datavec(jj+(j-1)*dr+(i-1)*dr*dy);
      end; % i
   end; % j0
end;% k
datavec=datavec(da*dr*dy+1:length(datavec));
Vow=datavec(1:da);
datavec=datavec(da+1:length(datavec));
Voe=zeros(da,dr);
for i=1:da,
	for jj=1:dr,
   	Voe(i,jj)=datavec(jj+(i-1)*dr);
   end; % i
end;% k
datavec=datavec(da*dr+1:length(datavec));
Voee=zeros(da,dr);
for i=1:da,
	for jj=1:dr,
   	Voee(i,jj)=datavec(jj+(i-1)*dr);
   end; % i
end;% k
datavec=datavec(da*dr+1:length(datavec));
Vokeff=datavec(1:dk);
datavec=datavec(dk+1:length(datavec));
counter=1;
apoly=zeros(da,dy,dr);
for i=1:da
	for j=1:dy
		for jj=1:dr
         apoly(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
kpoly=zeros(da,dy,dr)-1;
for i=1:da
	for j=1:dy
		for jj=1:dr
         kpoly(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
apolye=zeros(da,dy,dr);
for i=1:da
	for j=1:dy
		for jj=1:dr
         apolye(i,j,jj)=datavec(counter);
   	     counter=counter+1;
	   end;
	end;
end;
kpolye=zeros(da,dy,dr)-1;
for i=1:da
	for j=1:dy
		for jj=1:dr
         kpolye(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
apolyw=zeros(da,dy,dr);
for i=1:da
	for j=1:dy
		for jj=1:dr
         apolyw(i,j,jj)=datavec(counter);
   	     counter=counter+1;
	   end;
	end;
end;
apolow=zeros(da,1);
for i=1:da
   apolow(i)=datavec(counter);
   counter=counter+1;
end;
apolownet=zeros(da,1);
for i=1:da
   apolownet(i)=datavec(counter);
   counter=counter+1;
end;
apoloe=zeros(da,dr);
for i=1:da
	for jj=1:dr
      apoloe(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;
apoloenet=zeros(da,dr);
for i=1:da
	for jj=1:dr
      apoloenet(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;
kpoloe=zeros(da,dr)-1;
for i=1:da
	for jj=1:dr
      kpoloe(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;
kyhat=zeros(da,dy,dr)-1;
for i=1:da
	for j=1:dy
		for jj=1:dr
         kyhat(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
kohat=zeros(da,dr)-1;
for i=1:da
	for jj=1:dr
      kohat(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;
labpoly=zeros(da,dy,dr);
for i=1:da
	for j=1:dy
		for jj=1:dr
         labpoly(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
labpoloe=zeros(da,dr);
for i=1:da
	for jj=1:dr
      labpoloe(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;
delt=datavec(counter);
counter=counter+1;
for i=1:da
    for j=1:dy
        for jj=1:dr
            conspoly(i,j,jj)=datavec(counter);
            counter=counter+1;
        end;
    end;
end;
for i=1:da
    for j=1:dy
        for jj=1:dr
            netincy(i,j,jj)=datavec(counter);
            counter=counter+1;
        end;
    end;
end;
for i=1:da
    for j=1:dy
        for jj=1:dr
            grossincy(i,j,jj)=datavec(counter);
            counter=counter+1;
        end;
    end;
end;
for i=1:da
    conspolow(i)=datavec(counter);
    counter=counter+1;
end;
for i=1:da
    netincow(i)=datavec(counter);
    counter=counter+1;
end;
for i=1:da
    grossincow(i)=datavec(counter);
    counter=counter+1;
end;
for i=1:da
    for jj=1:dr
        conspoloe(i,jj)=datavec(counter);
        counter=counter+1;
    end;
end;
for i=1:da
    for jj=1:dr
        netincoe(i,jj)=datavec(counter);
        counter=counter+1;
    end;
end;
for i=1:da
    for jj=1:dr
        grossincoe(i,jj)=datavec(counter);
        counter=counter+1;
    end;
end;

if switchequalss==1,
    load -ascii invdistr;
    datavec=invdistr; 
    clear invdistr;
else,
    load -ascii invdistrFINALSS;
    datavec=invdistrFINALSS; 
    clear invdistrFINALSS;
end;

nstates=datavec(1);
nyoung=datavec(2);
noe=datavec(3);
invm=datavec(4:nstates+3);
datavec=datavec(nstates+4:length(datavec));
prgrid=datavec(1:da);
datavec=datavec(da+1:length(datavec));
prgridyw=datavec(1:da);
prgridye=datavec(da+1:2*da);
prgridoe=datavec(2*da+1:3*da);
prgridow=datavec(3*da+1:4*da);
datavec=datavec(4*da+1:length(datavec));
tota=datavec(1);
totk=datavec(2);
inck=datavec(3);
invlevk=datavec(4:nstates-da+3);
datavec=datavec(nstates-da+4:length(datavec));
invpolk=datavec(1:nstates-da);
invrk=datavec(nstates-da+1:2*(nstates-da));
datavec=datavec(2*(nstates-da)+1:length(datavec));
k2gdp=datavec(1);
ykshare=datavec(2);
rbar=datavec(3);
invr=datavec(4:4+dr-1);
datavec=datavec(4+dr:length(datavec));
totke=datavec(1);
bet=datavec(2);
gam=datavec(3);
eff=datavec(4);
eta=datavec(5);
ni=datavec(6);
propewswitch=datavec(7);
propweswitch=datavec(8);
alph=datavec(9);
invy=datavec(10:10+dy-1);
datavec=datavec(10+dy:length(datavec));
for i=1:dr,
	for j=1:dr,
		Pr(i,j)=datavec((i-1)*dr+j);
	end;
end;
datavec=datavec(dr*dr+1:length(datavec));
yktotsh=datavec(1);
totentr=datavec(2);
totret=datavec(3);
totL=datavec(4);
grossw=datavec(5);
beq2gdp=datavec(6);
totkborr=datavec(7);
totyshe=datavec(8);
toteffL=datavec(9);
totlcorp=datavec(10);
hiredlabe=datavec(11);
counter=12;
for i=1:(2*nyoung)
   invtotlabye(i)=datavec(counter);
   counter=counter+1;
end;
for i=1:(noe)
   invtotlaboe(i)=datavec(counter);
   counter=counter+1;
end;
alphe=datavec(counter);
counter=counter+1;
phi=datavec(counter);
counter=counter+1;
xi=datavec(counter);
counter=counter+1;
ibar=datavec(counter);
counter=counter+1;
totkcorp=datavec(counter);
counter=counter+1;
totkgrossborr=datavec(counter);
counter=counter+1;
%labsup=datavec(counter);

% load -ascii funtot;
% datavec=funtot; 
% clear funtot;
% iteratot=(length(datavec))/8;
% fundiff=datavec(1:iteratot);
% datavec=datavec(iteratot+1:length(datavec));
% funtota=datavec(1:iteratot);
% datavec=datavec(iteratot+1:length(datavec));
% funtotk=datavec(1:iteratot);
% datavec=datavec(iteratot+1:length(datavec));
% funrbar=datavec(1:iteratot);
% datavec=datavec(iteratot+1:length(datavec));
% taubalvec=datavec(1:iteratot);
% datavec=datavec(iteratot+1:length(datavec));
% imbalvec=datavec(1:iteratot);
% datavec=datavec(iteratot+1:length(datavec));
% govbalvec=datavec(1:iteratot);
% datavec=datavec(iteratot+1:length(datavec));
% gdpvec=datavec(1:iteratot);
% [funrbars,funind]=sort(funrbar);
% funtotks=funtotk(funind);
% funtotas=funtota(funind);
% fundiffs=fundiff(funind);
% 

load -ascii we2inc;
datavec=we2inc; 
clear w2inc;
we2ince=datavec(1);
we2incw=datavec(2);

load -ascii govtax
datavec=govtax;
clear govtax;
ix=1;
gdp=datavec(ix); ix=ix+1;
govdebt=datavec(ix); ix=ix+1;
transf=datavec(ix); ix=ix+1;
gfrac=datavec(ix); ix=ix+1;
debtfrac=datavec(ix); ix=ix+1;
tottaxl=datavec(ix); ix=ix+1;
tottaxe=datavec(ix); ix=ix+1;
tottaxa=datavec(ix); ix=ix+1;
tottaxcw=datavec(ix); ix=ix+1;
tottaxce=datavec(ix); ix=ix+1;
tottaxbw=datavec(ix); ix=ix+1;
tottaxbe=datavec(ix); ix=ix+1;
govbal=datavec(ix); ix=ix+1;
taubal=datavec(ix); ix=ix+1;
btaxw=datavec(ix); ix=ix+1;
staxw=datavec(ix); ix=ix+1;
ptaxw=datavec(ix); ix=ix+1;
staxwbase=datavec(ix); ix=ix+1;
avgywsim=datavec(ix); ix=ix+1;
btaxe=datavec(ix); ix=ix+1;
staxe=datavec(ix); ix=ix+1;
ptaxe=datavec(ix); ix=ix+1;
staxebase=datavec(ix); ix=ix+1;
avgyesim=datavec(ix); ix=ix+1;
tauc=datavec(ix); ix=ix+1;
taua=datavec(ix); ix=ix+1;
tauls=datavec(ix); ix=ix+1;
exem=datavec(ix); ix=ix+1;
taub=datavec(ix); ix=ix+1;

kgrid=a;
propkgrid=prgrid;
nk=size(propkgrid,1);

%plot(kgrid,propkgrid);

% compute now the gini index for productivity.
% the number of people for each income level is given by the invariant
% distribution of the markov process we are considering.
dist=[0; invy];
yy=[0; y];
dyy=size(yy,1);
% lorenz curve plot (cumulative productivity plotted against cumulative
% number of agents; both normalized to one)
cumdist=cumsum(dist); % this is the cumulative number of agents
cumearn=cumsum(yy.*dist)/sum(yy.*dist); % this is cumulative productivity
area=0;
for i=1:dyy-1,
   area=area+(cumearn(i+1)+cumearn(i))*(cumdist(i+1)-cumdist(i));
end;
giniy=1-area

sp=[.01 .05 .10 .20 .40 .60 .80]';
% gini index and quantiles for wealth
[giniw,squantw,absasw]=giniperc(kgrid,propkgrid,sp);


%%%%%%%%%%%%%%%%%%%%%%%%%%% add capdist file
% compute invariant distribution over firm size
for ii=1:(nstates-da),
   if invlevk(ii)==0,
      indexk(ii)=0;
   else,
      indexk(ii)=min(find(invlevk(ii)<k+1e-05));
   end;
end;

invdistk=zeros(dk,1);
for ii=1:(nstates-da),
   if indexk(ii)>0,
      invdistk(indexk(ii))=invdistk(indexk(ii))+invm(ii);
   end;
end;
invdistk=invdistk/sum(invdistk);

% compute average firm size
avgf=k(2:dk)'*invdistk(2:dk)/sum(invdistk(2:dk));
avgfdoll=avgf*incdoll;

% compute median firm size (excluding those who keep the minimum
% amount of investment to keep the option value of being an entrep)
cdistk=cumsum(invdistk(2:dk)/sum(invdistk(2:dk)));
medf=k(min(find(cdistk>0.5)));
medfdoll=medf*incdoll;

% compute the share of wealth owned by entrepreneurs
% old
frweoe=a'*(prgridoe)/tota;
% young
frweye=a'*(prgridye)/tota;
% total entr
frwete=a'*(prgridoe+prgridye)/tota;

% compute average net worth
% workers
avgww=a'*(prgrid-prgridoe-prgridye)/sum(prgrid-prgridoe-prgridye);
avgwwdoll=avgww*incdoll;
% entrepreneurs
avgwe=a'*(prgridoe+prgridye)/sum(prgridoe+prgridye);
avgwedoll=avgwe*incdoll;

% compute median net worth
% workers
tempo=cumsum((prgrid-prgridoe-prgridye)/sum(prgrid-prgridoe-prgridye));
mednww=a(min(find(tempo>0.5)));
mednwwdoll=mednww*incdoll;
% entrepreneurs
tempo=cumsum((prgridoe+prgridye)/sum(prgridoe+prgridye));
mednwe=a(min(find(tempo>0.5)));
mednwedoll=mednwe*incdoll;

%incomes in two sectors
%share of income to entr=ykshare
%share of income to entr net of depreciation
yksharenet=(inck-rbar*totkborr-delt*totk)/(gdp-delt*totk);

% compute fraction of entrepreneurs in top wealth quantiles
prgridall=[prgridyw;prgridow;prgridye;prgridoe];
aall=[a;a;a;a];
indicatorentr=[zeros(2*da,1);ones(2*da,1)];
[aallsorted,aax]=sort(aall);
prgridallsorted=prgridall(aax);
indicatorentrsorted=indicatorentr(aax);
topquante=[.01;.05;.1];
percqtwe=numtopmask(prgridallsorted,topquante,find(indicatorentrsorted==1));

% compute bequest tax stuff
prgrido=prgridow+prgridoe;
prgrido=prgrido/sum(prgrido);
fid=find(a>=exem);
presttax=sum(prgrido(fid));
esttaxcutoff=quantili(a,prgrido,.98);

%gini and concentration of CONSUMPTION
[invmconsall,invmpropconsall,invmcons2eall,invmpropcons2eall,invmcons2wall,invmpropcons2wall]= ...
    stackinvec(invm,conspoly,conspoloe,conspolow,kpoly,kpoloe,da,dy,dr);
[ginic,squantcons,absasscons,cumdist,cums,cumdistcut,cumscut,squantconscut,giniconscut]=ginipercmorestuff(invmconsall,invmpropconsall,sp);

%[ginic2e,squantcons2e,absasscons2e]=giniperc(invmcons2eall,invmpropcons2eall,sp);
[ginic2w,squantcons2w,absasscons2w]=giniperc(invmcons2wall,invmpropcons2wall,sp);

%gini and concentration of NET income
[invmnetincall,invmpropnetincall,invmnetinc2eall,invmpropnetinc2eall,invmnetinc2wall,invmpropnetinc2wall]= ...
    stackinvec(invm,netincy,netincoe,netincow,kpoly,kpoloe,da,dy,dr);
[gininetinc,squantnetinc,absassnetinc]=giniperc(invmnetincall,invmpropnetincall,sp);
%[gininetinc2e,squantnetinc2e,absassnetinc2e]=giniperc(invmnetinc2eall,invmpropnetinc2eall,sp);
[gininetinc2w,squantnetinc2w,absassnetinc2w]=giniperc(invmnetinc2wall,invmpropnetinc2wall,sp);

%gini and concentration of GROSS income
[invmgrossincall,invmpropgrossincall,invmgrossinc2eall,invmpropgrossinc2eall,invmgrossinc2wall,invmpropgrossinc2wall]= ...
    stackinvec(invm,grossincy,grossincoe,grossincow,kpoly,kpoloe,da,dy,dr);
[ginigrossinc,squantgrossinc,absassgrossinc]=giniperc(invmgrossincall,invmpropgrossincall,sp);
%[ginigrossinc2e,squantgrossinc2e,absassgrossinc2e]=giniperc(invmgrossinc2eall,invmpropgrossinc2eall,sp);
[ginigrossinc2w,squantgrossinc2w,absassgrossinc2w]=giniperc(invmgrossinc2wall,invmpropgrossinc2wall,sp);

% compute now the distribution of workers hired by entrepreneurs
% labor demand:
% labpoloe is (da,dr)
% labpoly is (da,dy,dr). 
% we use kpoly, kpoloe to figure out when they are really entrepreneurs
% (index >-1)
% old entrepreneurs (do only for high dr)
invmoe=invm(2*(dr*dy*da)+1:2*(dr*dy*da)+da*dr);
invmoe=reshape(invmoe,da,dr);
% eliminate those that are not entrepreneurs.
for j=1:dr,
    fid=find(kpoloe(:,j)<0.1);
    invmoe(fid,j)=0.0;
end,
invmoe=reshape(invmoe,da*dr,1);
labpoloe=reshape(labpoloe,da*dr,1);
% all the young people, regardless of previous occupation
invmy=invm(1:dr*dy*da)+invm(dr*dy*da+1:2*(dr*dy*da));
% eliminate those that are not entrepreneurs
invmy=reshape(invmy,da,dy,dr);
for j=1:dy,
    for jj=1:dr,
        fid=find(kpoly(:,j,jj)<0.1);
        invmy(fid,j,jj)=0;
    end,
end,
invmy=reshape(invmy,da*dy*dr,1);
labpoly=reshape(labpoly,da*dy*dr,1);
invmlab=[invmoe;invmy];
labpole=[labpoloe;labpoly];

qt=[0.44; 0.45; 0.46; 0.465; 0.47; 0.48];
laborquant=quantili(labpole,invmlab,qt);
laborquant=[qt laborquant]';

[labpolexs,labpoleix]=sort(labpole);
labpolews=invmlab(labpoleix);
labpolews=labpolews/sum(labpolews);
labpolecums=cumsum(labpolews);

frachiring=1-labpolecums(min(find(labpolexs>0))-1)

% construct vector to import into excel spreadsheet
% ordering:
% k/y,fraction at 0,  top 1% wealth, frac entr, exit entr ,entry w, median net worth e/w, hiredlabe, giniw, govbal2gdp
excelvec=[k2gdp;propkgrid(1);(sum(prgridye)+sum(prgridoe));propewswitch;propweswitch;mednwedoll/mednwwdoll;...
         presttax; (tottaxbw+tottaxbe)/gdp*100; frachiring; avgwedoll/avgwwdoll; hiredlabe;giniw;govbal/gdp;rbar;...
         taubal; gdp; k2gdp*gdp;squantw(1)/100];

     
diary dat.out;
save dat;
disp('------------------- diary May2010.out ------------------------');
disp('    beta      gamma     eta     ni');
disp([bet gam eta ni]);
disp('------------------------------------------------------------------');
disp('    phi        xi  ');
disp([phi xi]);
disp('------------------------------------------------------------------');
disp('   maxa   da     dr    dy    mink  maxk   dk');
disp([a(da) da dr dy k(1) k(dk) dk]);
disp('   eff   alpha      ');
disp([eff alph]);
disp('------------------------------------------------------------------');
disp('y states and invariant distribution');
disp(y');
disp(invy');
disp('earnings gini')
disp(giniy);
disp('------------------------------------------------------------------');
disp('r states and invariant distribution');
disp(r');
disp(invr');
disp('Pr');
disp(Pr);
disp('-----------  ARE WE BUMPING ON THE GRIDS?-------------------------');
disp('prgrid(da),invdistk(dk)');
cacca=[prgrid(da) invdistk(dk)];
disp(cacca);
disp('------------------------- RESULTS --------------------------------');
disp('WEALTH')
disp('1%           5%       10%       20%       40%        60%        80%')
disp(squantw');
disp('wealth gini   % at zero');
cacca=[giniw propkgrid(1)*100];
disp(cacca);
disp('------------------------------------------------------------------');
disp('share of net worth held by entr: total, young, old');
disp([frwete frweye frweoe]);
disp('    we2ince,   w2incw');
cacca=[we2ince we2incw];
disp(cacca);
disp('average net worth: entrepreneurs, workers');
disp('G-H data: 855K, 126K');
disp([avgwedoll avgwwdoll]);
disp('median net worth: entrepreneurs, workers');
disp('G-H data: 307K, 38K');
disp([mednwedoll mednwwdoll]);
disp('--------------------------------------------------------------------');
disp('% entr total, young,    old');
cacca=[(sum(prgridye)+sum(prgridoe))*100 sum(prgridye)*100 sum(prgridoe)*100];
disp(cacca);
disp('% entr becoming workers');
disp(propewswitch*100);
disp('% w becoming e');
disp(propweswitch*100);
disp('--------------------------------------------------------------------');
disp('   ykshare,  ykshare (net),   rbar,     ibar,    tota,     totk');
cacca=[ ykshare yksharenet rbar*100 ibar*100 tota totk];
disp(cacca);
disp('   gdp,       k2gdp,    % bequests to gdp ');
cacca=[gdp,k2gdp,beq2gdp];
disp(cacca);
disp('--------------------------------------------------------------------');
disp('Government');
disp('Govbal');
disp(govbal);
sspay=transf*(totret-sum(prgridoe));
disp('The following are expressed as a percentage of GDP');
disp('INTPAY,  SStransf,    Gexp');
cacca=[rbar*govdebt/gdp*100,sspay/gdp*100,gfrac];
disp(cacca);
disp('tax receipts as a % of gdp ');
disp('labor tax, entr tax, assets tax, cons tax on w, cons tax on e, beq tax');
cacca=[tottaxl/gdp*100, tottaxe/gdp*100, tottaxa/gdp*100, tottaxcw/gdp*100, tottaxce/gdp*100, (tottaxbw+tottaxbe)/gdp*100];
disp(cacca);
disp(strcat('fraction paying estate taxes=',num2str(presttax)));
disp(strcat('quantile .98 of w distr of old=',num2str(esttaxcutoff)));
disp(' ');
disp('---------------- labor demand quantiles  -------------------------');
laborquant
disp(' ');
disp('------------------------ firms -----------------------------------');
disp('firm size:average and median');
disp([avgfdoll medfdoll]);
disp('------------------------------------------------------------------');
disp(' ');
disp('fraction of entr in the top x% of wealth');
disp(topquante');
disp(percqtwe);
disp(' ');
disp('------------------------------------------------------------------');
disp('CONSUMPTION')
disp('1%           5%       10%       20%       40%        60%        80%')
disp(squantcons');
disp('consumption gini');
disp(ginic);
disp('------------------------------------------------------------------');
disp('CONSUMPTION, top X% missing')
disp('1%           5%       10%       20%       40%        60%        80%')
disp(squantconscut');
disp('consumption gini');
disp(giniconscut);
disp('------------------------------------------------------------------');
disp('CONSUMPTION WORKERS')
disp('1%           5%       10%       20%       40%        60%        80%')
disp(squantcons2w')
disp('consumption gini');
disp(ginic2w);
disp('------------------------------------------------------------------');
disp('NET INCOME')
disp('1%           5%       10%       20%       40%        60%        80%')
disp(squantnetinc');
disp('net income gini');
disp(gininetinc);
disp('------------------------------------------------------------------');
disp('NET INCOME WORKERS')
disp('1%           5%       10%       20%       40%        60%        80%')
disp(squantnetinc2w');
disp('net income gini');
disp(gininetinc2w);
disp('------------------------------------------------------------------');
disp('GROSS INCOME')
disp('1%           5%       10%       20%       40%        60%        80%')
disp(squantgrossinc');
disp('gross income gini');
disp(ginigrossinc);
disp('------------------------------------------------------------------');
disp('GROSS INCOME WORKERS')
disp('1%           5%       10%       20%       40%        60%        80%')
disp(squantgrossinc2w');
disp('gross income gini');
disp(ginigrossinc2w);
disp('------------------------------------------------------------------');
disp('Excel outputs ');
excelvec
disp('------------------------------------------------------------------');
disp('');
diary off;


if exist('remotedirectory')==1,
    if remotedirectory==1,
        eval(['cd ' newdir]);   
    end;
end;

% LOAD TRANSITION STUFF HERE

load -ascii vectorsanddata;
datavec=vectorsanddata; 
clear vectorsanddata;
i=1;
Ttrans=datavec(i);
Ttransplot=min(Ttransplot,Ttrans);
i=i+1;
govdebt1ss=datavec(i);
i=i+1;
govdebt2ss=datavec(i);
i=i+1;

i=i+Ttrans; % skip taucpathT not used
taubalpathT=zeros(Ttrans,1);
for j=1:Ttrans,
    taubalpathT(j)=datavec(i);
    i=i+1;
end,
totaT=zeros(Ttrans,1);
for j=1:Ttrans,
    totaT(j)=datavec(i);
    i=i+1;
end,
gdpT=zeros(Ttrans,1);
for j=1:Ttrans,
    gdpT(j)=datavec(i);
    i=i+1;
end,
govprimsurpT=zeros(Ttrans,1);
for j=1:Ttrans,
    govprimsurpT(j)=datavec(i);
    i=i+1;
end,
wageimpliedT=zeros(Ttrans,1);
for j=1:Ttrans,
    wageimpliedT(j)=datavec(i);
    i=i+1;
end,
rimpliedT=zeros(Ttrans,1);
for j=1:Ttrans,
    rimpliedT(j)=datavec(i);
    i=i+1;
end,
PVprimgovsurp=datavec(i);
i=i+1;
govbalPV=datavec(i);
i=i+1;
govbalPVmin=datavec(i);
i=i+1;
govbalPVmax=datavec(i);
i=i+1;
% taucadj=datavec(i);
i=i+1; 
%taucadjmin=datavec(i);
i=i+1;
%taucadjmax=datavec(i);
i=i+1;
%taucinterp=datavec(i);
i=i+1;
epsigov=datavec(i);
i=i+1;
rbar=datavec(i);
i=i+1;
wage=datavec(i);
i=i+1;
epsinvm=datavec(i);
i=i+1;
nstates=datavec(i);
i=i+1;
invmtrans=zeros(nstates,1);
for j=1:nstates,
    invmtrans(j)=datavec(i);
    i=i+1;
end,
govdebtT=zeros(Ttrans,1);
for j=1:Ttrans,
    govdebtT(j)=datavec(i);
    i=i+1;
end,
rbarpath=zeros(Ttrans,1);
for j=1:Ttrans,
    rbarpath(j)=datavec(i);
    i=i+1;
end,
wagepath=zeros(Ttrans,1);
for j=1:Ttrans,
    wagepath(j)=datavec(i);
    i=i+1;
end,
totkT=zeros(Ttrans,1);
for j=1:Ttrans,
    totkT(j)=datavec(i);
    i=i+1;
end,
totlcorpT=zeros(Ttrans,1);
for j=1:Ttrans,
    totlcorpT(j)=datavec(i);
    i=i+1;
end,
inckT=zeros(Ttrans,1);
for j=1:Ttrans,
    inckT(j)=datavec(i);
    i=i+1;
end,
epsir=datavec(i);
i=i+1
taxeslesstransfT=zeros(Ttrans,1);
for j=1:Ttrans,
    taxeslesstransfT(j)=datavec(i);
    i=i+1;
end,
hiredlabeT=zeros(Ttrans,1);
for j=1:Ttrans,
    hiredlabeT(j)=datavec(i);
    i=i+1;
end,
totkcorpT=zeros(Ttrans,1);
for j=1:Ttrans,
    totkcorpT(j)=datavec(i);
    i=i+1;
end,
totentrT=zeros(Ttrans,1);
for j=1:Ttrans,
    totentrT(j)=datavec(i);
    i=i+1;
end,
totkgrossborrT=zeros(Ttrans,1);
for j=1:Ttrans,
    totkgrossborrT(j)=datavec(i);
    i=i+1;
end,
propewswitchT=zeros(Ttrans,1);
for j=1:Ttrans,
    propewswitchT(j)=datavec(i);
    i=i+1;
end,
propweswitchT=zeros(Ttrans,1);
for j=1:Ttrans,
    propweswitchT(j)=datavec(i);
    i=i+1;
end,
ibarpath=zeros(Ttrans,1);
for j=1:Ttrans,
    ibarpath(j)=datavec(i);
    i=i+1;
end,
T0=datavec(i);
i=i+1;
T1=datavec(i);
%i=i+1;
%T2=datavec(i);
i=i+1;
T3=datavec(i);
i=i+1;
T4=datavec(i);
i=i+1;
abigvec=zeros(T0+1,1);
for j=1:T0+1,
    abigvec(j)=datavec(i);
    i=i+1;
end,
xivec=zeros(T0+1,1);
for j=1:T0+1,
    xivec(j)=datavec(i);
    i=i+1;
end,
phivec=zeros(T0+1,1);
for j=1:T0+1,
    phivec(j)=datavec(i);
    i=i+1;
end,
aggrconsgoodsT=zeros(Ttrans,1);
for j=1:Ttrans,
    aggrconsgoodsT(j)=datavec(i);
    i=i+1;
end,
tfpvec=zeros(T0+1,1);
for j=1:T0+1,
    tfpvec(j)=datavec(i);
    i=i+1;
end;
totefflT=zeros(Ttrans,1);
for j=1:Ttrans,
    totefflT(j)=datavec(i);
    i=i+1;
end;
labsupT=zeros(Ttrans,1);
for j=1:Ttrans,
    labsupT(j)=datavec(i);
    i=i+1;
end;
capintermedT=zeros(Ttrans,1);
for j=1:Ttrans,
    capintermedT(j)=datavec(i);
    i=i+1;
end;
aggrconstotT=zeros(Ttrans,1);
for j=1:Ttrans,
    aggrconstotT(j)=datavec(i);
    i=i+1;
end;
oldnipaswitch=datavec(i);

if (savepolfun==1),
    load -ascii polfuns;
    datavec=polfuns; 
    clear polfuns;
    counter=1;
    apolyT=zeros(da,dy,dr,Ttrans);
    for i=1:da,
        for j=1:dy,
            for jj=1:dr,
                for ii=1:Ttrans,
                    apolyT(i,j,jj,ii)=datavec(counter);
                    counter=counter+1;
                end; % ii
            end; % jj
        end; % j
    end; % i
    datavec=datavec(counter:length(datavec));
    counter=1;
    kpolyT=zeros(da,dy,dr,Ttrans);
    for i=1:da,
        for j=1:dy,
            for jj=1:dr,
                for ii=1:Ttrans,
                    kpolyT(i,j,jj,ii)=datavec(counter);
                    counter=counter+1;
                end; % ii
            end; % jj
        end; % j
    end; % i
    datavec=datavec(counter:length(datavec));
    counter=1;
    labpolyT=zeros(da,dy,dr,Ttrans);
    for i=1:da,
        for j=1:dy,
            for jj=1:dr,
                for ii=1:Ttrans,
                    labpolyT(i,j,jj,ii)=datavec(counter);
                    counter=counter+1;
                end; % ii
            end; % jj
        end; % j
    end; % i
    datavec=datavec(counter:length(datavec));
    counter=1;
    apolowT=zeros(da,Ttrans);
    for i=1:da,
        for ii=1:Ttrans,
            apolowT(i,ii)=datavec(counter);
            counter=counter+1;
        end; % i
    end; % j0
    datavec=datavec(counter:length(datavec));
    counter=1;
    apoloeT=zeros(da,dr,Ttrans);
    for i=1:da,
        for jj=1:dr,
            for ii=1:Ttrans,
                apoloeT(i,jj,ii)=datavec(counter);
                counter=counter+1;
             end; % ii
        end; % jj
    end; % i
    datavec=datavec(counter:length(datavec));
    counter=1;
    kpoloeT=zeros(da,dr,Ttrans);
    for i=1:da,
        for jj=1:dr,
            for ii=1:Ttrans,
                kpoloeT(i,jj,ii)=datavec(counter);
                counter=counter+1;
             end; % ii
        end; % jj
    end; % i
    datavec=datavec(counter:length(datavec));
    counter=1;
    labpoloeT=zeros(da,dr,Ttrans);
    for i=1:da,
        for jj=1:dr,
            for ii=1:Ttrans,
                labpoloeT(i,jj,ii)=datavec(counter);
                counter=counter+1;
             end; % ii
        end; % jj
    end; % i
end;

gdpcorpT=zeros(Ttrans,1);
gdpentrT=zeros(Ttrans,1);
intermedcostT=zeros(Ttrans,1);
avgkT=zeros(Ttrans,1);
govtotsurpT=govprimsurpT-ibarpath.*govdebtT;
aggrcapstockT=zeros(Ttrans,1);
for i=1:Ttrans,
    gdpcorpT(i)=abigvec(min(i,T0+1))*tfpvec(min(i,T0+1))*(totkcorpT(i)^alph)*(totlcorpT(i)^(1.0-alph))-...
        phivec(min(i,T0+1))*xivec(min(i,T0+1))*totkcorpT(i);
    gdpentrT(i)=inckT(i)-phivec(min(i,T0+1))*totkgrossborrT(i);
    intermedcostT(i)=phivec(min(i,T0+1))*capintermedT(i); 
    aggrcapstockT(i)=totkT(i)+totkcorpT(i);
end;
avgkT=totkT./totentrT;
aggrinvestT=zeros(Ttrans,1);
for i=1:Ttrans-1,
    aggrinvestT(i)=aggrcapstockT(i+1)-aggrcapstockT(i)*(1-delt);
end;
aggrinvestT(Ttrans)=delt*aggrcapstockT(Ttrans);


save dat;

save rbarpath2501 rbarpath -ascii

if exist('remotedirectory')==1,
    if remotedirectory==1,
        eval(['cd ' parentdir]);
    end;
end;