clear;

% In our working directories, this was called invleverage2ndround

set(0,'DefaultLineLineWidth',2,'DefaultAxesFontSize',16,'DefaultAxesFontName','Times New Roman');

% this code also computes consumption inequality, and 
% gross and net income inequality, also conditional on age and 
% occupational choice
% it load from the fortran code in which entrepreneurs can choose how many 
% workers to hire

% define relevant yearly income to transform into dollars
% in thousands!
incdoll=45;

load -ascii valfun;
datavec=valfun; 
clear valfun;

% load and define data from fortran ascii file
% (including some parameters, various value functions and policy
% functions, and various measures of gross income)
da=datavec(1);
dy=datavec(2);
dr=datavec(3);
dk=datavec(4);
datavec=datavec(5:length(datavec));
a=datavec(1:da);
y=datavec(da+1:da+dy);
r=datavec(da+dy+1:da+dy+dr);
k=datavec(da+dy+dr+1:da+dy+dr+dk);
datavec=datavec(da+dy+dr+dk+1:length(datavec));
Vy=zeros(da,dy,dr);
for i=1:da,
	for j=1:dy,
		for jj=1:dr,
			Vy(i,j,jj)=datavec(jj+(j-1)*dr+(i-1)*dr*dy);
		end; % i
	end; % j0
end;% k
datavec=datavec(da*dr*dy+1:length(datavec));
Vyw=zeros(da,dy,dr);
for i=1:da,
	for j=1:dy,
		for jj=1:dr,
         Vyw(i,j,jj)=datavec(jj+(j-1)*dr+(i-1)*dr*dy);
      end; % i
   end; % j0
end;% k
datavec=datavec(da*dr*dy+1:length(datavec));
Vye=zeros(da,dy,dr);
for i=1:da,
	for j=1:dy,
		for jj=1:dr,
         Vye(i,j,jj)=datavec(jj+(j-1)*dr+(i-1)*dr*dy);
      end; % i
   end; % j0
end;% k
datavec=datavec(da*dr*dy+1:length(datavec));
Vow=datavec(1:da);
datavec=datavec(da+1:length(datavec));
Voe=zeros(da,dr);
for i=1:da,
	for jj=1:dr,
   	Voe(i,jj)=datavec(jj+(i-1)*dr);
   end; % i
end;% k
datavec=datavec(da*dr+1:length(datavec));
Voee=zeros(da,dr);
for i=1:da,
	for jj=1:dr,
   	Voee(i,jj)=datavec(jj+(i-1)*dr);
   end; % i
end;% k
datavec=datavec(da*dr+1:length(datavec));
Vokeff=datavec(1:dk);
datavec=datavec(dk+1:length(datavec));
counter=1;
apoly=zeros(da,dy,dr);
for i=1:da
	for j=1:dy
		for jj=1:dr
         apoly(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
kpoly=zeros(da,dy,dr)-1;
for i=1:da
	for j=1:dy
		for jj=1:dr
         kpoly(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
apolye=zeros(da,dy,dr);
for i=1:da
	for j=1:dy
		for jj=1:dr
         apolye(i,j,jj)=datavec(counter);
   	     counter=counter+1;
	   end;
	end;
end;
kpolye=zeros(da,dy,dr)-1;
for i=1:da
	for j=1:dy
		for jj=1:dr
         kpolye(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
apolyw=zeros(da,dy,dr);
for i=1:da
	for j=1:dy
		for jj=1:dr
         apolyw(i,j,jj)=datavec(counter);
   	     counter=counter+1;
	   end;
	end;
end;
apolow=zeros(da,1);
for i=1:da
   apolow(i)=datavec(counter);
   counter=counter+1;
end;
apolownet=zeros(da,1);
for i=1:da
   apolownet(i)=datavec(counter);
   counter=counter+1;
end;
apoloe=zeros(da,dr);
for i=1:da
	for jj=1:dr
      apoloe(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;
apoloenet=zeros(da,dr);
for i=1:da
	for jj=1:dr
      apoloenet(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;
kpoloe=zeros(da,dr)-1;
for i=1:da
	for jj=1:dr
      kpoloe(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;
kyhat=zeros(da,dy,dr)-1;
for i=1:da
	for j=1:dy
		for jj=1:dr
         kyhat(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
kohat=zeros(da,dr)-1;
for i=1:da
	for jj=1:dr
      kohat(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;
labpoly=zeros(da,dy,dr);
for i=1:da
	for j=1:dy
		for jj=1:dr
         labpoly(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
labpoloe=zeros(da,dr);
for i=1:da
	for jj=1:dr
      labpoloe(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;
delt=datavec(counter);
counter=counter+1;
for i=1:da
    for j=1:dy
        for jj=1:dr
            conspoly(i,j,jj)=datavec(counter);
            counter=counter+1;
        end;
    end;
end;
for i=1:da
    for j=1:dy
        for jj=1:dr
            netincy(i,j,jj)=datavec(counter);
            counter=counter+1;
        end;
    end;
end;
for i=1:da
    for j=1:dy
        for jj=1:dr
            grossincy(i,j,jj)=datavec(counter);
            counter=counter+1;
        end;
    end;
end;
for i=1:da
    conspolow(i)=datavec(counter);
    counter=counter+1;
end;
for i=1:da
    netincow(i)=datavec(counter);
    counter=counter+1;
end;
for i=1:da
    grossincow(i)=datavec(counter);
    counter=counter+1;
end;
for i=1:da
    for jj=1:dr
        conspoloe(i,jj)=datavec(counter);
        counter=counter+1;
    end;
end;
for i=1:da
    for jj=1:dr
        netincoe(i,jj)=datavec(counter);
        counter=counter+1;
    end;
end;
for i=1:da
    for jj=1:dr
        grossincoe(i,jj)=datavec(counter);
        counter=counter+1;
    end;
end;

load -ascii invdistr;
datavec=invdistr; 
clear invdistr;

nstates=datavec(1);
nyoung=datavec(2);
noe=datavec(3);
invm=datavec(4:nstates+3);
datavec=datavec(nstates+4:length(datavec));
prgrid=datavec(1:da);
datavec=datavec(da+1:length(datavec));
prgridyw=datavec(1:da);
prgridye=datavec(da+1:2*da);
prgridoe=datavec(2*da+1:3*da);
prgridow=datavec(3*da+1:4*da);
datavec=datavec(4*da+1:length(datavec));
tota=datavec(1);
totk=datavec(2);
inck=datavec(3);
invlevk=datavec(4:nstates-da+3);
datavec=datavec(nstates-da+4:length(datavec));
invpolk=datavec(1:nstates-da);
invrk=datavec(nstates-da+1:2*(nstates-da));
datavec=datavec(2*(nstates-da)+1:length(datavec));
k2gdp=datavec(1);
ykshare=datavec(2);
rbar=datavec(3);
invr=datavec(4:4+dr-1);
datavec=datavec(4+dr:length(datavec));
totke=datavec(1);
bet=datavec(2);
gam=datavec(3);
eff=datavec(4);
eta=datavec(5);
ni=datavec(6);
propewswitch=datavec(7);
propweswitch=datavec(8);
alph=datavec(9);
invy=datavec(10:10+dy-1);
datavec=datavec(10+dy:length(datavec));
for i=1:dr,
	for j=1:dr,
		Pr(i,j)=datavec((i-1)*dr+j);
	end;
end;
datavec=datavec(dr*dr+1:length(datavec));
yktotsh=datavec(1);
totentr=datavec(2);
totret=datavec(3);
totL=datavec(4);
grossw=datavec(5);
beq2gdp=datavec(6);
totkborr=datavec(7);
totyshe=datavec(8);
toteffL=datavec(9);
totlcorp=datavec(10);
hiredlabe=datavec(11);
counter=12;
for i=1:(2*nyoung)
   invtotlabye(i)=datavec(counter);
   counter=counter+1;
end;
for i=1:(noe)
   invtotlaboe(i)=datavec(counter);
   counter=counter+1;
end;
alphe=datavec(counter);
counter=counter+1;
phi=datavec(counter);
counter=counter+1;
xi=datavec(counter);
counter=counter+1;
ibar=datavec(counter);
counter=counter+1;
totkcorp=datavec(counter);
counter=counter+1;
totkgrossborr=datavec(counter);
counter=counter+1;
labsup=datavec(counter);

load -ascii funtot;
datavec=funtot; 
clear funtot;
iteratot=(length(datavec))/8;
fundiff=datavec(1:iteratot);
datavec=datavec(iteratot+1:length(datavec));
funtota=datavec(1:iteratot);
datavec=datavec(iteratot+1:length(datavec));
funtotk=datavec(1:iteratot);
datavec=datavec(iteratot+1:length(datavec));
funrbar=datavec(1:iteratot);
datavec=datavec(iteratot+1:length(datavec));
taubalvec=datavec(1:iteratot);
datavec=datavec(iteratot+1:length(datavec));
imbalvec=datavec(1:iteratot);
datavec=datavec(iteratot+1:length(datavec));
govbalvec=datavec(1:iteratot);
datavec=datavec(iteratot+1:length(datavec));
gdpvec=datavec(1:iteratot);
[funrbars,funind]=sort(funrbar);
funtotks=funtotk(funind);
funtotas=funtota(funind);
fundiffs=fundiff(funind);


load -ascii we2inc;
datavec=we2inc; 
clear w2inc;
we2ince=datavec(1);
we2incw=datavec(2);

load -ascii govtax
datavec=govtax;
clear govtax;
ix=1;
gdp=datavec(ix); ix=ix+1;
govdebt=datavec(ix); ix=ix+1;
transf=datavec(ix); ix=ix+1;
gfrac=datavec(ix); ix=ix+1;
debtfrac=datavec(ix); ix=ix+1;
tottaxl=datavec(ix); ix=ix+1;
tottaxe=datavec(ix); ix=ix+1;
tottaxa=datavec(ix); ix=ix+1;
tottaxcw=datavec(ix); ix=ix+1;
tottaxce=datavec(ix); ix=ix+1;
tottaxbw=datavec(ix); ix=ix+1;
tottaxbe=datavec(ix); ix=ix+1;
govbal=datavec(ix); ix=ix+1;
taubal=datavec(ix); ix=ix+1;
btaxw=datavec(ix); ix=ix+1;
staxw=datavec(ix); ix=ix+1;
ptaxw=datavec(ix); ix=ix+1;
staxwbase=datavec(ix); ix=ix+1;
avgywsim=datavec(ix); ix=ix+1;
btaxe=datavec(ix); ix=ix+1;
staxe=datavec(ix); ix=ix+1;
ptaxe=datavec(ix); ix=ix+1;
staxebase=datavec(ix); ix=ix+1;
avgyesim=datavec(ix); ix=ix+1;
tauc=datavec(ix); ix=ix+1;
taua=datavec(ix); ix=ix+1;
tauls=datavec(ix); ix=ix+1;
exem=datavec(ix); ix=ix+1;
taub=datavec(ix); ix=ix+1;

%plot(funrbars,fundiffs);
%figure;

kgrid=a;
propkgrid=prgrid;
nk=size(propkgrid,1);

%plot(kgrid,propkgrid);

% compute now the gini index for productivity.
% the number of people for each income level is given by the invariant
% distribution of the markov process we are considering.
dist=[0; invy];
yy=[0; y];
dyy=size(yy,1);
% lorenz curve plot (cumulative productivity plotted against cumulative
% number of agents; both normalized to one)
cumdist=cumsum(dist); % this is the cumulative number of agents
cumearn=cumsum(yy.*dist)/sum(yy.*dist); % this is cumulative productivity
area=0;
for i=1:dyy-1,
   area=area+(cumearn(i+1)+cumearn(i))*(cumdist(i+1)-cumdist(i));
end;
giniy=1-area

sp=[.01 .05 .10 .20 .40 .60 .80]';
% gini index and quantiles for wealth
[giniw,squantw,absasw]=giniperc(kgrid,propkgrid,sp);


%%%%%%%%%%%%%%%%%%%%%%%%%%% add capdist file
% compute invariant distribution over firm size
for ii=1:(nstates-da),
   if invlevk(ii)==0,
      indexk(ii)=0;
   else,
      indexk(ii)=min(find(invlevk(ii)<k+1e-05));
   end;
end;

invdistk=zeros(dk,1);
for ii=1:(nstates-da),
   if indexk(ii)>0,
      invdistk(indexk(ii))=invdistk(indexk(ii))+invm(ii);
   end;
end;
invdistk=invdistk/sum(invdistk);

% compute average firm size
avgf=k(2:dk)'*invdistk(2:dk)/sum(invdistk(2:dk));
avgfdoll=avgf*incdoll;

% compute median firm size (excluding those who keep the minimum
% amount of investment to keep the option value of being an entrep)
cdistk=cumsum(invdistk(2:dk)/sum(invdistk(2:dk)));
medf=k(min(find(cdistk>0.5)));
medfdoll=medf*incdoll;

% compute the share of wealth owned by entrepreneurs
% old
frweoe=a'*(prgridoe)/tota;
% young
frweye=a'*(prgridye)/tota;
% total entr
frwete=a'*(prgridoe+prgridye)/tota;

% compute average net worth
% workers
avgww=a'*(prgrid-prgridoe-prgridye)/sum(prgrid-prgridoe-prgridye);
avgwwdoll=avgww*incdoll;
% entrepreneurs
avgwe=a'*(prgridoe+prgridye)/sum(prgridoe+prgridye);
avgwedoll=avgwe*incdoll;

% compute median net worth
% workers
tempo=cumsum((prgrid-prgridoe-prgridye)/sum(prgrid-prgridoe-prgridye));
mednww=a(min(find(tempo>0.5)));
mednwwdoll=mednww*incdoll;
% entrepreneurs
tempo=cumsum((prgridoe+prgridye)/sum(prgridoe+prgridye));
mednwe=a(min(find(tempo>0.5)));
mednwedoll=mednwe*incdoll;

%incomes in two sectors
%share of income to entr=ykshare
%share of income to entr net of depreciation
yksharenet=(inck-rbar*totkborr-delt*totk)/(gdp-delt*totk);

% compute fraction of entrepreneurs in top wealth quantiles
prgridall=[prgridyw;prgridow;prgridye;prgridoe];
aall=[a;a;a;a];
indicatorentr=[zeros(2*da,1);ones(2*da,1)];
[aallsorted,aax]=sort(aall);
prgridallsorted=prgridall(aax);
indicatorentrsorted=indicatorentr(aax);
topquante=[.01;.05;.1];
percqtwe=numtopmask(prgridallsorted,topquante,find(indicatorentrsorted==1));

% compute bequest tax stuff
prgrido=prgridow+prgridoe;
prgrido=prgrido/sum(prgrido);
fid=find(a>=exem);
presttax=sum(prgrido(fid));
esttaxcutoff=quantili(a,prgrido,.98);

%gini and concentration of CONSUMPTION
[invmconsall,invmpropconsall,invmcons2eall,invmpropcons2eall,invmcons2wall,invmpropcons2wall]= ...
    stackinvec(invm,conspoly,conspoloe,conspolow,kpoly,kpoloe,da,dy,dr);
[ginic,squantcons,absasscons,cumdist,cums,cumdistcut,cumscut,squantconscut,giniconscut]=ginipercmorestuff(invmconsall,invmpropconsall,sp);

%[ginic2e,squantcons2e,absasscons2e]=giniperc(invmcons2eall,invmpropcons2eall,sp);
[ginic2w,squantcons2w,absasscons2w]=giniperc(invmcons2wall,invmpropcons2wall,sp);

%gini and concentration of NET income
[invmnetincall,invmpropnetincall,invmnetinc2eall,invmpropnetinc2eall,invmnetinc2wall,invmpropnetinc2wall]= ...
    stackinvec(invm,netincy,netincoe,netincow,kpoly,kpoloe,da,dy,dr);
[gininetinc,squantnetinc,absassnetinc]=giniperc(invmnetincall,invmpropnetincall,sp);
%[gininetinc2e,squantnetinc2e,absassnetinc2e]=giniperc(invmnetinc2eall,invmpropnetinc2eall,sp);
[gininetinc2w,squantnetinc2w,absassnetinc2w]=giniperc(invmnetinc2wall,invmpropnetinc2wall,sp);

%gini and concentration of GROSS income
[invmgrossincall,invmpropgrossincall,invmgrossinc2eall,invmpropgrossinc2eall,invmgrossinc2wall,invmpropgrossinc2wall]= ...
    stackinvec(invm,grossincy,grossincoe,grossincow,kpoly,kpoloe,da,dy,dr);
[ginigrossinc,squantgrossinc,absassgrossinc]=giniperc(invmgrossincall,invmpropgrossincall,sp);
%[ginigrossinc2e,squantgrossinc2e,absassgrossinc2e]=giniperc(invmgrossinc2eall,invmpropgrossinc2eall,sp);
[ginigrossinc2w,squantgrossinc2w,absassgrossinc2w]=giniperc(invmgrossinc2wall,invmpropgrossinc2wall,sp);

% compute now the distribution of workers hired by entrepreneurs
% labor demand:
% labpoloe is (da,dr)
% labpoly is (da,dy,dr). 
% we use kpoly, kpoloe to figure out when they are really entrepreneurs
% (index >-1)
% old entrepreneurs (do only for high dr)
invmoe=invm(2*(dr*dy*da)+1:2*(dr*dy*da)+da*dr);
invmoe=reshape(invmoe,da,dr);
% eliminate those that are not entrepreneurs.
for j=1:dr,
    fid=find(kpoloe(:,j)<0.1);
    invmoe(fid,j)=0.0;
end,
invmoe=reshape(invmoe,da*dr,1);
labpoloe=reshape(labpoloe,da*dr,1);
% all the young people, regardless of previous occupation
invmy=invm(1:dr*dy*da)+invm(dr*dy*da+1:2*(dr*dy*da));
% eliminate those that are not entrepreneurs
invmy=reshape(invmy,da,dy,dr);
for j=1:dy,
    for jj=1:dr,
        fid=find(kpoly(:,j,jj)<0.1);
        invmy(fid,j,jj)=0;
    end,
end,
invmy=reshape(invmy,da*dy*dr,1);
labpoly=reshape(labpoly,da*dy*dr,1);
invmlab=[invmoe;invmy];
labpole=[labpoloe;labpoly];

qt=[0.44; 0.45; 0.46; 0.465; 0.47; 0.48];
laborquant=quantili(labpole,invmlab,qt);
laborquant=[qt laborquant]';

[labpolexs,labpoleix]=sort(labpole);
labpolews=invmlab(labpoleix);
labpolews=labpolews/sum(labpolews);
labpolecums=cumsum(labpolews);

frachiring=1-labpolecums(min(find(labpolexs>0))-1)

% construct vector to import into excel spreadsheet
% ordering:
% k/y,fraction at 0,  top 1% wealth, frac entr, exit entr ,entry w, median net worth e/w, hiredlabe, giniw, govbal2gdp
excelvec=[k2gdp;propkgrid(1);(sum(prgridye)+sum(prgridoe));propewswitch;propweswitch;mednwedoll/mednwwdoll;...
         presttax; (tottaxbw+tottaxbe)/gdp*100; frachiring; avgwedoll/avgwwdoll; hiredlabe;giniw;govbal/gdp;rbar;...
         taubal; gdp; k2gdp*gdp;squantw(1)/100];

diary dat.out;
save dat;
disp('------------------- diary April2010.out ------------------------');
disp('    beta      gamma     eta     ni');
disp([bet gam eta ni]);
disp('------------------------------------------------------------------');
disp('    phi        xi  ');
disp([phi xi]);
disp('------------------------------------------------------------------');
disp('   maxa   da     dr    dy    mink  maxk   dk');
disp([a(da) da dr dy k(1) k(dk) dk]);
disp('   eff   alpha      ');
disp([eff alph]);
disp('------------------------------------------------------------------');
disp('y states and invariant distribution');
disp(y');
disp(invy');
disp('earnings gini')
disp(giniy);
disp('------------------------------------------------------------------');
disp('r states and invariant distribution');
disp(r');
disp(invr');
disp('Pr');
disp(Pr);
disp('-----------  ARE WE BUMPING ON THE GRIDS?-------------------------');
disp('prgrid(da),invdistk(dk)');
cacca=[prgrid(da) invdistk(dk)];
disp(cacca);
disp('------------------------- RESULTS --------------------------------');
disp('WEALTH')
disp('1%           5%       10%       20%       40%        60%        80%')
disp(squantw');
disp('wealth gini   % at zero');
cacca=[giniw propkgrid(1)*100];
disp(cacca);
disp('------------------------------------------------------------------');
disp('share of net worth held by entr: total, young, old');
disp([frwete frweye frweoe]);
disp('    we2ince,   w2incw');
cacca=[we2ince we2incw];
disp(cacca);
disp('average net worth: entrepreneurs, workers');
disp('G-H data: 855K, 126K');
disp([avgwedoll avgwwdoll]);
disp('median net worth: entrepreneurs, workers');
disp('G-H data: 307K, 38K');
disp([mednwedoll mednwwdoll]);
disp('--------------------------------------------------------------------');
disp('% entr total, young,    old');
cacca=[(sum(prgridye)+sum(prgridoe))*100 sum(prgridye)*100 sum(prgridoe)*100];
disp(cacca);
disp('% entr becoming workers');
disp(propewswitch*100);
disp('% w becoming e');
disp(propweswitch*100);
disp('--------------------------------------------------------------------');
disp('   ykshare,  ykshare (net),   rbar,     ibar,    tota,     totk');
cacca=[ ykshare yksharenet rbar*100 ibar*100 tota totk];
disp(cacca);
disp('   gdp,       k2gdp,    % bequests to gdp ');
cacca=[gdp,k2gdp,beq2gdp];
disp(cacca);
disp('--------------------------------------------------------------------');
disp('Government');
disp('Govbal');
disp(govbal);
sspay=transf*(totret-sum(prgridoe));
disp('The following are expressed as a percentage of GDP');
disp('INTPAY,  SStransf,    Gexp');
cacca=[rbar*govdebt/gdp*100,sspay/gdp*100,gfrac];
disp(cacca);
disp('tax receipts as a % of gdp ');
disp('labor tax, entr tax, assets tax, cons tax on w, cons tax on e, beq tax');
cacca=[tottaxl/gdp*100, tottaxe/gdp*100, tottaxa/gdp*100, tottaxcw/gdp*100, tottaxce/gdp*100, (tottaxbw+tottaxbe)/gdp*100];
disp(cacca);
disp(strcat('fraction paying estate taxes=',num2str(presttax)));
disp(strcat('quantile .98 of w distr of old=',num2str(esttaxcutoff)));
disp(' ');
disp('---------------- labor demand quantiles  -------------------------');
laborquant
disp(' ');
disp('------------------------ firms -----------------------------------');
disp('firm size:average and median');
disp([avgfdoll medfdoll]);
disp('------------------------------------------------------------------');
disp(' ');
disp('fraction of entr in the top x% of wealth');
disp(topquante');
disp(percqtwe);
disp(' ');
disp('------------------------------------------------------------------');
disp('CONSUMPTION')
disp('1%           5%       10%       20%       40%        60%        80%')
disp(squantcons');
disp('consumption gini');
disp(ginic);
disp('------------------------------------------------------------------');
disp('CONSUMPTION, top X% missing')
disp('1%           5%       10%       20%       40%        60%        80%')
disp(squantconscut');
disp('consumption gini');
disp(giniconscut);
disp('------------------------------------------------------------------');
disp('CONSUMPTION WORKERS')
disp('1%           5%       10%       20%       40%        60%        80%')
disp(squantcons2w')
disp('consumption gini');
disp(ginic2w);
disp('------------------------------------------------------------------');
disp('NET INCOME')
disp('1%           5%       10%       20%       40%        60%        80%')
disp(squantnetinc');
disp('net income gini');
disp(gininetinc);
disp('------------------------------------------------------------------');
disp('NET INCOME WORKERS')
disp('1%           5%       10%       20%       40%        60%        80%')
disp(squantnetinc2w');
disp('net income gini');
disp(gininetinc2w);
disp('------------------------------------------------------------------');
disp('GROSS INCOME')
disp('1%           5%       10%       20%       40%        60%        80%')
disp(squantgrossinc');
disp('gross income gini');
disp(ginigrossinc);
disp('------------------------------------------------------------------');
disp('GROSS INCOME WORKERS')
disp('1%           5%       10%       20%       40%        60%        80%')
disp(squantgrossinc2w');
disp('gross income gini');
disp(ginigrossinc2w);
disp('------------------------------------------------------------------');
disp('Excel outputs ');
excelvec
disp('------------------------------------------------------------------');
disp('Compare to SCF hiring, divide by y(2)')
qt=[0.25; 0.50; 0.75; 0.90; 0.95];
laborquant=quantili(labpole,invmlab,qt);
laborquant=[qt laborquant./y(2)]'
disp('Compare to SCF hiring, divide by y(3)')
qt=[0.25; 0.50; 0.75; 0.90; 0.95];
laborquant=quantili(labpole,invmlab,qt);
laborquant=[qt laborquant./y(3)]'
disp('------------------------------------------------------------------');

disp('');
diary off;

% This piece that produces Figures 2 and 3 is based on graphDEC06 and is
% based on the JPE code

dopdf=1;
blackandwhite=0; % =1 means figures will be in black and white
if blackandwhite==1,
    set(0,'DefaultAxesColorOrder',[0 0 0])
    suffix='2ndroundbw'; % This is appended at the end of the file names to distinguish
        % its role
else,
    suffix='2ndround';
end;


nfig=1;
% graphs

percsup=.085
%%%%%%%%%%%%%%%%%%%%%% load DATA SCF89
%order of variables in file scf89_1.txt
%X1	X3128	X3228	X3328	XX1	BUS	NETWORTH 	yrint	wt	hasbus	actbus	age	selfe	selfep	
%bus1	bus2	bus3	busotr	gh	totvalb2	totvalb3	totvalb	typeb1	howacq1	yreduc
load scf89dat_1.txt;
i=1;
X1=scf89dat_1(:,i); i=i+1;
X3128	=scf89dat_1(:,i); i=i+1;
X3228	=scf89dat_1(:,i); i=i+1;
X3328	=scf89dat_1(:,i); i=i+1;
XX1	=scf89dat_1(:,i); i=i+1;
bus	=scf89dat_1(:,i); i=i+1;
networth=scf89dat_1(:,i); i=i+1;
yrint	=scf89dat_1(:,i); i=i+1;
wt	=scf89dat_1(:,i); i=i+1;
hasbus=scf89dat_1(:,i); i=i+1;	
actbus=scf89dat_1(:,i); i=i+1;	
age	=scf89dat_1(:,i); i=i+1;
selfe	=scf89dat_1(:,i); i=i+1;
selfep=scf89dat_1(:,i); i=i+1;	
bus1	=scf89dat_1(:,i); i=i+1;
bus2	=scf89dat_1(:,i); i=i+1;
bus3	=scf89dat_1(:,i); i=i+1;
busotr=scf89dat_1(:,i); i=i+1;	
gh	=scf89dat_1(:,i); i=i+1;
totvalb2=scf89dat_1(:,i); i=i+1;	
totvalb3=scf89dat_1(:,i); i=i+1;	
totvalb=scf89dat_1(:,i); i=i+1;	
typeb1=scf89dat_1(:,i); i=i+1;	
howacq1=scf89dat_1(:,i); i=i+1;	
yreduc=scf89dat_1(:,i); i=i+1;

networth=networth/1000;
weight=wt/sum(wt);

netsup=5000;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%% baseline wealth and data
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure(nfig); nfig=nfig+1;

networthbench=a*incdoll;
%create a sort of histogram
[netdat,wdat]=distwhist(networth,weight,100,20000);
%it may be useful to rearrange the simulations as well
[netbench,wbench]=distwhist(networthbench,prgrid,100,20000);

plot(netbench,wbench,'-',netdat,wdat,'--');
axis([0 netsup 0 percsup]);
set(gca,'FontSize',16,'FontName','Times New Roman');
xlabel('Positive wealth, in thousands of dollars');
ylabel('Fraction of people');
legend('Model','Data');
fname=['benchdisttJuly_2013' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;
figure;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%% plot wealth distribution entrepreneurs, baseline and data
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%entrepreneurs GH
figure(nfig); nfig=nfig+1;
perce=sum(prgridye+prgridoe);
fid=find(actbus==1 & bus>0);
weightGH=weight(fid);
percGH=sum(weightGH);
networthGH=networth(fid);
[netdatGH,wdatGH]=distwhist(networthGH,weightGH/percGH,100,20000);
%it may be useful to rearrange the simulations as well
[netbenchGH,wbenchGH]=distwhist(networthbench,(prgridye+prgridoe)/perce,100,20000);

plot(netbenchGH,wbenchGH,'-',netdatGH,wdatGH,'--');
axis([0 netsup 0 percsup]);
set(gca,'FontSize',16,'FontName','Times New Roman');
xlabel('Positive wealth, in thousands of dollars');
ylabel('Fraction of people');
legend('Model','Data');
fname=['benchdisteJuly_2013' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;
figure;

% COMPARE WITH ALTERNATIVE STEADY STATE
load -ascii valfun2;
datavec=valfun2; 
clear valfun2;


% load and define data from fortran ascii file
% (including some parameters, various value functions and policy
% functions, and various measures of gross income)
da=datavec(1);
dy=datavec(2);
dr=datavec(3);
dk=datavec(4);
datavec=datavec(5:length(datavec));
a=datavec(1:da);
y=datavec(da+1:da+dy);
r=datavec(da+dy+1:da+dy+dr);
k=datavec(da+dy+dr+1:da+dy+dr+dk);
datavec=datavec(da+dy+dr+dk+1:length(datavec));
Vy2=zeros(da,dy,dr);
for i=1:da,
	for j=1:dy,
		for jj=1:dr,
			Vy2(i,j,jj)=datavec(jj+(j-1)*dr+(i-1)*dr*dy);
		end; % i
	end; % j0
end;% k
datavec=datavec(da*dr*dy+1:length(datavec));
Vyw2=zeros(da,dy,dr);
for i=1:da,
	for j=1:dy,
		for jj=1:dr,
         Vyw2(i,j,jj)=datavec(jj+(j-1)*dr+(i-1)*dr*dy);
      end; % i
   end; % j0
end;% k
datavec=datavec(da*dr*dy+1:length(datavec));
Vye2=zeros(da,dy,dr);
for i=1:da,
	for j=1:dy,
		for jj=1:dr,
         Vye2(i,j,jj)=datavec(jj+(j-1)*dr+(i-1)*dr*dy);
      end; % i
   end; % j0
end;% k
datavec=datavec(da*dr*dy+1:length(datavec));
Vow2=datavec(1:da);
datavec=datavec(da+1:length(datavec));
Voe2=zeros(da,dr);
for i=1:da,
	for jj=1:dr,
   	Voe2(i,jj)=datavec(jj+(i-1)*dr);
   end; % i
end;% k
datavec=datavec(da*dr+1:length(datavec));
Voee2=zeros(da,dr);
for i=1:da,
	for jj=1:dr,
   	Voee2(i,jj)=datavec(jj+(i-1)*dr);
   end; % i
end;% k
datavec=datavec(da*dr+1:length(datavec));
Vokeff2=datavec(1:dk);
datavec=datavec(dk+1:length(datavec));
counter=1;
apoly2=zeros(da,dy,dr);
for i=1:da
	for j=1:dy
		for jj=1:dr
         apoly2(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
kpoly2=zeros(da,dy,dr)-1;
for i=1:da
	for j=1:dy
		for jj=1:dr
         kpoly2(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
apolye2=zeros(da,dy,dr);
for i=1:da
	for j=1:dy
		for jj=1:dr
         apolye2(i,j,jj)=datavec(counter);
   	     counter=counter+1;
	   end;
	end;
end;
kpolye2=zeros(da,dy,dr)-1;
for i=1:da
	for j=1:dy
		for jj=1:dr
         kpolye2(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
apolyw2=zeros(da,dy,dr);
for i=1:da
	for j=1:dy
		for jj=1:dr
         apolyw2(i,j,jj)=datavec(counter);
   	     counter=counter+1;
	   end;
	end;
end;
apolow2=zeros(da,1);
for i=1:da
   apolow2(i)=datavec(counter);
   counter=counter+1;
end;
apolownet2=zeros(da,1);
for i=1:da
   apolownet2(i)=datavec(counter);
   counter=counter+1;
end;
apoloe2=zeros(da,dr);
for i=1:da
	for jj=1:dr
      apoloe2(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;
apoloenet2=zeros(da,dr);
for i=1:da
	for jj=1:dr
      apoloene2t(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;
kpoloe2=zeros(da,dr)-1;
for i=1:da
	for jj=1:dr
      kpoloe2(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;
kyhat2=zeros(da,dy,dr)-1;
for i=1:da
	for j=1:dy
		for jj=1:dr
         kyhat2(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
kohat2=zeros(da,dr)-1;
for i=1:da
	for jj=1:dr
      kohat2(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;
labpoly2=zeros(da,dy,dr);
for i=1:da
	for j=1:dy
		for jj=1:dr
         labpoly2(i,j,jj)=datavec(counter);
         counter=counter+1;
		end;
	end;
end;
labpoloe2=zeros(da,dr);
for i=1:da
	for jj=1:dr
      labpoloe2(i,jj)=datavec(counter);
      counter=counter+1;
	end;
end;

% study borrowing constraints IN BASELINE AND ALTERNATIVE CALIBRATION

j=60;
i=1;
plot(a(i:j),a(squeeze(kpolye(i:j,3,2))),'-',a(i:j),a(squeeze(kpolye2(i:j,3,2))),'--');
axis tight;
grid;
set(gca,'FontSize',16,'FontName','Times New Roman');
xlabel('Net worth');
title('Entrepreneurial investment');
legend('Looser borr.const.','Tighter borr. const.','Location','SouthEast');
fname=['invcompJuly_2013' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;
figure;


j=60;
i=1;
plot(a(i:j),a(squeeze(kpolye(i:j,3,2)))./a(i:j),a(i:j),a(squeeze(kpolye2(i:j,3,2)))./a(i:j),'--');
axis tight;
grid;
set(gca,'FontSize',16,'FontName','Times New Roman');
xlabel('Net worth');
title('Leverage');
legend('Looser borr.const.','Tighter borr. const.','Location','SouthEast');
fname=['leveragecompJuly_2013' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

