% This code coordinates the production of all transition graphs, except
% those that involve experiments with exogenous borrowing constraints

blackandwhite=0; % =1 means figures will be in black and white
if blackandwhite==1,
    set(0,'DefaultAxesColorOrder',[0 0 0])
    suffix='2ndroundbw'; % This is appended at the end of the file names to distinguish
        % its role
else,
    suffix='2ndround';
end;

remotedirectory=1; % if =1, trans201307.m is not put in the same directory as the experiment,
    % but is kept instead in the text directory and run from there. This
    % program then provides an appropriate environment variable that
    % changes the directory to where trans201307.m should get its input
preventplots=1; % if different from 0, it avoids creating a million Matlab figures, and simply creates them
    % in eps format (and pdf, if the appropriate option is chosen)
dopdf=1; % =1 calls epstopdf to convert eps files into pdf
% Some properties to make graphs look nice

set(0,'DefaultLineLineWidth',2,'DefaultAxesFontSize',16,'DefaultAxesFontName','Times New Roman');

% Define variables to create a loop over experiments and automate
% repetitive commands
direxperiment={'../phi__/AGPE',...
               '../phi__/AGGE',...
               '../phi__/ATGE';...
               '../phixi/AGPE',...
               '../phixi/AGGE',...
               '../phixi/ATGE';...
               '../eff__/AGPE',...
               '../eff__/AGGE',...
               '../eff__/ATGE';...
               '../tfp__/AGPE',...
               '../tfp__/AGGE',...
               '../tfp__/ATGE'};

expername={'phi'; 'phixi'; 'eff'; 'tfp'};
lenexpname=length(expername);

% Note that some of these suffixes are hard coded in the program, since the
% plots would not make sense if we change the order of the choices or we
% add new ones. Every time we do so the entire code should be reevaluated.
% All the instances of hard coding occur in the graphs
expersuffix={'PEadjG'; 'GEadjG'; 'GE'};
lensuffix=length(expersuffix);

if (lenexpname~=size(direxperiment,1) | lensuffix~=size(direxperiment,2))
    error('Label mismatch between directories of experiments and names of variables');
end;

varname={'gdpT'; 'totentrT'; 'avgkT'; 'aggrconsgoodsT'; 'ibarpath'; 'rbarpath';...
    'aggrinvestT'; 'taubalpathT'; 'govdebtT'; 'govprimsurpT'; 'govtotsurpT';...
    'gdpcorpT'; 'gdpentrT'; 'capintermedT'; 'intermedcostT'; 'hiredlabeT'; 'totlcorpT'};
% Note that government debt is nonsense in experiments that do not balance
% the budget constraint
lenvarname=length(varname);

labelname={'GDP'; 'Entrepreneurs'; 'Average Firm Size'; 'Consumption'; 'Interest rate (%)'; 'Interest rate (%)';...
    'Investment'; 'Tax rate (%)'; 'Government Debt'; 'Primary Surplus'; 'Government Surplus';...
    'Output'; 'Output'; 'Capital Intermediated'; 'Total Intermediation Costs'; 'Labor Hired by Entrepreneurs';...
    'Labor Hired by Corporate Sector'};
if length(labelname)~=lenvarname,
    error('Mismatch between variables and their labels for the graph');
end;

for ip=1:lenexpname,
    for jp=1:lensuffix,
        parentdir=pwd; % Grab current directory, to which we return
        newdir=char(direxperiment(ip,jp));
        trans201307;
 
        for kp=1:lenvarname, % Grab relevant variables and save them with an appropriate suffix
            % Example of line below: gdpTphiPEnoGVT=gdpT
            eval([char(varname(kp)) char(expername(ip)) char(expersuffix(jp)) '=' char(varname(kp))]);
        end;
    end;
end;

%  Plots for the phi experiment

plot(1:Ttransplot,100*gdpcorpTphiGEadjG(1:Ttransplot)/gdpcorpTphiGEadjG(1),'-',...
    1:Ttransplot,100*gdpentrTphiGEadjG(1:Ttransplot)/gdpentrTphiGEadjG(1),'--');
set(gca,'FontSize',16,'FontName','Times New Roman');
xlabel('Time');
xlabel('Value added across sectors');
title('Value added across sectors when spending adjusts');
grid; legend('Corporate', 'Entrepreneurial','Location','SouthEast'); axis([1 35 93.5 103]);
fname=['transsectorsphiGEadjG' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

if preventplots==0,figure;end;
plot(1:Ttransplot,100*gdpcorpTphiGE(1:Ttransplot)/gdpcorpTphiGEadjG(1),'-',...
    1:Ttransplot,100*gdpentrTphiGE(1:Ttransplot)/gdpentrTphiGEadjG(1),'--');
set(gca,'FontSize',16,'FontName','Times New Roman');
xlabel('Time');
title('Value added across sectors when taxes adjust');
grid; legend('Corporate', 'Entrepreneurial','Location','SouthEast'); axis([1 35 93.5 103]);
fname=['transsectorsphiGE' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

if preventplots==0,figure;end;
plot(1:Ttransplot,ibarpathphiPEadjG(1:Ttransplot),'-',...
    1:Ttransplot,ibarpathphiGEadjG(1:Ttransplot),'--',...
    1:Ttransplot,rbarpathphiPEadjG(1:Ttransplot),':',...
    1:Ttransplot,rbarpathphiGEadjG(1:Ttransplot),'-.');
xlabel('Time');
title('Interest rate');
grid;legend('Lending, PE', 'Lending, GE','Borrowing, PE','Borrowing, GE','Location','SouthEast'); axis tight;
fname=['transibarpathphi' suffix 'adjG.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

if preventplots==0,figure;end;
plot(1:Ttransplot,100*totentrTphiPEadjG(1:Ttransplot)/totentrTphiPEadjG(1),'-',...
    1:Ttransplot,100*totentrTphiGEadjG(1:Ttransplot)/totentrTphiPEadjG(1),'--',...
    1:Ttransplot,100*totentrTphiGE(1:Ttransplot)/totentrTphiPEadjG(1),':');
xlabel('Time');
title('Number of entrepreneurs');
axis([1 Ttransplot 94 100.5]);
grid; legend('PE, g adjusts', 'GE, g adjusts','GE, tax adjusts','Location','SouthEast');
fname=['transtotentrTphi' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

if preventplots==0,figure;end;
plot(1:Ttransplot,100*avgkTphiPEadjG(1:Ttransplot)/avgkTphiPEadjG(1),'-',...
    1:Ttransplot,100*avgkTphiGEadjG(1:Ttransplot)/avgkTphiPEadjG(1),'--',...
    1:Ttransplot,100*avgkTphiGE(1:Ttransplot)/avgkTphiPEadjG(1),':');
xlabel('Time');
title('Average firm size');
axis([1 Ttransplot 94 100.5]);
grid; legend('PE, g adjusts', 'GE, g adjusts','GE, tax adjusts','Location','SouthEast');
fname=['transavgkTphi' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;


if preventplots==0,figure;end;
if blackandwhite==0,
    plot(1:Ttransplot,100*hiredlabeTphiGEadjG(1:Ttransplot)*totlcorpTphiGEadjG(1)...
        ./(hiredlabeTphiGEadjG(1)*totlcorpTphiGEadjG(1:Ttransplot)),'--','Color',[0 0.5 0]);
else
    plot(1:Ttransplot,100*hiredlabeTphiGEadjG(1:Ttransplot)*totlcorpTphiGEadjG(1)...
        ./(hiredlabeTphiGEadjG(1)*totlcorpTphiGEadjG(1:Ttransplot)),'--');
end;
xlabel('Time');
ylabel('Relative Employment');
grid; axis tight;
fname=['transrelempTphiGEadjG' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

if preventplots==0,figure;end;
if blackandwhite==0,
    plot(1:Ttransplot,100*hiredlabeTphiGE(1:Ttransplot)*totlcorpTphiGEadjG(1)...
        ./(hiredlabeTphiGE(1)*totlcorpTphiGEadjG(1:Ttransplot)),':','Color',[1 0 0]);
else
    plot(1:Ttransplot,100*hiredlabeTphiGE(1:Ttransplot)*totlcorpTphiGEadjG(1)...
        ./(hiredlabeTphiGE(1)*totlcorpTphiGEadjG(1:Ttransplot)),':');
end;    
xlabel('Time');
ylabel('Relative Employment');
grid; axis tight;
fname=['transrelempTphiGE' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

if preventplots==0,figure;end;
plot(1:Ttransplot,100*gdpTphiPEadjG(1:Ttransplot)/gdpTphiPEadjG(1),'-',...
    1:Ttransplot,100*gdpTphiGEadjG(1:Ttransplot)/gdpTphiPEadjG(1),'--',...
    1:Ttransplot,100*gdpTphiGE(1:Ttransplot)/gdpTphiPEadjG(1),':');
xlabel('Time');
title('GDP');
axis tight;
grid; legend('PE, g adjusts', 'GE, g adjusts','GE, tax adjusts','Location','SouthEast');
fname=['transgdpTphi' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

if preventplots==0,figure;end;
plot(1:Ttransplot,100*aggrconsgoodsTphiPEadjG(1:Ttransplot)/aggrconsgoodsTphiPEadjG(1),'-',...
    1:Ttransplot,100*aggrconsgoodsTphiGEadjG(1:Ttransplot)/aggrconsgoodsTphiPEadjG(1),'--',...
    1:Ttransplot,100*aggrconsgoodsTphiGE(1:Ttransplot)/aggrconsgoodsTphiPEadjG(1),':');
xlabel('Time');
title('Consumption');
axis tight;
grid; legend('PE, g adjusts', 'GE, g adjusts','GE, tax adjusts','Location','SouthEast');
fname=['transaggrconsgoodsTphi' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

% Note that investment must be normalized by its GE value, since the
% shipment of capital overseas in PE makes investment jump one period
% ahead.

if preventplots==0,figure;end;
if blackandwhite==0,
    plot(1:Ttransplot,100*aggrinvestTphiGEadjG(1:Ttransplot)/aggrinvestTphiGEadjG(1),...
        '--','Color',[0 0.5 0]);
    hold on;
    plot(1:Ttransplot,100*aggrinvestTphiGE(1:Ttransplot)/aggrinvestTphiGEadjG(1),...
        ':','Color',[1 0 0]);
else
    plot(1:Ttransplot,100*aggrinvestTphiGEadjG(1:Ttransplot)/aggrinvestTphiGEadjG(1),...
        '--');
    hold on;
    plot(1:Ttransplot,100*aggrinvestTphiGE(1:Ttransplot)/aggrinvestTphiGEadjG(1),...
        ':');
end;
xlabel('Time');
title('Investment');
axis tight;
grid; legend('GE, g adjusts','GE, tax adjusts','Location','SouthEast');
fname=['transaggrinvestTphi' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;
hold off;

% Comparing phi and phi,xi experiment

if preventplots==0,figure;end;
plot(1:Ttransplot,100*totentrTphixiGEadjG(1:Ttransplot)/totentrTphiPEadjG(1),'-',...
    1:Ttransplot,100*totentrTphiGEadjG(1:Ttransplot)/totentrTphiPEadjG(1),'--');
xlabel('Time');
title('Number of entrepreneurs');
axis([1 Ttransplot 97 100.5]);
grid; legend('Shock to \phi and \xi', 'Shock to \phi','Location','SouthEast');
fname=['comptotentrTphixiGEadjG' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

if preventplots==0,figure;end;
plot(1:Ttransplot,100*avgkTphixiGEadjG(1:Ttransplot)/avgkTphiPEadjG(1),'-',...
    1:Ttransplot,100*avgkTphiGEadjG(1:Ttransplot)/avgkTphiPEadjG(1),'--');
xlabel('Time');
title('Average firm size');
axis([1 Ttransplot 97 100.5]);
grid; legend('Shock to \phi and \xi', 'Shock to \phi','Location','SouthEast');
fname=['compavgkTphixiGEadjG' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

% Note that investment must be normalized by its GE value, since the
% shipment of capital overseas in PE makes investment jump one period
% ahead.

if preventplots==0,figure;end;
plot(1:Ttransplot,100*aggrinvestTphixiGEadjG(1:Ttransplot)/aggrinvestTphiGEadjG(1),'-',...
    1:Ttransplot,100*aggrinvestTphiGEadjG(1:Ttransplot)/aggrinvestTphiGEadjG(1),'--');
xlabel('Time');
title('Investment');
axis tight;
grid; legend('Shock to \phi and \xi', 'Shock to \phi','Location','SouthEast');
fname=['compaggrinvestTphixiGEadjG' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

plot(1:Ttransplot,100*gdpcorpTphixiGEadjG(1:Ttransplot)/gdpcorpTphiGEadjG(1),'-',...
    1:Ttransplot,100*gdpentrTphixiGEadjG(1:Ttransplot)/gdpentrTphiGEadjG(1),'--');
set(gca,'FontSize',16,'FontName','Times New Roman');
xlabel('Time');
title('Value added across sectors when spending adjusts');
grid; legend('Corporate', 'Entrepreneurial','Location','SouthEast'); axis tight;
fname=['transsectorsphixiGEadjG' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

if preventplots==0,figure;end;
plot(1:Ttransplot,100*gdpTphixiGEadjG(1:Ttransplot)/gdpTphiPEadjG(1),'-',...
    1:Ttransplot,100*gdpTphiGEadjG(1:Ttransplot)/gdpTphiPEadjG(1),'--');
xlabel('Time');
title('GDP');
axis tight;
grid; legend('Shock to \phi and \xi', 'Shock to \phi','Location','SouthEast');
fname=['compgdpTphixiGEadjG' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

% Comparing shock to f and to phi

if preventplots==0,figure;end;
plot(1:Ttransplot,100*gdpTeffGEadjG(1:Ttransplot)/gdpTphiPEadjG(1),'-',...
    1:Ttransplot,100*gdpTphiGEadjG(1:Ttransplot)/gdpTphiPEadjG(1),'--');
xlabel('Time');
title('GDP');
axis tight;
grid; legend('Shock to f', 'Shock to \phi','Location','SouthEast');
fname=['compgdpTeffGEadjG' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

if preventplots==0,figure;end;
plot(1:Ttransplot,100*totentrTeffGEadjG(1:Ttransplot)/totentrTphiPEadjG(1),'-',...
    1:Ttransplot,100*totentrTphiGEadjG(1:Ttransplot)/totentrTphiPEadjG(1),'--');
xlabel('Time');
title('Number of entrepreneurs');
axis([1 Ttransplot 92.5 100.5]);
grid; legend('Shock to f', 'Shock to \phi','Location','SouthEast');
fname=['comptotentrTeffGEadjG' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

if preventplots==0,figure;end;
plot(1:Ttransplot,100*avgkTeffGEadjG(1:Ttransplot)/avgkTphiPEadjG(1),'-',...
    1:Ttransplot,100*avgkTphiGEadjG(1:Ttransplot)/avgkTphiPEadjG(1),'--');
xlabel('Time');
title('Average firm size');
axis([1 Ttransplot 92.5 100.5]);
grid; legend('Shock to f', 'Shock to \phi','Location','SouthEast');
fname=['compavgkTeffGEadjG' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

% Comparing shock to TFP and to phi

if preventplots==0,figure;end;
plot(1:Ttransplot,100*gdpTtfpGEadjG(1:Ttransplot)/gdpTphiPEadjG(1),'-',...
    1:Ttransplot,100*gdpTphiGEadjG(1:Ttransplot)/gdpTphiPEadjG(1),'--');
xlabel('Time');
title('GDP');
axis tight;
grid; legend('Shock to TFP', 'Shock to \phi','Location','SouthEast');
fname=['compgdpTtfpGEadjG' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

if preventplots==0,figure;end;
plot(1:Ttransplot,100*totentrTtfpGEadjG(1:Ttransplot)/totentrTphiPEadjG(1),'-',...
    1:Ttransplot,100*totentrTphiGEadjG(1:Ttransplot)/totentrTphiPEadjG(1),'--');
xlabel('Time');
title('Number of entrepreneurs');
axis([1 Ttransplot 97.5 100.5]);
grid; legend('Shock to TFP', 'Shock to \phi','Location','SouthEast');
fname=['comptotentrTtfpGEadjG' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

if preventplots==0,figure;end;
plot(1:Ttransplot,100*avgkTtfpGEadjG(1:Ttransplot)/avgkTphiPEadjG(1),'-',...
    1:Ttransplot,100*avgkTphiGEadjG(1:Ttransplot)/avgkTphiPEadjG(1),'--');
xlabel('Time');
title('Average firm size');
axis([1 Ttransplot 97.5 100.5]);
grid; legend('Shock to TFP', 'Shock to \phi','Location','SouthEast');
fname=['compavgkTtfpGEadjG' suffix '.eps'];
eval(['print -depsc ' fname]);
if dopdf==1,
    eval(['!epstopdf ' fname]);
end;

