function [gini,squants,absass]=giniperc(invmunsort,invmprop,sp);
%computes gini coeff and certain top quantiles for invmunsort
%%%%%%%%%%%%% lorenz curve plot (cumulative cons plotted against
% cumulative number of agents; both normalized to one)
% the function also sorts the data

[invmsorted,invx]=sort(invmunsort);
invmpropsorted=invmprop(invx);
% note: we may have to worry about same consumption levels
sizeinvm=length(invmunsort);
cumdist=cumsum(invmpropsorted); % this is the cumulative number of agents
cums=cumsum(invmsorted.*invmpropsorted)/sum(invmsorted.*invmpropsorted); 


% this is cumulative wealth
%plot(cumdist,cumwealth);
%axis([0 1 0 1]);
%title('Wealth Lorenz Curve');
%xlabel('Cumulative fraction of agents');
%ylabel('Cumulative fraction of wealth');

%%%%%%%%%%%%%% gini index
% the area under the lorenz curve is composed by trapeziums:
%          |c
% b |      |
%   |      |
% a |      |d
% whose area is (cd+ba)*ad/2.
% the formula for the gini index given by the ratio of the
% area between the 45 degree line and the the lorenz curve divided by
% the total area under the 45 degree line: 
% (1/2 - \sum_{i=1}^{da-1}(w(i+1)+w(i))*(cumdist(i+1)-cumdist(i))/2)/(1/2)=
% 1-\sum_{i=1}^{da-1}(w(i+1)+w(i))*(cumdist(i+1)-cumdist(i))
area=0;
for i=1:sizeinvm-1,
   area=area+(cums(i+1)+cums(i))*(cumdist(i+1)-cumdist(i));
end;
gini=1-area;
tops=[cumsum(flipud(invmsorted.*invmpropsorted/sum(invmsorted.*invmpropsorted))) cumsum(flipud(invmpropsorted))];
squants=interp1q(tops(:,2),tops(:,1),sp)*100;
% consumption by top 2% and 5%
i=min(find(cumdist>=.98));
j=min(find(cumdist>=.95));
absass=[cumdist(i) invmsorted(i) cumdist(j) invmsorted(j)];
