% This code compares the experiments with endogenous vs. exogenous
% borrowing constraints

blackandwhite=0; % =1 means figures will be in black and white
if blackandwhite==1,
    set(0,'DefaultAxesColorOrder',[0 0 0])
    set(0,'DefaultAxesLineStyleOrder','-|--|:|-.')
end;

suffix='paper'; % This is appended at the end of the file names to distinguish
% its role

remotedirectory=1; % if =1, trans201307.m is not put in the same directory as the experiment,
    % but is kept instead in the text directory and run from there. This
    % program then provides an appropriate environment variable that
    % changes the directory to where transXX.m should get its input
    % remotedirectory should always be 1 for this code
preventplots=1; % if different from 0, it avoids creating a million Matlab figures, and simply creates them
    % in eps format (and pdf, if the appropriate option is chosen)
dopdf=1; % =1 calls epstopdf to convert eps files into pdf
% Some properties to make graphs look nice
set(0,'DefaultLineLineWidth',2,'DefaultAxesFontSize',16,'DefaultAxesFontName','Times New Roman');

% Define variables to create a loop over experiments and automate
% repetitive commands
direxperiment={'../phi__/AGPE',...
    '../phi__/AGGE',...
    '../phi__/ATGE';...
    '../../Transexo/phi__/AGPE',...
    '../../Transexo/phi__/AGGE',...
    '../../Transexo/phi__/ATGE'};

expername={'endo'; 'exo'};
lenexpname=length(expername);

% Note that some of these suffixes are hard coded in the program, since the
% plots would not make sense if we change the order of the choices or we
% add new ones. Every time we do so the entire code should be reevaluated.
% All the instances of hard coding occur in the graphs
expersuffix={'PEadjG'; 'GEadjG'; 'GE'};
lensuffix=length(expersuffix);

if (lenexpname~=size(direxperiment,1) | lensuffix~=size(direxperiment,2))
    error('Label mismatch between directories of experiments and names of variables');
end;

varname={'gdpT'; 'totentrT'; 'avgkT'; 'aggrconsgoodsT'; 'ibarpath'; 'rbarpath';...
    'aggrinvestT'; 'taubalpathT'; 'govdebtT'; 'govprimsurpT'; 'govtotsurpT';...
    'gdpcorpT'; 'gdpentrT'; 'capintermedT'; 'intermedcostT'; 'hiredlabeT'; 'totlcorpT'};
% Note that government debt is nonsense in experiments that do not balance
% the budget constraint
lenvarname=length(varname);

% Plotindex=0 does not produce a plot of the variable for each type of
% shock
% Plotindex=1 produces two plots: one in PE and GE with government spending
% adjustment, and one with all three experiments
% Plotindex=2 produces a single plot of the GE case with endogenous taxes,
% in the appropriate color (red)
plotindex=[1; 1; 1; 1; 0; 0; 0; 2; 2; 2; 2; 1; 1; 1; 1; 0; 0];
if length(plotindex)~=lenvarname,
    error('Mismatch between variables and instructions for plots');
end;

% Variable for normalization
% Normvar=1: normalized by the same variable, set at 100 in SS
% Normvar=2: normalized by SS GDP
% Otherwise (Normvar=0): not normalized
normvar=[1; 1; 1; 1; 0; 0; 1; 0; 1; 2; 2; 1; 1; 1; 1; 1; 1];
if length(normvar)~=lenvarname,
    error('Mismatch between variables and instructions for normalization');
end;

% Special handling is not used by the code, but it is a reminder that, for
% the variables for which it is 1, something special is hard-coded in the
% graph (e.g., special requirement for the axis)
specialhandling=[0; 0; 0; 0; 1; 1; 1; 0; 0; 1; 1; 0; 0; 0; 0; 0; 0];
if length(specialhandling)~=lenvarname,
    error('Mismatch between variables and special handling reminder');
end;

labelname={'GDP'; 'Entrepreneurs'; 'Average Firm Size'; 'Consumption'; 'Interest rate (%)'; 'Interest rate (%)';...
    'Investment'; 'Tax rate (%)'; 'Government Debt'; 'Primary Surplus'; 'Government Surplus';...
    'Output'; 'Output'; 'Capital Intermediated'; 'Total Intermediation Costs'; 'Labor Hired by Entrepreneurs';...
    'Labor Hired by Corporate Sector'};
if length(labelname)~=lenvarname,
    error('Mismatch between variables and their labels for the graph');
end;

for ip=1:lenexpname,
    for jp=1:lensuffix,
        parentdir=pwd; % Grab current directory, to which we return
        newdir=char(direxperiment(ip,jp));
        trans201307;
        for kp=1:lenvarname, % Grab relevant variables and save them with an appropriate suffix
            % Example of line below: gdpTphiPEnoGVT=gdpT
            eval([char(varname(kp)) char(expername(ip)) char(expersuffix(jp)) '=' char(varname(kp))]);
        end;
    end;
end;


for ip=1:lenexpname,
    
    for kp=1:lenvarname,
        if plotindex(kp)==1,
            if normvar(kp)==1,
                normstring=['/' char(varname(kp)) char(expername(ip)) char(expersuffix(1)) '(1)'];
            elseif normvar(kp)==2,
                normstring=['/gdpT' char(expername(ip)) char(expersuffix(1)) '(1)'];
            else,
                normstring='';
            end;
            if preventplots==0,figure;end;
    
            if ip>1,
                if preventplots==0,figure;end;
                eval(['plot(1:Ttransplot,[100*' char(varname(kp)) char(expername(ip)) char(expersuffix(2)) '(1:Ttransplot)'...
                ' 100*' char(varname(kp)) char(expername(1)) char(expersuffix(2)) '(1:Ttransplot)]' normstring ')']);
% set(gca,'FontSize',16,'FontName','Times New Roman');
                xlabel('Time');
                ylabel(char(labelname(kp)));
                grid;
%                if kp==2,
%                    axis([1 Ttransplot 98 102]);
%                else,
                    axis tight;
%                end;
                fname=['comp' char(varname(kp)) char(expername(ip)) 'GEadjG' suffix '.eps'];
                eval(['print -depsc ' fname]);
                if dopdf==1,
                    eval(['!epstopdf ' fname]);
                end;
    
                if preventplots==0,figure;end;
                eval(['plot(1:Ttransplot,[100*' char(varname(kp)) char(expername(ip)) char(expersuffix(lensuffix)) '(1:Ttransplot)'...
                    ' 100*' char(varname(kp)) char(expername(1)) char(expersuffix(lensuffix)) '(1:Ttransplot)]' normstring ')']);
% set(gca,'FontSize',16,'FontName','Times New Roman');
                xlabel('Time');
                ylabel(char(labelname(kp)));
                grid;
%                if kp==2,
%                    axis([1 Ttransplot 98 102]);
%                else,
                    axis tight;
%                end;
                fname=['comp' char(varname(kp)) char(expername(ip)) suffix '.eps'];
                eval(['print -depsc ' fname]);
                if dopdf==1,
                    eval(['!epstopdf ' fname]);
                end;
            end;
        elseif plotindex(kp)==2,
            if ip>1,
                if preventplots==0,figure;end;
                eval(['plot(1:Ttransplot,[100*' char(varname(kp)) char(expername(ip)) char(expersuffix(lensuffix)) '(1:Ttransplot)'...
                    ' 100*' char(varname(kp)) char(expername(1)) char(expersuffix(lensuffix)) '(1:Ttransplot)]' normstring ')']);
% set(gca,'FontSize',16,'FontName','Times New Roman');
                xlabel('Time');
                ylabel(char(labelname(kp)));
                grid; axis tight;
                fname=['comp' char(varname(kp)) char(expername(ip)) suffix '.eps'];
                eval(['print -depsc ' fname]);
                if dopdf==1,
                    eval(['!epstopdf ' fname]);
                end;
            end;
        end;
    end;
    
    % Aggregate investment requires GE for the initial period, since in PE
    % it jumps even in period 1; also, a graph is produced without PE,
    % since PE produces crazy swings
      
    if ip>1,
        if preventplots==0,figure;end;
        eval(['plot(1:Ttransplot,[100*aggrinvestT' char(expername(ip)) char(expersuffix(2)) '(1:Ttransplot)'...
            ' 100*aggrinvestT' char(expername(1)) char(expersuffix(2)) '(1:Ttransplot)]/aggrinvestT'...
            char(expername(1)) char(expersuffix(lensuffix)) '(1))']);
% set(gca,'FontSize',16,'FontName','Times New Roman');
        xlabel('Time');
        ylabel('Investment');
        grid; axis tight;
        fname=['compaggrinvestT' char(expername(ip)) 'GEadjG' suffix '.eps'];
        eval(['print -depsc ' fname]);
        if dopdf==1,
            eval(['!epstopdf ' fname]);
        end;
    
        if preventplots==0,figure;end;
        eval(['plot(1:Ttransplot,[100*aggrinvestT' char(expername(ip)) char(expersuffix(lensuffix)) '(1:Ttransplot)'...
            ' 100*aggrinvestT' char(expername(1)) char(expersuffix(lensuffix)) '(1:Ttransplot)]/aggrinvestT'...
            char(expername(1)) char(expersuffix(lensuffix)) '(1))']);
% set(gca,'FontSize',16,'FontName','Times New Roman');
        xlabel('Time');
        ylabel('Investment');
        grid; axis tight;
        fname=['compaggrinvestT' char(expername(ip)) suffix '.eps'];
        eval(['print -depsc ' fname]);
        if dopdf==1,
            eval(['!epstopdf ' fname]);
        end;
    end;    

end;