function [ptx,wt]=distwhist(x,w,npt,xmax);
%lumps together gridpoints and their weight for plotting purposes
%
%   NOTE : versions previous to 26 aug 03 were wrong
%assumes it's wealth, so that the first gridpoint is zero
%and the other points are (linspace(sqrt))^2
%input:	x 		vector of 	gridpoints
%		w 				weights
%		npts		number of desired points
%		xmax		maximum gridpoint (nb all points greater than xmax are ignored)
%output:	ptx		new gridpoints
%		wt		new weights
%
%nb:	extremebin is the midpoint (in the transformed scale) between two gridpoints 
%	used to assign the points in x to the corresponding point in pts
%	a point in x is assigned to ptx(i+1) it it is extremebin(i) < x < extremebin(i+1)
%   pt(1) and xpt(1) are xmin and the fraction at xmin (or below)
%
% pt(1)        pt(2)            pt(3)
% extremebin(1)     extremebin(2)   extremebin(3)
% =     <             <=    <         <=    <  
% wt(1)     wt(2)                wt(3)     

xmin=0;		%assumes xmin is zero
%create non-equally spaced grid with more points near zero
xsqmax=sqrt(xmax);
extremembin=zeros(npt,1);	
ptx=zeros(npt,1);
extremebin=linspace(xmin,xsqmax,npt);
ptx(1)=xmin;
ptx(2:npt)=extremebin(1:npt-1)+ .5*(extremebin(2)-extremebin(1));
extremebin=extremebin.^2;
ptx=ptx.^2;
%create new weights
wt=zeros(npt,1);
for i=1:npt-1;
	fid=find( x>extremebin(i) & x<=extremebin(i+1) );
	if (~isempty(fid)),
		wt(i+1)=sum(w(fid));
	end;
end;
fid=find(x<=xmin);	% all points <= 0 are assigned to zero
wt(1)=sum(w(fid));	% (note all pts >= xmax are ignored)