module commonvar

IMPLICIT NONE

! grids
INTEGER, PARAMETER :: da1=55,da2=230    ! # asset levels for each grid
INTEGER, PARAMETER :: da=da1+da2         ! # asset levels 
INTEGER, PARAMETER :: dk1=da1,dk2=da2   ! # asset levels for each grid
INTEGER, PARAMETER :: dk=dk1+dk2         ! # asset levels
DOUBLE PRECISION, PARAMETER :: gridabreak=3.0		! cutoff for a
DOUBLE PRECISION, PARAMETER :: gridkbreak=gridabreak ! cutoff for k
INTEGER, PARAMETER :: gridtype=2		! gridtype for a and k
! grid for a
DOUBLE PRECISION, PARAMETER :: mina=0.0
DOUBLE PRECISION, PARAMETER :: maxa=1800.0    
! entrepreneurs
DOUBLE PRECISION, PARAMETER :: mink=0.05    ! minimum investment level 
DOUBLE PRECISION, PARAMETER :: maxk=maxa    ! maximum investment level

INTEGER, PARAMETER :: dr=2     ! # entrep. ability realiz. 
INTEGER, PARAMETER :: dy=5     ! # income realizations

! preferences and technology
DOUBLE PRECISION, PARAMETER :: bet=.91
DOUBLE PRECISION, PARAMETER :: gam=1.5
DOUBLE PRECISION, PARAMETER :: eta=1.0      ! altruism toward children
DOUBLE PRECISION, PARAMETER :: psii=.25      ! curvature of the labor supply
DOUBLE PRECISION, PARAMETER :: omega=0.0 ! labor supply disutility
DOUBLE PRECISION, PARAMETER :: ni=0.88      ! decr returns
DOUBLE PRECISION, PARAMETER :: alph=.33     ! capital share in non entr sector
DOUBLE PRECISION, PARAMETER :: alphe=0.80   ! capital share in entr sector
DOUBLE PRECISION, PARAMETER :: delt=.06     ! capital deprec.

! aging
DOUBLE PRECISION, PARAMETER :: pyou=.9778   ! prob. staying young
DOUBLE PRECISION, PARAMETER :: pold=.911    ! prob. staying old (not dying)

! govt parameters
DOUBLE PRECISION, PARAMETER :: replrate=0.4 ! repl. rate for pensions
DOUBLE PRECISION, PARAMETER :: tauc=0.11   ! consumption tax
DOUBLE PRECISION, PARAMETER :: exem=120.0    ! estate taxes exemption level
DOUBLE PRECISION, PARAMETER :: taub=0.16     ! tax rate on estates
DOUBLE PRECISION, PARAMETER :: gfrac=0.187  ! frac gov exp / gdp
DOUBLE PRECISION, PARAMETER :: debtfrac=0.27 ! frac gov debt /total capital

! Entrepreneurial ability. ALWAYS SET THE FIRST ONE TO ZERO!
DOUBLE PRECISION, PARAMETER, DIMENSION(dr) :: r=(/0.0, 1.16/)        ! grid for entrepr. ability (theta)
! Transition matrix for entrepreneurial ability
DOUBLE PRECISION, PARAMETER, DIMENSION(dr,dr) :: Pr=(/0.9765, 0.22, 0.0235,0.78/) ! Second element is (2,1)

! grid for worker ability   
DOUBLE PRECISION, PARAMETER, DIMENSION(dy) :: y =(/2.4675246e-001, 4.4731655e-001, 7.6540823e-001, 1.3096984e+000, 2.3742408e+000/)       
! p(y'|y)
DOUBLE PRECISION, PARAMETER, DIMENSION(dy,dy) :: Py=(/0.737571957533869, 0.194679850961718, 0.011257411090059, 0.000124020060613, 0.000000135713580,&
   &0.247281329173195, 0.555490252744122, 0.222075921776607, 0.016914625083558, 0.000157529629473,&
   &0.014989047949883, 0.232791251149989, 0.533333334266667, 0.232791251149989, 0.014989047949883,&
   &0.000157529629473, 0.016914625083558, 0.222075921776607, 0.555490252744122, 0.247281329173195,&
   &0.000000135713580, 0.000124020060613, 0.011257411090059, 0.194679850961718, 0.737571957533869/)    
 
INTEGER, PARAMETER :: oldnipaswitch=0 ! 0 means new NIPA accounting, 1 means old accounting
   
END MODULE commonvar