% bed_plots plots Business Employment Dynamics data from the Bureau of Labor Statistics
% on employment by firm size (as measured by number of workers)
% http://www.bls.gov/bdm/
% 
% bet_netchange.prn contains quarterly data on net changes in employment for different busines sizes 
% bed_lev_yr.net contains yearly data on employment levels


%   9 size cells
%	1 to 4	5 to 9	10 to 19	20 to 49	50 to 99	100 to 249	250 to 499	500 to 999	1,000 or more

load bed_netchange.prn		%change in employment (quarterly data)
qtrs=bed_netchange(:,1);
ncells=size(bed_netchange,2)-1-2; 

net_chg_cells=bed_netchange(:,[4:2:20]); % the first column contains dates, the third and fourth are totals

load bed_lev_y.prn		     % employment levels (yearly data)
emp_lev_y=bed_lev_y(:,2:ncells/2+1); % first col is year
yrs_lev=bed_lev_y(:,1);
fid=find(yrs_lev==2007);	     % we start from 2007 (recession)
emp_lev_07=emp_lev_y(fid,:);
emp_lev_tot_07=emp_lev_07*ones(ncells/2,1);
emp_sh_07=emp_lev_07/emp_lev_tot_07;	% not used
emp_sh_cumsum_07=cumsum(emp_sh_07);	% not used

fid2=find(qtrs==2007);		%we reconstruct *quarterly* levels after 2007 by cumulating net change from base year
q_07fw=(2007:.25:2013.5)';
nq_07fw=size(q_07fw,1);
emp_lev_q_07fw=zeros(nq_07fw,ncells/2);
emp_lev_q_07fw=emp_lev_07;
for i=2:nq_07fw
    emp_lev_q_07fw(i,:)=emp_lev_q_07fw(i-1,:)+net_chg_cells(fid2+i-1,:);
end

q_07_bk=[1992.25:.25:2007]';     % similarly, reconstruct levels before 2007 by subtracting net changes
nq_07bk=size(q_07_bk,1);
emp_lev_q_07bk=zeros(nq_07bk,ncells/2);
emp_lev_q_07bk(nq_07bk,:)=emp_lev_07;
for i=1:nq_07bk-1
    emp_lev_q_07bk(nq_07bk-i,:)=emp_lev_q_07bk(nq_07bk-i+1,:)-net_chg_cells(fid2-i+1,:);
end

emp_lev_q_07=[emp_lev_q_07bk;emp_lev_q_07fw(2:nq_07fw,:)];
qtrs_07=(1992.25:.25:2013.5)';
nq_07=size(qtrs_07,1);
emp_lev_q_07int=emp_lev_q_07*[0;ones(7,1);0];


% we plot relative employment size, that is, total employment at firms with number of employees <= X 
% divided by total employment at firms with number of employees > X
% the totals are computed by picking the appropriate columns in the constructed employment series

fid=find(qtrs_07==2007.75);
series1=emp_lev_q_07*[ones(2,1);zeros(7,1)];
series2=emp_lev_q_07*[zeros(2,1);ones(7,1)];

series3=emp_lev_q_07*[ones(4,1);zeros(5,1)];
series4=emp_lev_q_07*[zeros(4,1);ones(5,1)];

series5=emp_lev_q_07*[ones(5,1);zeros(4,1)];
series6=emp_lev_q_07*[zeros(5,1);ones(4,1)];

series7=emp_lev_q_07*[ones(6,1);zeros(3,1)];
series8=emp_lev_q_07*[zeros(6,1);ones(3,1)];

plot(qtrs_07(fid:nq_07),(series2(fid,1)/series1(fid,1))*series1(fid:nq_07)./series2(fid:nq_07), ...
     qtrs_07(fid:nq_07),(series4(fid,1)/series3(fid,1))*series3(fid:nq_07)./series4(fid:nq_07), ...
     qtrs_07(fid:nq_07),(series6(fid,1)/series5(fid,1))*series5(fid:nq_07)./series6(fid:nq_07), ...
     qtrs_07(fid:nq_07),(series8(fid,1)/series7(fid,1))*series7(fid:nq_07)./series8(fid:nq_07))
title('Relative employment by size (small/large 07q4=1)')
legend('1-10','1-50','1-100','1-250')

print -dpdf relativemp_varsizes
