PROGRAM trans ! ******only use for same initial and final ss *****

! Need to specify dorloop, dogovloop if switchdoall=0
! Note: The name of the drive that is used to run the code is hard coded into the program

! check DIMENSIONS and other hard-wired inputs!
! 1) search phivec(, xivec(, effvec(
! 2) search abigvec
! 3) search tfpvec

! NOTE: When the initial and final SS differ, an issue arises with deflation. THE CURRENT CODE DOES NOT DEFLATE THE NEW SS USING OLD SS WEIGHTS.
! THIS NEEDS TO BE CHANGED IF EXPERIMENTS ARE RUN WITH DIFFERENT SS

! The code contains a switch (actually located in commonvar) that allows to use either old or new 
! NIPA accounting. Under old NIPA accounting, interest spreads were part of consumption (and the spreads were a measure of their relative price,
! that should be taken into account when aggregating to obtain real consumption)
! Under new NIPA, consumption is only the part that is a spread between lending rates and government debt rates, which for us is zero. Our spread 
! (between borrowing rates and government debt rates) is an intermediate input

! This version allows for endogenous labor supply through a switch (not used for the published paper), 
! but it is only designed to work under proportional taxation. The code allows for 
! nonlinear taxation in the case of exogenous labor supply only. A switch is present that makes it explicit that progressive
! taxation and endogenous labor supply are mutually exclusive (but of course exogenous labor supply and proportional taxation is OK and allowed).

! Note that the code requires a *constant* consumption tax, or the code
! should be changed when computing aggregate consumption

! dorloop=0: no iteration on prices, otherwise: endogenous prices
! fixibar=1: fixes ibar to the inital ss level, instead of rbar. it only operates if dorloop=0, so partial equilibrium
! Note: in partial equilibrium, the initial and final SS *must* have the same interest rate
! the interest rate that remains the same must be rbar if fixibar=0 and ibar if fixibar=1

!USE numerical_libraries
!include 'link_f90_dll.h'    ! Link with dynamic numerical library

include 'link_fnl_shared.h'

USE commonvar
USE IFPORT

IMPLICIT NONE

								
! *****************  PARAMETER VALUES	
INTEGER, PARAMETER :: switchdoall=1 ! If this is equal to 1, we run the phi, phixi, eff, and tfp experiments sequentially (in that order) with the same code 

! prices convergence speed
DOUBLE PRECISION, PARAMETER :: weightoldprices=0.9 ! 

! transition matrix nonzero elements
INTEGER, PARAMETER :: nyoung=dr*dy*da   ! # possible states for young w or entr
INTEGER, PARAMETER :: noe=da*dr         ! # possible states for old entr
INTEGER, PARAMETER :: nstates=2*nyoung+noe+da   ! # states (total)
INTEGER, PARAMETER :: nonzero=2*(dy*dr+dr+1)*nyoung+(dy*dr+dr+1)*noe+&
                        &       (dy*dr+1)*da
INTEGER, PARAMETER :: sizeM=2*nyoung+noe+da     !dimension of trans mat M

! transition parameters
INTEGER, PARAMETER :: T0=5 ! In this phase, financial parameters can change for exogenous reasons; NOTE: 1st period is initial SS
INTEGER, PARAMETER :: T1=9 ! T1 is the number of periods during which taxes are different from SS
                           ! Before this period, they are equal to the initial SS, and afterwards they are equal to the final SS
INTEGER, PARAMETER :: T3=100, T4=5 ! In the T3 phase, taxes are at the SS, but factor prices are moving. 
                                   ! In the T4 phase, all factor prices and taxes are at the final SS
INTEGER, PARAMETER :: Ttrans=T0+T1+T3+T4
INTEGER, PARAMETER :: Ttransold=T0+T1+T3

! switches
INTEGER, PARAMETER :: switchbc=0       ! =0 ENDO BC, =1 exo bc,read IN file
INTEGER, PARAMETER :: switchlabsupproptax=0 ! =0 labsup is exogenous and taxation is Gouveia-Strauss, 
                                        ! =1 labsup is exogenous and taxation is proportional
                                        ! =2 workers' labor supply is endogenous and taxes are proportional,
INTEGER, PARAMETER :: fixibar=1         ! 0=rbar fixed, 1=ibar fixed (if dorloop=0)
INTEGER, PARAMETER :: loadrpathold=0    ! 1=load rpath from a previous run
INTEGER, PARAMETER :: savepolfun=0      ! 0=don't save policy functions 
INTEGER, PARAMETER :: switchequalss=1   ! 0=initial and final SS are different and must be loaded separately, =1 they are the same

! convergence criterions and penalty
DOUBLE PRECISION, PARAMETER :: pertgov=0.02 ! taubaladj+or-pertgov
DOUBLE PRECISION, PARAMETER :: epsigovmin=3e-04
DOUBLE PRECISION, PARAMETER :: epsirmin=1e-04
DOUBLE PRECISION, PARAMETER :: penalty=-1e+7

DOUBLE PRECISION, PARAMETER, DIMENSION(1+T0) :: phivecpar=(/0.015_8, 0.035_8, 0.035_8, 0.035_8, 0.015_8, 0.015_8/)  !0.015  ! intermediation cost r_t=i_t+phi
DOUBLE PRECISION, PARAMETER, DIMENSION(1+T0) :: xivecpar=(/0.33_8, 0.33_8*0.015_8/0.035_8, 0.33_8*0.015_8/0.035_8, 0.33_8*0.015_8/0.035_8, 0.33_8, 0.33_8/) !0.33      ! fraction of outside funds needed by corporate firms 
! enforcement
DOUBLE PRECISION, PARAMETER, DIMENSION(1+T0) :: effvecpar=(/0.75_8, 0.80_8, 0.80_8, 0.80_8, 0.75_8, 0.75_8/) !0.75 ! prop k kept when defaulting
DOUBLE PRECISION, PARAMETER, DIMENSION(1+T0) :: tfpvecpar=(/1.0_8, 0.975_8, 0.975_8, 0.975_8, 1.0_8, 1.0_8/) !1.0  ! This must be one in SS, since it does not appear in the SS code 
DOUBLE PRECISION, PARAMETER, DIMENSION(1+T0) :: abigvecpar=1.0_8 ! constant in front

CHARACTER(6), PARAMETER :: experimentlabel(4)=(/"phi__/", "phixi/","eff__/","tfp__/"/)
INTEGER, PARAMETER :: numsettings=3
! AG=Adjust g, AT=Adjust taxes, PE=Partial Equilibrium, GE=General Equilibrium
CHARACTER(5), PARAMETER :: experimentsettinglabel(numsettings)=(/"AGPE/", "AGGE/", "ATGE/"/) 

LOGICAL :: directorysuccess ! Needed to create new directories
INTEGER :: directorytempo ! Needed in the process of changing directories
CHARACTER(6) :: directoryname
CHARACTER(100) :: currentdirectory

INTEGER :: dorloop         ! 0=don't do r loop 
INTEGER :: dogovloop       ! 0=fix debt at SS value by adjusting g, 1=fixed g, adjust taxes during a transition period to balance gov't BC in PV
INTEGER :: experimentnumber,experimentsettingnumber

DOUBLE PRECISION, DIMENSION(1+T0) :: phivec  ! intermediation cost r_t=i_t+phi
DOUBLE PRECISION, DIMENSION(1+T0) :: xivec   ! fraction of outside funds needed by corporate firms 
! enforcement
DOUBLE PRECISION, DIMENSION(1+T0) :: effvec ! prop k kept when defaulting
DOUBLE PRECISION, DIMENSION(1+T0) :: tfpvec 
DOUBLE PRECISION, DIMENSION(1+T0) :: abigvec ! constant in front

DOUBLE PRECISION :: cacca ! placeholder
! government parameters
DOUBLE PRECISION:: govexp    ! gov exp

!miscellanea
CHARACTER(30) :: fname
DOUBLE PRECISION, DIMENSION(Ttransold-2) :: cacca3v
INTEGER, DIMENSION(2) :: imaxmat

! prices and stuff
DOUBLE PRECISION :: wage, rbar, ibar, rcorp, invprodibar, wageimplied, rimplied, Pvprimgovsurp,govbalPV,govbalPVmin,govbalPVmax 
DOUBLE PRECISION :: rbar1ss,rbar2ss
DOUBLE PRECISION :: eff,abig,phi,xi,tfp

! transition objects 
DOUBLE PRECISION,  DIMENSION(Ttrans) :: taubalpath, rbarpath,ibarpath,wagepath, govdebtT, taxeslesstransfT
DOUBLE PRECISION :: taubal, taubaladj, taubaladjmin,taubaladjmax
DOUBLE PRECISION :: taubal1ss, taubal2ss

! indexes
INTEGER :: i,i2,j,j1,j2,jj,l,ll,Ttime, Tfinal, OpenStatus, iteragovbal, iterar 
INTEGER, DIMENSION(1) :: imax, indanet

! convergence criteria
DOUBLE PRECISION :: epsigov, epsir 
! pensions
DOUBLE PRECISION :: transf, transf2ss
! grids
DOUBLE PRECISION, DIMENSION(da) :: a,anet       ! grid for assets
DOUBLE PRECISION, DIMENSION(dk) :: k        ! grid for k
DOUBLE PRECISION, DIMENSION(dr*dy,dr*dy) :: Pyr,Pyrtr ! joint distr. of y and r
DOUBLE PRECISION, DIMENSION(dy*dr) ::   invyr   ! invariant distr of y and r
DOUBLE PRECISION, DIMENSION(dy) ::      invy    ! invariant distr of y

! taxes estimated using Gouveia Strauss tau=b-b*(s*y**p+1)**(-1/p)
! stax depends on income normalization
DOUBLE PRECISION :: btaxw,staxw,ptaxw,staxwbase
DOUBLE PRECISION :: btaxe,staxe,ptaxe,staxebase

!value functions
! young
DOUBLE PRECISION, DIMENSION(da,dy,dr) :: Vynext, Vynext2ss   ! Vy young, current, and next period's vf Marco: Vy no longer used
! old
DOUBLE PRECISION, DIMENSION(da,dr) :: Voee   ! old entrepreneur staying entrep
DOUBLE PRECISION, DIMENSION(da) :: Vownext, Vownext2ss      !, Vow old, retired, worker,  current, and next period's vf Marco: Vow no longer used
DOUBLE PRECISION, DIMENSION(da,dr) :: Voenext, Voenext2ss    !, Voe old entrepreneur,  current, and next period's vf Marco: Voe no longer used
DOUBLE PRECISION, DIMENSION(da) :: Vynet ! val fun for descendant (net of estate tax)
DOUBLE PRECISION, DIMENSION(da) :: EVnewbw   ! exp value newborn worker
DOUBLE PRECISION, DIMENSION(da,dr) :: EVnewbe    ! exp value newborn entr
DOUBLE PRECISION, DIMENSION(da,dy,dr) :: EVy
! defaulted guys
DOUBLE PRECISION, DIMENSION(dk,dy,dr) :: Vwkeff ! defaulted worker
DOUBLE PRECISION, DIMENSION(dk) :: Vokeff    ! defaulted OLD worker

! policy functions
! young
INTEGER, DIMENSION(da,dy,dr) :: apolye, kpolye ! young that is entr for this period
INTEGER, DIMENSION(da,dy,dr) :: apolyw         ! young that is worker this period
DOUBLE PRECISION, DIMENSION(da,dy,dr) :: labpoly           ! labor demand for young entr
INTEGER, DIMENSION(da,dy,dr,Ttrans) :: apolyT,kpolyT   ! young
DOUBLE PRECISION, DIMENSION(da,dy,dr,Ttrans) :: labpolyT         ! labor demand for young entr
INTEGER, DIMENSION(da,dy,dr) :: apoly2ss,kpoly2ss ! young
DOUBLE PRECISION, DIMENSION(da,dy,dr) :: labpoly2ss        ! labor demand for young entr

! old
INTEGER, DIMENSION(da,Ttrans) :: apolowT               ! old, retired, worker
INTEGER, DIMENSION(da) :: apolownet                    ! as above net of estate tax
INTEGER, DIMENSION(da,dr,Ttrans) :: apoloeT,kpoloeT    ! old entrepreneur
INTEGER, DIMENSION(da,dr) :: apoloenet                 ! as above net of estate tax
DOUBLE PRECISION, DIMENSION(da,dr,Ttrans) :: labpoloeT         ! labor demand for old entrep
INTEGER, DIMENSION(da) :: apolow2ss               ! old, retired, worker
INTEGER, DIMENSION(da,dr) :: apoloe2ss,kpoloe2ss ! old entrepreneur
DOUBLE PRECISION, DIMENSION(da,dr) :: labpoloe2ss         ! labor demand for old entrep

! exogenous investment limits
INTEGER, DIMENSION(da,dy,dr) :: kyhat, kyhat2ss   ! young entr: max k(a,y,r)
INTEGER, DIMENSION(da,dr) :: kohat, kohat2ss      ! old entr: max k(a,r)

! transition matrix
INTEGER, DIMENSION(nonzero) :: colM, rowM     ! row and col index
DOUBLE PRECISION, DIMENSION(nonzero) :: valM              ! value (trans probability)

! invariant distribution
DOUBLE PRECISION, DIMENSION(nstates) :: invm,invm1,invm1ss  ! invar distr prob
DOUBLE PRECISION, DIMENSION(da) :: prgrid           ! invariant distr on a
DOUBLE PRECISION, DIMENSION(da) :: prgridyw,prgridye,prgridoe,prgridow  ! same by groups
DOUBLE PRECISION :: totayw,totaye,totaow,totaoe
DOUBLE PRECISION, DIMENSION(nstates-da) :: invlevk,invrk   ! k and r level corr to invm

DOUBLE PRECISION, DIMENSION(nstates-da) :: invlabe,invtotlabe ! outside labor and total labor demand to invm
DOUBLE PRECISION :: hiredlabe								  ! labor employed by entr and
DOUBLE PRECISION :: incky,incko                               ! entr's gross product (young and old)
DOUBLE PRECISION :: k2gdp									  ! k2gdp ratio
DOUBLE PRECISION, DIMENSION(Ttrans) :: totaT, gdpT, govprimsurpT, totkcorpT ! keep track of aggr during transition
DOUBLE PRECISION, DIMENSION(Ttrans) :: totkT, totlcorpT, inckT,hiredlabeT,totentrT,aggrconsgoodsT,aggrconstotT,totLT,toteffLT,labsupT,capintermedT
DOUBLE PRECISION, DIMENSION(Ttrans) :: rimpliedT,wageimpliedT
DOUBLE PRECISION, DIMENSION(2*nyoung) :: invrky,invlevky,invtotlabye,invmy  ! var to calculate incky and incko
DOUBLE PRECISION, DIMENSION(noe) :: invrko,invlevko,invtotlaboe,invmo       ! var to calculate incky and incko

DOUBLE PRECISION :: totentr                         ! number of entrepreneurs
DOUBLE PRECISION :: totret                          ! number of retirees
DOUBLE PRECISION :: totL,toteffL    ! number of workers  and total efficiency units of labor
DOUBLE PRECISION :: labsup  ! time spent working by workers (entrepreneurs are normalized to 1 unit of time, inelastic)

INTEGER, DIMENSION(nstates) :: ifswitchew         ! 1=if from e to w
INTEGER, DIMENSION(nstates) :: ifswitchwe         ! 1=if from w to e
DOUBLE PRECISION, DIMENSION(Ttrans) ::  propewswitchT, propweswitchT ! prop. of switch from e to w

! government revenues
DOUBLE PRECISION, DIMENSION(nstates) :: vectaxcw,vectaxce,vectaxl,vectaxe,vectaxbw,vectaxbe ! vectaxa
DOUBLE PRECISION :: tottaxcw,tottaxce,tottaxe,tottaxl,totincw,tottaxbw,tottaxbe !, tottaxa
DOUBLE PRECISION :: tottaxcw1ss,tottaxcw2ss,tottaxce1ss,tottaxce2ss
DOUBLE PRECISION :: govdebt1ss, govdebt2ss, govbal

! temporary objects
DOUBLE PRECISION :: ytaxw,taxw,taxo,ytaxo
DOUBLE PRECISION, DIMENSION(dk) :: ytaxe,taxe
DOUBLE PRECISION, DIMENSION(da) :: ucons,cs
DOUBLE PRECISION, DIMENSION(da,da) :: uconsold
DOUBLE PRECISION, DIMENSION(da,da,dy) :: uconsw
DOUBLE PRECISION, DIMENSION(dk,da,dy) :: uconsweff
DOUBLE PRECISION, DIMENSION(da,da,dr-1,dk) :: uconse
DOUBLE PRECISION, DIMENSION(dk) :: uconsl,csl
DOUBLE PRECISION, DIMENSION(da,dy,dr) :: newVy
DOUBLE PRECISION, DIMENSION(da,dy,dr) :: newVyw,newVye
DOUBLE PRECISION, DIMENSION(da,dr) :: newVoe    ! old entrepreneur
DOUBLE PRECISION, DIMENSION(da) :: newVow       ! old, retired, worker
DOUBLE PRECISION, DIMENSION(da) :: Vowtemp
DOUBLE PRECISION, DIMENSION(da):: Vywtemp
DOUBLE PRECISION, DIMENSION(dk,da) :: Vyetemp
DOUBLE PRECISION, DIMENSION(dk,da) :: Veetemp
DOUBLE PRECISION, DIMENSION(dk,da) :: Voeetemp
DOUBLE PRECISION, DIMENSION(sizeM) :: sumrowM

DOUBLE PRECISION :: ahere,khere,rhere,entinchere,winchere,lhere,taxwhere,taxehere,inchere 
DOUBLE PRECISION, DIMENSION(dk) :: labe           ! outside labor demand for old and young entr
DOUBLE PRECISION :: term1,front1,labdemand        ! additional variables for entr's labor demand

! miscellanea
DOUBLE PRECISION, DIMENSION(dy) ::eigvaly
COMPLEX*16, DIMENSION(dy) :: eigvalcy
DOUBLE PRECISION, DIMENSION(dy*dr) ::eigvalyr
COMPLEX*16, DIMENSION(dy*dr) :: eigvalcyr
DOUBLE PRECISION, DIMENSION(dy,dy) ::eigvecy
COMPLEX*16, DIMENSION(dy,dy) :: eigveccy
DOUBLE PRECISION, DIMENSION(dy*dr,dy*dr) ::eigvecyr
COMPLEX*16, DIMENSION(dy*dr,dy*dr) :: eigveccyr
INTEGER :: counter,crow,count1,count2,counter2

INTEGER :: bracketgov, havetaubalmin ! havetaucmin

DOUBLE PRECISION :: fundiffnow,fundiffmin,fundiffmax

DOUBLE PRECISION, DIMENSION(Ttrans) :: totkgrossborrT    !total amount borrowed by e
DOUBLE PRECISION :: totyshe     !total shadow labor income for e

DOUBLE PRECISION, DIMENSION(nstates-da) :: invkgrossborr ! gross borrowing by e for each state var

! ******************  INTERFACE SUBROUTINES
INTERFACE

SUBROUTINE linspace (xmin,xmax,npoints,lspace)
IMPLICIT NONE
DOUBLE PRECISION, INTENT(IN) :: xmin,xmax
INTEGER, INTENT(IN) :: npoints
DOUBLE PRECISION, DIMENSION(npoints), INTENT(OUT) :: lspace
END SUBROUTINE linspace

SUBROUTINE  interplin(l,x,y,n,z,v)
IMPLICIT NONE
INTEGER, INTENT(IN) :: l
INTEGER, INTENT(IN) :: n
DOUBLE PRECISION, DIMENSION(l), INTENT(IN) :: x
DOUBLE PRECISION, DIMENSION(l), INTENT(IN) :: y
DOUBLE PRECISION, DIMENSION(n), INTENT(IN) :: z
DOUBLE PRECISION, DIMENSION(n), INTENT(OUT) :: v
END SUBROUTINE

END INTERFACE

experimentnumber=0
IF (switchdoall==0) THEN
    dorloop=0
    dogovloop=0
    phivec=phivecpar
    xivec=xivecpar
    effvec=effvecpar
    tfpvec=tfpvecpar
    abigvec=abigvecpar
    directoryname=""
    CALL transsub(phivec,xivec,effvec,tfpvec,abigvec,dorloop,dogovloop,directoryname) 
ELSE
    currentdirectory="D" ! We ran this code on our D disk
    directorytempo=GETDRIVEDIRQQ(currentdirectory)
    DO experimentnumber=1,4
        IF (experimentnumber==1) THEN
            phivec=phivecpar
            xivec=xivecpar(1)
            effvec=effvecpar(1)
            tfpvec=tfpvecpar(1)
            abigvec=abigvecpar(1)
        ELSEIF (experimentnumber==2) THEN
            phivec=phivecpar
            xivec=xivecpar
            effvec=effvecpar(1)
            tfpvec=tfpvecpar(1)
            abigvec=abigvecpar(1)        
        ELSEIF (experimentnumber==3) THEN
            phivec=phivecpar(1)
            xivec=xivecpar(1)
            effvec=effvecpar
            tfpvec=tfpvecpar(1)
            abigvec=abigvecpar(1)  
        ELSE 
            phivec=phivecpar(1)
            xivec=xivecpar(1)
            effvec=effvecpar(1)
            tfpvec=tfpvecpar
            abigvec=abigvecpar(1)  
        END IF
        directoryname=experimentlabel(experimentnumber)
        directorysuccess=MAKEDIRQQ(directoryname)
        DO experimentsettingnumber=1,numsettings
            directorysuccess=CHANGEDIRQQ(directoryname)
            directorysuccess=MAKEDIRQQ(experimentsettinglabel(experimentsettingnumber))
            directorysuccess=CHANGEDIRQQ(currentdirectory)
            IF (experimentsettingnumber==1) THEN
                dorloop=0
                dogovloop=0
            ELSEIF (experimentsettingnumber==2) THEN
                dorloop=1
                dogovloop=0
            ELSE
                dorloop=1
                dogovloop=1
            END IF
            WRITE(*,*) directoryname // experimentsettinglabel(experimentsettingnumber)
            CALL transsub(phivec,xivec,effvec,tfpvec,abigvec,dorloop,dogovloop, &
                & directoryname // experimentsettinglabel(experimentsettingnumber)) 
        END DO ! experimentsettingnumber
    END DO ! experimentnumber  
END IF !switchdoall

CONTAINS

SUBROUTINE transsub(phivec,xivec,effvec,tfpvec,abigvec,dorloop,dogovloop,directoryname)

IMPLICIT NONE

DOUBLE PRECISION, DIMENSION(1+T0), INTENT(IN) :: xivec !0.33     ! fraction of outside funds needed by corporate firms 
DOUBLE PRECISION, DIMENSION(1+T0), INTENT(IN) :: phivec !(/0.015, 0.035, 0.035, 0.035, 0.015, 0.015/)    ! intermediation cost r_t=i_t+phi 

! enforcement
DOUBLE PRECISION, DIMENSION(1+T0), INTENT(IN) :: effvec !0.75 ! prop k kept when defaulting
! corporate prof fn
DOUBLE PRECISION, DIMENSION(1+T0), INTENT(IN) :: abigvec !1.0 ! constant in front
DOUBLE PRECISION, DIMENSION(1+T0), INTENT(IN) :: tfpvec !(/1.0, 0.975, 0.975, 0.975, 1.0, 1.0/) !1.0  ! This must be one in SS, since it does not appear in the SS code 

INTEGER, INTENT(IN) :: dorloop          ! 0=don't do r loop 
INTEGER, INTENT(IN) :: dogovloop        ! 0=don't balance gov bc 

CHARACTER(*), INTENT(IN) :: directoryname

! Reset warning file 
fname="Warning"
open (unit=32,file=fname,status="replace", &
&       action="write",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE (*,*) 'problems opening ', fname
END IF
CLOSE(unit=32)


! load stuff from initial and final ss

! reading final ss borrowing contraints
IF (switchequalss==0) THEN
    fname="exobcFINALSS"
ELSE
    fname="exobc"
END IF
open (unit=32,file=fname,status="old", &
&       action="read",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE (*,*) 'problems opening ', fname
END IF
DO i=1,da
	DO j=1,dy
		DO jj=1,dr
			READ (unit=32, fmt=*) kyhat2ss(i,j,jj)
		END DO
	END DO
END DO
DO i=1,da
	DO jj=1,dr
		READ (unit=32, fmt=*) kohat2ss(i,jj)
	END DO
END DO
CLOSE (unit=32)

! read in value functions FROM FINAL SS
IF (switchequalss==0) THEN
    fname="valfunFINALSS"
ELSE
    fname="valfun"
END IF
open (unit=32,file=fname,status="old", &
&       action="read",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
READ(unit=32,fmt=*) cacca
READ(unit=32,fmt=*) cacca
READ(unit=32,fmt=*) cacca
READ(unit=32,fmt=*) cacca
DO i=1,da
    READ(unit=32,fmt=*) a(i)
END DO
DO i=1,dy
    READ(unit=32,fmt=*) cacca !y(i)
END DO
DO i=1,dr
    READ(unit=32,fmt=*) cacca !r(i)
END DO
DO i=1,dk
    READ(unit=32,fmt=*) k(i)
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) Vynext2ss(i,j,jj) ! t+1 val fun taken as given in t
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) cacca !Vyw(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) cacca !Vye(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    READ(unit=32,fmt=*) Vownext2ss(i)
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) Voenext2ss(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) Voee(i,jj)
    END DO
END DO
DO i=1,dk
    READ(unit=32,fmt=*) cacca !Vokeff(i)
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) apoly2ss(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) kpoly2ss(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) cacca ! apolye(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) cacca !kpolye(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) cacca !apolyw(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    READ(unit=32,fmt=*) apolow2ss(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) cacca !apolownet(i)
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) apoloe2ss(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) cacca !apoloenet(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) kpoloe2ss(i,jj)
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) cacca
        END DO
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) cacca
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) labpoly2ss(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) labpoloe2ss(i,jj)
    END DO
END DO
READ(unit=32,fmt=*) cacca !delt
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) cacca !conspoly(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) cacca !netincy(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            READ(unit=32,fmt=*) cacca !grossincy(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    READ(unit=32,fmt=*) cacca ! conspolow(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) cacca ! netincow(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) cacca ! grossincow(i)
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) cacca ! conspoloe(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) cacca ! netincoe(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        READ(unit=32,fmt=*) cacca ! grossincoe(i,jj)
    END DO
END DO
CLOSE (unit=32)

fname="invdistr"
! loading invariant distr
open (unit=32,file=fname,status="old", &
&       action="READ", position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
READ(unit=32,fmt=*) cacca
READ(unit=32,fmt=*) cacca
READ(unit=32,fmt=*) cacca
DO i=1,nstates
    READ(unit=32,fmt=*) invm1ss(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) prgrid(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) prgridyw(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) prgridye(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) prgridoe(i)
END DO
DO i=1,da
    READ(unit=32,fmt=*) prgridow(i)
END DO
READ(unit=32,fmt=*) totaT(1)
READ(unit=32,fmt=*) totkT(1)
READ(unit=32,fmt=*) inckT(1)
DO i=1,(nstates-da)
    READ(unit=32,fmt=*) invlevk(i)
END DO
DO i=1,(nstates-da)
    READ(unit=32,fmt=*) cacca !invpolk(i)
END DO
DO i=1,(nstates-da)
    READ(unit=32,fmt=*) invrk(i)
END DO
READ(unit=32,fmt=*) k2gdp
READ(unit=32,fmt=*) cacca !ykshare
READ(unit=32,fmt=*) rbar1ss
DO i=1,dr
    READ(unit=32,fmt=*) cacca !invr(i)
END DO
READ(unit=32,fmt=*) cacca ! totke
READ(unit=32,fmt=*) cacca !bet
READ(unit=32,fmt=*) cacca !gam
READ(unit=32,fmt=*) cacca ! effvec(1)
READ(unit=32,fmt=*) cacca !eta
READ(unit=32,fmt=*) cacca ! ni
READ(unit=32,fmt=*) propewswitchT(1)
READ(unit=32,fmt=*) propweswitchT(1)
READ(unit=32,fmt=*) cacca !alph
DO i=1,dy
    READ(unit=32,fmt=*) cacca !invy(i)
END DO
DO i=1,dr
    DO j=1,dr
        READ(unit=32,fmt=*) cacca !Pr(i,j)
    END DO
END DO
READ(unit=32,fmt=*) cacca !yktotsh
READ(unit=32,fmt=*) totentrT(1)
READ(unit=32,fmt=*) totret
READ(unit=32,fmt=*) totLT(1)
READ(unit=32,fmt=*) wagepath(1)
READ(unit=32,fmt=*) cacca !beq2gdp
READ(unit=32,fmt=*) cacca ! totkborr 
READ(unit=32,fmt=*) totyshe
READ(unit=32,fmt=*) toteffLT(1)
READ(unit=32,fmt=*) totlcorpT(1)
READ(unit=32,fmt=*) hiredlabeT(1)
DO i=1,(2*nyoung)
    READ(unit=32,fmt=*) invtotlabye(i)
END DO
DO i=1,noe
    READ(unit=32,fmt=*) invtotlaboe(i)
END DO
READ(unit=32,fmt=*) cacca !alphe
READ(unit=32,fmt=*) cacca ! phivec(1)
READ(unit=32,fmt=*) cacca ! xivec(1)
READ(unit=32,fmt=*) cacca !ibar
READ(unit=32,fmt=*) totkcorpT(1)
READ(unit=32,fmt=*) totkgrossborrT(1)
READ(unit=32,fmt=*) cacca ! labsup
READ(unit=32,fmt=*) capintermedT(1)
CLOSE (unit=32)

IF (switchequalss==0) THEN
    fname="invdistrFINALSS"
    ! saving invariant distr
    open (unit=32,file=fname,status="old", &
    &       action="READ", position="rewind",iostat=OpenStatus)
    IF (OpenStatus.NE.0) THEN
        WRITE(*,*) 'problems opening ', fname
    END IF
    READ(unit=32,fmt=*) cacca
    READ(unit=32,fmt=*) cacca
    READ(unit=32,fmt=*) cacca
    DO i=1,nstates
        READ(unit=32,fmt=*) cacca ! invm(i)
    END DO
    DO i=1,da
        READ(unit=32,fmt=*) cacca !prgrid(i)
    END DO
    DO i=1,da
        READ(unit=32,fmt=*) cacca !prgridyw(i)
    END DO
    DO i=1,da
        READ(unit=32,fmt=*) cacca !prgridye(i)
    END DO
    DO i=1,da
        READ(unit=32,fmt=*) cacca !prgridoe(i)
    END DO
    DO i=1,da
        READ(unit=32,fmt=*) cacca ! prgridow(i)
    END DO
    READ(unit=32,fmt=*) totaT(Ttrans)
    READ(unit=32,fmt=*) totkT(Ttrans)
    READ(unit=32,fmt=*) inckT(Ttrans)
    DO i=1,(nstates-da)
        READ(unit=32,fmt=*) cacca ! invlevk(i)
    END DO
    DO i=1,(nstates-da)
        READ(unit=32,fmt=*) cacca !invpolk(i)
    END DO
    DO i=1,(nstates-da)
        READ(unit=32,fmt=*) cacca ! invrk(i)
    END DO
    READ(unit=32,fmt=*) cacca ! k2gdp
    READ(unit=32,fmt=*) cacca !ykshare
    READ(unit=32,fmt=*) rbar2ss
    DO i=1,dr
        READ(unit=32,fmt=*) cacca !invr(i)
    END DO
    READ(unit=32,fmt=*) cacca ! totke
    READ(unit=32,fmt=*) cacca ! bet
    READ(unit=32,fmt=*) cacca !gam
    READ(unit=32,fmt=*) cacca ! effvec(1+T0)  ! this is the final SS one if we change it
    READ(unit=32,fmt=*) cacca !eta
    READ(unit=32,fmt=*) cacca !ni
    READ(unit=32,fmt=*) propewswitchT(Ttrans)
    READ(unit=32,fmt=*) propweswitchT(Ttrans)
    READ(unit=32,fmt=*) cacca !alph
    DO i=1,dy
        READ(unit=32,fmt=*) cacca !invy(i)
    END DO
    DO i=1,dr
        DO j=1,dr
            READ(unit=32,fmt=*) cacca !Pr(i,j)
        END DO
    END DO
    READ(unit=32,fmt=*) cacca !yktotsh
    READ(unit=32,fmt=*) totentrT(Ttrans)
    READ(unit=32,fmt=*) cacca !totret
    READ(unit=32,fmt=*) totLT(Ttrans)
    READ(unit=32,fmt=*) wagepath(Ttrans)
    READ(unit=32,fmt=*) cacca !beq2gdp
    READ(unit=32,fmt=*) cacca ! totkborr
    READ(unit=32,fmt=*) cacca !totyshe
    READ(unit=32,fmt=*) cacca !toteffL
    READ(unit=32,fmt=*) totlcorpT(Ttrans)
    READ(unit=32,fmt=*) hiredlabeT(Ttrans)
    DO i=1,(2*nyoung)
        READ(unit=32,fmt=*) cacca !invtotlabye(i)
    END DO
    DO i=1,noe
        READ(unit=32,fmt=*) cacca !invtotlaboe(i)
    END DO
    READ(unit=32,fmt=*) cacca !alphe
    READ(unit=32,fmt=*) cacca ! phivec(1+T0)
    READ(unit=32,fmt=*) cacca ! xivec(1+T0)
    READ(unit=32,fmt=*) cacca !ibar
    READ(unit=32,fmt=*) totkcorpT(Ttrans)
    READ(unit=32,fmt=*) totkgrossborrT(Ttrans)
    READ(unit=32,fmt=*) cacca ! labsup
    READ(unit=32,fmt=*) capintermedT(Ttrans)
    CLOSE (unit=32)
ELSE
    totaT(Ttrans)=totaT(1)
    totkT(Ttrans)=totkT(1)
    inckT(Ttrans)=inckT(1)
    rbar2ss=rbar1ss
    propewswitchT(Ttrans)=propewswitchT(1)
    propweswitchT(Ttrans)=propweswitchT(1)
    totentrT(Ttrans)=totentrT(1)
    totLT(Ttrans)=totLT(1)
    wagepath(Ttrans)=wagepath(1)
    totlcorpT(Ttrans)=totlcorpT(1)
    hiredlabeT(Ttrans)=hiredlabeT(1)
    totkcorpT(Ttrans)=totkcorpT(1)
    totkgrossborrT(Ttrans)=totkgrossborrT(1)
    capintermedT(Ttrans)=capintermedT(1)
END IF

fname="govtax"
! saving totals for government
open (unit=32,file=fname,status="old", &
&       action="READ",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
	WRITE(*,*) 'problems opening ', fname
END IF
READ(unit=32,fmt=*) gdpT(1)
READ(unit=32,fmt=*) govdebt1ss
READ(unit=32,fmt=*)	transf
READ(unit=32,fmt=*)	cacca !gfrac
READ(unit=32,fmt=*)	cacca ! debtfrac
READ(unit=32,fmt=*)	tottaxl
READ(unit=32,fmt=*)	tottaxe
READ(unit=32,fmt=*)	cacca !tottaxa (obsolete)
READ(unit=32,fmt=*)	tottaxcw1ss
READ(unit=32,fmt=*)	tottaxce1ss
READ(unit=32,fmt=*)	cacca !tottaxbw
READ(unit=32,fmt=*)	cacca !tottaxbe
READ(unit=32,fmt=*)	cacca !govbal
READ(unit=32,fmt=*)	taubal1ss
! We read the Gouveia-Strauss parameters no matter what, but they are not used with proportional taxation
READ(unit=32,fmt=*)	btaxw
READ(unit=32,fmt=*)	staxw
READ(unit=32,fmt=*)	ptaxw
READ(unit=32,fmt=*)	staxwbase
READ(unit=32,fmt=*)	totincw
READ(unit=32,fmt=*)	btaxe
READ(unit=32,fmt=*)	staxe
READ(unit=32,fmt=*)	ptaxe
READ(unit=32,fmt=*)	staxebase
READ(unit=32,fmt=*)	cacca !totincw
READ(unit=32,fmt=*)	cacca
READ(unit=32,fmt=*)	cacca
READ(unit=32,fmt=*)	cacca
READ(unit=32,fmt=*)	cacca
READ(unit=32,fmt=*)	cacca
CLOSE(unit=32)

IF (switchequalss==0) THEN
    fname="govtaxFINALSS"
    ! saving totals for government
    open (unit=32,file=fname,status="old", &
    &       action="READ",position="rewind",iostat=OpenStatus)
    IF (OpenStatus.NE.0) THEN
        WRITE(*,*) 'problems opening ', fname
    END IF
    READ(unit=32,fmt=*) gdpT(Ttrans)
    READ(unit=32,fmt=*) govdebt2ss
    READ(unit=32,fmt=*)	transf2ss !transf
    READ(unit=32,fmt=*)	cacca !gfrac
    READ(unit=32,fmt=*)	cacca !debtfrac
    READ(unit=32,fmt=*)	cacca !tottaxl
    READ(unit=32,fmt=*)	cacca !tottaxe
    READ(unit=32,fmt=*)	cacca !tottaxa (obsolete)
    READ(unit=32,fmt=*)	tottaxcw2ss
    READ(unit=32,fmt=*)	tottaxce2ss
    READ(unit=32,fmt=*)	cacca !tottaxbw
    READ(unit=32,fmt=*)	cacca !tottaxbe
    READ(unit=32,fmt=*)	cacca !govbal
    READ(unit=32,fmt=*)	taubal2ss
    READ(unit=32,fmt=*)	cacca !btaxw
    READ(unit=32,fmt=*)	cacca !staxw
    READ(unit=32,fmt=*)	cacca !ptaxw
    READ(unit=32,fmt=*)	cacca !staxwbase
    READ(unit=32,fmt=*)	cacca !totincw
    READ(unit=32,fmt=*)	cacca !btaxe
    READ(unit=32,fmt=*)	cacca !staxe
    READ(unit=32,fmt=*)	cacca !ptaxe
    READ(unit=32,fmt=*)	cacca !staxebase
    READ(unit=32,fmt=*)	cacca !totincw
    READ(unit=32,fmt=*)	cacca
    READ(unit=32,fmt=*)	cacca
    READ(unit=32,fmt=*)	cacca
    READ(unit=32,fmt=*)	cacca
    READ(unit=32,fmt=*)	cacca
    CLOSE(unit=32)
ELSE
    gdpT(Ttrans)=gdpT(1)
    govdebt2ss=govdebt1ss
    transf2ss=transf
    tottaxcw2ss=tottaxcw1ss
    tottaxce2ss=tottaxce1ss
    taubal2ss=taubal1ss
END IF

! make up joint distr for y and r. y is outside
DO j=1,dy       !   y today
    DO jj=1,dy  !   y tomorrow
        Pyr((j-1)*dr+1:j*dr,(jj-1)*dr+1:jj*dr)=Py(j,jj)*Pr
    END DO
END DO
DO i=1,dy*dr
    Pyr(i,:)=Pyr(i,:)/SUM(Pyr(i,:))
END DO


Pyrtr=TRANSPOSE(Pyr) ! compute inv dist for joint of y and r
CALL devcrg (dy*dr,Pyrtr,dy*dr,eigvalcyr,eigveccyr,dy*dr)
eigvalyr=DBLE(eigvalcyr)
eigvecyr=DBLE(eigveccyr)
imax=MAXLOC(eigvalyr)
invyr=eigvecyr(:,imax(1))
invyr=invyr/SUM(invyr)

! compute inv dist for y
CALL devcrg (dy,TRANSPOSE(Py),dy,eigvalcy,eigveccy,dy)
eigvaly=DBLE(eigvalcy)
eigvecy=DBLE(eigveccy)
imax=MAXLOC(eigvaly)
invy=eigvecy(:,imax(1))
invy=invy/SUM(invy)

WRITE(*,*) "invy" , invy
WRITE(*,*) "y", y
 


fname=directoryname // "output"
OPEN (unit=32,file=fname,status="replace", &
&       action="write",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE (*,*) 'problems opening ', fname
END IF
WRITE (unit=32, fmt=*) "********************* Parameters **************************"
WRITE (unit=32, fmt=*) "bet=",bet
WRITE (unit=32, fmt=*) "ni=", ni 
WRITE (unit=32, fmt=*) "alphe=",alphe
WRITE (unit=32, fmt=*) "eff=",eff
WRITE (unit=32, fmt=*) "taub=", taub
WRITE (unit=32, fmt=*) "exem=", exem
WRITE (unit=32, fmt=*) "taubal1ss=", taubal1ss
WRITE (unit=32, fmt=*) "rbar1ss=", rbar1ss
WRITE (unit=32, fmt=*) "theta=", r(2)
WRITE (unit=32, fmt=*) "Pr(1,1)=", Pr(1,1)
WRITE (unit=32, fmt=*) "Pr(2,2)=", Pr(2,2)
WRITE (unit=32, fmt=*) "omega=", omega
WRITE (unit=32, fmt=*) "-------------------------------------------------------------"
WRITE (unit=32, fmt=*) "gam=",gam
WRITE (unit=32, fmt=*) "eta=",eta
WRITE (unit=32, fmt=*) "delt=",delt   
WRITE (unit=32, fmt=*) "alph=",alph
WRITE (unit=32, fmt=*) "abig=",abig
WRITE (unit=32, fmt=*) "repl rate=",replrate,"   tauc=",tauc 
WRITE (unit=32, fmt=*) "gfrac=",gfrac,"   debtfrac=",debtfrac
WRITE (unit=32, fmt=*) "da=",da,"  dk=",dk,"  maxa=",maxa
WRITE (unit=32, fmt=*) "da1=",da1,"   da2=",da2
WRITE (unit=32, fmt=*) "gridabreak=",gridabreak,"gridkbreak=",gridkbreak
IF (switchlabsupproptax==0) THEN
    WRITE (unit=32, fmt=*) "btaxw=",btaxw,"   staxw=",staxw,"   ptaxw=",ptaxw
    WRITE (unit=32, fmt=*) "btaxe=",btaxe,"   staxe=",staxe,"   ptaxe=",ptaxe
END IF
WRITE (unit=32,fmt=*) "oldNIPAswitch=",oldnipaswitch
WRITE (unit=32, fmt=*) "**************************************************************"
CLOSE (unit=32)

anet=a
WHERE (anet.GT.exem) anet=(a-exem)*(1.0-taub)+exem

fname=directoryname // "checkgovdebt"
OPEN (unit=32,file=fname,status="replace", &
&       action="write",position="rewind",iostat=OpenStatus)
WRITE (unit=32, fmt=*) "--------"
CLOSE (unit=32)			

! INTIALIZE, JUST IN CASE
apolyT=0
kpolyT=0
labpolyT=0.0
apolowT=0
apoloeT=0
kpoloeT=0
labpoloeT=0.0

! fill in values for final steady ss policy fns
IF (dorloop==0) THEN ! exogenous prices, pol fns constant after T0+T1
	DO i=T0+T1+1,Ttrans
		apolyT(:,:,:,i)=apoly2ss
		kpolyT(:,:,:,i)=kpoly2ss
		labpolyT(:,:,:,i)=labpoly2ss
		apolowT(:,i)=apolow2ss
		apoloeT(:,:,i)=apoloe2ss
		kpoloeT(:,:,i)=kpoloe2ss
		labpoloeT(:,:,i)=labpoloe2ss
	END DO
ELSE  ! endo prices, pol fns potentially change over all of Ttrans
	DO i=Ttransold,Ttrans
		apolyT(:,:,:,i)=apoly2ss
		kpolyT(:,:,:,i)=kpoly2ss
		labpolyT(:,:,:,i)=labpoly2ss
		apolowT(:,i)=apolow2ss
		apoloeT(:,:,i)=apoloe2ss
		kpoloeT(:,:,i)=kpoloe2ss
		labpoloeT(:,:,i)=labpoloe2ss
	END DO
END IF

IF (switchlabsupproptax==0) THEN
    !define staxw and staxe. note that totincw is fixed over transition and final ss
    staxw=staxwbase*totincw**(-ptaxw)
    staxe=staxebase*totincw**(-ptaxe)
END IF

wagepath=0.0 ! This is just an initialization 
rbarpath=0.0
IF (dorloop.EQ.1) THEN 
    ! defining initial (linear) guess for rbarpath
    rbarpath(1)=rbar1ss
    rbarpath(Ttransold:Ttrans)=rbar2ss
    CALL linspace(DBLE(2.0),DBLE(Ttransold-1.0),Ttransold-2,cacca3v)
    CALL interplin(2,(/ DBLE(1.0), DBLE(Ttransold)/),(/rbar1ss, rbar2ss /), &
		    Ttransold-2,cacca3v,rbarpath(2:Ttransold-1))
    IF (loadrpathold==1) THEN
	    fname="rpath"
	    ! loading rbarpath from previous run
	    open (unit=32,file=fname,status="old", &
	    &       action="READ", position="rewind",iostat=OpenStatus)
		    IF (OpenStatus.NE.0) THEN
		    WRITE(*,*) 'problems opening ', fname
	    END IF
		READ (unit=32,fmt=*) cacca ! rbparpath(1)
	    DO i=2,Ttransold-1
		    READ(unit=32,fmt=*) rbarpath(i)
	    END DO
	    CLOSE (unit=32)
    END IF
    ! compute rate of return from saving
    ibarpath=0.0 ! This is just an initialization
    DO i=1,T0
        ibarpath(i)=rbarpath(i)-phivec(i)
    END DO
    DO i=T0+1,Ttrans
        ibarpath(i)=rbarpath(i)-phivec(T0+1)
    END DO
ELSE
    IF (fixibar.EQ.0) THEN
        IF (ABS(rbar1ss-rbar2ss)>1e-06) THEN
            WRITE(*,*) 'rbar does not coincide in the initial and final ss'
            STOP
        END IF
        rbarpath=rbar1ss
        ibarpath=0.0 ! This is just an initialization
        DO i=1,T0
            ibarpath(i)=rbarpath(i)-phivec(i)
        END DO
        DO i=T0+1,Ttrans
            ibarpath(i)=rbarpath(i)-phivec(T0+1)
        END DO
    ELSE    
        IF (ABS(rbar1ss-phivec(1)-rbar2ss+phivec(T0+1))>1e-06) THEN
            WRITE(*,*) 'ibar does not coincide in the two SS or phivec is incorrect'
            STOP
        END IF
        ibarpath=rbar1ss-phivec(1)
        rbarpath=0.0 ! This is just an initialization
        DO i=1,T0
            rbarpath(i)=ibarpath(i)+phivec(i)
        END DO
        DO i=T0+1,Ttrans
            rbarpath(i)=ibarpath(i)+phivec(T0+1)
        END DO
    END IF
END IF
   
DO i=1,T0
	wagepath(i)=(1.0-alph)*abigvec(i)*tfpvec(i)*((xivec(i)*rbarpath(i)+(1.0-xivec(i))*ibarpath(i)+delt)/(alph*abigvec(i)*tfpvec(i)))**(alph/(alph-1.0))
END DO
DO i=T0+1,Ttrans
    wagepath(i)=(1.0-alph)*abigvec(T0+1)*tfpvec(T0+1)*((xivec(T0+1)*rbarpath(i)+(1.0-xivec(T0+1))*ibarpath(i)+delt)/(alph*abigvec(T0+1)*tfpvec(T0+1)))**(alph/(alph-1.0))
END DO
    
! initial and final values are never updated, so we simply define them here
rimpliedT(1)=rbar1ss
rimpliedT(Ttrans)=rbar2ss

! Under old NIPA accounting, this is only consumption of goods; aggregate consumption includes financial services
aggrconsgoodsT(1)=(tottaxcw1ss+tottaxce1ss)*(1.0+tauc)/tauc
aggrconsgoodsT(Ttrans)=(tottaxcw2ss+tottaxce2ss)*(1.0+tauc)/tauc
IF (oldnipaswitch==1) THEN
    aggrconstotT(1)=aggrconsgoodsT(1)+phivec(1)*capintermedT(1)
    aggrconstotT(Ttrans)=aggrconsgoodsT(Ttrans)+phivec(T0+1)*capintermedT(Ttrans)
ELSE
    aggrconstotT(1)=aggrconsgoodsT(1)
    aggrconstotT(Ttrans)=aggrconsgoodsT(Ttrans)
END IF 
    
wageimpliedT(1)=(1.0-alph)*abigvec(1)*tfpvec(1)*((xivec(1)*rbarpath(1)+(1.0-xivec(1))*ibarpath(1)+delt)/(alph*abigvec(1)*tfpvec(1)))**(alph/(alph-1.0))
wageimpliedT(Ttrans)=(1.0-alph)*abigvec(T0+1)*tfpvec(T0+1)*((xivec(T0+1)*rbarpath(Ttrans)+(1.0-xivec(T0+1))*ibarpath(Ttrans)+delt)/&
    &(alph*abigvec(T0+1)*tfpvec(T0+1)))**(alph/(alph-1.0))

! define initial guess for tax path
! define taubalpath
taubalpath=0.0 ! just an initialization
taubaladj=0.01  ! additional taubal
IF (dogovloop.EQ.1) THEN
    taubalpath(1:T0)=taubal1ss
    taubalpath(T0+1:T0+T1)=taubal1ss+taubaladj
    taubalpath(T0+T1+1:Ttrans)=taubal2ss		
ELSEIF (ABS(taubal1ss-taubal2ss)<1e-04) THEN
        taubalpath=taubal1ss
ELSE
    WRITE(*,*) 'dogovloop=0 but taxes are not equal in the two SS'
    STOP
END IF

! initialize error for r bar computation and counter for prices loop
epsir=1.0
iterar=1

fname="rpath"
open (unit=32,file=fname,status="replace", &
	&       action="WRITE",position="rewind",iostat=OpenStatus)
	IF (OpenStatus.NE.0) THEN
		WRITE(*,*) 'problems opening ', fname
	END IF
	WRITE(unit=32,fmt=*) Ttrans
CLOSE (unit=32)	
	
! We now have all the elements to compute the path for the labor supply
IF (switchlabsupproptax==2) THEN
    labsupT=(wagepath*(1.0-taubalpath)/(omega*(1.0+tauc)))**(1/psii) ! this is just an initialization
ELSE
    labsupT=1.0
    labsup=1.0
END IF

! loop on equilibrium interest rate path
DO WHILE (epsir>epsirmin)    		
	epsigov=10.0
	bracketgov=1 ! need to compute first bound for taucadjust
	iteragovbal=0
	havetaubalmin=0
	DO WHILE (epsigov>epsigovmin)
		
		WRITE(*,*) "****************************** "
		WRITE(*,*) "iteragovbal=", iteragovbal
		WRITE(*,*) "iterar=", iterar
		WRITE(*,*) "****************************** "
					
		iteragovbal=iteragovbal+1
		
		fname="rpath"
		open (unit=32,file=fname,status="replace", &
		&       action="WRITE",position="rewind",iostat=OpenStatus)
		IF (OpenStatus.NE.0) THEN
			WRITE(*,*) 'problems opening ', fname
		END IF
		DO i=1,Ttrans
			WRITE(unit=32,fmt=*) rbarpath(i)
		END DO
		CLOSE (unit=32)	
		
		! define index to compute pol funs and val fun: up to T0+T1 if exo prices,
		! up to Ttransold-1 if endo prices
		IF (dorloop==0) THEN 
			Tfinal=T0+T1
		ELSE
			Tfinal=Ttransold-1
		END IF
		
		! reinitialize final ss from correct value
		Vynext=Vynext2ss
		Voenext=Voenext2ss
		Vownext=Vownext2ss
		kyhat=dk ! This is now just an initialization
		kohat=dk

		! ***************************************************************************
		! Go backward in time to compute value funs and pol funs starting from FINAL SS				
		! ***************************************************************************		
		DO Ttime=Tfinal,2,-1 
			rbar=rbarpath(Ttime)		
			wage=wagepath(Ttime)
			ibar=ibarpath(Ttime)
			abig=abigvec(MIN(Ttime,1+T0))
			phi=phivec(MIN(Ttime,1+T0))
			xi=xivec(MIN(Ttime,1+T0))
			tfp=tfpvec(MIN(Ttime,1+T0))
			eff=effvec(MIN(Ttime,1+T0))			
			taubal=taubalpath(Ttime)
			
			! define useful constants
			term1=1.0/((1.0-alphe)*ni-1.0)
			front1=(wage/(ni*(1.0-alphe)))**term1	

			WRITE(*,*) "TtimeFIRST", Ttime
		
			IF (switchlabsupproptax==2) THEN ! If the labor supply is exogenous, it is equal to 1 and never revised
                labsup=(wage*(1.0-taubal)/(omega*(1.0+tauc)))**(1/psii)
            END IF
            transf=replrate*wage*labsup*DOT_PRODUCT(y,invy)					
            				
			! we now compute U(c) since it does not depend on V and borrowing constr
			uconsold=0.0    ! old retired.   rows=a, column=a'
			DO i=1,da ! today's assets
				ytaxo=transf+ibar*a(i)
				IF (switchlabsupproptax==0) THEN
    				taxo=(btaxw-btaxw*(staxw*ytaxo**ptaxw+1.0)**(-1.0/ptaxw))*ytaxo+taubal*ytaxo
    		    ELSE
    		        taxo=taubal*ytaxo
    		    END IF    
				cs=(a(i)*(1.0+ibar)+transf-a-taxo)/(1.0+tauc)
				WHERE (cs>0)
					ucons=(cs**(1.0-gam))/(1.0-gam)
				ELSEWHERE
					ucons=penalty
				END WHERE
				uconsold(i,:)=ucons
			END DO

			uconsw=0.0  ! young worker  (da,da',dy) note: does not depend on r!
			DO i=1,da ! today
				DO j=1,dy ! today's y
					ytaxw=wage*y(j)*labsup+ibar*a(i)
					IF (switchlabsupproptax==0) THEN
    					taxw=(btaxw-btaxw*(staxw*ytaxw**ptaxw+1.0)**(-1.0/ptaxw))*ytaxw+taubal*ytaxw
    			    ELSE
    			        taxw=taubal*ytaxw
    			    END IF
    			    cs=((1.0+ibar)*a(i)+wage*y(j)*labsup-taxw-a)/(1.0+tauc)
                    WHERE (cs>omega*y(j)/(1+psii)*labsup**(1+psii)) 
                        ucons=((cs-omega*y(j)/(1+psii)*labsup**(1+psii))**(1.0-gam))/(1.0-gam)
                    ELSEWHERE 
                        ucons=penalty
                    END WHERE
                    uconsw(i,:,j)=ucons
				END DO
			END DO
			
			uconse=0.0  !   entrep, flow utility for young and old is the same (da,da',dr,dk)
            DO i=1,da       !today's assets
                DO j=2,dr   ! today's r ! changed from dy=1,dr
				    labe=front1*(r(j)*tfp)**(-term1)*k**(-alphe*ni*term1) 
                    labe=max(0.0,labe-1.0)                              
                    ytaxe=r(j)*tfp*(k**alphe*(1.0+labe)**(1.0-alphe))**ni-delt*k-rbar*max(0.0,k-a(i))+ibar*max(0.0,a(i)-k)-wage*labe 
                    IF (switchlabsupproptax==0) THEN
                        taxe=(btaxe-btaxe*(staxe*ytaxe**ptaxe+1.0)**(-1.0/ptaxe)) &
                        &   *ytaxe+taubal*ytaxe
                    ELSE
                        taxe=taubal*ytaxe
                    END IF 
                    DO jj=1,da  ! tomorrow's a'
                        csl=(ytaxe-taxe+a(i)-a(jj))/(1.0+tauc)
                        WHERE (csl>omega*y(j)/(1+psii))  
                            uconsl=((csl-omega*y(j)/(1+psii))**(1.0-gam))/(1.0-gam) 
                        ELSEWHERE 
                            uconsl=penalty
                        END WHERE
                        uconse(i,jj,j-1,:)=uconsl 
                    END DO
                END DO 
            END DO
					
			! regardless of type of bc, impose that people with r=0 cannot borrow (it would be true anyway)
		    ! might as well save computations
			kyhat(:,:,1)=0 
			kohat(:,1)=0
		
			! compute expected value of V of NEWBORNS
			! only NEWBORN ENTREPRENEUR, INHERITS parent's r'
			EVnewbw=0.0
			EVnewbe=0.0
		    DO i=1,dy ! tomorrow
				DO j=1,dr
				    CALL interplin(da,a,Vynext(:,i,j),da,anet,Vynet)
					EVnewbw=invyr((i-1)*dr+j)*Vynet+EVnewbw
			        EVnewbe(:,j)=invy(i)*Vynet+EVnewbe(:,j)
			   END DO
			END DO

			!loop for OLD WORKER
			DO i=1,da ! today's assets
				Vowtemp=uconsold(i,:)+bet*pold*Vownext+eta*bet*(1.0-pold)*EVnewbw
				imax=MAXLOC(Vowtemp)
				newVow(i)=Vowtemp(imax(1))
				apolowT(i,Ttime)=imax(1)
				newVoe(i,1)=newVow(i)
				apoloeT(i,1,Ttime)=apolowT(i,Ttime)
				kpoloeT(i,1,Ttime)=-1  
				labpoloeT(i,1,Ttime)=0.0           
		    END DO

			! loop for old entrepreneur 
			! entrepreneur staying entrepreneur
			CALL interplin(da,a,newVow,dk,eff*k,Vokeff)	
			DO i=1,da       !today's assets
				DO j=2,dr   ! today's r								
					DO jj=1,da  ! tomorrow's a'
						Voeetemp(:,jj)=uconse(i,jj,j-1,:)+&
							&   bet*pold*DOT_PRODUCT(Voenext(jj,:),Pr(j,:))+&
			                &   eta*bet*(1.0-pold)*DOT_PRODUCT(EVnewbe(jj,:),Pr(j,:))
					END DO
					
					IF (switchbc.EQ.0) THEN ! do this only with endogenous bc
					    kohat(i,j)=dk					
					    DO jj=dk,1,-1 ! Today's k
					        ! MAXVAL(Voeetemp(jj,:)) is the best utility, for given k (investment) when we can choose next period's savings.
					        ! two cases:
					        ! a) if this optimal value is smaller than the utility from defaulting (Vokeff(jj)), never allow this investment level 
					        ! (impose penalty in valfun) and re-adjust kohat. Keep going with a lower dk, until we are out of this case 					 
					        ! b) if this optimal value is larger than the utility from defaulting (Vokeff(jj)), then we just go on with the 
					        ! occupational choice below and we do not need to update kohat
					        ! NON-MONOTONICITY COMPLICATION: It is possible that the incentive to run is non-monotone in k. In that case, we let 
					        ! kohat be the largest one for which we don't run. That is why kohat does not get updated, while we still impose the 
					        ! utility penalty. To make sure that we don't run into problems.
						    IF (MAXVAL(Voeetemp(jj,:))<Vokeff(jj)) THEN
							    Voeetemp(jj,:)=penalty
							    IF (kohat(i,j)==jj) THEN
								    kohat(i,j)=jj-1
    							END IF
	    					END IF  
		    			END DO ! jj
                    ELSE    !switchbc=1 or unchanged bc from steady state
                        kohat(i,j)=kohat2ss(i,j)
	                    IF (kohat2ss(i,j).LT.dk) THEN
                            !** when cannot borrow (kohat=last at which one can borrow)
                            Voeetemp(kohat2ss(i,j)+1:,:)=penalty
                        END IF	    		    
		    		END IF ! (switchbc.EQ.0) THEN
					
					imaxmat=MAXLOC(Voeetemp)
					Voee(i,j)=Voeetemp(imaxmat(1),imaxmat(2))
					IF (Voee(i,j).GT.newVow(i)) THEN 
						newVoe(i,j)=Voee(i,j)
						apoloeT(i,j,Ttime)=imaxmat(2)
						kpoloeT(i,j,Ttime)=imaxmat(1)
						labdemand=front1*(r(j)*tfp)**(-term1)*k(kpoloeT(i,j,Ttime))**(-alphe*ni*term1)
						labpoloeT(i,j,Ttime)=max(0.0,labdemand-1.0)
					ELSE
						newVoe(i,j)=newVow(i)
						apoloeT(i,j,Ttime)=apolowT(i,Ttime)
						kpoloeT(i,j,Ttime)=-1  
						labpoloeT(i,j,Ttime)=0.0            							
					END IF
				END DO ! j, today's r
			END DO ! i, today's assets
			
			EVy=0.0
			DO i=1,dy                   !today
				DO j=1,dr
					DO i2=1,dy          !tomorrow
						DO j2=1,dr
							EVy(:,i,j)=Pyr((i-1)*dr+j,(i2-1)*dr+j2)*&
							& Vynext(:,i2,j2)+EVy(:,i,j)
						END DO
					END DO
				END DO
			END DO

			!val fn for young that is a worker for the period
			DO i=1,da ! today
				DO j=1,dy ! today's y
					DO jj=1,dr ! todays' r
						Vywtemp=uconsw(i,:,j)+bet*pyou*EVy(:,j,jj)+&
							&   bet*(1.0-pyou)*Vownext
						imax=MAXLOC(Vywtemp)
						newVyw(i,j,jj)=Vywtemp(imax(1))
						apolyw(i,j,jj)=imax(1)
					END DO
				END DO
			END DO

			! NOTE THAT THE ** YOUNG** GUYS WITH ZERO ENTR ABILITY
			! ALWAYS CHOOSE TO BE WORKERS, BECAUSE THIS WAY THEY GET
			! THE WAGE. LET'S EXPLOIT THIS
			! val fn for young that is a ENTR for the period
			! LET US COMPUTE IT ONLY FOR GUYS WITH POSITIVE R
			! young entrepreneur decisions
			! here we incorporate the borrowing constraint
			DO i=1,da       !today's assets
				DO j=2,dr   ! today's r ! changed from dy=1,dr
					DO j1=1,dy  !today's y
						CALL interplin(da,a,newVyw(:,j1,j),dk,eff*k,Vwkeff(:,j1,j))
						DO jj=1,da  ! tomorrow's a'
							Vyetemp(:,jj)=uconse(i,jj,j-1,:)+ &
				            &   bet*pyou*EVy(jj,j1,j)+ &
					        &   bet*(1.0-pyou)*DOT_PRODUCT(Voenext(jj,:),Pr(j,:))
						END DO

					    IF (switchbc.EQ.0) THEN ! do this only with endogenous bc
						    kyhat(i,j1,j)=dk
						    DO jj=dk,1,-1 ! Today's k
							    IF (MAXVAL(Vyetemp(jj,:))<Vwkeff(jj,j1,j)) THEN
								    Vyetemp(jj,:)=penalty
								    IF (kyhat(i,j1,j)==jj) THEN
									    kyhat(i,j1,j)=jj-1
								    END IF
							    END IF
						    END DO ! jj
						ELSE   ! switchbc=1 bc as in steady states
                            ! impose kyhat
                            kyhat(i,j1,j)=kyhat2ss(i,j1,j)
                            IF (kyhat2ss(i,j1,j).LT.dk) THEN
                                Vyetemp(1+kyhat2ss(i,j1,j):,:)=penalty
                            END IF  
						END IF

						imaxmat=MAXLOC(Vyetemp)
						newVye(i,j1,j)=Vyetemp(imaxmat(1),imaxmat(2))
						apolye(i,j1,j)=imaxmat(2)
						kpolye(i,j1,j)=imaxmat(1)

						! YOUNG decide if e or w, include labor demand here
					    IF (newVye(i,j1,j).GT.newVyw(i,j1,j)) THEN
							newVy(i,j1,j)=newVye(i,j1,j)
						    apolyT(i,j1,j,Ttime)=apolye(i,j1,j)
						    kpolyT(i,j1,j,Ttime)=kpolye(i,j1,j)
							labdemand=front1*(r(j)*tfp)**(-term1)*k(kpolyT(i,j1,j,Ttime))**(-alphe*ni*term1)
							labpolyT(i,j1,j,Ttime)=max(0.0,labdemand-1.0)
						ELSE
							newVy(i,j1,j)=newVyw(i,j1,j)
						    apolyT(i,j1,j,Ttime)=apolyw(i,j1,j)
						    kpolyT(i,j1,j,Ttime)=-1
							labpolyT(i,j1,j,Ttime)=0.0
						END IF
					END DO !j1=1,dy  !today's y
				END DO
			END DO

			! now use the fact that YOUNG guys with r=0 always choose
			! to be workers
			kyhat(:,:,1)=0
			newVye(:,:,1)=newVyw(:,:,1)
			apolye(:,:,1)=apolyw(:,:,1)
			kpolye(:,:,1)=-1
			newVy(:,:,1)=newVyw(:,:,1)
			apolyT(:,:,1,Ttime)=apolyw(:,:,1)
			kpolyT(:,:,1,Ttime)=-1
			labpolyT(:,:,1,Ttime)=0.0			
		
			Vownext=newVow ! iterate vfs over time: for t, take t+1 val fun as given
			Voenext=newVoe
			Vynext=newVy	
			
		END DO ! DO Ttime=Tfinal,2 this is the backward loop
						
		! SAVE VALUE FUNCTIONS FOR WELFARE COMPARISON WITH INITIAL ss
		! IT IS THE ONE FOR Ttime=2 
		CALL printvalfunT2(directoryname)

		IF (savepolfun.EQ.1) THEN
            CALL printpolfunT(directoryname)
        END IF
		
		! ***************************************************************************
		! computed value funs and pol funs starting from FINAL SS				
		! ***************************************************************************
		! init
		taxeslesstransfT=0.0

		! ********************************************************************************
		! go forward in time from initial SS, compute time path of aggregates and govt bc
		! ********************************************************************************
		invm=invm1ss ! every time we change tau, we need to restart from initial ss

		! define index to compute transition matrix: up to T0+T1+1 if exo prices,
		! up to Ttransold if endo prices
		IF (dorloop==0) THEN  ! if fixed prices, no need to compute invm after T1
			Tfinal=T0+T1+1
		ELSE
			Tfinal=Ttransold
		END IF

		DO Ttime=2,Ttrans-1 			
			rbar=rbarpath(Ttime)
		    wage=wagepath(Ttime)
			ibar=ibarpath(Ttime)
            abig=abigvec(MIN(Ttime,1+T0))
			phi=phivec(MIN(Ttime,1+T0))
			xi=xivec(MIN(Ttime,1+T0))
            tfp=tfpvec(MIN(Ttime,1+T0))
            eff=effvec(MIN(Ttime,1+T0))
			taubal=taubalpath(Ttime)
				
            IF (switchlabsupproptax==2) THEN ! If the labor supply is exogenous, it is equal to 1 and never revised
                labsup=(wage*(1.0-taubal)/(omega*(1.0+tauc)))**(1/psii)
            END IF
            transf=replrate*wage*labsup*DOT_PRODUCT(y,invy)			
			
			! define useful constants
			term1=1.0/((1.0-alphe)*ni-1.0)
			front1=(wage/(ni*(1.0-alphe)))**term1	
			
            ! compute a bunch of stuff using the distribution at the beginning of the period       
			! distribution of a on people that were young workers in the previous period and remained young
            ! into this period, or children of people that were retirees in the previous period
			prgridyw=0.0
			DO i2=1,dy*dr
				prgridyw=prgridyw+invm((i2-1)*da+1:i2*da)
			END DO
			! same for people that were young entrepreneurs in the previous period and remain young into this period,
            ! or children of people that were old entrepreneurs in the previous period
			prgridye=0.0
			DO i2=1,dy*dr
				prgridye=prgridye+invm(nyoung+(i2-1)*da+1:nyoung+i2*da)
			END DO
			! same for people that were entrepreneurs last period (young or old) and are old today
			prgridoe=0.0
			DO i2=1,dr
				prgridoe=prgridoe+invm(2*nyoung+(i2-1)*da+1:2*nyoung+i2*da)
			END DO
			! same for people that were young workers last period and have become old, or old retirees last period that remain old
			prgridow=invm(nstates-da+1:)
			!total distribution for assets at the beginning of period
			prgrid=prgridyw+prgridye+prgridoe+prgridow
			
			invlevk=0.0 ! k level ...
			invrk=0.0   ! return corresp. to each element of invm (except old work)
			invkgrossborr=0.0 ! gross borrowing
			invlabe=0.0 ! outside labor demand to invm
			invtotlabe=0.0 ! tot. labor demand to invm
            ifswitchew=0    ! 1 if switch from e to non e (w or ret)
            ifswitchwe=0    ! 1 if switch from w to e
			toteffL=0.0    ! tot. eff. units (.neq.totL bcs entr choice depends on y).
			totentr=0.0 ! fraction of entrepreneurs
			totL=0.0 ! fraction of workers
			counter=1
			DO l=1,dr   ! young workers
				invrk((l-1)*da*dy+1:l*da*dy)=r(l)
				DO j=1,dy
					DO i=1,da
						IF (kpolyT(i,j,l,Ttime).GT.0) THEN
							invlevk(counter)=k(kpolyT(i,j,l,Ttime))
							invkgrossborr(counter)=max(0.0,k(kpolyT(i,j,l,Ttime))-a(i))
						    invlabe(counter)=labpolyT(i,j,l,Ttime)
							invtotlabe(counter)=1.0+invlabe(counter)
							ifswitchwe(counter)=1
							totentr=totentr+invm((l-1)*da*dy+(j-1)*da+i)
						ELSE
							toteffL=toteffL+y(j)*invm((l-1)*da*dy+(j-1)*da+i)*labsup
							totL=totL+invm((l-1)*da*dy+(j-1)*da+i)
						END IF
						counter=counter+1
					END DO
				END DO
			END DO
			DO l=1,dr   ! young entrepreneurs
				invrk(nyoung+(l-1)*da*dy+1:nyoung+l*da*dy)=r(l)
				DO j=1,dy
					DO i=1,da
						IF (kpolyT(i,j,l,Ttime).GT.0) THEN
							invlevk(counter)=k(kpolyT(i,j,l,Ttime))
							invkgrossborr(counter)=max(0.0,k(kpolyT(i,j,l,Ttime))-a(i))
							invlabe(counter)=labpolyT(i,j,l,Ttime)
							invtotlabe(counter)=1.0+invlabe(counter)
							totentr=totentr+invm(nyoung+(l-1)*da*dy+(j-1)*da+i)
						ELSE
						    ifswitchew(counter)=1
							toteffL=toteffL+y(j)*invm(nyoung+(l-1)*da*dy+(j-1)*da+i)*labsup
							totL=totL+invm(nyoung+(l-1)*da*dy+(j-1)*da+i)
						END IF
						counter=counter+1
					END DO
				END DO
			END DO
			DO l=1,dr   !   old entrepreneurs
				invrk(2*nyoung+(l-1)*da+1:2*nyoung+l*da)=r(l)
				DO i=1,da
					IF (kpoloeT(i,l,Ttime).GT.0) THEN
						invlevk(counter)=k(kpoloeT(i,l,Ttime))
						invkgrossborr(counter)=max(0.0,k(kpoloeT(i,l,Ttime))-a(i))
						invlabe(counter)=labpoloeT(i,l,Ttime)
						invtotlabe(counter)=1.0+invlabe(counter)
						totentr=totentr+invm(2*nyoung+(l-1)*da+i)
                    ELSE
                        ifswitchew(counter)=1
					END IF
					counter=counter+1
				END DO
			END DO
			
			totentrT(Ttime)=totentr
			totLT(Ttime)=totL
            toteffLT(Ttime)=toteffL			
            ! compute number of retirees
			totret=1.0-totentr-totL
			
			! capital and effective outside labor EMPLOYED by entr
			totkT(Ttime)=DOT_PRODUCT(invlevk,invm(:nstates-da))
			hiredlabe=DOT_PRODUCT(invlabe,invm(:nstates-da))
			hiredlabeT(Ttime)=hiredlabe
			
			! fraction of e switching from e to y and from y to e
            propewswitchT(Ttime)=DOT_PRODUCT(ifswitchew,invm)/totentrT(Ttime-1)
            propweswitchT(Ttime)=DOT_PRODUCT(ifswitchwe,invm)/totLT(Ttime-1)
			
			invrky=invrk(:2*nyoung)
			invrko=invrk(2*nyoung+1:nstates-da)
			invlevky=invlevk(:2*nyoung)
			invlevko=invlevk(2*nyoung+1:nstates-da)
			invtotlabye=invtotlabe(:2*nyoung)
			invtotlaboe=invtotlabe(2*nyoung+1:nstates-da)
			invmy=invm(:2*nyoung)
			invmo=invm(2*nyoung+1:nstates-da)
			! GROSS entr. output
			! note inck includes wages paid  interest owed and depr. 
			incky=DOT_PRODUCT(invrky*tfp*(invlevky**alphe*invtotlabye**(1.0-alphe))**ni,invmy)
			incko=DOT_PRODUCT(invrko*tfp*(invlevko**alphe*invtotlaboe**(1.0-alphe))**ni,invmo)
			inckT(Ttime)=incky+incko
			
			totaT(Ttime)=DOT_PRODUCT(a,prgrid)
			totayw=DOT_PRODUCT(a,prgridyw)
			totaye=DOT_PRODUCT(a,prgridye)
			totaow=DOT_PRODUCT(a,prgridow)
			totaoe=DOT_PRODUCT(a,prgridoe)
		
			! check need to check positivity
			totlcorpT(Ttime)=toteffL-hiredlabe  ! total effective labor in corporate sector
			
			IF (totlcorpT(Ttime) .LE. 0.0) THEN
				WRITE(*,*) 'totlcorpT(Ttime)', totlcorpT(Ttime)
				WRITE(*,*) 'LABOR IN CORP SECTOR IS NEGATIVE'
				STOP
			END IF
			
			totkgrossborrT(Ttime)=DOT_PRODUCT(invkgrossborr,invm(:nstates-da))
			
			!************************
			!   compute tax revenues
			vectaxcw=0.0
			vectaxce=0.0
			vectaxl=0.0
			vectaxe=0.0
			vectaxbw=0.0
			vectaxbe=0.0
			!compute average income workers
			counter=1
			DO l=1,dr   ! young workers
				rhere=r(l)
				DO j=1,dy
					DO i=1,da
						ahere=a(apolyT(i,j,l,Ttime))
						IF (kpolyT(i,j,l,Ttime).GT.0) THEN
							khere=k(kpolyT(i,j,l,Ttime))
							lhere=labpolyT(i,j,l,Ttime)
							entinchere=rhere*tfp*(khere**alphe*(1.0+lhere)**(1.0-alphe))**ni-delt*khere-rbar*max(0.0,khere-a(i))+&
							&ibar*max(0.0,a(i)-khere)-wage*lhere
							IF (switchlabsupproptax==0) THEN
    							vectaxe(counter)=(btaxe-btaxe*(staxe*entinchere**ptaxe+1.0) &
	    						&   **(-1.0/ptaxe))*entinchere+taubal*entinchere
	    					ELSE
	    					    vectaxe(counter)=taubal*entinchere
	    					END IF
							vectaxce(counter)=tauc*(entinchere-vectaxe(counter) &
							& +a(i)-ahere)/(1.0+tauc)	
						ELSE
							winchere=wage*labsup*y(j)+ibar*a(i)
							IF (switchlabsupproptax==0) THEN
    							vectaxl(counter)=(btaxw-btaxw*(staxw*winchere**ptaxw+1.0)**(-1.0/ptaxw))&
	    						&   *winchere+taubal*winchere
	    					ELSE
	    					    vectaxl(counter)=taubal*winchere
	    					END IF						
							vectaxcw(counter)=tauc*(a(i)+winchere &
							&   -vectaxl(counter)-ahere)/(1.0+tauc)
						END IF
						counter=counter+1
					END DO
				END DO
			END DO
				
			DO l=1,dr   ! young entrepreneurs
				rhere=r(l)
				DO j=1,dy
					DO i=1,da
						ahere=a(apolyT(i,j,l,Ttime))
						IF (kpolyT(i,j,l,Ttime).GT.0) THEN
							khere=k(kpolyT(i,j,l,Ttime))
							lhere=labpolyT(i,j,l,Ttime)
							entinchere=rhere*tfp*(khere**alphe*(1.0+lhere)**(1.0-alphe))**ni-delt*khere-rbar*max(0.0,khere-a(i))+&
							&ibar*max(0.0,a(i)-khere)-wage*lhere
							IF (switchlabsupproptax==0) THEN
    							vectaxe(counter)=(btaxe-btaxe*(staxe*entinchere**ptaxe+1.0) &
	    						&   **(-1.0/ptaxe))*entinchere+taubal*entinchere
	    					ELSE
	    					    vectaxe(counter)=taubal*entinchere
	    					END IF
							vectaxce(counter)=tauc*(entinchere-vectaxe(counter) &
							& +a(i)-ahere)/(1.0+tauc)											
						ELSE
							winchere=wage*labsup*y(j)+ibar*a(i)
							IF (switchlabsupproptax==0) THEN
    							vectaxl(counter)=(btaxw-btaxw*(staxw*winchere**ptaxw+1.0)**(-1.0/ptaxw))&
	    						&   *winchere+taubal*winchere	
	    					ELSE
	    					    vectaxl(counter)=taubal*winchere
	    					END IF
							vectaxcw(counter)=tauc*(a(i)+winchere &
							&   -vectaxl(counter)-ahere)/(1.0+tauc) 
						END IF
						counter=counter+1
					END DO
				END DO
			END DO
			DO l=1,dr   !   old entrepreneurs
				rhere=r(l)
				DO i=1,da
					ahere=a(apoloeT(i,l,Ttime))
					IF (kpoloeT(i,l,Ttime).GT.0) THEN
						khere=k(kpoloeT(i,l,Ttime))
						lhere=labpoloeT(i,l,Ttime)
						entinchere=rhere*tfp*(khere**alphe*(1.0+lhere)**(1.0-alphe))**ni-delt*khere-rbar*max(0.0,khere-a(i))+&
						&ibar*max(0.0,a(i)-khere)-wage*lhere
						IF (switchlabsupproptax==0) THEN
    						vectaxe(counter)=(btaxe-btaxe*(staxe*entinchere**ptaxe+1.0) &
	    					&   **(-1.0/ptaxe))*entinchere+taubal*entinchere
	    				ELSE
	    				    vectaxe(counter)=taubal*entinchere
	    				END IF
						vectaxce(counter)=tauc*(entinchere-vectaxe(counter) &
						& +a(i)-ahere)/(1.0+tauc)
						vectaxbe(counter)=max(0.0,(ahere-exem))*taub
					ELSE
						winchere=transf+ibar*a(i)
						IF (switchlabsupproptax==0) THEN
    						vectaxl(counter)=(btaxw-btaxw*(staxw*winchere**ptaxw+1.0)**(-1.0/ptaxw))*winchere &
	    					& +taubal*winchere					
	    				ELSE
	    				    vectaxl(counter)=taubal*winchere
	    				END IF
						vectaxcw(counter)=tauc*(a(i)+winchere-ahere-vectaxl(counter))/(1.0+tauc)
						vectaxbw(counter)=max(0.0,(ahere-exem))*taub
		 			END IF
					counter=counter+1
				END DO
			END DO
		
			DO i=1,da  !    old retirees
				ahere=a(apolowT(i,Ttime))
				winchere=transf+ibar*a(i)
				IF (switchlabsupproptax==0) THEN
    				vectaxl(counter)=(btaxw-btaxw*(staxw*winchere**ptaxw+1.0)**(-1.0/ptaxw))*winchere &
	    			& +taubal*winchere
	    		ELSE
	    		    vectaxl(counter)=taubal*winchere
	    		END IF	
				vectaxcw(counter)=tauc*(a(i)+winchere-ahere-vectaxl(counter))/(1.0+tauc) 
				vectaxbw(counter)=max(0.0,(ahere-exem))*taub
				counter=counter+1
			END DO
			tottaxl=DOT_PRODUCT(invm,vectaxl)
			tottaxe=DOT_PRODUCT(invm,vectaxe)
			tottaxcw=DOT_PRODUCT(invm,vectaxcw)
			tottaxce=DOT_PRODUCT(invm,vectaxce)
			! Revenues from bequest taxes arrive only at the beginning of the subsequent period. However, they arrive in time
		    ! to collect interest in the subsequent period, so in present value it is as if they were collected today
		    ! As an alternative interpretation, government debt is measured after bequest tax revenues have come in at the beginning of the period
			tottaxbw=DOT_PRODUCT(invm,vectaxbw)*(1.0-pold)
    		tottaxbe=DOT_PRODUCT(invm,vectaxbe)*(1.0-pold)
			
			taxeslesstransfT(Ttime)=tottaxl+tottaxe+tottaxcw+tottaxce+tottaxbw+tottaxbe-transf*totret
			
			! Under old NIPA accounting, this is only consumption of goods; aggregate consumption includes financial services
			aggrconsgoodsT(Ttime)=(tottaxce+tottaxcw)*(1.0+tauc)/tauc
			
			WRITE(*,*) 'TTime =', Ttime
			WRITE(*,*) 'tottaxl =', tottaxl
			WRITE(*,*) 'tottaxe =', tottaxe
			WRITE(*,*) 'tottaxcw =', tottaxcw
			WRITE(*,*) 'tottaxce =', tottaxce
			WRITE(*,*) 'transf =', transf
			WRITE(*,*) 'totret =', totret
			WRITE(*,*) 'sum(prigridoe) =', SUM(prgridoe)
			WRITE(*,*) 'Totentr =', totentr
			WRITE(*,*) 'TotL =', totL
			
			IF (Ttime.LE.Tfinal) THEN			   		
				! constructing the TRANSITION MATRIX in sparse form
				! sparse=row indices, col indices, values			
				! order of the transition matrix:
				! y workers-        r - y - assets
				! y entrepreneurs-  r - y - assets
				! old entr          r -     assets
				! old                       assets
				!
				rowM=0
				colM=0
				valM=0.0
				!***************** assets net of bequest taxes
                DO i=1,da
                    IF (a(apolowT(i,Ttime)).LE.exem) THEN
                        apolownet(i)=apolowT(i,Ttime)
                    ELSE
                        indanet=MINLOC(ABS(a-(1-taub)*(a(apolowT(i,Ttime))-exem)-exem))
                        apolownet(i)=indanet(1)
                    END IF
                END DO
                DO i=1,da
                    DO j=1,dr
                        IF (a(apoloeT(i,j,Ttime)).LE.exem) THEN
                            apoloenet(i,j)=apoloeT(i,j,Ttime)
                        ELSE
                            indanet=MINLOC(ABS(a-(1-taub)*(a(apoloeT(i,j,Ttime))-exem)-exem))
                            apoloenet(i,j)=indanet(1)
                        END IF  
                    END DO
                END DO
				counter=nonzero-(da*(dy*dr+1))+1    ! number of elements for the old
				!block transition oldw - ?
				DO i=1,da               !asset today
					crow=sizeM-da+i     !row of M
					!if reborn
					DO ll=1,dr          ! r tomorrow
						DO jj=1,dy      ! y tomorrow
							rowM(counter)=crow
							colM(counter)=(ll-1)*dy*da+(jj-1)*da+apolownet(i)
							valM(counter)=invyr((jj-1)*dr+ll)*(1.0-pold)
							counter=counter+1
						END DO
					END DO
					! if remains old
					rowM(counter)=crow
					colM(counter)=2*nyoung+noe+apolowT(i,Ttime)
					valM(counter)=pold
					counter=counter+1
				END DO
		
				!block transition old entr - ?
				counter=2*(dy*dr+dr+1)*nyoung+1
				DO l=1,dr       ! r today
					DO i=1,da   ! a today
						crow=2*nyoung+(l-1)*da+i
						! if reborn
						DO ll=1,dr ! r', the one the children inherit
							DO jj=1,dy  ! child's y, drawn from invariant distr
								rowM(counter)=crow
								! if remain entr, this is col
								colM(counter)=(ll-1)*dy*da+(jj-1)*da+apoloenet(i,l)
								! if become work, add some elements to col
								IF  (kpoloeT(i,l,Ttime).GT.0) THEN
									colM(counter)=colM(counter)+nyoung
								END IF
								valM(counter)=(1.0-pold)*invy(jj)*Pr(l,ll)
								counter=counter+1
							END DO
						END DO
						! if remains old
						IF  (kpoloeT(i,l,Ttime)==-1) THEN  ! becomes worker
							rowM(counter)=crow
							colM(counter)=2*nyoung+noe+apoloeT(i,l,Ttime)
							valM(counter)=pold
							counter=counter+1
							DO ll=1,dr
								rowM(counter)=crow
								colM(counter)=2*nyoung+(ll-1)*da+apoloeT(i,l,Ttime)
								valM(counter)=0.0
								counter=counter+1
							END DO
						ELSE                    ! remains entrepreneur
							rowM(counter)=crow
							colM(counter)=2*nyoung+noe+apoloeT(i,l,Ttime)
							valM(counter)=0.0
							counter=counter+1
							DO ll=1,dr
								rowM(counter)=crow
								colM(counter)=2*nyoung+(ll-1)*da+apoloeT(i,l,Ttime)
								valM(counter)=Pr(l,ll)*pold
								counter=counter+1
							END DO
						END IF
					END DO
				END DO

				!block transition young work - ?
				counter=1
				DO l=1,dr   !today
					DO j=1,dy   !today
						DO i=1,da   !today
							crow=(l-1)*da*dy+(j-1)*da+i
							!   if next period remains young
							DO ll=1,dr ! tomorrow
								DO jj=1,dy
									rowM(counter)=crow
									! if remain work, this is col
									colM(counter)=(ll-1)*dy*da+(jj-1)*da+apolyT(i,j,l,Ttime)
									! CALL checkcolM(1)
									! if become entr, add some elements to col
									IF  (kpolyT(i,j,l,Ttime).GT.0) THEN
										colM(counter)=colM(counter)+nyoung								
									END IF
									valM(counter)=pyou*Pyr((j-1)*dr+l,(jj-1)*dr+ll)
									counter=counter+1
								END DO
							END DO
							!   if next period becomes old
							IF  (kpolyT(i,j,l,Ttime)==-1) THEN ! if remains worker
								rowM(counter)=crow
								colM(counter)=2*nyoung+noe+apolyT(i,j,l,Ttime)
							    valM(counter)=(1-pyou)
								counter=counter+1
								DO ll=1,dr
									rowM(counter)=crow
									colM(counter)=2*nyoung+(ll-1)*da+apolyT(i,j,l,Ttime)
						            valM(counter)=0.0
									counter=counter+1
								END DO
							ELSE                               ! if becomes entr
								rowM(counter)=crow
								colM(counter)=2*nyoung+noe+apolyT(i,j,l,Ttime)
							    valM(counter)=0.0
								counter=counter+1
								DO ll=1,dr
									rowM(counter)=crow
									colM(counter)=2*nyoung+(ll-1)*da+apolyT(i,j,l,Ttime)
								    valM(counter)=Pr(l,ll)*(1-pyou)
									counter=counter+1
								END DO
							END IF
						END DO
					END DO
				END DO

				!block young entr - ?
				IF (counter.NE.nyoung*(dy*dr+dr+1)+1) WRITE(*,*) "counter does not match!!"
					DO l=1,dr   !today
						DO j=1,dy   !today
							DO i=1,da   !today
								crow=nyoung+(l-1)*da*dy+(j-1)*da+i
								!   if next period remains young
								DO ll=1,dr
									DO jj=1,dy
										rowM(counter)=crow
										! if becomes work, this is col
										colM(counter)=(ll-1)*dy*da+(jj-1)*da+apolyT(i,j,l,Ttime)
										! if become entr, add some elements to col
										IF  (kpolyT(i,j,l,Ttime).GT.0) THEN
											colM(counter)=colM(counter)+nyoung
										END IF
										valM(counter)=pyou*Pyr((j-1)*dr+l,(jj-1)*dr+ll)
										counter=counter+1
									END DO
								END DO
								!   if next period becomes old
								IF  (kpolyT(i,j,l,Ttime)==-1) THEN ! if becomes worker
									rowM(counter)=crow
									colM(counter)=2*nyoung+noe+apolyT(i,j,l,Ttime)
									valM(counter)=(1-pyou)
									counter=counter+1
									DO ll=1,dr
										rowM(counter)=crow
										colM(counter)=2*nyoung+(ll-1)*da+apolyT(i,j,l,Ttime)
										valM(counter)=0.0
										counter=counter+1
									END DO
								ELSE                               ! if becomes entr
									rowM(counter)=crow
									colM(counter)=2*nyoung+noe+apolyT(i,j,l,Ttime)
									valM(counter)=0.0
									counter=counter+1
									DO ll=1,dr
										rowM(counter)=crow
										colM(counter)=2*nyoung+(ll-1)*da+apolyT(i,j,l,Ttime)
										valM(counter)=Pr(l,ll)*(1-pyou)
										counter=counter+1
									END DO
								END IF
						END DO
					END DO
				END DO
			END IF ! IF (Ttime.LE.Tfinal) THEN ! transition M is same after Tfinal
			
			!   compute next period's distribution
			invm1=invm		
			invm=0.0
			! this do loop is the product M'*invm, M sparse
		    ! to transpose M, we simply use colM instead of rowM
			! invm= new inv distr
            ! invm1= old inv distr		
			DO i=1,nonzero
				invm(colM(i))=invm(colM(i))+invm1(rowM(i))*valM(i)
			END DO
			invm=invm/sum(invm)
			WRITE (*,*) "DISTR COMPUTED for Ttime=", Ttime			
						
		! *********************************************************************
		END DO ! forward in time from first SS to compute time path of aggregates
			   ! DO Ttime=2,Ttrans-1
		! *********************************************************************
		! inits
		govdebtT=0.0
		govdebtT(1)=govdebt1ss
		govdebtT(Ttrans)=govdebt2ss
		govprimsurpT=0.0
		govprimsurpT(1)=ibarpath(1)*govdebt1ss
		govprimsurpT(Ttrans)=ibarpath(Ttrans)*govdebt2ss

		! *********************************************************************
		! Go backward in time to compute totkcorp and implied prices using
		! govdebt computed going backward
		! *********************************************************************		
		DO Ttime=Ttrans-1,2,-1		
			! define appropriate prices
			rbar=rbarpath(Ttime)
			wage=wagepath(Ttime)
			ibar=ibarpath(Ttime)
			abig=abigvec(MIN(Ttime,1+T0))
			phi=phivec(MIN(Ttime,1+T0))
			xi=xivec(MIN(Ttime,1+T0))
			tfp=tfpvec(MIN(Ttime,1+T0))
			eff=effvec(MIN(Ttime,1+T0))
            taubal=taubalpath(Ttime)
			
			! fix govt exp after prices are fixed if initial and final SS are the same
			IF (switchequalss==0) THEN
    			
    			IF (Ttime .LE. Ttransold) THEN
    				govexp=gfrac*gdpT(Ttime+1)
    			ELSE
    				govexp=gfrac*gdpT(Ttrans)
    			END IF
    			
    		ELSEIF (dogovloop==1) THEN
    		    govexp=gfrac*gdpT(1) !  we do not cut government expenditure during the recession
    		    govprimsurpT(Ttime)=taxeslesstransfT(Ttime)-govexp
		
			    ! govdebtT(Ttime) is the value of government debt at the beginning of period Ttime, excluding interest payments
			    govdebtT(Ttime)=(govdebtT(Ttime+1)+govprimsurpT(Ttime))/(1+ibarpath(Ttime))
    		ELSE ! When dogovloop==0, we adjust government spending to keep government debt at the steady state value with fixed tax rates
                govdebtT(Ttime)=govdebt1ss
    		    govprimsurpT(Ttime)=ibarpath(Ttime)*govdebt1ss
    		    govexp=taxeslesstransfT(Ttime)-govprimsurpT(Ttime)
    		END IF

			fname=directoryname // "checkgovdebt"
			OPEN (unit=32,file=fname,status="OLD", &
			&       action="write",position="append",iostat=OpenStatus)
			WRITE (unit=32, fmt=*) "Ttime=", Ttime
			WRITE (unit=32, fmt=*) "govdebtT(Ttime)=", govdebtT(Ttime), "govdebtT(Ttime+1)=", govdebtT(Ttime+1)
			WRITE (unit=32, fmt=*) "ibarpath(Ttime)=", ibarpath(Ttime)
			WRITE (unit=32, fmt=*) "govprimsurpT(Ttime+1)", govprimsurpT(Ttime+1)
			WRITE (unit=32, fmt=*) "-----------------------------------------------------------"
			CLOSE (unit=32)			
			
			IF (dorloop==1) THEN ! endo prices. 			
   				totkcorpT(Ttime)=(totaT(Ttime)-totkT(Ttime)-govdebtT(Ttime))
			ELSE
				totkcorpT(Ttime)=((xi*rbar+(1.0-xi)*ibar+delt)/(abig*tfp*alph))**(1.0/(alph-1.0))*totlcorpT(Ttime)
			END IF
			
			rcorp=abig*tfp*alph*(totkcorpT(Ttime)/totlcorpT(Ttime))**(alph-1.0)-delt
     		wageimpliedT(Ttime)=abig*tfp*(1.0-alph)*((rcorp+delt)/(abig*tfp*alph))**(alph/(alph-1.0))
     		rimpliedT(Ttime)=rcorp+(1-xi)*phi
     		! Capital intermediated
     		capintermedT(Ttime)=xi*totkcorpT(Ttime)+totkgrossborrT(Ttime)
     		IF (oldnipaswitch==1) THEN
     		    ! Note that consumption is appropriately deflated, so we need phivec(1)
                aggrconstotT(Ttime)=aggrconsgoodsT(Ttime)+phivec(1)*capintermedT(Ttime)
            ELSE
                aggrconstotT(Ttime)=aggrconsgoodsT(Ttime)
            END IF 					
     		
			IF (oldnipaswitch==1) THEN
			    ! This is real GDP, so we need to deflate financial services appropriately
                ! phi*capintermedT is subtracted to the goods-producing sector. phivec(1)*capintermedT is then
                ! added to represent real financial services (the change from phivec(1) to phi reflects an increase
                ! in the price of financial services)
    			gdpT(Ttime)=abig*tfp*(totkcorpT(Ttime)**alph)*(totlcorpT(Ttime)**(1.0-alph))+inckT(Ttime)+ &
	    			& (phivec(1)-phi)*capintermedT(Ttime)
    	    ELSE
       			! netting out financial services as an intermediate input
    			gdpT(Ttime)=abig*tfp*(totkcorpT(Ttime)**alph)*(totlcorpT(Ttime)**(1.0-alph))+inckT(Ttime)- &
	    			& phi*capintermedT(Ttime)
	    	END IF
		END DO ! DO Ttime=Ttrans-1,2 this is the backward loop

		! ***************************************************************************
		! computed totkcorp and implied prices using
		! govdebt computed going backward				
		! ***************************************************************************

		! compute present value of govt inbalance
				
		invprodibar=1.0 
		Pvprimgovsurp=0.0
		DO i=2,Ttrans-1 
			invprodibar=invprodibar/(1.0+ibarpath(i))
            PVprimgovsurp=PVprimgovsurp+govprimsurpT(i)*invprodibar
		END DO
					
		! if govbalPV is positive, must raise tauadj
		govbalPV=govdebt1ss-govdebt2ss*invprodibar-PVprimgovsurp
		
		! just to give an order of magnitude about what we iterate on
		IF (dogovloop.EQ.1) THEN
			epsigov=abs(govbalPV/gdpT(1))
		ELSE
		    epsigov=epsigovmin/2.0
		END IF
		
		fname=directoryname // "output"
		OPEN (unit=32,file=fname,status="OLD", &
		&       action="write",position="append",iostat=OpenStatus)
		IF (epsigov.LT.epsigovmin) THEN	
			WRITE (unit=32,fmt=*) "reached convergence for GOVT BC"
		END IF
		WRITE (unit=32, fmt=*) "**************************************"
		WRITE (unit=32, fmt=*) "-----------------TAXES----------------"
		WRITE (unit=32, fmt=*) "Iteragovbal", iteragovbal
		WRITE (unit=32, fmt=*) "-----------------TAXES----------------"
        WRITE (unit=32, fmt=*) "labsupT(1:T0+T1)", labsupT(1:T0+T1)
        WRITE (unit=32, fmt=*) "--------------------------------------"		
        WRITE (unit=32, fmt=*) "wagepath(1:T0+T1)", wagepath(1:T0+T1)
        WRITE (unit=32, fmt=*) "--------------------------------------"	
        WRITE (unit=32, fmt=*) "taubalpath(1:T0+T1)", taubalpath(1:T0+T1)
        WRITE (unit=32, fmt=*) "--------------------------------------"	
        WRITE (unit=32, fmt=*) "rbarpath(1:T0+T1)", rbarpath(1:T0+T1)	
        WRITE (unit=32, fmt=*) "--------------------------------------"	
        WRITE (unit=32, fmt=*) "rimpliedT(1:T0+T1)", rimpliedT(1:T0+T1)	
        WRITE (unit=32, fmt=*) "--------------------------------------"	
        WRITE (unit=32, fmt=*) "ibarpath(1:T0+T1)", ibarpath(1:T0+T1)	
        WRITE (unit=32, fmt=*) "--------------------------------------"	
        WRITE (unit=32, fmt=*) "taubaladj", taubaladj	
		WRITE (unit=32, fmt=*) "taubal1ss", taubal1ss
	    WRITE (unit=32, fmt=*) "taubal2ss", taubal2ss
		WRITE (unit=32, fmt=*) "taubaladjmin", taubaladjmin
		WRITE (unit=32, fmt=*) "taubaladjmax", taubaladjmax		
		WRITE (unit=32, fmt=*) "epsigov", epsigov
		WRITE (unit=32, fmt=*) "govbalPV", govbalPV
		WRITE (unit=32, fmt=*) "govbalPVgdp=",govbalPV/gdpT(1)
		WRITE (unit=32, fmt=*) "govbalPVmin", govbalPVmin
		WRITE (unit=32, fmt=*) "govbalPVmax", govbalPVmax			
		WRITE (unit=32, fmt=*) "govbalPV2gdpmin=",govbalPVmin/gdpT(1)," govbalPV2gdpmax=",govbalPVmax/gdpT(1)
		WRITE (unit=32, fmt=*) "tota", totaT(Ttime)
		WRITE (unit=32, fmt=*) "PVprimgovsurp", PVprimgovsurp
		WRITE (unit=32, fmt=*) "govprimsup", govprimsurpT(Ttime)
		WRITE (unit=32, fmt=*) "Iterar", iterar
		WRITE (unit=32, fmt=*) "epsir", epsir
	
		WRITE (unit=32, fmt=*) "***************************************"
		CLOSE (unit=32)			
		
		CALL vectorsanddata(phivec,xivec,effvec,tfpvec,abigvec,dorloop,dogovloop,directoryname) ! save stuff
		
		IF (epsigov>epsigovmin) THEN			
			! using bisection algorithm to update tau
			! start with a tax, figure out if min or max, add or subtract pertgov
			! could be the opposite sign, start bisection, if another min or max,
			! apply pertgov again until bracketing	
			! NOTE" when govPV>0, need to increase TAU
				
			IF (bracketgov==1) THEN
				IF (govbalPV.GT.0.0) THEN
					havetaubalmin=1 ! switch: note, we computed taubalmin
					! in this case
      				govbalPVmin=govbalPV
       				taubaladjmin=taubaladj
       				taubaladj=taubaladj+pertgov
					WRITE(*,*) "	IN BRACKETGOV=1, GOVBALPV>0) taubalADJ",taubaladj
					bracketgov=2
				ELSE
					govbalPVmax=govbalPV
       				taubaladjmax=taubaladj
       				taubaladj=taubaladj-pertgov	
   					bracketgov=2
				END IF  					
			ELSE IF (bracketgov==2) THEN ! distinguish btw bracketing and no bracketing
				IF ((govbalPV.GT.0.0).AND.(havetaubalmin==1)) THEN ! then two min						
					WRITE (*,*) "***************************"
					WRITE (*,*) "no bracketing for taubaladj yet="
           			WRITE (*,*) "trying another taubaladjmax"
					WRITE (*,*) "***************************"
           			fname=directoryname // "output"
           			OPEN (unit=32,file=fname,status="OLD", &
						&   action="write",position="append",iostat=OpenStatus)
					WRITE (unit=32,fmt=*) "***************************"
					WRITE (unit=32,fmt=*) "no bracketing for taubaladj yet="
					WRITE (unit=32,fmt=*) "trying another taubaladjmax"
					WRITE (unit=32,fmt=*) "***************************"
					CLOSE (unit=32)
           			bracketgov=2 ! still looking for a taubalmax
           			taubaladjmin=taubaladj
           			taubaladj=taubaladjmin+pertgov
					govbalPVmin=govbalPV
   				END IF ! for two mins
				IF ((govbalPV.LT.0.0).AND.(havetaubalmin.NE.1)) THEN ! then two max						
					WRITE (*,*) "***************************"
					WRITE (*,*) "no bracketing for taubaladj yet="
           			WRITE (*,*) "trying another taubaladjmin"
					WRITE (*,*) "***************************"
           			fname=directoryname // "output"
           			OPEN (unit=32,file=fname,status="OLD", &
						&   action="write",position="append",iostat=OpenStatus)
					WRITE (unit=32,fmt=*) "***************************"
					WRITE (unit=32,fmt=*) "no bracketing for taubaladj yet="
           			WRITE (unit=32,fmt=*) "trying another taubaladjmin"
					WRITE (unit=32,fmt=*) "***************************"
					CLOSE (unit=32)
           			bracketgov=2 ! still looking for a taubalmin
           			taubaladjmax=taubaladj
           			taubaladj=taubaladjmax-pertgov
					govbalPVmax=govbalPV
   				END IF ! for two maxes
				IF ((govbalPV.GT.0.0).AND.(havetaubalmin.NE.1)) THEN ! first max, now min
					taubaladjmin=taubaladj
	        		govbalPVmin=govbalPV
					bracketgov=3
					! compute new taubaladj
					taubaladj=taubaladjmin-(taubaladjmax-taubaladjmin)*govbalPVmin/(govbalPVmax-govbalPVmin)
				END IF ! for max first, min then
				IF ((govbalPV.LT.0.0).AND.(havetaubalmin==1)) THEN ! first min, now max
					taubaladjmax=taubaladj
           			govbalPVmax=govbalPV
					bracketgov=3
					! compute new taubaladj
					taubaladj=taubaladjmin-(taubaladjmax-taubaladjmin)*govbalPVmin/(govbalPVmax-govbalPVmin)
				END IF ! for max first, min then
			ELSE ! for bracketgov>2
				IF (govbalPV.GT.0.0) THEN !we now just found ANOTHER min
					taubaladjmin=taubaladj
					govbalPVmin=govbalPV
					! compute new taubaladj
					taubaladj=taubaladjmin-(taubaladjmax-taubaladjmin)*govbalPVmin/(govbalPVmax-govbalPVmin)
				END IF ! for min now
				IF (govbalPV.LT.0.0) THEN !we just found a new max
					taubaladjmax=taubaladj
					govbalPVmax=govbalPV
					! compute new taubaladj
					taubaladj=taubaladjmin-(taubaladjmax-taubaladjmin)*govbalPVmin/(govbalPVmax-govbalPVmin)
				END IF ! for min now						
			END IF
			fname=directoryname // "savetaxstuff"
			OPEN (unit=32,file=fname,status="OLD", &
				&       action="write",position="append",iostat=OpenStatus)
			WRITE (unit=32, fmt=*) taubaladj, govbalPV, govbalPVmin, govbalPVmax
			CLOSE (unit=32)
				
			WRITE(*,*) "taubal1ss", taubal1ss
			WRITE(*,*) "taubal2ss", taubal2ss
            WRITE(*,*) "taubaladj", taubaladj
            taubalpath(T0+1:T0+T1)=taubal1ss+taubaladj
            IF (switchlabsupproptax==2) THEN ! If the labor supply is exogenous, it is equal to 1 and never revised
                labsupT=(wagepath*(1.0-taubalpath)/(omega*(1.0+tauc)))**(1/psii)
            END IF		
    	END IF !IF (epsigov>epsigovmin) THEN

		WRITE(*,*) "outside of forward t loop"
		WRITE(*,*) "Ttime", Ttime
		WRITE(*,*) "PVprimgovsurp", PVprimgovsurp
		WRITE(*,*) "govprimsup", govprimsurpT(Ttime)
		WRITE(*,*) "taubaladj", taubaladj
		WRITE(*,*) "taubaladjmin", taubaladjmin
		WRITE(*,*) "taubaladjmax", taubaladjmax
		WRITE(*,*) "epsigov", epsigov
		WRITE(*,*) "govbalPV", govbalPV
		WRITE(*,*) "govbalPVmin", govbalPVmin
		WRITE(*,*) "govbalPVmax", govbalPVmax					

	END DO ! WHILE (EPSIGOV)

	IF (savepolfun.EQ.2) THEN
        CALL printpolfunT(directoryname)
    END IF
	
	IF (dorloop==0) THEN
	    epsir=epsirmin/2.0
	ELSE  	
        epsir=MAXVAL(ABS(rimpliedT(2:Ttransold-1)-rbarpath(2:Ttransold-1)))
        WRITE(*,*) "I AM COMPUTING EPSIR!!!!!!", epsir
		IF (epsir>epsirmin) THEN 
			rbarpath(2:Ttransold-1)=weightoldprices*rbarpath(2:Ttransold-1)+ &
			& (1.0-weightoldprices)*rimpliedT(2:Ttransold-1)
			DO i=2,T0  
	            ibarpath(i)=rbarpath(i)-phivec(i)
		        wagepath(i)=(1.0-alph)*abigvec(i)*tfpvec(i)*((xivec(i)*rbarpath(i)+(1.0-xivec(i))*ibarpath(i)+delt)/(alph*abigvec(i)*tfpvec(i)))**(alph/(alph-1.0))
			END DO
            DO i=T0+1,Ttransold-1
                ibarpath(i)=rbarpath(i)-phivec(T0+1)
                wagepath(i)=(1.0-alph)*abigvec(T0+1)*tfpvec(T0+1)*((xivec(T0+1)*rbarpath(i)+(1.0-xivec(T0+1))*ibarpath(i)+delt)/(alph*abigvec(T0+1)*tfpvec(T0+1)))**(alph/(alph-1.0))
            END DO
            IF (switchlabsupproptax==2) THEN ! If the labor supply is exogenous, it is equal to 1 and never revised
                labsupT=(wagepath*(1.0-taubalpath)/(omega*(1.0+tauc)))**(1.0/psii)
            END IF
		END IF				
	END IF	
	
	iterar=iterar+1		
	WRITE (*,*) "finished computing r"
END DO ! WHILE (EPSIR)

END SUBROUTINE transsub

SUBROUTINE printvalfunT2(directoryname)

    CHARACTER(*), INTENT(IN) :: directoryname

    fname=directoryname // "valfunT2"
    ! saving value functions
    open (unit=32,file=fname,status="replace", &
    &       action="WRITE",position="rewind",iostat=OpenStatus)
    IF (OpenStatus.NE.0) THEN
        WRITE(*,*) 'problems opening ', fname
    END IF
    DO i=1,da
        DO j=1,dy
            DO jj=1,dr
                WRITE(unit=32,fmt=*) newVy(i,j,jj)
            END DO
        END DO
    END DO
    DO i=1,da
        DO j=1,dy
            DO jj=1,dr
                WRITE(unit=32,fmt=*) newVyw(i,j,jj)
            END DO
        END DO
    END DO
    DO i=1,da
        DO j=1,dy
            DO jj=1,dr
                WRITE(unit=32,fmt=*) newVye(i,j,jj)
            END DO
        END DO
    END DO
    DO i=1,da
        WRITE(unit=32,fmt=*) newVow(i)
    END DO
    DO i=1,da
        DO jj=1,dr
            WRITE(unit=32,fmt=*) newVoe(i,jj)
        END DO
    END DO
    DO i=1,da
        DO jj=1,dr
            WRITE(unit=32,fmt=*) Voee(i,jj)
        END DO
    END DO
    CLOSE (unit=32)
END SUBROUTINE printvalfunT2

SUBROUTINE printpolfunT(directoryname)
    CHARACTER(*), INTENT(IN) :: directoryname
    ! print policy functions and borrowing constraints
    fname=directoryname // "polfuns"
    ! saving value functions
    open (unit=32,file=fname,status="replace", &
    &       action="WRITE",position="rewind",iostat=OpenStatus)
    IF (OpenStatus.NE.0) THEN
        WRITE(*,*) 'problems opening ', fname
    END IF
    ! apolyT(da,dy,dr,Ttrans)
	DO i=1,da
        DO j=1,dy
            DO jj=1,dr
                DO i2=1,Ttrans
                    WRITE(unit=32,fmt=*) apolyT(i,j,jj,i2)
                END DO
            END DO
        END DO
    END DO
    ! kpolyT(da,dy,dr,Ttrans)
	DO i=1,da
        DO j=1,dy
            DO jj=1,dr
                DO i2=1,Ttrans
                    WRITE(unit=32,fmt=*) kpolyT(i,j,jj,i2)
                END DO
            END DO
        END DO
     END DO
    ! labpolyT(da,dy,dr,Ttrans)
    DO i=1,da
        DO j=1,dy
            DO jj=1,dr
                DO i2=1,Ttrans
                    WRITE(unit=32,fmt=*) labpolyT(i,j,jj,i2)
                END DO
            END DO
        END DO
    END DO
    ! apolowT(da,Ttrans)
    DO i=1,da
        DO i2=1,Ttrans
            WRITE(unit=32,fmt=*) apolowT(i,i2)
        END DO
    END DO
    ! apoloeT(da,dr,Ttrans)
    DO i=1,da
        DO jj=1,dr
            DO i2=1,Ttrans
                WRITE(unit=32,fmt=*) apoloeT(i,jj,i2)
            END DO
        END DO
    END DO
    ! kpoloeT(da,dr,Ttrans)
    DO i=1,da
        DO jj=1,dr
            DO i2=1,Ttrans
                WRITE(unit=32,fmt=*) kpoloeT(i,jj,i2)
            END DO
        END DO
    END DO
    ! labpoloeT(da,dr,Ttrans)
    DO i=1,da
        DO jj=1,dr
            DO i2=1,Ttrans
                WRITE(unit=32,fmt=*) labpoloeT(i,jj,i2)
            END DO
        END DO
    END DO
    CLOSE (unit=32)
END SUBROUTINE printpolfunT

SUBROUTINE vectorsanddata(phivec,xivec,effvec,tfpvec,abigvec,dorloop,dogovloop,directoryname)

    DOUBLE PRECISION, DIMENSION(1+T0), INTENT(IN) :: xivec !0.33     ! fraction of outside funds needed by corporate firms 
    DOUBLE PRECISION, DIMENSION(1+T0), INTENT(IN) :: phivec !(/0.015, 0.035, 0.035, 0.035, 0.015, 0.015/)    ! intermediation cost r_t=i_t+phi 

    ! enforcement
    DOUBLE PRECISION, DIMENSION(1+T0), INTENT(IN) :: effvec !0.75 ! prop k kept when defaulting
    ! corporate prof fn
    DOUBLE PRECISION, DIMENSION(1+T0), INTENT(IN) :: abigvec !1.0 ! constant in front
    DOUBLE PRECISION, DIMENSION(1+T0), INTENT(IN) :: tfpvec !(/1.0, 0.975, 0.975, 0.975, 1.0, 1.0/) !1.0  ! This must be one in SS, since it does not appear in the SS code 

    INTEGER, INTENT(IN) :: dorloop          ! 0=don't do r loop 
    INTEGER, INTENT(IN) :: dogovloop        ! 0=don't balance gov bc 

    CHARACTER(*), INTENT(IN) :: directoryname

    ! print policy functions and borrowing constraints
    fname=directoryname // "vectorsanddata"
    open (unit=32,file=fname,status="replace", &
	&       action="WRITE",position="rewind",iostat=OpenStatus)
	IF (OpenStatus.NE.0) THEN
		WRITE(*,*) 'problems opening ', fname
	END IF
	WRITE(unit=32,fmt=*) Ttrans
	WRITE(unit=32,fmt=*) govdebt1ss
	WRITE(unit=32,fmt=*) govdebt2ss
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) cacca ! taucpath(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) taubalpath(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) totaT(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) gdpT(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) govprimsurpT(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) wageimpliedT(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) rimpliedT(i)
	END DO
	WRITE(unit=32,fmt=*) PVprimgovsurp
	WRITE(unit=32,fmt=*) govbalPV
	WRITE(unit=32,fmt=*) govbalPVmin
	WRITE(unit=32,fmt=*) govbalPVmax
	WRITE(unit=32,fmt=*) cacca ! taucadj
	WRITE(unit=32,fmt=*) cacca ! taucadjmin
	WRITE(unit=32,fmt=*) cacca ! taucadjmax
	WRITE(unit=32,fmt=*) cacca ! taucinterp
	WRITE(unit=32,fmt=*) epsigov
	WRITE(unit=32,fmt=*) rbar
	WRITE(unit=32,fmt=*) wage
	WRITE(unit=32,fmt=*) cacca !epsinvm
	WRITE(unit=32,fmt=*) nstates
	DO i=1,nstates
		WRITE(unit=32,fmt=*) invm(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) govdebtT(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) rbarpath(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) wagepath(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) totkT(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) totlcorpT(i)
	END DO
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) inckT(i)
	END DO
	WRITE(unit=32,fmt=*) epsir
	DO i=1,Ttrans
		WRITE(unit=32,fmt=*) taxeslesstransfT(i)
	END DO
    DO i=1,Ttrans
		WRITE(unit=32,fmt=*) hiredlabeT(i)
	END DO
    DO i=1,Ttrans 
		WRITE(unit=32,fmt=*) totkcorpT(i)
	END DO
    DO i=1,Ttrans 
		WRITE(unit=32,fmt=*) totentrT(i)
	END DO
    DO i=1,Ttrans 
		WRITE(unit=32,fmt=*) totkgrossborrT(i)
	END DO
    DO i=1,Ttrans 
		WRITE(unit=32,fmt=*) propewswitchT(i)
	END DO
    DO i=1,Ttrans 
		WRITE(unit=32,fmt=*) propweswitchT(i)
	END DO
	DO i=1,Ttrans
    	WRITE(unit=32,fmt=*) ibarpath(i)
	END DO
	WRITE(unit=32,fmt=*) T0
	WRITE(unit=32,fmt=*) T1
	!WRITE(unit=32,fmt=*) T2
	WRITE(unit=32,fmt=*) T3
	WRITE(unit=32,fmt=*) T4
	DO i=1,T0+1
        WRITE(unit=32,fmt=*) abigvec(i)
    END DO	
	DO i=1,T0+1
        WRITE(unit=32,fmt=*) xivec(i)
    END DO	
	DO i=1,T0+1
        WRITE(unit=32,fmt=*) phivec(i)
    END DO
    DO i=1,Ttrans
        WRITE(unit=32,fmt=*) aggrconsgoodsT(i)
    END DO
    DO i=1,T0+1
        WRITE(unit=32,fmt=*) tfpvec(i)
    END DO	
    DO i=1,Ttrans 
	    WRITE(unit=32,fmt=*) totefflT(i)
	END DO
    DO i=1,Ttrans 
		WRITE(unit=32,fmt=*) labsupT(i)
	END DO
	DO i=1,Ttrans 
		WRITE(unit=32,fmt=*) capintermedT(i)
	END DO
	DO i=1,Ttrans
        WRITE(unit=32,fmt=*) aggrconstotT(i)
    END DO
    WRITE(unit=32,fmt=*) oldnipaswitch
	CLOSE (unit=32)
END SUBROUTINE vectorsanddata

END PROGRAM

!******************************************

SUBROUTINE linspace(xmin,xmax,npoints,lspace)
    IMPLICIT NONE
    DOUBLE PRECISION, INTENT(IN) :: xmin,xmax
    INTEGER, INTENT(IN) :: npoints
    DOUBLE PRECISION, DIMENSION(npoints), INTENT(OUT) :: lspace
    INTEGER :: i
    lspace=DBLE( (/ (i,i=0,npoints-1) /) )/DBLE(npoints-1)*(xmax-xmin)+xmin
END SUBROUTINE linspace

SUBROUTINE  interplin(l,x,y,n,z,v)
    ! interpolate, from values of the fn given as ordinates of
    ! input data points in an x-y plane and for a given set of
    ! x values (abscissas), the values of a single-valued fn y=f(x)
    ! input parameters are
    !     l  = # of data points (2 or greater)
    !     x  = array of dimension l storing the x values (abscissas)
    !          of input data points (in ascending order)
    !     y  = array of dimension l storing the y values (ordinates)
    !          of input data points
    !     n  = # of points at which interpolation of the y value (ordinate)
    !          (ordinate) is needed (1 or greater)
    !     z  = array of dimension n storing the x values (abscissas) of
    !          desired points
    ! output parameter
    !     v  = array of dimension n where the interpolated y values
    !          (ordinates) are to be displayed
    IMPLICIT NONE

    INTEGER, INTENT(IN) :: l
    INTEGER, INTENT(IN) :: n
    DOUBLE PRECISION, DIMENSION(l), INTENT(IN) :: x
    DOUBLE PRECISION, DIMENSION(l), INTENT(IN) :: y
    DOUBLE PRECISION, DIMENSION(n), INTENT(IN) :: z
    DOUBLE PRECISION, DIMENSION(n), INTENT(OUT) :: v

    INTEGER :: i,ind
    INTEGER, DIMENSION(1) :: k
    DOUBLE PRECISION :: diff

    DO i=1,n
        k=MAXLOC(-ABS(z(i)-x))
        ind=k(1)
        diff=z(i)-x(ind)
        IF (abs(diff)<1e-04) THEN
            v(i)=y(ind)
        ELSE
            IF (diff<0) THEN
                v(i)=y(ind-1)+(z(i)-x(ind-1))/(x(ind)-x(ind-1))&
                         & *(y(ind)-y(ind-1))
            ELSE
                v(i)=y(ind)+(z(i)-x(ind))/(x(ind+1)-x(ind))*(y(ind+1)-y(ind))
            END IF
        END IF
    END DO ! DO i=1,n
END SUBROUTINE interplin
