PROGRAM credit

! program with intermediation costs
! dototincw should be 1 for initial SS, 0 for final SS if final SS is not the same (not used in this paper)
! xi=fraction of outside funds needed by corporate firms
! i_t=return on saving
! r_t=i_t+phi=cost of borrowing

! notice that we derived: MPK=delta+(1-xi)i_t+xi r_t

! if you do not want to iterate on r, or taul, set dogovloop, dorloop to 0
! flexible grids. If gridtype=1, old grid, 
! if gridtype=2, new grid

! The transition fn keeps track of previous 
! employment so that we keep track of the switches. 
!

!USE numerical_libraries

include 'link_fnl_shared.h'

USE commonvar

IMPLICIT NONE

! *****************  PARAMETER VALUES

! preferences and technology
DOUBLE PRECISION, PARAMETER :: abig=1.0     ! constant in nonentr prod fn
DOUBLE PRECISION, PARAMETER :: xi=0.33      ! fraction of outside funds needed by corporate firms
DOUBLE PRECISION, PARAMETER :: phi=0.015    ! intermediation cost r_t=i_t+phi

! government parameters
DOUBLE PRECISION, PARAMETER :: tauls=0.0    ! lump sum tax

! enforcement
DOUBLE PRECISION, PARAMETER :: eff=0.75     ! prop k kept when defaulting
DOUBLE PRECISION, PARAMETER :: lambd=1.5    ! if swithcbc=2, can borrow lambd*a

! CONVERGENCE STUFF
INTEGER, PARAMETER :: dogovloop=1, dorloop=1 ! 0=don't do gov loop or r loop! cricri
INTEGER, PARAMETER :: dototincw=1 ! update normalization of taxes, else keep fixed
INTEGER, PARAMETER :: iterarmax=40    ! maximum number of iterations allowed for rbar
INTEGER, PARAMETER :: iteragovmax=40  ! maximum number of iterations allowed for govt loop
DOUBLE PRECISION, PARAMETER :: relax=0.0       ! relaxation parameter for val. funcs (weight on OLD iteration)
DOUBLE PRECISION, PARAMETER :: relaxgov=0.0    ! relax par for tau. weight on OLD iteration, for gov. distance first  two starting pts for taul in algo
DOUBLE PRECISION, PARAMETER :: pertgov=0.04 
DOUBLE PRECISION, PARAMETER :: radjust=0.08 ! maximum rbar-rimplied which we allow
DOUBLE PRECISION, PARAMETER :: rweight=0.5 ! relaxation parameter on rbar, rimplied used to compute new rbar
DOUBLE PRECISION, PARAMETER :: epsimin=4e-06
DOUBLE PRECISION, PARAMETER :: epsinvmin=4e-07
DOUBLE PRECISION, PARAMETER :: epsirmin=5e-05 
DOUBLE PRECISION, PARAMETER :: epsigovmin=.0000005
DOUBLE PRECISION, PARAMETER :: penalty=-1e+7

! number of iterations on iterakhat for which we want to save value functions
INTEGER, PARAMETER :: nite=6
! type of borrowing constraints used
INTEGER, PARAMETER :: switchbc=0       ! =0 ENDO BC, =1 exo bc,read IN file, =2 exo bc, LAMBD PAR
INTEGER, PARAMETER :: switchlabsupproptax=0 ! =0 labsup is exogenous and taxation is Gouveia-Strauss, 
                                        ! =1 labsup is exogenous and taxation is proportional
                                        ! =2 workers' labor supply is endogenous and taxes are proportional,

! transition matrix nonzero elements
INTEGER, PARAMETER :: nyoung=dr*dy*da   ! # possible states for young w or entr
INTEGER, PARAMETER :: noe=da*dr         ! # possible states for old entr
INTEGER, PARAMETER :: nstates=2*nyoung+noe+da   ! # states (total)
INTEGER, PARAMETER :: nonzero=2*(dy*dr+dr+1)*nyoung+(dy*dr+dr+1)*noe+&
                        &       (dy*dr+1)*da
INTEGER, PARAMETER :: sizeM=2*nyoung+noe+da     !dimension of trans mat M

DOUBLE PRECISION, PARAMETER :: obsolete=0.0 ! This is saved in places where we used to have other parameters

! *****************  VARIABLES

! indexes
INTEGER :: i,i2,j,j1,j2,jj,l,ll,OpenStatus
INTEGER, DIMENSION(1) :: imax,indanet
INTEGER, DIMENSION(2) :: imaxmat
! convergence criteria
DOUBLE PRECISION :: epsi,epsinv,epsir,epsigov
INTEGER :: epsihato ! kohat-newkohat: how bc changes across iter for old
INTEGER :: epsihaty ! kyhat-newkyhat: how bc changes across iter for young
INTEGER :: epsihat  ! epsihat=abs((kyhat-newkyhat)+(kohat-newkohat))=0
                    ! iterate on val funs and bc until it's zero.
! equilibrium risk-free interest rate and wages
DOUBLE PRECISION :: rbar,ibar,rbarmin,rbarmax,rimplied,rcorp,wage,wageimplied

DOUBLE PRECISION :: taubalrbarmax,taubalrbarmin,taubalinterp,tbalwidth

! pensions
DOUBLE PRECISION :: transf
! grids
DOUBLE PRECISION, DIMENSION(da) :: a,anet       ! grid for assets
DOUBLE PRECISION, DIMENSION(dk) :: k        ! grid for k
DOUBLE PRECISION, DIMENSION(dr*dy,dr*dy) :: Pyr,Pyrtr ! joint distr. of y and r
DOUBLE PRECISION, DIMENSION(dy*dr) ::   invyr   ! invariant distr of y and r
DOUBLE PRECISION, DIMENSION(dy) ::      invy    ! invariant distr of y
DOUBLE PRECISION, DIMENSION(dr) :: invr         ! inv dist for r
! taxes estimated using Gouveia Strauss tau=b-b*(s*y**p+1)**(-1/p)
! stax depends on income normalization
DOUBLE PRECISION :: btaxw,staxw,ptaxw,staxwbase
DOUBLE PRECISION :: btaxe,staxe,ptaxe,staxebase
!value functions
! young
DOUBLE PRECISION, DIMENSION(da,dy,dr) :: Vy   ! young
DOUBLE PRECISION, DIMENSION(da,dy,dr) :: Vye  ! young that is entrep for this period
DOUBLE PRECISION, DIMENSION(da,dy,dr) :: Vyw  ! young that is worker for this period
! old
DOUBLE PRECISION, DIMENSION(da,dr) :: Voee   ! old entrepreneur staying entrep
DOUBLE PRECISION, DIMENSION(da) :: Vow       ! old, retired, worker
DOUBLE PRECISION, DIMENSION(da,dr) :: Voe    ! old entrepreneur
! defaulted guys
DOUBLE PRECISION, DIMENSION(dk,dy,dr) :: Vwkeff ! defaulted worker
DOUBLE PRECISION, DIMENSION(dk) :: Vokeff    ! defaulted OLD worker
! decendants
DOUBLE PRECISION, DIMENSION(da) :: Vynet    ! val fun for descendant (net of estate tax)
DOUBLE PRECISION, DIMENSION(da) :: EVnewbw   ! exp value newborn worker
DOUBLE PRECISION, DIMENSION(da,dr) :: EVnewbe    ! exp value newborn entr
DOUBLE PRECISION, DIMENSION(da,dy,dr) :: EVy
! policy functions
! young
INTEGER, DIMENSION(da,dy,dr) :: apolye,kpolye ! young that is entr for this period
INTEGER, DIMENSION(da,dy,dr) :: apolyw        ! young that is worker this period
INTEGER, DIMENSION(da,dy,dr) :: apoly,kpoly   ! young
DOUBLE PRECISION, DIMENSION(da,dy,dr) :: labpoly         ! labor demand for young entr

! old
INTEGER, DIMENSION(da) :: apolow              ! old, retired, worker
INTEGER, DIMENSION(da) :: apolownet           ! as above net of estate tax
INTEGER, DIMENSION(da,dr) :: apoloe,kpoloe    ! old entrepreneur
INTEGER, DIMENSION(da,dr) :: apoloenet        ! as above net of estate tax
DOUBLE PRECISION, DIMENSION(da,dr) :: labpoloe            ! labor demand for old entre
DOUBLE PRECISION, DIMENSION(da,dy,dr) :: conspoly,grossincy,netincy	! consumption and income of y
DOUBLE PRECISION, DIMENSION(da,dr) :: conspoloe,grossincoe,netincoe	! cons and income of old who remain e
DOUBLE PRECISION, DIMENSION(da) :: conspolow,grossincow,netincow		! cons and income of old retired

! exogenous investment limits
INTEGER, DIMENSION(da,dy,dr) :: kyhat         ! young entr: max k(a,y,r)
INTEGER, DIMENSION(da,dr) :: kohat            ! old entr: max k(a,r)
INTEGER, DIMENSION(da,dy,dr) :: newkyhat      ! 
INTEGER, DIMENSION(da,dr) :: newkohat         ! 
! transition matrix
INTEGER, DIMENSION(nonzero) :: colM, rowM     ! row and col index
DOUBLE PRECISION, DIMENSION(nonzero) :: valM              ! value (trans probability)
INTEGER, DIMENSION(2*nyoung*dr*dy) :: rowyoung,colyoung	! sub transition matrix for young to young
DOUBLE PRECISION, DIMENSION(2*nyoung*dr*dy) :: valyoung=0.0			! to compute wealth mobility
! invariant distribution
DOUBLE PRECISION, DIMENSION(nstates) :: invm,invm1  ! invar distr prob
DOUBLE PRECISION, DIMENSION(da) :: prgrid           ! invariant distr on a
DOUBLE PRECISION, DIMENSION(da) :: prgridyw,prgridye,prgridoe,prgridow  ! same by groups
DOUBLE PRECISION :: totayw,totaye,totaow,totaoe,totborrye,totborroe
DOUBLE PRECISION, DIMENSION(nstates-da) :: invlevk,invrk  ! k and r level corr to invm
INTEGER, DIMENSION(nstates-da):: invpolk      ! k policy corr to invm

DOUBLE PRECISION, DIMENSION(nstates-da) :: invlabe,invtotlabe     ! outside labor and total labor demand to invm
DOUBLE PRECISION :: totk,hiredlabe                                ! capital and labor employed by entr and 
DOUBLE PRECISION :: inck,incky,incko                              ! entr's gross product (young and old)
DOUBLE PRECISION :: tota,k2gdp,totkcorp,gdp,totlcorp              ! total a, k2gdp ratio, total k and l in corp sector
DOUBLE PRECISION, DIMENSION(2*nyoung) :: invrky,invlevky,invtotlabye,invmy  ! additional variables to calculate incky and incko
DOUBLE PRECISION, DIMENSION(noe) :: invrko,invlevko,invtotlaboe,invmo       ! additional variables to calculate incky and incko

DOUBLE PRECISION :: ykshare,totke ! share of gross income to entrepr, totke
DOUBLE PRECISION :: yktotsh        !total share of income that goes to capital   
DOUBLE PRECISION :: totentr                         ! number of entrepreneurs
DOUBLE PRECISION :: totret                          ! number of retirees
DOUBLE PRECISION :: totL,toteffL   ! number of workers  and total efficiency units of work in the corporate sector
DOUBLE PRECISION :: labsup         ! time spent working by workers (entrepreneurs are normalized to 1 unit of time, inelastic)
DOUBLE PRECISION :: capintermed    ! Total capital subject to intermediation
DOUBLE PRECISION :: beq2gdp                       ! bequests as a fraction of gdp,
INTEGER, DIMENSION(nstates) :: ifswitchew         ! 1=if from e to w
INTEGER, DIMENSION(nstates) :: ifswitchwe         ! 1=if from w to e
DOUBLE PRECISION ::  propewswitch, propweswitch               ! prop. of switch from e to w
! government revenues
DOUBLE PRECISION, DIMENSION(nstates) :: vectaxcw,vectaxce,vectaxl,vectaxe,vectaxbw,vectaxbe,vecbeq 
DOUBLE PRECISION, DIMENSION(nstates) :: vectotincw,vecwe2yw,vecwe2ye
DOUBLE PRECISION :: tottaxcw,tottaxce,tottaxe,tottaxbw,tottaxbe,tottaxl,totincw
DOUBLE PRECISION :: govdebt,govbal
DOUBLE PRECISION :: govbal2gdp,govbal2gdpmin,govbal2gdpmax
DOUBLE PRECISION :: taubal,taubalmin,taubalmax
! temporary objects
DOUBLE PRECISION :: ytaxw,taxw,taxo,ytaxo
DOUBLE PRECISION, DIMENSION(dk) :: ytaxe,taxe
DOUBLE PRECISION, DIMENSION(da) :: ucons,cs
DOUBLE PRECISION, DIMENSION(da,da) :: uconsold
DOUBLE PRECISION, DIMENSION(da,da,dy) :: uconsw
DOUBLE PRECISION, DIMENSION(da,da,dr-1,dk) :: uconse 
DOUBLE PRECISION, DIMENSION(dk) :: uconsl,csl
DOUBLE PRECISION, DIMENSION(da,dy,dr) :: newVy
DOUBLE PRECISION, DIMENSION(da,dy,dr) :: newVyw,newVye
DOUBLE PRECISION, DIMENSION(da,dr) :: newVoe    ! old entrepreneur
DOUBLE PRECISION, DIMENSION(da) :: newVow       ! old, retired, worker
DOUBLE PRECISION, DIMENSION(da) :: Vowtemp
DOUBLE PRECISION, DIMENSION(da):: Vywtemp
DOUBLE PRECISION, DIMENSION(dk,da) :: Vyetemp
DOUBLE PRECISION, DIMENSION(dk,da) :: Veetemp
DOUBLE PRECISION, DIMENSION(dk,da) :: Voeetemp
DOUBLE PRECISION, DIMENSION(sizeM) :: sumrowM

DOUBLE PRECISION :: ahere,khere,rhere,entinchere,winchere,lhere,taxwhere,taxehere,inchere   
DOUBLE PRECISION, DIMENSION(dk) :: labe                    ! outside labor demand for old and young entrepreneurs, which is the same
DOUBLE PRECISION :: term1,front1,labdemand                        ! additional variables for entr's labor demand

! miscellanea
DOUBLE PRECISION, DIMENSION(dy) ::eigvaly
COMPLEX*16, DIMENSION(dy) :: eigvalcy
DOUBLE PRECISION, DIMENSION(dy*dr) ::eigvalyr
COMPLEX*16, DIMENSION(dy*dr) :: eigvalcyr
DOUBLE PRECISION, DIMENSION(dy,dy) ::eigvecy
COMPLEX*16, DIMENSION(dy,dy) :: eigveccy
DOUBLE PRECISION, DIMENSION(dy*dr,dy*dr) ::eigvecyr
COMPLEX*16, DIMENSION(dy*dr,dy*dr) :: eigveccyr
DOUBLE PRECISION, DIMENSION(dr) ::eigvalr
COMPLEX*16, DIMENSION(dr) :: eigvalcr
DOUBLE PRECISION, DIMENSION(dr,dr) ::eigvecr
COMPLEX*16, DIMENSION(dr,dr) :: eigveccr
INTEGER :: counter,crow,count1,count2,counter2
INTEGER, DIMENSION(da) :: kvecbc

INTEGER :: iterar,itera,iteragov,iterakhat,iteratot
CHARACTER(20) :: fname

DOUBLE PRECISION, DIMENSION(200) :: fundiff,funtota,funtotk,funrbar,taubalvec,imbalvec,govbalvec,gdpvec
DOUBLE PRECISION :: we2ye,we2yw,we2ywmedian,we2yemedian ! wealth to income ratio for entrep and workers
INTEGER :: bracketr,bracketgov,noneedtaubalmax
! nonneedtaubalmax indicator used when we start off taubal of the "wrong" sign, so we 
! get positive value for the function, in that case we keep them as taubalmax,
! without recomputing bracketgov==2
! bracketgov==1, for negative fn, ==2 for positive, ==0 for bisection
! bracketr=1 is first run with an rbar, bracketr=21 is when we've done the first round and
! found a min, bracketr=22 is when we've done the first round and found it's a max
DOUBLE PRECISION :: fundiffnow,fundiffmin,fundiffmax

! define val funs that we save when iterating on iterakhat to speed up computation time
!value functions
DOUBLE PRECISION, DIMENSION(da,dy,dr,nite) :: Vyer   ! young entr for the period
DOUBLE PRECISION, DIMENSION(da,dy,dr,nite) :: Vywr   ! young worker for the period
DOUBLE PRECISION, DIMENSION(da,dy,dr,nite) :: Vyr    ! young
DOUBLE PRECISION, DIMENSION(da,dr,nite) :: Voeer     ! old entrepreneur staying entrep
DOUBLE PRECISION, DIMENSION(da,nite) :: Vowr         ! old, retired, worker
DOUBLE PRECISION, DIMENSION(da,dr,nite) :: Voer  ! old entrepreneur
! vector recording rbar and the corresponding equilibrium taul to inform on where
! to center taul when we change rbar after the third iteration on rbar
! ordering: each row rbar-corresponding taul for balanced govt bc
DOUBLE PRECISION, DIMENSION(iterarmax,2) :: saverbartaul

INTEGER :: counterinvm ! counter used when computing w2's
DOUBLE PRECISION :: incomei, w2iwi,w2iei,kborrowed ! convenient constants used to compute w2's

DOUBLE PRECISION :: totkborr    ! net borrowing by e
DOUBLE PRECISION :: totkgrossborr ! gross borrowing by e
DOUBLE PRECISION :: totyshe     !total shadow labor income for e
DOUBLE PRECISION, DIMENSION(nstates-da) :: invkborr, invkgrossborr ! net and gross borrowing by e for each state var
DOUBLE PRECISION, DIMENSION(nstates-da) :: invyshe ! shadow y for e for each state var

! the following used in the median w/y computation
INTEGER :: nentr,nywork
INTEGER, DIMENSION(nstates) :: whoise   !=1 if entr, 0 if y work, 2 if old ret
DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:) :: vecwe2yeonly,invmeonly
DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:) :: vecwe2ywonly,invmywonly

! ******************  INTERFACE SUBROUTINES
INTERFACE
SUBROUTINE linspace (xmin,xmax,npoints,lspace)
IMPLICIT NONE
DOUBLE PRECISION, INTENT(IN) :: xmin,xmax
INTEGER, INTENT(IN) :: npoints
DOUBLE PRECISION, DIMENSION(npoints), INTENT(OUT) :: lspace
END SUBROUTINE linspace

SUBROUTINE  interplin(l,x,y,n,z,v)
IMPLICIT NONE
INTEGER, INTENT(IN) :: l
INTEGER, INTENT(IN) :: n
DOUBLE PRECISION, DIMENSION(l), INTENT(IN) :: x
DOUBLE PRECISION, DIMENSION(l), INTENT(IN) :: y
DOUBLE PRECISION, DIMENSION(n), INTENT(IN) :: z
DOUBLE PRECISION, DIMENSION(n), INTENT(OUT) :: v
END SUBROUTINE

SUBROUTINE checkrow1 (A,dA)
IMPLICIT NONE
DOUBLE PRECISION, DIMENSION(:,:), INTENT(IN) :: A
INTEGER, INTENT(IN) :: dA
END SUBROUTINE

SUBROUTINE quantilweighted (series,weights,qprop,quant)
IMPLICIT NONE
DOUBLE PRECISION, DIMENSION(:), INTENT(IN) :: series,weights
DOUBLE PRECISION, INTENT(IN) :: qprop
DOUBLE PRECISION, INTENT(OUT) :: quant
END SUBROUTINE

END INTERFACE

fname="indcolM"
OPEN (unit=32,file=fname,status="replace", &
&       action="write",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE (*,*) 'problems opening ', fname
END IF
WRITE (unit=32, fmt=*) "indcolM"
CLOSE (unit=32)

! *******************  INITIALIZE STUFF
invm=1.0/DBLE(nstates)

Vye=0.0
Vyw=0.0
Vy=0.0
Voee=0.0
Vow=0.0
Voe=0.0

! initialize val fns saved to see if we can speed up

Vyer=0.0
Vywr=0.0
Vy=0.0
Voeer=0.0
Vowr=0.0
Voer=0.0     

!Gouveia Strauss parameters
btaxw=.32
staxw=.2154
ptaxw=.7646
btaxe=.2562
staxe=.42
ptaxe=1.4

totincw=1.534715 ! we will change this in each gov loop to update stax*
!stax is estimated on inc/25000
!so staxest*(y/25000)**p=staxbar*(45.0/25.0)**p * (y/45000)**p
staxwbase=staxw*(45.0/25.0)**ptaxw
!note: we are normalizing to avg inc w also for e!
staxebase=staxe*(45.0/25.0)**ptaxe  !note: we are normalizing to avg inc w also for e!
! intialize

!******************** LOAD STUFF


CALL checkrow1 (Pr,dr)

! compute invariant distr for Pr
CALL devcrg (dr,TRANSPOSE(Pr),dr,eigvalcr,eigveccr,dr)
eigvalr=DBLE(eigvalcr)
eigvecr=DBLE(eigveccr)
imax=MAXLOC(eigvalr)
invr=eigvecr(:,imax(1))

invr=invr/SUM(invr)
WRITE (*,*)  "Invariant distribution on r"
WRITE (*,*) invr

! make up joint distr for y and r. y is outside
DO j=1,dy       !   y today
    DO jj=1,dy  !   y tomorrow
        Pyr((j-1)*dr+1:j*dr,(jj-1)*dr+1:jj*dr)=Py(j,jj)*Pr      
    END DO
END DO
DO i=1,dy*dr
    Pyr(i,:)=Pyr(i,:)/SUM(Pyr(i,:)) 
END DO

Pyrtr=TRANSPOSE(Pyr) ! compute inv dist for joint of y and r
CALL devcrg (dy*dr,Pyrtr,dy*dr,eigvalcyr,eigveccyr,dy*dr)
eigvalyr=DBLE(eigvalcyr)
eigvecyr=DBLE(eigveccyr)
imax=MAXLOC(eigvalyr)
invyr=eigvecyr(:,imax(1))
invyr=invyr/SUM(invyr)
WRITE (*,*)  "Invariant distribution on yr"
WRITE (*,*) invyr


! compute inv dist for y 
CALL devcrg (dy,TRANSPOSE(Py),dy,eigvalcy,eigveccy,dy)
eigvaly=DBLE(eigvalcy)
eigvecy=DBLE(eigveccy)
imax=MAXLOC(eigvaly)
invy=eigvecy(:,imax(1))
invy=invy/SUM(invy)
WRITE (*,*)  "Invariant distribution on y"
WRITE (*,*) invy

fname="output"
OPEN (unit=32,file=fname,status="replace", &
&       action="write",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE (*,*) 'problems opening ', fname
END IF
WRITE (unit=32, fmt=*) "***************************************"
WRITE (unit=32, fmt=*) "da=",da,"  dk=",dk,"  maxa=",maxa
WRITE (unit=32, fmt=*) "da1=",da1,"   da2=",da2
WRITE (unit=32, fmt=*) "gridabreak=",gridabreak,"gridkbreak=",gridkbreak
WRITE (unit=32, fmt=*) "bet=",bet,"   gam=",gam,"   eta=",eta
WRITE (unit=32, fmt=*) "ni= ",ni,"  theta=",r(2),"   eff=",eff
WRITE (unit=32, fmt=*) "delt=",delt   
WRITE (unit=32, fmt=*) "alph=",alph,"   alphe=",alphe
WRITE (unit=32, fmt=*) "abig=",abig
WRITE (unit=32, fmt=*) "repl rate=",replrate,"   taubal=",taubal,"   tauc=",tauc 
WRITE (unit=32, fmt=*)  "tauls=",tauls,"  exem=",exem,"  taub=",taub
IF (switchlabsupproptax==0) THEN
    WRITE (unit=32, fmt=*) "btaxw=",btaxw,"   staxw=",staxw,"   ptaxw=",ptaxw
    WRITE (unit=32, fmt=*) "btaxe=",btaxe,"   staxe=",staxe,"   ptaxe=",ptaxe
END IF
WRITE (unit=32, fmt=*) "gfrac=",gfrac,"   debtfrac=",debtfrac
WRITE (unit=32, fmt=*) "epsigovmin=",epsigovmin," epsirmin=", epsirmin
WRITE (unit=32, fmt=*) "***************************************"
CLOSE (unit=32)


IF 	(gridtype==1) THEN 
	CALL linspace(SQRT(mina),SQRT(maxa),da,a)
	a=a**2
	CALL linspace(SQRT(mink),SQRT(maxk),dk,k)
	k=k**2
ELSE IF (gridtype==2) THEN
	CALL linspace(mina,gridabreak,da1,a(1:da1))
	CALL linspace(DBLE(0.0),sqrt(maxa-gridabreak),da2+1,a(da1:da))
	a(da1:da)=gridabreak+a(da1:da)**2
	CALL linspace(mink,gridkbreak,dk1,k(1:dk1))
	CALL linspace(DBLE(0.0),sqrt(maxk-gridkbreak),dk2+1,k(dk1:dk))
	k(dk1:dk)=gridkbreak+k(dk1:dk)**2
ELSE IF (gridtype==3) THEN
	CALL linspace(SQRT(mina),SQRT(gridabreak),da1,a(1:da1))
	a(1:da1)=a(1:da1)**2
	CALL linspace(SQRT(mink),SQRT(gridkbreak),dk1,k(1:dk1))
	k(1:dk1)=k(1:dk1)**2
	CALL linspace(DBLE(0.0),sqrt(maxa-gridabreak),da2+1,a(da1:da))
	a(da1:da)=gridabreak+a(da1:da)**2
	CALL linspace(DBLE(0.0),sqrt(maxk-gridkbreak),dk2+1,k(dk1:dk))
	k(dk1:dk)=gridkbreak+k(dk1:dk)**2
END IF

anet=a
WHERE (anet.GT.exem) anet=(a-exem)*(1.0-taub)+exem

! compute borrowing for the case of exogenous bc
! return vector that gives closet k index for each lambd*a
DO i=1,da
	indanet=MINLOC(ABS(k-lambd*a(i)))
    kvecbc(i)=indanet(1)
END DO

! ************** taubals
taubalmin=0.001
taubalmax=0.035
taubal=taubalmin

tbalwidth=.3
taubalrbarmax=taubalmax
taubalrbarmin=taubalmin

rbar=5.142548825988317E-002 ! INITIALIZATION
ibar=rbar-phi

! initalize vectors used to store results
fundiff=0.0
funtota=0.0
funtotk=0.0
funrbar=0.0
taubalvec=0.0
imbalvec=0.0
govbalvec=0.0
gdpvec=0.0

govbal2gdpmin=0.0
govbal2gdpmax=0.0

epsir=1.0
iterar=1
bracketr=1
iteratot=1

! Fix the labor supply if exogenous
IF (switchlabsupproptax<2) THEN
    labsup=1.0
END IF


! loop on equilibrium interest rate
DO WHILE ((epsir>epsirmin).AND.(iterar.LE.iterarmax))
    wage=(1.0-alph)*abig*((xi*rbar+(1.0-xi)*ibar+delt)/(alph*abig))**(alph/(alph-1.0))

	!define useful constants
	term1=1.0/((1.0-alphe)*ni-1.0)
    front1=(wage/(ni*(1.0-alphe)))**term1	

	iteragov=1
	epsigov=1.0
	taubalvec=0.0
	imbalvec=0.0
	govbalvec=0.0
	gdpvec=0.0
	bracketgov=1
	noneedtaubalmax=0
	! Loop on government budget balance
	DO WHILE ((epsigov>epsigovmin).AND.(iteragov.LE.iteragovmax))
		!false position method. first we must compute the value of govbal in the extremes
		!(bracketgov=1 and 2), then we start interpolating the extremes    
		IF (bracketgov==1) THEN
			taubal=taubalmin
		ELSE IF (bracketgov==2) THEN
			taubal=taubalmax
		ELSE
			taubal=taubalmin-(taubalmax-taubalmin)*govbal2gdpmin/(govbal2gdpmax-govbal2gdpmin)
		END IF
		
		IF (switchlabsupproptax==0) THEN
    		!update staxw. further correction for ymedium in sim
    		staxw=staxwbase*totincw**(-ptaxw)
	    	staxe=staxebase*totincw**(-ptaxe)
	    END IF
        
        IF (switchlabsupproptax==2) THEN
            labsup=((wage*(1.0-taubal)/(1.0+tauc))/omega)**(1/psii)                        
        END IF 
        transf=replrate*wage*labsup*DOT_PRODUCT(y,invy)

        ! we now compute U(c) since it does not depend on V and borrowing constr
        ! note that retired have zero labor supply, so utility fn is unchanged
        uconsold=0.0    ! old retired.   rows=a, column=a'
        DO i=1,da ! today's assets
            ytaxo=transf+ibar*a(i)
 		    IF (switchlabsupproptax==0) THEN
    			taxo=(btaxw-btaxw*(staxw*ytaxo**ptaxw+1.0)**(-1.0/ptaxw))*ytaxo+taubal*ytaxo
    		ELSE
    		    taxo=taubal*ytaxo
    		END IF 
            cs=(a(i)*(1.0+ibar)+transf-a-tauls-taxo)/(1.0+tauc)
            WHERE (cs>0)
                ucons=(cs**(1.0-gam))/(1.0-gam)
            ELSEWHERE 
                ucons=penalty
            END WHERE
            uconsold(i,:)=ucons
        END DO        
       
        ! modify utility fun for labor supply
        uconsw=0.0  ! young worker  (da,da',dy) note: does not depend on r!
        DO i=1,da ! today
            DO j=1,dy ! today's y                                     
                ytaxw=wage*labsup*y(j)+ibar*a(i)  
       			IF (switchlabsupproptax==0) THEN
    			    taxw=(btaxw-btaxw*(staxw*ytaxw**ptaxw+1.0)**(-1.0/ptaxw))*ytaxw+taubal*ytaxw
    			ELSE
    		        taxw=taubal*ytaxw
    		    END IF                    
                cs=((1.0+ibar)*a(i)+wage*y(j)*labsup-taxw-a-tauls)/(1.0+tauc)
                WHERE (cs>omega*y(j)/(1+psii)*labsup**(1+psii)) ! ********sept06
                    ucons=((cs-omega*y(j)/(1+psii)*labsup**(1+psii))**(1.0-gam))/(1.0-gam)
                ELSEWHERE 
                    ucons=penalty
                END WHERE
                uconsw(i,:,j)=ucons
            END DO
        END DO

        uconse=0.0  !   entrep, flow utility for young and old is the same (da,da',dr,dk)
        DO i=1,da       !today's assets
            DO j=2,dr   ! today's r ! changed from dy=1,dr
				labe=front1*r(j)**(-term1)*k**(-alphe*ni*term1)
                labe=max(0.0,labe-1.0)                              
                ytaxe=r(j)*(k**alphe*(1.0+labe)**(1.0-alphe))**ni-delt*k-rbar*max(0.0,k-a(i))+ibar*max(0.0,a(i)-k)-wage*labe 
                IF (switchlabsupproptax==0) THEN
                    taxe=(btaxe-btaxe*(staxe*ytaxe**ptaxe+1.0)**(-1.0/ptaxe)) &
                    &   *ytaxe+taubal*ytaxe
                ELSE
                    taxe=taubal*ytaxe
                END IF 
                DO jj=1,da  ! tomorrow's a'
                    csl=(ytaxe-taxe+a(i)-a(jj)-tauls)/(1.0+tauc)
                    WHERE (csl>omega*y(j)/(1+psii))  ! ********sept06
                        uconsl=((csl-omega*y(j)/(1+psii))**(1.0-gam))/(1.0-gam) 
                    ELSEWHERE 
                        uconsl=penalty
                    END WHERE
                    uconse(i,jj,j-1,:)=uconsl 
                END DO
            END DO 
        END DO
        
		! Now define appropriate borrowing constraints: either endogenous, or exogenous and read in from
		! file, or equal to lambda*a
		IF (switchbc==0) THEN
			epsi=10
			! investment limit init. start over at the max k for any given rbar, taul, new value function iteration.
			kyhat=dk 
			kohat=dk			
		ELSE IF (switchbc==1) THEN						
			fname='exobc'
			open (unit=32,file=fname,status="old", &
			&       action="read",position="rewind",iostat=OpenStatus)
			IF (OpenStatus.NE.0) THEN
				WRITE (*,*) 'problems opening ', fname
			END IF

			DO i=1,da
				DO j=1,dy
					DO jj=1,dr
						READ (unit=32, fmt=*) kyhat(i,j,jj)
					END DO
				END DO
			END DO
			DO i=1,da
				DO jj=1,dr
					READ (unit=32, fmt=*) kohat(i,jj)
				END DO
			END DO
		ELSE 
			DO i=1,dy
				DO j=2,dr
					kyhat(:,i,j)=kvecbc						
				END DO
			END DO 
			DO j=2,dr
				kohat(:,j)=kvecbc					
			END DO
		END IF 
		! regardless of type of bc, impose that people with r=0 cannot be entrepreneurs
        ! (never an issue for the young anyway)
		kyhat(:,:,1)=0
		kohat(:,1)=0    
		iterakhat=1 ! first round for given rbar and taul
		! go and compute value fn for given bc
		epsihat=1

        DO WHILE (epsihat>0) ! loop on endogenous borrowing constraints
            itera=0
            epsihat=0
            ! start value function iterations, given khat for young and old
            epsi=10
            IF (iterakhat.LE.nite .AND. iterar.NE.1) THEN
                Vye=Vyer(:,:,:,iterakhat) 
                Vyw=Vywr(:,:,:,iterakhat)
                Vy=Vyr(:,:,:,iterakhat)
                Voee=Voeer(:,:,iterakhat)
                Vow=Vowr(:,iterakhat)
                Voe=Voer(:,:,iterakhat)
            END IF
            DO WHILE (epsi>epsimin) ! loop on value funcs for given b.c 
                itera=itera+1
                ! compute expected value of V of NEWBORNS
                ! only NEWBORN ENTREPRENEUR, INHERITS parent's r'
                EVnewbw=0.0
                EVnewbe=0.0 
                DO i=1,dy ! tomorrow
                    DO j=1,dr
                        call interplin(da,a,Vy(:,i,j),da,anet,Vynet)
                        EVnewbw=invyr((i-1)*dr+j)*Vynet+EVnewbw
                        EVnewbe(:,j)=invy(i)*Vynet+EVnewbe(:,j)
                    END DO
                END DO
                !loop for OLD WORKER
                DO i=1,da ! today's assets
                    Vowtemp=uconsold(i,:)+bet*pold*Vow+eta*bet*(1.0-pold)*EVnewbw
                    imax=MAXLOC(Vowtemp)
                    newVow(i)=Vowtemp(imax(1))
                    apolow(i)=imax(1)
                END DO  
                ! loop for old entrepreneur
                ! entrepreneur staying entrepreneur
                DO i=1,da       !today's assets
                    DO j=2,dr   ! today's r
                        DO jj=1,da  ! tomorrow's a'
                            Voeetemp(:,jj)=uconse(i,jj,j-1,:)+&
                            &   bet*pold*DOT_PRODUCT(Voe(jj,:),Pr(j,:))+&
                            &   eta*bet*(1.0-pold)*DOT_PRODUCT(EVnewbe(jj,:),Pr(j,:))
                            ! impose kohat
                            IF (kohat(i,j).LT.dk) THEN
                                !** when cannot borrow (kohat=last at which one can borrow)
                                Voeetemp(kohat(i,j)+1:,jj)=penalty
                            END IF
                        END DO
                        imaxmat=MAXLOC(Voeetemp)
                        Voee(i,j)=Voeetemp(imaxmat(1),imaxmat(2))
                        IF (Voee(i,j).GT.newVow(i)) THEN
                            newVoe(i,j)=Voee(i,j)
                            apoloe(i,j)=imaxmat(2)
                            kpoloe(i,j)=imaxmat(1)
                        ELSE
                            newVoe(i,j)=newVow(i)
                            apoloe(i,j)=apolow(i)
                            kpoloe(i,j)=-1              
                        END IF
!                       get optimal policy for labor demand
                        IF (kpoloe(i,j) .ne. -1) then
                           labdemand=front1*r(j)**(-term1)*k(kpoloe(i,j))**(-alphe*ni*term1)
                           labpoloe(i,j)=max(0.0,labdemand-1.0)           
                        ELSE
                           labpoloe(i,j)=0.0
                        ENDIF
                    END DO
                END DO
                ! now impose that OLD guys with r=0 have to retire
                newVoe(:,1)=newVow
                apoloe(:,1)=apolow
                kpoloe(:,1)=-1 
                labpoloe(:,1)=0.0
                
                EVy=0.0
                DO i=1,dy                   !today
                    DO j=1,dr
                        DO i2=1,dy          !tomorrow
                            DO j2=1,dr
                                EVy(:,i,j)=Pyr((i-1)*dr+j,(i2-1)*dr+j2)*&
                                & Vy(:,i2,j2)+EVy(:,i,j)
                            END DO
                        END DO
                    END DO
                END DO
                !val fn for young that is a worker for the period   
                DO i=1,da ! today
                    DO j=1,dy ! today's y                       
                        DO jj=1,dr ! todays' r
                            Vywtemp=uconsw(i,:,j)+bet*pyou*EVy(:,j,jj)+&
                            &   bet*(1.0-pyou)*newVow
                            imax=MAXLOC(Vywtemp)
                            newVyw(i,j,jj)=Vywtemp(imax(1))
                            apolyw(i,j,jj)=imax(1)
                        END DO
                    END DO
                END DO
                
                ! Note that we imposed no entrepreneurship for people
                ! with zero ability, which is anyway optimal for the young
                ! We exploit this and compute val fn below only for guys with positive r
                ! val fn for young that is a ENTR for the period    
                ! young entrepreneur decisions
                DO i=1,da       !today's assets
                    DO j=2,dr   ! today's r ! changed from dy=1,dr
                        DO j1=1,dy  !today's y
                            DO jj=1,da  ! tomorrow's a'                                
                                Vyetemp(:,jj)=uconse(i,jj,j-1,:)+ &      
                                &   bet*pyou*EVy(jj,j1,j)+ &
                                &   bet*(1.0-pyou)*DOT_PRODUCT(newVoe(jj,:),Pr(j,:))   
                                ! impose kyhat
                                IF (kyhat(i,j1,j).LT.dk) THEN
                                    Vyetemp(1+kyhat(i,j1,j):,jj)=penalty
                                END IF                  
                            END DO
                            imaxmat=MAXLOC(Vyetemp)
                            newVye(i,j1,j)=Vyetemp(imaxmat(1),imaxmat(2))
                            apolye(i,j1,j)=imaxmat(2)
                            kpolye(i,j1,j)=imaxmat(1)
                            
                            ! YOUNG decide if e or w
                            IF (newVye(i,j1,j).GT.newVyw(i,j1,j)) THEN  
                                newVy(i,j1,j)=newVye(i,j1,j)
                                apoly(i,j1,j)=apolye(i,j1,j)
                                kpoly(i,j1,j)=kpolye(i,j1,j)
                            ELSE
                                newVy(i,j1,j)=newVyw(i,j1,j)
                                apoly(i,j1,j)=apolyw(i,j1,j)
                                kpoly(i,j1,j)=-1          
                            END IF
                            ! get optimal policy for labor demand                            
                            IF (kpoly(i,j1,j) .ne. -1) then
                               labdemand=front1*r(j)**(-term1)*k(kpoly(i,j1,j))**(-alphe*ni*term1)
                               labpoly(i,j1,j)=max(0.0,labdemand-1.0)           
                            ELSE
                               labpoly(i,j1,j)=0.0
                            ENDIF                             
                        END DO
                    END DO
                END DO
                ! now use the fact that YOUNG guys with r=0 always choose
                ! to be workers
                newVye(:,:,1)=newVyw(:,:,1)
                apolye(:,:,1)=apolyw(:,:,1)
                kpolye(:,:,1)=-1
                newVy(:,:,1)=newVyw(:,:,1)
                apoly(:,:,1)=apolyw(:,:,1)
                kpoly(:,:,1)=-1   
                labpoly(:,:,1)=0.0     

                epsi=MAXVAL(ABS(newVow-Vow))+MAXVAL(ABS(newVoe-Voe))+ &
                &   MAXVAL(ABS(newVye-Vye))+MAXVAL(ABS(newVyw-Vyw))+&
                &   MAXVAL(ABS(newVy-Vy))
                WRITE (*,*) itera,epsi
                Vow=(1.0-relax)*newVow+relax*Vow
                Voe=(1.0-relax)*newVoe+relax*Voe
                Vyw=(1.0-relax)*newVyw+relax*Vyw
                Vye=(1.0-relax)*newVye+relax*Vye
                Vy=(1.0-relax)*newVy+relax*Vy
            END DO ! DO WHILE (epsi>epsimin) ! loop on value funcs for given b.c 
            
            
			IF (switchbc==0) THEN 
				! now check temptation to run with borrowed money
				! value function of the OLD WORKER STARTING OFF AFTER DEFAULT 
				! (with assets k*eff)
            
				CALL interplin(da,a,Vow,dk,eff*k,Vokeff)            			
				DO i=1,da
					DO j=2,dr
						count1=1
						count2=1
						DO WHILE (count1.GT.0)
							IF (Voe(i,j).LT.Vokeff(count2)) THEN
								newkohat(i,j)=count2-1
								count1=0
							END IF
							count2=count2+1
							IF (count2==(dk+1)) THEN 
								newkohat(i,j)=dk
								count1=0
							END IF
						END DO
					END DO
				END DO
				! impose retirement for people with r=0
				newkohat(:,1)=0
				epsihato=MAXVAL(ABS(newkohat-kohat))
				WRITE (*,*) "MAXVAL(newkohat-kohat)",MAXVAL(newkohat-kohat)
				kohat=newkohat

				! value function of the young worker starting off after default 
				! (with assets k*eff)
				DO j1=1,dy
	                DO j=1,dr                   
		                CALL interplin(da,a,Vyw(:,j1,j),dk,eff*k,Vwkeff(:,j1,j))
			        END DO
	            END DO
		        DO i=1,da
			        DO j1=1,dy
				        DO j=2,dr
					        count1=1
						    count2=1
							DO WHILE (count1.GT.0)
								IF (Vye(i,j1,j).LT.Vwkeff(count2,j1,j)) THEN
									newkyhat(i,j1,j)=count2-1
									count1=0
	                            END IF
		                        count2=count2+1
			                    IF (count2==(dk+1)) THEN 
				                    newkyhat(i,j1,j)=dk
					                count1=0
						        END IF
							END DO      
	                    END DO
		            END DO
				END DO
				! impose no entrepreneurship for people with r=0
				newkyhat(:,:,1)=0
				epsihaty=MAXVAL(ABS(newkyhat-kyhat))
				WRITE (*,*) "MAXVAL(newkyhat-kyhat)",MAXVAL(newkyhat-kyhat)
				kyhat=newkyhat
				epsihat=epsihato+epsihaty
				WRITE (*,*) "iterakhat",iterakhat," epsihato",epsihato," epsihaty",epsihaty
				iterakhat=iterakhat+1
			ELSE 
				epsihat=0
			END IF !IF (switchbc==0) THEN 
							
			IF (iterakhat.LE.nite) THEN
				Vyer(:,:,:,iterakhat)=Vye
				Vywr(:,:,:,iterakhat)=Vyw
				Vyr(:,:,:,iterakhat)=Vy 
				Voeer(:,:,iterakhat)=Voee
				Vowr(:,iterakhat)=Vow
				Voer(:,:,iterakhat)=Voe
			END IF
		END DO ! DO WHILE(countkhat)

        WRITE(*,*) "FINISHED COMPUTING VALUE FUNCTIONS"

        ! constructing the TRANSITION MATRIX in sparse form
        ! sparse=row indices, col indices, values
        ! 
        ! order of the transition matrix:
        ! y workers-        r - y - assets
        ! y entrepreneurs-  r - y - assets
        ! old entr          r -     assets
        ! old                       assets
        !
        rowM=0
        colM=0
        valM=0.0
        !***************** assets net of bequest taxes
        DO i=1,da
            IF (a(apolow(i)).LE.exem) THEN
                apolownet(i)=apolow(i)
            ELSE
                indanet=MINLOC(ABS(a-(1-taub)*(a(apolow(i))-exem)-exem))
                apolownet(i)=indanet(1)
            END IF
        END DO
        DO i=1,da
            DO j=1,dr
                IF (a(apoloe(i,j)).LE.exem) THEN
                    apoloenet(i,j)=apoloe(i,j)
                ELSE
                    indanet=MINLOC(ABS(a-(1-taub)*(a(apoloe(i,j))-exem)-exem))
                    apoloenet(i,j)=indanet(1)
                END IF  
            END DO
        END DO
        counter=nonzero-(da*(dy*dr+1))+1    ! number of elements for the old
        !block transition oldw - ?
        DO i=1,da               !asset today
            crow=sizeM-da+i     !row of M
            !if reborn
            DO ll=1,dr          ! r tomorrow
                DO jj=1,dy      ! y tomorrow
                    rowM(counter)=crow
                    colM(counter)=(ll-1)*dy*da+(jj-1)*da+apolownet(i)
                    valM(counter)=invyr((jj-1)*dr+ll)*(1.0-pold)
                    counter=counter+1
                END DO
            END DO
            ! if remains old
            rowM(counter)=crow
            colM(counter)=2*nyoung+noe+apolow(i)
            valM(counter)=pold
            counter=counter+1
        END DO
        !block transition old entr - ?
        counter=2*(dy*dr+dr+1)*nyoung+1
        DO l=1,dr       ! r today
            DO i=1,da   ! a today
                crow=2*nyoung+(l-1)*da+i
                ! if reborn
                DO ll=1,dr ! r', the one the children inherit
                    DO jj=1,dy  ! child's y, drawn from invariant distrbn
                        rowM(counter)=crow
                        ! if remain entr, this is col
                        colM(counter)=(ll-1)*dy*da+(jj-1)*da+apoloenet(i,l)
                        ! if become work, add some elements to col
                        IF  (kpoloe(i,l).GT.0) THEN
                            colM(counter)=colM(counter)+nyoung
                        END IF
                        valM(counter)=(1.0-pold)*invy(jj)*Pr(l,ll)
                        counter=counter+1
                    END DO
                END DO
                ! if remains old
                IF  (kpoloe(i,l)==-1) THEN  ! becomes worker
                    rowM(counter)=crow
                    colM(counter)=2*nyoung+noe+apoloe(i,l)
                    valM(counter)=pold
                    counter=counter+1
                    DO ll=1,dr
                        rowM(counter)=crow
                        colM(counter)=2*nyoung+(ll-1)*da+apoloe(i,l)
                        valM(counter)=0.0
                        counter=counter+1
                    END DO
                ELSE                    ! remains entrepreneur
                    rowM(counter)=crow
                    colM(counter)=2*nyoung+noe+apoloe(i,l)
                    valM(counter)=0.0
                    counter=counter+1
                    DO ll=1,dr
                        rowM(counter)=crow
                        colM(counter)=2*nyoung+(ll-1)*da+apoloe(i,l)
                        valM(counter)=Pr(l,ll)*pold
                        counter=counter+1
                    END DO
                END IF      
            END DO
        END DO
        !block transition young work - ?        
        counter=1
        DO l=1,dr   !today
            DO j=1,dy   !today
                DO i=1,da   !today
                    crow=(l-1)*da*dy+(j-1)*da+i
                    !   if next period remains young
                    DO ll=1,dr ! tomorrow
                        DO jj=1,dy
                            rowM(counter)=crow
                            ! if remain work, this is col
                            colM(counter)=(ll-1)*dy*da+(jj-1)*da+apoly(i,j,l)
                            CALL checkcolM(1)
                            ! if become entr, add some elements to col
                            IF  (kpoly(i,j,l).GT.0) THEN
                                colM(counter)=colM(counter)+nyoung
                                CALL checkcolM(2)
                            END IF
                            valM(counter)=pyou*Pyr((j-1)*dr+l,(jj-1)*dr+ll)
                            counter=counter+1
                        END DO
                    END DO
                    !   if next period becomes old
                    IF  (kpoly(i,j,l)==-1) THEN     !   if remains worker
                        rowM(counter)=crow
                        colM(counter)=2*nyoung+noe+apoly(i,j,l)
                        CALL checkcolM(3)
                        valM(counter)=(1-pyou)
                        counter=counter+1
                        DO ll=1,dr
                            rowM(counter)=crow
                            colM(counter)=2*nyoung+(ll-1)*da+apoly(i,j,l)
                            CALL checkcolM(4)
                            valM(counter)=0.0
                            counter=counter+1
                        END DO
                    ELSE                            !   if becomes entr
                        rowM(counter)=crow
                        colM(counter)=2*nyoung+noe+apoly(i,j,l)
                        CALL checkcolM(5)
                        valM(counter)=0.0
                        counter=counter+1
                        DO ll=1,dr
                            rowM(counter)=crow                          
                            colM(counter)=2*nyoung+(ll-1)*da+apoly(i,j,l)
                            CALL checkcolM(6)
                            valM(counter)=Pr(l,ll)*(1-pyou)
                            counter=counter+1
                        END DO
                    END IF  
                END DO
            END DO
        END DO
        !block young entr - ?
        IF (counter.NE.nyoung*(dy*dr+dr+1)+1) WRITE(*,*) "counter does not match!!"
            DO l=1,dr   !today
                DO j=1,dy   !today
                    DO i=1,da   !today
                        crow=nyoung+(l-1)*da*dy+(j-1)*da+i
                    !   if next period remains young
                    DO ll=1,dr
                        DO jj=1,dy
                            rowM(counter)=crow
                            ! if becomes work, this is col                          
                            colM(counter)=(ll-1)*dy*da+(jj-1)*da+apoly(i,j,l)
                            ! if become entr, add some elements to col                          
                            IF  (kpoly(i,j,l).GT.0) THEN
                                colM(counter)=colM(counter)+nyoung
                            END IF
                            valM(counter)=pyou*Pyr((j-1)*dr+l,(jj-1)*dr+ll)
                            counter=counter+1
                        END DO
                    END DO
                    !   if next period becomes old                  
                    IF  (kpoly(i,j,l)==-1) THEN     !   if becomes worker
                        rowM(counter)=crow                      
                        colM(counter)=2*nyoung+noe+apoly(i,j,l)
                        valM(counter)=(1.0-pyou)
                        counter=counter+1
                        DO ll=1,dr
                            rowM(counter)=crow                      
                            colM(counter)=2*nyoung+(ll-1)*da+apoly(i,j,l)
                            valM(counter)=0.0
                            counter=counter+1
                        END DO
                    ELSE                            !   if becomes entr
                        rowM(counter)=crow                  
                        colM(counter)=2*nyoung+noe+apoly(i,j,l)
                        valM(counter)=0.0
                        counter=counter+1
                        DO ll=1,dr
                            rowM(counter)=crow                          
                            colM(counter)=2*nyoung+(ll-1)*da+apoly(i,j,l)
                            valM(counter)=Pr(l,ll)*(1.0-pyou)
                            counter=counter+1
                        END DO
                    END IF  
                END DO
            END DO
        END DO
        
        ! just to check for debugging purposes
        CALL printwe2inc()
        CALL printinvdistr()
		CALL printtotgov()
		CALL printtotfun()
        CALL printvalfun()      
        CALL checksumrowM()
        
        
        WRITE(*,*) "FINISHED COMPUTING TRANSITION MATRIX"

        !   compute invariant distribution
        itera=0 
        epsinv=10
        DO WHILE (epsinv> epsinvmin)
            invm1=invm
            invm=0.0
            ! this do loop is the product M'*invm, M sparse
            ! to transpose M, we simply use colM instead of rowM
            ! invm= new inv distr
            ! invm1= old inv distr
            DO i=1,nonzero
                invm(colM(i))=invm(colM(i))+invm1(rowM(i))*valM(i)
            END DO
            epsinv=MAXVAL(ABS(invm-invm1))
            itera=itera+1
        END DO
        invm=invm/sum(invm)

        ! invariant distribution of a on people that were young workers in the previous period and remained young
        ! into this period, or children of people that were retirees in the previous period
        prgridyw=0.0
        DO i2=1,dy*dr
            prgridyw=prgridyw+invm((i2-1)*da+1:i2*da)
        END DO
        ! same for people that were young entrepreneurs in the previous period and remain young into this period,
        ! or children of people that were old entrepreneurs in the previous period
        prgridye=0.0
        DO i2=1,dy*dr
            prgridye=prgridye+invm(nyoung+(i2-1)*da+1:nyoung+i2*da)
        END DO                                                          
        ! same for people that were entrepreneurs last period (young or old) and are old today
        prgridoe=0.0
        DO i2=1,dr
            prgridoe=prgridoe+invm(2*nyoung+(i2-1)*da+1:2*nyoung+i2*da)
        END DO
        ! same for people that were young workers last period and have become old, or old retirees last period that remain old
        prgridow=invm(nstates-da+1:)
        !total invariant distr
        prgrid=prgridyw+prgridye+prgridoe+prgridow
        
        ! compute total number of entrepreneurs (which should also be a fraction,
        ! since we normalized total population to be 1)
        ! Notice that the sum of prgridye and prgridoe counts everybody that was an entrepreneur last period,
        ! so this is the fraction of entrepreneurs last period which coincides with the fraction of entrepreneurs
        ! in this period in steady state
        totentr=SUM(prgridye)+SUM(prgridoe)
            
        invpolk=0   ! k pol fn corresponding to each element of invm
        invlevk=0.0 ! k level ...
        invrk=0.0   ! return corresponding to each element of invm (except old work)
        invkborr=0.0    ! net amount borrowed by e, kbor=k-a
        invkgrossborr=0.0 ! gross borrowing
        invyshe=0.0     !shadow y for e
        invlabe=0.0      ! outside labor demand to invm
        invtotlabe=0.0   ! total labor demand to invm   
        totL=0.0 ! number of workers
        
        ifswitchew=0    ! 1 if switch from e to non e (w or ret)
        ifswitchwe=0    ! 1 if switch from w to e
        toteffL=0.0 ! total efficiency units (.neq.totL because entr choice depends on y and because of labor supply).
        counter=1
        DO l=1,dr   ! young workers
            invrk((l-1)*da*dy+1:l*da*dy)=r(l)
            DO j=1,dy
                DO i=1,da               
                    invpolk(counter)=kpoly(i,j,l)
                    IF (kpoly(i,j,l).GT.0) THEN
                        invlevk(counter)=k(kpoly(i,j,l))
                        invkborr(counter)=k(kpoly(i,j,l))-a(i)
                        invkgrossborr(counter)=max(0.0,k(kpoly(i,j,l))-a(i))                
                        invyshe(counter)=y(j)*wage*labsup                  
                        invlabe(counter)=labpoly(i,j,l)
                        invtotlabe(counter)=1.0+invlabe(counter) 
                        ifswitchwe(counter)=1
                    ELSE
                        toteffL=toteffL+y(j)*invm((l-1)*da*dy+(j-1)*da+i)*labsup
                        totL=totL+invm((l-1)*da*dy+(j-1)*da+i)
                    END IF
                    counter=counter+1
                END DO
            END DO
        END DO  
        DO l=1,dr   ! young entrepreneurs
            invrk(nyoung+(l-1)*da*dy+1:nyoung+l*da*dy)=r(l)
            DO j=1,dy
                DO i=1,da
                    invpolk(counter)=kpoly(i,j,l)
                    IF (kpoly(i,j,l).GT.0) THEN
                        invlevk(counter)=k(kpoly(i,j,l))
                        invkborr(counter)=k(kpoly(i,j,l))-a(i)
                        invkgrossborr(counter)=max(0.0,k(kpoly(i,j,l))-a(i))
                        invyshe(counter)=y(j)*wage*labsup                  
                        invlabe(counter)=labpoly(i,j,l)
                        invtotlabe(counter)=1.0+invlabe(counter)                  
                    ELSE
                        ifswitchew(counter)=1
                        toteffL=toteffL+y(j)*invm(nyoung+(l-1)*da*dy+(j-1)*da+i)*labsup
                        totL=totL+invm(nyoung+(l-1)*da*dy+(j-1)*da+i)
                    END IF
                    counter=counter+1
                END DO
            END DO
        END DO
        DO l=1,dr   !   old entrepreneurs
            invrk(2*nyoung+(l-1)*da+1:2*nyoung+l*da)=r(l)
            DO i=1,da
                invpolk(counter)=kpoloe(i,l)
                IF (kpoloe(i,l).GT.0) THEN
                    invlevk(counter)=k(kpoloe(i,l))
                    invkborr(counter)=k(kpoloe(i,l))-a(i)
                    invkgrossborr(counter)=max(0.0,k(kpoloe(i,l))-a(i))
                    invyshe(counter)=transf                 
                    invlabe(counter)=labpoloe(i,l)
                    invtotlabe(counter)=1.0+invlabe(counter) 
                ELSE
                    ifswitchew(counter)=1
                END IF
                counter=counter+1
            END DO
        END DO
        
        ! Retirees computed as a residual
        totret=1-totentr-totL 
        
        ! capital and effective outside labor EMPLOYED by entr
        totk=DOT_PRODUCT(invlevk,invm(:nstates-da))
        hiredlabe=DOT_PRODUCT(invlabe,invm(:nstates-da))
         
        invrky=invrk(:2*nyoung)
        invrko=invrk(2*nyoung+1:nstates-da)
        invlevky=invlevk(:2*nyoung)
        invlevko=invlevk(2*nyoung+1:nstates-da)
        invtotlabye=invtotlabe(:2*nyoung)
        invtotlaboe=invtotlabe(2*nyoung+1:nstates-da)
        invmy=invm(:2*nyoung)
        invmo=invm(2*nyoung+1:nstates-da)
		! GROSS entr. output
		! note inck includes wages paid  interest owed and depr. check
        incky=DOT_PRODUCT(invrky*(invlevky**alphe*invtotlabye**(1.0-alphe))**ni,invmy)
        incko=DOT_PRODUCT(invrko*(invlevko**alphe*invtotlaboe**(1.0-alphe))**ni,invmo)
        inck=incky+incko
      
        tota=DOT_PRODUCT(a,prgrid)
        totayw=DOT_PRODUCT(a,prgridyw)
        totaye=DOT_PRODUCT(a,prgridye)
        totaow=DOT_PRODUCT(a,prgridow)
        totaoe=DOT_PRODUCT(a,prgridoe)
       
        ! check need to check positivity
        totlcorp=toteffL-hiredlabe          ! total effective labor in corporate sector
		IF (totlcorp .LE. 0.0) THEN 
			WRITE(*,*) 'totlcorp', totlcorp  
			WRITE(*,*) 'LABOR IN CORP SECTOR IS NEGATIVE'
			STOP
		END IF
  	
        totkborr=DOT_PRODUCT(invkborr,invm(:nstates-da))
        totkgrossborr=DOT_PRODUCT(invkgrossborr,invm(:nstates-da))           
       
        IF (dorloop==1) THEN ! endo prices
            ! We have intermediation costs, but they are in terms of goods, not capital.
            ! All capital goes to the corporate sector or to the entrepreneurs
            totkcorp=tota/(1.0+debtfrac)-totk
        ELSE
            totkcorp=((xi*rbar+(1.0-xi)*ibar+delt)/(abig*alph))**(1.0/(alph-1.0))*totlcorp
        END IF    
       
        rcorp=abig*alph*(totkcorp/totlcorp)**(alph-1.0)-delt                      
        wageimplied=abig*(1.0-alph)*((rcorp+delt)/(abig*alph))**(alph/(alph-1.0))
        ! In equilibrium, rcorp=xi*rbar+(1-xi)*ibar=xi*rbar+(1-xi)*(rbar-phi)=rbar-(1-xi)*phi,
        ! rbar=rcorp+(1-xi)*phi
        rimplied=rcorp+(1-xi)*phi
        govdebt=debtfrac*(totkcorp+totk)
        ! use product rather than payments to compute GDP
        capintermed=xi*totkcorp+totkgrossborr
        IF (oldnipaswitch==1) THEN                
            ! intermediation costs are paid out of this product, so they should not show up again 
            gdp=abig*(totkcorp**alph)*(totlcorp**(1.0-alph))+inck       
        ELSE
            ! intermediation costs are netted out, since financial services are an intermediate input according
            ! to NIPA if the depositors are paid the rate on government debt
            gdp=abig*(totkcorp**alph)*(totlcorp**(1.0-alph))+inck-phi*capintermed
        END IF
        
        k2gdp=(totk+totkcorp)/gdp
        !total wealth held by entrepreneurs (at beginning of period)
        totke=DOT_PRODUCT(a,prgridye)+DOT_PRODUCT(a,prgridoe)
        totyshe=DOT_PRODUCT(invyshe,invm(:nstates-da))
        ! gross income, net of capital and hired lab comp.
        ykshare=(inck-rbar*totkborr-wage*hiredlabe)/gdp
        ! share of capital in gdp
        IF (oldnipaswitch==1) THEN        
            yktotsh=(alph*abig*(totkcorp**alph)*(totlcorp**(1.0-alph))+inck-wage*hiredlabe)/gdp
        ELSE
            ! Financial services must be subtracted, since they are charged to borrowers
            yktotsh=(alph*abig*(totkcorp**alph)*(totlcorp**(1.0-alph))+inck-wage*hiredlabe-phi*(xi*totkcorp+totk))/gdp
        END IF
        
        ! fraction of e switching from e to y and from y to e
        propewswitch=DOT_PRODUCT(ifswitchew,invm)/totentr
        propweswitch=DOT_PRODUCT(ifswitchwe,invm)/totL
        
        CALL printinvdistr()
        
        

		!************************
		! compute tax revenues
		vectaxcw=0.0
		vectaxce=0.0
		vectaxl=0.0
		vectaxe=0.0
		vectaxbw=0.0
		vectaxbe=0.0
		
		! Compute bequests
		vecbeq=0.0
		
		! compute average income workers
		vectotincw=0.0
		vecwe2yw=0.0
		vecwe2ye=0.0
		whoise=0
		counter=1 
		DO l=1,dr   ! young workers
			rhere=r(l)
			DO j=1,dy
	            DO i=1,da
		            ahere=a(apoly(i,j,l))                   
			        IF (kpoly(i,j,l).GT.0) THEN
				        khere=k(kpoly(i,j,l))
				        lhere=labpoly(i,j,l)
					    entinchere=rhere*(khere**alphe*(1.0+lhere)**(1.0-alphe))**ni-delt*khere-rbar*max(0.0,khere-a(i))+ ibar*max(0.0,a(i)-khere)-wage*lhere
						IF (switchlabsupproptax==0) THEN
							vectaxe(counter)=(btaxe-btaxe*(staxe*entinchere**ptaxe+1.0) &
    						&   **(-1.0/ptaxe))*entinchere+taubal*entinchere
    					ELSE
    					    vectaxe(counter)=taubal*entinchere
    					END IF
						vectaxce(counter)=tauc*(entinchere-vectaxe(counter) &
						& +a(i)-tauls-ahere)/(1.0+tauc)
						vecwe2ye(counter)=a(i)/entinchere
						whoise(counter)=1
					ELSE                        
	                    winchere=wage*y(j)*labsup+ibar*a(i)
						IF (switchlabsupproptax==0) THEN
							vectaxl(counter)=(btaxw-btaxw*(staxw*winchere**ptaxw+1.0)**(-1.0/ptaxw))&
    						&   *winchere+taubal*winchere
    					ELSE
    					    vectaxl(counter)=taubal*winchere
    					END IF		
						vectaxcw(counter)=tauc*((1.0+ibar)*a(i)+wage*y(j)*labsup &
						&   -vectaxl(counter)-ahere-tauls)/(1.0+tauc)
						vectotincw(counter)=wage*y(j)*labsup+ibar*a(i)
						vecwe2yw(counter)=a(i)/winchere
					END IF
					counter=counter+1
				END DO
			END DO
		END DO
		DO l=1,dr   ! young entrepreneurs
			rhere=r(l)
			DO j=1,dy
	            DO i=1,da
		            ahere=a(apoly(i,j,l))           
			        IF (kpoly(i,j,l).GT.0) THEN
				        khere=k(kpoly(i,j,l))
				        lhere=labpoly(i,j,l)
					    entinchere=rhere*(khere**alphe*(1.0+lhere)**(1.0-alphe))**ni-delt*khere-rbar*max(0.0,khere-a(i))+ ibar*max(0.0,a(i)-khere)-wage*lhere
						IF (switchlabsupproptax==0) THEN
							vectaxe(counter)=(btaxe-btaxe*(staxe*entinchere**ptaxe+1.0) &
    						&   **(-1.0/ptaxe))*entinchere+taubal*entinchere
    					ELSE
    					    vectaxe(counter)=taubal*entinchere
    					END IF
						vectaxce(counter)=tauc*(entinchere-vectaxe(counter) &
						& +a(i)-tauls-ahere)/(1.0+tauc)
						vecwe2ye(counter)=a(i)/entinchere 
						whoise(counter)=1
					ELSE
    					winchere=wage*y(j)*labsup+ibar*a(i)
						IF (switchlabsupproptax==0) THEN
							vectaxl(counter)=(btaxw-btaxw*(staxw*winchere**ptaxw+1.0)**(-1.0/ptaxw))&
    						&   *winchere+taubal*winchere	
    					ELSE
    					    vectaxl(counter)=taubal*winchere
    					END IF    					
	                    vectaxcw(counter)=tauc*((1.0+ibar)*a(i)+wage*y(j)*labsup &
			            &   -vectaxl(counter)-ahere-tauls)/(1.0+tauc)
				        vectotincw(counter)=wage*y(j)*labsup+ibar*a(i)
					    vecwe2yw(counter)=a(i)/winchere
					END IF
					counter=counter+1
				END DO
			END DO
		END DO
		DO l=1,dr   !   old entrepreneurs
			rhere=r(l)
			DO i=1,da
				ahere=a(apoloe(i,l))
				vecbeq(counter)=ahere      
				IF (kpoloe(i,l).GT.0) THEN
	                khere=k(kpoloe(i,l))
				    lhere=labpoloe(i,l)				  
					entinchere=rhere*(khere**alphe*(1.0+lhere)**(1.0-alphe))**ni-delt*khere-rbar*max(0.0,khere-a(i))+ ibar*max(0.0,a(i)-khere)-wage*lhere
					IF (switchlabsupproptax==0) THEN
						vectaxe(counter)=(btaxe-btaxe*(staxe*entinchere**ptaxe+1.0) &
    					&   **(-1.0/ptaxe))*entinchere+taubal*entinchere
    				ELSE
    				    vectaxe(counter)=taubal*entinchere
    				END IF	
	                vectaxce(counter)=tauc*(entinchere-vectaxe(counter) &
	                & +a(i)-tauls-ahere)/(1.0+tauc)
		            vectaxbe(counter)=max(0.0,(ahere-exem))*taub
			        vecwe2ye(counter)=a(i)/entinchere
				    whoise(counter)=1
				ELSE
					winchere=transf+ibar*a(i)
					IF (switchlabsupproptax==0) THEN
						vectaxl(counter)=(btaxw-btaxw*(staxw*winchere**ptaxw+1.0)**(-1.0/ptaxw))*winchere &
    					& +taubal*winchere					
    				ELSE
    				    vectaxl(counter)=taubal*winchere
    				END IF					
					vectaxcw(counter)=tauc*(a(i)*(1.0+ibar)+transf-ahere-tauls-vectaxl(counter))/(1.0+tauc)
					vectaxbw(counter)=max(0.0,(ahere-exem))*taub
					vectotincw(counter)=transf+ibar*a(i)
					whoise(counter)=2
				END IF
				counter=counter+1
			END DO
		END DO
		DO i=1,da  !    old retirees
			ahere=a(apolow(i))
			vecbeq(counter)=ahere
	        winchere=transf+ibar*a(i)
			IF (switchlabsupproptax==0) THEN
				vectaxl(counter)=(btaxw-btaxw*(staxw*winchere**ptaxw+1.0)**(-1.0/ptaxw))*winchere &
    			& +taubal*winchere
    		ELSE
    		    vectaxl(counter)=taubal*winchere
    		END IF			
			vectaxcw(counter)=tauc*(a(i)*(1.0+ibar)+transf-ahere-tauls-vectaxl(counter))/(1.0+tauc)
			vectaxbw(counter)=max(0.0,(ahere-exem))*taub
			vectotincw(counter)=transf+ibar*a(i)
			whoise(counter)=2               
			counter=counter+1
		END DO
		tottaxl=DOT_PRODUCT(invm,vectaxl)
		tottaxe=DOT_PRODUCT(invm,vectaxe)
		tottaxcw=DOT_PRODUCT(invm,vectaxcw)
		tottaxce=DOT_PRODUCT(invm,vectaxce)
		
		! Revenues from bequest taxes arrive only at the beginning of the subsequent period. However, they arrive in time
		! to collect interest in the subsequent period, so in present value it is as if they were collected today
		! As an alternative interpretation, government debt is measured after bequest tax revenues have come in at the beginning of the period
		tottaxbw=DOT_PRODUCT(invm,vectaxbw)*(1.0-pold)
		tottaxbe=DOT_PRODUCT(invm,vectaxbe)*(1.0-pold)
		beq2gdp=DOT_PRODUCT(invm,vecbeq)*(1.0-pold)/gdp 
		
		CALL printinvdistr()
			
		IF (dototincw==1) THEN
			totincw=DOT_PRODUCT(invm,vectotincw)/(1.0-totentr)
		END IF
		we2yw=DOT_PRODUCT(invm,vecwe2yw)/totL
		we2ye=DOT_PRODUCT(invm,vecwe2ye)/totentr
		nentr=count(whoise==1)
		
		ALLOCATE (vecwe2yeonly(nentr),invmeonly(nentr))
		
		vecwe2yeonly=PACK(vecwe2ye,mask=whoise==1)
		invmeonly=PACK(invm,mask=whoise==1)
        
		CALL quantilweighted(vecwe2yeonly,invmeonly/sum(invmeonly),DBLE(0.5),we2yemedian)
		
		DEALLOCATE (vecwe2yeonly,invmeonly)
		nywork=count(whoise==0)
		ALLOCATE (vecwe2ywonly(nywork),invmywonly(nywork))
		vecwe2ywonly=pack(vecwe2yw,mask=whoise==0)
		invmywonly=pack(invm,mask=whoise==0)
		CALL quantilweighted(vecwe2ywonly,invmywonly/sum(invmywonly),DBLE(0.5),we2ywmedian)
		DEALLOCATE (vecwe2ywonly,invmywonly)
		call quantilweighted(vecwe2yw,invm/totL,DBLE(0.5),we2ywmedian)
		call quantilweighted(vecwe2ye,invm/totentr,DBLE(0.5),we2yemedian)

		govbal=tottaxl+tottaxe+tottaxcw+tottaxce+tottaxbw+tottaxbe- &
        & gfrac*gdp-ibar*govdebt-transf*totret
        
        WRITE(*,*) "GOVBAL COMPUTED"
        
		govbal2gdp=govbal/gdp
		epsigov=MIN(ABS(govbal2gdp), ABS(taubalmax-taubalmin)*10.0)
		WRITE (*,*) "finished computing govt bc ", "iteragov=", iteragov," iterar= ",iterar	
		WRITE (*,*) "taubalmin=",taubalmin," taubalmax=",taubalmax, "  taubal=",taubal
		WRITE (*,*) "rbar=",rbar,"rbarmin=", rbarmin,"   rbarmax=",rbarmax, "ibar=", ibar	
		WRITE (*,*) "govbal", govbal, "govbal2gdp=",govbal2gdp 
		WRITE (*,*) "govbal2gdpmin=",govbal2gdpmin," govbal2gdpmax=",govbal2gdpmax
	    WRITE (*,*)  "k2gdp=",k2gdp,"	gdp=", gdp	
        WRITE (*,*) "tota=",tota,"   totkcorp=",totkcorp
        WRITE (*,*) "totayw=",totayw,"  totaye=",totaye
        WRITE (*,*) "totaow=",totaow,"  totaoe=",totaoe
		WRITE (*,*) "toteffl=", toteffl,"	hiredlabe=", hiredlabe, "	totkcorp=", totkcorp
        WRITE (*,*) "**********************"
        WRITE (*,*) " "				

		fname="output"
		OPEN (unit=32,file=fname,status="OLD", &
		&       action="write",position="append",iostat=OpenStatus)
		IF (epsigov.LT.epsigovmin) THEN	
			WRITE (unit=32,fmt=*) "reached convergence govt loop"
		END IF
       	WRITE (unit=32, fmt=*) "***********************************"
        WRITE (unit=32, fmt=*) "results for: iterar= ",iterar," iteragov", iteragov	
		WRITE (unit=32, fmt=*) "taubal=",taubal
		WRITE (unit=32, fmt=*) "taubalmin=",taubalmin," taubalmax=",taubalmax
		WRITE (unit=32, fmt=*) "rbar=",rbar, "  rimplied=", rimplied, "ibar=", ibar
		WRITE (unit=32, fmt=*) "rbarmin=", rbarmin,"   rbarmax=",rbarmax
		WRITE (unit=32, fmt=*) "wage=", wage,"   wageimplied=",wageimplied   
		WRITE (unit=32, fmt=*) "govbal", govbal, "  govbal2gdp=",govbal2gdp 
		WRITE (unit=32, fmt=*) "govbal2gdpmin=",govbal2gdpmin," govbal2gdpmax=",govbal2gdpmax
	    WRITE (unit=32, fmt=*)  "k2gdp=",k2gdp,"	gdp=", gdp	
        WRITE (unit=32, fmt=*) "tota=",tota,"   totkcorp=",totkcorp
		WRITE (unit=32, fmt=*) "toteffl=", toteffl,"	hiredlabe=", hiredlabe, "	totkcorp=", totkcorp
        WRITE (unit=32, fmt=*) "totayw=",totayw,"  totaye=",totaye
        WRITE (unit=32, fmt=*) "totaow=",totaow,"  totaoe=",totaoe
		WRITE (unit=32, fmt=*) "tottaxl=",tottaxl,"tottaxe=",tottaxe
        WRITE (unit=32, fmt=*) "tottaxcw=",tottaxcw,"totaxce=",tottaxce
        WRITE (unit=32, fmt=*) "totaxbe=",tottaxbe,"totaxbw=",tottaxbw
        WRITE (unit=32, fmt=*) "totincw=",totincw,"(previous govbal)",govbal
		WRITE (unit=32,fmt=*) "we2yw=",we2yw,"   we2ye=",we2ye
		WRITE (unit=32,fmt=*) "we2ywmedian=",we2ywmedian,"   we2yemedian=",we2yemedian        
        WRITE (unit=32, fmt=*) "**********************"
        WRITE (unit=32, fmt=*) " "				
        CLOSE (unit=32)
		
		IF (dogovloop==0) THEN
			epsigov=epsigovmin/2.0	
		ELSE    		
			IF (epsigov>epsigovmin) THEN
				!using bisection algorithm to update taubal
    			IF (bracketgov==1) THEN
					IF (govbal2gdp.GT.0.0) THEN
		   				WRITE (*,*) "***************************"
           				WRITE (*,*) "taubalmin gives a positive govbal2gdp="	   		
						WRITE (*,*) "trying another taubalmin"
           				WRITE (*,*) "***************************"
           				fname="output"
           				OPEN (unit=32,file=fname,status="OLD", &
			 			&   action="write",position="append",iostat=OpenStatus)
		   				WRITE (unit=32,fmt=*) "***************************"
           				WRITE (unit=32,fmt=*) "taubalmin gives a positive govbal2gdp="		   		
						WRITE (unit=32,fmt=*) "trying another taubalmin"
           				WRITE (unit=32,fmt=*) "***************************"
           				CLOSE (unit=32)             
           				noneedtaubalmax=1 ! switch: note that we computed taubalmax 
						! in this case
           				govbal2gdpmax=govbal2gdp
           				taubalmax=taubalmin
           				taubalmin=taubalmin-pertgov
						! note bracketgov still ==1
					ELSE
						govbal2gdpmin=govbal2gdp
       					bracketgov=2
					END IF  
					! if we have computed taubalmax first (because we made a mistake
					! and govbal >0 for initial taubalmin), then, once computed a true
					! taubalmin (govbal<0), start bisection (bracketr=0)
        			IF ((govbal2gdp.LE.0.0).AND.(noneedtaubalmax==1)) THEN
						bracketgov=0
        			END IF      
				ELSE IF (bracketgov==2) THEN
        			IF (govbal2gdp.LT.0.0) THEN
						WRITE (*,*) "***************************"
						WRITE (*,*) "taubalmax gives a negative govbal2gdp="
            			WRITE (*,*) "trying another taubalmax"
						WRITE (*,*) "***************************"
            			fname="output"
            			OPEN (unit=32,file=fname,status="OLD", &
                		&   action="write",position="append",iostat=OpenStatus)
 						WRITE (unit=32,fmt=*) "***************************"
						WRITE (unit=32,fmt=*) "taubalmax gives a negative govbal2gdp="
            			WRITE (unit=32,fmt=*) "trying another taubalmax"
						WRITE (unit=32,fmt=*) "***************************"
						CLOSE (unit=32)
            			bracketgov=2 ! still looking for a taubalmax (govbal>0)
            			taubalmin=taubalmax
            			taubalmax=taubalmax+pertgov
						govbal2gdpmin=govbal2gdp
       				ELSE
						govbal2gdpmax=govbal2gdp
        			    bracketgov=0 ! bracketgov=0: computed BOTH taubalmin and taubalmax 
	       			END IF
    			ELSE
        			! convergence criterion 
        			IF (govbal2gdp.GT.0.0) THEN
		    			taubalmax=taubal
            			govbal2gdpmax=govbal2gdp
        			ELSE
            			taubalmin=taubal
            			govbal2gdpmin=govbal2gdp
        			END IF
    			END IF
			END IF 
		END IF
		
		
		fundiffnow=rbar-rimplied
        ! convergence criterion 
		IF (bracketr==1.OR.bracketr==21.OR.bracketr==22) THEN 
			epsir=ABS(fundiffnow)
		ELSE
			epsir=min(ABS(fundiffnow),ABS(rbarmax-rbarmin))
		END IF
        
		! keep track of following for each rbar, taubal computed
		taubalvec(iteratot)=taubal
		imbalvec(iteratot)=govbal2gdp
		govbalvec(iteratot)=govbal
		gdpvec(iteratot)=gdp
		funrbar(iteratot)=rbar
		fundiff(iteratot)=fundiffnow
		funtota(iteratot)=tota
		funtotk(iteratot)=totk
				
		iteragov=iteragov+1				
		iteratot=iteratot+1

		CALL printwe2inc()
		CALL printtotgov()
		CALL printtotfun()
		CALL quantilweighted(vecwe2yw,invm/totL,DBLE(0.5),we2ywmedian)
		CALL quantilweighted(vecwe2ye,invm/totentr,DBLE(0.5),we2yemedian)
		CALL printbc()
	END DO !end government budget loop

	fname="output"
	OPEN (unit=32,file=fname,status="OLD", &
		&       action="write",position="append",iostat=OpenStatus)
	WRITE (unit=32, fmt=*) "***********************************"
	WRITE (unit=32, fmt=*) "completed loop for rbar iterar=",iterar,"  iteragov=",iteragov-1
	WRITE (unit=32, fmt=*) "rimplied",rimplied, "   rbar",rbar,"ibar=", ibar
	WRITE (unit=32, fmt=*) "rbarmin",rbarmin, "   rbarmax",rbarmax
	WRITE (unit=32, fmt=*) "toteffl=", toteffl,"	hiredlabe=", hiredlabe, "	totkcorp=", totkcorp
	WRITE (unit=32, fmt=*) "wageimplied=",wageimplied 
	WRITE (unit=32, fmt=*) "fundiffnow=",fundiffnow
	WRITE (unit=32, fmt=*) "fundiffmin=", fundiffmin,"fundiffmax=",fundiffmax
	WRITE (unit=32, fmt=*) " "
	CLOSE (unit=32)
	
	WRITE (*,*) "completed loop for rbar iterar=",iterar,"  iteragov=",iteragov-1
	WRITE (*,*) "rimplied",rimplied, "   rbar",rbar,"ibar=", ibar
	WRITE (*,*) "rbarmin",rbarmin, "   rbarmax",rbarmax
	WRITE (*,*) "toteffl=", toteffl,"	hiredlabe=", hiredlabe, "	totkcorp=", totkcorp
	WRITE (*,*) "wageimplied=",wageimplied 
	WRITE (*,*) "fundiffnow=",fundiffnow
	WRITE (*,*) "fundiffmin=", fundiffmin,"fundiffmax=",fundiffmax

	IF (dorloop==0) THEN
		epsir=epsirmin/2.0
		! define following only for output purposes in case we do not do rloop
		rbarmin=0.0001
		rbarmax=.20
		fundiffmin=-20.0
		fundiffmax=20.0
	ELSE  	
		! using bisection algorithm to update rbar
	    ! bisection algorithm	 
		IF (epsir>epsirmin) THEN    
			IF (bracketr==1) THEN			
				IF (fundiffnow.GT.0.0) THEN
					bracketr=22
					rbarmax=rbar
					fundiffmax=fundiffnow
					! make sure that the algorithm does not use a crazy rimplied 
					! for computations, if it is, use a relaxation criterion
					IF (ABS(rbar-rimplied).LE. radjust) THEN
						rbar=rimplied
					ELSE 
						rbar=rweight*rbar+(1.0-rweight)*rimplied
					END IF
					ibar=rbar-phi
					! define new bounds for taubal
					! if previously found rbarmax and look for rbarmin, use previous eqm taubal as taubalmax
					IF (dogovloop==1) THEN
						taubalmin=taubal-pertgov
						taubalmax=taubal+0.0001	
						taubalrbarmax=taubal
					END IF
				ELSE
					bracketr=21
					rbarmin=MAX(rbar,0.00001)
					fundiffmin=fundiffnow
					! make sure that the algorithm does not use a crazy rimplied 
					! for computations, if it is, use a relaxation criterion
					IF (ABS(rbar-rimplied).LE. radjust) THEN
						rbar=MAX(rimplied, 0.000012)
					ELSE 
						rbar=MAX(rweight*rbar+(1.0-rweight)*rimplied, 0.000012)
					END IF
					ibar=rbar-phi
					IF (dogovloop==1) THEN
						! define new bounds for taubal	
						! if previously found rbarmin and look for rbarmax, use previous eqm taubal as taubalmin
						taubalmax=taubal+pertgov
						taubalmin=taubal-0.0001
						taubalrbarmin=taubal
					END IF
				END IF  
			ELSE IF (bracketr==21) THEN
				! if we previously found rbarmin
				IF (fundiffnow.GT.0.0) THEN
					! and now we find rbarmax
					rbarmax=rbar
					fundiffmax=fundiffnow
					bracketr=0 ! start bisection
					!this should be the zero for the linear interpolation
					rbar=rbarmin-(rbarmax-rbarmin)*fundiffmin/(fundiffmax-fundiffmin)
					ibar=rbar-phi
					IF (dogovloop==1) THEN
						! define new bounds for taubal	
						! if previously found rbarmax and look for rbarmin, use previous eqm taubal as taubalmax
						taubalrbarmax=taubal
						taubalinterp=taubalrbarmin+(taubalrbarmax-taubalrbarmin)* &
						&(rbar-rbarmin)/(rbarmax-rbarmin)
						taubalmin=taubalinterp-tbalwidth*ABS(taubalrbarmax-taubalrbarmin)
						taubalmax=taubalinterp+tbalwidth*ABS(taubalrbarmax-taubalrbarmin)
					END IF
				ELSE 
					! if there is a problem and find new rbarmin and no rbarmax yet
					rbarmin=rbar
					fundiffmin=fundiffnow
					rbar=rbarmin+0.005
					ibar=rbar-phi
					IF (dogovloop==1) THEN
						! define new bounds for taubal	
						! if previously found rbarmax and look for rbarmin, use previous eqm taubal as taubalmax
						taubalmax=taubal+pertgov
						taubalmin=taubal-0.0001
						taubalrbarmin=taubal
					END IF
				END IF
			ELSE IF (bracketr==22) THEN
				! if we previoulsy found rbarmax
				IF (fundiffnow.LT.0.0) THEN	!found min
					rbarmin=rbar
					fundiffmin=fundiffnow
					bracketr=0 ! start bisection
					!this should be the zero for the linear interpolation
				    rbar=rbarmin-(rbarmax-rbarmin)*fundiffmin/(fundiffmax-fundiffmin)
					ibar=rbar-phi
					IF (dogovloop==1) THEN
						! define new bounds for taubal	
						! if previously found rbarmax and look for rbarmin, use previous eqm taubal as taubalmax
						taubalrbarmin=taubal
						taubalinterp=taubalrbarmin+(taubalrbarmax-taubalrbarmin)* &
						&(rbar-rbarmin)/(rbarmax-rbarmin)
						taubalmin=taubalinterp-tbalwidth*ABS(taubalrbarmax-taubalrbarmin)
						taubalmax=taubalinterp+tbalwidth*ABS(taubalrbarmax-taubalrbarmin)
					END IF
				ELSE 
					! if there a problem and find new rbarmax and no rbarmin yet
					rbarmax=rbar
					fundiffmax=fundiffnow
					rbar=rbarmax-0.005
					ibar=rbar-phi
					IF (dogovloop==1) THEN
						! define new bounds for taubal	
						! if previously found rbarmax and look for rbarmin, use previous eqm taubal as taubalmax
						taubalmin=taubal-pertgov
						taubalmax=taubal+0.0001
						taubalrbarmin=taubal
					END IF
				END IF
			ELSE	! if have bounds
				IF (fundiffnow.GT.0.0) THEN
					rbarmax=rbar
					fundiffmax=fundiffnow
					!this should be the zero for the linear interpolation
				    rbar=rbarmin-(rbarmax-rbarmin)*fundiffmin/(fundiffmax-fundiffmin)
					ibar=rbar-phi
					IF (dogovloop==1) THEN
						! define new bounds for taubal	
						! if previously found rbarmax and look for rbarmin, use previous eqm taubal as taubalmax
						taubalrbarmax=taubal
						taubalinterp=taubalrbarmin+(taubalrbarmax-taubalrbarmin)* &
						&(rbar-rbarmin)/(rbarmax-rbarmin)
						taubalmin=taubalinterp-tbalwidth*ABS(taubalrbarmax-taubalrbarmin)
						taubalmax=taubalinterp+tbalwidth*ABS(taubalrbarmax-taubalrbarmin)
					END IF
				ELSE
					rbarmin=rbar
					fundiffmin=fundiffnow
					!this should be the zero for the linear interpolation
				    rbar=rbarmin-(rbarmax-rbarmin)*fundiffmin/(fundiffmax-fundiffmin)
					ibar=rbar-phi
					IF (dogovloop==1) THEN
						! define new bounds for taubal	
						! if previously found rbarmax and look for rbarmin, use previous eqm taubal as taubalmax
						taubalrbarmin=taubal
						taubalinterp=taubalrbarmin+(taubalrbarmax-taubalrbarmin)* &
						&(rbar-rbarmin)/(rbarmax-rbarmin)
						taubalmin=taubalinterp-tbalwidth*ABS(taubalrbarmax-taubalrbarmin)
						taubalmax=taubalinterp+tbalwidth*ABS(taubalrbarmax-taubalrbarmin)
					END IF	
				END IF
			END IF
		END IF 
	END IF
    CALL printtotfun()
    iterar=iterar+1
    WRITE(*,*) "iterar on rbar",iterar
END DO      !end do while for rbar


! now compute consumption and income distributions
conspoly=0.0    ! consumption of young
conspolow=0.0   ! consumption of old w
conspoloe=0.0	! consumption of old entr
grossincow=0.0		! gross income old w
grossincoe=0.0		! gross income old e
grossincy=0.0		! gross income young
netincow=0.0		! net income old w
netincoe=0.0		! net income old e
netincy=0.0			! net income young

! old workers
DO i=1,da ! today's assets
	ytaxo=transf+ibar*a(i)
	grossincow(i)=ytaxo
	IF (switchlabsupproptax==0) THEN
        taxo=(btaxw-btaxw*(staxw*ytaxo**ptaxw+1.0)**(-1.0/ptaxw))*ytaxo+taubal*ytaxo
    ELSE
        taxo=taubal*ytaxo
    END IF
	netincow(i)=grossincow(i)-taxo-tauls
    conspolow(i)=(a(i)*(1.0+ibar)+transf-a(apolow(i))-tauls-taxo)/(1.0+tauc)
	IF (conspolow(i).LE.0.0) THEN
		WRITE(*,*) 'WARNING RETIRED HAVE NEGATIVE CONSUMPTION'
		!STOP
	END IF
END DO
! consumption policy for old who remain entr this period
DO i=1,da           ! today's assets
	DO j=1,dr       ! today's r
		IF (kpoloe(i,j).GT.0) THEN ! if decide to stay entrepreneurs
			khere=k(kpoloe(i,j))
			lhere=labpoloe(i,j)
			! Note that entinchere (which is an optimal choice) cannot be negative if ibar>0, since there is always the option of running a size 0 firm
            entinchere=r(j)*(khere**alphe*(1.0+lhere)**(1.0-alphe))**ni-delt*khere-rbar*max(0.0,khere-a(i))+ ibar*max(0.0,a(i)-khere)-wage*lhere
            IF (switchlabsupproptax==0) THEN
                taxehere=(btaxe-btaxe*(staxe*entinchere**ptaxe+1.0)**(-1.0/ptaxe))*entinchere+taubal*entinchere
			ELSE
			    taxehere=taubal*entinchere 
			END IF
            grossincoe(i,j)=entinchere
			netincoe(i,j)=entinchere-taxehere-tauls
			conspoloe(i,j)=(entinchere-taxehere+a(i)-a(apoloe(i,j))-tauls)/(1.0+tauc)
		ELSE ! if they decide to become workers		
			ytaxo=transf+ibar*a(i)
			grossincow(i)=ytaxo
            IF (switchlabsupproptax==0) THEN
                taxo=(btaxw-btaxw*(staxw*ytaxo**ptaxw+1.0)**(-1.0/ptaxw))*ytaxo+taubal*ytaxo
            ELSE
                taxo=taubal*ytaxo
            END IF			
             taxo=(btaxw-btaxw*(staxw*ytaxo**ptaxw+1.0)**(-1.0/ptaxw))*ytaxo+taubal*ytaxo
			netincow(i)=grossincow(i)-taxo-tauls
            conspoloe(i,j)=(a(i)*(1.0+ibar)+transf-a(apolow(i))-tauls-taxo)/(1.0+tauc)
		END IF
		IF (conspoloe(i,j).LE.0.0) THEN
		WRITE(*,*) 'WARNING OLD E HAVE NEGATIVE CONSUMPTION'
				!STOP
		END IF
	END DO  
END DO
! young 
DO i=1,da ! today
	DO j=1,dy ! today's y       
		DO jj=1,dr
			IF (kpoly(i,j,jj).GT.0) THEN
				khere=k(kpoly(i,j,jj))
				lhere=labpoly(i,j,jj)
    			! Note that entinchere (which is an optimal choice) cannot be negative if ibar>0, since there is always the option of running a size 0 firm
				entinchere=r(jj)*(khere**alphe*(1.0+lhere)**(1.0-alphe))**ni-delt*khere-rbar*max(0.0,khere-a(i))+ ibar*max(0.0,a(i)-khere)-wage*lhere
                IF (switchlabsupproptax==0) THEN
                    taxehere=(btaxe-btaxe*(staxe*entinchere**ptaxe+1.0)**(-1.0/ptaxe))*entinchere+taubal*entinchere
			    ELSE
			        taxehere=taubal*entinchere 
			    END IF				
			    grossincy(i,j,jj)=entinchere
				netincy(i,j,jj)=entinchere-taxehere-tauls
				conspoly(i,j,jj)=(entinchere-taxehere+a(i)-a(apoly(i,j,jj))-tauls)/(1.0+tauc)
				IF (conspoly(i,j,jj).LE.0.0) THEN
					WRITE(*,*) 'WARNING YOUNG E HAVE NEGATIVE CONSUMPTION'
					!STOP
				END IF
			ELSE	
                inchere=wage*y(j)*labsup+ibar*a(i) 
                IF (switchlabsupproptax==0) THEN
                    taxwhere=(btaxw-btaxw*(staxw*inchere**ptaxw+1.0)**(-1.0/ptaxw))*inchere+taubal*inchere
                ELSE
                    taxwhere=taubal*inchere
                END IF			               
    			grossincy(i,j,jj)=inchere
				netincy(i,j,jj)=inchere-taxwhere-tauls
                conspoly(i,j,jj)=((1.0+ibar)*a(i)+wage*y(j)*labsup-taxwhere-a(apoly(i,j,jj))-tauls)/(1.0+tauc)
				IF (conspoly(i,j,jj).LE.0.0) THEN
					WRITE(*,*) 'WARNING YOUNG W HAVE NEGATIVE CONSUMPTION'
				END IF
			END IF
        END DO
	END DO
END DO

CALL printvalfun()  

!saving transition matrix for young only
rowyoung=0
colyoung=0
valyoung=0.0
counter2=1
DO i=1,(2*(dy*dr+dr+1)*nyoung) ! all starting young
	IF (colM(i).LE.(2*nyoung)) THEN ! and stay young
		rowyoung(counter2)=rowM(i)
		colyoung(counter2)=colM(i)
		valyoung(counter2)=valM(i)
		counter2=counter2+1
	END IF
END DO
IF ((counter2-1).NE.(2*nyoung*dy*dr)) THEN
	WRITE (*,*) 'ERROR: size young transition wrong'
	fname="output"
	OPEN (unit=32,file=fname,status="OLD", &
	&       action="write",position="append",iostat=OpenStatus)
    WRITE (unit=32, fmt=*) "***********************************"
	WRITE (unit=32, fmt=*) 'ERROR: size young transition wrong'
	WRITE (unit=32, fmt=*) "counter2=",counter2-1
	WRITE (unit=32, fmt=*) "2*nyoung*dr*dy=", 2*nyoung*dr*dy		
    WRITE (unit=32, fmt=*) "***********************************"
	CLOSE (unit=32)
END IF

CALL printmobyoung() 

CONTAINS


SUBROUTINE printmobyoung
fname="mobyoung"
! saving vectors to compute mobility for young
open (unit=32,file=fname,status="replace", &
&       action="WRITE",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
DO i=1,(2*nyoung*dr*dy)
	WRITE (unit=32, fmt=*) rowyoung(i)
END DO
DO i=1,(2*nyoung*dr*dy)
	WRITE (unit=32, fmt=*) colyoung(i)
END DO
DO i=1,(2*nyoung*dr*dy)
	WRITE (unit=32, fmt=*) valyoung(i)
END DO
CLOSE (unit=32)
END SUBROUTINE printmobyoung

SUBROUTINE printbc
fname="exobc"
! saving borrowing constraints
open (unit=32,file=fname,status="replace", &
&       action="WRITE",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
DO i=1,da
	DO j=1,dy
		DO jj=1,dr
			WRITE (unit=32, fmt=*) kyhat(i,j,jj)
		END DO
	END DO
END DO
DO i=1,da
	DO jj=1,dr
		WRITE (unit=32, fmt=*) kohat(i,jj)
	END DO
END DO
CLOSE (unit=32)
END SUBROUTINE printBC


SUBROUTINE printvalfun
fname="valfun"
! saving value functions
open (unit=32,file=fname,status="replace", &
&       action="WRITE",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
WRITE(unit=32,fmt=*) da
WRITE(unit=32,fmt=*) dy
WRITE(unit=32,fmt=*) dr
WRITE(unit=32,fmt=*) dk
DO i=1,da
    WRITE(unit=32,fmt=*) a(i)
END DO
DO i=1,dy 
    WRITE(unit=32,fmt=*) y(i)
END DO
DO i=1,dr
    WRITE(unit=32,fmt=*) r(i)
END DO
DO i=1,dk
    WRITE(unit=32,fmt=*) k(i)
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) Vy(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) Vyw(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) Vye(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) Vow(i)
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) Voe(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) Voee(i,jj)
    END DO
END DO
DO i=1,dk
    WRITE(unit=32,fmt=*) Vokeff(i)
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) apoly(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) kpoly(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) apolye(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) kpolye(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) apolyw(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) apolow(i)
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) apolownet(i)
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) apoloe(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) apoloenet(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) kpoloe(i,jj)
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) kyhat(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) kohat(i,jj)
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) labpoly(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) labpoloe(i,jj)
    END DO
END DO
WRITE(unit=32,fmt=*) delt
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) conspoly(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) netincy(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    DO j=1,dy
        DO jj=1,dr
            WRITE(unit=32,fmt=*) grossincy(i,j,jj)
        END DO
    END DO
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) conspolow(i)
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) netincow(i)
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) grossincow(i)
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) conspoloe(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) netincoe(i,jj)
    END DO
END DO
DO i=1,da
    DO jj=1,dr
        WRITE(unit=32,fmt=*) grossincoe(i,jj)
    END DO
END DO
CLOSE (unit=32)
END SUBROUTINE printvalfun

SUBROUTINE printinvdistr
fname="invdistr"
! saving invariant distr
open (unit=32,file=fname,status="replace", &
&       action="WRITE",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
WRITE(unit=32,fmt=*) nstates
WRITE(unit=32,fmt=*) nyoung
WRITE(unit=32,fmt=*) noe
DO i=1,nstates
    WRITE(unit=32,fmt=*) invm(i)
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) prgrid(i)
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) prgridyw(i)
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) prgridye(i)
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) prgridoe(i)
END DO
DO i=1,da
    WRITE(unit=32,fmt=*) prgridow(i)
END DO
WRITE(unit=32,fmt=*) tota
WRITE(unit=32,fmt=*) totk
WRITE(unit=32,fmt=*) inck
DO i=1,(nstates-da) 
    WRITE(unit=32,fmt=*) invlevk(i)
END DO  
DO i=1,(nstates-da) 
    WRITE(unit=32,fmt=*) invpolk(i)
END DO  
DO i=1,(nstates-da)
    WRITE(unit=32,fmt=*) invrk(i)
END DO
WRITE(unit=32,fmt=*) k2gdp
WRITE(unit=32,fmt=*) ykshare
WRITE(unit=32,fmt=*) rbar
DO i=1,dr
    WRITE(unit=32,fmt=*) invr(i)
END DO
WRITE(unit=32,fmt=*) totke
WRITE(unit=32,fmt=*) bet
WRITE(unit=32,fmt=*) gam
WRITE(unit=32,fmt=*) eff
WRITE(unit=32,fmt=*) eta
WRITE(unit=32,fmt=*) ni
WRITE(unit=32,fmt=*) propewswitch
WRITE(unit=32,fmt=*) propweswitch
WRITE(unit=32,fmt=*) alph
DO i=1,dy
    WRITE(unit=32,fmt=*) invy(i)
END DO
DO i=1,dr
    DO j=1,dr
        WRITE(unit=32,fmt=*) Pr(i,j)
    END DO
END DO
WRITE(unit=32,fmt=*) yktotsh
WRITE(unit=32,fmt=*) totentr 
WRITE(unit=32,fmt=*) totret
WRITE(unit=32,fmt=*) totL
WRITE(unit=32,fmt=*) wage
WRITE(unit=32,fmt=*) beq2gdp
WRITE(unit=32,fmt=*) totkborr
WRITE(unit=32,fmt=*) totyshe
WRITE(unit=32,fmt=*) toteffL
WRITE(unit=32,fmt=*) totlcorp
WRITE(unit=32,fmt=*) hiredlabe
DO i=1,(2*nyoung)
    WRITE(unit=32,fmt=*) invtotlabye(i)
END DO
DO i=1,noe
    WRITE(unit=32,fmt=*) invtotlaboe(i)
END DO
WRITE(unit=32,fmt=*) alphe
WRITE(unit=32,fmt=*) phi
WRITE(unit=32,fmt=*) xi
WRITE(unit=32,fmt=*) ibar
! matlab read
WRITE(unit=32,fmt=*) totkcorp
WRITE(unit=32,fmt=*) totkgrossborr
WRITE(unit=32,fmt=*) labsup
WRITE(unit=32,fmt=*) capintermed
! matlab
CLOSE (unit=32)
END SUBROUTINE printinvdistr

SUBROUTINE printtotfun()
fname="funtot"
! saving tots
open (unit=32,file=fname,status="replace", &
&       action="WRITE",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
DO i=1,iteratot
    WRITE(unit=32,fmt=*) fundiff(i)
END DO
DO i=1,iteratot
    WRITE(unit=32,fmt=*) funtota(i)
END DO
DO i=1,iteratot
    WRITE(unit=32,fmt=*) funtotk(i)
END DO
DO i=1,iteratot
    WRITE(unit=32,fmt=*) funrbar(i)
END DO
DO i=1,iteratot
    WRITE(unit=32,fmt=*) taubalvec(i)
END DO
DO i=1,iteratot
    WRITE(unit=32,fmt=*) imbalvec(i)
END DO
DO i=1,iteratot
    WRITE(unit=32,fmt=*) govbalvec(i)
END DO
DO i=1,iteratot
    WRITE(unit=32,fmt=*) gdpvec(i)
END DO
CLOSE(unit=32)
END SUBROUTINE printtotfun

SUBROUTINE printwe2inc()
fname="we2inc"
! saving tots
open (unit=32,file=fname,status="replace", &
&       action="WRITE",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
WRITE(unit=32,fmt=*) we2ye
WRITE(unit=32,fmt=*) we2yw
CLOSE(unit=32)
END SUBROUTINE printwe2inc

SUBROUTINE printtotgov()
fname="govtax"
! saving totals for government
open (unit=32,file=fname,status="replace", &
&       action="WRITE",position="rewind",iostat=OpenStatus)
IF (OpenStatus.NE.0) THEN
    WRITE(*,*) 'problems opening ', fname
END IF
WRITE(unit=32,fmt=*)    gdp
WRITE(unit=32,fmt=*)    govdebt
WRITE(unit=32,fmt=*)    transf
WRITE(unit=32,fmt=*)    gfrac
WRITE(unit=32,fmt=*)	debtfrac
WRITE(unit=32,fmt=*)    tottaxl
WRITE(unit=32,fmt=*)    tottaxe
WRITE(unit=32,fmt=*)    obsolete
WRITE(unit=32,fmt=*)    tottaxcw
WRITE(unit=32,fmt=*)    tottaxce
WRITE(unit=32,fmt=*)    tottaxbw
WRITE(unit=32,fmt=*)    tottaxbe    
WRITE(unit=32,fmt=*)    govbal
WRITE(unit=32,fmt=*)    taubal
WRITE(unit=32,fmt=*)	btaxw
WRITE(unit=32,fmt=*)	staxw
WRITE(unit=32,fmt=*)	ptaxw
WRITE(unit=32,fmt=*)	staxwbase
WRITE(unit=32,fmt=*)	totincw
WRITE(unit=32,fmt=*)	btaxe
WRITE(unit=32,fmt=*)	staxe
WRITE(unit=32,fmt=*)	ptaxe
WRITE(unit=32,fmt=*)	staxebase
WRITE(unit=32,fmt=*)	totincw
WRITE(unit=32,fmt=*)	tauc
WRITE(unit=32,fmt=*)	obsolete
WRITE(unit=32,fmt=*)	tauls
WRITE(unit=32,fmt=*)	exem
WRITE(unit=32,fmt=*)	taub
CLOSE(unit=32)
END SUBROUTINE printtotgov


SUBROUTINE checksumrowM()
sumrowM=0.0
DO i=1,sizeM
    DO j=1,nonzero
    IF (rowM(j)==i) THEN
        sumrowM(i)=sumrowM(i)+valM(j)
    END IF
    END DO
    IF (ABS(sumrowM(i)-1).GE.1e-5) THEN
        WRITE (*,*) "sum of row",i," equals",sumrowM(i)
    END IF
END DO
END SUBROUTINE checksumrowM

SUBROUTINE checkcolM(posiz)
IMPLICIT NONE
INTEGER, INTENT(IN) :: posiz
CHARACTER(10) :: fname3

fname3='indcolM'
IF (colM(counter).GT.nstates) THEN
    open (unit=32,file=fname3,status="OLD", &
    &       action="READWRITE",position="APPEND",iostat=OpenStatus)
    IF (OpenStatus.NE.0) THEN
        WRITE(*,*) 'problems opening ', fname3
    END IF
    WRITE(unit=32,fmt=*) posiz,l,j,i,ll,jj,counter,apoly(i,j,l)
    CLOSE (unit=32)
END IF
END SUBROUTINE checkcolM


END PROGRAM credit
!******************************************

SUBROUTINE linspace(xmin,xmax,npoints,lspace)
IMPLICIT NONE
DOUBLE PRECISION, INTENT(IN) :: xmin,xmax
INTEGER, INTENT(IN) :: npoints
DOUBLE PRECISION, DIMENSION(npoints), INTENT(OUT) :: lspace
INTEGER :: i
lspace=DBLE( (/ (i,i=0,npoints-1) /) )/DBLE(npoints-1)*(xmax-xmin)+xmin
END SUBROUTINE linspace

SUBROUTINE  interplin(l,x,y,n,z,v)
! interpolate, from values of the fn given as ordinates of
! input data points in an x-y plane and for a given set of
! x values (abscissas), the values of a single-valued fn y=f(x)
! input parameters are
!     l  = # of data points (2 or greater)
!     x  = array of dimension l storing the x values (abscissas)
!          of input data points (in ascending order)
!     y  = array of dimension l storing the y values (ordinates)
!          of input data points
!     n  = # of points at which interpolation of the y value (ordinate)
!          (ordinate) is needed (1 or greater)
!     z  = array of dimension n storing the x values (abscissas) of
!          desired points
! output parameter
!     v  = array of dimension n where the interpolated y values
!          (ordinates) are to be displayed
IMPLICIT NONE

INTEGER, INTENT(IN) :: l
INTEGER, INTENT(IN) :: n
DOUBLE PRECISION, DIMENSION(l), INTENT(IN) :: x
DOUBLE PRECISION, DIMENSION(l), INTENT(IN) :: y
DOUBLE PRECISION, DIMENSION(n), INTENT(IN) :: z
DOUBLE PRECISION, DIMENSION(n), INTENT(OUT) :: v

INTEGER :: i,ind
INTEGER, DIMENSION(1) :: k
DOUBLE PRECISION :: diff

DO i=1,n
    k=MAXLOC(-ABS(z(i)-x))
    ind=k(1)
    diff=z(i)-x(ind)
    IF (abs(diff)<1e-04) THEN
        v(i)=y(ind)
    ELSE
        IF (diff<0) THEN
            v(i)=y(ind-1)+(z(i)-x(ind-1))/(x(ind)-x(ind-1))&
                     & *(y(ind)-y(ind-1))
        ELSE
            v(i)=y(ind)+(z(i)-x(ind))/(x(ind+1)-x(ind))*(y(ind+1)-y(ind))
        END IF
    END IF
END DO ! DO i=1,n
END SUBROUTINE interplin

SUBROUTINE checkrow1 (A,dA)
IMPLICIT NONE
DOUBLE PRECISION, DIMENSION(:,:), INTENT(IN) :: A
INTEGER, INTENT(IN) :: dA
INTEGER :: i
DO i=1,dA
        IF ( ABS(sum(A(i,:))-1).GT.1e-6 ) THEN
                WRITE (*,*) "row",i," of matrix doesn't sum to 1"
        END IF
END DO
END SUBROUTINE checkrow1

SUBROUTINE quantilweighted (series,weights,qprop,quant)

!USE numerical_libraries
include 'link_fnl_shared.h'

IMPLICIT NONE
DOUBLE PRECISION, DIMENSION(:), INTENT(IN) :: series,weights
DOUBLE PRECISION, INTENT(IN) :: qprop
DOUBLE PRECISION, INTENT(OUT) :: quant
DOUBLE PRECISION, ALLOCATABLE, DIMENSION(:)  :: seriesord,weightord,csum
INTEGER, ALLOCATABLE, DIMENSION(:) :: iperm
INTEGER :: lvec,i,j,cuth
INTEGER, DIMENSION(1) :: cuthp
DOUBLE PRECISION :: wt

!CHARACTER(20) :: fname
!INTEGER :: OpenStatus 

! first, we need to order series, in ascending order
!  seriesord and the corresponding weightord
! then we construct the cumulative sum of weights csum
lvec=size(series)
allocate(seriesord(lvec),iperm(lvec),csum(lvec),weightord(lvec))
iperm= (/ (j, j=1,lvec) /)

!the following reorders the series and outputs iperm, the vector of indices shifted
CALL svrgp (lvec,series,seriesord,iperm)
!fname="sort"
!OPEN (unit=32,file=fname,status="replace", &
!&       action="write",position="rewind",iostat=OpenStatus)
!IF (OpenStatus.NE.0) THEN
!    WRITE (*,*) 'problems opening ', fname
!END IF
!write(unit=32,fmt=*) 'series', series
!write(unit=32,fmt=*) '------------------------'
!write(unit=32,fmt=*) 'series ord', seriesord
!write(unit=32,fmt=*) '------------------------'
!write(unit=32,fmt=*) 'iperm', iperm
!CLOSE (unit=32)

!way in which csum is computed:
! suppose you have  s1  s2      s3      s4
! with weights      w1  w2      w3      w4
! the csum is:      c1  c2      c3      c4
! equal to      w1/2    c1+w1/2+w2/2    c2+w2/2+w3/2    c3+w3/2+w4/2
!
! ie for each point s, csum is equal to the pr<s plus 1/2 of the pr of being in
! that point. I don't remember exactly why i did it that way, with the interpolation
! suppose you have s1 s2 s3 with 1/3 1/3 1/3
! then csum is 1/6 1/2 5/6, so median q=.5 would give you s2 (as it should)
! if you have q=.75, it will give you a point between s2 s3, closer to s3.

DO i=1,lvec
    weightord(i)=weights(iperm(i))
END DO
csum(1)=weightord(1)/2
DO i=2,lvec
    csum(i)=csum(i-1)+weightord(i)/2+weightord(i-1)/2
END DO
!here we find where the required quantile falls
!this command picks the min of csum for those elements of csum that are greater than qprop
cuthp=minloc(csum,csum.GT.qprop)
cuth=cuthp(1)
if (cuth==1) then   ! if the required quantile is below the first, then set it to the first
    quant=series(1)
else if (qprop.GE.csum(lvec)) then  !above the last
    quant=seriesord(lvec)
else            ! interpolate between the closest gridpoints
    quant=seriesord(cuth-1)+(qprop-csum(cuth-1))/ &
    &   (csum(cuth)-csum(cuth-1))*(seriesord(cuth)-seriesord(cuth-1))
end if
END SUBROUTINE quantilweighted
