clear *
set more off
set mem 800m
set maxvar 10000

macro def confidence confinan conbus conclerg coneduc confed conlabor conpress conmedic contv conjudge consci conlegis conarmy 
macro def issp_confidence concong conbiz congovt conchurh concourt conschls
macro def controls age sex  degree madeg padeg wrkstat marital childs region relig  
macro def cuts ethnic childs babies preteen teens reg16 srcbelt
macro def indeps  
macro def other 
macro def attitudes life helpful fair trust anomia5 anomia6 anomia7 class finalter finrela getahead fear burglr robbry 
macro def varofinterest race year
macro def technical wtssall oversamp spanint wtgss id dateint
 
* Load data
use "remp7208.R3.dta" /* Not using the 2008 reinterviews of the 2006 sample; doing so would require weight wtnrcomb*/

* Set sample and weights
gen wtgss=wtssall*oversamp if spanint!=2  /* Full english-language sample; weighted to be representative of adult population; includes black over-samples (downweighted) */
* do "Family income.do"
keep $confidence $issp_confidence $controls $cuts $indeps $attitudes $varofinterest $technical $other
order $technical $confidence $controls $issp_confidence
drop wtssall

gen day=dateint-int(dateint/100)*100
replace day=1 if day==99
gen month=int(dateint/100)
gen dt=mdy(month, day, year)
replace dt=mdy(4,1,year) if dt==. /*Empty cells get average date=April Fools*/
drop day month
egen t_yr=tag(year)

* Merge in State, County and PSU identifiers: Note--this won't work unless you get the identifiers from the GSS yourself
sort year id
cap merge 1:1 year id using "..\Proprietary\gssgeocode_justin_wolfers"
gen str2 st=""
cap for ! in any AL AK AS AZ AR CA CO CT DE DC FL FM GA GU HI ID IL IN IA KS KY LA ME MH MD MA MI MN MS MO MT NE NV NH NJ NM NY NC ND MP OH OK OR PW PA PR RI SC SD TN TX UM UT VT VA VI WA WV WI WY \ ///
	@ in numlist 1 2 60 4 5 6 8 9 10 11 12 64 13 66 15 16 17 18 19 20 21 22 23 68 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 69 39 40 41 70 42 72 44 45 46 47 48 74 49 50 51 78 53 54 55 56: ///
	replace st="!" if fipsstat==@
for ! in any AL AK AS AZ AR CA CO CT DE DC FL FM GA GU HI ID IL IN IA KS KY LA ME MH MD MA MI MN MS MO MT NE NV NH NJ NM NY NC ND MP OH OK OR PW PA PR RI SC SD TN TX UM UT VT VA VI WA WV WI WY \ ///
	@ in numlist 1 2 60 4 5 6 8 9 10 11 12 64 13 66 15 16 17 18 19 20 21 22 23 68 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 69 39 40 41 70 42 72 44 45 46 47 48 74 49 50 51 78 53 54 55 56: ///
	label define statefips @ "!", add modify
cap gen fipsstat=.
label values fipsstat statefips	
cap drop _merge

label define reg9st 1 "MA CT VT NH RI ME" 2 "NY PA NH" 3 "OH MI IL WI IN" 4 "MO MN KS IA ND SD" 5 "FL NC VA GA MD SC WV DE DC" 6 "TN AL KY MS" 7 "TX LA OK AR" 8 "CO AZ ID WY MT UT NM" 9 "CA WA OR AK HI"
gen reg9st=region
la values reg9st reg9st

** Clean dependent variables: Confidence variables
fvset base frequent _all
label define confidence 1 "Hardly any" 2 "Only some" 3 "A great deal"
for X in varlist $confidence: recode X (1=3) (2=2) (3=1) \ label values X confidence
label define issp_confidence 1 "No confidence at all" 2 "Very little confidence" 3 "Some confidence" 4 "A great deal of confidence" 5 "Complete confidence"
for X in varlist $issp_confidence: replace X=6-X \ label values X issp_confidence
for X in varlist $confidence $issp_confidence: summ X [w=wtgss] \ gen X_z=(X-r(mean))/r(sd) 

* Clean controls
recode degree madeg padeg (8 9 98=.)
for var $controls : replace X=99 if X>=. 
gen age10=10*int(age/10)
replace relig=5 if relig>5 & relig<98

* Different cuts of the data
gen agegroup=1 if age>=18 & age<=29
replace agegroup=2 if age>=30 & age<=44
replace agegroup=3 if age>=45 & age<=59
replace agegroup=4 if age>=60 & age~=98
label define agegroup 1 "18 to 29 years" 2 "30 to 44 years" 3 "45 to 59 years" 4 "60 years or older", modify
label values agegroup agegroup
label var agegroup "Age Group"

label define sex 1 "Men" 2 "Women", modify
label values sex sex
label var sex "Gender"

gen edgroup=degree
replace edgroup=1 if edgroup==2
replace edgroup=3 if edgroup==4
label define edgroup 0 "<High school" 1 "High school" 2 "Associates degree" 3 "College grad" 4 "Graduate school", modify
label values edgroup edgroup
la var edgroup "Educational Status"

gen pa_deg=0 if padeg==0
replace pa_deg=1 if padeg==1
replace pa_deg=2 if padeg>1 & padeg<98 & padeg~=.
la var pa_deg "Father's Educational Status"

gen empstat=wrkstat
replace empstat=3 if wrkstat==4
la var empstat "Employment Status"

gen employed=1 if wrkstat==1 | wrkstat==2
replace employed=0 if wrkstat>2 & wrkstat<8 
label define employed 0 "Not working" 1 "Employed"
label values employed employed
la var employed "Employment Status"

gen married=marital
replace married=3 if married==4
replace married=. if married==98
label define married 1 "Married" 2 "Widowed" 3 "Divorced (or sep.)" 5 "Never married"
label values married married
la var married "Marital Status"

la var region "Region"
label define region 1 "New England" 2 "Middle Atlantic" 3 "East-North Central" 4 "West-North Central" 5 "South Atlantic" 6 "East-South Central" 7 "West-South Central" 8 "Mountain" 9 "Pacific", modify
label values region region

gen reg16_4=.
gen region_4=.
for X in num 0/9 99 \ Y in num 0 1 1 2 2 3 3 3 4 4 99: replace reg16_4=Y if reg16==X \ replace region_4=Y if region==X
label define region_4 0 "Foreign" 1 "Northeast" 2 "Midwest" 3 "South" 4 "West"
label values reg16_4 reg4
label values region_4 region_4
la var region_4 "Region"
la var reg16_4 "Region at Age 16"

gen urban=1 if srcbelt<=3
replace urban=0 if srcbelt>3 & srcbelt<.
replace urban=99 if srcbelt==.
label define urban 0 "Suburban and rural" 1 "Urban" 
label values urban urban
la var urban "Urban Status"

gen sexage=sex*10+agegroup
replace sexage=99 if sex==99 | age==99
label define sexage 11 "Men: 18-29 yrs" 12 "Men: 30-44 yrs" 13 "Men: 45-59 yrs" 14 "Men: 60+ yrs" 21 "Women: 18-29 yrs" 22 "Women: 30-44 yrs" 23 "Women: 45-59 yrs" 24 "Women: 60+ yrs" 99 "Missing age"
label values sexage sexage
la var sexage "Sex and Age"

gen agesex=agegroup*10+sex
replace agesex=99 if sex==99 | age==99
label define agesex 11 "Men: 18-29 yrs" 21 "Men: 30-44 yrs" 31 "Men: 45-59 yrs" 41 "Men: 60+ yrs" 12 "Women: 18-29 yrs" 22 "Women: 30-44 yrs" 32 "Women: 45-59 yrs" 42 "Women: 60+ yrs" 99 "Missing age"
label values agesex agesex
la var agesex "Age and Sex"



* Merge in state economic data

sort st year
merge m:1 st year using "..\State economic conditions\Unemployment.dta", keep(match master)
drop _merge
compress
save "..\Proprietary\Trust_GSS", replace
drop st ur
save "Trust_GSS", replace



