/*************************************************************************
* A do file to replicate the results of Snowberg, Wolfers and Zitzewitz	 *
* "Party Influence in Congress and the Economy" submitted for publication*
* in the Quarterly Journal of Political Science in 2007.		 *
*									 *
* This code produces a log file "SWZ07_replication.log with the results	 *
* for table 1, and the text dealing with the 1994 election		 *
*									 *
* In interpreting the results (and matching them to the table and text	 *
* it is useful to have the following key to the finance symbols:	 *
* ES or SP: S&P 500							 *
* NQ: Nasdaq 100							 *
* JY: Japanese Yen							 *
* EC: Euro								 *
* CD: Canadian Dollar							 *
* DM: German Mark							 *
* CLAZ06: Oil Futures (CLA stands for light crude, Z06 for the delivery	 *
*			date of December 06 - also CLAZ04 and CLAZ02)	 *
* Btwo: Two year treasury note						 *
* Bten: Ten year treasury note						 *
* pHse: Probability House will be controlled by Republicans		 *
* pSen: Probability Senate will be controlled by Republicans		 *
* GW: Probability of Bush winning the 2004 election			 *
* 									 *
* for more info on the files in this bundle see readme.txt included in   *
* the bundle.								 *
*************************************************************************/

drop _all
set mem 600m
set matsize 100
set more 1
capture log close

cap log using SWZ07_replication.log, replace

/*************************************************************************
* Table 1								 *
*************************************************************************/

/*************************************************************************
* Regressions for 2006							 *
*************************************************************************/
cap log off

foreach sym in logES logNQ logJY logEC logCD pCLAZ06 yBtwo yBten {
	cap use elec06, clear	
	/* prepare data for 30 - min analysis - flag means that you filled
	   in a blank with a ba from 10 min before, check that there isn't 
	   a trade 20 min before that properly belongs there ... */
	gen i = 1
	cap replace i = i[_n-1]+1 if `sym'[_n-1] == .
	gen flag = (flag`sym'[_n-1] == 1 & `sym' == .)
	cap replace `sym' = `sym'[_n-i] if `sym' == . & i <= 2
	cap replace `sym' = `sym'[_n-2] if flag & flag`sym'[_n-2] == 0 & `sym'[_n-2] ~= .
	drop flag
	gen iHse = 1
	cap replace iHse = iHse[_n-1]+1 if pHse[_n-1] == .
	gen flag = (flagHse[_n-1] == 1 & pHse == .)
	cap replace pHse = pHse[_n-iHse] if pHse == . & iHse <= 2
	cap replace pHse = pHse[_n-2] if flag & flagpse[_n-2] == 0 & pHse[_n-2] ~= .
	drop flag
	gen iSen = 1
	cap replace iSen = iSen[_n-1]+1 if pSen[_n-1] == .
	gen flag = (flagSen[_n-1] == 1 & pSen == .)
	cap replace pSen = pSen[_n-iSen] if pSen == . & iSen <= 2
	cap replace pSen = pSen[_n-2] if flag & flagSen[_n-2] == 0 & pSen[_n-2] ~= .
	drop flag
	cap drop i*
	cap sort datetime
	cap gen o = mod(_n,3)
	cap keep if o == 1
	drop o
	
	sort datetime
	cap gen i = 1
	cap replace i = i[_n-1]+1 if `sym'[_n-1] == . | pHse[_n-1] == . | pSen[_n-1] == .
	cap gen w = 1/i
	cap gen double delta`sym' = `sym' - `sym'[_n-i]
	cap gen double deltaSen = pSen - pSen[_n-i]
	cap gen double deltaHse = pHse - pHse[_n-i]
	
	cap log on
	reg delta`sym' deltaSen deltaHse [aweight = w], robust
	cap log off
	
}

cap log on
/*************************************************************************
* Regressions for 2002					 		 *
*************************************************************************/
cap log off

foreach sym in logES logNQ logJY logEC logCD pCLAZ02 yBtwo yBten {
	/* prepare data for 30 min analysis */
	cap use elec02, clear
	cap gen i = 1
	cap replace i = i[_n-1]+1 if `sym'[_n-1] == . | pSen[_n-1] == .
	gen flag = (flag`sym'[_n-1] == 1 & `sym' == .)
	cap replace `sym' = `sym'[_n-i] if `sym' == . & i <= 2
	cap replace `sym' = `sym'[_n-2] if flag & flag`sym'[_n-2] == 0 & `sym'[_n-2] ~= .
	gen iSen = 1
	cap replace iSen = iSen[_n-1]+1 if pSen[_n-1] == .
	cap replace pSen = pSen[_n-iSen] if pSen == . & iSen <= 2
	cap sort datetime
	cap gen o = mod(_n,3)
	cap keep if o == 1
	drop o i* flag
	
	sort datetime
	cap gen i = 1
	cap replace i = i[_n-1]+1 if `sym'[_n-1] == . | pSen[_n-1] == .
	cap gen w = 1/i
	cap gen double delta`sym' = `sym' - `sym'[_n-i]
	cap gen double deltaSen = pSen - pSen[_n-i]
	
	cap log on
	reg delta`sym' deltaSen [aweight = w], robust
	cap log off
}

cap log on
/*************************************************************************
* Regressions for 2004							 *
*************************************************************************/
cap log off

foreach sym in logES logNQ logJY logEC logCD pCLAZ04 yBtwo yBten {
	cap use elec04, clear

	/* 30 - min lags */
	cap gen i = 1
	cap replace i = i[_n-1]+1 if `sym'[_n-1] == .
	cap replace `sym' = `sym'[_n-i] if `sym' == . & i <= 2
	cap gen o = mod(_n,3)
	cap keep if o == 1
	drop o i
	cap sort date hour m10
	cap gen i = 1
	cap replace i = i[_n-1]+1 if `sym'[_n-1] == .
	/* w is the weight to get rid of heteroskedacticity */
	cap gen w = 1/i
	/* 30 - min diff */
	cap gen double delta`sym' = `sym' - `sym'[_n-i]
	cap gen double deltaGW = gwbush[_n] - gwbush[_n-i]
	cap log on
	reg delta`sym' deltaGW [aweight = w], robust
	cap log off
}

cap log on
/*************************************************************************
* 1994 Changes in contracts on election night btw 4-11 pm		 *
*************************************************************************/
cap log off

foreach sym in ES JY DM {
	use data94/point94, clear
	cap keep if strpos(contract, "`sym'") > 0
	cap log on
	display "Percent change in price over 4-11 pm 11/8/94 in `sym' " 200*(p11pm-p4pm)/(p11pm+p4pm) 
	cap log off
}
cap log off 
use data94/point94, clear
cap keep if contract == "CLAZ94"
cap log on
display "Change in price over 4-11 pm 11/8/94 in CLA " p11pm-p4pm 
cap log off


cap log on
/*************************************************************************
* 1994 Standard errors							 *
*************************************************************************/
use data94/se94, clear
*SE for ES is StDev of pctchgES
sum pctchgES
*SE for CLA is StDev of pricechgCLA
sum pricechgCLA
*SE for JY is StDev of pctchgES
sum pctchgJY
*SE for DM is StDev of pctchgES
sum pctchgDM

cap log close

					 
/*************************************************************************
* Figures								 *
*************************************************************************/

#delimit cr
graph set eps fontface Arial
*graph set mf fontface Arial

set scheme s1color
* Figure 1 - Paper version
use fig1.dta, clear
keep if datetime > (17112.6666 - 1/(24*6))
gen ESindex = pES/pES[1]*100
replace pHse = pHse*100
replace pSen = pSen*100
replace pHse = . if datetime > 17113.4
sort datetime
gen t = round((datetime - (17112 + 2/3))*(24*6))
for var pSen pHse: gen X1=X if t<=64 \ gen X2=X if t>=65

/* graph 1a */
#delimit;
twoway 
    (line pSen1 t, sort lcolor(cranberry) lpattern(longdash) clwidth(medthick))
    (line pSen2 t, sort lcolor(cranberry) lpattern(longdash) clwidth(medthick))
    (line pHse1 t, sort lcolor(navy) lpattern(shortdash) clwidth(medthick))
    (line pHse2 t, sort lcolor(navy) lpattern(shortdash) clwidth(medthick))
    (line ESindex t, yaxis(2) sort lcolor(green) clwidth(thick)), 
        ylabel(, angle(horizontal) labsize(small)) 
        xtitle("")
        xlabel( 12 "6 p.m." 48 "Midnight" 84 "6 a.m." 120 "Noon", labsize(medsmall))
        xmlabel(30 "Election Day" 84 "Post-election Day", labgap(5) labsize(medlarge))
        xmtick(0(6)138)
        ytitle("", axis(2))
        ylabel(99.4(.2)100.4, angle(horizontal) labsize(small) axis(2)) 
        title(Election 2006: Congressional Control and US Equities, size(medlarge) color(black)) 
        xline(125, lcolor(black) lwidth(thin) lpattern(longdash)) /*12:51pm*/
        yline(0, lcolor(black))
        text(75 128 "Rumsfeld Resigns", orientation(vertical))
        text(4 67 "Tradesports closed" "(1 hour)", size(vsmall))    
        legend(off)
    fysize(100)
    name(fig1a, replace)
;

* Graph 1b;
replace pHse1 = .;
#delimit;
twoway 
    (line pSen1 t, sort lcolor(cranberry) lpattern(longdash) clwidth(medthick))
    (line pHse1 t, sort lcolor(navy) lpattern(shortdash) clwidth(medthick))
    (line pVA t, sort lcolor(gs12) lpattern(shortdash) clwidth(vthin))
    (line pMO t, sort lcolor(gs6) lpattern(tight_dot) clwidth(vthin))
    (line ESindex t, yaxis(2) sort lcolor(green) clwidth(thick))
        if t <= 60 & t >= 30, 
    ylabel(0(20)100, angle(horizontal) labsize(small)) 
    xtitle("")
    xlabel( 30 "9 p.m." 36 "10 p.m." 42 "11 p.m." 48 "Midnight" 54 "1 a.m." 60 "2 a.m.", labsize(medsmall))
    xmtick(30(6)60)
    xmlabel(39 "Election Day" 54 "Post-election Day", labgap(5) labsize(medlarge))
    ytitle("", axis(2))
    ylabel(99.75(.05)100, angle(horizontal) labsize(small) axis(2) format(%9.2f)) 
    title("Close-up: 2006 Senate experiment 9 p.m.-2 a.m.", size(medlarge) color(black))
    legend(order(1 "Probability of a Republican Majority in the Senate (Tradesports)"
                     2 "Probability of a Republican Majority in the House (Tradesports)"
                    /* 3 "Probability of a Republican Victory in Virginia (Tradesports)"
                     4 "Probability of a Republican Victory in Missouri (Tradesports)" */
                     5 "S&P 500 Future (CME), right axis")
                    size(small) rows(5) span)
	text(11 52 "VA Senate Race", size(small))
	text(5  57 "MO Senate Race", size(small))
    fysize(120)
    name(fig1b, replace)
;

graph combine fig1a fig1b,
        rows(2) cols(1)             
        l1title("Tradesports: Probability Republican Majority", size(small)) 
        r1title("S&P 500: 4 p.m. on Election Day = 100", size(small))
        xsize(7) ysize(10)
	name(fig1, replace);
graph export fig1.eps, replace fontface(Arial);
graph export fig1.tif, replace;


* Graph 2: 2002;
#delimit cr
use elec02.dta, clear

gen ESindex = pES/pES[1]*100
label var ESindex "S&P 500 Future (Index - CME)"
replace pHse = pHse*100
replace pSen = pSen*100
sort datetime
gen t = round((datetime - (15649 + 2/3))*(24*6))

#delimit;
twoway
	(line pSen t, sort lcolor(cranberry) lpattern(longdash) clwidth(medthick))
	(line pHse t, sort lcolor(navy) lpattern(shortdash) clwidth(medthick))
      (line ESindex t, yaxis(2) sort lcolor(green) clwidth(thick))
	, 
	title("Election Night: 2002", size(medlarge) color(black) ring(0)) 
	xtitle("")
	ytitle("Tradesports: Probability of Republican Majority", size(small)) 
	ylabel( 20(20)100, angle(horizontal) labsize(small)) 
	ytitle("S&P 500: 4 p.m. on Election Day = 100", size(small) axis(2) ) 
      ylabel(99.7(.3)100.9, angle(horizontal) labsize(small) axis(2) format(%9.1f)) 
	xlabel(0 "4 p.m." 12 "6 p.m." 24 "8 p.m." 36 "10 p.m." 48 "Midnight", labsize(medsmall)) 
	xmtick(0(6)48)
      legend(order(1 "Probability of a Republican Majority in the Senate (Tradesports)"
                     2 "Probability of a Republican Majority in the House (Tradesports)"
                     3 "S&P 500 Future (CME), right axis")
			size(small)
			rows(3) span
		)
	xsize(10) ysize(7.5)
	name(fig2, replace)
;
graph export fig2.eps, replace fontface(Arial);
graph export fig2.tif, replace;

* Graph 3;

#delimit cr
use data94/elec94 if datetime>=12730+16/24 & datetime<=12731+1/24, clear
gen year=1994
gen t = round((datetime - (12730+16/24))*(24*6))
sort t
gen pES_index=pES/pES[1]*100

for X in num 1/6: gen str20 eventsX="" \ gen eX=. 
replace events1="TV anchors hint at pro-GOP exit polls" if t==21
replace events2="NPR reports GOP win >=6 Senate seats" if t==24
replace events3="CNN calls Senate for GOP" if t==25
replace events4="CBS calls House for GOP" if t==39
replace events5="CNN calls House for GOP" if t==40
replace events6="Early exit polls available to party operatives" if t==0
for X in num 1/6: replace eX=pES_index if eventsX~=""



#delimit ;
twoway
	(line pES_index t, sort lcolor(green) clwidth(thick))

	(scatter e1 t, mlabel(events1) msymbol(lgx) mcolor(black) mlabcolor(black) mlabposition(9))
	(scatter e2 t, mlabel(events2) msymbol(lgx) mcolor(black) mlabcolor(black) mlabposition(9))
	(scatter e3 t, mlabel(events3) msymbol(lgx) mcolor(black) mlabcolor(black) mlabposition(9))
	(scatter e4 t, mlabel(events4) msymbol(lgx) mcolor(black) mlabcolor(black) mlabposition(2))
	(scatter e5 t, mlabel(events5) msymbol(lgx) mcolor(black) mlabcolor(black) mlabposition(3))
	(scatter e6 t, mlabel(events6) msymbol(lgx) mcolor(black) mlabcolor(black) mlabposition(3))

	/*(line pES1998_index t)*/
	if t<=60
,
	title("Election Night: 1994 Republican Takeover")
	xtitle("")
	xlabel(0 "4 p.m." 12 "6 p.m." 24 "8 p.m." 36 "10 p.m." 48 "Midnight", labsize(medsmall)) 
	xmtick(0(6)54)
	ytitle("S&P 500: 4 p.m. on Election Day = 100", size(small) ) 
      ylabel(100(.1)100.5, angle(horizontal) labsize(small) format(%9.1f)) 
	legend(
		on 
		order(1 "S&P 500 Future (CME)")
		rows(1) span
		)
	note("Note: Timing of info reflects press reports. (Intraday prediction markets were unavailable to track electoral shocks.)" "Election eve: Prob. GOP House majority = 20%; Prob. GOP Senate majority = 70%" , span)
	xsize(10) ysize(7.5)
	name(fig3, replace);

graph export fig3.eps, replace fontface(Arial);
graph export fig3.tif, replace;


